;get/asm.
;
;	RECEIVE COMMAND
READ	LD	DE,DATA		;WHERE TO PUT THE TEXT (IF ANY.)
	LD	A,CMTXT
	CALL	COMND		;GET EITHER SOME TEXT OR A CONFIRM.
	JP	KERMT3		;DIDN'T GET ANYTHING.
	OR	A		;GET ANY CHARS?
	JR	Z,READ1		;NOPE, JUST A REGULAR SEND.
	LD	(ARGBLK+1),A	;STORE THE NUMBER OF CHARS.
	EX	DE,HL		;GET POINTER INTO HL.
	LD	(HL),'$'	;PUT IN A DOLLAR SIGN FOR PRINTING.
	CALL	INIT		;CLEAR THE LINE AND INITIALIZE THE BUFFERS.
	LD	DE,SCRFLN	;POSITION CURSOR
	CALL	PRTSTR
	LD	DE,DATA		;PRINT THE FILE NAME
	CALL	PRTSTR
	LD	A,'1'		;START WITH SINGLE CHARACTER CHECKSUM
	LD	(CURCHK),A	;SAVE THE TYPE
	XOR	A		;START A PACKET ZERO.
	LD	(ARGBLK),A
	LD	A,'R'		;RECEIVE INIT PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	KERMT3		;DIE!
	JP	READ12
;
READ1	CALL	INIT		;CLEAR THE LINE AND INITIALIZE THE BUFFERS.
READ12	XOR	A
	LD	(CZSEEN),A
	LD	HL,0
	LD	(NUMPKT),HL	;SET THE NUMBER OF PACKETS TO ZERO.
	LD	(NUMRTR),HL	;SET THE NUMBER OF RETRIES TO ZERO.
	LD	(PKTNUM),A	;SET THE PACKET NUMBER TO ZERO.
	LD	(NUMTRY),A	;SET THE NUMBER OF TRIES TO ZERO.
	LD	DE,SCRNRT	;POSITION CURSOR
	CALL	PRTSTR
	LD	HL,0
	CALL	NOUT		;WRITE THE NUMBER OF RETRIES.
	LD	A,'R'
	LD	(STATE),A	;SET THE STATE TO RECEIVE INITIATE.
;RECEIVE STATE TABLE SWITCHER.
READ2	LD	DE,SCRNP	;POSITION CURSOR
	CALL	PRTSTR
	LD	HL,(NUMPKT)
	CALL	NOUT		;WRITE THE CURRENT PACKET NUMBER.
	LD	A,(STATE)	;GET THE STATE.
	CP	'D'		;ARE WE IN THE DATA RECEIVE STATE?
	JP	NZ,READ3
	CALL	RDATA
	JP	READ2
READ3	CP	'F'		;ARE WE IN THE FILE RECEIVE STATE?
	JP	NZ,READ4
	CALL	RFILE		;CALL RECEIVE FILE.
	JP	READ2
READ4	CP	'R'		;ARE WE IN THE RECEIVE-INITIATE STATE?
	JP	NZ,READ5
	CALL	RINIT
	JP	READ2
READ5	CP	'C'		;ARE WE IN THE RECEIVE-COMPLETE STATE?
	JR	NZ,READ6
	LD	DE,INFMS3	;PUT IN "COMPLETE" MESSAGE.
	LD	A,(CZSEEN)
	OR	A		;.  .  .
	JR	Z,READ5A	;NO.
	XOR	A		;YES, CLEAR FLAG.
	LD	(CZSEEN),A
	LD	DE,INMS13	;ISSUE "INTERRUPTED" MESSAGE.
READ5A	CALL	FINMES		;PRINT COMPLETION MESSAGE IN RIGHT PLACE.
	JP	KERMIT
READ6	CP	'A'		;ARE WE IN THE RECEIVE-"ABORT" STATE?
	JR	NZ,READ7
	LD	DE,INFMS4	;PRINT MESSAGE.
	CALL	FINMES
	JP	KERMIT
READ7	LD	DE,INFMS4	;ANYTHING ELSE IS EQUIVALENT TO "ABORT".
	CALL	FINMES
	JP	KERMIT
;
;	INITIALIZE BUFFERS AND CLEAR LINE.
INIT	LD	DE,OUTLIN	;PUT BANNER ON SCREEN
	CALL	PRTSTR
	LD	DE,OUTLN2	;PUT STATISTICS HEADERS ON THE SCREEN
	CALL	PRTSTR		;ONLY FOR SCREEN-FORMATTING VERSIONS.
INIT1	LD	A,BUFSIZ	;BUFFER SIZE.
	LD	(CHRCNT),A	;NUMBER OF CHARS LEFT.
	LD	HL,BUFF		;ADDR FOR BEGINNING.
	LD	(BUFPNT),HL	;STORE ADDR FOR BEGINNING.
	RET
;
;	RECEIVE ROUTINES
;	RECEIVE INIT
RINIT	LD	A,(NUMTRY)	;GET THE NUMBER OF TRIES.
	CP	IMXTRY		;HAVE WE REACHED THE MAXIMUM NUMBER OF TRIES?
	JP	M,RINIT2
	LD	DE,ERMES4
	CALL	ERROR3		;MOVE CURSOR AND PRINT AN ERROR MESSAGE.
	JP	ABORT		;CHANGE THE STATE TO ABORT.
RINIT2	INC	A		;INCREMENT IT.
	LD	(NUMTRY),A	;SAVE THE UPDATED NUMBER OF TRIES.
;
	LD	A,'1'		;RESET CHECK TYPE TO '1'
	LD	(CURCHK),A	;AS CURRENT TYPE FOR INIT
	CALL	RPACK		;GET A PACKET.
	JP	NAK		;TRASHED PACKET: NAK, RETRY.
	CP	'S'		;IS IT A SEND INITIATE PACKET?
	JR	NZ,RINIT3	;IF NOT SEE IF ITS AN ERROR.
	LD	A,(NUMTRY)	;GET THE NUMBER OF TRIES.
	LD	(OLDTRY),A	;SAVE IT.
	XOR	A
	LD	(NUMTRY),A	;RESET THE NUMBER OF TRIES.
	LD	A,(ARGBLK)	;RETURNED PACKET NUMBER.  (SYNCHRONIZE THEM.)
	INC	A		;INCREMENT IT.
	AND	3FH		;TURN OFF THE TWO HIGH ORDER BITS.
	LD	(PKTNUM),A	;SAVE MODULO 64 OF THE NUMBER.
	LD	HL,(NUMPKT)
	INC	HL		;INCREMENT THE NUMBER OF PACKETS.
	LD	(NUMPKT),HL
	LD	A,(ARGBLK+1)	;GET THE NUMBER OF ARGUMENTS RECEIVED.
	LD	HL,DATA		;GET A POINTER TO THE DATA.
;******              ***********************************
	CALL	SPAR		;GET THE DATA INTO THE PROPER VARIABLES.
;****** ^^^^^^^^^^^^ ***********************************
	LD	HL,DATA		;GET A POINTER TO OUR DATA BLOCK.
;******              ***********************************
	CALL	RPAR		;SET UP THE RECEIVE PARAMETERS.
;****** ^^^^^^^^^^^^ ***********************************
	LD	(ARGBLK+1),A	;STORE THE RETURNED NUMBER OF ARGUMENTS.
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	ABORT		;FAILED, ABORT.
	LD	A,(INICHK)
	LD	(CURCHK),A	;FOR ALL FUTURE PACKETS
	LD	A,'F'		;SET THE STATE TO FILE SEND.
	LD	(STATE),A
	RET
RINIT3	CP	'E'		;IS IT AN ERROR PACKET.
	JR	NZ,NAK0		;IF NOT NAK WHATEVER IT IS.
	CALL	ERROR
	JR	ABORT
;THESE ARE SOME UTILITY ROUTINES.
;	ABORT
ABORT	LD	A,'A'		;OTHERWISE ABORT.
	LD	(STATE),A
	RET
;	NAK
NAK0	CALL	UPDRTR		;UPDATE NUMBER OF RETRIES.
NAK	LD	A,(PKTNUM)	;GET THE PACKET NUMBER WE'RE WAITING FOR.
	LD	(ARGBLK),A
	XOR	A		;NO DATA.
	LD	(ARGBLK+1),A
	LD	A,'N'		;NAK THAT PACKET.
	CALL	SPACK
	JP	ABORT		;GIVE UP.
	RET			;GO AROUND AGAIN.
UPDRTR	LD	DE,SCRNRT	;POSITION CURSOR
	CALL	PRTSTR
	LD	HL,(NUMRTR)
	INC	HL		;INCREMENT THE NUMBER OF RETRIES
	LD	(NUMRTR),HL
	CALL	NOUT		;WRITE THE NUMBER OF RETRIES.
	RET
;
;
;*******************************************************
;**                      RPAR                         **
;*******************************************************
;THIS ROUTINE SETS UP THE DATA FOR INIT PACKET (EITHER
;	the SEND_INIT OR ACK PACKET).
;
RPAR	LD	A,(RPSIZ)	;GET THE RECEIVE PACKET SIZE.
	ADD	A,' '		;convert to ' ' offset
	LD	(HL),A		;PUT IT IN THE PACKET.
	INC	HL		;POINT TO THE NEXT CHAR.
	LD	A,(RTIME)	;GET THE RECEIVE PACKET TIME OUT.
	ADD	A,' '		;ADD A SPACE.
	LD	(HL),A		;PUT IT IN THE PACKET.
	INC	HL
	LD	A,(RPAD)	;GET THE NUMBER OF PADDING CHARS.
	ADD	A,' '
	LD	(HL),A
	INC	HL
	LD	A,(RPADCH)	;GET THE PADDING CHAR.
	XOR	40H		;change to @AZetc..
;;	AND	7FH
	LD	(HL),A
	INC	HL
	LD	A,(REOL)	;GET THE EOL CHAR.
	ADD	A,' '
	LD	(HL),A
	INC	HL
	LD	A,(RQUOTE)	;GET THE QUOTE CHAR.
	LD	(HL),A
	INC	HL
;Mod by nick. Add bit 7 quoting if necessary.
	LD	A,(RQUOTE8)	;' ' if none, else '&'.
	LD	(HL),A
;
	INC	HL		;ADVANCE TO NEXT
	LD	A,(INICHK)
	LD	(HL),A		;STORE IT
	INC	HL		;ADVANCE POINTER
;Mod by Nick.
	LD	A,(RQUOTER)	;repeat quoting '~'
	LD	(HL),A		;not implemented yet.
	INC	HL
;
	LD	A,9		;length, data field.
;Load A with number of items in data segment.
	RET
;
;
;*******************************************************
;**                      SPAR                         **
;*******************************************************
;
;THIS ROUTINE READS IN ALL THE SEND_INIT PACKET INFORMATION.
;
SPAR	LD	(TEMP4),A	;SAVE THE count of data
	CP	2		;<1 piece of data?
	RET	M		;if packet empty
;If no data was given in the ACK packet for a send-init
;or a send-init itself from the other side then we are
;finished here.
;
	LD	A,(HL)		;GET THE MAX PACKET SIZE.
	SUB	20H		;SUBTRACT A SPACE.
	LD	(SPSIZ),A	;SAVE IT.
	LD	A,(TEMP4)
	CP	3		;<2 pieces of data?
	RET	M		;ends before timeout
	INC	HL
	LD	A,(HL)
	SUB	20H		;get timeout {secs}
	LD	(STIME),A
	LD	A,(TEMP4)
	CP	4		;<3 pieces of data?
	RET	M
	INC	HL		;point to next field.
	LD	A,(HL)		;get number of pad chars
	SUB	20H
	LD	(SPAD),A
	LD	A,(TEMP4)
	CP	5		;<4 pieces of data?
	RET	M		;ends before pad char
	INC	HL
	LD	A,(HL)		;GET THE PADDING CHAR.
;;	ADD	A,100O		;RE-CONTROLIFY IT.
;Typical bug above.... add 40h instead of XOR.
	XOR	40H
;;	AND	7FH		;7 should never be masked
	LD	(SPADCH),A
	LD	A,(TEMP4)
	CP	6		;<5 pieces of data?
	RET	M		;ends before EOL char
	INC	HL
	LD	A,(HL)		;GET THE EOL CHAR.
	SUB	20H
	LD	(SEOL),A
	LD	A,(TEMP4)
	CP	7		;<6 pieces of data
	RET	M		;ends before RQUOTE
	INC	HL
	LD	A,(HL)		;get quote it will use
	LD	(SQUOTE),A	;sending to me.
	LD	A,(TEMP4)
	CP	8		;<7 pieces of data?
	RET	M		;ends before QUOTE8.
	INC	HL
	LD	A,(HL)		;get 8'th bit quote char
;Kermit 4C (SysV ... basset) uses a 'Y' or 'N' in this
;field. if so, what should be done???   HELP!!!!!
;
	LD	(SQUOTE8),A
;
;;PERHAPS WE SHOULD VALIDATE THAT THE 8-BIT QUOTE CHARACTER IS ONLY
;;'Y' OR 'N', HOWEVER, IF THE OTHER END REALLY DESIRES 8-BIT QUOTING,
;;IT SHOULD GIVE AN ERROR DUE TO OUR STATING THAT WE DO NOT DO 8-BIT
;;QUOTING AT ALL.
	LD	A,(TEMP4)
	CP	9		;<8 pieces of data?
	RET	M		;ends before check type
	INC	HL
	LD	A,(HL)		;get check type 1/2/3
	LD	B,A		;if unlike ours use '1'
	LD	A,(CHKTYP)	;get our desired type
	CP	B		;compare
	JR	Z,SPAR01	;if same, use it
	LD	A,'1'		;else use 1 char cksum
SPAR01	LD	(INICHK),A	;save.
;
;Mod by Nick. Provision for repeat count prefix.
	LD	A,(TEMP4)
	CP	10		;<9 pieces of data?
	RET	M		;ends before repeat quote
	INC	HL
	LD	A,(HL)
	LD	B,A
;Don't know what to compare and/or set against here..
;*** fudge fudge fudge fudge fudge the code ***
	LD	A,' '		;dont do quoter yet.
	LD	(SQUOTER),A
	RET
;
;********************************************************
;********************************************************
;
;	RECEIVE FILE
RFILE	LD	A,(NUMTRY)	;GET THE NUMBER OF TRIES.
	CP	MAXTRY		;REACHED MAX TRIES?
	JP	M,RFILE1
	LD	DE,ERMES5
	CALL	ERROR3		;MOVE CURSOR AND PRINT AN ERROR MESSAGE.
	JP	ABORT		;CHANGE THE STATE TO ABORT.
RFILE1	INC	A		;INCREMENT IT.
	LD	(NUMTRY),A	;SAVE THE UPDATED NUMBER OF TRIES.
	CALL	RPACK		;GET A PACKET.
	JP	NAK		;TRASHED PACKET: NAK, RETRY.
	CP	'S'		;IS IT A SEND INITIATE PACKET?
	JP	NZ,RFILE2	;NO, TRY NEXT TYPE.
	LD	A,(OLDTRY)	;GET THE NUMBER OF TRIES.
	CP	IMXTRY		;HAVE WE REACHED THE MAXIMUM NUMBER OF TRIES?
	JP	M,RFIL12	;IF NOT PROCEED.
	LD	DE,ERMES4
	CALL	ERROR3		;MOVE CURSOR AND PRINT AN ERROR MESSAGE.
	JP	ABORT		;CHANGE THE STATE TO ABORT.
RFIL12	INC	A		;INCREMENT IT.
	LD	(OLDTRY),A	;SAVE THE UPDATED NUMBER OF TRIES.
	LD	A,(PKTNUM)	;GET THE PRESENT PACKET NUMBER.
	DEC	A		;DECREMENT.
	LD	B,A
	LD	A,(ARGBLK)	;GET THE PACKET'S NUMBER
	CP	B		;IS THE PACKET'S NUMBER ONE LESS THAN NOW?
	JP	NZ,NAK0		;NO, NAK AND TRY AGAIN.
	CALL	UPDRTR		;UPDATE THE RETRY COUNT.
	XOR	A
	LD	(NUMTRY),A	;RESET THE NUMBER OF TRIES.
	LD	HL,DATA		;GET A POINTER TO OUR DATA BLOCK.
;******              ***********************************
	CALL	RPAR		;create packet for our defaults
;****** ^^^^^^^^^^^^ ***********************************
	LD	(ARGBLK+1),A	;SAVE THE NUMBER OF ARGUMENTS.
	LD	A,'Y'		;Ack the send-init packet
	CALL	SPACK
	JP	ABORT		;FAILED, ABORT.
	RET
RFILE2	CP	'Z'		;IS IT AN EOF PACKET?
	JP	NZ,RFILE3	;NO, TRY NEXT TYPE.
	LD	A,(OLDTRY)	;GET THE NUMBER OF TRIES.
	CP	MAXTRY		;HAVE WE REACHED THE MAXIMUM NUMBER OF TRIES?
	JP	M,RFIL21	;IF NOT PROCEED.
	LD	DE,ERMES6
	CALL	ERROR3		;MOVE CURSOR AND PRINT AN ERROR MESSAGE.
	JP	ABORT		;CHANGE THE STATE TO ABORT.
RFIL21	INC	A		;INCREMENT IT.
	LD	(OLDTRY),A	;SAVE THE UPDATED NUMBER OF TRIES.
	LD	A,(PKTNUM)	;GET THE PRESENT PACKET NUMBER.
	DEC	A		;DECREMENT.
	LD	B,A
	LD	A,(ARGBLK)	;GET THE PACKET'S NUMBER
	CP	B		;IS THE PACKET'S NUMBER ONE LESS THAN NOW?
	JP	NZ,NAK0		;NO, NAK IT AND TRY AGAIN.
	CALL	UPDRTR		;UPDATE THE NUMBER OF RETRIES.
	XOR	A
	LD	(NUMTRY),A	;RESET NUMBER OF TRIES.
	LD	(ARGBLK+1),A	;NO DATA.  (THE PACKET NUMBER IS IN ARGBLK.)
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	ABORT		;FAILED, ABORT.
	RET
RFILE3	CP	'F'		;START OF FILE?
	JP	NZ,RFILE4
	LD	A,(PKTNUM)	;GET THE PACKET NUMBER.
	LD	B,A
	LD	A,(ARGBLK)
	CP	B		;IS IT THE RIGHT PACKET NUMBER?
	JP	NZ,NAK0		;NO, NAK IT AND TRY AGAIN.
	INC	A		;INCREMENT THE PACKET NUMBER.
	AND	3FH		;TURN OFF THE TWO HIGH ORDER BITS.
	LD	(PKTNUM),A	;SAVE MODULO 64 OF THE NUMBER.
	LD	HL,(NUMPKT)
	INC	HL		;INCREMENT THE NUMBER OF PACKETS.
	LD	(NUMPKT),HL
	CALL	GOFIL		;GET A FILE TO WRITE TO.
	JP	ABORT
	CALL	INIT1		;INITIALIZE ALL THE BUFFERS.
	LD	A,(NUMTRY)	;GET THE NUMBER OF TRIES.
	LD	(OLDTRY),A	;SAVE IT.
	XOR	A
	LD	(NUMTRY),A	;RESET THE NUMBER OF TRIES.
	LD	(ARGBLK+1),A	;NO DATA.  (THE PACKET NUMBER IS IN ARGBLK.)
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	ABORT
	LD	A,'D'		;SET THE STATE TO DATA RECEIVE.
	LD	(STATE),A
	LD	(CZSEEN),A
	CP	'Z'		;AND DIDN'T WANT ANY MORE
	RET	Z		;IF THAT WAS THE REQUEST, KEEP TELLING OTHER END
	XOR	A		;OTHERWISE, CLEAR FLAG (CONTROL-X IS ONLY FOR ONE FILE)
	LD	(CZSEEN),A
	RET
RFILE4	CP	'B'		;END OF TRANSMISSION.
	JP	NZ,RFILE5
	LD	A,(PKTNUM)	;GET THE PACKET NUMBER.
	LD	B,A
	LD	A,(ARGBLK)
	CP	B		;IS IT THE RIGHT PACKET NUMBER?
	JP	NZ,NAK0		;NO, NAK IT AND TRY AGAIN.
	XOR	A		;NO DATA.  (PACKET NUMBER ALREADY IN ARGBLK).
	LD	(ARGBLK+1),A
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	ABORT
	LD	A,'C'		;SET THE STATE TO COMPLETE.
	LD	(STATE),A
	RET
RFILE5	CP	'E'		;IS IT AN ERROR PACKET.
	JP	NZ,ABORT
	CALL	ERROR
	JP	ABORT
;	RECEIVE DATA
RDATA	LD	A,(NUMTRY)	;GET THE NUMBER OF TRIES.
	CP	MAXTRY		;HAVE WE REACHED THE MAXIMUM NUMBER OF TRIES?
	JP	M,RDATA1
	LD	DE,ERMS10
	CALL	ERROR3		;DISPLAY ERROR MESSAGE.
	JP	ABORT		;CHANGE THE STATE TO ABORT.
RDATA1	INC	A		;INCREMENT IT.
	LD	(NUMTRY),A	;SAVE THE UPDATED NUMBER OF TRIES.
	CALL	RPACK		;GET A PACKET.
	JP	NAK		;TRASHED PACKET: NAK, RETRY.
	CP	'D'		;IS IT A DATA PACKET?
	JP	NZ,RDATA2	;NO, TRY NEXT TYPE.
RDAT11	LD	A,(PKTNUM)	;GET THE PRESENT PACKET NUMBER.
	LD	B,A
	LD	A,(ARGBLK)	;GET THE PACKET'S NUMBER.
	CP	B		;IS THE PACKET'S NUMBER CORRECT?
	JP	Z,RDAT14
	LD	A,(OLDTRY)	;GET THE NUMBER OF TRIES.
	CP	MAXTRY		;HAVE WE REACHED THE MAXIMUM NUMBER OF TRIES?
	JP	M,RDAT12	;IF NOT PROCEED.
	LD	DE,ERMS10
	CALL	ERROR3		;DISPLAY ERR MSG.
	JP	ABORT		;CHANGE THE STATE TO ABORT.
RDAT12	INC	A		;INCREMENT IT.
	LD	(OLDTRY),A	;SAVE THE UPDATED NUMBER OF TRIES.
	LD	A,(PKTNUM)	;GET THE PRESENT PACKET NUMBER.
	DEC	A		;DECREMENT.
	LD	B,A
	LD	A,(ARGBLK)	;GET THE PACKET'S NUMBER
	CP	B		;IS THE PACKET'S NUMBER ONE LESS THAN NOW?
	JP	NZ,NAK0		;NO, NAK IT AND TRY AGAIN.
	CALL	UPDRTR		;UPDATE THE NUMBER OF RETRIES.
	XOR	A
	LD	(NUMTRY),A	;RESET NUMBER OF TRIES.
	LD	(ARGBLK+1),A	;NO DATA.  (THE PACKET NUMBER IS IN ARGBLK).
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	ABORT		;FAILED, ABORT.
	RET
RDAT14	INC	A		;INCREMENT THE PACKET NUMBER.
	AND	3FH		;TURN OFF THE TWO HIGH ORDER BITS.
	LD	(PKTNUM),A	;SAVE MODULO 64 OF THE NUMBER.
	LD	HL,(NUMPKT)
	INC	HL		;INCREMENT THE NUMBER OF PACKETS.
	LD	(NUMPKT),HL
	LD	A,(NUMTRY)	;GET THE NUMBER OF TRIES.
	LD	(OLDTRY),A	;SAVE IT.
	LD	A,(ARGBLK+1)	;GET THE LENGTH OF THE DATA.
	CALL	PTCHR
	JP	ABORT		;UNABLE TO WRITE OUT CHARS;ABORT.
	XOR	A
	LD	(NUMTRY),A	;RESET THE NUMBER OF TRIES.
	LD	(ARGBLK+1),A	;NO DATA.  (PACKET NUMBER STILL IN ARGBLK).
	LD	C,A		;ASSUME NO DATA
	LD	(CZSEEN),A
	OR	A		;.  .  .
	JP	Z,RDAT15	;ZERO IF NOT TYPED
	LD	C,A		;GET THE TYPE OF CHARACTER TYPED
	LD	A,1		;ONE DATA CHARACTER
	LD	(ARGBLK+1),A	;SAVE THE COUNT
	LD	A,C		;GET THE POSSIBLE DATA CHARACTER
	LD	(DATA),A	;STORE IN DATA AREA
RDAT15	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	ABORT
	RET
RDATA2	CP	'F'		;START OF FILE?
	JP	NZ,RDATA3	;NO, TRY NEXT TYPE.
	LD	A,(OLDTRY)	;GET THE NUMBER OF TRIES.
	CP	MAXTRY		;HAVE WE REACHED THE MAXIMUM NUMBER OF TRIES?
	JP	M,RDAT21	;IF NOT PROCEED.
	LD	DE,ERMES5
	CALL	ERROR3		;DISPLAY ERR MSG.
	JP	ABORT		;CHANGE THE STATE TO ABORT.
RDAT21	INC	A		;INCREMENT IT.
	LD	(OLDTRY),A	;SAVE THE UPDATED NUMBER OF TRIES.
	LD	A,(PKTNUM)	;GET THE PRESENT PACKET NUMBER.
	DEC	A		;DECREMENT.
	LD	B,A
	LD	A,(ARGBLK)	;GET THE PACKET'S NUMBER
	CP	B		;IS THE PACKET'S NUMBER ONE LESS THAN NOW?
	JP	NZ,NAK0		;NO, NAK IT AND TRY AGAIN.
	CALL	UPDRTR		;UPDATE THE NUMBER OF RETRIES.
	XOR	A
	LD	(NUMTRY),A	;RESET NUMBER OF TRIES.
	LD	(ARGBLK+1),A	;NO DATA.  (THE PACKET NUMBER IS IN ARGBLK).
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	ABORT		;FAILED, ABORT.
	RET
RDATA3	CP	'Z'		;IS IT A EOF PACKET?
	JP	NZ,RDATA4	;TRY AND SEE IF ITS AN ERROR.
	LD	A,(PKTNUM)	;GET THE PRESENT PACKET NUMBER.
	LD	B,A
	LD	A,(ARGBLK)	;GET THE PACKET'S NUMBER
	CP	B		;IS THE PACKET'S NUMBER CORRECT?
	JP	NZ,NAK0		;NO, NAK IT AND TRY AGAIN.
	INC	A		;INCREMENT THE PACKET NUMBER.
	AND	3FH		;TURN OFF THE TWO HIGH ORDER BITS.
	LD	(PKTNUM),A	;SAVE MODULO 64 OF THE NUMBER.
	LD	HL,(NUMPKT)
	INC	HL		;INCREMENT THE NUMBER OF PACKETS.
	LD	(NUMPKT),HL
	LD	A,(ARGBLK+1)	;GET THE DATA LENGTH	
	CP	1		;HAVE ONE ITEM?
	JP	NZ,RDAT33	;IF NOT, IGNORE DATA
	LD	A,(DATA)	;YES, GET THE CHARACTER
	CP	'D'		;IS IT A 'D' FOR DISCARD?
	JP	Z,RDAT36	;IF SO, PUNT FILE
RDAT33	LD	HL,(BUFPNT)	;GET THE DMA POINTER.
	LD	A,(CHRCNT)	;GET THE NUMBER OF CHARS LEFT IN THE DMA.
RDAT34	DEC	A		;LOWER THE COUNT.
	OR	A
	JP	M,RDAT35	;IF FULL THEN STOP.
	LD	(HL),'Z'-100O	;PUT IN A ^Z FOR EOF.
	INC	HL		;POINT TO THE NEXT SPACE.
	JP	RDAT34
RDAT35	LD	DE,FCB
	CALL	@CLOSE		;CLOSE THE FILE
	XOR	A		;SINCE WE KEPT THE FILE,
	LD	(CZSEEN),A
RDAT36	LD	A,(NUMTRY)	;GET THE NUMBER OF TRIES.
	LD	(OLDTRY),A	;SAVE IT.
	XOR	A
	LD	(NUMTRY),A	;RESET THE NUMBER OF TRIES.
	LD	(ARGBLK+1),A	;NO DATA.  (THE PACKET NUMBER IS IN ARGBLK).
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	ABORT
	LD	A,'F'
	LD	(STATE),A
	RET
RDATA4	CP	'E'		;IS IT AN ERROR PACKET.
	JP	NZ,ABORT
	CALL	ERROR
	JP	ABORT
;
                                                                                                                  