/*
        Serial handler. Spawn line monitor if defined.
        Monitor serial line and spawn data and fax handlers
        Spawn 'Linetidy' after a data call completes
*/
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>
#include <database.h>

char _prog_name[] = "Pbox Serial Handler";
char _version[] = "v1.20";
long ipch = -1;                 /* input channel  */
long opch = -1;                 /* output channel */
long monID = -1;                /* monitor job ID */
long logID = -1;                /* log channel */
char modem[82];
char failcall[82];
char bbscall[82];
char faxcall[82];
char faxprg[82];
char faxport[4];
char faxbaud[10];
char bbsprg[82];
char linemon[82];
char linelog[42];
char mdm1[82];
char mdm2[82];
char mdm3[82];
char mdm4[82];
char mdma[82];
char mdmh[82];
char mdmd[82];
char mdmo[82];
char days[30];
char mnth[50];
int  dcdtime = 0;
char lf[] = { '\r', '\n' };
int  line = 0;
int  baud = 0;
int  loglevel;
int  answer_after = 0;
int  rings = 0;

QD_TEXT  (82) fname = {0};
QD_TEXT  (42) cmdln = {0};
QD_TEXTI (cmd,"0");     /* cmd for most programs is our line number */

typedef struct _llist
{
    struct _llist *next;
    char txt[82];
}llist;

int  COM_DCD(int chan, short tmo);
int  COM_BAUD(int chan, int baud);
long exec(struct QD_text *filename, struct QD_text *cmdline,
          short wait, short chans, long chan1, long chan2, long chan3);

/*--------------------------------------------------------------------------*/
int     leap_year(int year)
{
        if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0)
           return(1);
        return(0);
}
/*--------------------------------------------------------------------------*/
char *getmonth(long time)
{
long spd,spl,spy,secs,year,siy,f;
int mlen[] = {31,28,31,30,31,30,31,31,30,31,30,31};

  spd = 60*60*24;               /* seconds in a day */
  spy = spd * 365;              /* seconds in a year */
  spl = spd + spy;              /* seconds in a leap year */
  secs = time;                  /* seconds left */
  year = 1961;                  /* clock starts at 1961 */

  while(1)
  {
    siy = spy;                  /* seconds in this year */
    if (leap_year(year))
      siy += spd;               /* adjust for leap year */
    if (secs < siy)
       break;                   /* inside this year */
    secs -= siy;
    year++;
  }
  if (leap_year(year))
     mlen[1]++;                 /* adjust Feb length if in a leap year */
  for(f=0; f<12; f++)
  {
     secs -= (spd * mlen[f]);
     if (secs < 0)
     {                          /* we are inside this month */
       f *= 3;                  /* offset inside string */
       return(mnth+f);
     }
  }
  return(mnth);                 /* should never get here */
}
/*--------------------------------------------------------------------------*/
char *getday(long time)
{
long spd,dy;

  spd = 60*60*24;               /* seconds in a day */
  dy  = time/spd;               /* whole days */
  dy++;                         /* day we are in */
  dy %= 7;                      /* day of week (0 = saturday) */
  dy *= 3;                      /* offset into string */
  return (days+dy);
}
/*--------------------------------------------------------------------------*/
void sysvar(char *varname, char *ans, int sz, int l)
{
char msg[82];
char *a;
short rlen;

  sprintf(msg,"sysvar %s",varname);
  a = msg;
  if(l)
  {
    a += strlen(msg)-1;
    *a += l;              /* fudge line number onto request */
  }
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen < sz) sz = rlen;
    strncpy(ans,a,sz);
    ans[sz] = '\0';
    free(a);
  }
}
/*--------------------------------------------------------------------------*/
void log(int level, char *value)
{
char msg[202];
char *a;
short rlen;

 if(loglevel & level)
 {
  sprintf(msg,"log %d %s",line,value);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a != NULL) free(a);
 }
}
/*--------------------------------------------------------------------------*/
void setline(char *value)
{
char msg[82];
char *a;
short rlen;

  sprintf(msg,"setline %d %s",line,value);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a != NULL) free(a);
}
/*--------------------------------------------------------------------------*/
void sendstr(char *msg)
{
char *a;
int e;
char c;

   while(1)                             /* empty the serial queue */
   {
     e = io_fbyte(ipch, 10, &c);
     if (e < 0)  break;
   }
   a = msg;
   while(1)
   {
     if (*a == '\0')    /* end of line */
     {
       io_sbyte(opch, 10, '\r');
       return();
     }
     if (*a == '~')             /* tilde means pause half a second */
       mt_susjb(-1,25,NULL);
     else
       io_sbyte(opch, 10, *a);  /* anything else gets sent to the modem */
     a++;
   }
}
/*--------------------------------------------------------------------------*/
int get_modem(char r[], int max, int tmo)
{
char *a;
char c;
int n = 0;
int e;

  a = &r[0];

  while(1)
  {
    e = io_fbyte(ipch, tmo, &c);

    if(e < 0)
    {
      *a = '\0';
      if(n == 0)
        n = e;                  /* return error if no bytes fetched, */
      break;                    /* return nr of bytes if some data */
    }
    if (c != '\n')
    {
      if (c == '\r')
      {
        *a = '\0';
        break;
      }
      if (++n == max)
      {
        *a = '\0';
        break;
      }
      *a++ = c;
    }
  }
  return(n);
}
/*--------------------------------------------------------------------------*/
void    summary(char *txt, int type)
{
/*      Type 1, date/msg/nl
        Type 2, date/msg/tab
        Type 3, msg/nl (append to a type 2 msg)
*/
char buff[122];
char when[42];
long time;
char day[4];
char month[4];
char date[30];
char *a;

   time = mt_rclck();
   cn_date(date,time);
   strncpy(day,getday(time),3);
   day[3] = '\0';
   strncpy(month,getmonth(time),3);
   month[3] = '\0';
   a  = &date[0];
   a += 13;
   *a = '\0';
   a -= 8;
   *a = '\0';
   sprintf(when,"%s %s %s %s ",day,month,date+11,date+14);

        if (logID > 0)
        {
          if (type == 1)
          sprintf(buff,"%s %s\n",when,txt);
          else if (type == 2)
          sprintf(buff,"%s %s",when,txt);
          else if (type == 3)
          sprintf(buff," %s\n",txt);
          io_sstrg(logID,0,buff,strlen(buff));
        }
}
/*--------------------------------------------------------------------------*/
int get_ok(void)
{
char msg[122];
char ans[82];
char count = 0;
int ferr;

   while(1)
   {
     ferr = get_modem(ans,80, 200);     /* allow 4 seconds for 80 char response */
     if(ferr >= 0)
     {
       if (strnicmp(ans,"OK",2) == 0 )
         return 0;
       if(ans[0] != '\0')
       {
         sprintf(msg,"Modem reports \"%s\"",ans);
         log(64,msg);
       }
     }
     if(count++ == 8)                   /* fetch at most 8 strings. */
     {
        log(64,"Failed to get OK");
        return(-1);
     }
     mt_susjb(-1,30,NULL);
   }
}
/*--------------------------------------------------------------------------*/
void answer_modem(void)
{
char msg[82];
char ans[122];
long fail;
char *a;
int baudrate;
char badlines = 0;
char count = 0;
int ferr;
short rlen;

 log(8,"Answering modem");
 strcpy(msg,"sysvar s_answer");
 a=Request ("pbox", msg, strlen(msg), &rlen);
 if (a != NULL)
 {
   *(a+rlen)= '\0';
   sprintf(ans,"status %s",a);
   free(a);
   setline(ans);
 }
 sendstr(mdma);

 while(1)
 {
   ferr = get_modem(msg,80,3250);      /* allow just over 1 min for carrier */
   if(ferr < 0)
   {
     sprintf(ans,"Modem error %d while waiting for carrier",ferr);
     log(64,ans);
     summary(ans,1);
     sprintf(msg,"offline %d",line);
     a=Request ("pbox", msg, strlen(msg), &rlen);
     if (a != NULL) free(a);
     a=Request ("pbox", "counter 6", 9, &rlen);
     if (a != NULL) free(a);
     return();
   }

   if (strnicmp(msg,faxcall,strlen(faxcall)) == 0 )
   {
      if (faxprg[0] == '-')
        fail = -1;
      else
      {
        log(8,"Invoking Fax handler");
        summary("Fax ",2);
        strcpy(msg,"sysvar s_fax");
        a=Request ("pbox", msg, strlen(msg), &rlen);
        if (a != NULL)
        {
          *(a+rlen)= '\0';
          sprintf(ans,"status %s",a);
          free(a);
          setline(ans);
        }
        if (dcdtime)            /* switch off carrier-detect for faxes */
           (void)COM_DCD(opch,0);
        strcpy((char *)&fname.chrs,faxprg);
        fname.len = strlen(faxprg);
        if (faxport[0] == 'Y')  /* pass serial chan to fax prg? */
        {
              baud = atoi(faxbaud);
              if (baud != 0)
                  COM_BAUD(opch,baud);
              fail =  exec ((struct QD_text *)&fname.len,
                          (struct QD_text *)&cmd.len,
                           -1,2,ipch,opch,0 );
        }
        else
        {
            if(ipch > 0)
              (void)io_close(ipch);     /* fax program opens the port itself */
            ipch = 0;
            fail =  exec ((struct QD_text *)&fname.len,
                          (struct QD_text *)&cmd.len,
                           -1,0,0,0,0 );
        }
      }

      if (fail < 0)
      {
        log(8,"Fax call failed");
        summary("FAILED",3);
      }
      else
      {
        log(8,"Fax call complete");
        summary("received ok",3);
      }
      sprintf(msg,"offline %d",line);
      a=Request ("pbox", msg, strlen(msg), &rlen);
      if (a != NULL) free(a);
      return();
   }

   else if (strnicmp(msg,bbscall,strlen(bbscall)) == 0 )
   {
      if (bbsprg[0] == '-')
        fail = -1;
      else
      {
        log(64,msg);  /* connect 14400/ARQ/etc */
        log(8,"Invoking Data handler");
        baudrate = atoi((char *)&msg[ 1+ strlen(bbscall) ]);
        sprintf(ans,"Baud %d",baudrate);
        setline(ans);
        log(8,ans);
        sprintf(ans,"Data %s ",(char *)&msg[1+strlen(bbscall)]);
        summary(ans,2);
        strcpy(msg,"sysvar s_data");
        a=Request ("pbox", msg, strlen(msg), &rlen);
        if (a != NULL)
        {
          *(a+rlen)= '\0';
          sprintf(ans,"status %s",a);
          free(a);
          setline(ans);
        }
        setline("user 0");
        sprintf(ans,"moni %d",ipch);
        setline(ans);
        strcpy((char *)&fname.chrs,bbsprg);
        fname.len = strlen(bbsprg);

        fail =  exec ((struct QD_text *)&fname.len,
                      (struct QD_text *)&cmd.len,
                       -1,2,ipch,opch,0 );

        setline("moni 0");
      }
      if (fail < 0)
      {
        sprintf(msg,"Data call failed %d",fail);
        log(8,msg);
        summary("FAILED",3);
      }
      else
      {
        log(8,"Data call complete");
        sprintf(msg,"getline %d name",line);
        a=Request ("pbox", msg, strlen(msg), &rlen);
        if (a != NULL)
        {
          summary(a,3);
          free(a);
        }
        else
          summary("FAILED",3);
      }
      sendstr(mdmh);
      mt_susjb(-1,100,NULL);
      sprintf(msg,"offline %d",line);
      a=Request ("pbox", msg, strlen(msg), &rlen);
      if (a != NULL) free(a);

      if (dcdtime)
         (void)COM_DCD(opch,0);       /* cancel EOF state */

      if(mdmo[0] != '\0')
      {
         llist *head_ptr;
         llist *run_ptr;
         llist *tmp_ptr;
         int delay = 150;

         head_ptr = NULL;
         run_ptr = head_ptr;

         log(64,mdmo);
         sendstr(mdmo);
/*
        The USRobotics modem sends it's response to commands in
        NON-HANDSHAKE mode, so it overflows the serial receive buffer
        if you try to log while it's sending you data. To get around this
        I build a linked list of modem responses, and log them all when the
        data flow stops
*/
         while(1)
         {
           ferr = io_fline(ipch,delay,ans,sizeof(ans)-1); /* get line or timeout */
           if(ferr > 1)                      /* ignore empty lines */
           {
             delay=50;
             ans[ferr-2] = '\0';             /* strip off CR */
             tmp_ptr = malloc(sizeof(llist));
             if (head_ptr == NULL)           /* new list */
             {
                 head_ptr = tmp_ptr;
                 run_ptr = tmp_ptr;
             }
             else
             {
               run_ptr->next = tmp_ptr;      /* append to list */
               run_ptr = tmp_ptr;
             }
             run_ptr->next = NULL;
             strcpy(run_ptr->txt,ans);       /* store text */
           }
           if(ferr < 0)
             break;
         }
         run_ptr = head_ptr;                 /* go from start of list */
         while(1)
         {
           if (run_ptr == NULL)              /* end of list */
              break;
           log(64,run_ptr->txt);
           tmp_ptr = run_ptr;
           run_ptr = run_ptr->next;          /* next line */
           free(tmp_ptr);
         }
      }

      sprintf((char *)&cmdln.chrs,"%d Exit code %d",line,fail);
      cmdln.len = strlen((char *)&cmdln.chrs[0]);

      strcpy(msg,"sysvar linetidy"); /* get the name of 'linetidy' */
      a=Request ("pbox", msg, strlen(msg), &rlen);
      if (a != NULL)
      {
        strcpy((char *)&fname.chrs,a);
        fname.len = strlen(a);

        if ((fname.len != 0) && (*a != '-'))
          (void)exec ((struct QD_text *)&fname.len,(struct QD_text *)&cmdln.len,
                     -1,0,0,0,0 );
        free(a);
      }
      return();
   }

   else if (strnicmp(msg,failcall,strlen(failcall)) == 0 )
   {
     log(64,"No carrier reported");
     summary("No carrier reported",1);
     sprintf(msg,"offline %d",line);
     a=Request ("pbox", msg, strlen(msg), &rlen);
     if (a != NULL) free(a);
     a=Request ("pbox", "counter 6", 9, &rlen);
     if (a != NULL) free(a);
     return();
   }

   else
   {
     if(msg[0] != '\0')
     {
       sprintf(ans,"Modem reports \"%s\" while answering",msg);
       log(64,ans);
       badlines++;
       if(badlines >= 6)          /* return if too much garbage on line    */
       {
          sprintf(msg,"offline %d",line);
          a=Request ("pbox", msg, strlen(msg), &rlen);
          if (a != NULL) free(a);
          summary("Garbage on line",3);
          return();
       }
     }
   }
 }
}
/*--------------------------------------------------------------------------*/
int init_modem()
{
int count = 0;
char *a;
char date[30];
char day[4];
char month[4];
long time;
short rlen;
char msg[82];
char ans[122];
char c, fail;

   if(ipch > 0)
     (void)io_close(ipch);
    mt_susjb(-1,100,NULL);
   ipch = io_open(modem, 1);
   if(ipch < 0)
   {
     log(32,"Unable to open serial port");
     return(ipch);
   }
   opch = ipch;
   if (dcdtime)
     (void)COM_DCD(opch,dcdtime);
   time = mt_rclck();
   (void)cn_date(date,time);
   strncpy(day,getday(time),3);
   day[3] = '\0';
   strncpy(month,getmonth(time),3);
   month[3] = '\0';
   a  = &date[0];
   a += 14;
   *a = '\0';
   a -= 8;
   *a = '\0';
   sprintf(msg,"---------- %s %s %s %s",day,month,date+10,date+2);
   log(1,msg);
   sprintf(msg,"Initialising modem on %s",modem);
   log(64,msg);
   strcpy(msg,"sysvar s_idle");
   a=Request ("pbox", msg, strlen(msg), &rlen);
   if (a != NULL)
   {
     *(a+rlen)= '\0';
     sprintf(ans,"status %s",a);
     free(a);
     setline(ans);
   }
 while(count < 5)                  /* try up to 5 times to init modem */
 {
   fail = 0;
   if ((mdm1[0] != '\0') && (fail == 0))
   {
     log(64,mdm1);
     sendstr(mdm1);
     if(get_ok() < 0)
       fail = 1;
   }
   if ((mdm2[0] != '\0') && (fail == 0))
   {
     log(64,mdm2);
     sendstr(mdm2);
     if(get_ok() < 0)
       fail = 1;
   }
   if ((mdm3[0] != '\0') && (fail == 0))
   {
     log(64,mdm3);
     sendstr(mdm3);
     if(get_ok() < 0)
       fail = 1;
   }
   if ((mdm4[0] != '\0') && (fail == 0))
   {
     log(64,mdm4);
     sendstr(mdm4);
     if(get_ok() < 0)
       fail = 1;
   }
   if(fail == 0)
   {
     log(64,"Initialised OK");
     return(0);
   }
   mt_susjb(-1,100,NULL);        /* wait a bit */
   (void)io_close(ipch);
   mt_susjb(-1,100,NULL);
   ipch = io_open(modem, 1);
   if(ipch < 0)
   {
     log(32,"Unable to open serial port");
     return(ipch);
   }
   mt_susjb(-1,100,NULL);
   opch = ipch;
   if (dcdtime)
     (void)COM_DCD(opch,dcdtime);
   count++;                     /* then retry up to 5 times */
 }

 strcpy(msg,"Modem initialisation failed - aborted.");
 log(32,msg);
 return(-1);
}
/*--------------------------------------------------------------------------*/
int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
char *a;
int n = -1;
char msg[122];
char ans[82];
short rlen;
char key;
char count;
int ferr;
short *ss;
long myid;
long tempid;
long prior = 0;
long addr = 0;
char *adptr = (char *)&addr;

    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    sp += (nc << 2);            /* skip channels        */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;

    if(mlen == 0)
      line = 1;                 /* default to line 1 */
    else
    {
      while(*sp == ' ') sp++;                     /* skip leading whitespace */
      line = atoi(sp);                            /* 1st param is line number */
    }
    a = (char *)&cmd.chrs;
    *a += line;

    if((n=UseSrvThg (CLNT, "pbox")) == 0)
    {
       loglevel = 0xffff;
       a = Request ("pbox","sysvar loglevel",-1,&rlen);
       if (a != NULL)
       {
         a[rlen] = '\0';
         if (*a != '-')
           loglevel = atoi(a);
         free(a);
       }
      sysvar("linemon0", linemon, sizeof(linemon)-1, line);
      sysvar("line0", modem, sizeof(modem)-1, line);

      sp = *av;                 /* point to job name */
      ss = (short *)sp;         /* this is where length goes */
      sp += 10;                 /* skip length and "Pbox Ser" */
      *sp++ = ' ';              /* add a space, then */
      strncpy(sp,modem, 12);    /* patch name to include ser port */
      sp = (char *)ss;
      sp += 2;
      *ss = strlen(sp);         /* and store new name length */

      if(linemon[0] != '-')
      {
         strcpy((char *)&fname.chrs, linemon);
         fname.len = strlen(linemon);
         monID =  exec ((struct QD_text *)&fname.len,
                       (struct QD_text *)&cmd.len,
                        0,0,0,0,0 );
      }
      else
      {
        monID = -1;     /* pretend we are the monitor job */
      }

      sprintf(msg,"%s %s",_prog_name,_version);
      log(1,msg);

      sysvar("failcall0", failcall, sizeof(failcall)-1, line);
      sysvar("datacall0", bbscall, sizeof(bbscall)-1, line);
      sysvar("faxcall0", faxcall, sizeof(faxcall)-1, line);
      sysvar("faxport0", faxport, sizeof(faxport)-1, line);
      sysvar("faxbaud0", faxbaud, sizeof(faxbaud)-1, line);
      sysvar("bbs_prg0", bbsprg, sizeof(bbsprg)-1, line);
      sysvar("fax_prg0", faxprg, sizeof(faxprg)-1, line);
      sysvar("mdm1_0", mdm1, sizeof(mdm1)-1, line);
      sysvar("mdm2_0", mdm2, sizeof(mdm2)-1, line);
      sysvar("mdm3_0", mdm3, sizeof(mdm3)-1, line);
      sysvar("mdm4_0", mdm4, sizeof(mdm4)-1, line);
      sysvar("mdmanswer_0", mdma, sizeof(mdma)-1, line);
      sysvar("mdmhangup_0", mdmh, sizeof(mdmh)-1, line);
      sysvar("mdmresult_0", mdmo, sizeof(mdmo)-1, line);
      sysvar("linelog0", linelog, sizeof(linelog)-1, line);
      sysvar("weekdays", days, sizeof(days)-1, 0);
      sysvar("months", mnth, sizeof(mnth)-1, 0);

      sysvar("mdmring_0", mdmd, sizeof(mdmd)-1, line);
      if (mdmd[0] == '-')
        answer_after = 1;
      else
        answer_after = atoi(mdmd);

      sysvar("mdmdcd_0", mdmd, sizeof(mdmd)-1, line);
      if (mdmd[0] == '-')
        dcdtime = 0;
      else
        dcdtime = atoi(mdmd);

      if (modem[0] == '-')
         return(-7);

      if (days[0] == '-')
         strcpy(days,"SatSunMonTueWedThuFri");
      if (mnth[0] == '-')
         strcpy(mnth,"JanFebMarAprMayJunJulAugSepOctNovDec");

      if (mdm1[0] == '-')
         mdm1[0] = '\0';
      if (mdm2[0] == '-')
         mdm2[0] = '\0';
      if (mdm3[0] == '-')
         mdm3[0] = '\0';
      if (mdm4[0] == '-')
         mdm4[0] = '\0';
      if (mdmo[0] == '-')
         mdmo[0] = '\0';
      if (mdmh[0] == '-')
          strcpy(mdmh,"~~~+++~~~ATH0");
      if (mdma[0] == '-')
          strcpy(mdma,"ATA");
      sprintf(msg,"offline %d",line);
      a=Request ("pbox", msg, strlen(msg), &rlen);
      if (a != NULL) free(a);
      if(init_modem() < 0)
        return(-1);
      log(1,"Waiting for call");

      while(1)
      {
        myid = -1;
        tempid = monID;
        ferr = mt_jinf( &tempid, &myid, &prior, &adptr );
        if (ferr < 0)                   /* check monitor still exists */
          (void) mt_frjob(-1, 0);       /* if not, suicide */

        ferr = get_modem(ans,40,400);  /* allow 8 seconds to detect 'ring' */
        if(ferr >= 0)
        {
          if (strnicmp(ans, "RING", 4) == 0)
          {
            rings++;
            sprintf(msg,"Ring %d",rings);
            log(64,msg);
            if (rings >= answer_after)
            {
              sprintf(msg,"online %d",line);    /* ask if we can go online */
              ferr = -1;
              a=Request ("pbox", msg, strlen(msg), &rlen);
              if (a != NULL)
              {
                *(a+rlen)= '\0';
                ferr = atoi(a);
                free(a);
              }
              if(ferr > 0)
              {
                rings = 0;
                if (linelog[0] == '-')
                  logID = -1;
                else
                {
                  logID = io_open(linelog,0);
                  if (logID > 0)
                    fs_pos(logID,0L,2);
                  else if (logID == -7)         /* not found, open new log */
                    logID = io_open(linelog,2);
                }
                answer_modem();
                if (logID >0)
                   io_close(logID);
                log(64,"Resetting modem");
                if(init_modem() < 0)
                  return(-1);
                log(1,"Waiting for call");
              }
            }
          }
          else
          {
          /* don't cancel ring counter here in case we ever get caller-id
             working - this is where the name/number will be sent */

            if(ans[0] != '\0')
            {
              sprintf(msg,"Modem reports \"%s\" while waiting",ans);
              log(64,msg);
              summary(msg,1);
            }
          }
        }
        else
          rings = 0;    /* reset ring counter - timeout */
      }
    }
    FreeSrvThg (CLNT, "pbox");
    return(0);
}
int (*_Cstart) () = main;
