;
; C68 library routine to set or read COM_DCD and COM_BAUD values.
; Returns current setting (+ve) or Qdos error (-ve)
;
; Equivalent to C Routine:
;
;   int com_dcd (int channel,short value)
;   int com_baud(int channel, int  value);
;
        .text
        .even

        .globl    _COM_DCD
        .globl    _COM_BAUD

_COM_BAUD:
        movem.l d1-d3/a0-a3,-(sp)
        moveq   #$52,d0                 ; IO.BAUD
        move.l  $20(a7),a0              ; channel
        move.l  $24(a7),d1              ; value to set
        bra     com_com
_COM_DCD:
        movem.l d1-d3/a0-a3,-(sp)
        moveq   #$54,d0                 ; IO.DCD
        move.l  $20(a7),a0              ; channel
        move.w  $24(a7),d1              ; value to set
com_com:
        trap    #3
        tst.l   d0                      ; did driver understand call?
        bne     com_exit
        move.w  d1,d0                   ; if so, return value
com_exit:
        movem.l (sp)+,d1-d3/a0-a3
        rts
