/*
       Pbox job to spawn a terminal monitoring the user on a specified
       line (default is line 1). You see exactly what the caller sees.
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>

long exec(struct QD_text *filename, struct QD_text *cmdline,
          short wait, short chans, long chan1, long chan2, long chan3);

long qpipe(long *, long *);

char _prog_name[] = "Monitor 0";
int  line;

void setline(char *value)
{
char msg[80];
char *a;
short rlen;

  (void)sprintf(msg,"setline %d %s",line,value);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a != NULL) free(a);
}

void getreq(char *msg, struct QD_text *rp)
{
/*
        Send a message to the Pbox server and get a reply back as a
        QD_text string. String length set to zero if error of any kind.
        No check is made that the QD_text is large enough.
*/
char *p;
short rlen;

  if((p=Request ("pbox", msg, strlen(msg), &rlen)) != NULL)
  {
    (void)strncpy( (char *)&(rp->chrs), p, rlen);
    rp->len = rlen;
    free(p);
  }
  else
    rp->len = 0;
}



int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
jobid_t termID = -1;
QD_TEXT  (80) fname = {0};
QD_TEXT  (20) cmdln = {0};
QD_TEXT  (10) chans = {0};
int n    = -1;
char msg[40];
char *ptr;
long rd1, wr1, wr2;
jobid_t  id    = -1;
long prior = 0;
long addr  = 0;
long myid  = 0;
long ferr  = 0;
long term  = 0;
long rlen  = 0;

    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    sp += (nc << 2);            /* skip channels        */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;
    if(mlen == 0)               /* if no commandline    */
      line = 1;
    else
      line = atoi(sp);

    ptr = *av;
    ptr += 10;
    *ptr += line;               /* change job name to include line no */


   cmdln.len = 0;
   if((n=UseSrvThg (CLNT, "pbox")) == 0)
   {
     ferr  = qpipe( &rd1, &wr1);   /* open a pipe */
     if(ferr == 0)                 /* if we got it opened ok */
     {
       wr2=io_open("nul",1);

       (void)sprintf(msg,"setline %d mono %d",line,wr1); /* set monitor output */
       getreq(msg,(struct QD_text *)&fname.len);


       (void)strcpy(msg,"sysvar moniterm");       /* get name of 'terminal'  */
       getreq(msg,(struct QD_text *)&fname.len);
       (void)strcpy((char *)&cmdln.chrs[0],"sysvar monicmd"); /* command line */
       getreq((char *)&cmdln.chrs[0],(struct QD_text *)&cmdln.len);
       if (strstr((char *)&cmdln.chrs[0],"-Error") != NULL)
           cmdln.len=0;
       (void)strcpy(msg,"sysvar monichans");      /* how many channels */
       getreq(msg,(struct QD_text *)&chans.len);
       rlen=atoi((char *)&chans.chrs[0]);
       if(fname.len != 0)
       {
         if(rlen == 3)
         {
           termID  = exec ((struct QD_text *)&fname.len,
                           (struct QD_text *)&cmdln.len,
                            0,3,rd1,0,wr2 );
         }
         else
         {
           termID  = exec ((struct QD_text *)&fname.len,
                           (struct QD_text *)&cmdln.len,
                            0,2,rd1,wr2,0 );
         }

         while (term == 0)          /* wait for terminal to die */
         {
           (void)mt_susjb(-1,5,NULL);
           myid = -1;
           id   = termID;                 /* look for this job ID. It returns */
                                          /* term -ve if job doesnt exist */
           term = mt_jinf( &id, &myid, &prior, (char **)&addr );
           myid = -1;
         }
         (void)sprintf(msg,"setline %d mono 0",line); /* set monitor output */
         getreq(msg,(struct QD_text *)&fname.len);
         (void)io_close(rd1);
         (void)io_close(wr1);
       }
     }
   }
  FreeSrvThg (CLNT, "pbox");         /* dont need the server any more */
  return(0);
}
int (*_Cstart) () = main;
