/*
 *   areafile -  produce a sorted list of files in the current area
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <time.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>
#include <database.h>

   struct dlist
    {
        char         *name;     /* filename */
        long          flen;     /* length */
        long          date;     /* update date */
        struct dlist *next;     /* ptr to next entry */
    };

#define unixtoql 283996800              /* time conversion, 1970 to 1961 */

char _prog_name[] = "Areafile";
char _version[] = "1.21";

char *flist, *fareas, *groups, *board, *phone, *head, *lang, *temp;
char *morereq, *moretag, *yesno, *whfile, *inactive, *eoline, *flnf;
char *powers, *magic, *exceed, *tempdir, *istagged, *passmsg;
char adir[38];
char areanum[8];
char pass[22];
long tagfile;
short lines, shown;
short allow = 0;
short tagk,tagn;
short dnpd,dntd;
short strip;
long ipch;                      /* input channel  */
long opch;                      /* output channel */
long mono;                      /* monitor output */
long fileDB = -1;
char lf[] = { '\r', '\n' };
char empty = '\0';
char bbsline[6];
char lno;
long timeout = 0;               /* inactivity timeout */
int  lf_eol = 0;
int cnt = 0;
int loglevel;
struct dlist *list;
struct dlist *lhed;
int raw = 0;
int show = 0;

void log(int l, char *msg);
int askline(char *buf, short buflen);
/*---------------------------------------------------------------------------*/
char *filename(char *n)
{
  char *period = NULL;
  char *underscore = NULL;
  char *ptr,*ret;

  ptr = n;
  ptr += 3;                     /* skip n1_ */
  ret = ptr;
  ptr = strchr(ret,'_');        /* find end of device */
  if (ptr == NULL)
    return(ret);
  ret = ptr+1;
  underscore = strrchr(ret,'_');
  period = strrchr(ret,'.');

  if(underscore == NULL)
    return(ret);                /* just a filename or name.ext */

  if(period != NULL)
    return(underscore+1);       /* dir_name.ext */

  ptr = strchr(ret,'_');        /* name_ext or dir_name_ext */
  if(ptr == underscore)
    return(ret);                /* name_ext */

  while(1)                      /* find last_but_one underscore */
  {
    ret = ptr+1;
    ptr = strchr(ret,'_');
    if(ptr >= underscore)
      return(ret);
  }
}
/*--------------------------------------------------------------------------*/
char * sysmsg(char *varname)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"sysmsg ");
  (void)strcat(msg,bbsline);
  (void)strcat(msg," ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg,(short)strlen(msg), &rlen);
  if (a == NULL)
    return (&empty);
  *(a+rlen) = '\0';
  return(a);
}
/*---------------------------------------------------------------------------*/
int tag(char *name, char inarea)  /* return 0 = ok, -ve = error, +ve = not allowed */
{
char full[40];
char lbuff[102];
char temp[50];
long file,fsiz;
char *ptr;
int ok,len;
char f;
short rlen;

     if (allow)
     {
       if ((allow & 2) == 0)      /* check downloads allowed */
       {
         whfile = sysmsg("optna");
        io_sstrg(opch, -1, whfile, strlen(whfile));
        io_sstrg(opch, -1, lf, 2);
        if (mono)
        {
        io_sstrg(mono,  0, whfile, strlen(whfile));
        io_sstrg(mono,  0, lf, 2);
        }
        return(1);
       }
     }
    strcpy(full,adir);
    strcat(full,name);
    file = io_open(full,1);
    fsiz = 0;
    if(file >= 0)
    {
      fsiz = fs_pos(file,0,2);          /* goto end of file */
      io_close(file);
      fsiz /= 1024;                     /* calculate file size in K */
      fsiz++;
      ok = 1;                           /* assume it's going to be tagged */

      if (strchr(powers,'H') == NULL)   /* if limited downloads */
      {
         if ((dntd + tagk) > dnpd)
         {
            ok = 0;
            io_sstrg(opch, -1, exceed, strlen(exceed));
            io_sstrg(opch, -1, lf, 2);
            if (mono)
            {
            io_sstrg(mono,  0, exceed, strlen(exceed));
            io_sstrg(mono,  0, lf, 2);
            }
            log(32,"Download limit exceeded");
            return(1);
         }
      }
      if (ok)
      {
        if(inarea)
          sprintf(temp,"%s %s",areanum,full);
        else
          strcpy(temp,full);
        fs_pos(tagfile,0,0);                    /* goto start of taglist */
        while(1)
        {
          len = io_fline(tagfile,-1,lbuff,50);
          if (len <= 0)
            break;
          lbuff[len-1]='\0';
          if (stricmp(temp,lbuff) == 0)         /* got a match */
          {
            sprintf(lbuff,"\"%s\" %s",filename(full),istagged);
            io_sstrg(opch, -1, lbuff, strlen(lbuff));
            io_sstrg(opch, -1, lf, 2);
            if (mono)
            {
            io_sstrg(mono,  0, lbuff, strlen(lbuff));
            io_sstrg(mono,  0, lf, 2);
            }
            ok = 0;
            return(0);
          }
        }
      }
      if (ok)
      {
        if (strchr(powers,'O') == NULL)   /* if password needed */
        {
          if (pass[0] != '\0')
          {
            for(f=0; f<3; f++)
            {
              io_sstrg(opch, -1, passmsg, strlen(passmsg));
              if (mono)
              io_sstrg(mono,  0, passmsg, strlen(passmsg));
              len = askline(lbuff,20);
              if (len < 0)      /* timed out getting response */
                 exit(len);
              if(strnicmp(lbuff,pass,strlen(pass)) != 0)
                ok = 0;
              else
              {
                ok = 1;
                break;
              }
            }
          }
        }
      }
      if (ok)
      {
        sprintf(lbuff,"Tag: %s %dk",filename(full),fsiz);
        io_sstrg(opch, -1, lbuff, strlen(lbuff));
        io_sstrg(opch, -1, lf, 2);
        if (mono)
        {
        io_sstrg(mono,  0, lbuff, strlen(lbuff));
        io_sstrg(mono,  0, lf, 2);
        }
        log(8,lbuff);
        io_sstrg(tagfile,-1,temp,strlen(temp));
        io_sbyte(tagfile,-1,'\n');
        sprintf(temp,"setline 0 tagk +%d",fsiz);
        temp[8] += lno;
        (void) Request ("pbox", temp,-1, &rlen);
        strcpy(temp,"setline 0 tagn +1");
        temp[8] += lno;
        (void) Request ("pbox", temp,-1, &rlen);
        return(0);
      }
    }
    else
    {
      sprintf(lbuff,"%s \"%s\"",flnf,name);
      io_sstrg(opch, -1, lbuff, strlen(lbuff));
      io_sstrg(opch, -1, lf, 2);
      if (mono)
      {
      io_sstrg(mono,  0, lbuff, strlen(lbuff));
      io_sstrg(mono,  0, lf, 2);
      }
      sprintf(lbuff,"Failed tag: \"%s\"",name);
      log(8,lbuff);
    }
    return(-1);
}
/*---------------------------------------------------------------------------*/
int comp_name(long db, char *rec, struct fld_list fldef[],char *appcn)
/*
        search the database for field 2 = required name

long db;                             database ID
char *rec;                           pointer to record
struct fld_list fldef[];             field list
char *appcn;                         application definable quantity; in
                                     this case, the compare string
   return: 1 = match;  0 = no match.
*/
{
   struct QLSTR *string;
   int stln;
 
   db = db; /* keep compiler happy */
   /* make a pointer to field 2 */
   string = (struct QLSTR *) (rec + fldef[2].fld_ptr);
   stln = strlen(appcn);
   if (stln != string->qs_strlen)  return(0);
   return(strnicmp(string->qs_str,appcn,stln) == 0);
}
/*---------------------------------------------------------------------------*/
int comp_area(long dbid,char *rec,struct fld_list fldef[],void *appcn)
{
   return(  *(short *)(rec + fldef[1].fld_ptr) == *(short *)appcn  );
}
/*--------------------------------------------------------------------------*/
/* reverse string s in place */
void reverse(char s[])
{
  int c,i,j;
  for(i=0, j=strlen(s)-1; i<j; i++, j-- )
  {
    c = s[i];
    s[i] = s[j];
    s[j] = (char)c;
  }
}
/*--------------------------------------------------------------------------*/
void ltoa(long n, char s[])
{
 int i, sign;

 if ((sign = n) < 0 )
    n = -n;
 i = 0;
 do {  s[i++] = (char)(n % 10 + '0');  }
    while ((n /= 10) > 0);
 if (sign < 0)
    s[i++] = '-';
 s[i] = '\0';
 reverse(s);
}
/*--------------------------------------------------------------------------*/
char getkey(void)
/* fetch a key or timeout, ignoring line feeds if appropriate */
{
char c;
int ferr,tmo;

  tmo = timeout;
  while(1)
  {
    ferr = io_fbyte( ipch, 50, &c );
    if (ferr == 0)              /* if you got a byte, return it, */
    {
      if (lf_eol)               /* if eol code is line-feed */
         return(c);             /* return whatever you got */
      else                      /* if CR or CR/LF is eol code */
        if (c != '\n')          /* ignore LFs on the assumption */
           return(c);           /* it's from a CR/LF pair */
    }
    if (ferr == -1)             /* not complete, */
    {
      if(tmo > 0)               /* if not infinite timeout */
      {
        tmo--;
        if(tmo == 0)            /* see if timed out yet */
           return(0);
      }
    }
    if (ferr < -1)
        return(0);              /* catch xmit error, eof etc. */
  }
}

/*--------------------------------------------------------------------------*/
char * sysvar(char *varname)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"sysvar ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg,(short)strlen(msg), &rlen);
  if (a == NULL)
    return (&empty);
  *(a+rlen) = '\0';
  return(a);
}
/*--------------------------------------------------------------------------*/
char * getline(char *varname)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"getline ");
  (void)strcat(msg,bbsline);
  (void)strcat(msg," ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg, (short)strlen(msg), &rlen);
  if (a == NULL) return (&empty);
  *(a+rlen) = '\0';
  return(a);
}
/*--------------------------------------------------------------------------*/
void log(int level, char *value)
{
char msg[82];
char *a;
short rlen;

  if(loglevel & level)
  {
    (void)strcpy(msg,"log ");
    (void)strcat(msg,bbsline);
    (void)strcat(msg," ");
    (void)strcat(msg,value);
    a=Request ("pbox", msg, (short)strlen(msg), &rlen);
    if (a != NULL) free(a);
  }
}
/*--------------------------------------------------------------------------*/
int askline(char *buf, short buflen)
{
   int len;
   char *ptr;
   char c;

   ptr = buf;
   len = 0;
   while(1)
   {
     c = getkey();
     if (c == 0)
       exit(-10);               /* eof or timeout */
     if (c == eoline[0])
     {
        *ptr = '\0';
        io_sstrg(opch,-1,lf,2);
        if (mono)
        io_sstrg(mono, 0,lf,2);
        return(len);                    /* return length, could be 0 */
     }
     if (c == 0)  return(-1);           /* or timeout */
     if ((c == 8) || (c == 127))        /* backspace */
     {
       if (len > 0)
       {
         ptr--;
         len--;
         (void)io_sbyte(opch,-1,8);
         (void)io_sbyte(opch,-1,' ');
         (void)io_sbyte(opch,-1,8);
         if (mono)
         {
         (void)io_sbyte(mono, 0,8);
         (void)io_sbyte(mono, 0,' ');
         (void)io_sbyte(mono, 0,8);
         }
       }
     }
     else
     {
       *ptr = c;
       ptr++;
       len++;
       if(len == buflen)  return(len);
       (void)io_sbyte(opch,-1,c);
       if (mono)
       (void)io_sbyte(mono, 0,c);
     }
   }
}
/*---------------------------------------------------------------------------*/
void askwhich(void)
{
char c;
char *ptr, *eol, *s;
char answer[102];
char lbuff[102];
char one_name[42];
short len,f,posn;
struct dlist *sptr;
long file;
char sent = 0;
/*
        Tag one or more comma-or-space separated filenames/numbers
*/
      io_sstrg(opch, -1, whfile, strlen(whfile));
      if (mono)
      io_sstrg(mono,  0, whfile, strlen(whfile));
      len = askline(answer,100);
      if (len < 0)      /* timed out getting response */
         exit(len);
      if (len == 0)
      {
        io_sstrg(opch, -1, lf, 2);
        if (mono)
        io_sstrg(mono,  0, lf, 2);
        return;
      }
      if (raw)
        sptr = list;
      else
        posn = fsd_curr(fileDB);  /* keep current position */
      ptr = eol = answer;
      while(1)                  /* for each entry */
      {
        sent = 0;
        while(*eol == ' ')      /* strip leading whitespace */
          eol++;
        if (*eol == '\0')       /* no more entries */
           break;
        ptr = eol;              /* start of entry */
        while((*eol != ',') && (*eol != ' ') && (*eol != '\0'))
          eol++;
        if (eol != ptr)         /* check for nul entry */
        {
           c = *eol;
           *eol = '\0';
           strcpy(one_name,ptr);        /* copy entry to "one_name" */
           *eol = c;
           c = 1;                       /* assume it's all numeric */
           for (f=0; f<strlen(one_name); f++)
           {
             if (!isdigit(one_name[f])) /* check all digits */
                c = 0;
           }
           if (c)       /* entry is a position in list */
           {
             if (raw == 1)      /* private, but no list shown */
             {
               sprintf(lbuff,"%s \"%s\"",flnf,one_name);
               io_sstrg(opch, -1, lbuff, strlen(lbuff));
               io_sstrg(opch, -1, lf, 2);
               if (mono)
               {
               io_sstrg(mono,  0, lbuff, strlen(lbuff));
               io_sstrg(mono,  0, lf, 2);
               }
             }
             else if (raw == 2)
             {
               f = (short)atoi(one_name);
               if ((f > 0) && (f <= cnt))
               {
                 list = lhed;
                 while (f > 1)
                 {
                   list = list->next;
                   f--;
                 }
                 s = list->name;
                 s += strip;

                 strcpy(one_name, s);   /* get filename */
                 pass[0] = '\0';
                 if(tag(one_name,0)==0) sent = 1;
               }
               else              /* number not valid */
               {
                 sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                 io_sstrg(opch, -1, lbuff, strlen(lbuff));
                 io_sstrg(opch, -1, lf, 2);
                 if (mono)
                 {
                 io_sstrg(mono,  0, lbuff, strlen(lbuff));
                 io_sstrg(mono,  0, lf, 2);
                 }
               }
             }
             else
             {
               f = (short)atoi(one_name);
               if ((f > 0) && (f <= cnt))
               {
                 fsd_posa(fileDB, f-1);
                 len = fsd_get(fileDB,2,36,one_name);     /* get filename */
                 one_name[len] = '\0';
                 len = fsd_get(fileDB,6,20,pass);         /* get password */
                 pass[len] = '\0';
                 if(tag(one_name,1)==0) sent = 1;
               }
               else              /* number not valid */
               {
                 sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                 io_sstrg(opch, -1, lbuff, strlen(lbuff));
                 io_sstrg(opch, -1, lf, 2);
                 if (mono)
                 {
                 io_sstrg(mono,  0, lbuff, strlen(lbuff));
                 io_sstrg(mono,  0, lf, 2);
                 }
               }

             }  /* not raw */
           }
           else         /* it's a name */
           {
              if (strchr(powers,'M') != NULL)  /* full system access */
              {
                file = io_open(one_name,1);

                if (file > 0)
                {
                  io_close(file);
                  pass[0] = '\0';       /* no password  */
                  adir[0] = '\0';       /* no directory */
                  if(tag(one_name,0)==0) sent = 1;
                }
              }
              if ((magic[0] != '\0') && (sent == 0))  /* try magic names */
              {
                 file = io_open(magic,1);             /* open for read only */
                 if ( file >= 0 )
                 {
                   f = 0;
                   while ( f >= 0)
                   {
                     f = io_fline(file,200,lbuff,100);  /* check each line in the magic file */
                     if (f > 0)
                     {
                       lbuff[f-1] = '\0';             /* make sure line is terminated */
                       if (strnicmp(lbuff,one_name,strlen(one_name)) == 0)
                       {
                          ptr = lbuff;
                          ptr += strlen(one_name);
                          if(*ptr == ' ')           /* make sure it's whole of name */
                          {
                            while(*ptr == ' ') ptr++;
                            (void)io_close(file);
                            file = io_open(ptr,1);    /* open the magic filename */
                            if(file >=0)
                            {
                              (void)io_close(file);
                              pass[0] = '\0';       /* no password  */
                              adir[0] = '\0';       /* no directory */
                              if(tag(ptr,0) == 0) sent = 1;
                            }
                          }
                       }
                     }
                   }
                   (void)io_close(file);            /* not a magic name */
                 }

              }
              if (sent == 0)
              {
                 if (raw)
                 {
                   strcpy(lbuff,adir);
                   strcat(lbuff,one_name);
                   file = io_open(lbuff,1);

                   if (file > 0)
                   {
                     io_close(file);
                     pass[0] = '\0';
                     if (tag(one_name,0) == 0) sent = 1;
                   }
                   else              /* not found in this area */
                   {
                     sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                     io_sstrg(opch, -1, lbuff, strlen(lbuff));
                     io_sstrg(opch, -1, lf, 2);
                     if (mono)
                     {
                     io_sstrg(mono,  0, lbuff, strlen(lbuff));
                     io_sstrg(mono,  0, lf, 2);
                     }
                   }
                 }
                 else
                 {
                   if (fsd_srch(fileDB, comp_name, one_name) >= 0)
                   {
                     len = fsd_get(fileDB,6,20,pass);        /* get password */
                     pass[len] = '\0';
                     if (tag(one_name,1) == 0) sent = 1;
                   }
                   else              /* not found in this area */
                   {
                     sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                     io_sstrg(opch, -1, lbuff, strlen(lbuff));
                     io_sstrg(opch, -1, lf, 2);
                     if (mono)
                     {
                     io_sstrg(mono,  0, lbuff, strlen(lbuff));
                     io_sstrg(mono,  0, lf, 2);
                     }
                   }
                 }
              }
           }
        }
        else
          eol++;
      }
      io_sstrg(opch, -1, lf, 2);
      if (mono)
      io_sstrg(mono,  0, lf, 2);
      if (raw)
        list = sptr;
      else
        fsd_posa(fileDB,posn);            /* restore position in list */
      mt_susjb(-1,80,NULL);
}
/*---------------------------------------------------------------------------*/
char checkmore(void)
{
char c;
short len,f;

  if (morereq[0] != '0')
  {
    if (shown == lines)
    {
      shown = 0;
      len = strlen(moretag);
      io_sstrg(opch,-1, moretag, len);
      io_sbyte(opch,-1,' ');
      if (mono)
      {
      io_sstrg(mono, 0, moretag, len);
      io_sbyte(mono, 0,' ');
      }
      c = getkey();
      if (c == 0)
        exit(-10);              /* eof or timeout */
      if(strchr(yesno,c) != NULL)
      {
        if(morereq[0] == '2')
        {
          io_sbyte(opch,-1,0x0c);
          if (mono)
          io_sbyte(mono, 0,0x0c);
        }
        else
        {
          io_sbyte(opch,-1,'\r');
          if (mono)
          io_sbyte(mono, 0,'\r');
          for (f=0; f<len; f++)     /* wipe the prompt */
          {
            io_sbyte(opch,-1,' ');
            if (mono)
            io_sbyte(mono, 0,' ');
          }
          io_sbyte(opch,-1,'\r');
          if (mono)
          io_sbyte(mono, 0,'\r');
        }
      }
      if (c == yesno[0])
         return(0);
      if (c == yesno[1])
         return(0);
      if (c == yesno[2])
         return(-1);
      if (c == yesno[3])
         return(-1);
      io_sbyte(opch,-1,'\r');
      if (mono)
      io_sbyte(mono, 0,'\r');
      for (f=0; f<len; f++)     /* wipe the prompt */
      {
        io_sbyte(opch,-1,' ');
        if (mono)
        io_sbyte(mono, 0,' ');
      }
      io_sbyte(opch,-1,'\r');
      if (mono)
      io_sbyte(mono, 0,'\r');
      askwhich();
      return(1);
    }
  }
  return(0);
}
/*---------------------------------------------------------------------------*/
struct dlist * dir_read(char *dir)
{
struct dlist *head = NULL;
struct dlist *tail = NULL;
struct dlist *new = NULL;
char dbuff[64];
char *t, *txt;
short *s, len;
long *l;
long ch;
int ferr;

  ch = io_open(dir,4);
  if (ch > 0)
  {
    while(1)
    {
      ferr = io_fstrg(ch, -1, dbuff, 64);
      if (ferr != 64) break;
      s = (short *)&dbuff[14];           /* point to name length */
      len = *s;
      if ((len > 0) && (len < 37))       /* ignore empty/bad ones */
      {
        new = (struct dlist *)malloc(sizeof(struct dlist));
        txt = malloc(len+1);
        t = &dbuff[16];
        strncpy(txt,t,len);
        txt[len] = '\0';
        l = (long *)&dbuff[0];
        new->name = txt;
        new->flen = *l;
        l = (long *)&dbuff[52];
        new->date = *l;
        new->next = NULL;
        if (head == NULL)
          head = new;
        else
          tail->next = new;
        tail = new;
      }
    }
    io_close(ch);
  }
  return(head);
}
/*---------------------------------------------------------------------------*/
int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
long fareaCH = -1;
long fareaDB = -1;
long ch;
int nfiles;
short rlen;
int  ans,a,f;
long fdate;
short anum,fdown;
char aname[38];
char agrp[6];
char adesc[502];
char ahead[42];
char atyp[10];
char fname[38];
char fdesc[1002];
char full[38];
char padding[80];
char stars[80];
char lbuff[302];
struct tm *tp;
long file,fsiz;
char c1,c2;
char *s,*c,*t,*tmp;
int  pad,l,lim,skip,ferr;
char m1[] = "setline 0 exitcmd = menu_prg curr";
char m2[] = "getflst 0 1";

    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    if (nc != 2) exit(-15);     /* abort if no channels */
    ipch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    opch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;

    if(mlen)
      lno = atoi(sp);
    else
      lno = 0;

    *(sp+mlen)='\0';

    if (strfnd("nolist",sp) == -1)
      show = 1;

    m1[8] += lno;               /* patch line number into messages */
    m2[8] += lno;
    ltoa(lno,bbsline);          /* get it in ascii */

     if((ans=UseSrvThg (CLNT, "pbox")) == 0)
     {
      if(lno == 0)
        inactive = Request ("pbox","sysvar inactive0",-1,&rlen);
      else
        inactive = Request ("pbox","sysvar inactive",-1,&rlen);
      if (inactive == NULL)
        timeout = -1;
      else
      {
        inactive[rlen] = '\0';
        if(inactive[0] != '-')
          timeout = atol(inactive);
        if(timeout==0) timeout = -1;
      }
       eoline  = getline("eoli");
       lf_eol = (eoline[0] == '\n');

       fareas  = sysvar ("fareas");
       tempdir = sysvar ("tempdir");
       magic = sysvar ("magic_dat");
       groups  = getline("fareas");
       morereq = getline("more");
       moretag = Request ("pbox", m1,-1, &rlen); /* dummy to set exit cmd */
       if (moretag != NULL) free(moretag);
       moretag = sysmsg("moretag");
       istagged = sysmsg("istagged");
       passmsg = sysmsg("password");
       yesno   = sysmsg("yesno");
       flnf    = sysmsg("flnf");
       exceed  = sysmsg("dlexceed");
       lang    = getline("lang");
       powers  = getline("power");
       temp    = getline("mono");
       mono    = atoi(temp);
       temp    = getline("dnpd");
       dnpd    = (short)atoi(temp);
       temp    = getline("dntd");
       dntd    = (short)atoi(temp);
       temp    = getline("tagk");
       tagk    = (short)atoi(temp);
       temp    = getline("tagn");
       tagn    = (short)atoi(temp);
       temp    = getline("cfil");
       anum    = (short)atoi(temp);
       strcpy(areanum,temp);
       t = Request ("pbox","sysvar loglevel",-1,&rlen);
       if (t == NULL)
         loglevel = 0xffff;
       else
       {
         t[rlen] = '\0';
         if (*t == '-')
           loglevel = 0xffff;
         else
           loglevel = atoi(t);
         free(t);
       }
       sprintf(lbuff,"%s %s",_prog_name,_version);
       log(1,lbuff);
       temp    = getline("lines");
       lines   = (short)atoi(temp);
       if(lines == 0) lines = 24;
       lines--;         /* allow for "more" prompt */

       fareaCH = io_open( fareas, 1 ); /* shared access open */
       if (fareaCH > 0 )
          fareaDB = fsd_open(fareaCH);

       if (fareaCH < 0 || fareaDB < 0 ) /* if the 'open' failed */
         exit(-9);
#define elim 55
#define epad 24
     ans = fsd_srch(fareaDB, comp_area, &anum);
     ans = fsd_get(fareaDB, 5, 4, agrp);
     ans = fsd_get(fareaDB, 4, 36, adir);
     adir[ans] = '\0';
     ans = fsd_get(fareaDB, 6, 8, atyp);
     atyp[ans] = '\0';
     whfile  = sysmsg("whfile");

     tmp = strchr(groups,agrp[0]);
     if (tmp != NULL)
       allow = atoi(tmp+1);

     if (allow)
     {
       if ((allow & 33) == 0)   /* check listing or raw listing allowed */
         show = 0;
     }
   if (show)
   {
     if(morereq[0] == '2')
     {
       io_sbyte(opch,-1,0x0c);
       if (mono)
       io_sbyte(mono, 0,0x0c);
     }
     for(f=0;f<epad;f++)
       padding[f] = ' ';
     padding[epad] = '\0';
     for(f=0;f<78;f++)
       stars[f] = '*';
     stars[78] = '\0';

     head    = sysmsg("listhead");
     board   = sysvar ("boardname");
     phone   = sysvar ("phone_no");
     ans = fsd_get(fareaDB, 2, 36, aname);
     aname[ans] = '\0';
     ans = fsd_get(fareaDB, 8, 80, adesc);
     adesc[ans] = '\0';
     ans = fsd_get(fareaDB, 10, 40, ahead);
     ahead[ans] = '\0';
     io_sstrg(opch, -1, stars, strlen(stars));
     io_sstrg(opch, -1, lf, 2);
     if (mono)
     {
     io_sstrg(mono,  0, stars, strlen(stars));
     io_sstrg(mono,  0, lf, 2);
     }
     sprintf(lbuff,"* %-21.21s  %-21.21s AREA: %-23.23s *",board,phone,adesc);
     io_sstrg(opch, -1, lbuff, strlen(lbuff));
     io_sstrg(opch, -1, lf, 2);
     if (mono)
     {
     io_sstrg(mono,  0, lbuff, strlen(lbuff));
     io_sstrg(mono,  0, lf, 2);
     }
     sprintf(lbuff,"* %-74.74s *",head);
     io_sstrg(opch, -1, lbuff, strlen(lbuff));
     io_sstrg(opch, -1, lf, 2);
     io_sstrg(opch, -1, stars, strlen(stars));
     io_sstrg(opch, -1, lf, 2);
     if (mono)
     {
     io_sstrg(mono,  0, lbuff, strlen(lbuff));
     io_sstrg(mono,  0, lf, 2);
     io_sstrg(mono,  0, stars, strlen(stars));
     io_sstrg(mono,  0, lf, 2);
     }
     shown = 4;
   }
     sprintf(lbuff,"%sTaglist0",tempdir);       /* open the taglist */
     s = lbuff;
     s += strlen(lbuff);
     s--;
     *s += lno;                  /* patch name to required line number */
     tagfile = io_open(lbuff,0);
     if (tagfile < 0)
       tagfile = io_open(lbuff,2);
     raw = 0;
     if (strchr(atyp,'P') != NULL)
     {
        raw = 1;                        /* 1 = private area */
        if (strchr(powers,'R') != NULL) /* 2 = allowed to see a raw directory */
          raw = 2;
        if (allow)                      /* check for override */
        {
          if (allow & 32)
            raw = 2;
          else
            raw = 1;
        }
     }
     if (raw == 1)              /* no list available, cant use numbers */
       whfile  = sysmsg("tagnames");
     if (raw)                   /* build a raw directory list */
     {
       strip = strlen(adir);    /* get length of directory part of name */
       strip -= 5;              /* allowing for device part */
       lhed = dir_read(adir);
       list = lhed;
       nfiles = 0;              /* count how many entries there are */
       while (list != NULL)
       {
         nfiles++;
         list = list->next;
       }
       list = lhed;             /* back to start */
     }
     if (raw < 2)
     {
       if (show)
       {
          s = ahead;                 /* show any header file */
          s += strlen(ahead);
          *s = *lang;                /* patch name to required language */
          *(s+1) = '\0';             /* and re-terminate name */

          file = io_open(ahead,1);
          if ( file < 0 )
          {
            *s = '0';
            file = io_open(ahead,1);
            if ( file < 0 )
            {
              *s = '\0';
              file = io_open(ahead,1);
            }
          }
          if (file >= 0 )                            /* show file header text */
          {
           ferr = 0;
           while(ferr >= 0)
           {
             ferr = io_fline(file, -1, lbuff, 300);
             if (ferr == -5)
             {
                 while(io_fbyte(file, -1, &c1 ) == 0) /* go to eof   */
                 if(c1 == '\n') break;              /* or linefeed */
                 ferr = 300;                          /* to truncate long lines */
             }
             if (ferr > 0)
             {
               io_sstrg(opch, -1, lbuff, ferr -1);
               io_sstrg(opch, -1, lf, 2);
               if (mono)
               {
               io_sstrg(mono,  0, lbuff, ferr -1);
               io_sstrg(mono,  0, lf, 2);
               }
               shown++;
             }
           }
           io_sstrg(opch, -1, lf, 2);
           if (mono)
           io_sstrg(mono,  0, lf, 2);
           shown++;
           io_close(file);
          }
       }
       cnt = 50;
       while(1)
       {
         flist   = Request ("pbox", m2, -1, &rlen);
         if (flist == NULL)  exit (-1);
         flist[rlen] = '\0';
         fileDB = atoi(flist);          /* get external list */
         free(flist);
         if(fileDB != -1)               /* -1 means no list (yet) */
           break;
         cnt--;
         if(cnt == 0)                   /* try 50 times (5 seconds) */
           exit(-1);
         mt_susjb(-1,5,NULL);           /* at 1/10 second intervals */
       }
       nfiles = fsd_rcnt(fileDB);      /* how many files in database */
       fsd_posa(fileDB,0);             /* position at start of files */
     }
     if (show)
     {
        cnt = 0;
        for(f = 0; f < nfiles; f++)
        {
            cnt++;
            if (raw)
            {
              s = list->name;
              s += strip;
              rlen = strlen(s);
              strcpy(fname,s);
              fname[rlen] = '\0';
              fdesc[0] = '\0';
              fdate = list->date;
              fdown = 0;
              fsiz  = list->flen;
              fsiz /= 1024;                        /* calculate file size in K */
              fsiz++;
            }
            else
            {
              ans = fsd_get(fileDB, 2,36, &fname[0]);
              fname[ans] = '\0';
              ans = fsd_get(fileDB, 5,1000, &fdesc[0]);
              fdesc[ans] = '\0';
              ans = fsd_get(fileDB, 3, 4, &fdate);
              ans = fsd_get(fileDB, 4, 2, &fdown);
              strcpy(full,adir);
              strcat(full,fname);
              file = io_open(full,1);
              fsiz = 0;
              if(file >= 0)
              {
                fsiz = fs_pos(file,0,2);             /* goto end of file */
                io_close(file);
                fsiz /= 1024;                        /* calculate file size in K */
                fsiz++;
              }
            }
            fdate -= unixtoql;
            tp = localtime(&fdate);
            /* name, date, size in k, dloads, areaname */

            if (fsiz)
              sprintf(lbuff,"%3.3d  %-18.18s %02.2d/%02.2d/%02.2d %5.5dk [%04.4d] ",
                     cnt, fname, tp->tm_mday, (tp->tm_mon)+1, tp->tm_year,
                     fsiz, fdown);
            else
              sprintf(lbuff,"%3.3d  %-18.18s %02.2d/%02.2d/%02.2d --??-- [%04.4d] ",
                     cnt, fname, tp->tm_mday, (tp->tm_mon)+1, tp->tm_year,
                     fdown);
            io_sstrg(opch, -1, lbuff, strlen(lbuff));
            io_sstrg(opch, -1, lf, 2);
            if (mono)
            {
            io_sstrg(mono,  0, lbuff, strlen(lbuff));
            io_sstrg(mono,  0, lf, 2);
            }
            shown++;
            if(checkmore() == -1)
               exit(0);
            if (raw == 0)
            {
              c = &fdesc[0];
              s = c;
              lim = elim;
              l = strlen(c);
              if(l == 0)
              {
                io_sstrg(opch, -1, padding, strlen(padding));
                io_sstrg(opch, -1, "No Description", 14);
                io_sstrg(opch, -1, lf, 2);
                if (mono)
                {
                io_sstrg(opch,  0, padding, strlen(padding));
                io_sstrg(mono,  0, "No Description", 14);
                io_sstrg(mono,  0, lf, 2);
                }
                shown++;
                if(checkmore() == -1)
                   exit(0);
              }
              else
              {
                while(l)
                {
                  if(l <= lim)             /* less than a full line left */
                  {                        /* so it's last one to print */
                    io_sstrg(opch, -1, padding, strlen(padding));
                    io_sstrg(opch, -1, s, strlen(s));
                    io_sstrg(opch, -1, lf, 2);
                    if (mono)
                    {
                    io_sstrg(mono,  0, padding, strlen(padding));
                    io_sstrg(mono,  0, s, strlen(s));
                    io_sstrg(mono,  0, lf, 2);
                    }
                    shown++;
                    if(checkmore() == -1)
                      exit(0);
                    break;
                  }
                  else
                  {
                    c += lim;
                    while(*c != ' ')
                    {
                      if(c == s)
                        break;
                      c--;
                    }
                  }
                  if(c != s)
                  {
                    *c = '\0';
                    io_sstrg(opch, -1, padding, strlen(padding));
                    io_sstrg(opch, -1, s, strlen(s));
                    io_sstrg(opch, -1, lf, 2);
                    if (mono)
                    {
                    io_sstrg(mono,  0, padding, strlen(padding));
                    io_sstrg(mono,  0, s, strlen(s));
                    io_sstrg(mono,  0, lf, 2);
                    }
                    shown++;
                    if(checkmore() == -1)
                      exit(0);
                    l -= strlen(s);
                    s=c;
                    s++;
                    l--;
                  }
                  else
                  {
                    c += lim;
                    c -= 2;
                    c1 = *c;
                    *c = '-';
                    c++;
                    c2 = *c;
                    *c = '\0';
                    io_sstrg(opch, -1, padding, strlen(padding));
                    io_sstrg(opch, -1, s, strlen(s));
                    io_sstrg(opch, -1, lf, 2);
                    if (mono)
                    {
                    io_sstrg(mono,  0, padding, strlen(padding));
                    io_sstrg(mono,  0, s, strlen(s));
                    io_sstrg(mono,  0, lf, 2);
                    }
                    shown++;
                    if(checkmore() == -1)
                      exit(0);
                    l -= strlen(s);
                    *c = c2;
                    c--;
                    *c = c1;
                    s = c;
                  }
                }                          /* end while l */
              }                            /* end description */
            fsd_posr(fileDB,1);            /* next file */
            }
            else                           /* raw directory */
              list = list->next;
        }                                  /* end for all files */
     }
     else
       cnt = nfiles = 10000;

     if (nfiles)
        askwhich();
     else
        sleep(4);
     fsd_close(fareaDB);
     io_close(fareaCH);
   }
   FreeSrvThg (CLNT, "pbox");
   return(0);
}
int (*_Cstart) () = main;
