/*
 *     Flist -  produce a list of all files in public areas, a list
 *              of new files, and a zipped version of the full list
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <time.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>
#include <database.h>

#define unixtoql 283996800              /* time conversion, 1970 to 1961 */

#undef _condetails
#define LINES   14
#define COLUMNS 52
#define BORDERW 1
struct WINDOWDEF
     _condetails = {
        2,
        BORDERW,
        0,
        7,
        6*COLUMNS+4*BORDERW,
        10*LINES+3*BORDERW+12,
        16,
        26
        };

void    consetup_title();
void    (*_consetup)() = consetup_title;
char*   _endmsg = NULL;

char _version[]   = "1.08";
char _copyright[] = "PA Borman";
char _prog_name[] = "Pbox FileList";
char empty = '\0';

char *files, *fareas, *flist, *zipcmd, *ziplist, *newlist;
char *zipper, *magic, *listgrp;

int comp_area(long dbid,char *rec,struct fld_list fldef[],void *appcn)
{
   return(  *(short *)(rec + fldef[1].fld_ptr) == *(short *)appcn  );
}
/*--------------------------------------------------------------------------*/
char * sysvar(char *varname)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"sysvar ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg,(short)strlen(msg), &rlen);
  if (a == NULL)
    return (&empty);
  *(a+rlen) = '\0';
  return(a);
}
/*---------------------------------------------------------------------------*/
int main (int ac, char **av)
{
long fileCH = -1;
long fileDB = -1;
long fareaCH = -1;
long fareaDB = -1;
int nareas,nfiles;
char msg[40];
short rlen;
int  ans,a,f;
long fdate;
short anum,cnum,fdown;
short sort_order[6];
short new_sort[2];
char aname[38];
char adir[38];
char agrp[6];
char adesc[502];
char fname[38];
char fdesc[1002];
char full[38];
char padding[80];
char stars[80];
struct tm *tp;
FILE *list, *file;
long fsiz;
char c1,c2;
char *s,*c,*t;
int  pad,l,lim,cnt,skip;

     sort_order[0] =  1;     /* area number, ascending */
     sort_order[1] =  1;
     sort_order[2] =  3;     /* datestamp, descending */
     sort_order[3] = -1;
     sort_order[4] =  2;     /* filename, ascending */
     sort_order[5] =  1;
       new_sort[0] =  3;     /* datestamp, descending */
       new_sort[1] = -1;

     for(f=0;f<78;f++)
       stars[f] = '*';
     stars[78] = '\0';

     if((ans=UseSrvThg (CLNT, "pbox")) == 0)
     {
       fareas  = sysvar ("fareas");
       files   = sysvar ("files");
       flist   = sysvar ("flist_txt");
       zipcmd  = sysvar ("flist_cmd");
       ziplist = sysvar ("flist_zip");
       listgrp = sysvar ("flist_grp");
       newlist = sysvar ("newlist");
       zipper  = sysvar ("zip_prg");
       magic   = sysvar ("magic_dat");

       if (*listgrp == '-') *listgrp = '\0';  /* blank string if not defined */

       fareaCH = io_open( fareas, 1 ); /* shared access open */
       if (fareaCH > 0 )
          fareaDB = fsd_open(fareaCH);

       if (fareaCH < 0 || fareaDB < 0 )     /* if the 'open' failed */
       {
         printf("Unable to open FAREAS\n");
         return(0);
       }
       fileCH = io_open( files, 1 ); /* shared access open */
       if (fileCH > 0 )
          fileDB = fsd_open(fileCH);

       if (fileCH < 0 || fileDB < 0 )     /* if the 'open' failed */
       {
         printf("Unable to open FILES\n");
         return(0);
       }
       list = fopen(flist,"w");
       file = fopen(magic,"r");
       if(file != NULL)
       {
          printf("Magic names\n");
          while(1)
          {
            s = fgets(adesc, 81, file);
            if(s == NULL)
              break;
            if(*s == '#')
              fputs(++s,list);
          }
          fclose(file);
       }
       ans    = fsd_ordr (fileDB, 3, sort_order);   /* sort the database */

       cnum = -1;                       /* current area number */

       nfiles = fsd_rcnt(fileDB);      /* how many files in database */

#define slim 35
#define elim 44
#define epad 35

       for(f=0;f<78;f++)
         padding[f] = ' ';
       padding[epad] = '\0';

       fsd_posa(fileDB,0);              /* position at start of files */
       for(f = 0; f < nfiles; f++)
       {
         ans = fsd_get(fileDB, 1, 2, &anum);
         if(anum != cnum)               /* changed area */
         {
           if((cnum != -1) && (!skip))
             printf(" %4.4d files\n",cnt);
           cnt = 0;             /* no files in this group yet */
           skip = 0;            /* assume we're listing this new group */
           ans = fsd_srch(fareaDB, comp_area, &anum);
           if(ans >= 0)
           {
               ans = fsd_get(fareaDB, 2, 36, aname);
               aname[ans] = '\0';
               ans = fsd_get(fareaDB, 4, 36, adir);
               adir[ans] = '\0';
               ans = fsd_get(fareaDB, 8,500, adesc);
               adesc[ans] = '\0';
               ans = fsd_get(fareaDB, 5, 4, agrp);
               agrp[ans] = '\0';

               if (listgrp[0] != '\0')
                 if ((*agrp != '\0') && (strchr (listgrp,*agrp) == NULL))
                      skip = 1;      /* skip if not a listed group */

               if (!skip)
               {
                 printf("Area %4.4d, %-20.20s",anum,aname);
                 fputs("\n",list);
                 fputs(stars,list);
                 fputs("\n",list);
                 fprintf(list,"*   Area %4.4d, %-20.20s %-40.40s *\n",
                         anum, aname, adesc);
                 fputs(stars,list);
                 fputs("\n",list);
               }
           }
           else
              printf("Unknown area %d\n",anum);
           cnum = anum;
         }
         cnt++;
       if (!skip)
       {
         ans = fsd_get(fileDB, 2,36, &fname[0]);
         fname[ans] = '\0';
         ans = fsd_get(fileDB, 5,1000, &fdesc[0]);
         fdesc[ans] = '\0';
         ans = fsd_get(fileDB, 3, 4, &fdate);
         ans = fsd_get(fileDB, 4, 2, &fdown);
         fdate -= unixtoql;
         tp = localtime(&fdate);
         strcpy(full,adir);
         strcat(full,fname);
         file = fopen(full,"r");
         fsiz = 0;
         if(file != NULL)
         {
           fseek(file,0L,SEEK_END);
           fsiz = ftell(file);
           fclose(file);
           fsiz /= 1024;
           fsiz++;
         }
         /* name, date, size in k, dloads, description */
         if (fsiz)
           fprintf(list,"%-18.18s %02.2d/%02.2d/%02.2d %5.5dk [%04.4d] ",
                  fname, tp->tm_mday, (tp->tm_mon)+1, tp->tm_year,
                  fsiz, fdown);
         else
           fprintf(list,"%-18.18s %02.2d/%02.2d/%02.2d --??-- [%04.4d] ",
                  fname, tp->tm_mday, (tp->tm_mon)+1, tp->tm_year, fdown);
         
         c = &fdesc[0];
         s = c;
         lim = slim;
         l = strlen(c);
         if(l == 0)
           fputs("No Description\n",list);
         else
         {
             while(l)
             {
               if(l <= lim)
               {
                 if(lim != slim)
                   fputs(padding,list);
                 fputs(s,list);
                 fputs("\n",list);
                 break;
               }
               else
               {
                 c += lim;
                 while(*c != ' ')
                 {
                   if(c == s)
                     break;
                   c--;
                 }
               }
               if(c != s)
               {
                 *c = '\0';
                 if(lim != slim)
                   fputs(padding,list);
                 fputs(s,list);
                 fputs("\n",list);
                 l -= strlen(s);
                 s=c;
                 s++;
                 l--;
               }
               else
               {
                 c += lim;
                 c -= 2;
                 c1 = *c;
                 *c = '-';
                 c++;
                 c2 = *c;
                 *c = '\0';
                 if(lim != slim)
                   fputs(padding,list);
                 fputs(s,list);
                 fputs("\n",list);
                 l -= strlen(s);
                 *c = c2;
                 c--;
                 *c = c1;
                 s = c;
               }
               lim = elim;
             }                          /* end while l */
         }
         }                              /* end skip group */
         fsd_posr(fileDB,1);            /* next file */
       }
       if(!skip) printf(" %4.4d files\n",cnt);
       fclose(list);

       printf("Zipping\n");
       remove(ziplist);
       (void)sprintf(adesc,zipcmd,ziplist,flist);
       (void)execl(zipper, (int *)-1L, "Zipper", adesc, NULL);

       file = fopen(newlist,"r");
       if(file != NULL)
       {
         printf("New files\n");
         s = fgets(adesc,80,file);
         c = fgets(padding,80,file);
         t = fgets(stars,80,file);
         fclose(file);
         file = fopen(newlist,"w");
         if(s != NULL)
           fputs(adesc,file);
         else
           fputs("\n",file);
         if(c != NULL)
           fputs(padding,file);
         else
           fputs("\n",file);
         if(t != NULL)
           fputs(stars,file);
         else
           fputs("\n",file);

         ans    = fsd_ordr (fileDB, 1, new_sort);   /* sort the database */
         f = 0;         /* not shown any yet */
         fsd_posa(fileDB,0);
         while(1)
         {
           ans = fsd_get(fileDB, 1, 2, &anum);
           ans = fsd_srch(fareaDB, comp_area, &anum);
           ans = fsd_get(fareaDB, 5, 4, agrp);
           agrp[ans] = '\0';

           skip = 0;
           if (listgrp[0] != '\0')
             if ((*agrp != '\0') && (strchr (listgrp,*agrp) == NULL))
               skip = 1;                /* skip if not a listed group */

           if (skip == 0)
           {
               ans = fsd_get(fileDB, 2,36, fname);
               fname[ans] = '\0';
               f++;
               fprintf(file,"              Area %4.4d  %s\n", anum, fname);
           }

           if (f == 16)
             break;                     /* this is as many as we want */

           ans == fsd_curr(fileDB);
           if (ans == nfiles-1)
             break;                      /* end of file reached */
           fsd_posr(fileDB,1);           /* move to next record */
         }
         fclose(file);
       }
       fsd_close(fileDB);
       io_close(fileCH);
       fsd_close(fareaDB);
       io_close(fareaCH);
     }
     FreeSrvThg (CLNT, "pbox");
     return(0);
}
