/*
         Pbox scrollable line log - based on cview
*/

#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <stdarg.h>
#include <string.h>
#include <sys/stat.h>
#include "view.h"

long _stack = 8000;
extern short WinHgt;

long (*_cmdchannels) (long) = NULL;
long (*_stackchannels) (long) = NULL;
void (*_consetup)() = NULL;
long (*_conread) () = NULL;
long (*_conwrite) () = NULL;
char *_endmsg = NULL;

Prototype long lit_reset (struct WM_wwork *, short);

static long MMOVE (struct WM_wwork *, struct WM_litm *);
static long ACTRL (struct WM_wwork *, struct WM_appw *, struct WM_wstat *, short, short, short, short);
static long AHIT (struct WM_wwork *, struct WM_appw *, struct WM_wstat *, short, short, short);
static long ADRAW (struct WM_wwork *, struct WM_appw *);
static long AEXIT (struct WM_wwork *, struct WM_litm *);
static long APRINT (struct WM_wwork *, struct WM_litm *);
static long ASLEEP (struct WM_wwork *, struct WM_litm *);

static long lit_event (struct WM_wwork *, struct WM_litm *);

static struct WM_action afun = {JSR, wm_actli, lit_event};
static struct WM_action aexit = {JSR, wm_actli, AEXIT};
static struct WM_action adraw = {JSR, wm_drwaw, ADRAW};
static struct WM_action ahit = {JSR, wm_hitaw, AHIT};
static struct WM_action actrl = {JSR, wm_ctlaw, ACTRL};
static struct WM_action mmove = {JSR, wm_actli, MMOVE};
static struct WM_action aprint = {JSR, wm_actli, APRINT};
static struct WM_action asleep = {JSR, wm_actli, ASLEEP};

static WM_PWCB (1) ycb = {0};

static struct WM_wstat ws =     /* window status area */
{
    NULL,                       /* *wwork               point back to work def */
    NULL,                       /* *wdef                this was wdef */
    0,                          /* chid                 chan ID enclosing pointer */
    0, 0, 0,                    /* swnr, xpos, ypos     sub-window and ptr posn */
    0, 0,                       /* kstk, kprs           key stroke and press */
    0,                          /* evnt                 event vector */
    0, 0, 0, 0,                 /* xsiz, ysiz, xorg, yorg  */
    0, 0,                       /* ptpsx, ptpsy         pointer position (abs) */
    FORM_QL4, 0, 0,             /* wmode, 2 spare       window mode and spare */
    NULL,                       /* *ciact               current item "action" */
    -1,                         /* citem                current item */
    0, 0, 0,                    /* cibrw, cipap, cispr  current item attr */
    0, 0, 0, 0,                 /* cihxs,ys, cihxo,yo   current item hit area */
    {0, 0, 0, 0, 0, 0, 0, 0}    /* litem[40]            loose item status */
};

#define ninfw    2              /* number of information windows */
#define ninfo    1              /* number of information objects */
#define nlitm    5              /* number of loose items */
#define nappl    1              /* number of application sub-windows */

#define min_wid     264
#define min_hgt     86

static WM_WSCALE (ninfw + ninfo + nlitm + nappl) wsc =
{
    min_wid, min_hgt, 0, 0, 12, 10,
    {
        { 8, 0, 0, 0 },                 /* infw[0] scale width */
        { 0, 0, 4, 0 },                 /* infw[1] horiz centered */
        { 0, 0, 0, 0 },                 /* info[0] unscaled */
        { 0, 0, 0, 0 },                 /* litm[0] unscaled */
        { 0, 0, 0, 0 },                 /* litm[1] unscaled */
        { 0, 0, 0, 0 },                 /* litm[2] unscaled */
        { 0, 0, 8, 0 },                 /* litm[3] right justify */
        { 0, 0, 8, 0 },                 /* litm[4] right justify */
        { 8, 8, 0, 0}                   /* appw[0] fully scaled */
    }
};

static QD_TEXTI (END, "ESC");
static QD_TEXTI (VIEW, "Log 0     ");

static struct WM_info info[ninfo + 1] =
{
    {66, 10, 6, 0, 0, 0, 0, 0, 0, &VIEW},
    {-1}
};

static struct WM_infw infw[ninfw + 1] =         /* information window */
{
    {438-(26*5), 14,            /* xsize, ysize         size */
     26*3, 0,                   /* xorg, yorg           and origin */
     0,                         /* flag                 no clear + shadow */
     0, 0, CL_MFILL,            /* borw, borc, papr     border width/clr,paper */
     NULL},                     /* *pobj                pointer to object list */
    {78, 12,                    /* xsize, ysize         size */
     184, 1,                    /* xorg, yorg           and origin */
     0,                         /* flag                 no clear + shadow */
     0, 0, CL_MBACK,            /* borw, borc, papr     border width/clr,paper */
     info},                     /* *pobj                pointer to object list */
    {-1}                        /* end of array */
};

#define F3KEY   0xf0

extern struct WM_sprite wm_sprite_move, wm_sprite_size,
                        wm_sprite_f3, wm_sprite_sleep;

static struct WM_litm litm[nlitm + 1] =         /* loose item */
{
    {22, 10,   2, 2, 0, 0, 2, K_MOVE,   &wm_sprite_move,    0, &mmove},
    {22, 10,  28, 2, 0, 0, 2, K_SIZE,   &wm_sprite_size,    1, &afun},
    {22, 10,  54, 2, 0, 0, 2, K_SLEEP,  &wm_sprite_sleep,   2, &asleep},
    {22, 10, 388, 2, 0, 0, 2, F3KEY,    &wm_sprite_f3,      3, &aprint},
    {22, 10, 414, 2, 0, 0, 0, K_CANCEL, &END,               4, &aexit},
    {-1}
};

static struct WM_menw aw0 =     /* application sub-window */
{
    431, 142,                   /* xsize, ysize         size */
    4, 14,                      /* xorg, yorg           and origin */
    0,                          /* flag                 no clear + shadow */
    1, 4, 0,                    /* borw, borc, papr     border width/clr, paper */
    NULL,                       /* *pspr                pointer to sprite */
    &adraw,                     /* *draw                draw routine */
    &ahit,                      /* *hit                 hit routine */
    &actrl,                     /* *ctrl                control routine */
    0, 1,                       /* nxsc, nysc           max x,y sections */
    0, 0, 0,                    /* skey, 2 spare        selection keystroke */
    NULL,                       /* *pwcb            part window ctrl block */
    0, 0, 0, 0, 0, 0, NULL, NULL,       /* 6 short 2 pointer zero */
    7,0,7,                      /* psac, psbc, pssc arrow/bar clrs */
    &ycb,                       /* *pwcb            part window ctrl block */
    0, 0, 0, 0, 0, 0, NULL, NULL,       /* 6 short 2 pointer zero */
    7,0,7,                      /* psac, psbc, pssc arrow/bar clrs */
};

static struct WM_appl appl[nappl + 1] = {&aw0, NULL};

static struct WM_wwork ww =     /* window working definition */
{
    &ws,                        /* *wstat;              pointer to status area */
    &wsc,                       /* *wscale              this was pointer to WDEF */
    0,                          /* chid                 channel ID */
    NULL,                       /* *pprec               pointer to pointer record */
    0,                          /* psave                pointer position saved */
    0, 0, 0, 0,                 /* 4 zero */
    appl,                       /* *splst               pointer to sprite list */
    438, 158,                   /* xsize, ysize         size */
    0, 0,                       /* xorg, yorg           and origin */
    2,                          /* flag                    clear + shadow */
    1,4,7,                      /* borw, borc, papr     border width/clr, paper */
    NULL,                       /* *sprite              pointer to sprite */
    1, CL_MHIGH,                /* curw, curc           current item width/clr */
    CL_MPUNAV,CL_MIUNAV,NULL,NULL,  /* uback, uink, *ublob, *upatt  unavail */
    CL_MPAVBL,CL_MIAVBL,NULL,NULL,  /* aback, aink, *ablob, *apatt  avail */
    CL_MPSLCT,CL_MISLCT,NULL,NULL,  /* sback, sink, *sblob, *spatt  selected */
    NULL,                       /* *help */
    ninfw, ninfo, infw,         /* ninfo, ninob, *pinfo info winds */
    nlitm, litm,                /* nlitm, *plitm        loose items */
    nappl, appl                 /* nappl  *pappl        appl winds */
};

static int ChanId;
static int iline;
static PLEMT pHead;
static int NLine, TopL, BotL;
static short maxline;
static short working = 0;
static short subdraw = 0;
static short update = 0;
static short llen;
static int CVJob;
static int SubID = 0;
static short upbar = 0;

static DoText (struct WM_wwork *, int, int);
static ShowPct (struct WM_wwork *);
static void PReader (int);


/* Safe Hex */

void *xmalloc(size_t size)
{
    void *p;

    p = malloc(size);

    if(!p)
    {
        mt_susjb(-1, -1, NULL);
    }
}

long lit_reset (struct WM_wwork *wwk, short lit)
{
    wwk->wstat->litem[lit] = WSI_MKAV;  /* set make available */
    return wm_ldraw (wwk, -1);  /* and re-draw */

}

static long lit_event (struct WM_wwork *wwk, struct WM_litm *li)
{
    return li->skey + 14;       /* calculate event for selection key */
}

/* Refresh the application window after a hit
   You will be amazed by the complete lack of logic and structure here,
   so am I. But it's only a quick and dirty hack.
*/
Refresh ()
{
    int i;

    if (iline > 0)
    {
        int xb;

        xb = BotL;
        if (BotL + iline >= NLine)
        {
            iline = NLine - BotL;
            TopL = NLine - maxline;
            if(TopL < 0)
            {
                TopL = 0;
            }
            BotL = NLine;
        }
        else
        {
            TopL += iline;
            BotL += iline;
        }

        if (BotL != xb)
        {
            aw0.ypwcb->s[0].stt = TopL;
            wm_upbar (&ww, (struct WM_swdef *) &aw0, 0, 0);
            if (iline > maxline)
            {
                iline = maxline;
                sd_pos (ChanId, 1, 0, 0);
                sd_clear (ChanId, 1);
            }
            else
            {
                sd_scrol (ChanId, 1, -10);
                sd_pos (ChanId, 1, 0, maxline - 1);
            }
            DoText (&ww, BotL - iline, BotL);
        }
    }
    else if (iline < 0 && TopL)
    {
        int xt;
        int ml;

        xt = TopL;
        if (TopL + iline <= 0)
        {
            ml = TopL;
            TopL = 0;
            iline = -ml;
            BotL = maxline;
        }
        else
        {
            ml = TopL;
            TopL += iline;
            BotL += iline;
        }

        if (TopL != xt)
        {
            aw0.ypwcb->s[0].stt = TopL;
            wm_upbar (&ww, (struct WM_swdef *) &aw0, 0, 0);
            iline = -iline;
            if (iline > maxline)
            {
                iline = maxline;
                sd_pos (ChanId, 1, 0, 0);
                sd_clear (ChanId, 1);
                DoText (&ww, TopL, BotL);
            }
            else
            {
                for (i = 0; i < iline; i++)
                {
                    sd_pos (ChanId, 1, 0, 0);
                    sd_scrol (ChanId, 1, 10);
                    DoText (&ww, ml - i - 1, ml - i);
                }
            }
        }
    }
}

/*
 Get a pointer to a line number in the linked list of lines
*/

PLEMT GetPos (int pos)
{
    PLEMT pl;
    int i;

    for (pl = pHead, i = 0; i < pos && pl;  i++, pl = pl->next)
        ;       /* Null loop to find our line */

    return pl;
}

int DrawLine (struct QD_text *p)
{
    short nw;

    if (p->len > llen)
    {
        nw = llen;
    }
    else
    {
        nw = p->len;
    }
    io_sstrg (ChanId, 1, p->chrs, nw);
    sd_clrrt (ChanId, 1);
    io_sbyte (ChanId, 1, '\n');
}

/*
   Display text between top line (tl) and bottom (bl)
*/

static DoText (struct WM_wwork *wwk, int tl, int bl)
{
    int i,j;
    PLEMT sp;

    ShowPct (wwk);

    j = bl - tl;
    if(j > 0 && j <= maxline)   /* Sanity, should never happen ;-) */
    {
        sp = GetPos (tl);

        for (i = 0; (i < j) && sp ; sp = sp->next, i++)
        {   
            DrawLine (sp->line);
        }
    }
}

/*
   Show percentage in title bar
*/
 
ShowPct (struct WM_wwork *wwk)
{
    short pct;

    char ptxt[16];

    if(NLine)
    {
        pct = BotL * 100 / NLine;
    }
    else
    {
        pct = 100;
    }
    sprintf (ptxt, "%3d%%", pct);
    wm_swinf (wwk, (short) 1, 0);
    sd_pixp (wwk->chid, -1, 48, 0);
    sd_clrrt (wwk->chid, -1);
    io_sstrg (wwk->chid, -1, ptxt, (short) strlen(ptxt));
}

static long AEXIT (struct WM_wwork *wwk, struct WM_litm *li)
{
    lit_reset (wwk, li->item);
    exit (0);
}

/*
   Rethink the display. Something has moved !!!!
*/

ReThink (struct WM_wwork *wwk)
{
    int addon;

    aw0.nrow = NLine;
    maxline = aw0.ysize / 10;
    aw0.ypwcb->s[0].siz = maxline;
    addon = (NLine > maxline) ? maxline : NLine;
    BotL = TopL + addon;
    if (BotL > NLine)
    {
        BotL = NLine;
        TopL = BotL - maxline;
    }
    aw0.ypwcb->s[0].stt = TopL;

    DoText (wwk, TopL, BotL);
}

/*
   Draw action routine
   n.b. makes room for scroll bars (8 pixels)
*/

static long ADRAW (struct WM_wwork *wwk, struct WM_appw *apw)
{
    int addon;

    aw0.xsize -= 8;
    wm_swdef (wwk, apw, ChanId);
    llen = aw0.xsize / 6;
    ReThink (wwk);
    if (pHead != NULL)
       wm_index (wwk, (struct WM_swdef *) apw);
    return 0;
}

/*
   Hit routine, calculate displacement (iline) and set a DO event
   (From a keystroke in window event)
   entered every second
*/

static long AHIT (struct WM_wwork *wwk, struct WM_appw *apw,
                  struct WM_wstat *wst, short x, short y, short evnt)
{

    if (evnt == 1)
    {
        iline = 1;
    }
    else if (evnt == 2 || evnt == 0xd9)
    {
        iline = apw->ysize / 10 - 1;
    }
    else if (evnt == 0xd1)
    {
        iline = -apw->ysize / 10 + 1;
    }
    else if (evnt == 0xfc)
    {
        iline = -1;
    }
    else
    {
        iline = 0;
    }
    if (update)
    {

        /* Serious redisplay required */
        
        TopL = NLine;
        wwk->wstat->evnt |= PT_WAKE;
    }
    else if (iline)
    {
        wwk->wstat->evnt |= PT_DO;
    }
    if (upbar)
    {
        upbar = 0;
        wm_upbar (wwk, (struct WM_swdef *) apw, 0, 0);
    }
    return 50;
}

/*
   Ctrl routine, calculate displacement (iline) and set a DO event
   From a hit on the scroll bars.
*/

static long ACTRL (struct WM_wwork *wwk, struct WM_appw *apw,
                   struct WM_wstat *wst,
                   short bpos, short blen, short item, short evnt)
{
    int x;
    char txt[64];

    x = NLine * bpos / blen;
    iline = x - TopL;
    return PT__DO;
}

/*
  Sleep main job to avoid conflict with output from pipe reader
*/

Slumber ()
{
    while (subdraw)
    {
        mt_susjb (-1, 1, NULL);
    }
    if(SubID > 0)
    {
        mt_susjb(SubID, -1, NULL);
    }
}
Awaken()
{
    if(SubID > 0)
    {
        mt_reljb(SubID);
    }
}

static long ASLEEP (struct WM_wwork *wwk,  struct WM_litm *li)
{
    lit_reset (wwk, li->item);
    return PT__ZZZZ;
}

/*
   On the move, must redraw the window
*/

static long MMOVE (struct WM_wwork *wwk, struct WM_litm *li)
{
    short dx, dy;
    struct QLRECT rct;

    working = 1;
    Slumber ();                         /* This is probably VERY bad */
    wwk->wstat->evnt |= PT_WMOVE;       /* set event bit for wm_chwin */
    wm_chwin (wwk, &dx, &dy);   /* move window */
    aw0.xsize += 8;
    ADRAW (wwk, (struct WM_appw *) &aw0);
    Awaken();
    working = 0;
    return lit_reset (wwk, li->item);
}

static long APRINT (struct WM_wwork *wwk, struct WM_litm *li)
{
    working = 1;
    Slumber ();
    PrintView(wwk, pHead, NLine);
    Awaken();
    working = 0;
    return lit_reset (wwk, li->item);
}

static AddLine(char *txt, short res, char show)
{
PLEMT pn = NULL;
static PLEMT pTail = NULL;
char *ptr;
short nln;

    pn = xmalloc (sizeof (LEMT));
    if (pn)
    {
        /*
           We store data in QD_text format to avoid having to
           strlen when ever a display update is required.
        */

        nln = res + 1;
        if ((pn->line = (struct QD_text *) xmalloc (nln)) != NULL)
        {
            pn->line->len = res - 1;
            memcpy (pn->line->chrs, txt, pn->line->len);
            if (pHead == NULL)
            {
                pHead = pn;             /* must be a new list */
                pTail = pn;
            }
            else
            {
              if (show == 0)            /* add at head of list, history */
              {                         /* stores latest line first     */
                pn->next = pHead;
                pHead = pn;
              }
              else                      /* once history is all read,  */
              {                         /* store new lines on the end */
                pTail->next = pn;
                pn->next = NULL;
                pTail = pn;
              }
            }
            subdraw = 1;
            NLine++;

            /* It would be nice to display and update NLine in the title
               bar, but this is a bit expensive on a 68008 (and it's not
               our window anyway, so it's a bit messy).
            */
            if (!working && BotL == NLine - 1)
            {
                if (NLine > maxline)
                {
                  if (show)
                  {
                    sd_scrol (ChanId, 1, -10);
                    sd_pos (ChanId, 1, 0, maxline - 1);
                  }
                  upbar = 1;
                }
                TopL = NLine - maxline;
                BotL = NLine;
                if (TopL < 0)
                {
                    TopL = 0;
                }
                aw0.nrow = NLine;
                aw0.ypwcb->s[0].stt = TopL;

                if (show) DrawLine (pn->line);
            }
            else
            {
                update = 1;
            }
            subdraw = 0;
        }
    }
}

void PReader (int ipipe)
{
  char txt[512];
  char otxt[512];
  int res;
  otxt[0] = '\0';

  mt_prior(-1,100);

  while (1)                     /* quickly build list of all existing lines */
  {
    res = io_fline (ipipe, -1, txt, 512);
    if (res <= 1) break;
    if (strcmp(otxt,txt) != 0)              /* suppress duplicates */
    {
       strcpy(otxt,txt);                    /* keep most recent line */
       AddLine(txt, res,0);
    }
  }
  mt_prior(-1,1);               /* now slowly show new lines as they arrive */
  fs_pos(ipipe, 0, 0);
  res = io_fline (ipipe, -1,otxt, 512);

  while (1)
  {
      fs_pos(ipipe, 0, 0);                      /* reposition for new lines */
      res = io_fline (ipipe, -1, txt, 512);
      if (res > 1)
      {
        if (strcmp(otxt,txt) != 0)              /* suppress duplicates */
        {
           strcpy(otxt,txt);                    /* keep most recent line */
           AddLine(txt, res,1);
        }
      }
  }
}
main (int ac, char **av)
{
    PLEMT pl, pn = NULL;
    char *ptr;
    int i, ipipe;
    struct WM_wsiz *pwl;
    short lx = -1,ly = -1;
    int lno = 1;
    int file = 0;
    short hgt;
    short *sptr;
    char hist[] = "history_line0";
    char daughter[] = "Log 0";

    if (ac > 1)
    {
      ptr = av[1];
      if ( strchr("0123456789",*ptr) == NULL)
        file = 1;
      else
        lno = atoi(ptr);
    }
    if (file)
    {
      ptr = (char *)&VIEW.chrs[0];      /* change title to "Viewer" */
      strcpy(ptr,"Viewer ");
      VIEW.len = 6;
    }
    else
    {
      ptr = (char *)&VIEW.chrs[4];
      *ptr += lno;                /* change title to include line no */

      ptr = daughter;             /* and daughter job name */
      ptr += 4;
      *ptr += lno;

      ptr = hist;                 /* and history channel too */
      ptr += 12;
      *ptr += lno;
    }
    ww.chid = getchid (0);

    if (!wm_findv (ww.chid))
    {
        exit (-1);
    }

    pwl = GetLimits(&ww);       /* get max screen dimensions */

    sptr = &WinHgt;
    hgt  = *sptr;               /* height in lines of main menu window */

    hgt *= 10;                  /* 10 chars per line */
    hgt += (2+16+8);            /* allow for border & banner & shadow */

    if (hgt > (pwl->ysize))
       hgt = (pwl->ysize);      /* limit if necessary */

    hgt -= 8;                   /* allow for shadow */

    ww.ysize = hgt;
    hgt -= 16;                   /* allow for banner  */
    aw0.ysize = hgt;

    ChanId = io_open ("scr", 0);
    sd_setin(ChanId, -1, 7);
    sd_setpa(ChanId, -1, 0);
    sd_setst(ChanId, -1, 0);
    ws.wwork = &ww;             /* set cross reference */

    CVJob = getpid ();

    iline = 0;
    pHead = NULL;
    NLine = 0;
    TopL = BotL = 0;

/*
   Prime the part window control block
*/
    aw0.ypwcb->nsec = 1;
    aw0.ypwcb->s[0].pos = 0;
    aw0.ypwcb->s[0].stt = 0;
    aw0.nrow = NLine;

    lx = (pwl->xsize - ww.xsize)/2;
    ly = (pwl->ysize - ww.ysize)/2;

    wm_prpos (&ww, lx, ly);
    wm_wdraw (&ww);

    if (file)
      ipipe = io_open(av[1],1);
    else
      ipipe = io_open(hist,1);

    if (ipipe > 0)
    {
        SubID = jcall (PReader, daughter, 8, 8000, 1, ipipe);

        /* The PICK with WAKE forces the program into the app window
           HIT routine, which will then be called on a scheduled basis
           (due to its +ve return value) when the pointer is in the app
           window. This means we can poll various flags and update the
           scroll bar as necessary.
        */
        pick (ChanId, -1, CVJob, K_WAKE);
    }

    aw0.xsize += 8;
    ADRAW (&ww, (struct WM_appw *) &aw0);

    while (1)
    {
        wm_rptr (&ww);

        working = 1;
        Slumber ();

        if (ws.evnt & PT_ZZZZ)
        {
            aw0.xsize += 8;
            Awaken();
            TopL = 99999;               /* Ensure we redraw at the bottom */
            mt_prior(-1,1);             /* this is so button_pick notices us */
            menu_button (&ww, daughter);
            mt_prior(-1,8);
        }

        if (ws.evnt & PT_WSIZE)
        {
            aw0.xsize += 8;
            re_size (&ww, 1);
        }
        
        if (ws.evnt & PT_WAKE)
        {
            aw0.xsize += 8;
            ADRAW (&ww, (struct WM_appw *) &aw0);
            update = 0;
        }
        
        if (ws.evnt & PT_DO)
        {
            Refresh ();
        }
        
        Awaken();
        working = 0;
    }
    io_close (ChanId);
    wm_cluns (&ww);
    return (0);
}
