/* re-size functions */

#include <qdos.h>
#include <qptr.h>

void re_scale (struct WM_wwork *wwk, short *pdx, short *pdy);
void scale (struct WM_swdef *sw, char sc[], short dx, short dy);

/* We _must_ recalculate the maximum size of window before resize, SMS2 uses
   can redefine resolution without telling us.
*/
struct WM_wsiz *GetLimits(struct WM_wwork *wwk)
{
    static struct WM_wsiz wl;
    int sts;

    sts = iop_flim (wwk->chid, -1, &wl);

    wwk->wscale->xmax = 8 + ((wl.xsize - 12) / 6) * 6;
    wwk->wscale->ymax = 14 + ((wl.ysize - 16) / 10) * 10;
    return &wl;
}


/* general re-size function - returns error from re-draw */

long re_size (struct WM_wwork *wwk, short lit_size)
{
   short dx,dy;
   static struct WM_wsiz wl;
   int sts;

   sts = iop_flim (wwk->chid, -1, &wl);

   wwk->wscale->xmax = (wl.xsize - 12);
   wwk->wscale->ymax = (wl.ysize - 16);


   (void)wm_chwin (wwk,&dx,&dy);  /* read pointer move for size event */
   dx=-dx; dy=-dy;          /* our true sense of change size */

   wwk->wstat->litem[lit_size] = WSI_AVBL;  /* item available when we redraw */

   re_scale (wwk,&dx,&dy);   /* reset all the item sizes and positions */

   (void)wm_unset (wwk);          /* unset window because we are about to pr_pos */

   wwk->xorg=wwk->wstat->ptpsx - wwk->xorg;
   wwk->yorg=wwk->wstat->ptpsy - wwk->yorg;   /* set origin to window relative
                                                pointer position */
   (void)wm_prpos (wwk, (short)(wwk->wstat->ptpsx-dx), (short)(wwk->wstat->ptpsy-dy));
                 /* set new window position, keeping bottom right corner fixed
                   (ptpsx/ptpsy is old position)
                   ????? surely (short)-(short) should be (short) ????? */
   return wm_wdraw (wwk);
}

/* general re-scale function using the wscale structure: resets actual size
   change in *pdx, *pdy. */

void re_scale (struct WM_wwork *wwk, short *pdx, short *pdy)
{
   short newsz;
   int iscale;
   struct WM_wscale *sc;
   struct WM_infw *infw;
   struct WM_info *info;
   struct WM_litm *litm;
   struct WM_appl *appl;
   struct WM_appw *appw;

   sc=wwk->wscale;

   newsz = wwk->xsize + ( (*pdx+sc->xinc/2) / sc->xinc ) * sc->xinc;
                                            /* adjust by discrete increments */

   if (newsz > sc->xmax)      newsz = sc->xmax;        /* limit size */
   else if (newsz < sc->xmin) newsz = sc->xmin;

   *pdx  = newsz - wwk->xsize;                         /* the actual change */
   wwk->xsize = newsz;                                 /* set size */

   newsz = wwk->ysize + ( (*pdy+sc->yinc/2) / sc->yinc ) * sc->yinc;
                                            /* adjust by discrete increments */

   if (newsz > sc->ymax)      newsz = sc->ymax;        /* limit size */
   else if (newsz < sc->ymin) newsz = sc->ymin;

   *pdy  = newsz - wwk->ysize;                         /* the actual change */
   wwk->ysize = newsz;                                 /* set size */

   iscale=0;                        /* now follows a table of scale factors */

   if (infw=wwk->pinfo)
      while (infw->xsize >= 0)
      {
         scale ((struct WM_swdef *)infw, sc->s8[iscale++], *pdx, *pdy); /* scale info window */

         if (info=(infw++)->pobl)
            while (info->xsize >= 0)
               scale ((struct WM_swdef *)info++, sc->s8[iscale++], *pdx, *pdy); /* and objects */
       }

   if (litm=wwk->plitm)
      while (litm->xsize >= 0)
         scale ((struct WM_swdef *)litm++, sc->s8[iscale++], *pdx, *pdy); /* scale loose item */

   if (appl=wwk->pappl)
      while (appw=(appl++)->pappw)
         scale ((struct WM_swdef *)appw, sc->s8[iscale++], *pdx, *pdy);  /* scale app sub-window */
}

void scale (struct WM_swdef *sw, char sc[], short dx, short dy)
{
   if (sc[0]) sw->xsize += (dx * sc[0]) >> 3;
   if (sc[1]) sw->ysize += (dy * sc[1]) >> 3;
   if (sc[2]) sw->xorg  += (dx * sc[2]) >> 3;
   if (sc[3]) sw->yorg  += (dy * sc[3]) >> 3;
}
