#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <qdos.h>
#include <qptr.h>
#include "view.h"

#define TRUE 1
#define FALSE 0

Prototype void PrintView (struct WM_wwork *, PLEMT, int);

static int GetFileName (struct WM_wwork *, char *, char *, int, int, int);
static int exists (char *p);

void PrintView (struct WM_wwork *wwk, PLEMT pl, int nl)
{
    int n;
    static char prtname[40] = "prt";
    int chn;
    PLEMT pi;
    
    if(nl)
    {
        n = GetFileName (wwk, "Print To", prtname, 40, NEW_EXCL, 1);
        if (n > 0)
        {
            chn = io_open(prtname, NEW_EXCL);
            if(chn > 0)
            {
                for(pi = pl; pi; pi = pi->next)
                {
                    io_sstrg(chn, -1, pi->line->chrs, pi->line->len);
                    io_sbyte(chn, -1, '\n');
                }
                io_close(chn);
            }
        }
    }
    else
    {
        menu_choice(wwk, "No Lines Buffered", 1, 0, "OK");
    }
}

int GetFileName (struct WM_wwork *wwk, char *prompt, char *text,
                 int maxc, int type, int query)
{
    int done = 0;
    int n, k;
    char temp[80];

    /* save user buffer */

    strcpy (temp, text);
    do
    {
        n = menu_text (wwk, prompt, temp, maxc);
        if (n < 0)
        {
            done = TRUE;
        }
        else
        {
            if (type >= NEW_EXCL)
            {
                if (query == FALSE || type == NEW_EXCL)
                {
                    done = TRUE;
                    strcpy (text, temp);
                }
                else
                {
                    if (exists (temp))
                    {
                        k = menu_choice (wwk, "File exists, overwrite ?", 3, 1, "Yes", "No", "Quit");
                        if (k == 0)
                        {
                            done = TRUE;
                            strcpy (text, temp);
                        }
                        else if (k == 2)
                        {
                            done = TRUE;
                            n = -1;
                        }
                    }
                    else
                    {
                        done = TRUE;
                        strcpy (text, temp);
                    }
                }
            }
            else
            {
                if (exists (temp))
                {
                    done = TRUE;
                    strcpy (text, temp);
                }
                else
                {
                    k = menu_choice (wwk, "File not found", 2, 0, "OK", "Quit");
                    if (k == 1)
                    {
                        done = TRUE;
                        n = -1;
                    }
                }
            }
        }
    }
    while (!done);
    return n;
}

/* Could have used access() if it worked ;-{ */
    
static int exists (char *p)
{
    int chn;
    int sts = 0;

    if ((chn = io_open (p, OLD_SHARE)) > 0)
    {
        sts = 1;
        io_close (chn);
    }
    return sts;
}
