/*******************************************************************************
*
*   Given a main window defintion, and a title, this function creates a sleep
*   button (preferably in the button frame) and goes off to sleep.
*
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <qdos.h>
#include <qptr.h>

#include "view.h"

Prototype void menu_button (struct WM_wwork *, char *);

static long ASWAKE (struct WM_wwork *, struct WM_litm *, struct WM_wstat *,
            short, short, short, short);

static struct WM_action aswake = {JSR, wm_actli, ASWAKE};


void menu_button (struct WM_wwork *wwk, char *title)
{
    short sleep_wid;
    
#define ti_max 24
    static QD_TEXT (ti_max) _title = {0};

    static struct WM_wstat ws = {0};    /* this time ws is initialised in code */

    static struct WM_litm litm[1 + 1] = /* loose item */
    {
        {12, 10,                /* xsize, ysize         size */
         2, 1,                  /* xorg, yorg           and origin */
         0, 0,                  /* xjst, yjst           justification */
         TYP_TEXT, K_WAKE,      /* type, skey           type and select key */
         &_title,               /* *pobj                pointer to object */
         0,             /* item                 item number */
         &aswake},               /* *pact                pointer to action */

        {-1}                    /* end of array */
    };

    static struct WM_wwork ww = /* window working definition */
    {
        NULL,                   /* *wstat;              pointer to status area */
        NULL,                   /* *wscale              this was pointer to WDEF */
        0,                      /* chid                 channel ID */
        NULL,                   /* *pprec               pointer to pointer record */
        0,                      /* psave                pointer position saved */
        0, 0, 0, 0,             /* 4 zero */
        NULL,                   /* *splst               pointer to sprite list */

        16, 12,                 /* xsize, ysize         size */
        12, 8,                  /* xorg, yorg           and origin */
        0,                      /* flag                 no clear + shadow */
        1, CL_BBORD, CL_MBACK,  /* borw, borc, papr     border width/clr, paper */
        NULL,                   /* *sprite              pointer to sprite */

        1, CL_MHIGH,            /* curw, curc           current item width/clr */

        CL_MPUNAV, CL_MIUNAV, NULL, NULL,       /* uback, uink, *ublob, *upatt  unavail */
        CL_BPAVBL, CL_BIAVBL, NULL, NULL,       /* aback, aink, *ablob, *apatt  avail */
        CL_BPSLCT, CL_BISLCT, NULL, NULL,       /* sback, sink, *sblob, *spatt  selected */

        NULL,                   /* *help */

        0, 0, NULL,             /* ninfo, ninob, *pinfo info winds */
        1, litm,                /* nlitm, *plitm        loose items */
        0, NULL                 /* nappl  *pappl        appl winds */
    };

    ws.wwork = &ww;             /* cross references */
    ww.wstat = &ws;
    ww.chid = wwk->chid;                /* copy channel ID */
    ww.flag = 0;
    ws.wmode = FORM_QL4;

    QD_STXT (_title, title, ti_max);    /* title string */

    sleep_wid = (((_title.len * 6) + 3) & 0xfffc);      /* round up to multiple of 4 */

    ww.xsize = sleep_wid + 4;   /* allow for loose item border */
    ww.xorg = sleep_wid - 4;    /* pointer here */
    ww.yorg = 9;

    litm[0].xsize = sleep_wid;  /* set item size */
    ws.litem[0] = 0;            /* and status */

    ws.citem = -1;              /* no current item  */
    ws.ciact = NULL;            /* or current item routine */

    wm_unset (wwk);             /* unset old definition */

    if (bt_prpos (&ww))
    {
        ww.flag = 2;            /* ... no, use shadow */
        wm_prpos (&ww, DEFXY);
    }                           /*     and position at pointer */

    wm_wdraw (&ww);             /* and draw */

    while (!wm_rptr (&ww))
    {
        if (ws.evnt & PT_WAKE)
            break;
    }

    wm_unset (&ww);             /* unset button */

    if (!ww.flag)
    {
        bt_free ();
    }
    wwk->xorg = wwk->wstat->ptpsx - wwk->xorg;
    wwk->yorg = wwk->wstat->ptpsy - wwk->yorg;  /* set "origin" to window rel pos */

    wm_prpos (wwk, wwk->wstat->ptpsx, wwk->wstat->ptpsy);       /* old window position */
    wm_wdraw (wwk);             /* and draw */
}

static long ASWAKE (struct WM_wwork *wwk, struct WM_litm *li, struct WM_wstat *wst, short xpos, short ypos, short key, short event)
{
    if (event)
    {
        return PT__WAKE;        /* convert DO to WAKE */
    }
    if (wwk->flag)
    {
        short dx,dy;
        wwk->wstat->evnt |= PT_WMOVE;   /* set event bit for wm_chwin */
        wm_chwin (wwk, &dx, &dy);       /* move window */
        return 0;
    }
   return lit_reset (wwk, 0);   /* otherwise reset and return */
}
