/*******************************************************************************
*
*   Given a prompt, a QL_TEXT structure and its maximum length, this function
*   pulls down a text entry menu. The current contents of the QL_TEXT are
*   copied and written out. When the text has been edited, the function
*   returns the number of characters in the text.
*
*   An ESC returns -1 without changing the contents of the QL_TEXT.
*
*   This function is limited to a maximum text length of 60 (text_max) chars.
*
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <qdos.h>
#include <qptr.h>
#include "view.h"

Prototype struct QD_text *QSTRING (struct QD_text *, char *, int);
Prototype short menu_text (struct WM_wwork *, char *, char *, int);

struct QD_text *QSTRING (struct QD_text *s, char *t, int len)
{
    s->len = strlen (t);
    if (s->len > len)
    {
        s->len = len;
    }
    strncpy ((char *) s->chrs, t, s->len);
    *(s->chrs + s->len) = 0;
}


short menu_text (wwk, prompt, rtx, mxr)
struct WM_wwork *wwk;
char *prompt;
char *rtx;
int mxr;
{
    short pulld_wid, pr_wid, text_wid;
    long rcode;

#define text_max 72
    static QD_TEXT (text_max) _text = {0};

#define pr_max 60
    static QD_TEXT (pr_max) _prompt = {0};

#define pulld_min 48
#define pulld_hgt 25
#define bord_x 4

    struct WM_wstat ws;
    static struct WM_info info[1 + 1] = /* information objects */
    {
        {6, 10,                 /* xsize, ysize         size */
         (pulld_min - 6) / 2, 0,/* xorg, yorg           and origin */
         TYP_TEXT, 0,           /* type, spare          item type */
         {0, 0, 0},     /* ink, cwid, chgt      character attributes */
         &_prompt},              /* *pobj                pointer to object */

        {-1}                    /* end of array */
    };

    static struct WM_infw infw[2 + 1] = /* information window */
    {
        {pulld_min, 10,         /* xsize, ysize         size */
         bord_x, 1,             /* xorg, yorg           and origin */
         0,                     /* flag                 no clear + shadow */
         0, 0, CL_MBACK,        /* borw, borc, papr     border width/clr, paper */
         info},                  /* *pobj                pointer to object list */

        {pulld_min, 10,         /* xsize, ysize         size */
         bord_x, 13,            /* xorg, yorg           and origin */
         NO_WCLEAR,             /* flag                 no clear + shadow */
         1, 0, CL_MBACK,        /* borw, borc, papr     border width/clr, paper */
         NULL},                  /* *pobj                pointer to object list */

        {-1}                    /* end of array */
    };

    static struct WM_wwork ww = /* window working definition */
    {
        NULL,                   /* *wstat;              pointer to status area */
        NULL,                   /* *wscale              this was pointer to WDEF */
        0,                      /* chid                 channel ID */
        NULL,                   /* *pprec               pointer to pointer record */
        0,                      /* psave                pointer position saved */
        0, 0, 0, 0,             /* 4 zero */
        NULL,                   /* *splst               pointer to sprite list */

        pulld_min + bord_x * 2, pulld_hgt,      /* xsize, ysize */
        pulld_min, pulld_hgt - 4,       /* xorg, yorg           and origin */
        2,                      /* flag                 no clear + shadow */
        1, CL_MBORD, CL_MBACK,  /* borw, borc, papr     border width/clr, paper */
        NULL,                   /* *sprite              pointer to sprite */

        1, CL_MHIGH,            /* curw, curc           current item width/clr */

        CL_MPUNAV, CL_MIUNAV, NULL, NULL,       /* uback, uink, *ublob, *upatt
                                                 * unavail */
        CL_MPAVBL, CL_MIAVBL, NULL, NULL,       /* aback, aink, *ablob, *apatt avail */
        CL_MPSLCT, CL_MISLCT, NULL, NULL,       /* sback, sink, *sblob, *spatt
                                                 * selected */

        NULL,                   /* *help */

        2, 1, infw,             /* ninfo, ninob, *pinfo info winds */
        0, NULL,                /* nlitm, *plitm        loose items */
        0, NULL                 /* nappl  *pappl        appl winds */
    };

    QSTRING ((struct QD_text *) &_prompt, prompt, pr_max);      /* title string */

    QSTRING ((struct QD_text *) &_text, rtx, text_max); /* initial reply */

    pulld_wid = text_wid = mxr * 6;     /* first guess at width */

    pr_wid = (_prompt.len + 1) * 6;
    if (pr_wid > pulld_wid)
        pulld_wid = pr_wid;
    /* but make sure that there is enough room for the prompt */

    ww.xsize = pulld_wid + bord_x * 2;  /* allow an inner border on window */

    infw[0].xsize = pulld_wid;  /* size of title window */
    info[0].xsize = pr_wid - 6; /* size and position of */
    info[0].xorg = (pulld_wid - pr_wid) / 2 + 3;        /* .. title 1/2 char at left */

    infw[1].xsize = text_wid;
    infw[1].xorg = (pulld_wid - text_wid) / 2 + bord_x;

    ww.xorg = infw[1].xorg - 2;
    ww.yorg = infw[1].yorg + 8; /* text near pointer */

    ws.wwork = &ww;
    ww.wstat = &ws;

    ws.citem = -1;
    ws.ciact = NULL;

    wm_pulld (&ww, wwk->xorg + 50, wwk->yorg + 50);     /* pull down */
    wm_wdraw (&ww);

    wm_swinf (&ww, (short) 1, CL_IINK);

    rcode = wm_rname (ww.chid, (struct QD_text *) &_text);      /* read text */

    wm_cluns (&ww);             /* throw menu away */

    if (rcode)
    {
        return -1;
    }
    else
    {

        strncpy (rtx, (char *) _text.chrs, _text.len);
        *(rtx + _text.len) = '\0';
        return _text.len;
    }
}
