/*******************************************************************************
*
*   Given a prompt,  the number of loose items (1 to 6) and the loose item to
*   be pointed to (numbered from 0) followed by the appropriate number of item
*   strings (up to 20 characters), this function pulls down a confirmation menu.
*
*   An ESC returns -1, while a hit, do or selection by first character returns
*   the item number. Note: the first character of each item string should be
*   Upper Case.
*
*******************************************************************************/

#include <stdio.h>
#include <qdos.h>
#include <qptr.h>
#include <stdarg.h>
#include "view.h"

Prototype int menu_choice (struct WM_wwork *, char *, int, int, char *,...);

static long ACHOICE (struct WM_wwork *, struct WM_litm *, struct WM_wstat *);
static struct WM_action achoice = {JSR, wm_actli, ACHOICE};

int menu_choice (struct WM_wwork *wwk, char *prompt, int nlitm, int itptr, char *litm0,...)
{
    va_list nxlitm;
    char *itxt;
    int icount;
    short pulld_wid, pr_wid, lit_wid;

#define pr_max 60
    static QD_TEXT (pr_max) qprompt = {0};

#define litm_max 20
#define nlitm_max 6
    static QD_TEXT (litm_max) _litm[nlitm_max] = {0};

#define pulld_min 48
#define pulld_hgt 27
#define bord_x 4

    struct WM_wstat ws;         /* this time ws is initialised in code */

    static struct WM_info info[1 + 1] = /* information objects */
    {
        {6, 10,                 /* xsize, ysize         size */
         (pulld_min - 6) / 2, 0,/* xorg, yorg           and origin */
         TYP_TEXT, 0,           /* type, spare          item type */
         {0, 0, 0},             /* ink, cwid, chgt      character attributes */
         &qprompt},              /* *pobj                pointer to object */
        {-1}                    /* end of array */
    };

    static struct WM_infw infw[2 + 1] = /* information window */
    {

        {pulld_min, 12,         /* xsize, ysize         size */
         bord_x, 13,            /* xorg, yorg           and origin */
         0,                     /* flag                 no clear + shadow */
         1, 0, 127,             /* borw, borc, papr     border width/clr,
                                 * paper */
         NULL},                  /* *pobj                pointer to object
                                 * list */
        {pulld_min, 10,         /* xsize, ysize         size */
         bord_x, 1,             /* xorg, yorg           and origin */
         NO_WCLEAR,             /* flag                 no clear + shadow */
         0, 0, CL_MBACK,        /* borw, borc, papr     border width/clr,
                                 * paper */
         info},                  /* *pobj                pointer to object
                                 * list */

        {-1}                    /* end of array */
    };

    static struct WM_litm litm[nlitm_max + 1] = /* loose item */
    {
        {6, 10,                 /* xsize, ysize         size */
         4, 14,                 /* xorg, yorg           and origin */
         0, 0,                  /* xjst, yjst           justification */
         TYP_TEXT - 1, 0,       /* type, skey           type and select key */
         &_litm[0],             /* *pobj                pointer to object */
         0,                     /* item                 item number */
         &achoice},              /* *pact                pointer to action */

        {6, 10,                 /* xsize, ysize         size */
         4, 14,                 /* xorg, yorg           and origin */
         0, 0,                  /* xjst, yjst           justification */
         TYP_TEXT - 1, 0,       /* type, skey           type and select key */
         &_litm[1],             /* *pobj                pointer to object */
         1,                     /* item                 item number */
         &achoice},              /* *pact                pointer to action */

        {6, 10,                 /* xsize, ysize         size */
         4, 14,                 /* xorg, yorg           and origin */
         0, 0,                  /* xjst, yjst           justification */
         TYP_TEXT - 1, 0,       /* type, skey           type and select key */
         &_litm[2],             /* *pobj                pointer to object */
         2,                     /* item                 item number */
         &achoice},              /* *pact                pointer to action */

        {6, 10,                 /* xsize, ysize         size */
         4, 14,                 /* xorg, yorg           and origin */
         0, 0,                  /* xjst, yjst           justification */
         TYP_TEXT - 1, 0,       /* type, skey           type and select key */
         &_litm[3],             /* *pobj                pointer to object */
         3,                     /* item                 item number */
         &achoice},              /* *pact                pointer to action */

        {6, 10,                 /* xsize, ysize         size */
         4, 14,                 /* xorg, yorg           and origin */
         0, 0,                  /* xjst, yjst           justification */
         TYP_TEXT - 1, 0,       /* type, skey           type and select key */
         &_litm[4],             /* *pobj                pointer to object */
         4,                     /* item                 item number */
         &achoice},              /* *pact                pointer to action */

        {6, 10,                 /* xsize, ysize         size */
         4, 14,                 /* xorg, yorg           and origin */
         0, 0,                  /* xjst, yjst           justification */
         TYP_TEXT - 1, 0,       /* type, skey           type and select key */
         &_litm[5],             /* *pobj                pointer to object */
         5,                     /* item                 item number */
         &achoice},              /* *pact                pointer to action */

        {-1}                    /* end of array */
    };

    static struct WM_wwork ww = /* window working definition */
    {
        NULL,                   /* *wstat;              pointer to status
                                 * area */
        NULL,                   /* *wscale              this was pointer to
                                 * WDEF */
        0,                      /* chid                 channel ID */
        NULL,                   /* *pprec               pointer to pointer
                                 * record */
        0,                      /* psave                pointer position
                                 * saved */
        0, 0, 0, 0,             /* 4 zero */
        NULL,                   /* *splst               pointer to sprite
                                 * list */

        pulld_min + bord_x * 2, pulld_hgt,      /* xsize, ysize */
        pulld_min, pulld_hgt - 4,       /* xorg, yorg           and origin */
        2,                      /* flag                 no clear + shadow */
        1, CL_MBORD, 127,       /* borw, borc, papr     border width/clr,
                                 * paper */
        NULL,                   /* *sprite              pointer to sprite */

        1, CL_MHIGH,            /* curw, curc           current item
                                 * width/clr */

        CL_MPUNAV, CL_MIUNAV, NULL, NULL,       /* uback, uink, *ublob,
                                                 * *upatt unavail */
        CL_MPAVBL, CL_MIAVBL, NULL, NULL,       /* aback, aink, *ablob,
                                                 * *apatt avail */
        CL_MPSLCT, CL_MISLCT, NULL, NULL,       /* sback, sink, *sblob,
                                                 * *spatt selected */

        NULL,                   /* *help */

        2, 1, infw,             /* ninfo, ninob, *pinfo info winds */
        6, litm,                /* nlitm, *plitm        loose items */
        0, NULL                 /* nappl  *pappl        appl winds */
    };


    ws.wwork = &ww;             /* cross references */
    ww.wstat = &ws;

    QSTRING ((struct QD_text *) &qprompt, prompt, pr_max);      /* title string */

    for (va_start (nxlitm, itptr), icount = 0, lit_wid = 0;
         icount < nlitm; icount++)
    {
        itxt = va_arg (nxlitm, char *); /* generalised itxt=*nxlitm++ */
        QSTRING ((struct QD_text *) &_litm[icount], itxt, litm_max);    /* loose item string */
        if (_litm[icount].len > lit_wid)
            lit_wid = _litm[icount].len;
    }

    pulld_wid = (lit_wid * 6 + 10) * nlitm;     /* first guess at width */
    /* includes one character spare + loose item border for each item */

    pr_wid = (qprompt.len + 1) * 6;

    if (pr_wid > pulld_wid)
        pulld_wid = pr_wid;
    /* but make sure that there is enough room for the prompt */

    if (nlitm == 5)
        pulld_wid = ((pulld_wid + 9) / 10) * 10;
    /* nice size for 5 items */
    else
        pulld_wid = ((pulld_wid + 11) / 12) * 12;
    /* nice size for 1-4,6 */
    lit_wid = (pulld_wid / nlitm) - 4;  /* width of each item */

    ww.xsize = pulld_wid + (bord_x * 2);        /* allow inner border on
                                                 * window */
    ww.nlitm = (short) nlitm;   /* number of loose items */
    ww.xorg = itptr * (lit_wid + 4) + 8;        /* lit_wid pointer here */
    ww.yorg = pulld_hgt - 4;

    infw[0].xsize = pulld_wid;  /* size of title window */

    info[0].xsize = pr_wid - 6; /* size and position of */
    info[0].xorg = (pulld_wid - pr_wid) / 2 + 3;        /* .. title 1/2 char at
                                                         * left */
    infw[1].xsize = pulld_wid;

    for (icount = 0; icount < nlitm; icount++)
    {
        litm[icount].xsize = lit_wid;   /* set item size */
        litm[icount].xorg = bord_x + 2 + icount * (lit_wid + 4);        /* origin */
        litm[icount].skey = _litm[icount].chrs[0];      /* select key */
        ws.litem[icount] = 0;   /* and status */
    }
    litm[nlitm].xsize = -1;     /* ensure that there is a -1 at end of list */

    ws.citem = -1;              /* no current item  */
    ws.ciact = NULL;            /* or current item routine */
    ws.litem[nlitm_max] = -1;   /* preset ESC return */

    wm_pulld (&ww, wwk->xorg + 50, wwk->yorg + 50);     /* pull down */
    wm_wdraw (&ww);

    while (!wm_rptr (&ww))
    {
        if (ws.evnt & PT_CAN)
            break;
    }

    wm_cluns (&ww);             /* throw it away */

    return ws.litem[nlitm_max]; /* return code number */
}

static long ACHOICE (struct WM_wwork *wwk, struct WM_litm *li, struct WM_wstat *wst)
{
    wst->litem[nlitm_max] = li->item;   /* set item hit in status area */
    return PT__CAN;             /* and return CAN event */
}
