;
;   C68 Button frame routines
;
;       bt_frame        Put window into button frame
;       bt_free         Free button frame
;       bt_prpos
;
; Equivalent to C routines:
;
;   int bt_frame (chanid_t chan, swdef *sub_window)
;   int bt_prpos (wwork *sub_window)
;
; AMENDMENT HISTORY
; ~~~~~~~~~~~~~~~~~
;   First Version       Tony Tebby
;
;   31 Oct 93   DJW   - Added underscore to entry point name
;                     - Merged in bt_prpos_s file
;                     - Added check on WMAN vector being known

        .text
        .even

        .globl    _bt_frame
        .globl    _bt_free
        .globl    _bt_prpos

sys_thgl equ    $b8

th_thing equ    $10

thh_type equ    $04
thh_entr equ    $08

sw_xsize equ    $00
sw_xorg  equ    $04
sw_attr  equ    $08

wwa_clfg equ    $00
wwa_borw equ    $02
wwa_borc equ    $04
wwa_papr equ    $06

iow.defw equ    $0d
iow.clra equ    $20
iow.spap equ    $27
iow.sstr equ    $28
iop.outl equ    $7a
iopo.set equ      0

sms.info equ    $00
sms.uthg equ    $28
sms.fthg equ    $29

err.nimp equ    -19


bt_name: dc.w  12
         dc.b  'Button Frame'

;+++
;
; Allocate window in button frame.
; C68 call compatible.
;
; P0 = channel ID
; P4 = pointer to sub-window structure
;
; returns 0 OK, -ve QDOS error
;
; struct swdef
; {  short xsize;    /* X size */
;    short ysize;
;    short xorg;     /* X origin */          ----- origin is set
;    short yorg;     /* Y origin*/
;    char  clfg;     /* -128 if no clear, +1 if cursor keys */
;    char  shdd;     /* shadow depth */      ----- assumed 0
;    word  borw;     /* border width */
;    word  borc;     /* border colour */
;    word  papr;     /* paper colour */
;    char  *sprite;  /* pointer to sprite */ ----- not used
; }
;---
_bt_frame:
btf.frame equ   $08
btf_size equ    $00
btf_org  equ    $04
stk_chan equ    $18
stk_swdf equ    $1c

        movem.l d2/d3/a2,-(sp)
        subq.l  #btf.frame,sp

        move.l  stk_swdf(sp),a0          ; (sub-)window definition
        bsr     btf_use                 ; use thing
        bne     btf_exit

        lea     btf_org(sp),a1
        move.l  d2,(a1)                  ; set origin
        add.l   d7,d2                    ; and adjusted
        move.l  d2,sw_xorg(a2)           ; ... in call structure

        move.l  stk_swdf(sp),a2
        move.l  sw_xsize(a2),d0
        add.l   d2,d0
        add.l   d2,d0                    ; larger size
        move.l  d0,-(a1)

        moveq   #0,d1
        moveq   #iopo.set,d2
        move.l  stk_chan(sp),a0
        moveq   #iop.outl,d0             ; set outline
        bsr     btf_trap3
        bne     btf_exit

        move.b  sw_attr+wwa_borw+1(a3),d2
        move.b  sw_attr+wwa_borc+1(a3),d1
        moveq   #iow.defw,d0             ; window and border
        bsr     btf_trap3
        bne     btf_exit

        move.b  sw_attr+wwa_papr+1(a3),d1; paper
        moveq   #iow.spap,d0
        bsr     btf_trap3
        bne     btf_exit

        move.b  sw_attr+wwa_papr+1(a3),d1; paper / strip
        moveq   #iow.sstr,d0
        bsr     btf_trap3
        bne     btf_exit

        tst.b   sw_attr+wwa_clfg(a3)     ; clear window?
        blt     btf_exit                 ; ... no

        moveq   #iow.clra,d0
        bsr     btf_trap3

btf_exit:
        addq.l  #btf.frame,sp
btf_exf:
        movem.l (sp)+,d2/d3/a2
        rts


btf_trap3:
        moveq   #-1,d3
        trap    #3
        tst.l   d0
        rts

;+++
; long bt_free()
;
; Free button frame.
; C68 call compatible.
;
; returns 0 OK, -ve QDOS error
;
;---
_bt_free:
        movem.l d2/d3/a2,-(sp)
        bsr     btf_look
        bne     btf_exf

        lea     bt_name,a0
        moveq   #-1,d1
        moveq   #sms.fthg,d0             ; free button frame
        jsr     (a2)
        bra     btf_exf


WM.PRPOS equ    $0c

WW_XSIZE equ    $20
WW_XORG  equ    $24
WW_WATTR equ    $28

SAVEREG equ 8+4                 ; size of saved registers + return address

_bt_prpos:
        movem.l d2/a4,-(sp)
        move.l  0+SAVEREG(sp),a4
        lea     WW_XSIZE(a4),a0          ; window definition

        jsr     btf_use                  ; use thing
        bne     btp_exit

        clr.w   WW_WATTR(a4)             ; clear flags / shadow

        add.l   d2,d1                    ; position of inside window
        add.l   WW_XORG(a4),d1           ; position of origin

        jsr     __wm_chkv
        bmi     btp_exit
        move.l  d0,a0
        jsr     WM.PRPOS(a0)             ; position

btp_exit:
        movem.l (sp)+,d2/a4
        rts


;+++
; btf_use: internal service
;
; d1  r   border adjust
; d2  r   origin
; a0 c  s pointer to sub-window definition
;
; returns 0 OK, -ve QDOS error
;
btf_use:
stu_swdf equ    $08

        movem.l d3/d7/a0/a2,-(sp)
        bsr     btf_look                 ; find thing
        bne     btu_exit		 ;; JH BUG FIX

        move.l  stu_swdf(sp),a0
        move.l  sw_xsize(a0),d2          ; size
        move.w  sw_attr+wwa_borw(a0),d1
        move.w  d1,d7
        add.w   d1,d7
        swap    d7
        move.w  d1,d7
        add.l   d7,d2
        add.l   d7,d2                    ; including border

        moveq   #0,d3                    ; new position
        lea     bt_name,a0
        moveq   #-1,d1
        moveq   #sms.uthg,d0             ; use button frame
        jsr     (a2)
        move.l  d7,d1                    ; border adjust
btu_exit:
        movem.l (sp)+,d3/d7/a0/a2
        tst.l   d0
        rts




btf_look:
        moveq   #sms.info,d0             ; get system variables
        trap    #1
        move.l  sys_thgl(a0),d1          ; this is the Thing list
        beq     btf_nf                   ; empty list, very bad!
        move.l  d1,a0
btf_lp:
        move.l  (a0),d1                  ; get next list entry
        beq     btf_found                ; end of list? Here should be THING!
        move.l  d1,a0                    ; next link
        bra     btf_lp
btf_found:
        move.l  th_thing(a0),a0          ; get start of Thing
        move.l  thh_type(a0),d1          ; is it our special THING?
        addq.l  #1,d1
        bne     btf_nf                   ; sorry, it isn't
        move.l  thh_entr(a0),a2          ; this is the vector we look for
        rts
btf_nf:
        moveq   #err.nimp,d0             ; no thing
        rts
