 /*
        Menu   - play a menu file and get a response for exitmsg
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <csrvthg.h>
#include <database.h>
#include "win2_pbox_s_pserve_translates_h"

char _prog_name[] = "Pbox Menu";
char _version[] = "v1.21";
long ipch;                      /* input channel  */
long opch;                      /* output channel */
long mono;
long timeout=0;                 /* inactivity timeout */
char inactive[82];
char yesno[6];
char exitmsg[82];
char sysdir[82];
char errfile[82];
char presskey[82];
char errmenu_msg[82];
char yhave_msg[82];
char remain_msg[82];
char notime_msg[82];
char logmsg[82];
char mname[82];
char mfile[82];
char menudir[32];
char powers[42];
char mtype[2];
char mlab[4];
char tempbuff[102];
char keylab[] = ":keys";
int menupos = 0;
int keyspos = 0;
char keys[32];
char eoline[2];
int  line = 0;
int  lf_eol = 0;
char lf[] = { '\r', '\n' };
char rbo[] = { 0x08, ' ', 0x08 };
char term;
char lang[2];
int  loglevel;

/*---------------------------------------------------------------------------*/
int field1(long dbid,char *rec, struct fld_list fldef[],char *appcn)
/*
        search the database for field 1 = required name
        return: 1 = match;  0 = no match.
*/
{
   struct QLSTR *string;
   int stln;
 
   dbid = dbid; /* keep compiler happy */
   /* make a pointer to field 1 */
   string = (struct QLSTR *) (rec + fldef[1].fld_ptr);
   stln = strlen(appcn);
   if (stln != string->qs_strlen)  return(0);
   return(strnicmp(string->qs_str,appcn,stln) == 0);

}
/*---------------------------------------------------------------------------*/
int field2(long dbid,char *rec, struct fld_list fldef[],char *appcn)
/*
        search the database for field 2 = required name
        return: 1 = match;  0 = no match.
*/
{
   struct QLSTR *string;
   int stln;
 
   dbid = dbid; /* keep compiler happy */
   /* make a pointer to field 2 */
   string = (struct QLSTR *) (rec + fldef[2].fld_ptr);
   stln = strlen(appcn);
   if (stln != string->qs_strlen)  return(0);
   return(strnicmp(string->qs_str,appcn,stln) == 0);

}
/*---------------------------------------------------------------------------*/
/* reverse string s in place */
void reverse(char s[])
{
  int i,j;
  char c;
  for(i=0, j=strlen(s)-1; i<j; i++, j-- )
  {
    c = s[i];
    s[i] = s[j];
    s[j] = c;
  }
}
/*---------------------------------------------------------------------------*/
void ltoa(long n, char s[])     /* convert long integer to ascii string */
{
 int i, sign;

 if ((sign = n) < 0 )
    n = -n;
 i = 0;
 do {
       s[i++] = (char)(n % 10 + '0');
    }  while ((n /= 10) > 0);
 if (sign < 0)
    s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}
/*---------------------------------------------------------------------------*/
void translate(char *p, char t)
{
/*
        Translate any accented characters in the string pointed to by p
        The string conversion table is type 't' where
        1 = QL to ANSI
        2 = QL to PC8
        3 = QL to ASCII
        4 = ANSI to QL
        5 = PC8 to QL
        6 = ASCII to QL (void)
        7 to 9 are the same as 1 to 3, but operate on chars 128 to 178 only
*/
unsigned char *c;
unsigned char *f = p;
unsigned char ch = 1;

        if ((t == 1) || (t == 7))
          c = &QL_ANSI[0];
        else if ((t == 2) || (t == 8))
          c = &QL_PC8[0];
        else if ((t == 3) || (t == 9))
          c = &QL_ASCII[0];
        else if (t == 4)
          c = &ANSI_QL[0];
        else if (t == 5)
          c = &PC8_QL[0];
        else if (t == 6)
          return;
        else
          return;

        if ( t < 7)
        {
          while (ch != 0)
          {
            ch = *f;
            *f = *(c + ch);
            f++;
          }
        }
        else
        {
          while (ch != 0)
          {
            ch = *f;
            if ((ch > 127) && (ch < 179))
              *f = *(c + ch);
              f++;
          }
        }
}
/*--------------------------------------------------------------------------*/
void vt100(char *line)
{
char *n;
char *s;
char out[502];
char out2[502];
int  byt,hide;
long ch,e;
char buff[502];
/*
        Process keypresses, changing invalid ones to a space
*/
     out[0] = '\0';                     /* nul string so far */
     s = line;                          /* start at beginning */
     hide = 0;
     if (*line == '')
       hide = 1;
     while(1)
     {
       n = strchr(s,'');               /* any more processing to do ? */
       if(n == NULL)
       {
         strcat(out,s);                 /* add remainder of line */
         break;
       }
       *n = '\0';                       /* terminate here */
       strcat(out,s);                   /* add this bit of line */
       n++;                             /* point to power required */
       if(strchr(powers,*n) == NULL)
         strcat(out," ");               /* not allowed */
       else
       {
         tempbuff[0] = *(n+1);
         tempbuff[1] = '\0';
         strcat(out,tempbuff);              /* allowed */
         strcat(keys,tempbuff);             /* add key to list */
       }
       s = n+2;
     }
   if (hide == 0)
   {
/*
        Process codes in curly braces
*/
     out2[0] = '\0';                    /* nul string so far */
     s = out;                           /* start at beginning */
     while(1)
     {
       n = strchr(s,'{');               /* any more processing to do ? */
       if(n == NULL)
       {
         strcat(out2,s);                /* add remainder of line */
         break;
       }
       *n = '\0';                       /* terminate here */
       strcat(out2,s);                  /* add this bit of line */
       n++;                             /* point to byte code */

       if (isdigit(*n))                 /* it's a char code */
       {
         byt = atoi(n);                 /* get it as an int */
         tempbuff[0] = byt;
         tempbuff[1] = '\0';
         strcat(out2,tempbuff);         /* add to string */
         s = strchr(n,'}');
         if(s == NULL)                  /* no terminating '}' */
           break;
         s++;                           /* continue processing after '}' */
       }
       else                             /* not a digit */
       {
         translate(out2,term);
         io_sstrg(opch,-1,out2,strlen(out2)-1);    /* print line so far */
         if (mono)
         io_sstrg(mono, 0,out2,strlen(out2)-1);    /* print line so far */
         out2[0] = '\0';                /* no line to process now */
         strcpy(buff,n);                /* copy filename */
         s = strchr(buff,'}');          /* replace terminator */
         if (s != NULL)
         {
           *s = '\0';
           ch = io_open(buff,1);        /* open file to send */
           if (ch > 0)
           {
             while(1)
             {
               e = io_fstrg(ch,-1,buff,500);   /* read upto a buffer full */
               if(e < 0)
                  break;
               if (mono)
               io_sstrg(mono, 0,buff,e);   /* write it to monitor */
               e = io_sstrg(opch,-1,buff,e);   /* and write it to ser */
             }
           }
           if (ch > 0)
              (void)io_close(ch);
         }
         s = strchr(n,'}');             /* do rest of line */
         if(s == NULL)                  /* no terminating '}' */
           break;
         s++;
       }
     }                                  /* end while */
/*
        Process translations for non-ansi screens
*/
     translate(out2,term);
     io_sstrg(opch,-1,out2,strlen(out2)-1);    /* print result */
     io_sstrg(opch,-1,lf,2);
     if (mono)
     {
     io_sstrg(mono, 0,out2,strlen(out2)-1);    /* print result */
     io_sstrg(mono, 0,lf,2);
     }
   } /* if not hidden */
}
/*--------------------------------------------------------------------------*/
char getkey(void)
/* fetch a key or timeout, ignoring line feeds if appropriate */
{
char c;
int ferr,tmo;

  tmo = timeout;
  while(1)
  {
    ferr = io_fbyte( ipch, 50, &c );
    if (ferr == 0)              /* if you got a byte, return it, */
    {
      if (lf_eol)               /* if eol code is line-feed */
         return(c);             /* return whatever you got */
      else                      /* if CR or CR/LF is eol code */
        if (c != '\n')          /* ignore LFs on the assumption */
           return(c);           /* it's from a CR/LF pair */
    }
    if (ferr == -1)             /* not complete, */
    {
      if(tmo > 0)               /* if not infinite timeout */
      {
        tmo--;
        if(tmo == 0)            /* see if timed out yet */
           return(0);
      }
    }
    if (ferr < -1)
        return(0);              /* catch xmit error, eof etc. */
  }
}

/*--------------------------------------------------------------------------*/
int readline (char *buff, int max)
{
int len;
char  *ptr = buff;
char  c;

   len = strlen(buff);

   while (len > 0)                        /* show any initial text */
   {
     (void)io_sbyte(opch,-1,*ptr);
     if (mono)
     (void)io_sbyte(mono, 0,*ptr);
     ptr++;
     len--;
   }
   len = strlen(buff);
   while(1)
   {
     c = getkey();
     if (c == 0) exit(-10);     /* eof or timeout */
     if (c == eoline[0])
     {
        *ptr = '\0';
        (void)io_sstrg(opch,-1,lf,2);
        if (mono)
        (void)io_sstrg(mono, 0,lf,2);
        return(len);
     }
     if (c == 0)  return(-1);           /* or timeout */
     *ptr = c;
     switch(c)
     {
       case 0x9b:       /* esc with msb set */
       case 27:         /* esc */
         c = getkey();  /* strip following char */
         c = 8;         /* and drop through to delete */
       case 8:
       case 127:
         if (len == 0)
         {
           (void)io_sstrg(opch,-1,rbo,3);
           if (mono)
           (void)io_sstrg(mono, 0,rbo,3);
         }
         if (len > 0)
         {
           (void)io_sstrg(opch,-1,rbo,3);
           if (mono)
           (void)io_sstrg(mono, 0,rbo,3);
           ptr--;
           len--;
         }
         break;
       default:
         (void)io_sbyte(opch,-1,c);
         if (mono)
         (void)io_sbyte(mono, 0,c);
         ptr++;
         len++;
         if (len == max)  return(-2); /* buffer full */
         break;
     }
   }
}
/*--------------------------------------------------------------------------*/
void sysmsg(char *varname, char *ans, int sz)
{
char msg[80];
char lno[4];
char *a;
short rlen;

  sprintf(msg,"sysmsg %d %s",line,varname);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen < sz) sz = rlen;
    strncpy(ans,a,sz);
    ans[sz] = '\0';
    free(a);
  }
}
/*--------------------------------------------------------------------------*/
void getline(char *varname, char *ans, int sz)
{
char msg[80];
char lno[4];
char *a;
short rlen;

  sprintf(msg,"getline %d %s",line,varname);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen < sz) sz = rlen;
    strncpy(ans,a,sz);
    ans[sz] = '\0';
    free(a);
  }
}
/*--------------------------------------------------------------------------*/
void sysvar(char *varname, char *ans, int sz)
{
char msg[80];
char *a;
short rlen;

  sprintf(msg,"sysvar %s",varname);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen < sz) sz = rlen;
    strncpy(ans,a,sz);
    ans[sz] = '\0';
    free(a);
  }
}
/*--------------------------------------------------------------------------*/
void log(int level, char *value)
{
char msg[80];
char lno[4];
char *a;
short rlen;

 if((loglevel & level) || (level == 0))
 {
  sprintf(msg,"log %d %s",line,value);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a != NULL) free(a);
 }
}
/*--------------------------------------------------------------------------*/
void setline(char *value)
{
char msg[80];
char lno[4];
char *a;
short rlen;

  sprintf(msg,"setline %d %s",line,value);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a != NULL) free(a);
}
/*--------------------------------------------------------------------------*/
int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
long flch = -1;                 /* file ID        */
char *a;
int n = -1;
char mline[502];
char reply[502];
char fname[42];
short rlen;
int ferr;
char key;
int f;
int tleft;
int start;
char *t;

    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    if (nc != 2) exit(-15);     /* abort if no channels */
    ipch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    opch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;
    a = sp+mlen;
    *a = '\0';

    if(mlen == 0)
      exit(-15);
    while(*sp == ' ')
       sp++;                                    /* skip leading whitespace */
    if(strchr(sp,' ') == NULL)
       strcpy(mname,"MAIN");                    /* default to main menu */

    line = atoi(sp);                            /* 1st param is line number */
    while(*sp != ' ') sp++;                     /* skip past number */
    while(*sp == ' ') sp++;                     /* and whitespace */
    strncpy(mname,sp,30);                       /* and read rest of command */

    if((n=UseSrvThg (CLNT, "pbox")) == 0)
    {
       t = Request ("pbox","sysvar loglevel",-1,&rlen);
       if (t == NULL)
         loglevel = 0xffff;
       else
       {
         t[rlen] = '\0';
         if (*t == '-')
           loglevel = 0xffff;
         else
           loglevel = atoi(t);
         free(t);
       }
       sprintf(reply,"%s %s",_prog_name,_version);
       log(1,reply);

      sysvar("sysdir", sysdir, sizeof(sysdir)-1);
      if(line == 0)
        sysvar("inactive0", inactive, sizeof(inactive)-1);
      else
        sysvar("inactive", inactive, sizeof(inactive)-1);
      if(inactive[0] != '-')
        timeout = atol(inactive);
      if(timeout==0) timeout = -1;
      sysvar("menu_dir", menudir, sizeof(menudir)-1);
      strcpy(keys,":");
      getline("eoli", eoline, 1);
      lf_eol = (eoline[0] == '\n');
      getline("char", reply, 1);
      term = reply[0];
      term -= '0';
      term += 6;                /* menus only translate some characters */
      getline("lang", lang, 1);
      getline("powe", powers, sizeof(powers)-1);
      getline("menu", mtype, 1);
      getline("mono",reply,12);
      mono = atoi(reply);
      sysmsg("errmenu",errmenu_msg,sizeof(errmenu_msg)-1);
      sysmsg("yhave",yhave_msg,sizeof(yhave_msg)-1);
      sysmsg("remain",remain_msg,sizeof(remain_msg)-1);
      sysmsg("notime",notime_msg,sizeof(notime_msg)-1);

      if(sysdir[0] == '\0')
      {
        log(32,"-Error unable to access sysdir");
        FreeSrvThg (CLNT, "pbox");
        exit(0);
      }
      for( f=0; f < strlen(mname); f++) /* make menu name uppercase */
        mname[f] = toupper(mname[f]);

      strcpy(mfile,mname);              /* keep a copy */
      sprintf(fname,"%s%s%c",menudir,mname,lang[0]);

      ferr = 0;   /* signal 'no error' (yet) */
      flch = io_open(fname,1);          /* try to open correct language file */
      if (flch < 0)
      {
        strcpy(logmsg,"No \"");
        strcat(logmsg,fname);
        strcat(logmsg,"\" trying \"");
        a = fname;
        a += strlen(fname);
        a -= 1;
        *a = '0';                       /* if it fails, try language 0 */
        strcat(logmsg,fname);
        strcat(logmsg,"\"");
        log(32,logmsg);
        flch = io_open(fname,1);
      }
      if (flch < 0)
      {
        *a = '\0';
        flch = io_open(fname,1);        /* if that fails, try no language */
      }
      if (flch < 0)                     /* if it still fails, give up */
      {
        sprintf(reply, "-Error unable to open \"%s\"",fname);
        log(32,reply);
        exit(-7);
      }
      else
      {
         mlab[0] = ':';
         if(mtype[0] == '2')            /* generate type 2 menu from type 1 */
           mlab[1] = '1';
         else if(mtype[0] == '9')       /* generate type 9 menu from type 1 */
           mlab[1] = '1';
         else
           mlab[1] = mtype[0];          /* anything else, use real type */
         mlab[2] = '\0';
         if(powers[0] == '-')
           strcpy(powers,"A");          /* lowest powers */

         menupos = 0;
         keyspos = 0;
         while(1)
         {
           ferr = io_fline(flch,-1,mline,500);   /* read a menu line */
           if(ferr < 0)
             break;
           mline[ferr] = '\0';
           if(strnicmp(mline,mlab,2) == 0)
             menupos = fs_pos(flch,0,1);        /* this is where menu starts */

           if(strnicmp(mline,keylab,strlen(keylab)) == 0)
             keyspos = fs_pos(flch,0,1);        /* this is where keys start */

           if((menupos != 0) && (keyspos != 0))
             break;
         }
         if(menupos == 0)
         {
            strcpy(logmsg,"No \"");
            strcat(logmsg,mlab);
            strcat(logmsg,"\" trying menu 0");
            log(32,logmsg);
            fs_pos(flch,0,0);   /* rewind to file start */
            mlab[1] = '0';      /* use menu 0 if the real one is missing */
            mtype[0] = '0';
            while(1)
            {
              ferr = io_fline(flch,-1,mline,500);   /* read a menu line */
              if(ferr < 0)
                break;
              mline[ferr] = '\0';
              if(strnicmp(mline,mlab,2) == 0)
                menupos = fs_pos(flch,0,1);        /* this is where menu starts */

              if(strnicmp(mline,keylab,strlen(keylab)) == 0)
                keyspos = fs_pos(flch,0,1);        /* this is where keys start */

              if((menupos != 0) && (keyspos != 0))
                break;
            }
         }
         if((keyspos == 0) || (menupos == 0))    /* bad menu file! */
         {
            strcpy(logmsg,"No \"");
            if(keyspos == 0)
              strcat(logmsg,keylab);
            else
              strcat(logmsg,mlab);
              strcat(logmsg,"\" found");
            log(32,logmsg);
            if (mono)
            {
            io_sstrg(mono,  0, errmenu_msg, strlen(errmenu_msg));
            io_sstrg(mono,  0, lf, 2);
            }
            io_fbyte(ipch,100,&key);      /* give user time to read it */
            setline("exitcmd - menu_prg prev");
            exit(-15);
         }
         fs_pos(flch,menupos,0);        /* start here */
         switch(mtype[0])
         {
          case '0':                     /* VT100 ascii full page menu */
          case '3':                     /* ANSI colour full page menu */
                while(1)
                {
                  ferr = io_fline(flch,-1,mline,500);   /* read a menu line */
                  if(ferr < 0)
                  {
                    if (mtype[0] == '0')
                      log(32,"Type 0 EOF");
                    else
                      log(32,"Type 3 EOF");
                    exit(-15);
                  }
                  mline[ferr] = '\0';
                  if(mline[0] == ':')           /* end of page */
                     break;
                  if(ferr < 2)
                  {
                    io_sstrg(opch,-1,lf,2);
                    if (mono)
                    io_sstrg(mono, 0,lf,2);
                  }
                  else
                    vt100(mline);               /* process the line */
                }
                break;
          case '1':                             /* short description */
                mline[0] = '\0';
                while(1)
                {
                  ferr = io_fline(flch,-1,reply,500);   /* read a menu line */
                  if(ferr < 0)
                  {
                    log(32,"Type 1 EOF");
                    exit(-15);
                  }
                  reply[ferr-1] = '\0';
                  if(ferr > 1)
                  {
                    if(reply[0] == ':')      /* end of page */
                       break;
                    if(strchr(powers, reply[0]) != NULL)
                    {                           /* if user has access */
                      tempbuff[0] = reply[1];
                      tempbuff[1] = '\0';
                      strcat(keys,tempbuff);        /* add key to list */
                      if(strlen(reply) > 2)
                      {
                        strcat(mline,&reply[2]); /* add text to line */
                        strcat(mline,", ");
                      }
                    }
                  }
                }
                a= &mline[0];
                a += strlen(mline);
                a -= 2;
                if(*a == ',')           /* knock off last ", " */
                  *a = '\0';
                a = &mline[0];
                while(1)                        /* split into lines */
                {
                  if(strlen(a) < 78)
                    break;
                  for(f=77; f>0; f--)
                  {
                    if(*(a+f) == ',')
                    {
                      *(a+f) = '\r';          /* patch in line feed */
                      *(a+f+1) = '\n';        /* and carriage return */
                      a += f+2;
                      f=0;
                    }
                  }
                }
                translate(mline ,term);
                io_sstrg(opch,-1,lf,2);
                io_sstrg(opch,-1,mline,strlen(mline));
                io_sstrg(opch,-1,lf,2);
                if (mono)
                {
                io_sstrg(mono, 0,lf,2);
                io_sstrg(mono, 0,mline,strlen(mline));
                io_sstrg(mono, 0,lf,2);
                }
                break;
          case '2':                     /* just keypresses */
                mline[0] = '\0';
                while(1)
                {
                  ferr = io_fline(flch,-1,reply,500);   /* read a menu line */
                  if(ferr < 0)
                  {
                    log(32,"Type 2 EOF");
                    exit(-15);
                  }
                  reply[ferr] = '\0';
                  if(ferr > 1)
                  {
                    if(reply[0] == ':')      /* end of page */
                       break;
                    if(strchr(powers, reply[0]) != NULL)
                    {                           /* if user has access */
                      tempbuff[0] = reply[1];
                      tempbuff[1] = '\0';
                      strcat(keys,tempbuff);        /* add key to list */
                      tempbuff[1] = ' ';
                      tempbuff[2] = '\0';
                      strcat(mline,tempbuff);     /* add initial to line */
                    }
                  }
                }
                io_sstrg(opch,-1,lf,2);
                io_sstrg(opch,-1,mline,strlen(mline));
                io_sstrg(opch,-1,lf,2);
                if (mono)
                {
                io_sstrg(mono, 0,lf,2);
                io_sstrg(mono, 0,mline,strlen(mline));
                io_sstrg(mono, 0,lf,2);
                }
                break;
          case '9':                             /* no prompt at all */
                mline[0] = '\0';
                while(1)
                {
                  ferr = io_fline(flch,-1,reply,500);   /* read a menu line */
                  if(ferr < 0)
                  {
                    log(32,"Type 9 EOF");
                    exit(-15);
                  }
                  reply[ferr] = '\0';
                  if(ferr > 1)
                  {
                    if(reply[0] == ':')      /* end of page */
                       break;
                    if(strchr(powers, reply[0]) != NULL)
                    {                           /* if user has access */
                      tempbuff[0] = reply[1];
                      tempbuff[1] = '\0';
                      strcat(keys,tempbuff);        /* add key to list */
                    }
                  }
                }
                break;
           default:
                break;
         }
         if (strchr(powers,'I') == NULL)
         {
            getline("tleft",reply,12);
            tleft = atoi(reply);
            if(tleft <= 0)
            {
              io_sstrg(opch,-1,lf,2);
              io_sstrg(opch,-1,notime_msg,strlen(notime_msg));
              if (mono)
              {
              io_sstrg(mono, 0,lf,2);
              io_sstrg(mono, 0,notime_msg,strlen(notime_msg));
              }
              setline("exitcmd G logoff_prg noprompt notime");
              log(32,"Time limit expired");
              exit(0);
            }
            if(tleft <= 15)
            {
              sprintf(tempbuff,"%s%s %d %s%s",lf,yhave_msg,tleft,remain_msg,lf);
              io_sstrg(opch,-1,tempbuff, strlen(tempbuff));
              if (mono)
              io_sstrg(mono, 0,tempbuff, strlen(tempbuff));
            }
            else
            {
              io_sstrg(opch,-1,lf,2);
              if (mono)
              io_sstrg(mono, 0,lf,2);
            }
         }
         else
         {
            io_sstrg(opch,-1,lf,2);
            if (mono)
            io_sstrg(mono, 0,lf,2);
         }
         fs_pos(flch,keyspos,0);
         ferr = io_fline(flch,-1,reply,500);   /* read a menu line */
         if(ferr < 0)
         {
           log(32,"Keys EOF");
           exit(-15);
         }
         reply[ferr] = '\0';
         if(reply[0] == '')
         {
           reply[ferr-1] = '\0';                /* remove lf */
           if(strlen(reply) < 2)
             mname[0] = '\0';                   /* no menu name */
           else
           {
             a = strchr(reply,' ');
             if(a != NULL)
             {
               *a = '\0';
               strcpy(mname,&reply[1]);           /* user defined menu name */
               getline(a+1,reply,sizeof(reply));  /* name of mail/file area */
               if(reply[0] == '\0')
                 strcpy(reply,"-");
               if(reply[0] != '-')
               {
                 strcat(mname,": ");
                 strcat(mname,reply);           /* add areaname to prompt */
                 strcat(mname," ");
                 if(strnicmp(mfile,"mail",4) == 0) /* mail areas show position */
                 {
                   char mareas[42];
                   char msgid[82];
                   long flch,dbid,idch,idid;
                   short l,t,c;

                   sysvar("mareas",mareas,sizeof(mareas));
                   getline("msgid",msgid,sizeof(msgid));
                   flch = io_open( mareas, 1 ); /* mareas file is read only */
                   if (flch > 0 )
                   {
                      dbid = fsd_open(flch);

                   if (dbid > 0 )
                   {
                     l = fsd_srch(dbid, field2, reply); /* find area */
                     if (l >= 0)
                     {
                        l = fsd_get(dbid,  4, 40, mareas); /* get filename */
                        mareas[l] = '\0';
                        strcpy(&mareas[l-3],"idx");
                        idch = io_open( mareas,1 ); /* open index read-only */
                        if (idch > 0)
                        {
                          idid = fsd_open(idch);
                          if (idid > 0)
                          {
                            t = fsd_rcnt(idid);   /* number of messages */
                            c = fsd_srch(idid,field1,msgid);
                            if (c < 0)  /* id not found */
                            {
                              c = -1;
                            }
                            c++;
                            sprintf(mareas," %d/%d ",c,t);
                            strcat(mname,mareas);
                            (void)fsd_close(idid);
                          }
                          (void)io_close(idch);
                        }
                     }
                     (void)fsd_close(dbid);
                   }
                   (void)io_close(flch);
                   }
                 }
               }
             }
             else
               strcpy(mname,&reply[1]);         /* just menu name, no area */
           }
         }
         sprintf(logmsg,"Menu: %s",mname);      /* log where the user is */
         log(8,logmsg);
         getline("name",reply,sizeof(reply));
         sprintf(tempbuff,"status %s: %s",mfile,reply);
         setline(tempbuff);                         /* update status bar */
         io_sstrg(opch,-1,mname,strlen(mname));
         io_sstrg(opch,-1,"> ",2);              /* prompt on screen */
         if (mono)
         {
         io_sstrg(mono, 0,mname,strlen(mname));
         io_sstrg(mono, 0,"> ",2);              /* prompt on screen */
         }
         if(strnicmp(mfile,"mail",4) == 0)
           strcat(keys,"123456789");            /* mail allows msg number */
         for( f=0; f < strlen(keys); f++)       /* make keys list uppercase */
           keys[f] = toupper(keys[f]);

         while(1)                       /* get a keypress from the user */
         {
            key = getkey();
            if (key == 0) exit(-10);     /* eof or timeout */
            key = toupper(key);
            if(strchr(keys,key) != NULL)        /* is it valid? */
              break;
            if((key < 32) || (key > 128))
            {
              ltoa(key,tempbuff);
            }
            else
            {
              tempbuff[0] = key;
              tempbuff[1] = '\0';
            }
            sprintf(logmsg,"Bad menu option (%s)",tempbuff);
            log(128,logmsg);
         }
         sprintf(logmsg,"Menu option \"%c\"",key);
         log(128,logmsg);
         start = -1;                    /* assume it's not a msg number */
         if((strnicmp(mfile,"mail",4) == 0) &&
            (strchr("123456789",key) != NULL))
         {
            tempbuff[0] = key;
            tempbuff[1] = '\0';
            f = readline(tempbuff,10);      /* read in a number */
            start = atoi(tempbuff);
         }
         else                           /* not a msg number */
         {
           io_sbyte(opch,-1,key);
           io_sstrg(opch,-1,lf,2);
           if (mono)
           {
           io_sbyte(mono, 0,key);
           io_sstrg(mono, 0,lf,2);
           }
         }
         if(key == ':')                 /* fast logoff */
         {
           setline("exitcmd : logoff_prg : noprompt notime noscr");
           exit(0);
         }
         fs_pos(flch,keyspos,0);        /* work out what to do */
         while(1)
         {
           ferr = io_fline(flch,-1,reply,500);   /* read an option line */
           if(ferr < 0)
           {
             log(32,"Keys EOF");
             exit(-15);
           }
           reply[ferr-1] = '\0';
           if(ferr > 1)
           {
             if(reply[0] == ':')        /* end of page */
                break;
             if(start >= 0)             /* looking for readmail */
             {
               if(strfnd("readmail_prg",reply) != -1)
               {
                 a = reply;
                 a += strlen(reply);
                 a -= 1;
                 if (*a == 'M')         /* goto message number */
                   break;               /* found it */
               }
             }
             else if(reply[0] == key)
               break;                   /* found keypress */
           }
         }
         reply[ferr-1] = '\0';
         sprintf(tempbuff,"exitcmd %s",reply);
         if(start >= 0)                 /* add start msg number */
         {
           ltoa(start,reply);
           strcat(tempbuff,reply);
         }
         setline(tempbuff);
         exit(0);
      }
    }
    else
      exit(-7);
}
int (*_Cstart) () = main;
