/*
        Logoff - prompt for confirmation
                 ask for msg to sysop
                 display the logoff screen
                 run fortune program
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>
#include <database.h>

char _prog_name[] = "Pbox Logoff";
char _version[] = "v1.19";
long ipch;                      /* input channel  */
long opch;                      /* output channel */
long mono;
long timeout = 0;               /* inactivity timeout */
char inactive[82];
char cmdline[122];
char yesno[6];
char logmsg[82];
char exitmsg[82];
char optna[122];
char logoff[82];
char stilltag[202];
char msgprg[82];
char forprg[82];
char logscn[82];
char inten[202];
char tagks[10];
int tagk,lang;
char lf[] = { '\r', '\n' };
int  line = 0;
int  lf_eol = 0;
int  loglevel;
char mtyp = 0;

long exec(struct QD_text *filename, struct QD_text *cmdline,
          short wait, short chans, long chan1, long chan2, long chan3);


/* reverse string s in place */
void reverse(char s[])
{
  int c,i,j;
  for(i=0, j=strlen(s)-1; i<j; i++, j-- )
  {
    c = s[i];
    s[i] = s[j];
    s[j] = c;
  }
}

void ltoa(long n, char s[])
{
 int i, sign;

 if ((sign = n) < 0 )
    n = -n;
 i = 0;
 do {
       s[i++] = n % 10 + '0';
    }  while ((n /= 10) > 0);
 if (sign < 0)
    s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}

char getkey(void)
/* fetch a key or timeout, ignoring line feeds if appropriate */
{
char c;
int ferr,tmo;

  tmo = timeout;
  while(1)
  {
    ferr = io_fbyte( ipch, 50, &c );
    if (ferr == 0)              /* if you got a byte, return it, */
    {
      if (lf_eol)               /* if eol code is line-feed */
         return(c);             /* return whatever you got */
      else                      /* if CR or CR/LF is eol code */
        if (c != '\n')          /* ignore LFs on the assumption */
           return(c);           /* it's from a CR/LF pair */
    }
    if (ferr == -1)             /* not complete, */
    {
      if(tmo > 0)               /* if not infinite timeout */
      {
        tmo--;
        if(tmo == 0)            /* see if timed out yet */
           return(0);
      }
    }
    if (ferr < -1)
        return(0);              /* catch xmit error, eof etc. */
  }
}

void sysmsg(char *varname, char *ans, int sz)
{
char msg[82];
char *a;
short rlen;

  sprintf(msg,"sysmsg %d %s",line,varname);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen> sz)
      rlen = sz;
    strncpy(ans,a,rlen);
    ans[rlen] = '\0';
    free(a);
  }
}

void getline(char *varname, char *ans, int sz)
{
char msg[82];
char *a;
short rlen;

  sprintf(msg,"getline %d %s",line,varname);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen> sz)
      rlen = sz;
    strncpy(ans,a,rlen);
    ans[rlen] = '\0';
    free(a);
  }
}

void sysvar(char *varname, char *ans, int sz)
{
char msg[82];
char *a;
short rlen;

  sprintf(msg,"sysvar %s",varname);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen> sz)
      rlen = sz;
    strncpy(ans,a,rlen);
    ans[rlen] = '\0';
    free(a);
  }
}

void log(int level, char *value)
{
char msg[82];
char *a;
short rlen;

 if((loglevel & level) || (level == 0))
 {
  sprintf(msg,"log %d %s",line,value);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a != NULL) free(a);
 }
}

void setline(char *value)
{
char msg[82];
char *a;
short rlen;

  sprintf(msg,"setline %d %s",line,value);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a != NULL) free(a);
}

int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
long flch = -1;                 /* file ID        */
int n = -1;
char msg[12];
char reply[502];
short rlen;
char key;
int ferr;
char *t;
QD_TEXT  (82) fname = {0};
QD_TEXT  (82) cmdln = {0};


    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    if (nc != 2) exit(-15);     /* abort if no channels */
    ipch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    opch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;

    if(mlen == 0) exit(-15);
    *(sp+mlen) = '\0';                          /* terminate command line */
    while(*sp == ' ') sp++;                     /* skip leading whitespace */
    if(strchr(sp,' ') == NULL) exit(-15);       /* if not >1 param, error  */

    line = atoi(sp);                            /* 1st param is line number */
    while(*sp != ' ') sp++;                     /* skip past number */
    while(*sp == ' ') sp++;                     /* and whitespace */
    strncpy(cmdline,sp,80);                     /* and read rest of command */

    if((n=UseSrvThg (CLNT, "pbox")) == 0)
    {
       t = Request ("pbox","sysvar loglevel",-1,&rlen);
       loglevel = 0xffff;
       if (t != NULL)
       {
         t[rlen] = '\0';
         if (*t != '-')
           loglevel = atoi(t);
         free(t);
       }
       sprintf(reply,"%s %s",_prog_name,_version);
       log(1,reply);

      sysvar("fortune_prg", forprg, sizeof(forprg)-1);
      sysvar("entermsg_prg", msgprg, sizeof(msgprg)-1);
      if(line == 0)
        sysvar("inactive0", inactive, sizeof(inactive)-1);
      else
        sysvar("inactive", inactive, sizeof(inactive)-1);
      if(inactive[0] != '-')
        timeout = atol(inactive);
      if(timeout==0) timeout = -1;
      sysmsg("yesno", yesno, sizeof(yesno)-1);
      sysmsg("logoff", logoff, sizeof(logoff)-1);
      sysmsg("stilltag", stilltag, sizeof(stilltag)-1);
      sysmsg("exitmsg", exitmsg, sizeof(exitmsg)-1);
      sysmsg("optna", optna, sizeof(optna)-1);
      sysmsg("inactive", inactive, sizeof(inactive)-1);
      sysmsg("logofften", inten, sizeof(inten)-1);
      getline("eoli",tagks,1);
      lf_eol = (tagks[0] == '\n');
      getline("menu",tagks,1);
      mtyp = atoi(tagks);
      getline("mono",tagks,sizeof(tagks)-1);
      mono = atoi(tagks);
      getline("lang",tagks,1);
      lang = atoi(tagks);
      getline("tagk",tagks,sizeof(tagks)-1);
      tagk=atoi(tagks);

      sprintf(reply,"Logging off, %s",cmdline);
      log(1,reply);
      if (strfnd("inac",cmdline, 0) != -1)
      {
        setline("even +L");             /* flag line drop */
        setline("drop +1");             /* increase counter */
        io_sstrg(opch, -1, lf, 2);
        io_sstrg(opch, -1, inactive, strlen(inactive));
        io_sstrg(opch, -1, lf, 2);
        if (mono)
        {
        io_sstrg(mono,  0, lf, 2);
        io_sstrg(mono,  0, inactive, strlen(inactive));
        io_sstrg(mono,  0, lf, 2);
        }
        strcpy(cmdline,"noprompt notime");
      }
        if(strfnd ("nopr",cmdline, 0) == -1)
        {
          io_sstrg(opch, -1, lf, 2);
          if (mono)
          io_sstrg(mono,  0, lf, 2);
          if (tagk != 0)
          {
            io_sstrg(opch, -1, stilltag, strlen(stilltag));
            io_sstrg(opch, -1, lf, 2);
            if (mono)
            {
            io_sstrg(mono,  0, stilltag, strlen(stilltag));
            io_sstrg(mono,  0, lf, 2);
            }
          }
          io_sstrg(opch, -1, logoff, strlen(logoff));
          if (mono)
          io_sstrg(mono,  0, logoff, strlen(logoff));
          key = getkey();
          if(key == 0)
          {
              key = yesno[0];   /* timeout means yes, logoff */
              setline("even +L");             /* flag line drop */
              setline("drop +1");             /* increase counter */
          }
          if(strchr(yesno,key) == NULL)       /* default is 'Y' */
             key = yesno[0];
          if ((key == yesno[2]) || (key == yesno[3])) /* if you DIDNT say NO */
          {
            setline("exitcmd = menu_prg curr");
            return(0);
          }
          io_sbyte(opch, -1, key);
          io_sstrg(opch, -1, lf, 2);
          io_sstrg(opch, -1, exitmsg, strlen(exitmsg));
          if (mono)
          {
          io_sbyte(mono,  0, key);
          io_sstrg(mono,  0, lf, 2);
          io_sstrg(mono,  0, exitmsg, strlen(exitmsg));
          }
          key = getkey();
          if (key == 0)
          {
              key = yesno[2];   /* timeout means NO, no message */
              setline("even +L");             /* flag line drop */
              setline("drop +1");             /* increase counter */
          }
          if(strchr(yesno,key) == NULL)       /* default is 'N' */
             key = yesno[2];
          io_sbyte(opch, -1, key);
          io_sstrg(opch, -1, lf, 2);
          if (mono)
          {
          io_sbyte(mono,  0, key);
          io_sstrg(mono,  0, lf, 2);
          }
          if ((key == yesno[0]) || (key == yesno[1])) /* if you DID say yes */
          {
            if(msgprg[0] == '-')
            {
               io_sstrg(opch, -1, optna, strlen(optna));
               if (mono)
               io_sstrg(mono,  0, optna, strlen(optna));
            }
            else
            {
              strcpy((char *)&fname.chrs, msgprg);
              fname.len = strlen((char *)&fname.chrs);
              sprintf((char *)&cmdln.chrs,"%d S",line); /* rem sysop message */
              cmdln.len = strlen((char *)&cmdln.chrs);

              (void) exec ((struct QD_text *)&fname.len,
                           (struct QD_text *)&cmdln.len,
                            -1,2,ipch,opch,0 );
            }
          }
        }
        if(strfnd ("noti", cmdline, 0) == -1)
        {
          io_sstrg(opch, -1, lf, 2);
          io_sstrg(opch, -1, inten, strlen(inten));
          io_sstrg(opch, -1, lf, 2);
          if (mono)
          {
          io_sstrg(mono,  0, lf, 2);
          io_sstrg(mono,  0, inten, strlen(inten));
          io_sstrg(mono,  0, lf, 2);
          }
          for( n=9; n>=0; n-- )
          {
            strcpy(msg,"  0 ");
            msg[2] += n;
            io_sstrg(opch, -1, msg, 4);
            if (mono)
            io_sstrg(mono,  0, msg, 4);
            ferr = io_fbyte( ipch, 50L, &key );
            if (ferr >= 0)
            {
              if (key == ' ')
              {
                setline("exitcmd = menu_prg curr");
                return(0);
              }
              if (key == '\r')
                n = 0;
            }
            for (rlen = 0; rlen < 4; rlen++)
            {
                io_sbyte(opch,-1,8);
                if (mono)
                io_sbyte(mono, 0,8);
            }
          }
        }
        if(strfnd ("nosc", cmdline, 0) == -1)
        {
          flch = -1;
          if (mtyp == 3)
          {
            /*
                Try filename_ans0_1      (0=language,1=line number)
               then filename_ans0
                    filename_ans_1
                    filename_ans
                    filename_txt0_1
                    filename_txt0
                    filename_txt_1
                    filename_txt
            */
            sysvar("logoff_ans", logscn, sizeof(logscn)-1);
            sprintf(cmdline,"%s%d_%d",logscn,lang,line);
            flch = io_open(cmdline, 1);
            if (flch < 0)
            {
              sprintf(cmdline,"%s%d",logscn,lang);
              flch = io_open(cmdline, 1);
            }
            if (flch < 0)
            {
              sprintf(cmdline,"%s_%d",logscn,line);
              flch = io_open(cmdline, 1);
            }
            if (flch < 0)
            {
              strcpy(cmdline,logscn);
              flch = io_open(cmdline, 1);
            }
          }
          if (flch < 0)
          {
            sysvar("logoff_scn", logscn, sizeof(logscn)-1);
            sprintf(cmdline,"%s%d_%d",logscn,lang,line);
            flch = io_open(cmdline, 1);
            if (flch < 0)
            {
              sprintf(cmdline,"%s%d",logscn,lang);
              flch = io_open(cmdline, 1);
            }
            if (flch < 0)
            {
              sprintf(cmdline,"%s_%d",logscn,line);
              flch = io_open(cmdline, 1);
            }
            if (flch < 0)
            {
              strcpy(cmdline,logscn);
              flch = io_open(cmdline, 1);
            }
          }
          if(flch >= 0)
          {
            ferr = 0;
            sprintf(reply,"Displaying %s",cmdline);
            log(8,reply);

            while(ferr >= 0)
            {
              ferr = io_fline(flch, -1, reply, 500);
              if (ferr > 0)
              {
                io_sstrg(opch, -1, reply, ferr -1);
                io_sstrg(opch, -1, lf, 2);
                if (mono)
                {
                io_sstrg(mono,  0, reply, ferr -1);
                io_sstrg(mono,  0, lf, 2);
                }
              }
            }
            io_close(flch);
          }
          if(forprg[0] != '-')
          {
            log(8,"Displaying fortune");
            strcpy((char *)&fname.chrs, forprg);
            fname.len = strlen((char *)&fname.chrs);
            sprintf((char *)&cmdln.chrs,"%d",line);
            cmdln.len = strlen((char *)&cmdln.chrs);

            (void) exec ((struct QD_text *)&fname.len,
                         (struct QD_text *)&cmdln.len,
                          -1,2,ipch,opch,0 );
          }
          sleep(2);
          io_sstrg(opch, -1, lf, 2);
          io_sstrg(opch, -1, lf, 2);
          if (mono)
          {
          io_sstrg(mono,  0, lf, 2);
          io_sstrg(mono,  0, lf, 2);
          }
        }
        setline("chat 0");             /* cancel chat mode */
        setline("exitcmd :");
    }
    FreeSrvThg (CLNT, "pbox");
    return(0);
}
int (*_Cstart) () = main;
