;******************************************************************************
;
; This function creates an un-named pipe of 200 bytes length and returns
; both channel IDs to the caller with an error code.
;
; long qpipe (long *readID, long *writeID)
;
;******************************************************************************

.globl _qpipe


_qpipe:

movem.l d1/d3/a0/a1,-(sp)
stk_rdch equ    $14
stk_wrch equ    $18

        bra     qp_strt
rp:
        dc.w    4
        dc.b    'pipe'
wp:
        dc.w    8
        dc.b    'pipe_200'
qp_strt:
        moveq   #1,d0                   ;open
        lea     wp(pc),a0               ;this name
        moveq   #2,d3                   ;exclusively new
        moveq   #-1,d1                  ;for me
        trap    #2
        tst.l   d0
        bne     qp_exit                 ;else, return
        move.l  stk_wrch(sp),a1         ;stack write channel ID
        move.l  a0,(a1)
        move.l  a0,d3                   ;pass other end to connect to
        moveq   #1,d0                   ;open
        lea     rp(pc),a0               ;this name
        moveq   #-1,d1                  ;for me
        trap    #2
        move.l  stk_rdch(sp),a1         ;stack read channel ID
        move.l  a0,(a1)
qp_exit:
        movem.l (sp)+,d1/d3/a0/a1
        rts
