/*
       Pbox login button - exec a terminal and a menu handler, and link
       them together with pipes. Then wait until one or the other dies,
       kill the remaining one and close the pipes.

       It exists in two modes - if exec'd with a command line, it puts a
       button in the button frame, and runs until you 'esc' the button.
       If no command line is given it runs 'single shot' and then dies.

       In either mode, it calls 'Linetidy' on completion of login, and
       waits for it to complete.
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>

long qpipe(long *, long *);
long exec(struct QD_text *filename, struct QD_text *cmdline,
          short wait, short chans, long chan1, long chan2, long chan3);

char _prog_name[] = "Pbox Ser Local";
char _version[] = "1.20";
QD_TEXT  (81) fname = {0};
char gone[] = "log 0 Disconnected";
char start[]= "log 0 Local login";
char wait[] = "log 0 Waiting";
char lev[]  = "sysvar loglevel";
int loglevel;
void login(void);
void getreq(char *, struct QD_text *);
void makepipe(long *, long *);
static long ABUTN(struct WM_wwork *wwk);
struct WM_action abutn = {JSR, wm_actli, ABUTN};

int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
short sleep_wid;
int n = -1;

   static struct WM_wstat ws =  /* window status area */
   {
     NULL,                  /* *wwork               point back to work def */
     NULL,                  /* *wdef                this was wdef */
     0,                     /* chid                 chan ID enclosing pointer */
     0,0,0,                 /* swnr, xpos, ypos     sub-window and ptr posn */
     0,0,                   /* kstk, kprs           key stroke and press */
     0,                     /* evnt                 event vector */
     0,0,0,0,               /* xsiz, ysiz, xorg, yorg  */
     0,0,                   /* ptpsx, ptpsy         pointer position (abs) */
     0,0,0,                 /* wmode, 2 spare       window mode and spare */

     NULL,                  /* *ciact               current item "action" */
     -1,                    /* citem                current item */
     0,0,0,                 /* cibrw, cipap, cispr  current item attr */
     0,0,0,0,               /* cihxs,ys, cihxo,yo   current item hit area */

     {0,0,0,0,0,0,0,0}      /* litem[40]            loose item status */
   };

#define lit_wid 36
#define lit_hgt 10
#define ninfw    0       /* number of information windows */
#define ninfo    0       /* number of information objects */
#define ninft    0       /* number of information objects */
#define nlitm    1       /* number of loose items */
#define nappl    0       /* number of application sub-windows */

#define tit_text "Local"

   static QD_TEXTI (title,tit_text);

   static struct WM_litm litm[nlitm+1] =   /* loose item */
   {
    {lit_wid,lit_hgt,       /* xsize, ysize         size */
     2,1,                   /* xorg, yorg           and origin */
     0,0,                   /* xjst, yjst           justification */
     TYP_TEXT,0,            /* type, skey           type and select key */
     &title,                /* *pobj                pointer to object */
     0,                     /* item                 item number */
     &abutn},               /* *pact                pointer to action */

    {-1}                    /* end of array */
   };

   static struct WM_wwork ww = /* window working definition */
   {
     &ws,                   /* *wstat;              pointer to status area */
     NULL,                  /* *wscale              this was pointer to WDEF */
     0,                     /* chid                 channel ID */
     NULL,                  /* *pprec               pointer to pointer record */
     0,                     /* psave                pointer position saved */
     0,0,0,0,               /* 4 zero */
     NULL,                  /* *splst               pointer to sprite list */

     lit_wid+8,lit_hgt+2,   /* xsize, ysize         size */
     10,6,                  /* xorg, yorg           and origin */
     0,                     /* flag                 no clear + shadow */
     1,4,7,                 /* borw, borc, papr     border width/clr, paper */
     NULL,                  /* *sprite              pointer to sprite */

     1,CL_MHIGH,            /* curw, curc           current item width/clr */

     CL_MPUNAV,CL_MIUNAV,NULL,NULL,  /* uback, uink, *ublob, *upatt  unavail */
     CL_MPAVBL,CL_MIAVBL,NULL,NULL,  /* aback, aink, *ablob, *apatt  avail */
     CL_MPSLCT,CL_MISLCT,NULL,NULL,  /* sback, sink, *sblob, *spatt  selected */

     NULL,                  /* *help */

     ninfw,ninfo,NULL,      /* ninfo, ninob, *pinfo info winds */
     nlitm,litm,            /* nlitm, *plitm        loose items */
     nappl,NULL,            /* nappl  *pappl        appl winds */
   };

 if((n=UseSrvThg (CLNT, "pbox")) == 0)
 {
    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    sp += (nc << 2);            /* skip channels        */
    mlen = *((short *) sp);     /* command line length  */

    getreq(lev,(struct QD_text *)&fname.len);
    if((fname.len == 0) || (fname.chrs[0] == '-'))
      loglevel = 65536;
    else
      loglevel = atoi((char *)&fname.chrs[0]);

    if(mlen == 0)               /* if no commandline    */
    {
      if (loglevel & 1)
        getreq(start,(struct QD_text *)&fname.len);
      login();                  /* single shot mode     */
      if (loglevel & 1)
        getreq(gone,(struct QD_text *)&fname.len);
      return(0);                /* and die              */
    }

   ww.chid = io_open ("con", 0);
   if (!(long)wm_findv(ww.chid)) return(-1);

   ws.wwork=&ww;  /* cross references */
   ww.wstat=&ws;

   sleep_wid = (((title.len *6) +3) & 0xfffc); /* round up to multiple of 4 */

   ww.xsize = sleep_wid+4;          /* allow for loose item border */
   ww.xorg = sleep_wid-4;           /* pointer here */
   ww.yorg = 9;

   litm[0].xsize = sleep_wid;       /* set item size */
   ws.litem[0] = 0;                 /* and status */

   ws.citem = -1;                   /* no current item  */
   ws.ciact = NULL;                 /* or current item routine */

   if (bt_prpos (&ww))              /* set into button frame? */
   {  ww.flag = 2;                  /* ... no, use shadow */
      (void)wm_prpos (&ww,-1,-1);   /*     and position at pointer */
   }
   (void)mt_prior(-1,1);    /* this is needed so button_pick notices us !! */
   (void)wm_wdraw (&ww);                  /* and draw */

   while (!wm_rptr(&ww))
   {
        if (ws.evnt & PT_CAN)
        {
         if (loglevel & 1)
           getreq(gone,(struct QD_text *)&fname.len);
           break;
        }
   }
 FreeSrvThg (CLNT, "pbox");
 }
}
int (*_Cstart) () = main;

static long ABUTN(struct WM_wwork *wwk)
{
 if (loglevel & 1)
   getreq(start,(struct QD_text *)&fname.len);
   login();                             /* do a login */
 if (loglevel & 1)
   getreq(wait,(struct QD_text *)&fname.len);
   wwk->wstat->litem[0] = WSI_MKAV;     /* set make available */
   return wm_ldraw (wwk,-1);            /* and re-draw */
}
void login(void)
{
jobid_t termID = -1;
jobid_t  bbsID = -1;
jobid_t  id    = -1;
long prior = 0;
long addr  = 0;
long myid  = 0;
long ferr  = 0;
int  term  = 1;
int  bbs   = 1;
QD_TEXT  (40) cmdln = {0};
QD_TEXT  (40) chans = {0};
char msg[80];
long rd1, wr1, rd2, wr2;
char *a;
short rlen;

    (void)strcpy(msg,"online 0");
    a=Request ("pbox", msg, strlen(msg), &rlen);
    if (a == NULL) return;
    *(a+rlen)= '\0';
    ferr = atoi(a);
    free(a);
    if(ferr == 0) return;

  ferr  = qpipe( &rd1, &wr1);   /* open 2 pipes */
  ferr += qpipe( &rd2, &wr2);
  if(ferr == 0)                 /* if we got them opened ok */
  {
     cmdln.len=1;               /* command line is our line number */
     cmdln.chrs[0]='0';
     cmdln.chrs[1]='\0';
     (void)strcpy(msg,"sysvar bbs_prg");        /* get name of 'bbs_prg' */
     getreq(msg,(struct QD_text *)&fname.len);  /* by asking server for it */
     if(fname.len != 0)                         /* if you got a name, exec it */
        bbsID = exec ((struct QD_text *)&fname.len,
                      (struct QD_text *)&cmdln.len,
                       0,2,rd1,wr2,0 );

     sprintf(msg,"setline 0 moni %ld",wr1);      /* set monitor input */
     getreq(msg,(struct QD_text *)&fname.len);

     (void)strcpy(msg,"sysvar terminal");       /* get name of 'terminal'  */
     getreq(msg,(struct QD_text *)&fname.len);
     (void)strcpy((char *)&cmdln.chrs[0],"sysvar termcmd"); /* command line */
     getreq((char *)&cmdln.chrs[0],(struct QD_text *)&cmdln.len);
     if (strstr((char *)&cmdln.chrs[0],"-Error") != NULL)
         cmdln.len=0;
     (void)strcpy(msg,"sysvar termchans");      /* how many channels */
     getreq(msg,(struct QD_text *)&chans.len);
     rlen=atoi((char *)&chans.chrs[0]);
     if(fname.len != 0)
     {
       if(rlen == 3)
       {
         termID  = exec ((struct QD_text *)&fname.len,
                         (struct QD_text *)&cmdln.len,
                          0,3,rd2,0,wr1 );
       }
       else
       {
         termID  = exec ((struct QD_text *)&fname.len,
                         (struct QD_text *)&cmdln.len,
                          0,2,rd2,wr1,0 );
       }
     }
     term = 0;
     bbs = 0;
   }
   while((term == 0) && (bbs == 0))     /* wait for either terminal or bbs */
   {                                    /* to die */
     (void)mt_susjb(-1,5,NULL);
     myid = -1;
     id   = termID;                     /* look for this job ID. It returns */
                                        /* term -ve if job doesnt exist */
     term = mt_jinf( &id, &myid, &prior, (char **)&addr );
     myid = -1;
     id   = bbsID;
     bbs  = mt_jinf( &id, &myid, &prior, (char **)&addr );
   }
   if (term < 0)                        /* whichever one died, kill the other */
     (void)mt_frjob(bbsID,-1);
   if (bbs < 0)
     (void)mt_frjob(termID,-1);
   (void)io_close(rd1);
   (void)io_close(rd2);
   (void)io_close(wr1);
   (void)io_close(wr2);
   (void)strcpy(msg,"offline 0");
   a=Request ("pbox", msg, strlen(msg), &rlen);
   if (a != NULL) free(a);

   a = (char *)&cmdln.chrs[0];
   if (term < 0)
   {
     (void)strcpy(a,"0 Term gone");
     cmdln.len = 11;
   }
   else if (bbs < 0)
   {
     (void)strcpy(a,"0 BBS gone");
     cmdln.len += 10;
   }
   else
   {
     (void)strcpy(a,"0 Unknown");
     cmdln.len += 9;
   }
   (void)strcpy(msg,"sysvar linetidy"); /* get the name of 'linetidy' */
   getreq(msg,(struct QD_text *)&fname.len);
   if (fname.len != 0)
     (void)exec ((struct QD_text *)&fname.len,(struct QD_text *)&cmdln.len,
                  -1,0,0,0,0 );
}
void getreq(char *msg, struct QD_text *rp)
{
/*
        Send a message to the Pbox server and get a reply back as a
        QD_text string. String length set to zero if error of any kind.
        No check is made that the QD_text is large enough.
*/
char *p;
short rlen;

  if((p=Request ("pbox", msg, strlen(msg), &rlen)) != NULL)
  {
    (void)strncpy( (char *)&(rp->chrs), p, rlen);
    rp->len = rlen;
    free(p);
  }
  else
    rp->len = 0;
}
