;******************************************************************************
;
; This function execs a dependant job from a file, passing a command
; line and up to 3 channel IDs. It returns the ID of the daughter task if
; 'wait' is zero, or waits for the daughter to complete and returns the
; daughter error code if 'wait' is non-zero.
;
; long exec (struct QD_text *filename, struct QD_text *cmdline, short wait,
;            short no of channels, long chan1, long chan2, long chan3 )
;
;******************************************************************************

.globl _exec

sms.myjb equ    -1
sms.crjb equ    $01
sms.frjb equ    $05
sms.acjb equ    $0a
fs.headr equ    $47
fs.load  equ    $48
mt.prior equ    $0b

_exec:

movem.l d1-d5/d7/a0-a4,-(sp)
stk_file equ    $30
stk_cmdl equ    $34
stk_wait equ    $38
stk_chnn equ    $3a
stk_chn1 equ    $3c
stk_chn2 equ    $40
stk_chn3 equ    $44

        bra     jc_strt
buff:
        dc.b    '12345678901234567890'  ; nasty internal buffer for file header
jc_strt:
        moveq   #1,d0                   ;open
        move.l  stk_file(a7),a0         ;this file
        moveq   #0,d3                   ;exclusively
        moveq   #-1,d1                  ;for me
        trap    #2
        tst.l   d0
        bne     jc_exit                 ;else, return

        lea     buff(pc),a1             ;use input buffer
        moveq   #fs.headr,d0            ;to read file header
        moveq   #14,d2                  ;first 14 bytes
        trap    #3
        tst.l   d0                      ;any error
        bne     cl_err                  ;close file and return
*
        move.l  a0,a2                   ;save program channel ID
        lea     buff(pc),a1             ;point to file header
        moveq   #-15,d0                 ;preset 'bad parameter'
        cmpi.b  #1,5(a1)                ;is it execable?
        bne     cl_err                  ;if not, close and report
        move.l  (a1),d2                 ;read code size
        move.l  6(a1),d3                ;dataspace
        suba.l  a1,a1                   ;no start address

        move.l  stk_cmdl(a7),a4         ;get command string length
        moveq   #0,d5
        move.w  (a4),d5
        add.l   d5,d3
        add.l   #$19,d3                 ;allow room for cmd length + channels
*                                       ;and a bit of spare stack space
        bclr    #0,d3                   ;and round size up to even boundary
        move.l  d3,d5                   ;keep a copy of the size
        moveq   #sms.crjb,d0            ;create a new job
        moveq   #-1,d1                  ;owned by me
        trap    #1
        tst.l   d0                      ;ok?
        bne     cl_err                  ;close file and report file problem
        move.l  d1,d4                   ;keep job ID
        move.l  a0,a1                   ;this is base of allocated area
        move.l  a0,a4                   ;calculate the top
        adda.l  d2,a4                   ;of the allocated area
        adda.l  d5,a4                   ;so we can push a command string on

        move.l  a2,a0                   ;this is program channel
        moveq   #-1,d3
        moveq   #fs.load,d0             ;load file in
        trap    #3
        moveq   #2,d0                   ;close
        trap    #2                      ;program file

        clr.l   -(a4)                   ;tidy a bit of stack space
        clr.l   -(a4)
        move.l  stk_cmdl(a7),a0         ;point to command string
        moveq   #1,d1                   ;get command string length
        add.w   (a0),d1                 ;this is string size
        bclr    #0,d1                   ;rounded up
cmd_lp:
        move.w  0(a0,d1.w),-(a4)        ;copy command string
        subq.l  #2,d1
        bge     cmd_lp
        move.w  stk_chnn(a7),d1         ;get channel count (0 to 3)
        cmpi.w  #3,d1
        ble     chn_3                   ;if > 3 chans, send none
        moveq   #0,d1
        bra     chn_0
chn_3:
        cmpi.w  #3,d1
        bne     chn_2
        move.l  stk_chn3(a7),-(a4)
        move.l  stk_chn2(a7),-(a4)
        move.l  stk_chn1(a7),-(a4)
        bra     chn_0
chn_2:
        cmpi.w  #2,d1
        bne     chn_1
        move.l  stk_chn2(a7),-(a4)
        move.l  stk_chn1(a7),-(a4)
        bra     chn_0
chn_1:
        cmpi.w  #1,d1
        bne     chn_0
        move.l  stk_chn1(a7),-(a4)
chn_0:
        move.w  d1,-(a4)                ;no of channels passed
        move.l  d4,d1                   ;recover job ID
        moveq   #mt.prior,d0            ;set the priority
        moveq   #0,d2                   ;to zero
        trap    #1                      ;which sets a0 to job control area
        move.l  a4,$5c(a0)              ;set job stack pointer
        moveq   #sms.acjb,d0            ;activate job
        moveq   #8,d2                   ;this priority
        moveq   #-1,d3                  ;assume wait for completion
        tst.w   stk_wait(a7)
        bne     jc_act
        moveq   #0,d3
jc_act:
        trap    #1
        tst.w   d3                      ;did we wait for completion?
        bne     jc_exit                 ;if so, return error code,
        move.l  d4,d0                   ;else return daughter ID

jc_exit:
        movem.l (sp)+,d1-d5/d7/a0-a4
        rts
jc_ok:
        moveq   #0,d0
        bra     jc_exit
cl_err:
        move.l  d0,d4                   ;save error code
        moveq   #2,d0                   ;close
        trap    #2                      ;program file
        move.l  d4,d0
        bra     jc_exit
