/*
 *      Fortune - display a random entry from the 'fortune' database
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>
#include <database.h>

char _prog_name[] = "Pbox Fortune";
char _version[] = "v1.19";

int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
long ipch;                      /* input channel  */
long opch;                      /* output channel */
long mono;                      /* monitor output */
long dbid = -1;                 /* database ID    */
long flch = -1;                 /* dbs file ID    */
char *p;
char *a;
int n = -1;
char msg[40];
char reply[81];
short rlen;
long time;
short count;
long seed;
short posn;
int line = 0;
#define bufsz 1024
char answer[bufsz+1];
char tempbuff[bufsz+1];
char lf[] = { '\r', '\n' };


    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    if (nc != 2) exit(-15);     /* abort if no channels */
    ipch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    opch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;

    if(mlen)
      line = atoi(sp);


     if((n=UseSrvThg (CLNT, "pbox")) == 0)
     {
       strcpy(msg,"sysvar fortune_dbs");
       if((p=Request ("pbox", msg, strlen(msg), &rlen)) != NULL)
       {
         sprintf(tempbuff,"getline %d mono",line);
         a = Request ("pbox",tempbuff,-1,&rlen);
         mono = atoi(a);
         free(a);

         sprintf(tempbuff,"getline %d lang",line);
         a = Request ("pbox",tempbuff,-1,&rlen);
         a[rlen] = '\0';

         strcpy(tempbuff,p);
         strcat(tempbuff,a);
         free(a);

         flch = io_open(tempbuff,1);      /* try to open correct language file */
         if (flch < 0)
         {
           a = tempbuff;
           a += strlen(tempbuff);
           a -= 1;
           *a = '0';                    /* if it fails, try language 0 */
           flch = io_open(tempbuff,1);
         }
         if (flch < 0)
         {
           *a = '\0';
           flch = io_open(tempbuff,1);        /* if that fails, try no language */
         }
         if (flch > 0 )
            dbid = fsd_open(flch);

         if (flch < 0 || dbid < 0 )     /* if the 'open' failed */
         {
            if((a=Request ("pbox", "log 1 -Error opening Fortune_dbs",
                30, &rlen)) != NULL)
                free(a);
            return(0);
         }
         count = fsd_rcnt(dbid);        /* how many records there are */
         time = mt_rclck();             /* get a random number */
         time = time & 0x0000ffff;      /* between 0 and 32767 */
         posn = (short)(time % count);  /* get remainder as 0 to count -1 */
         posn += 1;                     /* 1 to count */

         fsd_posa(dbid,posn);           /* position here */

         count = fsd_get(dbid, 1, bufsz, (char *)answer);
         if (count < 0)
         {
          if((a=Request ("pbox", "log 1 -Error reading Fortune_dbs",
              30, &rlen)) != NULL)
              free(a);
         }
         else
         {

           sprintf(tempbuff,"sysmsg %d fortune_txt",line);
           a = Request ("pbox",tempbuff,-1,&rlen);
           a[rlen] = '\0';

           io_sstrg(opch, -1, lf, 2);
           io_sstrg(opch, -1, a, rlen);
           if (mono)
           {
           io_sstrg(mono,  0, lf, 2);
           io_sstrg(mono,  0, a, rlen);
           }
           free(a);
           io_sstrg(opch, -1, lf, 2);
           io_sstrg(opch, -1, (char *)answer, strlen((char *)answer));
           if (mono)
           {
           io_sstrg(mono,  0, lf, 2);
           io_sstrg(mono,  0, (char *)answer, strlen((char *)answer));
           }
           if (line == 0)
             sleep(4);
         }
         fsd_close(dbid);
         io_close(flch);
         free(p);
       }
       else
       {
          if((a=Request ("pbox", "log 1 -Error finding Fortune_dbs",
              30, &rlen)) != NULL)
             free(a);
       }
     }
     FreeSrvThg (CLNT, "pbox");
     return(0);
}
int (*_Cstart) () = main;
