/*
       Pbox LINE Info button - request 'chat' mode when hit, wait for cancel,
       or exec a 'lineinfo' job when 'do', wait for completion.
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>

long exec(struct QD_text *filename, struct QD_text *cmdline,
          short wait, short chans, long chan1, long chan2, long chan3);

char _prog_name[] = "Line 0";
long hsch;
int  line;
char history[20];

void chat(void);
void info(void);
void ltoa(long n, char s[]);
void getreq(char *, struct QD_text *);
static long ABUTN(struct WM_wwork *wwk);
struct WM_action abutn = {JSR, wm_actli, ABUTN};

void setline(char *value)
{
char msg[80];
char lno[4];
char *a;
short rlen;

  (void)strcpy(msg,"setline ");
  ltoa(line,lno);
  (void)strcat(msg,lno);
  (void)strcat(msg," ");
  (void)strcat(msg,value);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a != NULL) free(a);
}

/* reverse string s in place */
void reverse(char s[])
{
  int c,i,j;
  for(i=0, j=strlen(s)-1; i<j; i++, j-- )
  {
    c = s[i];
    s[i] = s[j];
    s[j] = c;
  }
}

void ltoa(long n, char s[])
{
 int i, sign;

 if ((sign = n) < 0 )
    n = -n;
 i = 0;
 do {
       s[i++] = n % 10 + '0';
    }  while ((n /= 10) > 0);
 if (sign < 0)
    s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}


int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
short sleep_wid;
char *ptr;
char msg[80];
int n = -1;

   static struct WM_wstat ws =  /* window status area */
   {
     NULL,                  /* *wwork               point back to work def */
     NULL,                  /* *wdef                this was wdef */
     0,                     /* chid                 chan ID enclosing pointer */
     0,0,0,                 /* swnr, xpos, ypos     sub-window and ptr posn */
     0,0,                   /* kstk, kprs           key stroke and press */
     0,                     /* evnt                 event vector */
     0,0,0,0,               /* xsiz, ysiz, xorg, yorg  */
     0,0,                   /* ptpsx, ptpsy         pointer position (abs) */
     0,0,0,                 /* wmode, 2 spare       window mode and spare */

     NULL,                  /* *ciact               current item "action" */
     -1,                    /* citem                current item */
     0,0,0,                 /* cibrw, cipap, cispr  current item attr */
     0,0,0,0,               /* cihxs,ys, cihxo,yo   current item hit area */

     {0,0,0,0,0,0,0,0}      /* litem[40]            loose item status */
   };

#define lit_wid 36
#define lit_hgt 10
#define ninfw    0       /* number of information windows */
#define ninfo    0       /* number of information objects */
#define ninft    0       /* number of information objects */
#define nlitm    1       /* number of loose items */
#define nappl    0       /* number of application sub-windows */

#define tit_text "Line 0"

   static QD_TEXTI (title,tit_text);

   static struct WM_litm litm[nlitm+1] =   /* loose item */
   {
    {lit_wid,lit_hgt,       /* xsize, ysize         size */
     2,1,                   /* xorg, yorg           and origin */
     0,0,                   /* xjst, yjst           justification */
     TYP_TEXT,0,            /* type, skey           type and select key */
     &title,                /* *pobj                pointer to object */
     0,                     /* item                 item number */
     &abutn},               /* *pact                pointer to action */

    {-1}                    /* end of array */
   };

   static struct WM_wwork ww = /* window working definition */
   {
     &ws,                   /* *wstat;              pointer to status area */
     NULL,                  /* *wscale              this was pointer to WDEF */
     0,                     /* chid                 channel ID */
     NULL,                  /* *pprec               pointer to pointer record */
     0,                     /* psave                pointer position saved */
     0,0,0,0,               /* 4 zero */
     NULL,                  /* *splst               pointer to sprite list */

     lit_wid+8,lit_hgt+2,   /* xsize, ysize         size */
     10,6,                  /* xorg, yorg           and origin */
     0,                     /* flag                 no clear + shadow */
     1,4,7,                 /* borw, borc, papr     border width/clr, paper */
     NULL,                  /* *sprite              pointer to sprite */

     1,CL_MHIGH,            /* curw, curc           current item width/clr */

     CL_MPUNAV,CL_MIUNAV,NULL,NULL,  /* uback, uink, *ublob, *upatt  unavail */
     CL_MPAVBL,CL_MIAVBL,NULL,NULL,  /* aback, aink, *ablob, *apatt  avail */
     CL_MPSLCT,CL_MISLCT,NULL,NULL,  /* sback, sink, *sblob, *spatt  selected */

     NULL,                  /* *help */

     ninfw,ninfo,NULL,      /* ninfo, ninob, *pinfo info winds */
     nlitm,litm,            /* nlitm, *plitm        loose items */
     nappl,NULL,            /* nappl  *pappl        appl winds */
   };

    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    sp += (nc << 2);            /* skip channels        */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;
    if(mlen == 0)               /* if no commandline    */
      line = 1;
    else
      line = atoi(sp);

    ptr = (char *)&title.chrs[5];
    *ptr += line;               /* change title to include line no */
    ptr = *av;
    ptr += 7;
    *ptr += line;               /* change job name to include line no */

   (void)strcpy(history,"HISTORY_Line0_1024");
   ptr = history;
   ptr += 12;
   *ptr += line;
   hsch = io_open (history, 3);
   if (hsch < 0)
     hsch = io_open("NULL",3);
   if  (hsch > 0)
   {
     if((n=UseSrvThg (CLNT, "pbox")) == 0)
     {
        (void)strcpy(msg,"lgch ");
        ltoa(hsch,history);
        (void)strcat(msg,history);
        setline(msg);
     }
     FreeSrvThg (CLNT, "pbox");         /* dont need the server any more */
   }
   ww.chid = io_open ("con", 0);
   if (!(long)wm_findv(ww.chid)) return(-1);

   ws.wwork=&ww;  /* cross references */
   ww.wstat=&ws;

   sleep_wid = (((title.len *6) +3) & 0xfffc); /* round up to multiple of 4 */

   ww.xsize = sleep_wid+4;          /* allow for loose item border */
   ww.xorg = sleep_wid-4;           /* pointer here */
   ww.yorg = 9;

   litm[0].xsize = sleep_wid;       /* set item size */
   ws.litem[0] = 0;                 /* and status */

   ws.citem = -1;                   /* no current item  */
   ws.ciact = NULL;                 /* or current item routine */

   if (bt_prpos (&ww))              /* set into button frame? */
   {  ww.flag = 2;                  /* ... no, use shadow */
      (void)wm_prpos (&ww,-1,-1); } /*     and position at pointer */
   (void)mt_prior(-1,1);  /* for button_pick to work !! */
   (void)wm_wdraw (&ww);                  /* and draw */

   while (!wm_rptr(&ww))
   {
        if (ws.evnt & PT_CAN)
          break;
   }
}
int (*_Cstart) () = main;

static long ABUTN(struct WM_wwork *wwk)
{
   if (wwk->wstat->kprs == 1)           /* 1 = space, 2 = enter */
     info();                            /* give line info */
   else                                 /* or             */
     chat();                            /* call chat mode */
   wwk->wstat->kprs = 0;                /* no keypress now */
   wwk->wstat->litem[0] = WSI_MKAV;     /* set make available */
   return wm_ldraw (wwk,-1);            /* and re-draw    */
}
void info(void)
{
jobid_t termID = -1;
QD_TEXT  (80) fname = {0};
QD_TEXT  (20) cmdln = {0};
int n    = -1;
char msg[40];
char *ptr;

   cmdln.len = 0;
   if((n=UseSrvThg (CLNT, "pbox")) == 0)
   {
     (void)strcpy(msg,"sysvar lineinfo");       /* get name of 'lineinfo'  */
     getreq(msg,(struct QD_text *)&fname.len);
     cmdln.len = 1;
     ptr = (char *)&cmdln.chrs[0];
     *ptr = '0';
     *ptr += line;
     if(fname.len != 0)
       termID  = exec ((struct QD_text *)&fname.len,
                       (struct QD_text *)&cmdln.len,
                       -1,0,0,0,0 );
   }
  FreeSrvThg (CLNT, "pbox");         /* dont need the server any more */
}
void chat(void)
{
QD_TEXT  (80) reply = {0};
int n    = -1;
char msg[40];
char *ptr;

   if((n=UseSrvThg (CLNT, "pbox")) == 0)
   {
     (void)strcpy(msg,"getline 0 user");
     ptr = (char *)&msg[8];
     *ptr += line;               /* change msg to include line no */
     getreq(msg,(struct QD_text *)&reply.len);
     if(reply.chrs[0] == '-')
       return();
     n = atoi((char *)&reply.chrs);
     if(n <= 0)
       return();
     (void)strcpy(msg,"setline 0 chat Y");
     ptr = (char *)&msg[8];
     *ptr += line;
     getreq(msg,(struct QD_text *)&reply.len);
     if(reply.chrs[0] == '-')
       return();
     (void)strcpy(msg,"getline 0 chat");
     ptr = (char *)&msg[8];
     *ptr += line;
     while(1)                    /* wait here until 'Y' is cleared */
     {
       (void)sleep(2);
       getreq(msg,(struct QD_text *)&reply.len);
       if(reply.chrs[0] != 'Y')
         return();
     }
   }
  FreeSrvThg (CLNT, "pbox");         /* dont need the server any more */
}
/*---------------------------------------------------------------------------*/
void getreq(char *msg, struct QD_text *rp)
{
/*
        Send a message to the Pbox server and get a reply back as a
        QD_text string. String length set to zero if error of any kind.
        No check is made that the QD_text is large enough.
*/
char *p;
short rlen;

  if((p=Request ("pbox", msg, strlen(msg), &rlen)) != NULL)
  {
    (void)strncpy( (char *)&(rp->chrs), p, rlen);
    rp->len = rlen;
    free(p);
  }
  else
    rp->len = 0;
}
