  /*
      Tossmail - unpack any Fido message bundles in INBOUND, and move all
      resulting messages in _pkt files into the message databases, moving
      any 'dupes' to a special dupes area, unknown areas to a 'bad' area,
      blocked addresses to the bad area, rename any 3d fakenets to true 4d,
      flag new mail for any recognised users - ie this program is equivalent
      to Qbox's LOOKMAIL and TOSSMAIL combined, but with extra functionality.
      V1.17 adds a "packet mode" which just processes any packets in inbound
      and does not unpack any arcmail. This mode is intended to be used from
      within the mailer to process areamgr messages on the same call.
      To use this, send a command line of line number, "pkt", eg "1 pkt"
  */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <csrvthg.h>
#include <database.h>
#include <stdarg.h>
#include <time.h>

#define unixtoql 283996800              /* time conversion, 1961 to 1970 */

enum  msg_type {net, echo, local, duplicate, bad};    /* message types */

#undef _condetails
#define LINES   14
#define COLUMNS 52
#define BORDERW 1
struct WINDOWDEF
     _condetails = {
        2,
        BORDERW,
        0,
        7,
        6*COLUMNS+4*BORDERW,
        10*LINES+3*BORDERW+12,
        16,
        26
        };

void    consetup_title();
void    (*_consetup)() = consetup_title;
char*   _endmsg = NULL;

#define BMAX 42
#define AMAX 100

char _prog_name[] = "Pbox Tossmail";
char _version[]   = "1.20";
char _copyright[] = "PA Borman";
long currtime;
long rnum;
char line = 0;
char pktmode = 0;
char task_hit = 0;              /* 0 = not called on this pass */
char ext_task = 0;              /* 0 = not run external at all */
    /*
       This is a table of compressors and their identification IDs.
       It is a sequence of identifying characters to check for.
    */

char zipID[] = { 'P','K', 3, 4, '\0' };       /* ZIP files */
char lzhID[] = { 1, 1,'-','l','h', '\0' };    /* LZH and HAR files */
char arjID[] = { 0x60, -22, '\0'};            /* ARJ files */
char arcID[] = { 26, '\0' };                  /* ARC files */

char    unzip[BMAX+2], unlzh[BMAX+2], unarj[BMAX+2],
        unarc[BMAX+2], unhar[BMAX+2], unpcmd[BMAX+2];

char    sysdir[BMAX+2], inbound[BMAX+2],  store[BMAX+2],   netmsg[BMAX+2],
        mareas[BMAX+2], filename[BMAX+2], userdir[BMAX+2], userdbs[BMAX+2],
        tosslog[BMAX+2], tempdir[BMAX+2], dupecheck[2], tossdel[10],
        logmsg[102], warnnew[2], blocking[BMAX+2], scanmail[BMAX+2];

long    dbid = -1;                 /* database ID    */
long    flch = -1;                 /* dbs file ID    */
long    udb  = -1;                 /* users dbs      */
long    uch  = -1;                 /* users chan     */
short   maxmsg = 0;                /* number of messages to keep */
long    tossed = 0;                /* number of tossed messages */
long    dupes  = 0;                /* number of dupes found */
long    badmsg = 0;                /* number of bad messages */
FILE    *lg;

unsigned short destzone, origzone, destnet, orignet, destnode, orignode;
unsigned short destpoint, origpoint, year, day, month, hour, minute, second;
unsigned short baudrate, pktype, msgtype, attrib, cost;
short delete;
char  prodcode, serial;
char  password[10], filler[22], dtime[22], touser[38], fromuser[38];
char  subject[74], message[32500], marea[38], sysop[74];

/*  forward declarations  */
int     unpack    (char * fname);
long    getbuff   (char *s, long n, FILE *iop); /* custom read function */
int     copyfile  (char *s, char *t, char *f);  /* copy file */
void    log       (char *s);                    /* print and log msg */
void    sysvar    (char *v, char *a, int s);    /* get system variable */
int     mail      (char *s);                    /* is filename a mail bundle */
int     extension (char *s, char *e);           /* check filename extension */
long    toss      (char *s);                    /* toss messages in _pkt file */
int     name      (long,char *,struct fld_list[],char *);
int     fido      (long,char *,struct fld_list[],char *);
int     locl      (long,char *,struct fld_list[],char *);
int     dupe      (long,char *,struct fld_list[],char *);
/*---------------------------------------------------------------------------*/
/* reverse string s in place */
void reverse(char s[])
{
  int i,j;
  char c;
  for(i=0, j=strlen(s)-1; i<j; i++, j-- )
  {
    c = s[i];
    s[i] = s[j];
    s[j] = c;
  }
}
/*---------------------------------------------------------------------------*/
void ltoa(long n, char s[])     /* convert long integer to ascii string */
{
 int i, sign;

 if ((sign = n) < 0 )
    n = -n;
 i = 0;
 do {
       s[i++] = (char)(n % 10 + '0');
    }  while ((n /= 10) > 0);
 if (sign < 0)
    s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}
/*---------------------------------------------------------------------------*/
void ltoh(long n, char s[], int f)   /* convert long integer to hex string   */
{                                    /* padding with leading zeros if needed */
 int i;

 if (n < 0 )
    n = -n;
 i = 0;
 do {
       s[i] = (char)(n % 16 + '0');
       if (s[i] > '9')
       {
         s[i] += ('A' - '9');
         s[i] -= 1;
       }
       i++;
    }  while ((n /= 16) > 0);
 while(i < f) s[i++] = '0';
 s[i] = '\0';
 reverse(s);
}
/*---------------------------------------------------------------------------*/
void sysvar(char *varname, char *ans, int sz)
{
char msg[102];
void *a;
short rlen;
  (void)strcpy(msg,"sysvar ");
  (void)strcat(msg,varname);

  a=Request ("pbox", msg, (short)strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen < sz) sz = rlen;
    ans[sz] = '\0';
    (void)strncpy(ans,a,sz);
    free(a);
  }
}
/*---------------------------------------------------------------------------*/
void log(char *msg)
{
     (void)puts(msg);
     if(lg != NULL)
     {
       (void)fputs(msg,lg);
       (void)fputs("\n",lg);
     }
}
/*---------------------------------------------------------------------------*/
int  main(int argc, char * argv[])
{
struct   qdirect qd;           /* structure for reading directories  */
char     temp[102];            /* wildcard and server buffer */
chanid_t dirch;                /* directory channel */
int      n = -1;               /* server flag */
struct   tm *t;
long     ferr;
chanid_t tmpfl;

 if(argc >= 2)                  /* get line number if supplied */
   line = (char)atoi(argv[1]);
 else
   line = 0;

 if(argc > 2)
   if (strcmp("pkt",argv[2]) == 0)
      pktmode = 1;

 if((n=UseSrvThg (CLNT, "pbox")) == 0)
 {
   sysvar("system",sysdir,BMAX);
   sysvar("inbound",inbound,BMAX);
   sysvar("storedir",store,BMAX);
   sysvar("tempdir",tempdir,BMAX);
   sysvar("userdir",userdir,BMAX);
   sysvar("userdbs",userdbs,BMAX);
   sysvar("mareas",mareas,BMAX);
   sysvar("unzip",unzip,BMAX);
   sysvar("unarc",unarc,BMAX);
   sysvar("unarj",unarj,BMAX);
   sysvar("unlzh",unlzh,BMAX);
   sysvar("unhar",unhar,BMAX);
   sysvar("netmsg",netmsg,BMAX);
   sysvar("sysop",sysop,72);
   sysvar("dupecheck",dupecheck,2);
   sysvar("notauser",warnnew,2);
   sysvar("tossdel",tossdel,10);
   sysvar("tosslog",tosslog,BMAX);
   sysvar("blocking",blocking,BMAX);
   sysvar("scanmail",scanmail,BMAX);

   delete = (short)atoi(tossdel);
   if(delete < 0)
     delete = 0;

   if(tosslog[0] != '-')
     lg = fopen(tosslog, "a");    /* open or create logfile */
   else
     lg = NULL;                   /* flag if no log required */

   currtime = mt_rclck();
   rnum = currtime;
   rnum -= unixtoql;              /* in unix base (1961)  */
   t = localtime(&rnum);          /* fill time structure  */
   (void)strftime(logmsg, 39,     /* turn into ascii string */
         "\n%a %d %b %y %H:%M:%S", t);
   log(logmsg);
   if (pktmode)
     log("Packet mode");
   rnum = currtime;               /* number to generate msgids from */

   flch = io_open( mareas, 1 );         /* mareas file is read only */
   if (flch > 0 )
      dbid = fsd_open(flch);

   if (flch < 0 || dbid < 0 )           /* exit if cant open mareas_dbs */
   {
     (void)strcpy(logmsg,"Bad mareas file");
     log(logmsg);
     return(-1);
   }
   uch = io_open( userdbs, 1 );     /* users file is read only */
    if (uch > 0 )
      udb = fsd_open(uch);

   if (uch < 0 || udb < 0 )             /* exit if cant open users_dbs */
   {
     (void)strcpy(logmsg,"Bad users_dbs file");
     log(logmsg);
     return(-1);
   }

     (void)strcpy(temp,inbound);
     (void)strcat(temp,"*");          /* wildcard all files in inbound */

/*------------------------------------
        unpack any mail bundles found
  ------------------------------------*/
   if (pktmode == 0)
   {
     (void)strcat(tempdir,"mail_tmp");
     tmpfl = io_open(tempdir,3);
     dirch = open_qdir(inbound);
     while(read_qdir(dirch, temp, filename, &qd, 0))
     {
       if(mail(filename) > 0)
       {
         (void)io_sstrg(tmpfl,-1L,filename,(short)strlen(filename));
         (void)io_sbyte(tmpfl,-1,10);
       }
     }
     (void)io_close(dirch);
     (void)fs_pos(tmpfl,0,0);
     while(1)
     {
       n = io_fline(tmpfl,-1L,filename,BMAX);
       if (n < 1) break;
       filename[n-1] = '\0';
       (void)unpack(filename);
     }
     (void)io_close(tmpfl);
     (void)io_delete(tempdir);
   }
/*------------------------------------
        toss any packets found
  ------------------------------------*/
   while(1)
   {
     dirch = open_qdir(inbound);
     while(read_qdir(dirch, temp, filename, &qd, 0) >0 )
     {
       if(extension(filename, "PKT"))
       {
         if (toss(filename) != 0 )
         {
            (void)strcpy(logmsg,"Failed to toss ");
            (void)strcat(logmsg,filename);
            log(logmsg);
         }
         else
         {
           (void)remove(filename);    /* delete successfully tossed pkts */
         }
       }
     }
     (void)io_close(dirch);
     if (task_hit == 0)         /* if we ran any external tasks this */
       break;                   /* time, scan for any new mail from them */
     else
     {
       ext_task = 1;            /* reset counter for another try */
       task_hit = 0;
     }
   }
/*------------------------------------
        shut everything down
  ------------------------------------*/

     (void)fsd_close(udb);
     (void)io_close(uch);
     (void)fsd_close(dbid);
     (void)io_close(flch);

     ferr = mt_rclck();             /* get finish time      */
     ferr -= unixtoql;              /* in unix base (1961)  */
     t = localtime(&ferr);          /* fill time structure  */
     (void)strftime(logmsg, 39,     /* turn into ascii string */
           "Finished at %H:%M:%S", t);
     log(logmsg);

     if (ext_task)              /* if we ran an external, run scanmail */
     {                          /* to process any replies from it */
      (void)sprintf(logmsg,"%d net",line);
      ferr = execl(scanmail, (int *)-1L, scanmail, logmsg, NULL);
     }

     FreeSrvThg (CLNT, "pbox");
 }
 else
   (void)puts("ERROR - No Pbox server !");
 return(0);
}
/*---------------------------------------------------------------------------*/
short readword(FILE *fp)        /* fido stores in INTEL format ;-((          */
{
  int a,b;
  a= fgetc(fp);
  b= fgetc(fp);
  return (short)(a+(256*b));
}
/*---------------------------------------------------------------------------*/
long readstring(FILE *fp, char *ans, size_t sz) /* fetch a nul term string   */
{
  char *ptr;
  int c;
  size_t count = 0;

  ptr = ans;
  while (count < sz)
  {
   c = fgetc(fp);
   if (c == EOF)
   {
     *ptr = '\0';
     break;
   }
   *ptr = (char)c;
   if (c == '\0')
      break;
   ptr++;
   count++;
  }
  if (count == sz)      /* oops, overflow. Strip garbage to next NULL */
  {
    *ptr = '\0';        /* terminate here */
    while(1)
    {
      c = fgetc(fp);
      if (c == EOF)  break;
      if (c == '\0') break;
    }
  }
  return(count);
}
/*---------------------------------------------------------------------------*/
long toss(char *fname)                  /* toss all messages in a _pkt file */
{
  int f;
  FILE  *fp;
  short find;                           /* fsd_xxx result/size */
  void  *a;
  short rlen;
  char  aname[BMAX+2];                  /* message area name */
  short anum;                           /* and number */
  long  fch = -1;                       /* message area channels */
  long  dbd = -1;
  long  ich = -1;                       /* index channels */
  long  ibd = -1;
  long  nch = -1;                       /* netmsg area channels */
  long  ndb = -1;
  int   mtype;                          /* message type code */
  char messid[AMAX+2];                  /* message ID string */
  char rplyid[AMAX+2];                  /* reply ID string */
  long size;                            /* length of message text */
  long zero = 0;                        /* longword value zero for fsd_put */
  long l;
  long written;
  char *ptr;
  char *c;
  char c1,c2;
  short *sptr;
  unsigned short capable;
  char *msg_start;
  char mline[AMAX+2];
  char temp[AMAX+2];
  char origdomain[10];
  char destdomain[10];
  char network[36];
  char fake[36];
  unsigned short idz,idn,idd,ioz,ion,iod;
  unsigned short mz,mn,md,mp,fakenet;
  short user,dupenum,ref;
  long ferr;
  long bl;
  int blokd;
  struct tm t;
  char   *mnth[] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug",
                    "Sep","Oct","Nov","Dec","Bad"};

  origdomain[0] = '\0';
  destdomain[0] = '\0';

  if (blocking[0] != '\0')
     bl = io_open(blocking, 1);         /* open list of blocked addresses */

  log(fname);                           /* report filename we're processing */

  tossed = dupes = 0;                   /* zero the counters */
  fp = fopen(fname, "r");               /* open for read only */
  if (fp == NULL)                       /* exit if theres a problem */
  {
    (void)strcpy(logmsg,"Cannot open \"");
    (void)strcat(logmsg,fname);
    (void)strcat(logmsg,"\"");
    log(logmsg);
    return(-1);
  }
  (void)fseek(fp, 0,SEEK_END);
  if (ftell(fp) <= 60)
  {
    (void)strcpy(logmsg,"Empty packet");
    log(logmsg);
    (void)fclose(fp);
    return(0);                          /* signal 'tossed ok' */
  }
  (void)strcpy(logmsg,"Packet type ");
  (void)fseek(fp,0,SEEK_SET);           /* back to beginning */
  orignode = readword(fp);              /* get pkt header */
  destnode = readword(fp);
  year     = readword(fp);
  month    = readword(fp);
  day      = readword(fp);
  hour     = readword(fp);
  minute   = readword(fp);
  second   = readword(fp);
  baudrate = readword(fp);
  pktype   = readword(fp);

  if (baudrate == 2)                    /* packet type 2.2, FSC-0045 */
  {
    (void)strcat(logmsg,"2.2");
    origpoint  = year;
    destpoint  = month;
    orignet  = readword(fp);
    destnet  = readword(fp);
    prodcode = (char)fgetc(fp);
    serial   = (char)fgetc(fp);
    for (f=0; f<8; f++)
      password[f] = (char)fgetc(fp);
    origzone = readword(fp);
    destzone = readword(fp);
    for (f=0; f<8; f++)
      origdomain[f] = (char)fgetc(fp);
    origdomain[8] = '\0';
    for (f=0; f<8; f++)
      destdomain[f] = (char)fgetc(fp);
    destdomain[8] = '\0';
    for(f=0; f<4; f++)
      filler[f] = (char)fgetc(fp);
  }
  else                                  /* packet type 2.0 or 2+ */
  {
    orignet  = readword(fp);
    destnet  = readword(fp);
    prodcode = (char)fgetc(fp);
    serial   = (char)fgetc(fp);
    for (f=0; f<8; f++)
      password[f] = (char)fgetc(fp);
    origzone = readword(fp);            /* FTS-0001 position */
    destzone = readword(fp);
    for(f=0; f<20; f++)
      filler[f] = (char)fgetc(fp);
    sptr = (short *)&filler[6];         /* intel order capability word */
    capable = *sptr;
    capable = (unsigned short)((capable >> 8) + (capable << 8));
    sptr = (short *)&filler[2];
    if ((capable == *sptr) && (capable != 0))  /* Packet type 2+, FSC-0039 */
    {
      (void)strcat(logmsg,"2+, capability = ");
      ltoh((long)capable,temp,4);
      (void)strcat(logmsg,temp);

/* Zones are duplicated in the header - I choose to ignore the 2nd copy
   as netmail from my SatUK feed has the right zone early in the pkt and his
   fido zone in the later slot
      sptr = (short *)&filler[8];
      origzone = *sptr;
      origzone = (unsigned short)((origzone >> 8) + (origzone << 8));
      sptr = (short *)&filler[10];
      destzone = *sptr;
      destzone = (unsigned short)((destzone >> 8) + (destzone << 8));
*/
      sptr = (short *)&filler[12];
      origpoint = *sptr;
      origpoint = (unsigned short)((origpoint >> 8) + (origpoint << 8));
      sptr = (short *)&filler[14];
      destpoint = *sptr;
      destpoint = (unsigned short)((destpoint >> 8) + (destpoint << 8));
      if ((origpoint != 0) && (orignet == 0xffff))  /* FSC-0048 */
      {
         sptr = (short *)&filler[0];
         orignet = *sptr;
         orignet = (unsigned short)((orignet >> 8) + (orignet << 8));
      }
    }
    else
    {
      (void)strcat(logmsg,"2.0");
      destpoint = 0;
      origpoint = 0;
    }
    (void)sprintf(temp," from %d:%d/%d.%d",origzone,orignet,orignode,origpoint);
    (void)strcat(logmsg,temp);
    log(logmsg);
  }
/*-----------------------------------
        for each message in the pkt
  -----------------------------------*/
  while (1)
  {
    msgtype  = readword(fp);
    if (msgtype == 0)    break;         /* word zero means no more msgs */
    if (feof(fp))        break;         /* as does end-of-file error */
    orignode = readword(fp);            /* get message header */
    destnode = readword(fp);
    orignet  = readword(fp);
    destnet  = readword(fp);
    attrib   = readword(fp);
    cost = attrib;
    cost &= (short)0x0100;              /* was it locally entered */
    if (cost == 0)
      attrib &= (short)0xFE73;          /* if not, mask out unwanted bits */
    else
      attrib &= (short)0xFFF3;          /* not rcv/snt but keep all others */
/*
  0 = Pvt    private message            keep
  1 = Cra    crash mail                 keep
  2 = Rcv    received by recipient              used by list/readmail
  3 = Snt    sent from this board               scanmail processed this msg
  4 = Att    file attached              keep
  5 = Tra    in transit                 keep
  6 = Orp    orphan                     keep
  7 = Kil    kill sent                          used by scanmail
  8 = Loc    locally entered
  9 = Hfp    hold for pickup            keep
  a = ???    unused                     keep
  b = Req    file request               keep
  c = Rrr    return receipt request     keep
  d = Irr    is return receipt          keep
  e = Aud    audit request              keep
  f = Upd    update request             keep
*/
    cost     = readword(fp);
    size = readstring(fp, dtime, sizeof(dtime));
    size = readstring(fp, touser, sizeof(touser));
    size = readstring(fp, fromuser, sizeof(fromuser));
    size = readstring(fp, subject, sizeof(subject));
    size = readstring(fp, message, 32000);
/*-----------------------------------
  size must remain set to the message
  text length for tossing later
  -----------------------------------*/
    mtype = net;                        /* assume netmail message */
    if (strncmp(message,"AREA:",5) == 0)
    {
      f = 0;
      while((marea[f] = message[5+f]) != '\r')
         ++f;
      marea[f] = '\0';
      mtype = echo;                     /* it's a fido echomail message */
    }
    else if (strncmp(message,"PBOX:",5) == 0)
    {
      f = 0;
      while((marea[f] = message[5+f]) != '\r')
         ++f;
      marea[f] = '\0';
      mtype = local;                    /* it's a pbox local message */
    }
    else
    {
      (void)strcpy(marea,"NETMAIL");
    }

    if (mtype == echo)                  /* echomail */
       find = fsd_srch(dbid, fido, marea);
    else
       find = fsd_srch(dbid, locl, marea);
       /* if pbox or netmail, area name is local name */
    if ((find < 0) || (fromuser[0] == '\0'))    /* bounce if no "from" name */
    {                                           /* or unknown msg area */
        mtype = bad;
       (void)strcpy(marea,"BADMSG");
       find = fsd_srch(dbid, locl, marea);      /* msgs to unknown areas */
    }
    if (find >= 0)                              /* if we carry the area */
    {
       anum = 0;
       find = fsd_get(dbid, 8, 2, (void *)&maxmsg);     /* number of msgs */
       find = fsd_get(dbid, 1, 2, (void *)&anum);       /* pbox area number */
       find = fsd_get(dbid,10,32, (void *)&network);    /* which network */
       if (find >= 0)
         network[find] = '\0';
       else
         network[0] = '\0';
       find = fsd_get(dbid, 4, BMAX, aname);            /* area dbs filename */
       if (find >= 0)                           /* check theres a filename */
       {
         aname[find] = '\0';
         fch = io_open( aname, 0 );     /* open dbs read/write */
         if (fch > 0 )
            dbd = fsd_open(fch);

         if (fch < 0 || dbd < 0 )       /* failed to open mail area dbs */
         {
           (void)strcpy(logmsg,"Bad marea : ");
           (void)strcat(logmsg,aname);
           log(logmsg);
           (void)fclose(fp);
           return(-1);
         }
         c = aname;
         c += strlen(aname);
         c -= 3;
         (void)strcpy(c,"idx");
         ich = io_open( aname, 0 );     /* open index read/write */
         if (ich > 0 )
            ibd = fsd_open(ich);

         fakenet = mz = mn = md = mp = 0;
         if (network[0] != '\0')        /* get my address and fakenet number */
         {
           sysvar(network,fake,BMAX);
           if (fake[0] == '-')
             sysvar("FIDONET",fake,BMAX);               /* default network */
           if (fake[0] != '-')
           {
             ptr = &fake[0];
             mz = (unsigned short)atoi(ptr);            /* my zone */
             ptr = strchr(ptr,':');
             if (ptr != NULL)
             {
               ptr++;
               mn = (unsigned short)atoi(ptr);          /* my net */
               ptr = strchr(ptr,'/');
               if (ptr != NULL)
               {
                 ptr++;
                 md = (unsigned short)atoi(ptr);        /* my node */
                 ptr = strchr(ptr,'.');
                 if (ptr != NULL)
                 {
                   ptr++;
                   mp = (unsigned short)atoi(ptr);      /* my point */
                 }
               }
             }
           }
           (void)strcpy(messid,network);
           (void)strcat(messid,"_PNT");
           sysvar(messid,fake,BMAX);
           if (fake[0] != '-')
             fakenet = (unsigned short)atoi((char *)&fake[0]);
                       /* my fakenet for this network */
         }
         messid[0] = '\0';                /* no msgid yet */
         rplyid[0] = '\0';                /* no reply yet */
/*---------------------------------------------------
   Now get the date string into a longword timestamp
  ---------------------------------------------------*/
         if (isdigit(dtime[0]))
         {
           /*-------------------------------
             it's a Fido format date string
             -------------------------------*/
           for(month = 0; month < 12; month++)
             if(strncmp(mnth[month], dtime+3, 3) == 0)
               break;

           t.tm_sec       = atoi(dtime+17);
           t.tm_min       = atoi(dtime+14);
           t.tm_hour      = atoi(dtime+11);
           t.tm_mday      = atoi(dtime);
           t.tm_mon       = month;
           t.tm_year      = atoi(dtime+7);
           written =  mktime(&t)+unixtoql;
         }
         else if (isupper(dtime[0]))
         {
           /*---------------------------------
             it's a Seadog format date string
             ---------------------------------*/
           for(month = 0; month < 12; month++)
             if(strncmp(mnth[month], dtime+7, 3) == 0)
               break;

           t.tm_sec       = 0;            /* Seadog doesnt store seconds */
           t.tm_min       = atoi(dtime+17);
           t.tm_hour      = atoi(dtime+14);
           t.tm_mday      = atoi(dtime+4);
           t.tm_mon       = month;
           t.tm_year      = atoi(dtime+11);
           written = mktime(&t)+unixtoql;
         }
         else
           /*-----------------------------------
              we dont know what format to use,
              so use 'assumed' time
             -----------------------------------*/
           written = mt_rclck() - 361440; /* ( yesterday ) */
/*-----------------------------------------------------
   That's got the date/time, so now skip any area name
   so we dont store that in our local copy of the msg
  -----------------------------------------------------*/
         ptr = message;
         if (mtype == bad)
             msg_start = message;           /* keep all of it in bad areas */
         else
         {                                  /* if in a known area    */
           if (mtype == echo || mtype == local)  /* and it has an area name */
           {
             c = mline;
             while(( *c++ = *ptr++) != '\r');   /* copy line to buffer */
             *c = '\0';                   /* terminate line */
             l = strlen(mline);           /* skip past 'AREA:name<cr>' */
                                          /* or 'PBOX:name<cr>'        */
             size -= l;                   /* stored message is shorter now */
           }
           msg_start = ptr;               /* start msg text after area name */
         }
/*-----------------------------------------------------
   Scan the leading ^A 'kludge' lines for data we need
  -----------------------------------------------------*/
         destpoint = 0; /* no TOPT yet */
         origpoint = 0; /* or FMPT */

         while(1)
         {
           char *lstart;

           if (*ptr++ == '\x01')        /* CTRL-A */
           {
             lstart = ptr;              /* point to first char */
             while (*ptr != '\r')
               ptr++;
             *ptr = '\0';               /* change terminator */

             if (strnicmp(lstart,"MSGID: ",7) == 0 )
             {
                c = lstart+7;
                while (*c == ' ') c++;
                (void)strncpy(messid,c,AMAX);
                messid[AMAX] = '\0';
             }
             else if (strnicmp(lstart,"REPLY: ",7) == 0 )
             {
                c = lstart+7;
                while (*c == ' ') c++;
                (void)strncpy(rplyid,c,AMAX);
                rplyid[AMAX] = '\0';
             }
             /*
                 Dont check for colons on the rest, as some systems dont
                 provide them, contrary to specifications!
             */
             else if ( strnicmp(lstart,"INTL",4) == 0 )
                  {
                     /*     INTL: dest z:n/d orig z:n/d
                            eg INTL 2:2503/402 801:300/0
                     */
                     idz=idn=idd=ioz=ion=iod=0;
                     c = strchr(lstart,' ');
                     if(c != NULL) {
                     while(*c == ' ') c++;    /* skip leading spaces */
                     idz = (short)atoi(c);    /* (I)ntl(D)est(Z)one  */
                     c = strchr(c,':');
                     if(c != NULL) {
                     c++;
                     idn = (short)atoi(c);
                     c = strchr(c,'/');
                     if(c != NULL) {
                     c++;
                     idd = (short)atoi(c);
                     c = strchr(c,' ');
                     if(c != NULL) {
                     while(*c == ' ') c++;
                     ioz = (short)atoi(c);
                     c = strchr(c,':');
                     if(c != NULL) {
                     c++;
                     ion = (short)atoi(c);
                     c = strchr(c,'/');
                     if(c != NULL) {
                     c++;
                     iod = (short)atoi(c);
                     /*
                         Do a health check on the addresses, and switch
                         to the INTL versions if different to the msg header
                     */
                     if( (destzone != idz) || (destnet != idn) ||
                         (destnode != idd))
                     {
                         (void)sprintf(logmsg,"Dest %d:%d/%d, %s\n",
                                       destzone,destnet,destnode,lstart);
                         log(logmsg);
                         destzone = idz;
                         destnet  = idn;
                         destnode = idd;
                     }
                     if( (origzone != ioz) || (orignet != ion) ||
                         (orignode != iod))
                     {
                        (void)sprintf(logmsg,"Orig %d:%d/%d, %s\n",
                                      origzone,orignet,orignode,lstart);
                        log(logmsg);
                        origzone = ioz;
                        orignet  = ion;
                        orignode = iod;
                     }
                     } } } } } }   /* all 6 numbers found */
                  }
             else if (strnicmp(lstart,"TOPT",4) == 0 )
                  {
                     c = strchr(lstart,' ');
                     if(c != NULL)
                     {
                       while(*c == ' ') c++;
                       destpoint = (short)atoi(c);
                     }
                  }
             else if (strnicmp(lstart,"FMPT",4) == 0 )
                  {
                     c = strchr(lstart,' ');
                     if(c != NULL)
                     {
                       while(*c == ' ') c++;
                       origpoint = (short)atoi(c);
                     }
                  }
             *ptr = '\r';               /* replace terminator */
             ptr++;                     /* start of next line */
           }
           else
             break;                     /* not CTRL-A so must be msg text */
         }
/*--------------------------------
   End of ^A lines, start of text
  --------------------------------*/

         for(c1=0, c2=(char)strlen(messid); c1<c2; c1++)
         {
           if (isprint(messid[c1]) == 0)  /* check messageID for validity */
           {
              messid[c1] = '\0';  /* truncate at first non-printable char */
              break;
           }
         }
         if (messid[0] == '\0')
         {
           ltoa(rnum,messid);           /* create a messageID if none found */
           rnum++;                      /* or if it started non-printable */
         }
         if ( bl != 0 )                 /* if we are blocking some addresses */
         {
           char *adr, *tmp;
           char block[82];
           int n;

           blokd = 0;                   /* assume NOT blocked */

           adr = strchr(messid,'@');
           if ( adr != NULL)            /* could be a blocked address */
           {
             (void)fs_pos(bl,0,0);      /* back to beginning */
             while(1)
             {
               n = io_fline(bl,-1L,block,80);
               if (n < 1) break;
               block[n-1] = '\0';
               if (n > 0)
               {
                  tmp = strstr(adr,block);
                  if (tmp != NULL)                 /* if text found in address */
                  {
                    (void)sprintf(temp,"Blocking <%s> <%s>",adr,block);
                    log(temp);
                    blokd = 1;                     /* block it */
                    break;
                  }
               }
             }
           }
         }
         if (blokd == 1)                        /* it's blocked */
         {
           if (mtype != bad)
           {
              mtype = bad;
              (void)strcpy(temp,"BADMSG");
              find = fsd_srch(dbid, locl, temp);    /* bad msgs area */
              (void)fsd_close(dbd);
              (void)io_close(fch);
              (void)fsd_close(ibd);
              (void)io_close(ich);
              anum = 0;
              find = fsd_get(dbid, 1, 2, (void *)&anum);  /* pbox area number */
              find = fsd_get(dbid, 4, BMAX, aname);       /* area dbs filename */
              if (find >= 0)
              {
                aname[find] = '\0';
                fch = io_open( aname, 0 );     /* open dbs read/write */
                if (fch > 0 )
                   dbd = fsd_open(fch);
                c = aname;
                c += strlen(aname);
                c -= 3;
                (void)strcpy(c,"idx");
                ich = io_open( aname, 0 );     /* open index read/write */
                if (ich > 0 )
                   ibd = fsd_open(ich);
                ptr = message;
                size += (msg_start-ptr);
                msg_start = ptr;               /* set msg to include area name */
              }
           }
         }
/*--------------------------------------------------
   Duplicate detection here if a 'dupes' area exists
   and msg is not already destined for 'badmsg' area
  ---------------------------------------------------*/
        tossed++;      /* assume it's not a dupe for now */
        if (mtype != bad)
        {
          (void)strcpy(temp,"DUPES");
          find = fsd_srch(dbid, locl, temp);    /* duplicate msgs area */

          if(dupecheck[0] != 'Y')               /* suppress dupe checking */
            find = -1;                          /* if dupecheck says so */
          if (find >= 0)
          {
            dupenum = fsd_srch(ibd, name, messid); /* is it a duplicate message */

            if (dupenum >= 0)  /* yes, change to dupes area */
            {
              dupes++;
              tossed--;                 /* change counters to show duped */
              mtype = duplicate;
              (void)fsd_close(dbd);
              (void)io_close(fch);
              (void)fsd_close(ibd);
              (void)io_close(ich);
              anum = 0;
              find = fsd_get(dbid, 1, 2, (void *)&anum);  /* pbox area number */
              find = fsd_get(dbid, 4, BMAX, aname);       /* area dbs filename */
              if (find >= 0)
              {
                aname[find] = '\0';
                fch = io_open( aname, 0 );     /* open dbs read/write */
                if (fch > 0 )
                   dbd = fsd_open(fch);
                c = aname;
                c += strlen(aname);
                c -= 3;
                (void)strcpy(c,"idx");
                ich = io_open( aname, 0 );     /* open index read/write */
                if (ich > 0 )
                   ibd = fsd_open(ich);
                ptr = message;
                size += (msg_start-ptr);
                msg_start = ptr;               /* set msg to include area name */
              }
            }
          }
        }
        if(mtype == duplicate)
          (void)sprintf(logmsg,"%s: <%s> DUPLICATE %d",marea,messid,dupenum);
        else if (blokd)
          (void)sprintf(logmsg,"%s: <%s> BLOCKED",marea,messid);
        else
          (void)sprintf(logmsg,"%s: <%s>",marea,messid);

        log(logmsg);
/*-------------------------------------------------
   Now convert any fakenet addresses into true 4d
  -------------------------------------------------*/
        if (mz != 0) /* if mz == 0 we are not in a network, it's a local area */
        {
          if ((origpoint == 0) && (orignet == fakenet) && (origzone == mz))
          {
             (void)sprintf(logmsg,"3D %d:%d/%d.0 converted to 4D %d:%d/%d.%d",
                           origzone,orignet,orignode,mz,mn,md,orignode);
             log(logmsg);
             origpoint = orignode;         /*     z:f/p.0 -> z:n/d.p      */
             orignode = md;
             orignet = mn;
          }
        }
/*-------------------------------------------------
   We're now in dupes area or real msg area if not
   a duplicate message. Check there's an area open
   and if ok, write message to database
  -------------------------------------------------*/
        if (fch >= 0 && dbd >= 0 )
        {
          (void)fsd_put(dbd,1,strlen(fromuser),fromuser);
          (void)fsd_put(dbd,2,strlen(touser),touser);
          (void)fsd_put(dbd,3,strlen(subject),subject);
          (void)fsd_put(dbd,4,strlen(messid),messid);
          (void)fsd_put(dbd,5,strlen(rplyid),rplyid);
          (void)fsd_put(dbd,6,4,&written);
          (void)fsd_put(dbd,7,4,&currtime);    /* received */
          (void)fsd_put(dbd,8,4,&zero);        /* read/sent */
          (void)fsd_put(dbd,9,2,&zero);        /* times read */
          (void)fsd_put(dbd,10,2,&cost);
          (void)fsd_put(dbd,11,2,&destzone);
          (void)fsd_put(dbd,12,2,&destnet);
          (void)fsd_put(dbd,13,2,&destnode);
          (void)fsd_put(dbd,14,2,&destpoint);
          (void)fsd_put(dbd,15,2,&origzone);
          (void)fsd_put(dbd,16,2,&orignet);
          (void)fsd_put(dbd,17,2,&orignode);
          (void)fsd_put(dbd,18,2,&origpoint);
          (void)fsd_put(dbd,19,2,&attrib);
          (void)fsd_put(dbd,20,size,msg_start);
          (void)fsd_appn(dbd);
          if(delete > 0)                  /* if we want to limit messages */
          {
            find = fsd_rcnt(dbd);         /* check how many messages in area */
            if(find >= maxmsg)
            {
              for(ferr = 0; ferr < delete; ferr++)
              {
                (void)fsd_posa(dbd,0);      /* goto first (earliest) message */
                (void)fsd_del(dbd);         /* and delete it */
                (void)fsd_posa(ibd,0);      /* then delete index entry too */
                (void)fsd_del(ibd);
              }
            }
          }
        }
        (void)fsd_close(dbd);
        (void)io_close(fch);
/*-------------------------------------
   Now update the index file to match
  -------------------------------------*/
        if (ich >= 0 && ibd >= 0 )
        {
          (void)fsd_posa(ibd,50000);                    /* end of file */
          (void)fsd_get(ibd,3,2,(void *)&ref);          /* highest ref nr */
          (void)fsd_put(ibd,1,strlen(messid),messid);   /* msgid  */
          (void)fsd_put(ibd,2,4,&currtime);             /* date   */
          if(ref == 32767)
            ref = 1;
          else
            ref++;
          (void)fsd_put(ibd,3,2,&ref);                  /* reference nr */
          (void)fsd_appn(ibd);
        }
        (void)fsd_close(ibd);
        (void)io_close(ich);
/*
        At this point, check netmail for file request flag
*/
/*------------------------------------------------------
   If netmail is sent to a 'special' name, take special
   action by calling another program, passing the msgid
   The message database is closed, so the new program
   can open/edit/reply to the message as it wishes.
  ------------------------------------------------------*/
         if (mtype == net)
         {
           nch = io_open( netmsg, 1 );     /* open netmsg dbs read only */
           if (nch > 0 )
           {
             ndb = fsd_open(nch);
             if (ndb >= 0 )
             {
               find = fsd_srch(ndb, name, touser);  /* field 1 string cmp */
               if (find >= 0)
               {
                 find = fsd_get(ndb, 2, BMAX, (void *)&temp); /* read program to call */
                 if (find > 0)
                 {
                   temp[find] = '\0';
                   (void)strcpy(logmsg,"Message to ");
                   (void)strcat(logmsg,touser);
                   log(logmsg);
                   (void)fsd_close(dbid);
                   (void)io_close(flch);
                   task_hit = 1;
                   ferr = execl(temp, (int *)-1L, touser, messid, NULL);
                   flch = io_open( mareas, 1 );         /* mareas file is read only */
                   if (flch > 0 )
                      dbid = fsd_open(flch);

                   if (flch < 0 || dbid < 0 )           /* exit if cant open mareas_dbs */
                   {
                     (void)strcpy(logmsg,"Bad mareas file");
                     log(logmsg);
                     return(-1);
                   }
                   if (ferr != 0)
                   {
                    (void)strcpy(logmsg,"Error running ");
                    (void)strcat(logmsg,touser);
                    (void)strcat(logmsg," -> ");
                    (void)strcat(logmsg,messid);
                    log(logmsg);
                   }
                 }
               }
               (void)fsd_close(ndb);
             }
             (void)io_close(nch);
           }
/*------------------------------------------------------------
        Check for any attached files and move them into
        the private file area??  What about files with TICs.
        The TIC processor moves those, but the file may be
        attached to an earlier message than the TIC.
        Leave all attached files in inbound for now.
-------------------------------------------------------------*/
         }
/*------------------------------------------------------------
   If 'touser' is in our userlist, flag new mail for him
   unless it's a duplicate message or in badmail area, in
   which case dont bother
  ------------------------------------------------------------*/
        if (mtype == duplicate)
        {
          a=Request ("pbox", "counter 8", 9, &rlen);  /* inc "dupe" counter */
          if (a != NULL) free(a);
        }
        if (mtype == bad)
        {
          a=Request ("pbox", "counter 9", 9, &rlen);  /* inc "bad" counter */
          if (a != NULL) free(a);
        }
        if ((mtype != duplicate) && (mtype != bad))
        {
          a=Request ("pbox", "counter 7", 9, &rlen);  /* inc "good" counter */
          if (a != NULL) free(a);
          if(stricmp(touser,"SYSOP") == 0)
                                /* flag new mail to whoever sysop is */
          {
             if ((destzone == mz) && (destnet==mn) && (destnode==md) && (destpoint==mp))
             {
               a=Request ("pbox", "counter 4", 9, &rlen);  /* inc counter */
               if (a != NULL) free(a);
               find = fsd_srch(udb, locl, sysop); /* locl is field 2 string cmp */
             }
             else
             {
 sprintf(temp,"msg to %s at %d:%d/%d.%d",touser,destzone,destnet,destnode,destpoint);
 log(temp);
 sprintf(temp,"my address is %d:%d/%d.%d Fake %d, network <%s>",mz,mn,md,mp,fakenet,network);
 log(temp);
             }
          }
          else
            find = fsd_srch(udb, locl, touser);

          if(stricmp(touser,sysop) == 0)        /* message to sysop by name */
          {
             if ((destzone == mz) && (destnet==mn) && (destnode==md) && (destpoint==mp))
             {
               a=Request ("pbox", "counter 4", 9, &rlen);  /* inc counter */
               if (a != NULL) free(a);
             }
             else
             {
 sprintf(temp,"msg to %s at %d:%d/%d.%d",touser,destzone,destnet,destnode,destpoint);
 log(temp);
 sprintf(temp,"my address is %d:%d/%d.%d Fake %d, network <%s>",mz,mn,md,mp,fakenet,network);
 log(temp);
             }
          }
          if (find >= 0)
          {
            (void)fsd_get(udb, 1, 2, (void *)&user);  /* read user number as a short */
            (void)strcpy(mline,userdir);
            ltoh(user,temp,4);
            (void)strcat(mline,temp);                 /* create _new filename */
            (void)strcat(mline,"_new");

            ferr = io_open(mline, 0);             /* open_r/w */
            if (ferr < 0)
              ferr = io_open(mline, 2);           /* open_new */
            if (ferr >= 0)
            {
            (void)fs_pos(ferr, 0, 2);             /* goto end */
            ltoh(anum,temp,4);                    /* msg area as 4 digits hex */
            (void)io_sstrg(ferr, -1, temp,4);
            (void)io_sstrg(ferr,-1,messid,(short)strlen(messid)); /* and msgid */
            (void)io_sbyte(ferr,-1,10);                    /* all on one line */
            (void)io_close(ferr);
            }
          }
          else          /* not a recognised user */
          {
            if(warnnew[1] == '1')
            {
              (void)strcpy(logmsg,"<");
              (void)strcat(logmsg,touser);
              (void)strcat(logmsg,"> not found");
              log(logmsg);
            }
          }
        }
      }                                 /* in 'badmsg' area */
    }                                   /* cant find marea */
  }                                     /* next message in pkt */
  (void)fclose(fp);
  if (bl != 0)
     (void)io_close(bl);
  ltoa(tossed,logmsg);
  (void)strcat(logmsg," message");
  if(tossed != 1)
    (void)strcat(logmsg,"s");
  (void)strcat(logmsg,", ");
  ltoa(dupes,temp);
  (void)strcat(logmsg,temp);
  (void)strcat(logmsg," dupe");
  if(dupes != 1)
    (void)strcat(logmsg,"s");
  (void)strcat(logmsg,".");
  log(logmsg);
  return(0);
}
/*---------------------------------------------------------------------------*/
int name(long db, char *rec, struct fld_list fldef[],char *appcn)
/*
        search the database for field 1 = required name

long db;                             database ID
char *rec;                           pointer to record
struct fld_list fldef[];             field list
char *appcn;                         application definable quantity; in
                                     this case, the compare string
   return: 1 = match;  0 = no match.
*/
{
   struct QLSTR *string;
   int stln;
 
   db = db; /* keep compiler happy */
   /* make a pointer to field 1 */
   string = (struct QLSTR *) (rec + fldef[1].fld_ptr);
   stln = strlen(appcn);
   if (stln != string->qs_strlen)  return(0);
   return(strnicmp(string->qs_str,appcn,stln) == 0);

}
/*---------------------------------------------------------------------------*/
int locl(long db, char *rec, struct fld_list fldef[],char *appcn)
/*
        search the database for field 2 = required name

long db;                             database ID
char *rec;                           pointer to record
struct fld_list fldef[];             field list
char *appcn;                         application definable quantity; in
                                     this case, the compare string
   return: 1 = match;  0 = no match.
*/
{
   struct QLSTR *string;
   int stln;
 
   db = db; /* keep compiler happy */
   /* make a pointer to field 2 */
   string = (struct QLSTR *) (rec + fldef[2].fld_ptr);
   stln = strlen(appcn);
   if (stln != string->qs_strlen)  return(0);
   return(strnicmp(string->qs_str,appcn,stln) == 0);

}

/*---------------------------------------------------------------------------*/
int fido(long db, char *rec, struct fld_list fldef[],char *appcn)
/*
        search the database for field 3 = required name

long db;                             database ID
char *rec;                           pointer to record
struct fld_list fldef[];             field list
char *appcn;                         application definable quantity; in
                                     this case, the compare string
   return: 1 = match;  0 = no match.
*/
{
   struct QLSTR *string;
   int stln;
 
   db = db; /* keep compiler happy */
   /* make a pointer to field 3 */
   string = (struct QLSTR *) (rec + fldef[3].fld_ptr);
   stln = strlen(appcn);
   if (stln != string->qs_strlen)  return(0);
   return(strnicmp(string->qs_str,appcn,stln) == 0);

}
/*---------------------------------------------------------------------------*/
long    getbuff(char *s, long n, FILE *iop)
{
   /* fetch at most n characters from iop or until EOF
      returning the number of characters read.          */

   int   c,f;

   for(f = 0; f < n-1  && (c = getc(iop)) != EOF; f++)
      s[f] = (char)c;
   s[f+1] = '\0';
   return f;
}
/*---------------------------------------------------------------------------*/
int copyfile(char *s, char *t, char *f)
{
        /*----------------------------------------------------------
            Copy file f (full name) from directory s to directory t
          ----------------------------------------------------------*/

FILE    *ip,*op;
int     c;
char    temp[44];

  c = strlen(s);                /* length of source_dir name on filename */

  (void)strcpy(temp,t);               /* get target directory */
  (void)strcat(temp,&f[c]);           /* append filename      */

  (void)strcpy(logmsg,"Copying ");
  (void)strcat(logmsg,f);
  (void)strcat(logmsg," to ");
  (void)strcat(logmsg,temp);
  log(logmsg);
  ip = fopen(f,"r");    /* open source */
  if(ip == NULL)
  {
    (void)strcpy(logmsg,"Error opening ");
    (void)strcat(logmsg,f);
    log(logmsg);
    return(-1);                 /* return if error */
  }
  op = fopen(temp,"w");         /* open new target */
  if(op == NULL)
  {
    (void)strcpy(logmsg,"Error opening ");
    (void)strcat(logmsg,temp);
    log(logmsg);
    (void)fclose(ip);           /* close input     */
    return(-1);                 /* return if error */
  }
  while ((c = fgetc(ip)) != EOF)
    (void)fputc(c,op);

  (void)fclose(ip);
  (void)fclose(op);

return(0);
}
/*---------------------------------------------------------------------------*/

int extension(char* s, char* e)
{
char * dot;                         /* position of extension in filename */

  dot = strrchr(s,'.');             /* find the dot */
  if(dot == NULL)                   /* if no dot, try underscore */
     dot = strrchr(s,'_');
  if(dot == NULL)
     return(0);                     /* if no underscore either, no match */
  if(!strnicmp(&dot[1],e,strlen(e)))
    return(1);
  return(0);
}

/*---------------------------------------------------------------------------*/
int mail(char *s)
{
char * dot;                     /* position of extension in filename */

  dot = strrchr(s,'.');         /* find the dot */
  if(dot == NULL)
    return(-1);                 /* if no dot, it's not mail */
  if(!strnicmp(dot,".MO",3))
      return(1);
  if(!strnicmp(dot,".TU",3))
      return(2);
  if(!strnicmp(dot,".WE",3))
      return(3);
  if(!strnicmp(dot,".TH",3))
      return(4);
  if(!strnicmp(dot,".FR",3))
      return(5);
  if(!strnicmp(dot,".SA",3))
      return(6);
  if(!strnicmp(dot,".SU",3))
      return(7);

    return(0);
}

/*---------------------------------------------------------------------------*/
int unpack(char * fname)
{
int match = 0;                  /* file type not matched */
long fail  = 0;                 /* file failed to unpack */
int temp  = 0;
int err   = 0;
char buffer[12];                /* buffer to read file start into */
FILE *fp;                       /* file pointer for source file   */
char cmdline[102];              /* command line for unpackers     */
int   chantab[3] = { 2, 0, 0 }; /* channel table for Jans unarc   */

    /* make the filename lower case to aid pattern matching */
    while (fname[temp] != '\0')
    {
      fname[temp]=(char)tolower(fname[temp]);
      temp++;
    }

   fp = fopen(fname,"r");
   if (fp == NULL)
      {
      (void)strcpy(logmsg,"Cannot open \"");
      (void)strcat(logmsg,fname);
      (void)strcat(logmsg,"\"");
      log(logmsg);
      return(-1);
      }

   /* fetch 8 bytes from the file into a buffer allowing room for terminator */
   temp = getbuff(buffer, 9, fp);   /* custom function returns 0 on error  */
   if (temp == 0)
      {
      (void)strcpy(logmsg,"Error reading ");
      (void)strcat(logmsg,fname);
      log(logmsg);
      return(-1);
      }

    (void)fclose(fp);

   /* Now check the header */

   err = strncmp(buffer, zipID, strlen(zipID));
   if (err == 0)
   {
      (void)strcpy(logmsg,"ZIP: ");
      (void)strcat(logmsg,fname);
      log(logmsg);
      sysvar("unzip_cmd",unpcmd,BMAX);
      (void)sprintf(cmdline,unpcmd,fname,inbound);
      fail =  execl( unzip, (int *)-1L, "Unzip", cmdline, NULL);
      if(fail != 0)
      {
        (void)strcpy(logmsg,"Failed to unzip ");
        (void)strcat(logmsg,fname);
        log(logmsg);
                                        /* if not unzipped print warning */
        if(strlen(store))               /* and if we were given a store, */
        {
          err = copyfile(inbound,store,fname); /* copy the file into it  */
          if(err == 0)
            (void)remove(fname);
        }
      }
      else
      (void)remove(fname);
      match = 1;
   }
   if(!match)
   {
   char a,b,c;
   int ext;
   a = buffer[0];       /* fudge for lzh which has variable bytes 0 & 1 */
   b = buffer[1];       /* so we fix these to known values and then     */
   buffer[0] = 1;       /* replace them later                           */
   buffer[1] = 1;
   err = strncmp(buffer, lzhID, strlen(lzhID));
   buffer[0] = a;
   buffer[1] = b;
   if (err == 0)
      {
      int offset;
      offset = strfnd("_hrq",fname);   /* look for '_hrq' */
      if(offset == -1)
        offset = strfnd(".hrq",fname); /* look for '.hrq' instead */
      if(offset == -1)
      {
         (void)strcpy(logmsg,"LZH: ");
         (void)strcat(logmsg,fname);
         log(logmsg);
         sysvar("unlzh_cmd",unpcmd,BMAX);
         (void)sprintf(cmdline,unpcmd,fname,inbound);
         fail =  execl( unlzh, (int *)-1L, "Unlzh", cmdline, NULL);
         if(fail != 0)
         {
           (void)strcpy(logmsg,"Failed to unlzh ");
           (void)strcat(logmsg,fname);
           log(logmsg);
                                           /* if not unzipped print warning */
           if(strlen(store))               /* and if we were given a store, */
           {
             err = copyfile(inbound,store,fname); /* copy the file into it  */
             if(err == 0)
               (void)remove(fname);
           }
         }
         else
         (void)remove(fname);          /* and finally delete the zip    */
         match = 1;
      }
      else
      {
         (void)strcpy(logmsg,"HAR: ");
         (void)strcat(logmsg,fname);
         log(logmsg);
         ext=strlen(fname);                 /* har needs the extension off */
         c=fname[ext-4];
         fname[ext-4] = '\0';
         sysvar("unhar_cmd",unpcmd,BMAX);
         (void)sprintf(cmdline,unpcmd,fname,inbound);
         fname[ext-4]=c;
         fail =  execl( unhar, (int *)-1L, "Unhar", cmdline, NULL);
         if(fail != 0)
         {
           (void)strcpy(logmsg,"Failed to unhar ");
           (void)strcat(logmsg,fname);
           log(logmsg);
                                           /* if not unzipped print warning */
           if(strlen(store))               /* and if we were given a store, */
           {
             err = copyfile(inbound,store,fname); /* copy the file into it  */
             if(err == 0)
               (void)remove(fname);
           }
         }
         else
         (void)remove(fname);          /* and finally delete the zip    */
         match = 1;
      }
      match = 1;
      }
   }
   if(!match)
   {
     err = strncmp(buffer, arjID, strlen(arjID));
     if (err == 0)
     {
        (void)strcpy(logmsg,"ARJ: ");
        (void)strcat(logmsg,fname);
        log(logmsg);
         sysvar("unarj_cmd",unpcmd,BMAX);
         (void)sprintf(cmdline,unpcmd,fname,inbound);
        fail =  execl( unarj, (int *)-1L, "Unarj", cmdline, NULL);
        if(fail != 0)
        {
          (void)strcpy(logmsg,"Failed to unarj ");
          (void)strcat(logmsg,fname);
          log(logmsg);
                                          /* if not unzipped print warning */
          if(strlen(store))               /* and if we were given a store, */
           {
             err = copyfile(inbound,store,fname); /* copy the file into it  */
             if(err == 0)
               (void)remove(fname);
           }
        }
         else
        (void)remove(fname);          /* and finally delete the zip    */
        match = 1;
     }
   }
   if(!match)
   {
     err = strncmp(buffer, arcID, strlen(arcID));
     if (err == 0)
     {
        (void)strcpy(logmsg,"ARC: ");
        (void)strcat(logmsg,fname);
        log(logmsg);
         sysvar("unarc_cmd",unpcmd,BMAX);
         (void)sprintf(cmdline,unpcmd,fname,inbound);
              /*
                  pass Jan's unarc the source dir too for unpacking into
                 Jan's UNARC needs to be passed only 1 open channel for output
              */

        chantab[0]=1;
        chantab[1]=fileno(stdout);
        fail =  execl( unarc, (int *)chantab, "Unarc", cmdline, NULL);
        if(fail != 0)
        {
          (void)strcpy(logmsg,"Failed to unarc ");
          (void)strcat(logmsg,fname);
          log(logmsg);
                                          /* if not unzipped print warning */
          if(strlen(store))               /* and if we were given a store, */
           {
             err = copyfile(inbound,store,fname); /* copy the file into it  */
             if(err == 0)
               (void)remove(fname);
           }
        }
         else
           (void)remove(fname);
        match = 1;
     }
   }
   if(!match)
   {
      (void)strcpy(logmsg,"Unknown archive type: ");
      (void)strcat(logmsg,fname);
      log(logmsg);
   }
   return fail;
}
/*------------------------------- END ---------------------------------------*/
