/**
*
* This header file defines global variables for PSERVE
*
**/

#define numcounters 10
#define maxlines 4
#define numlangs 8
#define unixtoql 283996800              /* time conversion, 1970 to 1961 */

#ifndef MAIN_C
extern                          /* Make the following external */
#endif
short nlines,
      fc_nr;

#ifndef MAIN_C
extern
#endif
long mainlgch;

#ifndef MAIN_C
extern
#endif
int  lockon,
     counters[numcounters];

#ifndef MAIN_C
extern
#endif
char sysdir[36] ,
     sysdat[36] ,
     sysmsg[36] ,
     listable[36],
     userdbs[36],
     fareas[36] ,
     mareas[36] ,
     feeds[36] ,
     pboxlog[36],
     nodelists[36],
     magic[36],
     flist[36],
     sconn[36],
     quiet[2],
     tempdir[36],
     *sysdat_base,
     *msgbase[numlangs],
     *sysdat_idx,
     *msg_idx[numlangs],
     *monptr,
     *dayptr;

#ifndef MAIN_C
extern
#endif
unsigned char
     QL_ANSI[],
     ANSI_QL[],
     QL_ASCII[],
     QL_PC8[],
     PC8_QL[],
     ANSI_PC8[],
     PC8_ANSI[];

#ifdef MAIN_C
char months[] = "JanFebMarAprMayJunJulAugSepOctNovDec";
char days[] = "SatSunMonTueWedThuFri";
#else
extern
char months[],
     days[];
#endif

typedef struct line_data
{
   short user;          /* user number of caller on this line  */
   char name[42];       /* user name                           */
   char city[42];       /* user city of origin                 */
   char pass[22];       /* password                            */
   char powers[28];     /* what options the user can access    */
   char mareas[28];     /* mail areas the user can access      */
   char fareas[28];     /* file areas the user can access      */
   long ltime;          /* Date/time of last call              */
   char editor;         /* preferred message editor            */
   char protocol;       /* preferred file transfer protocol    */
   char menus;          /* preferred menu type                 */
   char term;           /* terminal type                       */
   char lang;           /* language preference of user         */
   char more;           /* more (yes=non-zero or no=0)         */
   short width;         /* number of columns                   */
   short lines;         /* number of lines                     */
   short tmpd;          /* how many minutes allowed per day    */
   short tmtd;          /* how many minutes online today       */
   short dnpd;          /* Downloads allowed per day           */
   short dntd;          /* Downloads so far today              */
   short calls;         /* number of calls                     */
   short uplds;         /* Number of uploads                   */
   short dnlds;         /* Number of downloads                 */
   short msgs;          /* Number of messages entered          */
   short yells;         /* Number of times 'yell' hit          */
   short drops;         /* Number of line drops                */
   short cmsg;          /* Current mail area                   */
   short cfile;         /* Current file area                   */
   short tagk;          /* How many K of files are tagged now  */
   short tagn;          /* How many files are tagged now       */
   long lgch;           /* channel for bbsline log messages    */
   long login;          /* Date/time this call started         */
   char exitcmd[82];    /* exit command from the current menu  */
   char status[82];     /* single line of status info +term    */
   char mname[42];      /* Current mail area name              */
   char fname[42];      /* Current file area name              */
   char event[28];      /* list of user actions to tidy up     */
   char msgid[82];      /* Most recently read message ID       */
   long baud;           /* baud rate reported by modem         */
   char chat;           /* set to 'Y' if chat mode requested   */
   char inuse;          /* '0' if line idle, '1' if not        */
   char eoline;         /* 10 for LF, 13 for CR & ignore 10    */
   char ttype;          /* auto-detected terminal type code    */
   char oopts[28];      /* offline reader options list         */
   char oprot;          /* offline reader transfer protocol    */
   char oarch;          /* offline reader file archiver        */
   char charset;        /* character set to use                */
   char spare;
   long otime;          /* offline reader "last run" time      */
   char uopts[28];      /* user options                        */
   long mono;           /* monitor output channel (view user)  */
   long moni;           /* monitor input channel (keypresses)  */
} linedata;
#ifndef MAIN_C
extern
#endif
linedata line[maxlines+1];

typedef struct _comblock
{
    char lno;           /* line number                  */
    char act;           /* non-zero if cmd to process   */
    long id;            /* job id of flist task         */
    long sort;          /* sorted whole files database  */
    long selc;          /* sorted & selected one area   */
    short anum;         /* currently selected area      */
    char cmd[36];       /* command buffer               */
}comblock;
#ifndef MAIN_C
extern
#endif
comblock fcomm[maxlines+1];
