/*
                Pbox bulletin board server      PA Borman, May 95
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <qdos.h>
#include <qptr.h>
#include <things.h>
#include <sms.h>
#include <csrvthg.h>
#include <database.h>

#define NAME "PBOX"
#define FNAME "win1_pbox_SYSTEM_dat"
#define MAIN_C
#include "pserve.h"
#include "translates.h"

char _prog_name[] = "Pbox Server";
char _version[] = "1.20";

int main (int ac, char **av);
int (*_Cstart) (int, char **) = main;

long   jcall (char *, char *, long, long, long, ...);
extern void  flistjob  (void);
extern char *mkidx (char *s);

int field2(long,char *,struct fld_list[],char *);
int field1(long,char *,struct fld_list[],char *);
void init_defaults(void);
void set_defaults(void);
void getstrg(char *, char *, char *);
void ltoa(long, char []);
void reverse(char[]);
int extension(char*, char*);
void translate(char *p, char t);
void ansify(char *p, short lno);

int getline   (int, char *, short);
int setline   (int, char *, short);
int online    (int, char *, short);
int offline   (int, char *, short);
int lock      (int, char *, short);
int unlock    (int, char *, short);
int islock    (int, char *, short);
int setuser   (int, char *, short);
int setlog    (int, char *, short);
int getsysvar (int, char *, short);
int getsysmsg (int, char *, short);
int logline   (int, char *, short);
int version   (int, char *, short);
int nodelist  (int, char *, short);
int mailer    (int, char *, short);
int recfile   (int, char *, short);
int reqfile   (int, char *, short);
int upduser   (int, char *, short);
int counter   (int, char *, short);
int getflst   (int, char *, short);
int reset     (int, char *, short);
int goquiet   (int, char *, short);
int transtxt  (int, char *, short);

typedef struct
{
    char *cmd;
    int (*func) (int, char *, short);
}
CMDTABLE;

/*---------------------------------------------------------------------------*/
static CMDTABLE ctbl[] =
{
    {"getline",getline},
    {"setline",setline},
    {"online",online},
    {"offline",offline},
    {"lock",lock},
    {"unlock",unlock},
    {"islock",islock},
    {"setlog",setlog},
    {"setuser",setuser},
    {"sysvar",getsysvar},
    {"sysmsg",getsysmsg},
    {"log",logline},
    {"version",version},
    {"nodelist",nodelist},
    {"mailer",mailer},
    {"recfile",recfile},
    {"reqfile",reqfile},
    {"upduser",upduser},
    {"counter",counter},
    {"getflst",getflst},
    {"reset",reset},
    {"quiet",goquiet},
    {"translate",transtxt},
    {NULL}
};

enum vtype { s20, s40, s80, sp26, sr26, byt, wd, lwd, wp, dt, tl, ct };

enum action { act_sleep, act_die, act_newarea };

typedef struct
{
    char *cmd;
    char type;
    char *val;
}
LINEVAR;
/*---------------------------------------------------------------------------*/
static LINEVAR ltbl[] =
{
    {"user", wd,   (char *)&line[0].user},
    {"name", s40,  (char *)&line[0].name},
    {"city", s40,  (char *)&line[0].city},
    {"pass", s20,  (char *)&line[0].pass},
    {"powe", sp26, (char *)&line[0].powers},
    {"mare", sp26, (char *)&line[0].mareas},
    {"fare", sp26, (char *)&line[0].fareas},
    {"ltim", lwd , (char *)&line[0].ltime},
    {"logi", lwd , (char *)&line[0].login},
    {"exit", s40,  (char *)&line[0].exitcmd},
    {"stat", s80,  (char *)&line[0].status},
    {"mnam", s40,  (char *)&line[0].mname},
    {"fnam", s40,  (char *)&line[0].fname},
    {"even", sp26, (char *)&line[0].event},
    {"edit", byt,  (char *)&line[0].editor},
    {"prot", byt,  (char *)&line[0].protocol},
    {"menu", byt,  (char *)&line[0].menus},
    {"term", byt,  (char *)&line[0].term},
    {"lang", byt,  (char *)&line[0].lang},
    {"more", byt,  (char *)&line[0].more},
    {"widt", wd ,  (char *)&line[0].width},
    {"line", wd ,  (char *)&line[0].lines},
    {"tmpd", wp ,  (char *)&line[0].tmpd},
    {"tmtd", wp ,  (char *)&line[0].tmtd},
    {"ltms", dt ,  (char *)&line[0].ltime},
    {"logs", dt ,  (char *)&line[0].login},
    {"dnpd", wp ,  (char *)&line[0].dnpd},
    {"dntd", wp ,  (char *)&line[0].dntd},
    {"tagk", wp ,  (char *)&line[0].tagk},
    {"tagn", wp ,  (char *)&line[0].tagn},
    {"call", wp ,  (char *)&line[0].calls},
    {"upld", wp ,  (char *)&line[0].uplds},
    {"dnld", wp ,  (char *)&line[0].dnlds},
    {"msgs", wp ,  (char *)&line[0].msgs},
    {"yell", wp ,  (char *)&line[0].yells},
    {"drop", wp ,  (char *)&line[0].drops},
    {"cmsg", wp ,  (char *)&line[0].cmsg},
    {"cfil", wp ,  (char *)&line[0].cfile},
    {"tlef", tl ,  (char *)&line[0].tmpd},
    {"cltm", ct ,  (char *)&line[0].login},
    {"lgch", lwd,  (char *)&line[0].lgch},
    {"msgi", s80,  (char *)&line[0].msgid},
    {"baud", lwd,  (char *)&line[0].baud},
    {"chat", byt,  (char *)&line[0].chat},
    {"inus", byt,  (char *)&line[0].inuse},
    {"eoli", byt,  (char *)&line[0].eoline},
    {"ttyp", byt,  (char *)&line[0].ttype},
    {"opro", byt,  (char *)&line[0].oprot},
    {"oarc", byt,  (char *)&line[0].oarch},
    {"char", byt,  (char *)&line[0].charset},
    {"otim", lwd,  (char *)&line[0].otime},
    {"oopt", sp26, (char *)&line[0].oopts},
    {"uopt", sp26, (char *)&line[0].uopts},
    {"mono", lwd,  (char *)&line[0].mono},
    {"moni", lwd,  (char *)&line[0].moni},
    {NULL}
};
/*--------------------------------------------------------------------------*/
int     leap_year(int year)
{
        if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0)
           return(1);
        return(0);
}
/*--------------------------------------------------------------------------*/
long getmonth(long time)
{
long spd,spl,spy,secs,year,siy,f;
int mlen[] = {31,28,31,30,31,30,31,31,30,31,30,31};

  spd = 60*60*24;               /* seconds in a day */
  spy = spd * 365;              /* seconds in a year */
  spl = spd + spy;              /* seconds in a leap year */
  secs = time;                  /* seconds left */
  year = 1961;                  /* clock starts at 1961 */

  while(1)
  {
    siy = spy;                  /* seconds in this year */
    if (leap_year(year))
      siy += spd;               /* adjust for leap year */
    if (secs < siy)
       break;                   /* inside this year */
    secs -= siy;
    year++;
  }
  if (leap_year(year))
     mlen[1]++;                 /* adjust Feb length if in a leap year */
  for(f=0; f<12; f++)
  {
     secs -= (spd * mlen[f]);
     if (secs < 0)
     {                          /* we are inside this month */
       f *= 3;                  /* offset inside string */
       return(f);
     }
  }
  return(0);                    /* should never get here */
}
/*--------------------------------------------------------------------------*/
long getday(long time)
{
long spd,dy;

  spd = 60*60*24;               /* seconds in a day */
  dy  = time/spd;               /* whole days */
  dy++;                         /* day we are in */
  dy %= 7;                      /* day of week (0 = saturday) */
  dy *= 3;                      /* offset into string */
  return (dy);
}

/*---------------------------------------------------------------------------*/
int main (int ac, char **av)
{
int  ctx;
short done = 0;
CMDTABLE *pct;
char *p;
char *sp;    /* stack pointer  */
short nc;    /* no of channels */
short mlen;  /* cmdline length */
char f;

    ac = ac;            /* to keep compiler happy */

    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    sp += (nc << 2);            /* skip channels        */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;                    /* skip length          */
    if(mlen)                    /* parse the command line */
    {
      char *a;
      a = sysdat;

      while ( *sp != '\0' && *sp != ' ' && mlen > 0)
      {
        *a++ = *sp++;           /* copy string      */
        mlen--;
      }
      *a = '\0';                /* terminate with a null */
    }
    else
     (void)strcpy(sysdat, FNAME);
    sysdat_base = NULL;

    for (f = 0; f < numlangs; f++)
      msgbase[f] = NULL;

    (void)mt_prior(-1,64);              /* make me important */

    set_defaults();                     /* set the "one time" variables */
    init_defaults();                    /* and the resettable ones */

    if ((ctx = UseSrvThg (SRVR, NAME)) == 0)
    {
        short rlen;

        while (!done)
        {
            ctx = SrvPoll (NAME, 5, &p, &rlen);
            if (ctx >= 0)
            {
                if(p)
                {
                for (pct = ctbl; pct->cmd; pct++)
                {
                    if (strnicmp (pct->cmd, p, strlen (pct->cmd)) == 0)
                    {
                        (void)(pct->func) (ctx, p, rlen);
                        break;
                    }
                }
                if (pct->cmd == NULL)
                {
                    if(ctx > 0)(void)SrvRply (ctx, "-Error, bad request", 19);
                }
                free (p);
                }
            }
            else if(ctx != -1)
            {
                done = 1;
            }
        }
        ctx = 0;
    }
    else
      exit (-15);
return ctx;
}
/*---------------------------------------------------------------------------*/
void init_defaults(void)
{
long ch, fsiz;
char tempbuff[80];
short l;
char c;
long ferr, membase, got;
char *ptr, *tptr;

  sysdir[0]  = '\0';   /* first setup defaults in case no entry in dat file */
  sysmsg[0]  = '\0';
  userdbs[0] = '\0';
  fareas[0]  = '\0';
  mareas[0]  = '\0';
  pboxlog[0] = '\0';
  flist[0]   = '\0';
  magic[0]   = '\0';
  feeds[0]   = '\0';
  sconn[0]   = '\0';
  quiet[0]   = '\0';
  listable[0] ='\0';
  tempdir[0] = '\0';
  lockon = 0;

    if (sysdat_base != NULL)
      (void)mt_rechp(sysdat_base);
    if (sysdat_idx != NULL)
      (void)mt_rechp(sysdat_idx);
    for (c = 0; c < numlangs; c++)
    {
      if (msgbase[c] != NULL)
        (void)mt_rechp(msgbase[c]);
      if (msg_idx[c] != NULL)
        (void)mt_rechp(msg_idx[c]);
    }

    ch = io_open(sysdat,1);
    if(ch < 0)
      exit(-7);
    else
    {
      fsiz = fs_pos(ch,0,2);                    /* get file size */
      membase = (long)mt_alchp(fsiz+2, &got, -1); /* over sized to ensure NULL */
      if(membase < 0)
         exit(membase);
      (void)fs_pos(ch,0,0);                     /* back to file start */
      sysdat_base = (char *)membase;
      ferr=fs_load(ch, sysdat_base, fsiz);
      tptr = sysdat_base;
      tptr += fsiz;
      *tptr = '\0';
      if(ferr < 0)
        exit(ferr);
      (void)io_close(ch);
    }
    sysdat_idx = mkidx(sysdat_base);

    getstrg(sysdat_idx,sysdir,"SYSDIR");
    getstrg(sysdat_idx,userdbs,"USERDBS");
    getstrg(sysdat_idx,sysmsg,"SYSMSG");
    getstrg(sysdat_idx,sconn,"S_CONN");
    getstrg(sysdat_idx,feeds,"FEEDS");
    getstrg(sysdat_idx,pboxlog,"LOGFILE");
    getstrg(sysdat_idx,nodelists,"NODELIST_DAT");
    getstrg(sysdat_idx,magic,"MAGIC_DAT");
    getstrg(sysdat_idx,flist,"FILES");
    getstrg(sysdat_idx,fareas,"FAREAS");
    getstrg(sysdat_idx,mareas,"MAREAS");
    getstrg(sysdat_idx,quiet,"QUIET");
    getstrg(sysdat_idx,tempdir,"TEMPDIR");
    getstrg(sysdat_idx,listable,"FLIST_GRP");
    if(listable[0] == '-') listable[0] = '\0';
    getstrg(sysdat_idx,tempbuff,"LINES");
    nlines = (short)atoi(tempbuff);
    nlines++;                       /* add space for local line */
    if (nlines > maxlines)
      nlines = maxlines;

   for ( l = 0; l <= nlines; l++ )
   {
     line[l].user        =   0 ;
     line[l].chat        =  '0';
     line[l].inuse       =  '0';
     line[l].eoline      =   0 ;
   }
    (void)strcpy(tempbuff,sysmsg);
    (void)strcat(tempbuff,"0");
    ptr = tempbuff;
    ptr += strlen(tempbuff);
    ptr--;
    for (c = 0; c < numlangs; c++)
    {
      *ptr = '0'+c;
      ch = io_open(tempbuff,1);
      if(ch >= 0)
      {
        fsiz = fs_pos(ch,0,2);                    /* get file size */
        membase = (long)mt_alchp(fsiz+2, &got, -1);     /* over sized to ensure NULL */
        if (membase < 0)
           exit (membase);
        (void)fs_pos(ch,0,0);                     /* back to file start */
        msgbase[c] = (char *)membase;
        ferr=fs_load(ch, msgbase[c], fsiz);
        tptr = msgbase[c];
        tptr += fsiz;
        *tptr = '\0';
        if (ferr < 0)
          exit (ferr);
        (void)io_close(ch);
        msg_idx[c] = mkidx(msgbase[c]);
      }
      else
      {
        msgbase[c] = NULL;
        msg_idx[c] = NULL;
      }
    }
}
/*---------------------------------------------------------------------------*/
void set_defaults(void)
{
short l;

   for ( l = 0; l <= maxlines; l++ )
   {
     line[l].user        =   0 ;
     line[l].chat        =  '0';
     line[l].inuse       =  '0';
     line[l].eoline      =   0 ;
     line[l].mono        =   0 ;
     line[l].moni        =   0 ;
     line[l].lgch        =   0 ;        /* rem only clear these when server
                                           starts, so we retain channels
                                           between callers once set */
   }
    mainlgch = -1;
}
/*---------------------------------------------------------------------------*/
int mailer (int ctx, char *cmd, short rlen)
{
/*
        Log the message and get mailer zone:net/node safe for recfile
        then read mailer preferences to the line block
*/
char *ptr;
char *eol;
short lno;
long ch = -1;
long dbid = -1;
short l;

    rlen = rlen;        /* to keep compiler happy */

    ptr = cmd;
    ptr += 7;                   /* len of 'mailer ' */
    while( *ptr == ' ') ptr++;
    eol = ptr;
    while (isdigit(*eol)) eol++;
    *eol = '\0';
    lno = (short)atoi(ptr);
    *eol = ' ';
    ptr = eol;
    while( *ptr == ' ') ptr++;
    eol = ptr;                           /* ptr = start of zone */

    while((*eol != ' ') && (*eol != '\0')) eol++;
    *eol = '\0';                         /* terminate after address */
    (void)strcpy(line[lno].name,ptr);          /* copy mailer nr to name block */
    (void)strcpy(line[lno].status,sconn);      /* set status to  Connected to */
    (void)strcat(line[lno].status," \"");
    (void)strcat(line[lno].status,ptr);
    (void)strcat(line[lno].status,"\"");
    line[lno].user  = 0;                 /* 0 = unknown, -1 = in feeds_dbs */
    line[lno].pass[0] = '\0';            /* and set default tic pw */
    (void)strcpy(line[lno].city,"Y");          /* use dosnames */
    (void)strcpy(line[lno].powers,"zip_prg");  /* archiver */
    (void)strcpy(line[lno].mareas,"2+");       /* pktype */
    (void)strcpy(line[lno].fareas,"0001");     /* capability */
    (void)strcpy(line[lno].msgid,"using defaults");

   if(feeds[0] != '\0')
     ch = io_open(feeds,1);
   if (ch > 0 )
     dbid = fsd_open(ch);

   if (ch > 0 && dbid > 0 )
   {
     l = fsd_srch(dbid, field2, ptr);
     if (l >= 0)
     {
        line[lno].user = -1;
        l = fsd_get(dbid,  3,  2, &line[lno].city);
        if(line[lno].city[0] != 'Y')
           line[lno].city[0] = 'N';
        line[lno].city[1] = '\0';
        l = fsd_get(dbid,  2, 80, &line[lno].msgid);
        ptr = (char *)&line[lno].msgid;
        ptr += l;
        *ptr = '\0';
        l = fsd_get(dbid,  1, 20, &line[lno].pass);
        ptr = (char *)&line[lno].pass;
        ptr += l;
        *ptr = '\0';
        l = fsd_get(dbid,  4, 26, &line[lno].powers);
        ptr = (char *)&line[lno].powers;
        ptr += l;
        *ptr = '\0';
        l = fsd_get(dbid,  5, 26, &line[lno].mareas);
        ptr = (char *)&line[lno].mareas;
        ptr += l;
        *ptr = '\0';
        l = fsd_get(dbid,  6, 26, &line[lno].fareas);
        ptr = (char *)&line[lno].fareas;
        ptr += l;
        *ptr = '\0';
     }
     (void)fsd_close(dbid);
     (void)io_close(ch);
   }

    ptr = &cmd[3];                       /* fudge length so log works as */
    return(logline(ctx,ptr,strlen(ptr)));/* "log " is shorter than "mailer " */
}
/*---------------------------------------------------------------------------*/
int recfile (int ctx, char *cmd, short rlen)
{
/*
        Inbound file processing - for now just log the filenames
        Mailer on line is stored in line username as z:nnn/ddd
*/
char  *ptr;
char  *eol;
short lno;
char  msg[100];

    rlen = rlen;        /* to keep compiler happy */

    ptr = cmd;
    ptr += 8;                   /* len of 'recfile ' */
    while( *ptr == ' ') ptr++;
    eol = ptr;
    while (isdigit(*eol)) eol++;
    *eol = '\0';
    lno = (short)atoi(ptr);     /* ptr -> line number in string */
    (void)strcpy(msg,"log ");
    (void)strcat(msg,ptr);
    *eol = ' ';
    while( *eol == ' ') eol++;  /* points to filename */

    (void)strcat(msg," File \"");
    (void)strcat(msg,eol);
    (void)strcat(msg,"\"");
    return (logline(ctx,msg,strlen(msg)));
}
/*---------------------------------------------------------------------------*/
int extension(char* s, char* e)
{
char * dot;                         /* position of extension in filename */

  dot = strrchr(s,'.');             /* find the dot */
  if(dot == NULL)                   /* if no dot, try underscore */
     dot = strrchr(s,'_');
  if(dot == NULL)
     return(0);                     /* if no underscore either, no match */
  if(!strnicmp(&dot[1],e,3))
    return(1);
  return(0);
}
/*---------------------------------------------------------------------------*/
int unlock (int ctx, char *cmd, short rlen)
{
/*
        Unlock the bbs
*/
    cmd = cmd;          /* to keep compiler happy */
    rlen = rlen;

       lockon = 0;
       if(ctx > 0) return SrvRply (ctx, "OK", 2);       /* ok, done */
}
/*---------------------------------------------------------------------------*/
int islock (int ctx, char *cmd, short rlen)
{
/*
        Return the lock status of the bbs
*/
    cmd = cmd;          /* to keep compiler happy */
    rlen = rlen;

       if(lockon)
         if(ctx > 0) return SrvRply (ctx, "1", 1);
       if(ctx > 0) return SrvRply (ctx, "0", 1);
}
/*---------------------------------------------------------------------------*/
int lock (int ctx, char *cmd, short rlen)
{
/*
        Check that no lines are in use, and if none, lock the bbs
        Return 1 if locked successfully, 0 if not, 2 if already locked
*/
int on,f;

    cmd = cmd;          /* to keep compiler happy */
    rlen = rlen;

    if(lockon)
       if(ctx > 0) return SrvRply (ctx, "2", 1);    /* already locked */
    on = 0;
    for(f = 0; f < maxlines; f++)
      if(line[f].inuse != '0')  on++;   /* count how many lines are in use */

    if(on != 0)
    {
       lockon = 0;
       if(ctx > 0) return SrvRply (ctx, "0", 1);       /* in use, cant lock */
    }
    else
    {
       lockon = 1;
       if(ctx > 0) return SrvRply (ctx, "1", 1);       /* ok, locked */
    }
}
/*---------------------------------------------------------------------------*/
int offline (int ctx, char *cmd, short rlen)
{
/*
        Signal "line not in use"
*/
char *ptr;
char *eol;
short lno;

    rlen = rlen;        /* to keep compiler happy */

    ptr = cmd;
    ptr += 8;                   /* len of 'offline ' */
    while( *ptr == ' ') ptr++;
    eol = ptr;
    while (isdigit(*eol)) eol++;
    *eol = '\0';
    lno = (short)atoi(ptr);
    line[lno].inuse = '0';              /* not in use any more */
    fcomm[lno].act =  act_die;          /* ask daughter to die */
    if(ctx > 0) return SrvRply (ctx, "OK", 2);
}
/*---------------------------------------------------------------------------*/
int online (int ctx, char *cmd, short rlen)
{
/*
        Return 1 if ok to answer the line, zero if 'locked'
*/
char *ptr;
char *eol;
short lno;
long id;
char fjname[] = "Flist 0";

    rlen = rlen;        /* to keep compiler happy */

    ptr = cmd;
    ptr += 7;                   /* len of 'online ' */
    while( *ptr == ' ') ptr++;
    eol = ptr;
    while (isdigit(*eol)) eol++;
    *eol = '\0';
    lno = (short)atoi(ptr);
    if(lockon)
    {
       line[lno].inuse = '0';
       if(ctx > 0) return SrvRply (ctx, "0", 1);       /* no, dont answer */
    }
    else
    {
       line[lno].inuse = '1';
       fjname[6] = (char)48+lno;        /* patch jobname to include line nr */
       fcomm[lno].lno  = lno;           /* fill in communication table */
       fcomm[lno].act  = act_sleep;
       fcomm[lno].sort = -1;
       fcomm[lno].selc = -1;
       fc_nr = lno;                     /* set pointer for daughter job */
       id = jcall((char *)flistjob,fjname,4L,2000L,0L);
       fcomm[lno].id = id;
       if(ctx > 0) return SrvRply (ctx, "1", 1);       /* ok to answer */
    }
}
/*---------------------------------------------------------------------------*/
int upduser (int ctx, char *cmd, short rlen)
{
/*
        Update the current user's details to the file
*/
char  *ptr;
char  *eol;
short lno;
char  ans[100];
long  ch;
long  dbid;
short ferr;

    rlen = rlen;        /* to keep compiler happy */

    ptr = cmd;
    ptr += 8;                           /* len of 'upduser ' */
    while( *ptr == ' ') ptr++;
    eol = ptr;
    while (isdigit(*eol)) eol++;
    *eol = '\0';
    lno = (short)atoi(ptr);
    ans[0] = '\0';

   if(userdbs[0] != '\0')
     ch = io_open(userdbs,0);
   else
   {
      (void)strcpy(ans,"-Error. No users_dbs");
      if(ctx > 0) return SrvRply (ctx, ans, strlen(ans));
   }
   if (ch > 0 )
     dbid = fsd_open(ch);

   if (ch < 0 || dbid < 0 )            /* if the 'open' failed */
   {
      (void)strcpy(ans,"-Error opening users_dbs");
      if(ctx > 0) return SrvRply (ctx, ans, strlen(ans));
   }

   ferr = fsd_srch(dbid, field2, (char *)&line[lno].name);

   (void)fsd_put(dbid,  1,  2, &line[lno].user);
   (void)fsd_put(dbid,  2,  strlen((char *)&line[lno].name),   &line[lno].name);
   (void)fsd_put(dbid,  3,  strlen((char *)&line[lno].city),   &line[lno].city);
   (void)fsd_put(dbid,  4,  strlen((char *)&line[lno].pass),   &line[lno].pass);
   (void)fsd_put(dbid,  5,  strlen((char *)&line[lno].powers), &line[lno].powers);
   (void)fsd_put(dbid,  6,  strlen((char *)&line[lno].mareas), &line[lno].mareas);
   (void)fsd_put(dbid,  7,  strlen((char *)&line[lno].fareas), &line[lno].fareas);
   (void)fsd_put(dbid,  8,  4, &line[lno].ltime);
   (void)fsd_put(dbid,  9,  1, &line[lno].editor);
   (void)fsd_put(dbid, 10,  1, &line[lno].protocol);
   (void)fsd_put(dbid, 11,  1, &line[lno].menus);
   (void)fsd_put(dbid, 12,  1, &line[lno].term);
   (void)fsd_put(dbid, 13,  1, &line[lno].lang);
   (void)fsd_put(dbid, 14,  1, &line[lno].more);
   (void)fsd_put(dbid, 15,  2, &line[lno].width);
   (void)fsd_put(dbid, 16,  2, &line[lno].lines);
   (void)fsd_put(dbid, 17,  2, &line[lno].tmpd);
   (void)fsd_put(dbid, 18,  2, &line[lno].tmtd);
   (void)fsd_put(dbid, 19,  2, &line[lno].dnpd);
   (void)fsd_put(dbid, 20,  2, &line[lno].dntd);
   (void)fsd_put(dbid, 21,  2, &line[lno].calls);
   (void)fsd_put(dbid, 22,  2, &line[lno].uplds);
   (void)fsd_put(dbid, 23,  2, &line[lno].dnlds);
   (void)fsd_put(dbid, 24,  2, &line[lno].msgs);
   (void)fsd_put(dbid, 25,  2, &line[lno].yells);
   (void)fsd_put(dbid, 26,  2, &line[lno].drops);
   (void)fsd_put(dbid, 27,  2, &line[lno].cmsg);
   (void)fsd_put(dbid, 28,  2, &line[lno].cfile);
   (void)fsd_put(dbid, 29,  1, &line[lno].oprot);
   (void)fsd_put(dbid, 30,  1, &line[lno].oarch);
   (void)fsd_put(dbid, 31,  4, &line[lno].otime);
   (void)fsd_put(dbid, 32,  strlen((char *)&line[lno].oopts), &line[lno].oopts);
   (void)fsd_put(dbid, 33,  strlen((char *)&line[lno].uopts), &line[lno].uopts);
   (void)fsd_put(dbid, 34,  1, &line[lno].charset);

   if (ferr >= 0)
   {
      (void)strcpy(ans,"Updated");
      (void)fsd_updt(dbid);
   }
   else
   {
      (void)strcpy(ans,"Appended");
      (void)fsd_appn(dbid);
   }
   (void)fsd_close(dbid);
   (void)io_close(ch);
   if(ctx > 0) return SrvRply (ctx, ans, strlen(ans));
}
/*---------------------------------------------------------------------------*/
int reset   (int ctx, char *cmd, short rlen)
{
/*
        Reset the server variables and files
*/
    rlen = rlen;        /* to keep compiler happy */
    cmd = cmd;

    init_defaults();
    if(ctx > 0) return SrvRply (ctx, "OK", 2);
}
/*---------------------------------------------------------------------------*/
int version (int ctx, char *cmd, short rlen)
{
/*
        Return the server version number as a string
*/
    rlen = rlen;        /* to keep compiler happy */
    cmd = cmd;

    if(ctx > 0) return SrvRply (ctx, _version, 4);
}
/*---------------------------------------------------------------------------*/
int goquiet (int ctx, char *cmd, short rlen)
{
/*
        Return whether to run in quiet mode or not
*/
    rlen = rlen;        /* to keep compiler happy */
    cmd = cmd;

      if (quiet[0] == 'Y')                  /* return Y or N unchanged */
         if(ctx > 0) return SrvRply (ctx, "Y", 1);
      if (quiet[0] == 'N')
         if(ctx > 0) return SrvRply (ctx, "N", 1);
      if (lockon)                           /* anything else, return Y if */
         if(ctx > 0) return SrvRply (ctx, "Y", 1);      /* locked and N if unlocked   */
      if(ctx > 0) return SrvRply (ctx, "N", 1);
}
/*---------------------------------------------------------------------------*/
int setuser (int ctx, char *cmd, short rlen)
{
/*
        Setup the user for a bbs line
        and load in users details
*/
char *ptr;
char *eol;
long ch;
long dbid;
int  l;
short lno;
short user;
char ans[80];
char time[36];
short vw;

    rlen = rlen;        /* to keep compiler happy */

    ans[0] = '\0';
    ptr = cmd;
    ptr += 8;                   /* len of 'setuser ' */
    while( *ptr == ' ') ptr++;
    eol = ptr;
    while (isdigit(*eol)) eol++;
    *eol = '\0';
    lno = (short)atoi(ptr);
    ptr = eol;
    ptr++;
    while( *ptr == ' ') ptr++;

   if(userdbs[0] != '\0')
     ch = io_open(userdbs,1);
   else
   {
      (void)strcpy(ans,"-Error. No users_dbs");
      if(ctx > 0) return SrvRply (ctx, ans, strlen(ans));
   }
   if (ch > 0 )
     dbid = fsd_open(ch);

   if (ch < 0 || dbid < 0 )            /* if the 'open' failed */
   {
      (void)strcpy(ans,"-Error opening users_dbs");
      if(ctx > 0) return SrvRply (ctx, ans, strlen(ans));
   }
   user = fsd_srch(dbid, field2, ptr);

   if (user >= 0)
   {
      (void)fsd_get(dbid,  1,  2, &line[lno].user);
      vw = fsd_get(dbid,  2, 40, &line[lno].name);
        ptr = (char *)&line[lno].name;
        ptr += vw;
        *ptr = '\0';
      vw = fsd_get(dbid,  3, 40, &line[lno].city);
        ptr = (char *)&line[lno].city;
        ptr += vw;
        *ptr = '\0';
      vw = fsd_get(dbid,  4, 20, &line[lno].pass);
        ptr = (char *)&line[lno].pass;
        ptr += vw;
        *ptr = '\0';
      vw = fsd_get(dbid,  5, 26, &line[lno].powers);
        ptr = (char *)&line[lno].powers;
        ptr += vw;
        *ptr = '\0';
      vw = fsd_get(dbid,  6, 26, &line[lno].mareas);
        ptr = (char *)&line[lno].mareas;
        ptr += vw;
        *ptr = '\0';
      vw = fsd_get(dbid,  7, 26, &line[lno].fareas);
        ptr = (char *)&line[lno].fareas;
        ptr += vw;
        *ptr = '\0';
      (void)fsd_get(dbid,  8,  4, &line[lno].ltime);
      (void)fsd_get(dbid,  9,  1, &line[lno].editor);
      (void)fsd_get(dbid, 10,  1, &line[lno].protocol);
      (void)fsd_get(dbid, 11,  1, &line[lno].menus);
      (void)fsd_get(dbid, 12,  1, &line[lno].term);
      (void)fsd_get(dbid, 13,  1, &line[lno].lang);
      (void)fsd_get(dbid, 14,  1, &line[lno].more);
      (void)fsd_get(dbid, 15,  2, &line[lno].width);
      (void)fsd_get(dbid, 16,  2, &line[lno].lines);
      (void)fsd_get(dbid, 17,  2, &line[lno].tmpd);
      (void)fsd_get(dbid, 18,  2, &line[lno].tmtd);
      (void)fsd_get(dbid, 19,  2, &line[lno].dnpd);
      (void)fsd_get(dbid, 20,  2, &line[lno].dntd);
      (void)fsd_get(dbid, 21,  2, &line[lno].calls);
      (void)fsd_get(dbid, 22,  2, &line[lno].uplds);
      (void)fsd_get(dbid, 23,  2, &line[lno].dnlds);
      (void)fsd_get(dbid, 24,  2, &line[lno].msgs);
      (void)fsd_get(dbid, 25,  2, &line[lno].yells);
      (void)fsd_get(dbid, 26,  2, &line[lno].drops);
      (void)fsd_get(dbid, 27,  2, &line[lno].cmsg);
      (void)fsd_get(dbid, 28,  2, &line[lno].cfile);
      (void)fsd_get(dbid, 29,  1, &line[lno].oprot);
      (void)fsd_get(dbid, 30,  1, &line[lno].oarch);
      (void)fsd_get(dbid, 31,  4, &line[lno].otime);
      vw = fsd_get(dbid, 32,  26, &line[lno].oopts);
        ptr = (char *)&line[lno].oopts;
        ptr += vw;
        *ptr = '\0';
      vw = fsd_get(dbid, 33,  26, &line[lno].uopts);
        ptr = (char *)&line[lno].uopts;
        ptr += vw;
        *ptr = '\0';
      (void)fsd_get(dbid, 34,  1, &line[lno].charset);

      line[lno].mname[0]    = '\0';
      line[lno].fname[0]    = '\0';
      line[lno].event[0]    = '\0';
      line[lno].tagk        =   0 ;
      line[lno].tagn        =   0 ;
      line[lno].msgid[0]    = '\0';
      line[lno].chat        =  '0';
   }
   else
   {
     (void)strcpy(ans,"-Error finding \"");          /* cant find user */
     (void)strcat(ans,ptr);
     (void)strcat(ans,"\"");
   }
   (void)fsd_close(dbid);
   (void)io_close(ch);
   if( ans[0] == '-')
      if(ctx > 0) return SrvRply (ctx, ans, strlen(ans));

   line[lno].login = mt_rclck();              /* time of this login */

   (void)cn_date(time,line[lno].login);  /* get time strings for this call */
   (void)cn_date(ans,line[lno].ltime); /* and previous call (use Qdos) */
   l = strncmp(time+2,ans+2,11);       /* see if same day */
   if (l != 0)                           /* if it's a new day */
   {
     line[lno].tmtd = 0;                 /* reset the 'today' counters */
     line[lno].dntd = 0;
   }
   if(fareas[0] != '\0')
   {
     ch = io_open(fareas,1);
     if (ch > 0 )
     {
       dbid = fsd_open(ch);

       if (dbid > 0 )
       {
         user = fsd_srch(dbid, field1, &line[lno].cfile);

         if (user < 0)          /* if area doesnt exist, force area 1 */
         {
           (void)fsd_posa(dbid, 0);
           (void)fsd_get(dbid, 1, 2, &line[lno].cfile);
         }
         vw = fsd_get(dbid,  2, 40, &line[lno].fname);
           ptr = (char *)&line[lno].fname;
           ptr += vw;
           *ptr = '\0';

         (void)fsd_close(dbid);
       }
       (void)io_close(ch);
     }
   }
   if(mareas[0] != '\0')
   {
     ch = io_open(mareas,1);
     if (ch > 0 )
     {
       dbid = fsd_open(ch);

       if (dbid > 0 )
       {
         user = fsd_srch(dbid, field1, &line[lno].cmsg);

         if (user < 0)          /* if area doesnt exist, force area 1 */
         {
           (void)fsd_posa(dbid, 0);
           (void)fsd_get(dbid, 1, 2, &line[lno].cmsg);
         }
         vw = fsd_get(dbid,  2, 40, &line[lno].mname);
           ptr = (char *)&line[lno].mname;
           ptr += vw;
           *ptr = '\0';

         (void)fsd_close(dbid);
       }
       (void)io_close(ch);
     }
   }
   /* tell the flist task which area the user is in */
   ltoa(line[lno].cfile,fcomm[lno].cmd);
   fcomm[lno].selc = -1;
   fcomm[lno].act  =  act_newarea;        /* create selected list */

   if(ctx > 0) return SrvRply (ctx, "OK", 2);
}
/*---------------------------------------------------------------------------*/
int logline (int ctx, char *cmd, short rlen)
{
/*
        Send a message to the log channel. If first char is '+', prefix
        with spaces instead of current time, if first char is '-', no prefix.
        Sends message to file, also to channel mainlgch, also to per-line
        log channel
*/
char *ptr;
long ch;
int ferr;
char *eol;
short lno;
char lmsg[] = " 0 ";

    rlen = rlen;        /* to keep compiler happy */

    ptr = cmd;
    ptr += 4;                   /* len of 'log ' */
    while( *ptr == ' ') ptr++;
    eol = ptr;
    while (isdigit(*eol)) eol++;
    *eol = '\0';
    lno = (short)atoi(ptr);
    ptr = eol;
    ptr++;
    while( *ptr == ' ') ptr++;

    if( pboxlog[0] != '\0')
    {
      char linebuff[200];
      linebuff[0] = '\0';
      if (*ptr == '+')
      {
        (void)strcat(linebuff,"          ");
        ptr++;
        eol = &lmsg[1];           /* patch line number into string */
        *eol += (char)lno;
        (void)strcat(linebuff,lmsg);
      }
      else if (*ptr != '-')
      {
        int o;
        char *p;
        int t;
        short l;
        char txt[32];

        t = mt_rclck ();
        p = cn_date (txt, t);           /* get time from clock */
        l = 9;
        o = 11;
        (void)strncat(linebuff,p+o,l);
        eol = &lmsg[1];           /* patch line number into string */
        *eol += (char)lno;
        (void)strcat(linebuff,lmsg);
      }
      else
        ptr++;

      (void)strcat(linebuff,ptr);
      (void)strcat(linebuff,"\n");
      if(line[lno].lgch > 0)
        ferr = io_sstrg(line[lno].lgch,5,linebuff,strlen(linebuff));
      if (ferr < 0)                    /* if error */
        line[lno].lgch = -1;           /* mark log channel as closed */
     if(mainlgch > 0)
       ferr=io_sstrg(mainlgch,-1,linebuff,strlen(linebuff));
retry:
      ch = io_open(pboxlog,0);          /* open existing log */
      if ( ch >= 0 )
      {
        (void)fs_pos(ch,0L,2);
        ferr=io_sstrg(ch,-1,linebuff,strlen(linebuff));
        (void)io_close(ch);
      }
      else if (ch == -7)       /* not found */
      {
        ch = io_open(pboxlog,2);        /* open new log if no existing one */
        if ( ch >= 0 )
        {
          ferr=io_sstrg(ch,-1,linebuff,strlen(linebuff));
          (void)io_close(ch);
        }
      }
      else if (ch == -9)       /* in use */
      {
        (void)mt_susjb(-1,5,NULL);
        goto retry;
      }

      if (ferr >= 0)
        if(ctx > 0) return SrvRply (ctx, "OK", 2);
     if(ctx > 0) return SrvRply (ctx, "-Error accessing log",20);
    }
}
/*---------------------------------------------------------------------------*/
int setline (int ctx, char *cmd, short rlen)
{
/*
        Alter information in a line block
*/
char answer[200];
short lno;
char *ptr;
char *eol;
LINEVAR *pct;
char vc;
char *pc;
short vw;
short *pw;
long vl;
long *pl;
char *store;
long offset;
short oldval;

  rlen = rlen;        /* to keep compiler happy */

  answer[0] = '\0';
  ptr = &cmd[8];                /* len of 'setline ' */
  while (*ptr == ' ') ptr++;
  eol = ptr;
  while (isdigit(*eol)) eol++;
  *eol = '\0';
  lno = (short)atoi(ptr);
  ptr = eol;
  ptr++;
  while (*ptr == ' ') ptr++;
  offset = sizeof(struct line_data) * lno;   /* offset to start of right line */

  for (pct = ltbl; pct->cmd; pct++)
  {
      if (strnicmp (pct->cmd, ptr, strlen (pct->cmd)) == 0)
      {
         while (isgraph(*ptr)) ptr++;
         while (*ptr == ' ') ptr++;
         store = pct->val;
         store += offset;
         switch (pct->type)
         {
            case s20:
              (void)strncpy(store, ptr, 20);
              store[20] = '\0';
              if(ctx > 0) return SrvRply (ctx, "OK", 2);

            case s40:
              (void)strncpy(store, ptr, 40);
              store[40] = '\0';
              if(ctx > 0) return SrvRply (ctx, "OK", 2);

            case s80:
              (void)strncpy(store, ptr, 80);
              store[80] = '\0';
              if(ctx > 0) return SrvRply (ctx, "OK", 2);

            case  sp26:
              if (*ptr == '+')
              {
                pc = strchr(store,*(++ptr)); /* dont duplicate if already set */
                if (pc == NULL)
                {
                  pc = store;
                  pc += strlen(store);  /* point to nul on end of string */
                  *pc++ = *ptr;         /* replace with new char */
                  *pc = '\0';           /* append a new nul */
                }
              }
              else if (*ptr == '-')
              {
                pc = strchr(store,*(++ptr));
                if (pc != NULL)
                {
                  ptr = store;
                  ptr += strlen(store); /* point to nul on end of string */
                  if (ptr != store)
                  {
                    ptr--;              /* point to last char of string */
                    *pc = *ptr;         /* replace unwanted with last char */
                    *ptr = '\0';        /* append a new nul */
                  }
                  else
                  {
                    ptr = store;        /* was one char only, now its */
                    *ptr = '\0';        /* an empty string */
                  }
                }
              }
              else
              {
                (void)strncpy(store, ptr, 26);
                store[26] = '\0';
              }
              if(ctx > 0) return SrvRply (ctx, "OK", 2);

            case  byt:
              vc = *ptr;
              *store = vc;
              if(ctx > 0) return SrvRply (ctx, "OK", 2);

            case  wd:
              vw = (short)atoi(ptr);
              pw = (short *)store;
              vw &= 0x7fff;             /* limit to 32k so it stays +ve */
              *pw = vw;
              if(ctx > 0) return SrvRply (ctx, "OK", 2);

            case   wp:
              if (strnicmp (pct->cmd, "cfil", strlen (pct->cmd)) == 0)
                oldval = line[lno].cfile;
              if (*ptr == '+')
              {
                ptr++;
                vw = (short)atoi(ptr);
                pw = (short *)store;
                *pw += vw;
              }
              else if (*ptr == '-')
              {
                ptr++;
                vw = (short)atoi(ptr);
                pw = (short *)store;
                *pw -= vw;
              }
              else
              {
                vw = (short)atoi(ptr);
                pw = (short *)store;
                *pw = vw;
              }
              if (strnicmp (pct->cmd, "cfil", strlen (pct->cmd)) == 0)
              { /* tell the flist task that the user changed area */
                if ( vw != oldval)
                {
                  fcomm[lno].selc = -1;         /* current chan is invalid  */
                  (void)strcpy(fcomm[lno].cmd,ptr);   /* ptr -> ascii area number */
                  fcomm[lno].act = act_newarea;
                }
              }
              if(ctx > 0) return SrvRply (ctx, "OK", 2);

            case  lwd:
              vl = atol(ptr);
              pl = (long *)store;
              *pl = vl;
              if(ctx > 0) return SrvRply (ctx, "OK", 2);

            default:
              break;
         }
      }
    }
    (void)strcpy(answer,"-Error finding \"");         /* cant find variable name */
    (void)strcat(answer,ptr);
    (void)strcat(answer,"\"");
    if(ctx > 0) return SrvRply (ctx, answer, strlen(answer));
}
/*---------------------------------------------------------------------------*/
int getline (int ctx, char *cmd, short rlen)
{
/*
        Return information from the line data block
*/
char answer[200];
char monbuff[200];
char daybuff[200];
long ans;
char date[36];
short shrt;
short lno;
char *ptr;
char *eol;
LINEVAR *pct;
long offset;
long time;
char *store;
char c;

  rlen = rlen;        /* to keep compiler happy */

  answer[0] = '\0';
  ptr = &cmd[8];                /* len of 'getline ' */
  while (*ptr == ' ') ptr++;
  eol = ptr;
  while (isdigit(*eol)) eol++;
  *eol = '\0';
  lno = (short)atoi(ptr);
  ptr = eol;
  ptr++;
  while (*ptr == ' ') ptr++;    /* ptr points to varname */
  offset = sizeof(struct line_data) * lno;   /* offset to start of right line */

  for (pct = ltbl; pct->cmd; pct++)
  {
      if (strnicmp (pct->cmd, ptr, strlen (pct->cmd)) == 0)
      {
         store = pct->val;
         store += offset;

         switch (pct->type)
         {
            case  s20: case s40: case s80:
            case  sp26: case  sr26:
              if(ctx > 0) return SrvRply (ctx, store, strlen(store));

            case  byt:
              ptr = &answer[0];
              *ptr++ = *store;
              *ptr   = '\0';
              if(ctx > 0) return SrvRply (ctx, answer, 1);

            case  wd: case  wp:
              shrt = *((short *)store);
              ans = shrt;
              ltoa(ans,answer);
              if(ctx > 0) return SrvRply (ctx, answer, strlen(answer));

            case  lwd:
              ans = *((long *)store);
              ltoa(ans,answer);
              if(ctx > 0) return SrvRply (ctx, answer, strlen(answer));

            case  dt:
              c = line[lno].lang;               /* language */
              c -= '0';                         /* as a number */
              dayptr = &days[0];
              if (msgbase[c] != NULL)
              {
                getstrg(msg_idx[c],daybuff,"WEEKDAYS");
                dayptr = &daybuff[0];
              }
              monptr = &months[0];
              if (msgbase[c] != NULL)
              {
                getstrg(msg_idx[c],monbuff,"MONTHS");
                monptr = &monbuff[0];
              }
              offset = getday(*((long *)store));
              (void)strncpy(answer,dayptr+offset,3);
              answer[3] = ' ';
              answer[4] = '\0';
              (void)cn_date(date,*((long *)store));
              (void)strncat(answer,date+11,2);
              (void)strcat(answer," ");
              offset = getmonth(*((long *)store));
              (void)strncat(answer,monptr+offset,3);
              (void)strcat(answer," ");
              (void)strncat(answer,date+2,5);
              (void)strncat(answer,date+14,8);
              if(ctx > 0) return SrvRply (ctx, answer, strlen(answer));

            case  tl:
              shrt = line[lno].tmpd;    /* time per day */
              shrt -= line[lno].tmtd;   /* time in earlier calls today */
              time = mt_rclck();
              time -= line[lno].login;  /* time spent this call */
              time /= 60;               /* in minutes */
              ans = shrt - time;
              ltoa(ans,answer);
              if(ctx > 0) return SrvRply (ctx, answer, strlen(answer));

            case  ct:
              time = mt_rclck();
              time -= line[lno].login;  /* time spent this call */
              time /= 60;               /* in minutes */
              ltoa(time,answer);
              if(ctx > 0) return SrvRply (ctx, answer, strlen(answer));

            default:
              break;
         }
      }
  }
  if (answer[0] == '\0')
  {
    (void)strcpy(answer,"-Error finding \"");         /* cant find variable name */
    (void)strcat(answer,ptr);
    (void)strcat(answer,"\"");
  }
  if(ctx > 0) return SrvRply (ctx, answer, strlen(answer));
}
/*---------------------------------------------------------------------------*/
int getsysmsg (int ctx, char *cmd, short rlen)
{
/*
        Return message from the relevant messages_dat file
        depending on language setting of current user on line
        and his terminal type and his menu type
*/
char c;
char ans[202];
char *ptr;
char *eol;
short lno;
char lang;
char ttyp;

  rlen = rlen;        /* to keep compiler happy */

   ans[0] = '\0';                       /* no reply yet */
   c = 0;
   while (cmd[c] != '\0')
   {
     cmd[c]=toupper(cmd[c]);
     c++;
   }
   ptr = &cmd[7];                       /* len of 'sysmsg ' */
   while (*ptr == ' ') ptr++;
   eol = ptr;
   while (isdigit(*eol)) eol++;
   *eol = '\0';
   lno = (short)atoi(ptr);              /* get line number */
   lang =line[lno].lang;                /* and language for line */
   lang -= '0';                         /* as a number */
   ttyp =line[lno].charset;             /* and charset for line */
   ttyp -= '0';                         /* as a value */
   ptr = eol;                           /* get ptr -> name */
   ptr++;
   while (*ptr == ' ') ptr++;
   if (msgbase[lang] != NULL)
     getstrg(msg_idx[lang],ans,ptr);    /* look up name */
   if (*ans == '\0')
   {
     if (lang != 0)
     getstrg(msg_idx[0],ans,ptr);       /* try default language */
   }
   ansify(ans,lno);
   translate(ans,ttyp);
   if(ctx > 0) return SrvRply (ctx, ans, strlen(ans));
}
/*---------------------------------------------------------------------------*/
int getsysvar (int ctx, char *cmd, short rlen)
{
/*
        Return information from the current system_dat file
*/
char c;
char ans[200];
char *ptr;
char *eol;

  rlen = rlen;        /* to keep compiler happy */

   ans[0] = '\0';
   c = 0;
   while (cmd[c] != '\0')
   {
     cmd[c]=toupper(cmd[c]);
     c++;
   }
   ptr = &cmd[7];                       /* len of 'sysvar ' */
   while (*ptr == ' ') ptr++;
   eol = ptr;
   while( isgraph(*eol)) eol++;
   *eol   = '\0';
   getstrg(sysdat_idx,ans,ptr);
   if(ctx > 0) return SrvRply (ctx, ans, strlen(ans));
}
/*---------------------------------------------------------------------------*/
int transtxt (int ctx, char *cmd, short rlen)
{
/*
        translate a string to the right charset
*/
char *ptr;
char *eol;
short ttyp;

  rlen = rlen;        /* to keep compiler happy */

   ptr = &cmd[10];                       /* len of 'translate ' */
   while (*ptr == ' ') ptr++;
   eol = ptr;
   while (isdigit(*eol)) eol++;
   *eol = '\0';
   ttyp = (short)atoi(ptr);              /* get translate type */
   ptr = eol;
   ptr++;
   translate(ptr,ttyp);
   if(ctx > 0) return SrvRply (ctx, ptr, strlen(ptr));
}
/*---------------------------------  END  -----------------------------------*/
