;******************************************************************************
;
; Search memory for a matching string, equivalent to strfnd()
; Written in assembler as the C68 strfnd() function is far too slow.
;
; Find position of string1 inside string2, case dependant if case != 0
;
; The call parameters are:
;                               const char *    s1
;                               const char *    s2
;                                     int       case
; Returns -1 if no match,
; else returns pointer to position in s2
;
;******************************************************************************

.globl _memsearch

_memsearch:
        movem.l a0/a1/a2/a3/d7,-(sp)
        move.l  20+4(a7),a2     /* get s1 */
        move.l  20+8(a7),a1     /* and s2 */
        move.l  20+12(a7),d7    /* case if non-zero */
        tst.b   (a2)            /* looking for nul */
        beq     badx
restart:
        move.l  a2,a0           /* keep base of search string */
        move.l  a1,a3           /* and where we are looking */
lp:
        tst.b   (a1)            /* end of search area reached */
        beq     badx
        tst.l   d7
        beq     nocase
        move.b  (a0)+,d0
        cmp.b   (a1)+,d0
        beq     next
        cmpi.b  #97,d0
        blt     restart
        cmpi.b  #122,d0
        bgt     restart
        andi.b  #223,d0         /* mask 'a' to 'z' to uppercase */
        cmp.b   -1(a1),d0
        bne     restart
        bra     next
nocase:
        cmp.b   (a0)+,(a1)+
        bne     restart
next:
        tst.b   (a0)            /* found whole string */
        bne     lp
        move.l  a3,d0           /* match started here */
        sub.l   20+8(a7),d0     /* so this is offset */
        bra     bye
badx:
        moveq #-1,d0
bye:
        movem.l (sp)+,a0/a1/a2/a3/d7
        rts
