/*
        Job to asynchronously maintain file lists for users on the bbs
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <qdos.h>
#include <qptr.h>
#include <things.h>
#include <sms.h>
#include <csrvthg.h>
#include <database.h>

#include "pserve.h"


enum action { act_sleep, act_die, act_newarea };

/*---------------------------------------------------------------------------*/
int comp_area(long dbid,char *rec,struct fld_list fldef[],void *appcn)
{
   dbid = dbid;         /* keep compiler happy */
   return(  *(short *)(rec + fldef[1].fld_ptr) == *(short *)appcn  );
}
/*---------------------------------------------------------------------------*/
void flistjob(void)
{
short lno;
long ch   = -1;
long dbid = -1;
long ch2  = -1;
long dbd2 = -1;
short sort_order[4];
short ans;

     sort_order[0] =  3;     /* datestamp, descending */
     sort_order[1] = -1;
     sort_order[2] =  2;     /* filename, ascending */
     sort_order[3] =  1;

    lno = fc_nr;

    if(flist[0] != '\0')
      ch = io_open(flist,1);
    if (ch > 0 )
      dbid = fsd_open(ch);
    if (ch > 0 && dbid > 0 )
    {
      (void)fsd_ordr (dbid, 1, sort_order);   /* sort the database */
      fcomm[lno].sort = dbid;
      fcomm[lno].anum = -1;                   /* no selected area yet */
    }

    while(1)
    {
      switch (fcomm[lno].act)
      {
      case act_die:
           if (dbid > 0)
             (void)fsd_close(dbid);
           if (dbd2 > 0)
             (void)fsd_close(dbd2);
           if (ch > 0)
             (void)io_close(ch);
           if (ch2 > 0)
             (void)io_close(ch2);
           fcomm[lno].selc = -1;
           fcomm[lno].sort = -1;
           return;

      case act_newarea:
          ans = (short) atoi(fcomm[lno].cmd);   /* read the parameter  */
          fcomm[lno].act = act_sleep;           /* and free cmd buffer */
          if (ans != fcomm[lno].anum)           /* check we changed area */
          {
            if(ch2 < 0)
              ch2 = io_open(flist,1);
            if (ch2 > 0 )
              if (dbd2 < 0)
                dbd2 = fsd_open(ch2);
            if (ch2 > 0 && dbd2 > 0 )
            {
              (void)fsd_ordr (dbd2, 1, sort_order);   /* sort the database */
              (void)fsd_excld(dbd2, 0, 0);            /* exclude all records */
              (void)fsd_incld(dbd2,comp_area,&ans);   /* include this area */
              fcomm[lno].selc = dbd2;
            }
          }
          break;
      case act_sleep:
      default:
          (void)mt_susjb(-1,5,NULL);
          break;
      }
   }
}
/*---------------------------------------------------------------------------*/
