/*
                Pbox bulletin board server accessory routines
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <qdos.h>
#include <qptr.h>
#include <things.h>
#include <sms.h>
#include <csrvthg.h>
#include <database.h>

#include "pserve.h"

int nodelist (int ctx, char *cmd, short rlen);
int reqfile (int ctx, char *cmd, short rlen);
int counter (int ctx, char *cmd, short rlen);
int setlog (int ctx, char *cmd, short rlen);
void translate(char *p, char t);
void ansify(char *p, short lno);
int field1(long dbid,char *rec, struct fld_list fldef[],char *appcn);
int field2(long dbid,char *rec, struct fld_list fldef[],char *appcn);
void getstrg(char *base, char *var, char *text);
void reverse(char s[]);
void ltoa(long n, char s[]);
int getflst (int ctx, char *cmd, short rlen);
char *mkidx(char *s);
void report_freq(int lno, short area, char *name);

extern int logline (int ctx, char *cmd, short rlen);

char *mkidx(char *s)
{
/*
        Build an index to the text file pointed to by s
        Index entries are 2 pointers, token and value
*/

int count = 0;
char *ptr, *mem, *eol;
long got;
long *addr;

/* first work out how many entries there will be */

   ptr = s;
   while (1)
   {
     if (*ptr == '\0') break;   /* end of file */
     if (*ptr++ == '\n')
       if (*ptr != '*')
         count++;
   }
   count++;                     /* extra one so we end with a NULL */

   mem = mt_alchp((count*8), &got, -1);

   if (got <= 0)
     exit (got);

   ptr = s;
   addr = (long *)mem;
   while (1)
   {
     if (*ptr == '\0') break;      /* end of file */
     if (*ptr == '\n')
     {
       ptr++;
       if ((*ptr != '*') && (*ptr != '\0'))
       {
         *addr = (long)ptr;        /* store token */
         addr++;

         eol = strchr(ptr,'\n');   /* check for end of line */
         if (eol == NULL) break;

         ptr = strchr(ptr,'=');    /* find separator */
         if (ptr == NULL) break;

         if (ptr < eol)            /* check "=" is before "\n" */
         {
           ptr++;
           while (*ptr == ' ') ptr++;

           *addr = (long)ptr;        /* store value */
           addr++;
         }
         else
         {
           ptr = eol;
           addr--;
           *addr = 0;
         }
       }
     }
     else
       ptr++;
   }

   return (mem);
}

int nodelist (int ctx, char *cmd, short rlen)
{
/*
        Return the relevant portion of a nodelist entry as a string
*/
struct INDEX_ENTRY{
char    type;
char    spare;
short   zone;
short   net;
long    filepos;
};

  long  idxbase;
  struct INDEX_ENTRY idx;
  char nlfile[42];
  char entry[200];
  char temp[200];
  int ok;
  char *ptr;
  char *eol;
  char *tokptr;
  char *zptr;
  short tzone,tnet,tnode,tpoint;
  chanid_t ch;
  chanid_t nl;
  chanid_t ni;
  int l;
  char type;

    entry[0] = '\0';
    temp[0] = '\0';
    rlen = rlen;                /* keep compiler happy */

    ptr = cmd;
    ptr += 9;                   /* len of 'nodelist ' */
    while( *ptr == ' ') ptr++;
    eol = ptr;
    if( *ptr == '\0')
    {
      (void)strcpy(temp,"<Bad command - ");
      (void)strcat(temp,cmd);
      (void)strcat(temp,">");
      if(ctx > 0) return SrvRply (ctx, temp, strlen(temp));
    }
    type = *ptr;
    type = (char)tolower(type);         /* make lower case */

    if(strchr("bcspa",type) == NULL)    /* Board,City,Sysop,Phone,All */
    {
       type = 'a';
       eol = ptr;
    }
    else
    {
      ptr++;
      while( *ptr == ' ') ptr++;
      eol = ptr;
    }
    if( *ptr == '\0')
    {
      (void)strcpy(temp,"<Bad command - ");
      (void)strcat(temp,cmd);
      (void)strcat(temp,">");
      if(ctx > 0) return SrvRply (ctx, temp, strlen(temp));
    }
    tokptr = strchr(ptr, ':');
    if( tokptr == NULL)
    {
      (void)strcpy(temp,"<Bad zone - ");
      (void)strcat(temp,cmd);
      (void)strcat(temp,">");
      if(ctx > 0) return SrvRply (ctx, temp, strlen(temp));
    }
    zptr = ptr;                 /* keep this for later */
    tzone  = (short)atoi(ptr);
    ptr = tokptr;
    tokptr = strchr(ptr, '/');
    if (tokptr == NULL)
    {
      (void)strcpy(temp,"<Bad net - ");
      (void)strcat(temp,cmd);
      (void)strcat(temp,">");
      if(ctx > 0) return SrvRply (ctx, temp, strlen(temp));
    }
    tnet  = (short)atoi(ptr+1);
    tnode = (short)atoi(tokptr+1);
    tokptr = strchr(tokptr, '.');
    if (tokptr == NULL)
      tpoint = 0;
    else
      tpoint = atoi(tokptr+1);
    ch = io_open(nodelists,1);
    if(ch < 0)
    {
      (void)strcpy(temp,"<No nodelist_dat - ");
      (void)strcat(temp,nodelists);
      (void)strcat(temp,">");
      if(ctx > 0) return SrvRply (ctx, temp, strlen(temp));
    }
    ok = 0;                             /* assume entry is not found  */
    while(1)                            /* for each index in the file */
    {
      l = io_fline(ch, -1L, nlfile, 40); /* get the index name */
      if(l < 0)
        break;                          /* exit, no more indexes */
      nlfile[l-1] = '\0';
      ni = io_open(nlfile, 1);          /* open the index */
      if( ni >= 0)                      /* if opened ok */
      {
        l = io_fline(ni, -1L, nlfile, 40); /* get the nodelist name */
        if(l > 0)
        {
          nlfile[l-1] = '\0';
          idxbase = fs_pos(ni, 0, 1);   /* this is index start */
          nl = io_open(nlfile, 1);      /* open the nodelist */
          if ( nl >= 0 )
          {
            (void)fs_pos(ni, idxbase, 0);     /* goto start of index */
            idx.zone = -1;
            idx.net  = 0;
            while( (idx.zone != tzone) || (idx.net != tnet) )
            {                   /* find required zone:net in index */
               if (io_fstrg(ni, 100L, &idx, sizeof(idx)) != sizeof(idx))
                  break;        /* exit if end of index reached */
            }
            if( (idx.zone == tzone) && (idx.net == tnet) )
            {                   /* we found the zone:net in the index */
              l = fs_pos(nl, idx.filepos, 0);
              l = io_fline(nl, 100L, &temp, 200);  /* read net details */
              if(tnode == 0)
              {
                temp[l-1] = '\0';
                (void)strcpy(entry,temp);   /* keep a copy of the full string */
                tokptr  = strtok(temp, ",");
                tokptr  = strtok(NULL, ",");    /* tokptr -> node */
                ok = 1;
              }
              else
                ok = 0;

              while(ok == 0)
              {
                l = io_fline(nl, 100L, &temp, 200);
                if( l <= 0 )   /* end of nodelist */
                  break;
                temp[l-1] = '\0';
                (void)strcpy(entry,temp);   /* keep a copy of the full string */
                if( strstr(temp, ",") == temp)
                  tokptr = strtok(temp, ",");
                else
                {
                  if( strstr(temp,"Zone") == temp)  /* end of net reached */
                    break;
                  if( strstr(temp,"Host") == temp)  /* end of net reached */
                    break;
                  tokptr  = strtok(temp, ",");
                  tokptr  = strtok(NULL, ",");    /* tokptr -> node */
                }
                if(tokptr != NULL)
                  if( tnode == (short) atoi(tokptr))
                    ok = 1;     /* Found it */
              }                 /* end while scanning this net */
            }                   /* zone:net not in this index */
            (void)io_close(nl);       /* close nodelist */
          }                     /* failed to open nodelist */
        }                       /* cant read nodelist name */
        (void)io_close(ni);           /* close index */
      }                         /* failed to open index */
    }                           /* no more nodelists to scan */
    (void)io_close(ch);               /* close nodelist_dat */
    if(ok)
    {
      tokptr = entry;
      if(type != 'a')
      {
        tokptr  = strtok(NULL, ",");    /* tokptr -> board */
        if(type != 'b')
        {
          tokptr  = strtok(NULL, ",");    /* tokptr -> city */
          if(type != 'c')
          {
            tokptr  = strtok(NULL, ",");    /* tokptr -> sysop */
            if(type != 's')
              tokptr  = strtok(NULL, ",");    /* tokptr -> phone */
          }
        }
      }
      if(ctx > 0) return SrvRply (ctx, tokptr, strlen(tokptr));
    }
    else                        /* if not found in any nodelist */
    {
      (void)strcpy(temp,"<Unlisted system> ");
      (void)strcat(temp, zptr);
      if(ctx > 0) return SrvRply (ctx, temp, strlen(temp));
    }
}
/*---------------------------------------------------------------------------*/
int reqfile (int ctx, char *cmd, short rlen)
{
/*
       A file has been requested. Try to resolve the filename and return
       the full device_directory_filename of a match.
       Command line is line name|time|password
*/
char  *ptr;
char  *eol;
short l,area;
char  buf[100];
char  fname[34];
char  pswd[20];
char  tmstr[12];
long  ch,dbid;
char  flpass[20];
char  group[6];
long  fltime;
int   later;
long  updtime;
struct qdirect header;
int lyne = -1;
char mailer = 0;

    fname[0] = '\0';
    tmstr[0] = '\0';
    pswd[0]  = '\0';
    area = -1;
    rlen = rlen;        /* keep compiler happy */

    ptr = cmd;
    ptr += 8;                   /* len of 'reqfile ' */
    while( *ptr == ' ') ptr++;
    if(isdigit(*ptr))
      lyne = atoi(ptr);         /* get bbs line who made the request */
    else
    {
      mailer = 1;               /* and detect if it's a mailer */
      lyne = atoi(ptr+1);
    }
    while (*ptr != ' ') ptr++;
    while( *ptr == ' ') ptr++;
    eol = strchr(ptr,'|');      /* look for a timestr */
    if (eol == NULL)
    {
      (void)strncpy(fname,ptr,32);    /* just a filename */
      fname[32] = '\0';
    }
    else
    {
       *eol = '\0';             /* terminate here */
      (void)strncpy(fname,ptr,32);
      fname[32] = '\0';
      ptr = eol;
      ptr++;
      while( *ptr == ' ') ptr++;
      eol = strchr(ptr,'|');      /* look for a password */
      if (eol == NULL)
      {
        (void)strncpy(tmstr,ptr,12);    /* just a timestring */
        tmstr[11] = '\0';
      }
      else
      {
        (void)strncpy(tmstr,ptr,12);
        tmstr[11] = '\0';
        ptr = eol;
        ptr++;
        while( *ptr == ' ') ptr++;
        (void)strncpy(pswd,ptr,20);
        pswd[19] = '\0';
      }
    }
    if (fname[0] == '\0')
       if(ctx > 0) return SrvRply (ctx, "- no match", 10); /* empty name */
/*
   try magic names first - magic names are not passworded, but do allow
   update datestamps based on the file creation date.
*/
   ch = -1;
   if(magic[0] != '\0')                 /* is there a magic file */
   {
     ch = io_open(magic,1);             /* open for read only */
     if ( ch >= 0 )
     {
       l = 0;
       while ( l >= 0)
       {
         l = io_fline(ch,200,buf,100);  /* check each line in the magic file */
         if (l > 0)
         {
           buf[l-1] = '\0';             /* make sure line is terminated */
           if (strnicmp(buf,fname,strlen(fname)) == 0)
           {
              ptr = buf;
              ptr += strlen(fname);
              if(*ptr == ' ')           /* make sure it's whole of name */
              {
                while(*ptr == ' ') ptr++;
                (void)io_close(ch);
                ch = io_open(ptr,1);    /* open the magic filename */
                if(ch >=0)
                {
                  l = fs_headr(ch,-1,&header,64);
                  (void)io_close(ch);
                  if(l>0)
                  {
                    fltime = header.d_update;
                    if(tmstr[0] != '\0')      /* if we want an update date */
                    {
                      later = 0;
                      if(tmstr[0] == '+')     /* file stamp later than this */
                      {
                        later = 1;
                        updtime = atol(tmstr+1);
                      }
                      else if(tmstr[0] == '-')   /* file stamp earlier than this */
                      {
                        later = 0;
                        updtime = atol(tmstr+1);
                      }
                      else                   /* default to later than this */
                      {
                        later = 1;
                        updtime = atol(tmstr);
                      }
                      if(later)
                      {
                        if(fltime < updtime)     /* not later */
                        {
                           (void)strcpy(buf,"- File is newer than required date");
                           if(ctx > 0) return SrvRply (ctx, buf, strlen(buf));
                        }
                      }
                      else
                      {
                        if(fltime > updtime)         /* not earlier */
                        {
                           (void)strcpy(buf,"- File is older than required date");
                           if(ctx > 0) return SrvRply (ctx, buf, strlen(buf));
                        }
                      }
                    }
                    if (mailer) report_freq(lyne,area,ptr);
                    if(ctx > 0) return SrvRply (ctx, ptr, strlen(ptr));
                  }
                }
                else
                {
                  (void)strcpy(buf,"FREQ for missing MAGIC file \"");
                  (void)strcat(buf,ptr);
                  (void)strcat(buf,"\"");
                  (void)logline(ctx,buf,strlen(buf));
                  (void)strcpy(buf,"- Magic file missing. Please contact sysop");
                  if(ctx > 0) return SrvRply (ctx, buf, strlen(buf));
                }
              }
           }
         }
       }
     }
     (void)io_close(ch);                /* not a magic name */
   }
/*
   Not a magic name. Now try for name in files database
*/
   if(flist[0] != '\0')
     ch = io_open(flist,1);
   if (ch > 0 )
     dbid = fsd_open(ch);

   if (ch < 0 || dbid < 0 )            /* if the 'open' failed */
   {
      if(dbid >0)
        (void)fsd_close(dbid);
      (void)io_close(ch);
      (void)strcpy(buf,"-Error opening files_dbs");
      if(ctx > 0) return SrvRply (ctx, buf, strlen(buf));
   }
   l = fsd_srch(dbid, field2, &fname);        /* look for the filename */

   if (l >= 0)
   {
     l = fsd_get(dbid,  1,  2, &area);             /* if found, what area is it */
     l = fsd_get(dbid,  3,  4, &fltime);           /* timestamp of file */
     l = fsd_get(dbid,  6, 20, &flpass);           /* and required password */
     flpass[l] = '\0';
   }
   else
   {
     eol = strrchr(fname,'.');  /* if file.zip not found, try file_zip */
     if(eol != NULL)
     {
       *eol = '_';
       l = fsd_srch(dbid, field2, &fname);
       if (l >= 0)
       {
         l = fsd_get(dbid,  1,  2, &area);
         l = fsd_get(dbid,  3,  4, &fltime);
         l = fsd_get(dbid,  6, 20, &flpass);
         flpass[l] = '\0';
       }
       else
         *eol = '.';
     }
     else   /* there is no .ext  Were we asked for _ext  if so, try .ext */
     {
       eol = strrchr(fname,'_');
       if(eol != NULL)
       {
         *eol = '.';
         l = fsd_srch(dbid, field2, &fname);
         if (l >= 0)
         {
           l = fsd_get(dbid,  1,  2, &area);
           l = fsd_get(dbid,  3,  4, &fltime);
           l = fsd_get(dbid,  6, 20, &flpass);
           flpass[l] = '\0';
         }
         else
           *eol = '_';
       }
     }
   }
   (void)fsd_close(dbid);
   (void)io_close(ch);
   if(fareas[0] != '\0')
     ch = io_open(fareas,1);            /* now get the area directory name */
   if (ch > 0 )
     dbid = fsd_open(ch);

   if (ch < 0 || dbid < 0 )            /* if the 'open' failed */
   {
      if(dbid > 0)
        (void)fsd_close(dbid);
      if(ch > 0)
        (void)io_close(ch);
      (void)strcpy(buf,"-Error opening fareas_dbs");
      if(ctx > 0) return SrvRply (ctx, buf, strlen(buf));
   }
   l = fsd_srch(dbid, field1, &area);
   if (l < 0)
   {
      (void)fsd_close(dbid);
      (void)io_close(ch);
   }
   else
   {
      l = fsd_get(dbid,  5,  4, &group);        /* group the area is in */
      l = fsd_get(dbid,  4,  36, &buf);         /* read directory name */
      buf[l] = '\0';
      (void)strcat(buf,fname);
      (void)fsd_close(dbid);
      (void)io_close(ch);
      if(group[0] != '\0')                      /* if it's in a group */
      {
        if(mailer)                              /* mailer request */
        {
          if(strchr(listable,group[0]) == NULL)
             if(ctx > 0) return SrvRply (ctx, "- no match", 10); /* no access to group */
        }
        else
        {
          if(strchr(line[lyne].fareas,group[0]) == NULL)
             if(ctx > 0) return SrvRply (ctx, "- no match", 10); /* no access to group */
        }
      }         /* areas that aren't in a group are fully requestable */

      if(flpass[0] != '\0')             /* if a password is needed */
      {
        if(strnicmp(flpass,pswd, strlen(flpass)) != 0) /* but we dont match it */
          (void)strcpy(buf,"- Password failed");
      }
      if(tmstr[0] != '\0')              /* if we want an update date */
      {
        later = 0;
        if(tmstr[0] == '+')             /* file stamp later than this */
        {
          later = 1;
          updtime = atol(tmstr+1);
        }
        else if(tmstr[0] == '-')       /* file stamp earlier than this */
        {
          later = 0;
          updtime = atol(tmstr+1);
        }
        else                           /* default to later than this */
        {
          later = 1;
          updtime = atol(tmstr);
        }
        updtime += unixtoql;

        if(later)
        {
          if(fltime < updtime)         /* not later */
             (void)strcpy(buf,"- File is newer than required date");
        }
        else
        {
          if(fltime > updtime)         /* not earlier */
             (void)strcpy(buf,"- File is older than required date");
        }
      }
      if (mailer) report_freq(lyne,area,fname);
      if(ctx > 0) return SrvRply (ctx, buf, strlen(buf));
   }
/*
   try for name in private files area
*/
   if(fareas[0] != '\0')
     ch = io_open(fareas,1);
   if (ch > 0 )
     dbid = fsd_open(ch);

   if (ch < 0 || dbid < 0 )            /* if the 'open' failed */
   {
      if(dbid >0)
        (void)fsd_close(dbid);
      if(ch > 0)
        (void)io_close(ch);
      (void)strcpy(buf,"-Error opening fareas_dbs");
      if(ctx > 0) return SrvRply (ctx, buf, strlen(buf));
   }
   l = fsd_srch(dbid, field2, "PRIVATE");       /* look for the right area */
   if (l >= 0)
   {
      l = fsd_get(dbid,  4,  36, &buf);         /* read directory name */
      buf[l] = '\0';
      (void)strcat(buf,fname);                        /* add filename */
   }
   (void)fsd_close(dbid);
   (void)io_close(ch);
   later = io_open(buf,1);                      /* check it exists */
   if(later > 0)
   {
     (void)io_close(later);
     if(ctx > 0) return SrvRply (ctx, buf, strlen(buf));
   }
   else
   {
     eol = strrchr(buf,'.');  /* if file.zip not found, try file_zip */
     if(eol != NULL)
     {
       *eol = '_';
       later = io_open(buf,1);                      /* check it exists */
       if(later > 0)
       {
         (void)io_close(later);
         if(ctx > 0) return SrvRply (ctx, buf, strlen(buf));
       }
     }
     else   /* there is no .ext  Were we asked for _ext  if so, try .ext */
     {
       eol = strrchr(buf,'_');
       if(eol != NULL)
       {
         *eol = '.';
         later = io_open(buf,1);                      /* check it exists */
         if(later > 0)
         {
           (void)io_close(later);
           if(ctx > 0) return SrvRply (ctx, buf, strlen(buf));
         }
       }
     }
   }
   if(ctx > 0) return SrvRply (ctx, "- no match", 10); /* no sign of the file anywhere */
}
/*---------------------------------------------------------------------------*/
int counter (int ctx, char *cmd, short rlen)
{
/*
        No params means return string of current settings
        1 param means increase parm1 counter by 1
        2 params means set parm1 counter to value parm2 (usually to reset it)
*/
char *ptr;
char *eol;
int  parm, value;
char reply[100];
char val[6];

    rlen = rlen;                /* keep compiler happy */
    ptr = cmd;
    ptr += 7;                   /* len of 'counter' */
    while( *ptr == ' ') ptr++;  /* skip any whitespace */
    eol = ptr;
    if (*eol == '\0')           /* no params - build reply string */
    {
      reply[0] = '\0';
      for(parm=0; parm < numcounters; parm++)
      {
        ltoa(counters[parm],val);
        (void)strcat(reply,val);
        (void)strcat(reply," ");
      }
      if(ctx > 0) return SrvRply (ctx, reply, strlen(reply));
    }
    while (isdigit(*eol)) eol++;
    parm = atoi(ptr);           /* read which parameter to use */
    if ((parm >= numcounters) || (parm < 0))
    {
      if(ctx > 0) return SrvRply (ctx, "-Error, out of range", 20);
    }
    ptr = eol;
    while( *ptr == ' ') ptr++;  /* skip any whitespace */
    if (*ptr == '\0')           /* no second parameter */
    {
       counters[parm]++;
       if(ctx > 0) return SrvRply (ctx, "OK", 2);
    }
    value = atoi(ptr);           /* read value to set */
    counters[parm] = value;
    if(ctx > 0) return SrvRply (ctx, "OK", 2);
}
/*---------------------------------------------------------------------------*/
int setlog (int ctx, char *cmd, short rlen)
{
/*
        Set mainlgch to channel id provided as parameter
*/
char *ptr;

    rlen = rlen;                /* keep compiler happy */
    ptr = cmd;
    ptr += 7;                   /* len of 'setlog ' */
    while( *ptr == ' ') ptr++;
    mainlgch = atoi(ptr);
    if(ctx > 0) return SrvRply (ctx, "OK", 2);
}
/*---------------------------------------------------------------------------*/
void ansify(char *p, short lno)
{
/*
        If there are any embedded ansi sequences
           If the user wants colour
              strip the surrounding curly braces out
           else
              strip the ansi sequence AND the curly braces out
*/
char *s,*e;
char colour;

        colour = (strchr(line[lno].uopts,'C') != NULL);

        s = p;
        e = s;
        while(1)
        {
          s = strchr(s,'{');            /* start of ansi sequence */
          if (s == NULL) break;
          if (*(s+1) == 033)            /* if followed by ESC */
          {
            e = strchr(s,'}');
            if (e == NULL)              /* if there is no end char  */
               break;                   /* leave rest of line alone */
            else
            {
              if (colour)       /* show the ansi codes but not the braces */
              {
                (void)memmove(e,e+1,strlen(e));       /* strip out '}' */
                (void)memmove(s,s+1,strlen(s));       /* strip out '{' */
              }
              else                      /* dont show the codes or the braces */
              {
                (void)memmove(s,e+1,strlen(e));   /* strip '{' to '}' inclusive */
              }
            }
          }
          else          /* not an ansi sequence */
            s++;
        }
}
/*---------------------------------------------------------------------------*/
void translate(char *p, char t)
{
/*
        Translate any accented characters in the string pointed to by p
        The string conversion table is type 't' where
        1 = QL to ANSI
        2 = QL to PC8
        3 = QL to ASCII
        4 = ANSI to QL
        5 = PC8 to QL
        6 = ASCII to QL (void)
        7 to 9 are the same as 1 to 3, but operate on chars 128 to 178 only
        10= ANSI to PC8
        11= PC8 to ANSI
*/
unsigned char *c;
unsigned char *f = (unsigned char *)p;
unsigned char ch = 1;

        if ((t == 1) || (t == 7))
          c = &QL_ANSI[0];
        else if ((t == 2) || (t == 8))
          c = &QL_PC8[0];
        else if ((t == 3) || (t == 9))
          c = &QL_ASCII[0];
        else if (t == 4)
          c = &ANSI_QL[0];
        else if (t == 5)
          c = &PC8_QL[0];
        else if (t == 6)
          return;
        else if (t == 10)
          c = &ANSI_PC8[0];
        else if (t == 11)
          c = &PC8_ANSI[0];
        else
          return;

        if ((t < 7)||(t > 9))
        {
          while (ch != 0)
          {
            ch = *f;
            *f = *(c + ch);
            f++;
          }
        }
        else
        {
          while (ch != 0)
          {
            ch = *f;
            if ((ch > 127) && (ch < 179))
              *f = *(c + ch);
              f++;
          }
        }
}
/*---------------------------------------------------------------------------*/
int field1(long dbid,char *rec,struct fld_list fldef[],char *appcn)
{
   dbid = dbid;         /* keep compiler happy */
   return(  *(short *)(rec + fldef[1].fld_ptr) == *(short *)appcn  );
}
/*---------------------------------------------------------------------------*/
int field2(long dbid,char *rec, struct fld_list fldef[],char *appcn)
/*
        search the database for field 2 = required name
        return: 1 = match;  0 = no match.
*/
{
   struct QLSTR *string;
   int stln;
 
   dbid = dbid; /* keep compiler happy */
   /* make a pointer to field 2 */
   string = (struct QLSTR *) (rec + fldef[2].fld_ptr);
   stln = strlen(appcn);
   if (stln != string->qs_strlen)  return(0);
   return(strnicmp(string->qs_str,appcn,stln) == 0);

}
/*---------------------------------------------------------------------------*/
void getstrg(char *base, char *var, char *text)
{
/*
        Get the value associated with token "text" and return in "var"
*/
long *lptr;
char *cptr, *eol;
char c;
int  sz;

  lptr = (long *)base;
  sz = strlen(text);

  while(1)
  {
    cptr = (char *)*lptr++;

    if(cptr == NULL)          /* end of list reached */
    {
      (void)strcpy(var,"-Error finding \"");   /* cant find entry */
      (void)strcat(var,text);
      (void)strcat(var,"\"");
      break;
    }
    if ((strncmp(cptr,text,sz) == 0) && (cptr[sz] == ' '))
    {
      cptr = (char *)*lptr;
      eol = strchr(cptr,'\n');
      c = *eol;
      *eol = '\0';
      (void)strcpy(var,cptr);
      *eol = c;
      break;
    }
    lptr++;
  }
}
/*---------------------------------------------------------------------------*/
/* reverse string s in place */
void reverse(char s[])
{
  int c,i,j;
  for(i=0, j=strlen(s)-1; i<j; i++, j-- )
  {
    c = s[i];
    s[i] = s[j];
    s[j] = c;
  }
}
/*---------------------------------------------------------------------------*/
void ltoa(long n, char s[])
{
 int i, sign;

 if ((sign = n) < 0 )
    n = -n;
 i = 0;
 do {
       s[i++] = n % 10 + '0';
    }  while ((n /= 10) > 0);
 if (sign < 0)
    s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}
/*---------------------------------------------------------------------------*/
int getflst (int ctx, char *cmd, short rlen)
{
/*
        Return file list pointer for the required channel and type
*/
long ans;
short lno;
char *ptr;
char *eol;
char answer[12];

  rlen = rlen;                  /* keep compiler happy */
  ptr = &cmd[8];                /* len of 'getflst ' */
  while (*ptr == ' ') ptr++;
  eol = ptr;
  while (isdigit(*eol)) eol++;
  *eol = '\0';
  lno = (short)atoi(ptr);
  ptr = eol;
  ptr++;
  while (*ptr == ' ') ptr++;    /* ptr points to type (0 or 1) */
  ans = atoi(ptr);

  if(ans)                       /* selected database */
    ans = fcomm[lno].selc;
  else                          /* sorted whole database */
    ans = fcomm[lno].sort;

  ltoa(ans,answer);
  if(ctx > 0) return SrvRply (ctx, answer, strlen(answer));
}
/*---------------------------------------------------------------------------*/
void report_freq(int lno, short area, char *name)
{
/*
        Report a successful FREQ request
*/
long  ch;
char  buf[100];
char *ptr;

     (void)strcpy(buf,tempdir);
     (void)strcat(buf,"event0");
     ptr = &buf[0];
     ptr += strlen(buf);
     ptr--;
     *ptr += lno;                       /* patch line number in */
     ch = io_open(buf,0);               /* open existing file */
     if ( ch < 0 )
       ch = io_open(buf,2);             /* if fail, try open_new */
     if (ch >= 0)
     {
       (void)fs_pos(ch,0,2);            /* goto end of file */

       (void)io_sbyte(ch,100L,'F');
       (void)io_sbyte(ch,100L,'F');
       if (area >= 0)
       {
         ltoa(area,buf);
         (void)io_sstrg(ch,100L,buf,strlen(buf));
       }
       else
         (void)io_sbyte(ch,100L,'-');
       (void)io_sbyte(ch,100L,' ');
       (void)io_sstrg(ch,100L,name,strlen(name));
       (void)io_sbyte(ch,100L,10);
       (void)io_close(ch);
     }
}
