/*
 *   listfiles -  produce a sorted list of the most recent files in all
 *   areas the user has access to, either last month or since last call,
 *   or search for files matching a string in their name or description
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <time.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>
#include <database.h>

#define unixtoql 283996800              /* time conversion, 1970 to 1961 */

char _prog_name[] = "ListFiles";
char _version[] = "1.19";

char *flist, *fareas, *groups, *board, *phone, *head, *lang, *temp, *last;
char *morereq, *moretag, *yesno, *whfile, *inactive, *eoline, *flnf;
char *powers, *exceed, *tempdir, *istagged, *passmsg, *match;
char adir[38];
char pass[22];
char keywd[82];
long tagfile;
short lines, shown;
short tagk,tagn;
short dnpd,dntd;
short allow = 0;
long ipch;                      /* input channel  */
long opch;                      /* output channel */
long mono;
long fileDB = -1;
long fareaCH = -1;
long fareaDB = -1;
char lf[] = { '\r', '\n' };
char gt[] = { " >  " };
char empty = '\0';
char bbsline[6];
char lno,listype;
long timeout = 0;               /* inactivity timeout */
int  lf_eol = 0;
int nfiles = 0;
int cnt = 0;
short cnum = -1;
short anum;
int loglevel;

enum  list_type {list_month, list_call, list_keyword, list_name};

typedef struct _llist
{
    struct _llist *next;
    short posn;
    short anum;
    char txt[82];
}llist;
llist *head_ptr;
llist *run_ptr;
llist *tmp_ptr;

void log(int level, char *msg);
int askline(char *buf, short buflen);
/*--------------------------------------------------------------------------*/
char * sysmsg(char *varname)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"sysmsg ");
  (void)strcat(msg,bbsline);
  (void)strcat(msg," ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg,(short)strlen(msg), &rlen);
  if (a == NULL) return(&empty);
  *(a+rlen) = '\0';
  return(a);
}
/*---------------------------------------------------------------------------*/
int tag(char *name, char inarea)
{
char full[40];
char lbuff[102];
char temp[50];
long file,fsiz;
char *ptr;
int ok,len;
char f;
short rlen;

     if (allow)
     {
       if ((allow & 2) == 0)      /* check downloads allowed */
       {
         whfile = sysmsg("optna");
        io_sstrg(opch, -1, whfile, strlen(whfile));
        io_sstrg(opch, -1, lf, 2);
        if (mono)
        {
        io_sstrg(mono,  0, whfile, strlen(whfile));
        io_sstrg(mono,  0, lf, 2);
        }
        return(1);
       }
     }
    strcpy(full,adir);
    strcat(full,name);
    file = io_open(full,1);
    fsiz = 0;
    if(file >= 0)
    {
      fsiz = fs_pos(file,0,2);          /* goto end of file */
      io_close(file);
      fsiz /= 1024;                     /* calculate file size in K */
      fsiz++;
      ok = 1;                           /* assume it's going to be tagged */

      if (strchr(powers,'H') == NULL)   /* if limited downloads */
      {
         if ((dntd + tagk) > dnpd)
         {
            ok = 0;
            io_sstrg(opch, -1, exceed, strlen(exceed));
            io_sstrg(opch, -1, lf, 2);
            if (mono)
            {
            io_sstrg(mono,  0, exceed, strlen(exceed));
            io_sstrg(mono,  0, lf, 2);
            }
            log(32,"Download limit exceeded");
            return(-1);
         }
      }
      if (ok)
      {
        if (inarea)
          sprintf(temp,"%d %s",anum,full);
        else
          strcpy(temp,full);
        fs_pos(tagfile,0,0);                    /* goto start of taglist */
        while(1)
        {
          len = io_fline(tagfile,-1,lbuff,50);
          if (len <= 0)
            break;
          lbuff[len-1]='\0';
          if (stricmp(temp,lbuff) == 0)         /* got a match */
          {
            sprintf(lbuff,"\"%s\" %s",name,istagged);
            io_sstrg(opch, -1, lbuff, strlen(lbuff));
            io_sstrg(opch, -1, lf, 2);
            if (mono)
            {
            io_sstrg(mono,  0, lbuff, strlen(lbuff));
            io_sstrg(mono,  0, lf, 2);
            }
            ok = 0;
            break;
          }
        }
      }
      if (ok)
      {
        if (strchr(powers,'O') == NULL)   /* if password needed */
        {
          if (pass[0] != '\0')
          {
            for(f=0; f<3; f++)
            {
              io_sstrg(opch, -1, passmsg, strlen(passmsg));
              if (mono)
              io_sstrg(mono,  0, passmsg, strlen(passmsg));
              len = askline(lbuff,20);
              if (len < 0)      /* timed out getting response */
                 exit(len);
              if(strnicmp(lbuff,pass,strlen(pass)) != 0)
                ok = 0;
              else
              {
                ok = 1;
                break;
              }
            }
          }
        }
      }
      if (ok)
      {
        sprintf(lbuff,"Tag: %s %dk",name,fsiz);
        io_sstrg(opch, -1, lbuff, strlen(lbuff));
        io_sstrg(opch, -1, lf, 2);
        if (mono)
        {
        io_sstrg(mono,  0, lbuff, strlen(lbuff));
        io_sstrg(mono,  0, lf, 2);
        }
        log(16,lbuff);
        io_sstrg(tagfile,-1,temp,strlen(temp));
        io_sbyte(tagfile,-1,'\n');
        sprintf(temp,"setline 0 tagk +%d",fsiz);
        temp[8] += lno;
        (void) Request ("pbox", temp,-1, &rlen);
        strcpy(temp,"setline 0 tagn +1");
        temp[8] += lno;
        (void) Request ("pbox", temp,-1, &rlen);
      }
    }
    else
    {
      sprintf(lbuff,"%s \"%s\"",flnf,name);
      io_sstrg(opch, -1, lbuff, strlen(lbuff));
      io_sstrg(opch, -1, lf, 2);
      if (mono)
      {
      io_sstrg(mono,  0, lbuff, strlen(lbuff));
      io_sstrg(mono,  0, lf, 2);
      }
      sprintf(lbuff,"Failed tag: \"%s\"",name);
      log(32,lbuff);
    }
    return(0);
}
/*---------------------------------------------------------------------------*/
int comp_area(long dbid,char *rec,struct fld_list fldef[],void *appcn)
{
   return(  *(short *)(rec + fldef[1].fld_ptr) == *(short *)appcn  );
}
/*--------------------------------------------------------------------------*/
/* reverse string s in place */
void reverse(char s[])
{
  int c,i,j;
  for(i=0, j=strlen(s)-1; i<j; i++, j-- )
  {
    c = s[i];
    s[i] = s[j];
    s[j] = (char)c;
  }
}
/*--------------------------------------------------------------------------*/
void ltoa(long n, char s[])
{
 int i, sign;

 if ((sign = n) < 0 )
    n = -n;
 i = 0;
 do {  s[i++] = (char)(n % 10 + '0');  }
    while ((n /= 10) > 0);
 if (sign < 0)
    s[i++] = '-';
 s[i] = '\0';
 reverse(s);
}
/*--------------------------------------------------------------------------*/
char getkey(void)
/* fetch a key or timeout, ignoring line feeds if appropriate */
{
char c;
int ferr,tmo;

  tmo = timeout;
  while(1)
  {
    ferr = io_fbyte( ipch, 50, &c );
    if (ferr == 0)              /* if you got a byte, return it, */
    {
      if (lf_eol)               /* if eol code is line-feed */
         return(c);             /* return whatever you got */
      else                      /* if CR or CR/LF is eol code */
        if (c != '\n')          /* ignore LFs on the assumption */
           return(c);           /* it's from a CR/LF pair */
    }
    if (ferr == -1)             /* not complete, */
    {
      if(tmo > 0)               /* if not infinite timeout */
      {
        tmo--;
        if(tmo == 0)            /* see if timed out yet */
           return(0);
      }
    }
    if (ferr < -1)
        return(0);              /* catch xmit error, eof etc. */
  }
}

/*--------------------------------------------------------------------------*/
char * sysvar(char *varname)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"sysvar ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg,(short)strlen(msg), &rlen);
  if (a == NULL) return(&empty);
  *(a+rlen) = '\0';
  return(a);
}
/*--------------------------------------------------------------------------*/
char * getline(char *varname)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"getline ");
  (void)strcat(msg,bbsline);
  (void)strcat(msg," ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg, (short)strlen(msg), &rlen);
  if (a == NULL) return (&empty);
  *(a+rlen) = '\0';
  return(a);
}
/*--------------------------------------------------------------------------*/
void log(int level, char *value)
{
char msg[82];
char *a;
short rlen;

 if((loglevel & level) || (level == 0))
 {
  (void)strcpy(msg,"log ");
  (void)strcat(msg,bbsline);
  (void)strcat(msg," ");
  (void)strcat(msg,value);
  a=Request ("pbox", msg, (short)strlen(msg), &rlen);
  if (a != NULL) free(a);
 }
}
/*--------------------------------------------------------------------------*/
int askline(char *buf, short buflen)
{
   int len;
   char *ptr;
   char c;

   ptr = buf;
   len = 0;
   while(1)
   {
     c = getkey();
     if (c == 0) exit(-10);     /* eof or timeout */
     if (c == eoline[0])
     {
        *ptr = '\0';
        (void)io_sstrg(opch,-1,lf,2);
        if (mono)
        (void)io_sstrg(mono, 0,lf,2);
        return(len);                    /* return length, could be 0 */
     }
     if (c == 0)  return(-1);           /* or timeout */
     if ((c == 8) || (c == 127))        /* backspace */
     {
       if (len > 0)
       {
         ptr--;
         len--;
         (void)io_sbyte(opch,-1,8);
         (void)io_sbyte(opch,-1,' ');
         (void)io_sbyte(opch,-1,8);
         if (mono)
         {
         (void)io_sbyte(mono, 0,8);
         (void)io_sbyte(mono, 0,' ');
         (void)io_sbyte(mono, 0,8);
         }
       }
     }
     else
     {
       *ptr = c;
       ptr++;
       len++;
       if(len == buflen)  return(len);
       (void)io_sbyte(opch,-1,c);
       if (mono)
       (void)io_sbyte(mono, 0,c);
     }
   }
}
/*--------------------------------------------------------------------------*/
void askwhich(void)
{
char c;
char *ptr, *eol;
char answer[102];
char lbuff[102];
char one_name[42];
char agrp[4];
short len,f,posn,cpos;
short ans;
short wanted;
int ok;
/*
        Tag one or more comma separated filenames/numbers
*/
      io_sstrg(opch, -1, whfile, strlen(whfile));
      if (mono)
      io_sstrg(mono,  0, whfile, strlen(whfile));
      len = askline(answer,100);
      if (len < 0)      /* timed out getting response */
         exit(len);
      if (len == 0)
      {
        io_sstrg(opch, -1, lf, 2);
        if (mono)
        io_sstrg(mono,  0, lf, 2);
        return;
      }
      posn = fsd_curr(fileDB);  /* keep current position */
      ptr = eol = answer;
      while(1)                  /* for each entry */
      {
        while(*eol == ' ')      /* strip leading whitespace */
          eol++;
        if (*eol == '\0')       /* no more entries */
           break;
        ptr = eol;              /* start of entry */
        while((*eol != ',') && (*eol != ' ') && (*eol != '\0'))
          eol++;
        if (eol != ptr)         /* check for nul entry */
        {
           c = *eol;
           *eol = '\0';
           strcpy(one_name,ptr);        /* copy entry to "one_name" */
           *eol = c;
           c = 1;                       /* assume it's all numeric */
           for (f=0; f<strlen(one_name); f++)
           {
             if (!isdigit(one_name[f])) /* check all digits */
                c = 0;
           }
           if (c)       /* entry is a position in list */
           {
             wanted = (short)atoi(one_name);
             if ((wanted > 0) && (wanted <= cnt))
             {
               cpos = 0;
               tmp_ptr = head_ptr;
               while (1)
               {
                 wanted--;
                 if (wanted == 0)
                     break;
                 tmp_ptr = tmp_ptr->next;
               }
               anum = tmp_ptr->anum;
               ans = fsd_srch(fareaDB, comp_area, &anum);
               if (ans < 0)
               {
                 agrp[0] = '-';
                 agrp[1] = '\0';
                 adir[0] = '\0';
               }
               else
               {
                 ans = fsd_get(fareaDB, 5, 4, agrp);
                 ans = fsd_get(fareaDB, 4,36, adir);
                 adir[ans] = '\0';
                 cnum = anum;
               }
               strcpy(one_name,tmp_ptr->txt);           /* get filename */
               fsd_posa(fileDB,tmp_ptr->posn);          /* position here */
               len = fsd_get(fileDB,6,20,pass);         /* get password */
               pass[len] = '\0';
               tag(one_name,1);
             }
             else       /* bad number */
             {
                sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                io_sstrg(opch, -1, lbuff, strlen(lbuff));
                io_sstrg(opch, -1, lf, 2);
                if (mono)
                {
                io_sstrg(mono,  0, lbuff, strlen(lbuff));
                io_sstrg(mono,  0, lf, 2);
                }
             }
           }
           else  /* its a filename */
           {
             tmp_ptr = head_ptr;
             while (1)
             {
               c = strfnd(one_name,tmp_ptr->txt,0);
               if (c != -1)
                   break;
               if (tmp_ptr->next == NULL)
                  break;
               tmp_ptr = tmp_ptr->next;
             }
             if (c != -1)
             {
               anum = tmp_ptr->anum;
               ans = fsd_srch(fareaDB, comp_area, &anum);
               if (ans < 0)
               {
                 agrp[0] = '-';
                 agrp[1] = '\0';
                 adir[0] = '\0';
               }
               else
               {
                 ans = fsd_get(fareaDB, 5, 4, agrp);
                 ans = fsd_get(fareaDB, 4,36, adir);
                 adir[ans] = '\0';
                 cnum = anum;
               }
               fsd_posa(fileDB,tmp_ptr->posn);          /* position here */
               len = fsd_get(fileDB,6,20,pass);        /* get password */
               pass[len] = '\0';
               tag(one_name,1);
             }
             else       /* bad name */
             {
                sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                io_sstrg(opch, -1, lbuff, strlen(lbuff));
                io_sstrg(opch, -1, lf, 2);
                if (mono)
                {
                io_sstrg(mono,  0, lbuff, strlen(lbuff));
                io_sstrg(mono,  0, lf, 2);
                }
             }
           }
        }
        else
          eol++;
      }
      io_sstrg(opch, -1, lf, 2);
      if (mono)
      io_sstrg(mono,  0, lf, 2);
      fsd_posa(fileDB,posn);            /* restore position in list */
      mt_susjb(-1,80,NULL);
      cnum = -1;
}
/*---------------------------------------------------------------------------*/
char checkmore(void)
{
char c;
short len,f;

  if (morereq[0] != '0')
  {
    if (shown == lines)
    {
      shown = 0;
      len = strlen(moretag);
      io_sstrg(opch,-1, moretag, len);
      io_sbyte(opch,-1,' ');
      if (mono)
      {
      io_sstrg(mono, 0, moretag, len);
      io_sbyte(mono, 0,' ');
      }
      c = getkey();
      if (c == 0) exit(-10);     /* eof or timeout */
      if(strchr(yesno,c) != NULL)
      {
        if(morereq[0] == '2')
        {
          io_sbyte(opch,-1,0x0c);
          if (mono)
          io_sbyte(mono, 0,0x0c);
        }
        else
        {
          io_sbyte(opch,-1,'\r');
          if (mono)
          io_sbyte(mono, 0,'\r');
          for (f=0; f<len; f++)     /* wipe the prompt */
          {
            io_sbyte(opch,-1,' ');
            if (mono)
            io_sbyte(mono, 0,' ');
          }
          io_sbyte(opch,-1,'\r');
          if (mono)
          io_sbyte(mono, 0,'\r');
        }
      }
      if (c == yesno[0])
         return(0);
      if (c == yesno[1])
         return(0);
      if (c == yesno[2])
         return(-1);
      if (c == yesno[3])
         return(-1);
      io_sbyte(opch,-1,'\r');
      if (mono)
      io_sbyte(mono, 0,'\r');
      for (f=0; f<len; f++)     /* wipe the prompt */
      {
        io_sbyte(opch,-1,' ');
        if (mono)
        io_sbyte(mono, 0,' ');
      }
      io_sbyte(opch,-1,'\r');
      if (mono)
      io_sbyte(mono, 0,'\r');
      askwhich();
      return(1);
    }
  }
  return(0);
}
/*---------------------------------------------------------------------------*/
int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
long ch;
short rlen;
int  ans,a,f;
long fdate;
short fdown;
char aname[38];
char agrp[6];
char adesc[502];
char fname[38];
char fdesc[1002];
char full[38];
char padding[80];
char stars[80];
char lbuff[302];
struct tm *tp;
long file,fsiz;
char c1,c2;
char *s,*c,*t,*tmp;
int ok;
int  pad,l,lim,skip,ferr;
char m1[] = "setline 0 exitcmd = menu_prg curr";
char m2[] = "getflst 0 0";
char answer[82];
long endtime;

    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    if (nc != 2) exit(-15);     /* abort if no channels */
    ipch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    opch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;

    if(mlen)
      lno = atoi(sp);
    else
      lno = 0;

    listype = list_month;
    if (strfnd("call",sp,0)!= -1)
      listype = list_call;      /* show since last login */
    if (strfnd("keyw",sp,0) != -1)
      listype = list_keyword;   /* show files with word in description */
    if (strfnd("name",sp,0) != -1)
      listype = list_name;      /* show files matching part-name */

    m1[8] += lno;               /* patch line number into messages */
    m2[8] += lno;
    ltoa(lno,bbsline);          /* get it in ascii */

     if((ans=UseSrvThg (CLNT, "pbox")) == 0)
     {
       loglevel = 0xffff;
       t = Request ("pbox","sysvar loglevel",-1,&rlen);
       if (t != NULL)
       {
         t[rlen] = '\0';
         loglevel = atoi(t);
         free(t);
       }
       sprintf(lbuff,"%s %s",_prog_name,_version);
       log(1,lbuff);

      if(lno == 0)
        inactive = Request ("pbox","sysvar inactive0",-1,&rlen);
      else
        inactive = Request ("pbox","sysvar inactive",-1,&rlen);
      if (inactive == NULL)
        timeout = -1;
      else
      {
        inactive[rlen] = '\0';
        if(inactive[0] != '-')
          timeout = atol(inactive);
        if(timeout==0) timeout = -1;
      }
       eoline  = getline("eoli");
       lf_eol = (eoline[0] == '\n');

       fareas  = sysvar ("fareas");
       tempdir = sysvar ("tempdir");
       groups  = getline("fareas");
       morereq = getline("more");
       moretag = Request ("pbox", m1,-1, &rlen); /* dummy to set exit cmd */
       if (moretag != NULL) free(moretag);
       moretag = sysmsg("moretag");
       istagged = sysmsg("istagged");
       passmsg = sysmsg("password");
       yesno   = sysmsg("yesno");
       flnf    = sysmsg("flnf");
       exceed  = sysmsg("dlexceed");
       lang    = getline("lang");
       powers  = getline("power");
       temp    = getline("dnpd");
       dnpd    = (short)atoi(temp);
       temp    = getline("mono");
       mono    = atoi(temp);
       temp    = getline("dntd");
       dntd    = (short)atoi(temp);
       temp    = getline("tagk");
       tagk    = (short)atoi(temp);
       temp    = getline("tagn");
       tagn    = (short)atoi(temp);
       temp    = getline("lines");
       lines   = (short)atoi(temp);
       if(lines == 0) lines = 24;
       lines--;         /* allow for "more" prompt */

       fareaCH = io_open( fareas, 1 ); /* shared access open */
       if (fareaCH > 0 )
          fareaDB = fsd_open(fareaCH);

       if (fareaCH < 0 || fareaDB < 0 ) /* if the 'open' failed */
         exit(-1);

     if (listype == list_month)
     {
       endtime = mt_rclck();          /* time now */
       endtime -= (31*24*60*60);      /* time 1 month ago */
       last    = sysmsg("list30days");
     }
     else if (listype == list_call)
     {
       temp    = getline("ltim");
       endtime = atoi(temp);
       last    = sysmsg("listlast");
     }
     else
     {
       if (listype == list_keyword)
          temp = sysmsg("ksearch");
       else
          temp = sysmsg("nsearch");

       io_sstrg(opch, -1, temp, strlen(temp));
       io_sstrg(opch, -1, gt, 3);
       if (mono)
       {
       io_sstrg(mono,  0, temp, strlen(temp));
       io_sstrg(mono,  0, gt, 3);
       }
       rlen = askline(answer,80);
       if (rlen < 1) exit(0);
       strcpy(keywd,answer);
       keywd[rlen] = '\0';
       endtime = 0;
       temp    = sysmsg("listmatch");
       last = adesc;
       sprintf(last,"%s \"%s\"",temp,keywd);
     }
     if(morereq[0] == '2')
     {
       io_sbyte(opch,-1,0x0c);
       if (mono)
       io_sbyte(mono, 0,0x0c);
     }
#define elim 55
#define epad 24

     for(f=0;f<epad;f++)
       padding[f] = ' ';
     padding[epad] = '\0';
     for(f=0;f<78;f++)
       stars[f] = '*';
     stars[78] = '\0';

     head    = sysmsg("listhead");
     whfile  = sysmsg("whfile");
     io_sstrg(opch, -1, stars, strlen(stars));
     io_sstrg(opch, -1, lf, 2);
     if (mono)
     {
     io_sstrg(mono,  0, stars, strlen(stars));
     io_sstrg(mono,  0, lf, 2);
     }
     sprintf(lbuff,"* %-74.74s *",last);
     io_sstrg(opch, -1, lbuff, strlen(lbuff));
     io_sstrg(opch, -1, lf, 2);
     if (mono)
     {
     io_sstrg(mono,  0, lbuff, strlen(lbuff));
     io_sstrg(mono,  0, lf, 2);
     }
     sprintf(lbuff,"* %-74.74s *",head);
     io_sstrg(opch, -1, lbuff, strlen(lbuff));
     io_sstrg(opch, -1, lf, 2);
     io_sstrg(opch, -1, stars, strlen(stars));
     io_sstrg(opch, -1, lf, 2);
     io_sstrg(opch, -1, lf, 2);
     if (mono)
     {
     io_sstrg(mono,  0, lbuff, strlen(lbuff));
     io_sstrg(mono,  0, lf, 2);
     io_sstrg(mono,  0, stars, strlen(stars));
     io_sstrg(mono,  0, lf, 2);
     io_sstrg(mono,  0, lf, 2);
     }
     shown = 5;
     sprintf(lbuff,"%sTaglist0",tempdir);       /* open the taglist */
     s = lbuff;
     s += strlen(lbuff);
     s--;
     *s += lno;                  /* patch name to required line number */
     tagfile = io_open(lbuff,0);
     if (tagfile < 0)
       tagfile = io_open(lbuff,2);

       cnt = 50;
       while(1)
       {
         flist   = Request ("pbox", m2, -1, &rlen);
         if (flist == NULL) exit (-1);
         flist[rlen] = '\0';
         fileDB = atoi(flist);          /* get external list */
         free(flist);
         if(fileDB != -1)               /* -1 means no list (yet) */
           break;
         cnt--;
         if(cnt == 0)                   /* try 50 times (5 seconds) */
           exit(-1);
         mt_susjb(-1,5,NULL);           /* at 1/10 second intervals */
       }
       nfiles = fsd_rcnt(fileDB);      /* how many files in database */

     cnt = 0;
     cnum = -1;                         /* no current area */
     fsd_posa(fileDB,0);                /* position at start of files */
     for(f = 0; f < nfiles; f++)
     {
         ans = fsd_get(fileDB, 1, 2, &anum);
         if(anum != cnum)
         {
           ans = fsd_srch(fareaDB, comp_area, &anum);
           if (ans < 0)
           {
             agrp[0] = '-';
             agrp[1] = '\0';
             adir[0] = '\0';
             aname[0] = '\0';
           }
           else
           {
             ans = fsd_get(fareaDB, 5, 4, agrp);
             ans = fsd_get(fareaDB, 4, 36, adir);
             adir[ans] = '\0';
             ans = fsd_get(fareaDB, 2, 36, aname);
             aname[ans] = '\0';
             cnum = anum;
           }
         }
         ok = 0;                /* assume user cant have access */
         if (*agrp == '\0')     /* non-group files are always ok */
           ok = 1;
         if (strchr(groups,agrp[0]) != NULL)  /* user has access to this group */
         {
           ok = 1;                      /* assume ok to list */
           tmp = strchr(groups,agrp[0]);  /* but check for override */
           if (tmp != NULL)
             allow = atoi(tmp+1);
           if (allow)
           {
             if ((allow & 1) == 0)   /* check listing allowed */
               ok = 1;
             else
               ok = 0;
           }
         }
         if (ok)
         {
           ans = fsd_get(fileDB, 3, 4, &fdate);
           if (fdate < endtime)
             break;
           ans = fsd_get(fileDB, 2,36, &fname[0]);
           fname[ans] = '\0';
           ans = fsd_get(fileDB, 5,1000, &fdesc[0]);
           fdesc[ans] = '\0';
           if ((listype == list_keyword) && (strfnd(keywd,fdesc,0) == -1))
             ok = 0;
           if ((listype == list_name) && (strfnd(keywd,fname,0) == -1))
             ok = 0;
           if (ok)
           {
              ans = fsd_get(fileDB, 4, 2, &fdown);
              fdate -= unixtoql;
              tp = localtime(&fdate);
              strcpy(full,adir);
              strcat(full,fname);
              file = io_open(full,1);
              fsiz = 0;
              if(file >= 0)
              {
                fsiz = fs_pos(file,0,2);             /* goto end of file */
                io_close(file);
                fsiz /= 1024;                        /* calculate file size in K */
                fsiz++;
              }
              cnt++;
              tmp_ptr = malloc(sizeof(llist));
              if (head_ptr == NULL)           /* new list */
              {
                head_ptr = tmp_ptr;
                run_ptr = tmp_ptr;
              }
              else
              {
                run_ptr->next = tmp_ptr;      /* append to list */
                run_ptr = tmp_ptr;
              }
              run_ptr->next = NULL;
              strcpy(run_ptr->txt,fname);       /* store name */
              run_ptr->anum = cnum;             /* and area   */
              run_ptr->posn = fsd_curr(fileDB); /* current position */

              /* name, date, size in k, dloads, areaname */
              if (fsiz)
                sprintf(lbuff,"%3.3d  %-18.18s %02.2d/%02.2d/%02.2d %5.5dk [%04.4d] Area: %s",
                       cnt, fname, tp->tm_mday, (tp->tm_mon)+1, tp->tm_year,
                       fsiz, fdown, aname);
              else
                sprintf(lbuff,"%3.3d  %-18.18s %02.2d/%02.2d/%02.2d --??-- [%04.4d] Area: %s",
                       cnt, fname, tp->tm_mday, (tp->tm_mon)+1, tp->tm_year,
                       fdown, aname);
              io_sstrg(opch, -1, lbuff, strlen(lbuff));
              io_sstrg(opch, -1, lf, 2);
              if (mono)
              {
              io_sstrg(mono,  0, lbuff, strlen(lbuff));
              io_sstrg(mono,  0, lf, 2);
              }
              shown++;
              if(checkmore() == -1)
                 exit(0);
              lim = elim;
              c = &fdesc[0];
              s = c;
              l = strlen(c);
              if(l == 0)
              {
                io_sstrg(opch, -1, padding, strlen(padding));
                io_sstrg(opch, -1, "No Description", 14);
                io_sstrg(opch, -1, lf, 2);
                if (mono)
                {
                io_sstrg(mono,  0, padding, strlen(padding));
                io_sstrg(mono,  0, "No Description", 14);
                io_sstrg(mono,  0, lf, 2);
                }
                shown++;
                if(checkmore() == -1)
                   exit(0);
              }
              else
              {
                  while(l)
                  {
                    if(l <= lim)             /* less than a full line left */
                    {                        /* so it's last one to print */
                      io_sstrg(opch, -1, padding, strlen(padding));
                      io_sstrg(opch, -1, s, strlen(s));
                      io_sstrg(opch, -1, lf, 2);
                      if (mono)
                      {
                      io_sstrg(mono,  0, padding, strlen(padding));
                      io_sstrg(mono,  0, s, strlen(s));
                      io_sstrg(mono,  0, lf, 2);
                      }
                      shown++;
                      if(checkmore() == -1)
                        exit(0);
                      break;
                    }
                    else
                    {
                      c += lim;
                      while(*c != ' ')
                      {
                        if(c == s)
                          break;
                        c--;
                      }
                    }
                    if(c != s)
                    {
                      *c = '\0';
                      io_sstrg(opch, -1, padding, strlen(padding));
                      io_sstrg(opch, -1, s, strlen(s));
                      io_sstrg(opch, -1, lf, 2);
                      if (mono)
                      {
                      io_sstrg(mono,  0, padding, strlen(padding));
                      io_sstrg(mono,  0, s, strlen(s));
                      io_sstrg(mono,  0, lf, 2);
                      }
                      shown++;
                      if(checkmore() == -1)
                        exit(0);
                      l -= strlen(s);
                      s=c;
                      s++;
                      l--;
                    }
                    else
                    {
                      c += lim;
                      c -= 2;
                      c1 = *c;
                      *c = '-';
                      c++;
                      c2 = *c;
                      *c = '\0';
                      io_sstrg(opch, -1, padding, strlen(padding));
                      io_sstrg(opch, -1, s, strlen(s));
                      io_sstrg(opch, -1, lf, 2);
                      if (mono)
                      {
                      io_sstrg(mono,  0, padding, strlen(padding));
                      io_sstrg(mono,  0, s, strlen(s));
                      io_sstrg(mono,  0, lf, 2);
                      }
                      shown++;
                      if(checkmore() == -1)
                        exit(0);
                      l -= strlen(s);
                      *c = c2;
                      c--;
                      *c = c1;
                      s = c;
                    }
                  }                     /* end while l */
              }                         /* end description */
           }                            /* keyword match */
         }                              /* ok to have access */
       fsd_posr(fileDB,1);              /* next file */
     }                                  /* end for all files */
     if (cnt)
       askwhich();
     else
     {
       match   = sysmsg("matchfiles");
       io_sstrg(opch, -1, "0 ", 2);
       io_sstrg(opch, -1, match, strlen(match));
       io_sstrg(opch, -1, lf, 2);
       if (mono)
       {
       io_sstrg(mono,  0, "0 ", 2);
       io_sstrg(mono,  0, match, strlen(match));
       io_sstrg(mono,  0, lf, 2);
       }
       mt_susjb(-1,80,NULL);
     }
     fsd_close(fareaDB);
     io_close(fareaCH);
   }
   FreeSrvThg (CLNT, "pbox");
   return(0);
}
int (*_Cstart) () = main;
