     /*
        Lineditor for VT52 connections
     */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <ctype.h>
#include <string.h>
#include <csrvthg.h>
#include <sys/stat.h>

#define LLEN 74

char _prog_name[] = "Pbox Lineditor";
char _version[]   = "1.18";
char _copyright[] = "PA Borman";

   struct list
    {
        char          *text;     /* line text */
        struct list   *next;     /* ptr to next line */
    };

struct list *body;
struct list *insrt;
long ipch;                      /* input channel  */
long opch;                      /* output channel */
long flch;                      /* text file */
long timeout = 0;               /* inactivity timeout */
char inactive[82];
char flname[40];
char editcmd[82];
char editkeys[10];
char savedmsg[82];
char losemsg[82];
char addmsg[82];
char abrtmsg[82];
char suremsg[82];
char moremsg[82];
char ynmsg[5];
char more[2];
char lines[6];
char eoline[2];
short mlines;
unsigned short currline;

char  lf[] = { '\r', '\n' };
char rbo[] = { 0x08, ' ', 0x08 };
char pad[] = { ": " };
int  bbsline = 0;
int  lf_eol = 0;
int  ctrlz;

/*  forward declarations  */
void    reverse         (char s[]);
void    ltoa            (long n, char s[]);
unsigned char getkey    (void);
void    sysmsg          (char *varname, char *ans, short sz);
void    getline         (char *varname, char *ans, short sz);
void    sysvar          (char *varname, char *ans, short sz);
int     insert          (struct list **here, char *text);
void    free_list       (struct list *list);
int     readline        (unsigned char *buff, short l, short w);
void    savemsg         (long fch);
void    listlines       (void);
void    editline        (void);
void    insertline      (void);
void    loseline        (void);
void    abortmsg        (void);

/*--------------------------------------------------------------------------*/
/* reverse string s in place */
void reverse(char s[])
{
  int c,i,j;
  for(i=0, j=strlen(s)-1; i<j; i++, j-- )
  {
    c = s[i];
    s[i] = s[j];
    s[j] = (char)c;
  }
}
/*--------------------------------------------------------------------------*/
void ltoa(long n, char s[])
{
 int i, sign;

 if ((sign = n) < 0 )
    n = -n;
 i = 0;
 do {  s[i++] = (char)(n % 10 + '0');  }
    while ((n /= 10) > 0);
 if (sign < 0)
    s[i++] = '-';
 s[i] = '\0';
 reverse(s);
}
/*--------------------------------------------------------------------------*/
unsigned char getkey(void)
/* fetch a key or timeout, ignoring line feeds if appropriate */
{
unsigned char c;
int ferr,tmo;

  tmo = timeout;
  while(1)
  {
    ferr = io_fbyte( ipch, 50, (char *)&c );
    if (ferr == 0)              /* if you got a byte, return it, */
    {
      if (lf_eol)               /* if eol code is line-feed */
         return(c);             /* return whatever you got */
      else                      /* if CR or CR/LF is eol code */
        if (c != '\n')          /* ignore LFs on the assumption */
           return(c);           /* it's from a CR/LF pair */
    }
    if (ferr == -1)             /* not complete, */
    {
      if(tmo > 0)               /* if not infinite timeout */
      {
        tmo--;
        if(tmo == 0)            /* see if timed out yet */
           return(0);
      }
    }
    if (ferr < -1)
        return(0);              /* catch xmit error, eof etc. */
  }
}

/*--------------------------------------------------------------------------*/
void sysmsg(char *varname, char *ans, short sz)
{
char msg[82];
char lno[6];
char *a;
short rlen;

  (void)strcpy(msg,"sysmsg ");
  ltoa(bbsline,lno);
  (void)strcat(msg,lno);
  (void)strcat(msg," ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg,(short)strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen > sz)
      rlen = sz;
    (void)strncpy(ans,a,rlen);
    ans[rlen] = '\0';
    free(a);
  }
}
/*--------------------------------------------------------------------------*/
void getline(char *varname, char *ans, short sz)
{
char msg[82];
char lno[6];
char *a;
short rlen;

  (void)strcpy(msg,"getline ");
  ltoa(bbsline,lno);
  (void)strcat(msg,lno);
  (void)strcat(msg," ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg, (short)strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen > sz)
      rlen = sz;
    (void)strncpy(ans,a,rlen);
    ans[rlen] = '\0';
    free(a);
  }
}
/*--------------------------------------------------------------------------*/
void sysvar(char *varname, char *ans, short sz)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"sysvar ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg, (short)strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen > sz)
      rlen = sz;
    (void)strncpy(ans,a,rlen);
    ans[rlen] = '\0';
    free(a);
  }
}
/*--------------------------------------------------------------------------*/
int  main(int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
int n = ac;                     /* to keep compiler quiet */
char *currtxt, *wraptr;
struct list *tptr;
int ferr, f;
short wcnt;
char temp[6];
unsigned char c;

    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    if (nc != 2) exit(-15);     /* abort if no channels */
    ipch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    opch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;

    if(mlen == 0) exit(-15);
    *(sp+mlen) = '\0';          /* terminate command line */
    while(*sp == ' ') sp++;     /* skip leading whitespace */
    bbsline = atoi(sp);         /* 1st param is line number */

    if((n=UseSrvThg (CLNT, "pbox")) == 0)
    {
      if(bbsline == 0)
        sysvar("inactive0", inactive, sizeof(inactive)-1);
      else
        sysvar("inactive", inactive, sizeof(inactive)-1);
      if(inactive[0] != '-')
        timeout = atol(inactive);
      if(timeout==0) timeout = -1;

      sysmsg("linedcmd", editcmd, (short)sizeof(editcmd)-1);
      sysmsg("linedkeys", editkeys, (short)sizeof(editkeys)-1);
      sysmsg("lineddel", losemsg, (short)sizeof(losemsg)-1);
      sysmsg("linedadd", addmsg, (short)sizeof(addmsg)-1);
      sysmsg("msgsaved", savedmsg, (short)sizeof(savedmsg)-1);
      sysmsg("msgabort", abrtmsg, (short)sizeof(abrtmsg)-1);
      sysmsg("more", moremsg, (short)sizeof(moremsg)-1);
      sysmsg("abrtsure", suremsg, (short)sizeof(suremsg)-1);
      sysmsg("yesno", ynmsg, (short)sizeof(ynmsg)-1);
      getline("eoli", eoline, 1);
      lf_eol = (eoline[0] == '\n');
      getline("more", more, (short)sizeof(more)-1);
      getline("lines", lines, (short)sizeof(lines)-1);
      mlines=(short)atoi(lines);
      if (more[0] == '0')  mlines = -1;
      sysvar("tempdir", flname, (short)sizeof(flname)-1);
      (void)strcat(flname,"msg");      /* build the message name */
      ltoa(bbsline,temp);
      (void)strcat(flname,temp);
      (void)strcat(flname,"_tmp");

      flch = io_open(flname,0);        /* open the text file */
      if (flch < 0)
         flch = io_open(flname,3);      /* new file if not found */

       /* read any text from file in first */
       currline = 0;
       body = NULL;
       insrt = body;

       while(1)         /* read file in */
       {
          currtxt = malloc(LLEN);
          if (currtxt == NULL) break;           /* out of memory */
          ferr = io_fline(flch,-1,currtxt,LLEN-2,); /* read a line */
          if (ferr == -10)
             break;                             /* eof */
          if (ferr > 0)
             currtxt[ferr-1] = '\0';            /* lose the CR */
          currline++;
          (void)insert (&insrt,currtxt);
       }
       while(1)
       {
         /* read input channel into lines of text */
         wcnt = 0;
         ctrlz = 0;
         wraptr = NULL;
         while(1)
         {
            currtxt = malloc(LLEN);
            if (currtxt == NULL) break;           /* out of memory */
            if (wcnt)
              (void)strcpy(currtxt,wraptr);       /* copy any wrapped text */
            currline++;
            ferr = readline((unsigned char *)currtxt,LLEN-2,wcnt); /* read a line */
            wcnt = 0;
            if (ferr == -1) break;                /* error */
            if (ferr == -2)                       /* wrap needed */
            {
              wraptr = currtxt;
              wraptr += strlen(currtxt);
              while (*wraptr != ' ')
              {
                wraptr--;                         /* back to a space */
                wcnt++;
              }
              *wraptr = '\0';
              wraptr++;
              wcnt--;
              for (f=0;f<wcnt;f++)
                (void)io_sbyte(opch,-1,8);        /* backspace */
              for (f=0;f<wcnt;f++)
                (void)io_sbyte(opch,-1,32);       /* space */
              (void)io_sstrg(opch,-1,lf,2);       /* line feed */
            }
            (void)insert (&insrt,currtxt);
            if (ctrlz) break;                     /* exit if end of msg */
         }
         while(1)
         {
           (void) io_sstrg(opch,-1,lf,2);
           (void)io_sstrg(opch,-1,editcmd,(short)strlen(editcmd));
           c = getkey();
           if (c == 0) exit(-10);     /* eof or timeout */
           c = (unsigned char)toupper(c);

           if (c == editkeys[0])
              listlines();
           if (c == editkeys[1])
           {
              (void) io_sstrg(opch,-1,lf,2);
               currline = 0;
               tptr = body;                     /* first line of text */
               while(tptr)
               {
                 currline++;                    /* count how many lines */
                 insrt = tptr;                  /* and get new end posn */
                 tptr = tptr->next;
               }
              break;
           }
           if (c == editkeys[2])
           {
              insertline();
              break;
           }
           if (c == editkeys[3])
              loseline();
           if (c == editkeys[4])
              savemsg(flch);
           if (c == editkeys[5])
              abortmsg();
         }
      }
    }
    FreeSrvThg (CLNT, "pbox");
    return(0);
}
int (*_Cstart) () = main;

/*--------------------------------------------------------------------------*/
int askline(unsigned char *buf, short buflen)
{
   int len;
   unsigned char *ptr;
   unsigned char c;

   ptr = buf;
   len = 0;
   while(1)
   {
     c = getkey();
     if (c == 0) exit(-10);     /* eof or timeout */
     if (c == eoline[0])
     {
        *ptr = '\0';
        (void)io_sstrg(opch,-1,lf,2);
        return(len);                    /* return length, could be 0 */
     }
     if (c == 0)  return(-1);           /* or timeout */
     if ((c == 8) || (c == 127))        /* backspace */
     {
       if (len > 0)
       {
         ptr--;
         len--;
         (void)io_sstrg(opch,-1,rbo,3);
       }
     }
     else
     {
       *ptr = c;
       ptr++;
       len++;
       if(len == buflen)  return(len);
       (void)io_sbyte(opch,-1,c);
     }
   }
}
/*--------------------------------------------------------------------------*/
void    loseline       (void)
{
struct list *lptr, *sptr;
unsigned char num[6];
int    l,count;
short  tmo;

        tmo = (short)timeout;
        if(tmo != -1) tmo *= 50;                /* make it frames */
        (void) io_sstrg(opch,-1,lf,2);
        (void)io_sstrg(opch,-1,losemsg,(short)strlen(losemsg));
        l = askline(num,sizeof(num));
        if (l >= 0)
        {
          num[l] = '\0';
          l = atoi((char *)&num[0]);
          count = 1;
          if(l)
          {
             if(body == NULL) return;   /* quick exit if no lines */
             sptr = body;
             lptr = body;
             if(l == 1)                 /* remove first line */
             {
               body = body->next;
               insrt = body;
               free(sptr->text);
               free(sptr);
               return;
             }
             while(1)
             {
               if(l == count)
               {
                 sptr->next = lptr->next;
                 insrt = body;
                 free(lptr->text);
                 free(lptr);
                 break;
               }
               else
               {
                 if(lptr->next)
                 {
                   sptr = lptr;
                   lptr = lptr->next;
                   count++;
                 }
                 else
                   break;                /* must be past end of text */
               }
             }
          }
        }
}
/*--------------------------------------------------------------------------*/
void    insertline      (void)
{
struct list *sptr;
unsigned char num[6];
int    l;
unsigned short count;
short  tmo;

        if(body == NULL) return;   /* quick exit if no lines */
        tmo = (short)timeout;
        if(tmo != -1) tmo *= 50;                /* make it frames */
        (void) io_sstrg(opch,-1,lf,2);
        (void)io_sstrg(opch,-1,addmsg,(short)strlen(addmsg));
        l = askline(num,sizeof(num));
        if (l >= 0)
        {
          num[l] = '\0';
          l = atoi((char *)&num[0]);
          if(l == 0)
          {
            insrt = body;
            currline = 1;
            return;                /* insert before first line */
          }
          if(l > 0)
          {
             count = 1;
             l--;
             sptr = body;
             while(1)
             {
               if(l == count)
               {
                 insrt = sptr;
                 currline = count;
                 return;
               }
               else
               {
                 if(sptr->next)
                 {
                   sptr = sptr->next;
                   count++;
                 }
                 else
                 {
                   insrt = sptr;
                   currline = count;
                   return;                /* must be past end of text */
                 }
               }
             }
          }
        }
}
/*--------------------------------------------------------------------------*/
void    listlines       (void)
{
struct list *lptr;
char   num[6];
short  lnum, count;
unsigned char   c;

       lptr = body;                     /* first line of text */
       lnum = 0;
       count = 1;
       (void)io_sstrg(opch,-1,lf,2);
       while(1)                         /* write text to opch */
       {
         if(lptr == NULL) break;
         lnum++;
         count++;

         if (count == mlines)
         {
           (void)io_sstrg(opch,-1,moremsg,(short)strlen(moremsg));
            c = getkey();
            if (c == 0) exit(-10);     /* eof or timeout */
            c = (unsigned char)toupper(c);
            (void) io_sstrg(opch,-1,lf,2);
            if ((c == ynmsg[2]) || (c == ynmsg[3]))  break;
            count = 1;
         }
         ltoa (lnum,num);
         if (strlen(num)<3)
           (void)io_sbyte(opch,-1,' ');
         if (strlen(num)<2)
           (void)io_sbyte(opch,-1,' ');

         (void)io_sstrg(opch,-1,num,(short)strlen(num));
         (void)io_sstrg(opch,-1,pad,2);
         (void)io_sstrg(opch,-1,lptr->text, (short)strlen(lptr->text));
         (void)io_sstrg(opch,-1,lf,2);
         lptr = lptr->next;
       }
}
/*--------------------------------------------------------------------------*/
void    abortmsg        (void)
{
unsigned char c;

        (void) io_sstrg(opch,-1,lf,2);
        (void)io_sstrg(opch,-1,suremsg,(short)strlen(suremsg));
        c = getkey();
        if (c == 0) exit(-10);     /* eof or timeout */
        c = (unsigned char)toupper(c);
        (void) io_sstrg(opch,-1,lf,2);
        if ((c == ynmsg[0]) || (c == ynmsg[1]))
        {
           (void)io_sstrg(opch,-1,abrtmsg,(short)strlen(abrtmsg));
           exit(1);
        }
 }
/*--------------------------------------------------------------------------*/
void savemsg(long fch)
{
struct list *lptr;

       (void)fs_pos(fch,0,0);           /* rewind to file start */

       lptr = body;                     /* first line of text */
       while(1)                         /* write text to file */
       {
         if (lptr == NULL) break;
         (void)io_sstrg(fch,-1,lptr->text, (short)strlen(lptr->text));
         (void)io_sbyte(fch,-1,'\n');
         lptr = lptr->next;
       }
       (void)fs_trunc(fch,-1);
       (void)io_close(fch);
       (void) io_sstrg(opch,-1,lf,2);
       (void)io_sstrg(opch,-1,savedmsg,(short)strlen(savedmsg));
       exit(0);
}
/*--------------------------------------------------------------------------*/
int insert(struct list **here, char *text)
{
  /*
      Insert a new line into a linked list after given entry point
  */
  struct list *head_ptr;
  struct list *new_ptr;

  head_ptr = *here;
  if(head_ptr == NULL)          /* new list */
  {
    head_ptr = (struct list *)malloc(sizeof(struct list));
    head_ptr->text = text;
    head_ptr->next = NULL;
    *here = head_ptr;
    body = head_ptr;
    return(1);
  }
  new_ptr = (struct list *)malloc(sizeof(struct list));
  if (new_ptr == NULL)
    return(0);
  new_ptr->text = text;
  new_ptr->next = head_ptr->next;
  head_ptr->next = new_ptr;
  *here = new_ptr;
  return(1);
}
/*--------------------------------------------------------------------------*/
void free_list (struct list *list)
{
   struct list *next;

 if(list != NULL)
 {
   next = list->next;       /* first item in list is next */
   list->next = NULL;       /* and list is no more */

   while (next)
   {
      free (list->text);
      list = next;
      next = list->next;
      free (list);
   }
 }
}
/*--------------------------------------------------------------------------*/
int readline (unsigned char *buff, short l, short w)
{
short len = 0;
unsigned char  *ptr = buff;
char  num[6];
unsigned char  c;

   ltoa (currline,num);
   if (strlen(num)<3)
     (void)io_sbyte(opch,-1,' ');
   if (strlen(num)<2)
     (void)io_sbyte(opch,-1,' ');

   (void)io_sstrg(opch,-1,num,(short)strlen(num));
   (void)io_sstrg(opch,-1,pad,2);

   while (w > 0)                        /* show any wrapped text */
   {
     (void)io_sbyte(opch,-1,*ptr);
     ptr++;
     len++;
     w--;
   }
   while(1)
   {
     c = getkey();
     if (c == 0) exit(-10);     /* eof or timeout */
     if (c == eoline[0])
     {
        *ptr = '\0';
        (void)io_sstrg(opch,-1,lf,2);
        return(len);                    /* return length, could be 0 */
     }
     if (c == 0)  return(-1);           /* or timeout */
     if (c == 0x1a)
     {
        ctrlz = 1;
        *ptr = '\0';
        (void)io_sstrg(opch,-1,lf,2);
        return(len);                    /* or length + end of msg */
     }
     *ptr = c;
     switch(c)
     {
       case 8:
       case 127:
         if (len == 0)
           (void)io_sstrg(opch,-1,rbo,3);
         if (len > 0)
         {
           (void)io_sstrg(opch,-1,rbo,3);
           ptr--;
           len--;
         }
         break;
       default:
         (void)io_sbyte(opch,-1,c);
         ptr++;
         len++;
         if (len == l)  return(-2); /* wrap needed */
         break;
     }
   }
}
/*------------------------------- END ---------------------------------------*/
