 /*
        Info   - play a text file with/without 'more' prompts
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>
#include <database.h>

char _prog_name[] = "Pbox Info";
char _version[] = "v1.19";
long ipch;                      /* input channel  */
long opch;                      /* output channel */
long mono;                      /* monitor output */
long timeout=0;                 /* inactivity timeout */
char inactive[82];
char cmdline[82];
char yesno[6];
char exitmsg[82];
char sysdir[82];
char errfile[82];
char moremsg[82];
char presskey[82];
char uopts[26];
int  line = 0;
int  lf_eol = 0;
int loglevel;
char lf[] = { '\r', '\n' };
char ttyp;
char wt = 1;
char colour = 0;
/*---------------------------------------------------------------------------*/
void process(char *p)
{
/*
        If there are any embedded ansi sequences
           If the user wants colour
              strip the surrounding curly braces out
           else
              strip the ansi sequence AND the curly braces out
*/
char *s,*e;

        s = p;
        e = s;
        while(1)
        {
          s = strchr(s,'{');            /* start of ansi sequence */
          if (s == NULL) break;
          if (*(s+1) == 033)            /* if followed by ESC */
          {
            e = strchr(s,'}');
            if (e == NULL)              /* if there is no end char  */
               break;                   /* leave rest of line alone */
            else
            {
              if (colour)       /* show the ansi codes but not the braces */
              {
                memmove(e,e+1,strlen(e));       /* strip out '}' */
                memmove(s,s+1,strlen(s));       /* strip out '{' */
              }
              else                      /* dont show the codes or the braces */
              {
                memmove(s,e+1,strlen(e));   /* strip '{' to '}' inclusive */
              }
            }
          }
          else          /* not followed by ESC, so it's not an ansi sequence */
            s++;
        }
}
/*---------------------------------------------------------------------------*/
void translate(char *p, char t)
{
char *a;
short rlen;
char msg[220];

  sprintf(msg,"translate %c %s",t+6,p);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    *p = '\0';
  else
  {
    strcpy(p,a);
    free(a);
  }
}

char getkey(void)
/* fetch a key or timeout, ignoring line feeds if appropriate */
{
char c;
int ferr,tmo;

  tmo = timeout;
  while(1)
  {
    ferr = io_fbyte( ipch, 50, &c );
    if (ferr == 0)              /* if you got a byte, return it, */
    {
      if (lf_eol)               /* if eol code is line-feed */
         return(c);             /* return whatever you got */
      else                      /* if CR or CR/LF is eol code */
        if (c != '\n')          /* ignore LFs on the assumption */
           return(c);           /* it's from a CR/LF pair */
    }
    if (ferr == -1)             /* not complete, */
    {
      if(tmo > 0)               /* if not infinite timeout */
      {
        tmo--;
        if(tmo == 0)            /* see if timed out yet */
           return(0);
      }
    }
    if (ferr < -1)
        return(0);              /* catch xmit error, eof etc. */
  }
}

void sysmsg(char *varname, char *ans, int sz)
{
char msg[80];
char lno[4];
char *a;
short rlen;

  sprintf(msg,"sysmsg %d %s",line,varname);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen < sz) sz = rlen;
    strncpy(ans,a,sz);
    ans[sz] = '\0';
    free(a);
  }
}

void getline(char *varname, char *ans, int sz)
{
char msg[80];
char lno[4];
char *a;
short rlen;

  sprintf(msg,"getline %d %s",line,varname);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen < sz) sz = rlen;
    strncpy(ans,a,sz);
    ans[sz] = '\0';
    free(a);
  }
}

void sysvar(char *varname, char *ans, int sz)
{
char msg[80];
char *a;
short rlen;

  sprintf(msg,"sysvar %s",varname);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a == NULL)
    ans[0] = '\0';
  else
  {
    if (rlen < sz) sz = rlen;
    strncpy(ans,a,sz);
    ans[sz] = '\0';
    free(a);
  }
}

void log(int level, char *value)
{
char msg[80];
char lno[4];
char *a;
short rlen;

 if((loglevel & level) || (level == 0))
 {
  sprintf(msg,"log %d %s",line,value);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a != NULL) free(a);
 }
}

void setline(char *value)
{
char msg[80];
char lno[4];
char *a;
short rlen;

  sprintf(msg,"setline %d %s",line,value);
  a=Request ("pbox", msg, strlen(msg), &rlen);
  if (a != NULL) free(a);
}
/*---------------------------------------------------------------------------*/

void hit (char *fname)          /* record info hit to database */
{
char evfile[40];
char temp[34];
long evch;

        sysvar("tempdir", temp, sizeof(temp)-1);
        sprintf(evfile,"%sevent%d",temp,line);
        evch = io_open(evfile,0);
        if (evch == -7)
          evch = io_open(evfile,2);
        if (evch > 0)
        {
          fs_pos(evch,0,2);     /* goto EOF */
          sprintf(temp,"IF%s\n",fname);
          io_sstrg(evch,-1,temp,strlen(temp));
          io_close(evch);
        }
}

int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
long flch = -1;                 /* file ID        */
char *a, *t;
int n = -1;
char reply[302];
char fname[42];
short rlen;
int ferr;
short lines;
short shown;
char more;
char key;

    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    if (nc != 2) exit(-15);     /* abort if no channels */
    ipch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    opch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;
    a = sp+mlen;
    *a = '\0';

    if(mlen == 0) exit(-15);
    while(*sp == ' ') sp++;                     /* skip leading whitespace */
    if(strchr(sp,' ') == NULL) exit(-15);       /* if not >1 param, error  */

    line = atoi(sp);                            /* 1st param is line number */
    while(*sp != ' ') sp++;                     /* skip past number */
    while(*sp == ' ') sp++;                     /* and whitespace */
    if (*sp == '*')
    {
      wt = 0;                                   /* no "press a key" prompt */
      sp++;
    }
    strncpy(cmdline,sp,80);                     /* and read rest of command */
    cmdline[mlen] = '\0';

    if((n=UseSrvThg (CLNT, "pbox")) == 0)
    {
      sprintf(reply,"%s %s",_prog_name,_version);
      log(1,reply);
      sysvar("sysdir", sysdir, sizeof(sysdir)-1);
      if(line == 0)
        sysvar("inactive0", inactive, sizeof(inactive)-1);
      else
        sysvar("inactive", inactive, sizeof(inactive)-1);
      if(inactive[0] != '-')
        timeout = atol(inactive);
      if(timeout==0) timeout = -1;
      sysmsg("yesno", yesno, sizeof(yesno)-1);
      sysmsg("errfile", errfile, sizeof(errfile)-1);
      sysmsg("more", moremsg, sizeof(moremsg)-1);
      sysmsg("presskey", presskey, sizeof(presskey)-1);
      getline("more", reply, 2);
      more = reply[0];
      getline("uopt", uopts, 26);
      colour = (strchr(uopts,'C') != NULL);
      getline("lines", reply, 10);
      lines = (short)atoi(reply);
      getline("mono", reply, 10);
      mono = atoi(reply);
      getline("eoli", reply, 1);
      lf_eol = (reply[0] == '\n');
      getline("char", reply, 1);
      ttyp = reply[0];
      getline("lang", reply, 1);
      reply[1]='\0';
       t = Request ("pbox","sysvar loglevel",-1,&rlen);
       if (t == NULL)
         loglevel = 0xffff;
       else
       {
         t[rlen] = '\0';
         if (*t == '-')
           loglevel = 0xffff;
         else
           loglevel = atoi(t);
         free(t);
       }

      setline("exitcmd = menu_prg curr");

      if(sysdir[0] == '\0')
      {
        log(32,"-Error unable to access sysdir");
        FreeSrvThg (CLNT, "pbox");
        return(0);
      }
      sprintf(fname,"%sinfo_%s%s",sysdir,cmdline,reply);

      ferr = 0;   /* signal 'no error' (yet) */

      flch = io_open(fname,1);          /* try to open correct language file */
      if (flch < 0)
      {
        a = fname;
        a += strlen(fname);
        a -= 1;
        *a = '0';                       /* if it fails, try language 0 */
        flch = io_open(fname,1);
      }
      if (flch < 0)
      {
        *a = '\0';
        flch = io_open(fname,1);        /* if that fails, try no language */
      }
      if (flch < 0)                     /* if it still fails, give up */
      {
        sprintf(reply,"-Error unable to open \"%s\"",fname);
        log(32,reply);
        ferr = -7;          /* signal "not found" and "dont press a key" */
      }
      else
      {
        io_sbyte(opch, -1, 12);
        if (mono)
        io_sbyte(mono,  0, 12);
        sprintf(reply, "Info: %s",fname);
        log(8,reply);
        hit(fname);
      }
      shown = 0;

      while(ferr >= 0)
      {
        ferr = io_fline(flch, -1, reply, 300);
        if (ferr == -5)
        {
            while(io_fbyte(flch, -1, &key) == 0) /* go to eof   */
              if(key == '\n') break;             /* or linefeed */
            ferr = 300;                          /* to truncate long lines */
        }
        if (ferr > 0)
        {
          if (ferr > 1)                         /* not just a blank line */
          {
            reply[ferr-1] = '\0';
            process(reply);
            translate(reply,ttyp);
            io_sstrg(opch, -1, reply, strlen(reply));
            if (mono)
            io_sstrg(mono,  0, reply, strlen(reply));
          }
          io_sstrg(opch, -1, lf, 2);
          if (mono)
          io_sstrg(mono,  0, lf, 2);
          shown++;
          if(more != '0')
          {
            if(shown == lines-1)
            {
              io_sstrg(opch, -1, moremsg, strlen(moremsg));
              if (mono)
              io_sstrg(mono,  0, moremsg, strlen(moremsg));
              key = getkey();
              if (key == 0)     /* timeout or eof */
                 exit(-10);
              if(yesno[2]==key || yesno[3]==key) /* if you said NO  */
              {
                 io_sbyte(opch, -1, key);
                 io_sstrg(opch, -1, lf, 2 );
                 if (mono)
                 {
                 io_sbyte(mono,  0, key);
                 io_sstrg(mono,  0, lf, 2 );
                 }
                 ferr = -1;                      /* force loop exit */
              }
              else
                if(more == '2')
                {
                  io_sbyte(opch,-1,0x0c);       /* clear screen */
                  if (mono)
                  io_sbyte(mono, 0,0x0c);       /* clear screen */
                }
                else
                {
                  io_sbyte(opch,-1,'\r');
                  if (mono)
                  io_sbyte(mono, 0,'\r');
                  for (key=0; key<strlen(moremsg); key++) /* wipe the prompt */
                  {
                    io_sbyte(opch,-1,' ');
                    if (mono)
                    io_sbyte(mono, 0,' ');
                  }
                  io_sbyte(opch,-1,'\r');
                  if (mono)
                  io_sbyte(mono, 0,'\r');
                }
              shown = 0;
            }
          }
        }
      }
      if ((ferr != -1) && (wt))         /* -1=NO to MORE */
      {
        io_sstrg(opch, -1, presskey, strlen(presskey));
        if (mono)
        io_sstrg(mono,  0, presskey, strlen(presskey));
        key = getkey();
        if (key == 0)
          exit (-10);
        io_sstrg(opch, -1, lf, 2 );
        if (mono)
        io_sstrg(mono,  0, lf, 2 );
      }
      io_close(flch);
    }
    FreeSrvThg (CLNT, "pbox");
    return(0);
}
int (*_Cstart) () = main;
