/*
     delfile - delete a file by name or number in the current area
     If   name starts with a digit
        if it's NOT a private area, or user has power 'R'
          Nth name in current area (could be a 'raw' directory)
     Else
        If user has power 'M', try name directly
        Then try names in current area  (could be a 'Raw' directory)
*/
 
#include <stdio.h>
#include <stdlib.h>
#include <qdos.h>
#include <qptr.h>
#include <time.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <csrvthg.h>
#include <database.h>

char _prog_name[] = "Delfile";
char _version[] = "1.19";

   struct dlist
    {
        char         *name;     /* filename */
        long          flen;     /* length */
        struct dlist *next;     /* ptr to next entry */
    };


char *flist, *fareas, *groups, *temp;
char *yesno, *whfile, *inactive, *eoline, *flnf;
char *powers, *tempdir, *delt;
char adir[38];
char areanum[8];
char agrp[6];
short allow = 0;
short strip,anum;
long ipch;                      /* input channel  */
long opch;                      /* output channel */
long mono;                      /* monitor output */
long fileDB = -1;
char lf[] = { '\r', '\n' };
char empty = '\0';
char bbsline[6];
char lno;
long timeout = 0;               /* inactivity timeout */
int  lf_eol = 0;
int cnt = 0;
int nfiles = 0;
struct dlist *list;
struct dlist *lhed;
int raw = 0;
int loglevel;

void log(int level, char *msg);
int askline(char *buf, short buflen);
char * sysmsg(char *varname);

long exec(struct QD_text *filename, struct QD_text *cmdline,
          short wait, short chans, long chan1, long chan2, long chan3);

/*---------------------------------------------------------------------------*/
struct dlist * dir_read(char *dir)
{
struct dlist *head = NULL;
struct dlist *tail = NULL;
struct dlist *new = NULL;
char dbuff[64];
char *t, *txt;
short *s, len;
long *l;
long ch;
int ferr;

  ch = io_open(dir,4);
  if (ch > 0)
  {
    while(1)
    {
      ferr = io_fstrg(ch, -1, dbuff, 64);
      if (ferr != 64) break;
      s = (short *)&dbuff[14];           /* point to name length */
      len = *s;
      if ((len > 0) && (len < 37))       /* ignore empty/bad ones */
      {
        new = (struct dlist *)malloc(sizeof(struct dlist));
        txt = malloc(len+1);
        t = &dbuff[16];
        strncpy(txt,t,len);
        txt[len] = '\0';
        l = (long *)&dbuff[0];
        new->name = txt;
        new->flen = *l;
        new->next = NULL;
        if (head == NULL)
          head = new;
        else
          tail->next = new;
        tail = new;
      }
    }
    io_close(ch);
  }
  return(head);
}
/*---------------------------------------------------------------------------*/
int valid(void)
{
int ok = 0;

     if (strchr(powers,'J') != NULL)
     {
                        /* we have delete ability in some groups */
        if (allow == 0) /* if no override, we can delete in this group */
          ok = 1;
     }
     if (allow)                 /* was there a privelege value? */
     {
       if ((allow & 16) == 0)      /* check deletes allowed */
         ok = 0;
       else
         ok = 1;
     }
     if (ok == 0)
     {
        whfile = sysmsg("optna");
        io_sstrg(opch, -1, whfile, strlen(whfile));
        io_sstrg(opch, -1, lf, 2);
        if (mono)
        {
        io_sstrg(mono,  0, whfile, strlen(whfile));
        io_sstrg(mono,  0, lf, 2);
        }
        return(0);
     }
     return(1);
}
/*---------------------------------------------------------------------------*/
int tag(char *name)     /* return 0 = ok, -ve = error, +ve = not allowed */
{
char full[40];
char lbuff[102];
char temp[50];
long file,fsiz,ferr;
char *ptr;
int ok,len;
char f;
short rlen;
QD_TEXT  (42) fname = {0};
QD_TEXT  (82) cmdln = {0};

    strcpy(full,adir);
    strcat(full,name);
    file = io_open(full,1);
    fsiz = 0;
    if(file >= 0)
    {
        (void)io_close(file);
        (void)io_delete(full);
        sprintf(lbuff,"\"%s\" %s",name,delt);
        io_sstrg(opch, -1, lbuff, strlen(lbuff));
        io_sstrg(opch, -1, lf, 2);
        if (mono)
        {
        io_sstrg(mono,  0, lbuff, strlen(lbuff));
        io_sstrg(mono,  0, lf, 2);
        }
        sprintf(lbuff,"\"%s\" %s",name,delt);
        log(8,lbuff);
        if (adir[0] != '\0')    /* is it in the database */
        {
          sprintf(full,"%sevent%s",tempdir,bbsline);
          file = io_open(full,0);
          if (file >= 0)
          {
            fsiz = fs_pos(file,0,2);
            sprintf(lbuff,"FR%d %s",anum,name);
            io_sstrg(file, -1, lbuff, strlen(lbuff));
            io_sstrg(file, -1, lf, 2);
            io_close(file);
          }
        }
        return(0);
    }
    else
    {
      sprintf(lbuff,"%s \"%s\"",flnf,name);
      io_sstrg(opch, -1, lbuff, strlen(lbuff));
      io_sstrg(opch, -1, lf, 2);
      if (mono)
      {
      io_sstrg(mono,  0, lbuff, strlen(lbuff));
      io_sstrg(mono,  0, lf, 2);
      }
      sprintf(lbuff,"Failed delete: \"%s\"",name);
      log(8,lbuff);
    }
    return(-1);
}
/*---------------------------------------------------------------------------*/
int comp_name(long db, char *rec, struct fld_list fldef[],char *appcn)
/*
        search the database for field 2 = required name

long db;                             database ID
char *rec;                           pointer to record
struct fld_list fldef[];             field list
char *appcn;                         application definable quantity; in
                                     this case, the compare string
   return: 1 = match;  0 = no match.
*/
{
   struct QLSTR *string;
   int stln;
 
   db = db; /* keep compiler happy */
   /* make a pointer to field 2 */
   string = (struct QLSTR *) (rec + fldef[2].fld_ptr);
   stln = strlen(appcn);
   if (stln != string->qs_strlen)  return(0);
   return(strnicmp(string->qs_str,appcn,stln) == 0);
}
/*---------------------------------------------------------------------------*/
int comp_area(long dbid,char *rec,struct fld_list fldef[],void *appcn)
{
   return(  *(short *)(rec + fldef[1].fld_ptr) == *(short *)appcn  );
}
/*--------------------------------------------------------------------------*/
char getkey(void)
/* fetch a key or timeout, ignoring line feeds if appropriate */
{
char c;
int ferr,tmo;

  tmo = timeout;
  while(1)
  {
    ferr = io_fbyte( ipch, 50, &c );
    if (ferr == 0)              /* if you got a byte, return it, */
    {
      if (lf_eol)               /* if eol code is line-feed */
         return(c);             /* return whatever you got */
      else                      /* if CR or CR/LF is eol code */
        if (c != '\n')          /* ignore LFs on the assumption */
           return(c);           /* it's from a CR/LF pair */
    }
    if (ferr == -1)             /* not complete, */
    {
      if(tmo > 0)               /* if not infinite timeout */
      {
        tmo--;
        if(tmo == 0)            /* see if timed out yet */
           return(0);
      }
    }
    if (ferr < -1)
        return(0);              /* catch xmit error, eof etc. */
  }
}

/*--------------------------------------------------------------------------*/
char * sysvar(char *varname)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"sysvar ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg,(short)strlen(msg), &rlen);
  if (a == NULL) return (&empty);
  *(a+rlen) = '\0';
  return(a);
}
/*--------------------------------------------------------------------------*/
char * sysmsg(char *varname)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"sysmsg ");
  (void)strcat(msg,bbsline);
  (void)strcat(msg," ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg,(short)strlen(msg), &rlen);
  if (a == NULL) return (&empty);
  *(a+rlen) = '\0';
  return(a);
}
/*--------------------------------------------------------------------------*/
char * getline(char *varname)
{
char msg[82];
char *a;
short rlen;

  (void)strcpy(msg,"getline ");
  (void)strcat(msg,bbsline);
  (void)strcat(msg," ");
  (void)strcat(msg,varname);
  a=Request ("pbox", msg, (short)strlen(msg), &rlen);
  if (a == NULL) return (&empty);
  *(a+rlen) = '\0';
  return(a);
}
/*--------------------------------------------------------------------------*/
void log(int level, char *value)
{
char msg[82];
char *a;
short rlen;

 if(loglevel & level)
 {
  (void)strcpy(msg,"log ");
  (void)strcat(msg,bbsline);
  (void)strcat(msg," ");
  (void)strcat(msg,value);
  a=Request ("pbox", msg, (short)strlen(msg), &rlen);
  if (a != NULL) free(a);
 }
}
/*--------------------------------------------------------------------------*/
int askline(char *buf, short buflen)
{
   int len;
   char *ptr;
   char c;

   ptr = buf;
   len = 0;
   while(1)
   {
     c = getkey();
     if (c == 0) exit(-10);     /* eof or timeout */
     if (c == eoline[0])
     {
        *ptr = '\0';
        (void)io_sstrg(opch,-1,lf,2);
        if (mono)
        (void)io_sstrg(mono, 0,lf,2);
        return(len);                    /* return length, could be 0 */
     }
     if (c == 0)  return(-1);           /* or timeout */
     if ((c == 8) || (c == 127))        /* backspace */
     {
       if (len > 0)
       {
         ptr--;
         len--;
         (void)io_sbyte(opch,-1,8);
         (void)io_sbyte(opch,-1,' ');
         (void)io_sbyte(opch,-1,8);
         if (mono)
         {
         (void)io_sbyte(mono, 0,8);
         (void)io_sbyte(mono, 0,' ');
         (void)io_sbyte(mono, 0,8);
         }
       }
     }
     else
     {
       *ptr = c;
       ptr++;
       len++;
       if(len == buflen)
          return(len);
       (void)io_sbyte(opch,-1,c);
       if (mono)
       (void)io_sbyte(mono, 0,c);
     }
   }
}
/*---------------------------------------------------------------------------*/
void askwhich(void)
{
char c;
char *ptr, *eol, *s;
char answer[102];
char lbuff[102];
char one_name[42];
short len,f;
struct dlist *sptr;
long file;
/*
        ask for one filename/number
*/
      io_sstrg(opch, -1, whfile, strlen(whfile));
      if (mono)
      io_sstrg(mono,  0, whfile, strlen(whfile));
      len = askline(answer,100);
      if (len < 0)      /* timed out getting response */
         exit(len);
      if (len == 0)
      {
        io_sstrg(opch, -1, lf, 2);
        if (mono)
        io_sstrg(mono,  0, lf, 2);
        return;
      }
      if (raw == 2)
        sptr = list;


      ptr = eol = answer;
        while(*eol == ' ')      /* strip leading whitespace */
          eol++;
        if (*eol == '\0')       /* no entry */
           return;
        ptr = eol;              /* start of entry */
        while((*eol != ',') && (*eol != ' ') && (*eol != '\0'))
          eol++;
        if (eol != ptr)         /* check for nul entry */
        {
           c = *eol;
           *eol = '\0';
           strcpy(one_name,ptr);        /* copy entry to "one_name" */
           *eol = c;
           c = 1;                       /* assume it's all numeric */
           for (f=0; f<strlen(one_name); f++)
           {
             if (!isdigit(one_name[f])) /* check all digits */
                c = 0;
           }
           if (c)       /* entry is a position in list */
           {
             if (raw==2)
             {
               f = (short)atoi(one_name);
               if ((f > 0) && (f <= nfiles))
               {
                 list = lhed;
                 while (f > 1)
                 {
                   list = list->next;
                   f--;
                 }
                 s = list->name;
                 s += strip;

                 strcpy(one_name, s);   /* get filename */
                 if (valid())
                   if (tag(one_name) == 0)
                      return;
               }
               else              /* number not valid */
               {
                 sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                 io_sstrg(opch, -1, lbuff, strlen(lbuff));
                 io_sstrg(opch, -1, lf, 2);
                 if (mono)
                 {
                 io_sstrg(mono,  0, lbuff, strlen(lbuff));
                 io_sstrg(mono,  0, lf, 2);
                 }
               }
             }
             else if (raw == 0)      /* number, but not a raw directory */
             {
               f = (short)atoi(one_name);
               if ((f > 0) && (f <= nfiles))
               {
                 fsd_posa(fileDB, f-1);
                 len = fsd_get(fileDB,2,36,one_name);     /* get filename */
                 one_name[len] = '\0';
                 if (valid())
                   if (tag(one_name) == 0)
                      return;
               }
               else              /* number not valid */
               {
                 sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                 io_sstrg(opch, -1, lbuff, strlen(lbuff));
                 io_sstrg(opch, -1, lf, 2);
                 if (mono)
                 {
                 io_sstrg(mono,  0, lbuff, strlen(lbuff));
                 io_sstrg(mono,  0, lf, 2);
                 }
               }
             }
             else       /* cant use numbers if you dont have a list! */
             {
                 sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                 io_sstrg(opch, -1, lbuff, strlen(lbuff));
                 io_sstrg(opch, -1, lf, 2);
                 if (mono)
                 {
                 io_sstrg(mono,  0, lbuff, strlen(lbuff));
                 io_sstrg(mono,  0, lf, 2);
                 }
             }
           }
           else         /* it's a name */
           {
              if (strchr(powers,'M') != NULL)  /* full system access */
              {
                file = io_open(one_name,1);

                if (file > 0)
                {
                  io_close(file);
                  adir[0] = '\0';       /* no directory */
                  if (tag(one_name) == 0)
                     return;
                }
              }
              if (raw > 0)                /* try filenames in the area */
              {
                strcpy(lbuff,adir);
                strcat(lbuff,one_name);
                file = io_open(lbuff,1);

                if (file > 0)
                {
                  io_close(file);
                  if (valid())
                    if (tag(one_name) == 0)
                       return;
                }
                else              /* not found in this area */
                {
                  sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                  io_sstrg(opch, -1, lbuff, strlen(lbuff));
                  io_sstrg(opch, -1, lf, 2);
                  if (mono)
                  {
                  io_sstrg(mono,  0, lbuff, strlen(lbuff));
                  io_sstrg(mono,  0, lf, 2);
                  }
                }
              }
              else      /* name, but not a raw directory */
              {
                if (fsd_srch(fileDB, comp_name, one_name) >= 0)
                {
                  if (valid())
                    if (tag(one_name) == 0)
                       return;
                }
                else              /* not found in this area */
                {
                  sprintf(lbuff,"%s \"%s\"",flnf,one_name);
                  io_sstrg(opch, -1, lbuff, strlen(lbuff));
                  io_sstrg(opch, -1, lf, 2);
                  if (mono)
                  {
                  io_sstrg(mono,  0, lbuff, strlen(lbuff));
                  io_sstrg(mono,  0, lf, 2);
                  }
                }
              }
           }
        }

      io_sstrg(opch, -1, lf, 2);
      if (mono)
      io_sstrg(mono,  0, lf, 2);
      mt_susjb(-1,80,NULL);
}
/*---------------------------------------------------------------------------*/
int main (int ac, char **av)
{
char *sp;                       /* stack pointer  */
short nc;                       /* no of channels */
short mlen;                     /* cmdline length */
long fareaCH = -1;
long fareaDB = -1;
long ch;
short rlen;
int  ans,a,f;
long fdate;
short fdown;
char aname[38];
char adesc[502];
char ahead[42];
char atyp[10];
char fname[38];
char fdesc[1002];
char full[38];
char lbuff[302];
struct tm *tp;
long file,fsiz;
char c1,c2;
char *s,*c,*t,*tmp;
int  pad,l,lim,skip,ferr;
char m1[] = "setline 0 exitcmd = menu_prg curr";
char m2[] = "getflst 0 1";

    nc = ac;                    /* keep compiler quiet  */
    sp = *(av + 1);             /* supplied sp          */
    nc = *((short *) sp);       /* no of channels       */
    sp += 2;                    /* advance              */
    if (nc != 2) exit(-15);     /* abort if no channels */
    ipch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    opch = *((long *) sp);      /* read qdos channel id */
    sp += 4;                    /* advance              */
    mlen = *((short *) sp);     /* command line length  */
    sp += 2;

    if(mlen)
      lno = atoi(sp);
    else
      lno = 0;

    m1[8] += lno;               /* patch line number into messages */
    m2[8] += lno;
    sprintf(bbsline,"%d",lno);

     if((ans=UseSrvThg (CLNT, "pbox")) == 0)
     {
      if(lno == 0)
        inactive = Request ("pbox","sysvar inactive0",-1,&rlen);
      else
        inactive = Request ("pbox","sysvar inactive",-1,&rlen);
      if (inactive == NULL)
        timeout = -1;
      else
      {
        inactive[rlen] = '\0';
        if(inactive[0] != '-')
          timeout = atol(inactive);
        if(timeout==0) timeout = -1;
      }
       t = sysvar ("loglevel");
       if ((*t == '-') || (*t == '\0'))
         loglevel = 0xffff;
       else
         loglevel = atoi(t);
       free(t);
       sprintf(lbuff,"%s %s",_prog_name,_version);
       log(1,lbuff);

       eoline  = getline("eoli");
       lf_eol  = (eoline[0] == '\n');

       fareas  = sysvar ("fareas");
       tempdir = sysvar ("tempdir");
       groups  = Request ("pbox", m1,-1, &rlen); /* dummy to set exit cmd */
       if (groups != NULL) free(groups);
       groups  = getline("fareas");
       yesno   = sysmsg("yesno");
       flnf    = sysmsg("flnf");
       delt    = sysmsg("delfile");
       powers  = getline("power");
       temp    = getline("mono");
       mono    = atoi(temp);
       temp    = getline("cfil");
       anum    = (short)atoi(temp);
       strcpy(areanum,temp);

       fareaCH = io_open( fareas, 1 ); /* shared access open */
       if (fareaCH > 0 )
          fareaDB = fsd_open(fareaCH);

       if (fareaCH < 0 || fareaDB < 0 ) /* if the 'open' failed */
         exit(-1);
     whfile  = sysmsg("onefile");
     ans = fsd_srch(fareaDB, comp_area, &anum);
     ans = fsd_get(fareaDB, 5, 4, agrp);
     ans = fsd_get(fareaDB, 4, 36, adir);
     adir[ans] = '\0';
     ans = fsd_get(fareaDB, 6, 8, atyp);
     atyp[ans] = '\0';
     ans = fsd_get(fareaDB, 2, 36, aname);
     aname[ans] = '\0';
     tmp = strchr(groups,agrp[0]);
     if (tmp != NULL)
       allow = atoi(tmp+1);

     raw = 0;
     if (strchr(atyp,'P') != NULL)
     {
        raw = 1;                        /* 1 = private area */
        if (strchr(powers,'R') != NULL) /* 2 = allowed to see a raw directory */
          raw = 2;
        if (allow)                      /* check for override */
        {
          if (allow & 32)
            raw = 2;
          else
            raw = 1;
        }
     }
     if (raw == 1)              /* no list available, cant use numbers */
       whfile  = sysmsg("onename");

     if (raw == 2)              /* build a raw directory list */
     {
       strip = strlen(adir);    /* get length of directory part of name */
       strip -= 5;              /* allowing for device part */
       lhed = dir_read(adir);
       list = lhed;
       nfiles = 0;              /* count how many entries there are */
       while (list != NULL)
       {
         nfiles++;
         list = list->next;
       }
       list = lhed;             /* back to start */
     }
     else if (raw == 0)
     {
       cnt = 50;
       while(1)
       {
         flist   = Request ("pbox", m2, -1, &rlen);
         if (flist == NULL) exit (-1);
         fileDB = atoi(flist);          /* get external list */
         free(flist);
         if(fileDB != -1)               /* -1 means no list (yet) */
           break;
         cnt--;
         if(cnt == 0)                   /* try 50 times (5 seconds) */
           exit(-1);
         mt_susjb(-1,5,NULL);           /* at 1/10 second intervals */
       }
       nfiles = fsd_rcnt(fileDB);      /* how many files in database */
       fsd_posa(fileDB,0);             /* position at start of files */
     }
     else
       nfiles = 1000;

     cnt = 0;
     if (nfiles)
        askwhich();
     fsd_close(fareaDB);
     io_close(fareaCH);
   }
   FreeSrvThg (CLNT, "pbox");
   return(0);
}
int (*_Cstart) () = main;
