* Very simple vt100 terminal

	  data	    1024
	  filetype  1
	  section   prog

seri	equ	0		dataspace layout
sero	equ	4
con	equ	8
chenqbuff equ	$10
inescape  equ	$20
ylevel	  equ	$21
parm1	  equ	$22
crlf	  equ	$23

start	  bra.s     begin

	  dc.l	    0
	  dc.w	    $4afb

	  dc.w	    8
	  dc.b	    'ChatTerm'

condef	  dc.l	    $02010007
	  dc.l	    $01e600f4
	  dc.l	    $000c0006

initmsg   dc.w	    38
	  dc.b	    'Chat Term v1.03,  SHIFT/ENTER to quit '
	  ds.w	0
begin
	  adda.l    a4,a6		start of dataspace
	  move.w    (a7)+,d0
	  cmpi.w    #2,d0		need 2 channels
	  beq.s got_chan
	  suba.l    a0,a0
	  lea	    nochan(PC),a1
	  movea.w   $000000D0,a2	; UT_MTEXT
	  jsr	    (a2)
	  bra	    suicide
nochan
	  dc.w	24
	  dc.b	'Need 2 serial channels!',$0a
	  ds.w	0
got_chan
	  move.l    (a7)+,seri(a6)
	  move.l    (a7)+,sero(a6)

	  lea	    condef,a1
	  movea.w   $c6,a2		; UT.CON
	  jsr	    (a2)
	  move.l    a0,con(a6)
	  bsr	    cls
	  moveq     #$0e,d0
	  trap	    #3			; SD.CURE
	  movea.l   con(a6),a0
	  lea	    initmsg,a1
	  movea.w   $d0,a2		; UT.MTXT
	  jsr	    (a2)
	  moveq     #0,d1
	  moveq     #$11,d0
	  trap	    #3			; SD.TAB
	  moveq     #$16,d0
	  trap	    #3			; SD.NROW

nextchar  movea.l   con(a6),a0
	  tst.b     crlf(a6)		are we in a cr/lf pair
	  beq.s     getbyte		if not, fetch a char
	  move.b    #0,crlf(a6) 	clear flag for next time
	  move.b    #$0a,d1		send lf
	  bra.s     console
getbyte
	  moveq     #2,d3
	  moveq     #0,d1
	  bsr	    fetchbyte
	  tst.b     d0
	  bne.s     tryseri		no console input, try serial
	  cmpi.b    #$fe,d1		shift enter quits
	  beq	    suicide
	  cmpi.b    #$1b,d1		was it esc?
	  beq.s     nextchar		if so, ignore it
	  moveq     #-1,d3		increase timeout
	  cmpi.b    #$0a,d1		lf
	  bne.s     try_bs
	  moveq     #$0d,d1		then make lf into cr
	  move.b    #1,crlf(a6) 	set flag
try_bs	  cmpi.b    #$c2,d1		backspace
	  bne.s     console
	  moveq     #8,d1		becomes delete
	  bra.s     console		send to local console and serial port
tryseri   movea.l   seri(a6),a0
	  move.w    #2,d3		check for serial input
	  moveq     #0,d0
	  trap	    #3			; IO.PEND
	  tst.b     d0
	  bne.s     nextchar		next loop
	  bsr	    fetchbyte
console   movea.l   con(a6),a0
	  cmpi.b    #$7f,d1		check for 127
	  bne.s     trycntrl
	  moveq     #8,d1		becomes delete
trycntrl
	  cmpi.b    #$1f,d1		if control char, special handling
	  ble.s     ctrlchar
	  tst.b     inescape(a6)
	  bne	    escape		escape handling
	  bsr	    sendbyte		send to console
ctrlchar
	  move.l    a0,a4
	  move.l    sero(a6),a0
	  bsr	    sendbyte		echo char to serial port
	  move.l    a4,a0
	  cmpi.b    #$0d,d1		if it's a cr,
	  bne.s     not_a_cr
	  move.l    a0,a4
	  move.l    sero(a6),a0
	  move.b    #$0a,d1		also send a LF to remote
	  bsr	    sendbyte
	  move.l    a4,a0
	  moveq     #0,d1
	  moveq     #$11,d0
	  trap	    #3			; SD.TAB
	  bra.s     do_chenq

not_a_cr  cmpi.b    #$0a,d1		lf doesnt get sent to remote,
	  bne.s     try_del		we send cr/lf as a pair
do_chenq
	  moveq     #$0b,d0
	  lea	    chenqbuff(a6),a1
	  trap	    #3			; SD.CHENQ
	  lea	    chenqbuff(a6),a1
	  cmpi.w    #$17,6(a1)		line 23
	  bne.s     go_nrow
	  moveq     #-$0a,d1
	  moveq     #$18,d0
	  trap	    #3			; SD.SCROL
go_nrow   moveq     #$16,d0
	  trap	    #3			; SD.NROW
	  bra	    nextchar

try_del   cmpi.b    #8,d1		delete
	  bne.s     try_bell
	  moveq     #$0b,d0
	  lea	    chenqbuff(a6),a1
	  trap	    #3			; SD.CHENQ
	  lea	    chenqbuff(a6),a1
	  tst.w     4(a1)
	  beq.s     just_space
	  moveq     #$13,d0
	  trap	    #3			; SD.PCOL
just_space
	  move.b    #' ',d1
	  bsr	    sendbyte
	  moveq     #$13,d0
	  trap	    #3			; SD.PCOL
	  bra	    nextchar

try_bell  cmpi.b    #7,d1		bell character
	  bne.s     try_esc
	  bsr	    bell
	  bra	    nextchar

try_esc   cmpi.b    #$1b,d1		esc
	  bra	    nextchar		next character
	  move.b    d1,inescape(a6)
	  bra	    nextchar		next loop

escape	  tst.b     Ylevel(a6)		escape handling
	  beq.s     not_escy		not esc Y
	  cmpi.b    #1,ylevel(a6)
	  bne.s     got2parm		got 2 params now
	  move.b    #2,ylevel(a6)
	  subi.b    #$20,d1
	  move.b    d1,parm1(a6)
	  bra	    nextchar

got2parm  cmpi.b    #2,ylevel(a6)
	  bne.s     escexit
	  subi.b    #$20,d1
	  move.b    parm1(a6),d2
	  moveq     #$10,d0
	  trap	    #3			; SD.POS
	  bra.s     escexit

not_escy  cmpi.b    #$41,d1		esc A
	  bne.s     try_b
	  moveq     #$15,d0
	  trap	    #3			; SD.PROW
	  bra.s     escexit

try_b	  cmpi.b    #$42,d1		esc B
	  bne.s     try_c
	  moveq     #$16,d0
	  trap	    #3			; SD.NROW
	  bra.s     escexit

try_c	  cmpi.b    #$43,d1		esc C
	  bne.s     try_d
	  moveq     #$14,d0
	  trap	    #3			; SD.NCOL
	  bra.s     escexit

try_d	  cmpi.b    #$44,d1		esc D
	  bne.s     try_h
	  moveq     #$13,d0
	  trap	    #3			; SD.PCOL
	  bra.s     escexit

try_h	  cmpi.b    #$48,d1		esc H
	  bne.s     try_j
	  moveq     #$10,d0
	  moveq     #0,d1
	  moveq     #0,d2
	  trap	    #3			; SD.POS
	  bra.s     escexit

try_j	  cmpi.b    #$4a,d1		esc J
	  bne.s     try_k
	  moveq     #$24,d0
	  trap	    #3			; SD.CLRRT
	  moveq     #$22,d0
	  trap	    #3			; SD.CLRBT
	  bra.s     escexit

try_k	  cmpi.b    #$4b,d1		esc K
	  bne.s     try_y
	  moveq     #$24,d0
	  trap	    #3			; SD.CLRRT
	  bra.s     escexit

try_y	  cmpi.b    #$59,d1		esc Y
	  bne.s     escexit
	  move.b    #1,ylevel(a6)
	  bra	    nextchar

escexit   clr.b     inescape(a6)
	  bra	    nextchar

fetchbyte moveq     #1,d0
	  moveq     #0,d1
	  trap	    #3			; IO.FBYTE
	  rts

sendbyte  moveq     #-1,d3
	  moveq     #5,d0
	  move.b    d1,d4
	  trap	    #3			; IO.SBYTE
	  move.b    d4,d1
	  rts

cls	  moveq     #-1,d3
	  moveq     #$20,d0
	  trap	    #3			; SD.CLEAR
	  rts

bell	  moveq     #$11,d0
	  lea	    beep,a3
	  trap	    #1			; MT.IPCOM
	  rts

beep	  dc.b	  $0a		  ipc command number
	  dc.b	  $08		  number of parameters
	  dc.l	  $0000aaaa	  amounts of each parameter
	  dc.b	  $07,$00	  pitch1,pitch2
	  dc.w	  $0000 	  interval between steps
	  dc.w	  $0008 	  duration
	  dc.b	  $00		  step in pitch/wrap
	  dc.b	  $00		  randomness/fuzziness
	  dc.b	  $01		  no reply parameters

suicide   moveq     #5,d0
	  moveq     #-1,d1
	  trap	    #1			; MT.FRJOB

	  end
