{$B-}
unit tor32u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, Console, ComCtrls, StdCtrls, AdPort, AdStatLt,
  AdProtcl, AdPStat, TB97, tMisc, tGlob, tMainOvr, MainComm, TimeTask,
  MainCTL, Log, Resource, Ansi, Parse, MainCOvr, Multi, Shell, TMenus,
  Areas, TQwk, TScript, CompSys, Users, TModem, InfoUnit, OoMisc,
  Gauges, Objects, Protocol, OpCrt, appexec, AdModem, Registry, Protect,
  ShellAPI,
  Menus, WavePlay, TB97Ctls, RXShell;

type
  TMainForm = class(TForm)
    ApdComPort: TApdComPort;
    ApdProtocol: TApdProtocol;
    StatusLights: TApdSLController;
    ManualSendDlg: TOpenDialog;
    FontDialog: TFontDialog;
    Executer: TAppExec;
    ShowDlg: TOpenDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Console1: TColorConsole;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    ProtBox: TGroupBox;
    Memo1: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Panel6: TPanel;
    DCD: TApdStatusLight;
    Label7: TLabel;
    DSR: TApdStatusLight;
    Label8: TLabel;
    CTS: TApdStatusLight;
    Label9: TLabel;
    Label4: TLabel;
    RI: TApdStatusLight;
    RX: TApdStatusLight;
    Label5: TLabel;
    TX: TApdStatusLight;
    Label6: TLabel;
    ERR: TApdStatusLight;
    Label3: TLabel;
    Panel7: TPanel;
    Memo2: TMemo;
    Panel9: TPanel;
    Panel8: TPanel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    FileName: TLabel;
    FileDate: TLabel;
    Block: TLabel;
    Errors: TLabel;
    CPS: TLabel;
    Size: TLabel;
    Time: TLabel;
    FPos: TLabel;
    tLeft: TLabel;
    Autonomous: TTabSheet;
    Panel3: TPanel;
    Label10: TLabel;
    Status: TLabel;
    Label11: TLabel;
    mResult: TLabel;
    Panel4: TPanel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    TotalCalls: TLabel;
    TotalUsers: TLabel;
    MsgsPosted: TLabel;
    TotalULs: TLabel;
    TotalDLs: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    LastList: TListBox;
    PageControl2: TPageControl;
    WorkButtons: TTabSheet;
    FontButton: TToolbarButton97;
    UserInfoButton: TToolbarButton97;
    EditUserButton: TToolbarButton97;
    SecurityButton: TToolbarButton97;
    TagListButton: TToolbarButton97;
    SendFileButton: TToolbarButton97;
    ShowFileButton: TToolbarButton97;
    BugEmuButton: TToolbarButton97;
    ChatButton: TToolbarButton97;
    LockoutButton: TToolbarButton97;
    ExitButton: TToolbarButton97;
    WaitButtons: TTabSheet;
    InitButton: TToolbarButton97;
    AnswerButton: TToolbarButton97;
    BreakButton: TToolbarButton97;
    LocalButton: TToolbarButton97;
    wExitButton: TToolbarButton97;
    Modem: TApdModem;
    Panel2: TPanel;
    ProtText1: TLabel;
    ProtText2: TLabel;
    CurrentProgress: TProgressBar;
    TotalProgress: TProgressBar;
    HelpButton: TToolbarButton97;
    Button1: TButton;
    WorkMenu: TMainMenu;
    File2: TMenuItem;
    Exit1: TMenuItem;
    User1: TMenuItem;
    Viewinfo1: TMenuItem;
    Help1: TMenuItem;
    Font1: TMenuItem;
    Editusersparameters1: TMenuItem;
    Setsecuritylevel1: TMenuItem;
    Bugs1: TMenuItem;
    Chatwiththeuser1: TMenuItem;
    Lockout1: TMenuItem;
    Hangup1: TMenuItem;
    Sendfile1: TMenuItem;
    Showfile1: TMenuItem;
    Window1: TMenuItem;
    Programkeys1: TMenuItem;
    Commandline1: TMenuItem;
    WaitMenu: TMainMenu;
    File1: TMenuItem;
    Modem1: TMenuItem;
    Exit2: TMenuItem;
    Initialize1: TMenuItem;
    Answer1: TMenuItem;
    Break1: TMenuItem;
    Localmode1: TMenuItem;
    Showtoolbar1: TMenuItem;
    Taggedfiles1: TMenuItem;
    Window2: TMenuItem;
    Showtoolbar2: TMenuItem;
    Autoalignwindow1: TMenuItem;
    Autoalignwindow2: TMenuItem;
    N1: TMenuItem;
    Showstatusbar1: TMenuItem;
    Showstatusbar2: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    Increasetimeby1min1: TMenuItem;
    Decreasetimeby1min1: TMenuItem;
    ToolbarButton971: TToolbarButton97;
    Help2: TMenuItem;
    Commandline2: TMenuItem;
    About1: TMenuItem;
    About2: TMenuItem;
    PlayerWave1: TPlayerWave;
    Decreasefilesby50K: TMenuItem;
    Increasefilesby50K: TMenuItem;
    RxTrayIcon1: TRxTrayIcon;

    procedure MainEngine(Sender: TObject; Var Done : Boolean);
    procedure ExitButtonClick(Sender: TObject);
    procedure BugEmuButtonClick(Sender: TObject);
    procedure LockoutButtonClick(Sender: TObject);
    procedure ChatButtonClick(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
    procedure UserInfoButtonClick(Sender: TObject);
    procedure EditUserButtonClick(Sender: TObject);
    procedure SendFileButtonClick(Sender: TObject);
    procedure SecurityButtonClick(Sender: TObject);
    procedure TagListButtonClick(Sender: TObject);
    procedure FontButtonClick(Sender: TObject);
    procedure ShowFileButtonClick(Sender: TObject);

    procedure ApdProtocolProtocolStatus(CP: TObject; Options: Word);
    procedure ApdProtocolProtocolLog(CP: TObject; Log: Word);
    procedure ApdProtocolProtocolNextFile(CP: TObject;
      var FName: TPassString);
    procedure ApdProtocolProtocolAccept(CP: TObject; var Accept: Boolean;
      var FName: TPassString);
    procedure Button2Click(Sender: TObject);
    procedure Panel9Resize(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure LogException (Sender: TObject; E: Exception);
    procedure PageControl1Change(Sender: TObject);
    function Prepare: boolean;
    procedure ModemAnswerCount(M: TObject; Remaining: Word);
    procedure ModemModemRing(Sender: TObject);
    procedure ModemAnswerTimedOut(Sender: TObject);
    procedure InitButtonClick(Sender: TObject);
    procedure ModemCommandProcessed(M: TObject; WhatHappened: TModemStatus;
      Data: Integer);
    procedure ModemModemIsConnected(Sender: TObject);
    procedure ModemConnectFailed(Sender: TObject);
    procedure BreakButtonClick(Sender: TObject);
    procedure AnswerButtonClick(Sender: TObject);
    procedure LocalButtonClick(Sender: TObject);
    procedure AutonomousMode;
    procedure Panel2Resize(Sender: TObject);
    procedure ButtonPanelResize(Sender: TObject);
    procedure Panel8Resize(Sender: TObject);
    procedure LastListEnter(Sender: TObject);
    procedure TabSheet1Enter(Sender: TObject);
    procedure AppMinimize(Sender: TObject);
    procedure AppRestore(Sender: TObject);

    procedure misInit (B: Boolean);
    procedure misLocal (B: Boolean);
    procedure misSendFile (B: Boolean);
    procedure misBugEmu (B: Boolean);
    procedure misChat (B: Boolean);
    procedure misExit (B: Boolean);
    procedure misFont (B: Boolean);
    procedure misLockout (B: Boolean);
    procedure misShowFile (B: Boolean);
    procedure misHelp (B: Boolean);
    procedure misUserInfo (B: Boolean);
    procedure misEditUser (B: Boolean);
    procedure misSecurity (B: Boolean);
    procedure misTagList (B: Boolean);
    procedure misAnswer (B: Boolean);
    procedure misBreak (B: Boolean);
    procedure Showtoolbar1Click(Sender: TObject);
    procedure Alignwindow1Click(Sender: TObject);
    procedure Autoalignwindow1Click(Sender: TObject);
    procedure Commandline1Click(Sender: TObject);
    procedure Showstatusbar1Click(Sender: TObject);
    procedure Increasetimeby1min1Click(Sender: TObject);
    procedure Decreasetimeby1min1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure About1Click(Sender: TObject);
    procedure Decreasefilesby50KClick(Sender: TObject);
    procedure Increasefilesby50KClick(Sender: TObject);
    procedure RxTrayIcon1Click(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

  private
    { Private declarations }
    migInit: Boolean;
    migLocal: Boolean;
    migSendFile: Boolean;
    migBugEmu: Boolean;
    migChat: Boolean;
    migExit: Boolean;
    migFont: Boolean;
    migLockout: Boolean;
    migShowFile: Boolean;
    migHelp: Boolean;
    migUserInfo: Boolean;
    migEditUser: Boolean;
    migSecurity: Boolean;
    migTagList: Boolean;
    migAnswer: Boolean;
    migBreak: Boolean;
    InitOk: Boolean;

  public
    { Public declarations }

    property miInit: Boolean read migInit write misInit;
    property miLocal: Boolean read migLocal write misLocal;
    property miSendFile: Boolean read migSendFile write misSendFile;
    property miBugEmu: Boolean read migBugEmu write misBugEmu;
    property miChat: Boolean read migChat write misChat;
    property miExit: Boolean read migExit write misExit;
    property miFont: Boolean read migFont write misFont;
    property miLockout: Boolean read migLockout write misLockout;
    property miShowFile: Boolean read migShowFile write misShowFile;
    property miHelp: Boolean read migHelp write misHelp;
    property miUserInfo: Boolean read migUserInfo write misUserInfo;
    property miEditUser: Boolean read migEditUser write misEditUser;
    property miSecurity: Boolean read migSecurity write misSecurity;
    property miTagList: Boolean read migTagList write misTagList;
    property miAnswer: Boolean read migAnswer write misAnswer;
    property miBreak: Boolean read migBreak write misBreak;

  end;

Procedure ReadWinSettings;
Procedure SaveWinSettings;

var
  MainForm: TMainForm;

implementation

uses useredu, secur, taglist, cmdline, page, iemsibox, help, aboutbox;

{$R *.DFM}

Type
  tWinRes = Record
    Product, ActivePage  : String [50];
    FontCharset          : TFontCharset;
    FontHeight, FontSize : Integer;
    FontName             : String;
    FontStyle            : TFontStyles;
    Toolbar, Autoalign,
    StatusBar            : Boolean;
  End;

Var
  sR : tWinRes;
  Reg : TRegistry;
  sUpdated : Boolean;
  sCallWait, sInitModem, S : String;

Const
  RegistryEntry : String = 'Software\Tornado\Tornado Settings';
  WaitFinished : Boolean = True;

Procedure ReadWinSettings;
Var
  i : Byte;

Procedure CenterForm (Var F);
Var
  X, Y : LongInt;

Begin
  X := (Screen. Width - TForm (F). Width) Div 2;
  Y := (Screen. Height - TForm (F). Height) Div 2;
  If X < 0 Then X := 0;
  If Y < 0 Then Y := 0;

  TForm (F). Left := X;
  TForm (F). Top := Y;
End;

Begin
  Reg := TRegistry. Create;

  If Reg. OpenKey (RegistryEntry, False) Then
  Begin
    Try sR. Product := Reg. ReadString ('Version'); Except End;
    Try sR. FontCharset := TFontCharset (Reg. ReadInteger ('FontCharset')); Except End;
    Try sR. FontName := Reg. ReadString ('FontName'); Except End;
    Try sR. FontSize := Reg. ReadInteger ('FontSize'); Except End;
    Try sR. FontHeight := Reg. ReadInteger ('FontHeight'); Except End;
    Try S := Reg. ReadString ('FontStyle'); Except End;

    sR. FontStyle := [];
    For i := 1 To Length (S) Do
    Case S [i] Of
      'B' : sR. FontStyle := sR. FontStyle + [fsBold];
      'I' : sR. FontStyle := sR. FontStyle + [fsItalic];
      'U' : sR. FontStyle := sR. FontStyle + [fsUnderline];
      'S' : sR. FontStyle := sR. FontStyle + [fsStrikeout];
    End;

    Try sR. ActivePage := Reg. ReadString ('ActivePage');
    Except sR. ActivePage := ''; End;

    Try sR. ToolBar := Reg. ReadString ('Toolbar') = '1';
    Except sR. ToolBar := True; End;

    MainForm. Showtoolbar1. Checked := sR. Toolbar;
    MainForm. Showtoolbar2. Checked := sR. Toolbar;

    If Not sR. Toolbar
    Then MainForm. PageControl2. Height := 0
    Else MainForm. PageControl2. Height := 41;

    Try sR. StatusBar := Reg. ReadString ('Statusbar') = '1';
    Except sR. StatusBar := True; End;

    MainForm. Showstatusbar1. Checked := sR. Statusbar;
    MainForm. Showstatusbar2. Checked := sR. Statusbar;

    If Not sR. Statusbar
    Then MainForm. Panel1. Height := 0
    Else MainForm. Panel1. Height := 42;

    Try sR. AutoAlign := Reg. ReadString ('Autoalign') = '1';
    Except sR. Autoalign := True; End;

    MainForm. Autoalignwindow1. Checked := sR. Autoalign;
    MainForm. Autoalignwindow2. Checked := sR. Autoalign;

    Try S := Reg. ReadString ('Windows.Coordinates'); Except S := ''; End;

    If S <> '' Then
    Begin
      MainForm. Top := Str2Long (ExtractWord (1, S, [',', ' ']));
      MainForm. Left := Str2Long (ExtractWord (2, S, [',', ' ']));
      UserEdForm. Top := Str2Long (ExtractWord (3, S, [',', ' ']));
      UserEdForm. Left := Str2Long (ExtractWord (4, S, [',', ' ']));
      TagListForm. Top := Str2Long (ExtractWord (5, S, [',', ' ']));
      TagListForm. Left := Str2Long (ExtractWord (6, S, [',', ' ']));
      PageForm. Top := Str2Long (ExtractWord (7, S, [',', ' ']));
      PageForm. Left := Str2Long (ExtractWord (8, S, [',', ' ']));
      SecurityForm. Top := Str2Long (ExtractWord (9, S, [',', ' ']));
      SecurityForm. Left := Str2Long (ExtractWord (10, S, [',', ' ']));
      InfoForm. Top := Str2Long (ExtractWord (11, S, [',', ' ']));
      InfoForm. Left := Str2Long (ExtractWord (12, S, [',', ' ']));
    End;

    Try
      S := Reg. ReadString ('MainWindow.Size');
    Except
      S := '';
    End;

    If S <> '' Then
    Begin
      MainForm. Width := Str2Long (ExtractWord (1, S, [',', ' ']));
      MainForm. Height := Str2Long (ExtractWord (2, S, [',', ' ']));
    End;

    Reg. CloseKey;
  End Else
  Begin
    sR. FontCharset := OEM_CHARSET;
    sR. FontName := 'Courier New';
    sR. FontSize := 8;
    sR. FontHeight := -10;
    sR. FontStyle := [];

    MainForm. Alignwindow1Click (nil);
    UserEdForm. Position := poScreenCenter;
    TagListForm. Position := poScreenCenter;
    PageForm. Position := poScreenCenter;
    SecurityForm. Position := poScreenCenter;
    InfoForm. Position := poScreenCenter;
    MainForm. Position := poScreenCenter;

    CenterForm (UserEdForm);
    CenterForm (TagListForm);
    CenterForm (PageForm);
    CenterForm (SecurityForm);
    CenterForm (InfoForm);
  End;

  Reg. Free;
End;

Procedure SaveWinSettings;
Begin
  Reg := TRegistry. Create;
  Reg. CreateKey (RegistryEntry);
  Reg. OpenKey (RegistryEntry, False);

  With MainForm. Console1. Font Do
  Begin
    Reg. WriteInteger ('FontCharset', Byte (Charset));
    Reg. WriteString ('FontName', Name);
    Reg. WriteInteger ('FontSize', Size);
    Reg. WriteInteger ('FontHeight', Height);

    S := '';
    If fsBold in Style Then S := S + 'B';
    If fsItalic in Style Then S := S + 'I';
    If fsUnderline in Style Then S := S + 'U';
    If fsStrikeout in Style Then S := S + 'S';

    Reg. WriteString ('FontStyle', S);
  End;

  Reg. WriteString ('Version', NameVer);

  S :=
    Long2Str (MainForm. Top) + ' ,' +
    Long2Str (MainForm. Left) + ' ,' +
    Long2Str (UserEdForm. Top) + ' ,' +
    Long2Str (UserEdForm. Left) + ' ,' +
    Long2Str (TagListForm. Top) + ' ,' +
    Long2Str (TagListForm. Left) + ' ,' +
    Long2Str (PageForm. Top) + ' ,' +
    Long2Str (PageForm. Left) + ' ,' +
    Long2Str (SecurityForm. Top) + ' ,' +
    Long2Str (SecurityForm. Left) + ' ,' +
    Long2Str (InfoForm. Top) + ' ,' +
    Long2Str (InfoForm. Left);

  Reg. WriteString ('Windows.Coordinates', S);

  S := Long2Str (MainForm. Width) + ' ,' + Long2Str (MainForm. Height);
  Reg. WriteString ('MainWindow.Size', S);

  If MainForm. PageControl1. ActivePage = MainForm. TabSheet2
  Then S := 'Log' Else S := 'Main';
  Reg. WriteString ('ActivePage', S);

  If MainForm. Showtoolbar1. Checked Then S := '1' Else S := '0';
  Reg. WriteString ('Toolbar', S);

  If MainForm. Showstatusbar1. Checked Then S := '1' Else S := '0';
  Reg. WriteString ('Statusbar', S);

  If MainForm. Autoalignwindow1. Checked Then S := '1' Else S := '0';
  Reg. WriteString ('Autoalign', S);

  Reg. CloseKey;
  Reg. Free;
End;

Procedure OpenPort;
Begin
  P. ComNumber := Cnf. ComPort;
  P. Baud := Cnf. BaudRate;
  If Cnf. HWFlow Then P. HWFlowOptions := [hwfUseRTS, hwfRequireCTS];
  If Cnf. SWFlow Then P. SWFlowOptions := swfBoth;

  Try
    P. Open := True;
  Except
    InitError := True;
  End;
End;

Function KeyBoard (C: Char): Boolean;
Begin
  KeyBoard := True;
  AnalyzeKey (C);
End;

procedure TMainForm.MainEngine(Sender: TObject; Var Done : Boolean);

Procedure LampsOff;
Begin
  StatusLights. Monitoring := False;
  Label3. Visible := False;
  Label4. Visible := False;
  Label5. Visible := False;
  Label6. Visible := False;
  Label7. Visible := False;
  Label8. Visible := False;
  Label9. Visible := False;
  DCD. Width := 0;
  DSR. Width := 0;
  CTS. Width := 0;
  RX. Width := 0;
  TX. Width := 0;
  RI. Width := 0;
  ERR. Width := 0;
End;

Procedure RunBBS;
Begin
  miInit := False;
  miLocal := False;
  miAnswer := False;
  miBreak := False;

  DoBBS;
End;

Const
  MethodRunning : Boolean = False;

Begin
  If MethodRunning Then Exit;
  MethodRunning := True;
  // Application. Minimize;
  MainForm. SetFocus;

  ButtonPanelResize (nil);
  // Application. ProcessMessages;

  PageControl1. ActivePage := TabSheet1;
  P := ApdComPort;
  Prot := ApdProtocol;
  KeyBoardFunc := KeyBoard;

  Application. OnException := LogException;
  FormResize (nil);

  With Console1. Font Do
  Begin
    Charset := sR. FontCharset;
    Name := sR. FontName;
    Size := sR. FontSize;
    Height := sR. FontHeight;
    Style := sR. FontStyle;
  End;

  Console1. RecalibrateFont;
  If sR. Autoalign Then MainForm. Alignwindow1Click (nil);

  If sR. ActivePage = 'Log' Then
  Begin
    PageControl1. ActivePage := TabSheet2;
    ActiveControl := Memo1;
  End Else
  Begin
    PageControl1. ActivePage := TabSheet1;
    ActiveControl := Console1;
  End;
  Application. ProcessMessages;
  If Not Local Then
    MainForm. AppMinimize (TObject(Nil));
  Application. ProcessMessages;

  If Not AutoMode And Not Local Then
  Begin
    OpenPort;

    miSendFile := False;
    miBugEmu := False;
    miChat := False;
    miFont := False;
    miLockOut := False;
    miShowFile := False;

    StatusLights. Monitoring := True;
    AutonomousMode;

    Repeat
      Application. ProcessMessages;
    Until (PageControl1. ActivePage <> Autonomous) Or Application. Terminated;

    If Not Application. Terminated Then
    If Not AutoMode And Not Local Then NormExit Else
    Begin
      If Local Then
      Begin
        P. Open := False;
        LampsOff;
      End;

      miSendFile := True;
      miBugEmu := True;
      miChat := True;
      miFont := True;
      miLockOut := True;
      miShowFile := True;

      RunBBS;
    End;

  End Else
  If Not Local Then
  Begin
    OpenPort;

    If InitError Then
    Begin
      LogWrite ('!', sm (smlInitError));
      NormExit;

      LampsOff;
      SaveWinSettings;
      P. Open := False;

      Exit;
    End;

    If Not P. Open Then
    Begin
      InitError := True;
      NormExit;
      Exit;
    End Else
    If P. DCD Then
    Begin
      P. PutString (mCommand + #13);
      NewTimerSecs (Timer, 2);
      While Not TimerExpired (Timer) Do
      Begin
        Application. ProcessMessages;
        If P. CharReady Then
        Begin
          NewTimerSecs (Timer, 2);
          P. GetChar;
        End;
      End;
    End;

    StatusLights. Monitoring := True;

    If AutoMode Then
    Begin
      SetConnectSpeed (reqBaud);

      LogWrite ('~', sm (smLoadBBS) + ' ' + 'Com' +
      Long2Str (Cnf. ComPort) + ', Baud: ' +
      Long2Str (GetConnectSpeed) + '...');

      If Not P. DCD Then
      Begin
        LogWrite ('!', sm (smNoCD));
        Sleep (1500);
        If Cnf. Sound Then Begin
          {$IFDEF WIN32}
          MainForm. PlayerWave1. Stop;
          MainForm. PlayerWave1. WaveName := Cnf. Path + 'ncarrier.wav';
          MainForm. PlayerWave1. Loop := False;
          MainForm. PlayerWave1. Async := True;
          MainForm. PlayerWave1. Play;
          {$ELSE}
          SoundOf ('1 200 1 2 800 1000 -1 2 800');
          {$ENDIF}
        End;
        NormExit;
      End Else
        RunBBS;
    End;
  End Else
  Begin
    LampsOff;
    RunBBS;
  End;

  LampsOff;
  SaveWinSettings;
  P. Open := False;
end;

procedure TMainForm.ExitButtonClick(Sender: TObject);
begin
  miExit := False;
  NormExit;
end;

procedure TMainForm.BugEmuButtonClick(Sender: TObject);
begin
  If Not BugEmuButton.Enabled Then Exit;
  miBugEmu := False;
  Gluck;
  MainForm. Console1. ShowCursor;
  miBugEmu := True;
end;

procedure TMainForm.LockoutButtonClick(Sender: TObject);
begin
  If MessageDlg ('Lockout user?', mtConfirmation, [mbNo, mbYes], 0) = mrYes Then LockOut;
end;

procedure TMainForm.ChatButtonClick(Sender: TObject);
begin
  If Not ChatButton.Enabled Then Exit;
  miChat := False;
  ManualChat := True;
  Chat;
  ManualChat := False;
  miChat := True;
  NewTimerSecs (InactTimer, Round (Cnf. InactiveTime / 2));
  MainForm. Console1. ShowCursor;
end;

procedure TMainForm.HelpButtonClick(Sender: TObject);
begin
  If Not HelpButton.Enabled Then Exit;
  miHelp := False;
  HelpForm. Show;
end;

procedure TMainForm.UserInfoButtonClick(Sender: TObject);
Var
  bAge : Byte;

begin
  If Not UserInfoButton.Enabled Then Exit;
  miUserInfo := False;

  bAge := Str2Long (Copy (StrDate, 7, 4)) - Str2Long (Copy (Long2Date (R. BirthDate), 7, 4));
  If Str2Long (Copy (ReFormatDate (Long2Date (R. BirthDate), DefaultDateMask, 'DD-MM-YY'), 4, 2)) >
     Str2Long (Copy (StrDate, 4, 2)) Then Dec (bAge) Else
  If (Copy (ReFormatDate (Long2Date (R. BirthDate), DefaultDateMask, 'DD-MM-YY'), 4, 2) =
     Copy (StrDate, 4, 2)) And (Str2Long (Copy (ReFormatDate (Long2Date
     (R. BirthDate), DefaultDateMask, 'DD-MM-YY'), 1, 2)) > Str2Long (Copy (StrDate, 1, 2)))
  Then Dec (bAge);

  With InfoForm Do
  Begin
    ConnectSpeed.Caption := Long2Str (GetConnectSpeed);
    Name.Caption := R. Name;
    Birthdate.Caption := ReFormatDate (Long2Date (R. BirthDate),
      DefaultDateMask, Cnf. DateMask);
    Age.Caption := Long2Str (bAge);
    AverageCPS.Caption := Long2Str (R. AvgCPS);
    Location.Caption := R. Location;
    Password.Caption := R. Password;
    Security.Caption := Long2Str (R. Security);
    LastLogon.Caption := ReFormatDate (Long2Date (R. LastDate),
      DefaultDateMask, Cnf. DateMask);
    FirstLogon.Caption := ReFormatDate (Long2Date (R. FirstDate),
      DefaultDateMask, Cnf. DateMask);

    Show;
  End;
end;

procedure TMainForm.EditUserButtonClick(Sender: TObject);
begin
  If Not EditUserButton.Enabled Then Exit;
  miEditUser := False;
  UserEdForm. Show;
end;

procedure TMainForm.SendFileButtonClick(Sender: TObject);
Var
  S             : PathStr;
  S1            : String;
  i, oSizeOfAll : LongInt;
  oF2Transfer   : PTagFilesCollection;
  FileRec       : TTagFileRec;

begin
  If Not SendFileButton.Enabled Then Exit;
  miSendFile := False;
  ManualSendDlg. Title := 'Manual send file(s)';
  GetDir (0, S);
  ManualSendDlg. Execute;
  Console1. ShowCursor;
  SmartChDir (S);
  miSendFile := True;

  If ManualSendDlg. Files. Count = 0 Then
  Begin
    ManualSendDlg. Files. Clear;
    Exit;
  End;

  oF2Transfer := New (PTagFilesCollection, Init (F2Transfer^. Count, 1));

  If F2Transfer^. Count > 0 Then
  For i := 0 To F2Transfer^. Count-1 Do
    oF2Transfer^. Insert (NewTagFile (PTagFileRec (F2Transfer^. At (i))^));

  F2Transfer^. DeleteAll;
  oSizeOfAll := SizeOfAll;
  SizeOfAll := 0;

  For i := 0 To ManualSendDlg. Files. Count-1 Do
  Begin
    S := ManualSendDlg. Files [i];

    FileRec. PathName := S;
    FileRec. AreaNum := 0;
    FileRec. Size := gFileSize (S);
    FileRec. FromName := '';
    Inc (SizeOfAll, FileRec. Size);

    F2Transfer^. Insert (NewTagFile (FileRec));
  End;

  ManualSendDlg. Files. Clear;
  AutoDL := True;
  Transfer ('', Transmit, tsNormal);
  AutoDL := False;

  F2Transfer^. DeleteAll;
  SizeOfAll := oSizeOfAll;

  While oF2Transfer^. Count > 0 Do
  Begin
    F2Transfer^. Insert (NewTagFile (PTagFileRec (oF2Transfer^. At (0))^));
    DisposeTagFile (oF2Transfer^. At (0));
    oF2Transfer^. AtDelete (0);
  End;
  Dispose (oF2Transfer, Done);
end;

procedure TMainForm.SecurityButtonClick(Sender: TObject);
begin
  If Not SecurityButton. Enabled Then Exit;
  miSecurity := False;
  With SecurityForm Do
  Begin
    Edit. Text := Long2Str (R. Security);
    Show;
  End;
  Console1. ShowCursor;
end;

Procedure TMainForm. TagListButtonClick (Sender: TObject);
Var
  i : LongInt;
  S : String;

Begin
  If Not TagListButton.Enabled Then Exit;
  miTagList := False;

  With TagListForm Do
  Begin
    TotalFiles. Caption := Long2Str (F2Transfer^. Count);
    TotalSize. Caption := Long2Str (SizeOfAll);
      EstimatedTime. Caption := Long2Str (Round (
      EstimatedTransferTime (SizeOfAll, R. AvgCPS,
      GetConnectSpeed)/60)) + ' min.';
    ConnectSpeed. Caption := Long2Str (GetConnectSpeed);
    TagList. Clear;

    For i := 0 To Str2Long (TotalFiles. Caption)-1 Do
    Begin
      S := PTagFileRec (F2Transfer^. At (i))^. PathName;
      TagList. Items. Add (S);
    End;

    Show;
  End;
  Console1. ShowCursor;
End;

Const
  FName     : String = '';
  FilesSize : LongInt = 0;

procedure TMainForm.ApdProtocolProtocolStatus (CP: TObject; Options: Word);
Var
  ActualCPS : LongInt;
  flName    : String;
  Pr        : TApdProtocol;
  H, j      : Integer;

Const
  oTotal   : Byte = 0;
  oCurrent : Byte = 0;

begin
  Pr := TApdProtocol (CP);
  If Pr. ProtocolStatus <> 0 Then
    LogWrite ('&', 'ProtocolStatus: ' + Pr. StatusMsg (Pr. ProtocolStatus));

  Case Options Of
    apFirstCall :
      Begin
        FilesSize := SizeOfAll;
        TotalProgress. Position := 0;
        CurrentProgress. Position := 0;
        oTotal := 0;
        oCurrent := 0;

        miTagList := False;
        miSendFile := False;
        miBugEmu := False;
        miChat := False;
        miShowFile := False;
        TabSheet3. TabVisible := True;
        PageControl1. ActivePage := TabSheet3;
        ProtText1. Caption := NameVer + ' Internal ' + ProtTypeStr [Prot. ProtocolType];
        ProtText2. Caption := '(c) 1995-98, Konstantin Klyagin & Tornado Team, Kharkov, Ukraine.';
      End;
    apLastCall :
      Begin
        miTagList := True;
        miSendFile := True;
        miBugEmu := True;
        miShowFile := True;
        miChat := True;
        PageControl1. ActivePage := TabSheet1;
      End;

  Else
    If Not P. DCD Then LostCarrier;
    Clock2;

    flName := Pr. FileName;
    If (flName = '') Or Application. Terminated Then Exit;
    If FName <> flName Then
    Begin
      FileName. Caption := UpString (Trim (NiceFileName (flName, 28)));
      CurrentProgress. Position := 0;
      oCurrent := 0;

      Try
        FileDate. Caption := DateTimeToStr (Pr. FileDate);
      Except
        Try
          H := FileOpen (flName, fmOpenRead or fmShareDenyNone);
          If H > 0 Then FileDate. Caption := DateTimeToStr (FileDateToDateTime (FileGetDate (H)));
          FileClose (H);
        Except
          FileDate. Caption := 'Unknown';
        End;
      End;

      FName := Pr. FileName;

      If TrMode = Transmit
      Then
        ProtocolMsg (sm (smStartSend) + Trim (UpString (
        JustFileName (flName))) + ' (' + Long2Str (gFileSize (flName)) +
        sm (smBytes) + ')')
      Else
        ProtocolMsg (sm (smStartRecv) + Trim (UpString (
        JustFileName (flName))) + ' (' + Long2Str (Pr. FileLength) +
        sm (smBytes) + ')');

      If Pr. InitialPosition > 0 Then
        ProtocolMsg (sm (smpResuming) + ' ' +
        Long2Str (Pr. InitialPosition));

    End;

    Size. Caption := Long2Str (Pr. FileLength);

    If Prot. ElapsedTicks > 0 Then
    Begin
      ActualCPS := Trunc ((Pr. BytesTransferred -
      Pr. InitialPosition) / (Pr. ElapsedTicks / 18.2));
      If ActualCPS < 0 Then ActualCPS := 0;
    End;

    Time. Caption := HowTime (EstimatedTransferTime (Pr. FileLength,
    ActualCPS, GetConnectSpeed));

    tLeft. Caption := HowTime (EstimatedTransferTime (Pr. BytesRemaining,
    ActualCPS, GetConnectSpeed));

    Block. Caption := Long2Str (Pr. BlockLength);
    Errors. Caption := Long2Str (Pr. TotalErrors);
    CPS. Caption := Long2Str (ActualCPS);
    FPos. Caption := Long2Str (Pr. BytesTransferred);

    If Pr. FileLength > 0 Then
    Begin
      j := Trunc (Pr. BytesTransferred/(Pr. FileLength/100));
      If j <> oCurrent Then
      Begin
        CurrentProgress. Position := j;
        oCurrent := j;
      End;
    End;

    If FilesSize > 0 Then
    Begin
      j := Trunc ((TotalBytesTrans+Pr. BytesTransferred)/(FilesSize/100));
      If j <> oTotal Then
      Begin
        TotalProgress. Position := j;
        oTotal := j;
      End;
    End;

  end;
end;

procedure TMainForm.ApdProtocolProtocolLog(CP: TObject; Log: Word);
begin
  LogFile (Log);
end;

procedure TMainForm.ApdProtocolProtocolNextFile(CP: TObject;
  var FName: TPassString);
Var
  S : PathStr;

begin
  S := FName;
  If Not Next2Transfer (S) Then S := '';
  FName := S;
end;

procedure TMainForm.ApdProtocolProtocolAccept(CP: TObject;
  var Accept: Boolean; var FName: TPassString);
begin
  Accept := Protocol. AcceptFile (FName);
end;

procedure TMainForm.FontButtonClick(Sender: TObject);
begin
  FontDialog. Font := Console1. Font;
  miFont := False;
  If FontDialog. Execute Then Console1. Font := TFixedFont (FontDialog. Font);
  Console1. Font. Charset := OEM_CHARSET;
  If Console1. Font. Size = 8 Then Console1. Font. Height := -10;
  miFont := True;

  Console1. RecalibrateFont;
  Console1. ShowCursor;
  If Autoalignwindow1. Checked Then Alignwindow1Click (nil);
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
  If Prot. InProgress Then Prot. CancelProtocol;
end;

procedure TMainForm.ShowFileButtonClick(Sender: TObject);
Var
  S : String;
  i : LongInt;

begin
  ComSaveScreen;
  miShowFile := False;
  ShowDlg. Title := 'Show file(s)';
  GetDir (0, S);
  ShowDlg. Execute;
  Console1. ShowCursor;
  SmartChDir (S);
  miShowFile := True;

  If ShowDlg. Files. Count > 0 Then
  Begin
    For i := 0 To ShowDlg. Files. Count-1
    Do InsDisp (ShowDlg. Files [i]);
    ShowDlg. Files. Clear;
  End;
  ComRestoreScreen (InLightBarMenu);
end;

procedure TMainForm.Panel9Resize(Sender: TObject);
begin
  CurrentProgress. Width := Panel9. Width - 57;
  TotalProgress. Width := Panel9. Width - 57;
  ToolBarButton971. Left := Panel9. Width - 46;
end;

procedure TMainForm.ButtonPanelResize(Sender: TObject);
Var
  Distance : LongInt;

begin
  Distance := Trunc ((WorkButtons.Width-40*12)/13);

  If Distance >= 0 Then
  Begin
    FontButton. Width := 40;
    HelpButton. Width := 40;
    UserInfoButton. Width := 40;
    EditUserButton. Width := 40;
    SecurityButton. Width := 40;
    TagListButton. Width := 40;
    SendFileButton. Width := 40;
    ShowFileButton. Width := 40;
    BugEmuButton. Width := 40;
    ChatButton. Width := 40;
    LockOutButton. Width := 40;
    ExitButton. Width := 40;
    HelpButton. Left := Distance;
  End Else
  Begin
    Distance := Trunc ((WorkButtons. Width-2)/12);
    HelpButton. Width := Distance;
    FontButton. Width := Distance;
    UserInfoButton. Width := Distance;
    EditUserButton. Width := Distance;
    SecurityButton. Width := Distance;
    TagListButton. Width := Distance;
    SendFileButton. Width := Distance;
    ShowFileButton. Width := Distance;
    BugEmuButton. Width := Distance;
    ChatButton. Width := Distance;
    LockOutButton. Width := Distance;
    ExitButton. Width := Distance;
    HelpButton. Left := 4;
    Distance := 0;
  End;

  FontButton. Left := HelpButton.Width+HelpButton.Left+Distance;
  UserInfoButton. Left := FontButton.Width+FontButton.Left+Distance;
  EditUserButton. Left := UserInfoButton.Width+UserInfoButton.Left+Distance;
  SecurityButton. Left := EditUserButton.Width+EditUserButton.Left+Distance;
  TagListButton. Left := SecurityButton.Width+SecurityButton.Left+Distance;
  SendFileButton. Left := TagListButton.Width+TagListButton.Left+Distance;
  ShowFileButton. Left := SendFileButton.Width+SendFileButton.Left+Distance;
  BugEmuButton. Left := ShowFileButton.Width+ShowFileButton.Left+Distance;
  ChatButton. Left := BugEmuButton.Width+BugEmuButton.Left+Distance;
  LockOutButton. Left := ChatButton.Width+ChatButton.Left+Distance;
  ExitButton. Left := LockOutButton.Width+LockOutButton.Left+Distance;

  (*
  Distance := Trunc ((WaitButtons.Width-43*5)/6);

  If Distance >= 0 Then
  Begin
    InitButton. Width := 43;
    AnswerButton. Width := 43;
    LocalButton. Width := 43;
    wExitButton. Width := 43;
  End Else
  Begin
    Distance := Trunc ((WorkButtons. Width-2)/5);
    InitButton. Width := Distance;
    AnswerButton. Width := Distance;
    LocalButton. Width := Distance;
    wExitButton. Width := Distance;
    InitButton. Left := 4;
    Distance := 0;
  End;

  AnswerButton. Left := InitButton. Width+InitButton. Left+Distance;
  LocalButton. Left := AnswerButton. Width+AnswerButton. Left+Distance;
  wExitButton. Left := LocalButton. Width+LocalButton. Left+Distance;
  *)
end;

procedure TMainForm.FormResize(Sender: TObject);
Var
  DeltaX, DeltaY : Byte;

begin
  If Not Autoalignwindow1. Checked Then
  With Console1 Do
  Begin
    If ScrollBarsEnabled Then
    Begin
      DeltaX := 2;
      DeltaY := 1;
    End Else
    Begin
      DeltaX := 0;
      DeltaY := 0;
    End;

    FClientSize.X := ClientWidth div FCharSize.X;
    FClientSize.Y := ClientHeight div FCharSize.Y;
    If FRange.X > 0 Then FRange.X := Cols - FClientSize.X Else FRange.X := 0;
    If FRange.Y > 0 Then FRange.Y := Rows - FClientSize.Y Else FRange.Y := 0;

    ScrollBarsEnabled :=
      (FClientSize.X < FCols-DeltaX) Or
      (FClientSize.Y < FRows-DeltaY);

    Console1. SetScrollBars;
  End Else
    Alignwindow1Click (nil);
end;

procedure TMainForm.LogException (Sender: TObject; E: Exception);
var
  Msg: string;

begin
  Msg := E.Message;
  if (Msg <> '') and (AnsiLastChar(Msg) > '.') then Msg := Msg + '.';
  LogWrite ('!', 'Exception: ' + Msg);
  EraseFlag (RunFlag);
  LogClose;
  SaveTime;
  mL_Done;
  P. Open := False;

  If AfterCommand <> '' Then
  With Executer Do
  Begin
    Clear;
    Wait := False;
    ChangeDir := False;
    ExeParams. Add (AfterCommand);
    Try Execute; Except End;
  End;

  Application. Terminate;
  Application. ProcessMessages;
end;

procedure TMainForm.PageControl1Change(Sender: TObject);
begin
  If WaitFinished Then
  Case TTabControl (PageControl1). TabIndex Of
    0 : Begin
          ActiveControl := Console1;
          Console1. ShowCursor;
        End;
    1 : ActiveControl := Memo1;
    3 : ;
  End Else
  If TTabControl (PageControl1). TabIndex = 0 Then
    ActiveControl := Memo1;
end;

function TMainForm.Prepare: boolean;

Procedure ParseCommandLine;
Var
  Valid         : Boolean;
  i             : Byte;
  err           : Integer;

Begin
  For i := 1 To ParamCount Do
  Begin
    Valid := False;

    If   ((UpString (Copy (ParamStr (i), 1, 2)) = '-?')
       Or (UpString (Copy (ParamStr (i), 1, 2)) = '/?')
       Or (UpString (Copy (ParamStr (i), 1, 1)) =  '?')) Then
    Begin
      CommandLineForm. ShowModal;
      Application. Terminate;
      Application. ProcessMessages;
      Exit;
    End;

    If UpString (Copy (ParamStr (i), 1, 2)) = '-K' Then
    Begin
      If Trim (Copy (ParamStr (i), 3, 255)) <> '' Then
         ConfigName := Copy (ParamStr (i), 3, 255);
      Valid := True;
    End;

    If UpString (Copy (ParamStr (i), 1, 2)) = '-O' Then
    Begin
      OvrName := Copy (ParamStr (i), 3, 255);
      Valid := True;
    End;

    If UpString (Copy (ParamStr (i), 1, 2)) = '-U' Then
    Begin
      ReqName := PlaceSubStr (Copy (ParamStr (i), 3, 255), '_', ' ');
      ReqName := PrString (ReqName);
      Valid := True;
    End;

    If UpString (Copy (ParamStr (i), 1, 2)) = '-A' Then
    Begin
      AfterCommand := PlaceSubStr (Copy (ParamStr (i), 3, 255), '_', ' ');
      Valid := True;
    End;

    If UpString (Copy (ParamStr (i), 1, 2)) = '-M' Then
    Begin
      mCommand := Copy (ParamStr (i), 3, 255);
      Valid := True;
    End;

    If UpString (Copy (ParamStr (i), 1, 2)) = '-E' Then
    Begin
      ToEventTime := Str2Long (Copy (ParamStr (i), 3, 255));
      Valid := True;
    End;

    If UpString (ParamStr (i)) = '-L' Then
    Begin
      Local := True;
      reqBaud := 0;
      Cnf. ComPort := 0;
      Valid := True;
    End;

    If UpString (Copy (ParamStr (i), 1, 2)) = '-C' Then
    Begin
      Val (Copy (ParamStr (i), 3, 255), reqPort, err);
      AutoMode := True;
      Local := False;
      Valid := True;
    End;

    If UpString (Copy (ParamStr (i), 1, 2)) = '-B' Then
    Begin
      Val (Copy (ParamStr (i), 3, 97), reqBaud, err);
      AutoMode := True;
      Local := False;
      Valid := True;
    End;

    If UpString (Copy (ParamStr (i), 1, 2)) = '-N' Then
    Begin
      Val (Copy (ParamStr (i), 3, 97), BbsLine, err);
      Valid := True;
    End;

    If UpString (Copy (ParamStr (i), 1, 2)) = '-S' Then
    Begin
      RunScript := Copy (ParamStr (i), 3, 255);
      Valid := True;
    End;

    If Not Valid Then
    Begin
      ShowMessage ('Unknown command line parameter: "' + ParamStr (i) + '"');
      Application. Terminate;
      Application. ProcessMessages;
      Exit;
    End;

  End;
End;

Procedure CheckFiles;
Var
  LogString     : String [100];
  Fatal         : Boolean;

Begin
  Fatal := True;
  LogString := '';

  If Not FileExists (Cnf. LimitsFile) Then LogString :=  sm (smFile) +
         Trim (NiceFileName (Cnf. LimitsFile, 50)) + sm (smNotFound);

  If Not FileExists (Cnf. FileAreasFile) Then
  Begin
    LogString :=  sm (smFile) +
    Trim (NiceFileName (Cnf. FileAreasFile, 50)) +
    sm (smNotFound);
    Fatal := False;
  End;

  If Not FileExists (Cnf. MsgAreasFile) Then
  Begin
    LogString := sm (smFile) +
    Trim (NiceFileName (Cnf. MsgAreasFile, 50)) +
    sm (smNotFound);
    Fatal := False;
  End;

  If Not FileExists (Cnf. DefLangFile) Then LogString := sm (smFile) +
         Trim (NiceFileName (Cnf. DefLangFile, 50)) + sm (smNotFound);

  If LogString <> '' Then
  Begin
    LogWrite ('!', LogString);
    Sleep (2000);
    If Fatal Then ErrorExit;
  End;
End;

Procedure SetMessages;
Var
  S, S1 : PChar;

Begin
  GetMem (S, 256);
  GetMem (S1, 256);

  With UserEdForm Do
  Begin
    StrPCopy (S, sm (smueLocation)); OemToAnsi (S, S1); Label1. Caption := S1;
    StrPCopy (S, sm (smueOrganization)); OemToAnsi (S, S1); Label2. Caption := S1;
    StrPCopy (S, sm (smue1stAddress)); OemToAnsi (S, S1); Label3. Caption := S1;
    StrPCopy (S, sm (smue2ndAddress)); OemToAnsi (S, S1); Label4. Caption := S1;
    StrPCopy (S, sm (smue3rdAddress)); OemToAnsi (S, S1); Label5. Caption := S1;
    StrPCopy (S, sm (smueAlias)); OemToAnsi (S, S1); Label6. Caption := S1;
    StrPCopy (S, sm (smueDataPhone)); OemToAnsi (S, S1); Label7. Caption := S1;
    StrPCopy (S, sm (smueComment)); OemToAnsi (S, S1); Label8. Caption := S1;
    StrPCopy (S, sm (smueHomePhone)); OemToAnsi (S, S1); Label9. Caption := S1;
    StrPCopy (S, sm (smuePassword)); OemToAnsi (S, S1); Label10. Caption := S1;
    StrPCopy (S, sm (smueBirthDate)); OemToAnsi (S, S1); Label11. Caption := S1;
    StrPCopy (S, sm (smueMsgsPosted)); OemToAnsi (S, S1); Label12. Caption := S1;
    StrPCopy (S, sm (smueProtocol)); OemToAnsi (S, S1); Label13. Caption := S1;
    StrPCopy (S, sm (smueLines)); OemToAnsi (S, S1); Label14. Caption := S1;
    StrPCopy (S, sm (smueLanguage)); OemToAnsi (S, S1); Label15. Caption := S1;
    StrPCopy (S, sm (smueFlags)); OemToAnsi (S, S1); Label17. Caption := S1;
    StrPCopy (S, sm (smueDownloads)); OemToAnsi (S, S1); Label18. Caption := S1;
    StrPCopy (S, sm (smueDownloadsK)); OemToAnsi (S, S1); Label18. Caption := S1;
    StrPCopy (S, sm (smueUploadsK)); OemToAnsi (S, S1); Label24. Caption := S1;
    StrPCopy (S, sm (smueTodayK)); OemToAnsi (S, S1); Label25. Caption := S1;
    StrPCopy (S, sm (smueUploads)); OemToAnsi (S, S1); Label26. Caption := S1;
    StrPCopy (S, 'Security'); OemToAnsi (S, S1); Label28. Caption := S1;
    StrPCopy (S, sm (smuePausing)); OemToAnsi (S, S1); More. Caption := S1;
    StrPCopy (S, sm (smueHotKeys)); OemToAnsi (S, S1); HotKeys. Caption := S1;
    StrPCopy (S, sm (smueEmulation)); OemToAnsi (S, S1); EmuGroup. Caption := ' ' + S1 + ' ';
  End;

  StrPCopy (S, PlaceSubStr (sm (smsSysCalls), ':', ''));
  OemToAnsi (S, S1); Label12. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smsUsers), ':', ''));
  OemToAnsi (S, S1); Label13. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smsPosted), ':', ''));
  OemToAnsi (S, S1); Label14. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smsUpLoads), ':', ''));
  OemToAnsi (S, S1); Label15. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smsDownLoads), ':', ''));
  OemToAnsi (S, S1); Label16. Caption := S1;

  StrPCopy (S, PlaceSubStr (sm (smpFileName), ':', ''));
  OemToAnsi (S, S1); Label19. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smpDate), ':', ''));
  OemToAnsi (S, S1); Label20. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smpBlock), ':', ''));
  OemToAnsi (S, S1); Label21. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smpTotalErr), ':', ''));
  OemToAnsi (S, S1); Label22. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smpSize), ':', ''));
  OemToAnsi (S, S1); Label27. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smpBytesTransf), ':', ''));
  OemToAnsi (S, S1); Label26. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smpTime), ':', ''));
  OemToAnsi (S, S1); Label25. Caption := S1;
  StrPCopy (S, PlaceSubStr (sm (smpTimeLeft), ':', ''));
  OemToAnsi (S, S1); Label24. Caption := S1;

  With TagListForm Do
  Begin
    StrPCopy (S, PlaceSubStr (sm (smTotalFiles), ':', ''));
    OemToAnsi (S, S1); Label1. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smTotalSize), ':', ''));
    OemToAnsi (S, S1); Label2. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smEstTime), ':', ''));
    OemToAnsi (S, S1); Label3. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smibSpeed), ':', ''));
    OemToAnsi (S, S1); Label4. Caption := S1;
  End;

  StrPCopy (S, sm (smSecLevel)); OemToAnsi (S, S1); SecurityForm. Label1. Caption := S1;
  StrPCopy (S, sm (smwPaging)); OemToAnsi (S, S1); PageForm. Caption := S1;

  With InfoForm Do
  Begin
    StrPCopy (S, PlaceSubStr (sm (smibSpeed), ':', ''));
    OemToAnsi (S, S1); Label1. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smibAvgCPS), ':', ''));
    OemToAnsi (S, S1); Label2. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smibName), ':', ''));
    OemToAnsi (S, S1); Label3. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smibBirthDate), ':', ''));
    OemToAnsi (S, S1); Label4. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smibAge), ':', ''));
    OemToAnsi (S, S1); Label5. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smibLocation), ':', ''));
    OemToAnsi (S, S1); Label6. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smibPassword), ':', ''));
    OemToAnsi (S, S1); Label7. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smibSecurity), ':', ''));
    OemToAnsi (S, S1); Label8. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smibLastDate), ':', ''));
    OemToAnsi (S, S1); Label17. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smibFirstDate), ':', ''));
    OemToAnsi (S, S1); Label18. Caption := S1;
  End;

  With EmsiBox Do
  Begin
    StrPCopy (S, PlaceSubStr (sm (smeUserName), ':', ''));
    OemToAnsi (S, S1); Label1. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smeLocation), ':', ''));
    OemToAnsi (S, S1); Label2. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smeDPhone), ':', ''));
    OemToAnsi (S, S1); Label3. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smeVPhone), ':', ''));
    OemToAnsi (S, S1); Label4. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smePassword), ':', ''));
    OemToAnsi (S, S1); Label5. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smeBirthdate), ':', ''));
    OemToAnsi (S, S1); Label6. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smeSoftware), ':', ''));
    OemToAnsi (S, S1); Label7. Caption := S1;

    StrPCopy (S, PlaceSubStr (sm (smeHead2), #196, ''));
    OemToAnsi (S, S1); GroupBox1. Caption := S1;
    StrPCopy (S, PlaceSubStr (sm (smeHead1), #196, ''));
    OemToAnsi (S, S1); GroupBox2. Caption := S1;
  End;

  StrPCopy (S, sm (smmFile)); OemToAnsi (S, S1); File1. Caption  := S1; File2. Caption  := S1;
  StrPCopy (S, sm (smmWindow)); OemToAnsi (S, S1); Window1. Caption  := S1; Window2. Caption  := S1;
  StrPCopy (S, sm (smmModem)); OemToAnsi (S, S1); Modem1. Caption  := S1;
  StrPCopy (S, sm (smmLocalMode)); OemToAnsi (S, S1); Localmode1. Caption  := S1;
  StrPCopy (S, sm (smmExit)); OemToAnsi (S, S1); Exit1. Caption  := S1; Exit2. Caption  := S1;
  StrPCopy (S, sm (smmShowstatusbar)); OemToAnsi (S, S1); Showstatusbar1. Caption  := S1; Showstatusbar2. Caption  := S1;
  StrPCopy (S, sm (smmShowtoolbar)); OemToAnsi (S, S1); Showtoolbar1. Caption  := S1; Showtoolbar2. Caption  := S1;
  StrPCopy (S, sm (smmAutoalign)); OemToAnsi (S, S1); Autoalignwindow1. Caption  := S1; Autoalignwindow2. Caption  := S1;
  StrPCopy (S, sm (smmInit)); OemToAnsi (S, S1); Initialize1. Caption  := S1;
  StrPCopy (S, sm (smmAnswer)); OemToAnsi (S, S1); Answer1. Caption  := S1;
  StrPCopy (S, sm (smmBreak)); OemToAnsi (S, S1); Break1. Caption  := S1;
  StrPCopy (S, sm (smmSendFile)); OemToAnsi (S, S1); Sendfile1. Caption  := S1;
  StrPCopy (S, sm (smmShowfile)); OemToAnsi (S, S1); Showfile1. Caption  := S1;
  StrPCopy (S, sm (smmTaggedfiles)); OemToAnsi (S, S1); Taggedfiles1. Caption  := S1;
  StrPCopy (S, sm (smmUser)); OemToAnsi (S, S1); User1. Caption  := S1;
  StrPCopy (S, sm (smmViewinfo)); OemToAnsi (S, S1); Viewinfo1. Caption  := S1;
  StrPCopy (S, sm (smmSetsecurity)); OemToAnsi (S, S1); Setsecuritylevel1. Caption  := S1;
  StrPCopy (S, sm (smmEditUser)); OemToAnsi (S, S1); EditUsersparameters1. Caption  := S1;
  StrPCopy (S, sm (smmChat)); OemToAnsi (S, S1); Chatwiththeuser1. Caption  := S1;
  StrPCopy (S, sm (smmBugs)); OemToAnsi (S, S1); Bugs1. Caption  := S1;
  StrPCopy (S, sm (smmIncTime)); OemToAnsi (S, S1); Increasetimeby1min1. Caption  := S1;
  StrPCopy (S, sm (smmDecTime)); OemToAnsi (S, S1); Decreasetimeby1min1. Caption  := S1;
  StrPCopy (S, sm (smmIncKB)); OemToAnsi (S, S1); IncreaseFilesby50K. Caption  := S1;
  StrPCopy (S, sm (smmDecKB)); OemToAnsi (S, S1); DecreaseFilesby50K. Caption  := S1;
  StrPCopy (S, sm (smmLockout)); OemToAnsi (S, S1); Lockout1. Caption  := S1;
  StrPCopy (S, sm (smmHangup)); OemToAnsi (S, S1); Hangup1. Caption  := S1;
  StrPCopy (S, sm (smmSetfont)); OemToAnsi (S, S1); Font1. Caption  := S1;
  StrPCopy (S, sm (smmHelp)); OemToAnsi (S, S1); Help1. Caption  := S1;
  StrPCopy (S, sm (smmProgramkeys)); OemToAnsi (S, S1); Programkeys1. Caption  := S1;
  StrPCopy (S, sm (smmCommandline)); OemToAnsi (S, S1); Commandline1. Caption  := S1;

  FreeMem (S, 256);
  FreeMem (S1, 256);
End;

Var
  ms : LongInt;

Begin
  Local := False;
  Prepare := True;
  ToEventTime := 0;
  InitError := False;
  GetDir (0, oDir);

  TorDir := UpString (JustPathName (ParamStr (0)));
  SmartChDir (TorDir);
  TorDir := AddBackSlash (TorDir);

  ConfigName := TorDir + 'tornado.ctl';
  ReqName := '';
  Registering := False;
  AutoMode := False;
  reqBaud := 0;

  ParseCommandLine;
  If Application. Terminated Then
  Begin
    Prepare := False;
    Exit;
  End;

  ResRead (CompletePath (JustPathName (ParamStr (0))) + 'tornado.msg');
  SetMessages;

  ReadMainConfig (ConfigName, Cnf);
  If ((RunScript <> '') Or (RunRexx <> '')) And (ReqName = '') Then ReqName := PrString (Cnf. SysOp);

  Int2MonthFunc := Int2Month;
  If Trim (Cnf. LogFile) <> '' Then
  Begin
    If (Pos (':', Cnf. Logfile) = 0) and (Pos ('\', Cnf. Logfile) = 0) Then
      Cnf. LogFile := TorDir + Cnf. LogFile;
    LogOpen (Cnf. LogFile, Cnf. LogEvents, sm (smLogCreated));
  End;

  If AutoMode Then
  Begin
    If reqBaud = 0 Then reqBaud := Cnf. BaudRate;
    If reqPort <> 0 Then Cnf. ComPort := reqPort Else reqPort := Cnf. ComPort;
  End;

  Probegat := False;
  WantsChat := False;
  deltaTime := 0;

  HotKeysStr := '';
  Ansi. ToBell := Cnf. Sound;

  { ms := MidSec; }
  OpenFileAreas; CloseFileAreas;
  OpenMsgAreas; CloseMsgAreas;
  OpenFileGroups; CloseFileGroups;
  OpenMsgGroups; CloseMsgGroups;
  { ShowMessage ('Time used: ' + Long2Str (MidSec-ms)); }

  InitMainCOvr;
  InitMultiUnit;
  InitTMainOvr;
  InitShellUnit;

  If DirExists (Cnf. Path) Then SmartChDir (Copy (Cnf. Path, 1, Length (Cnf. Path) - 1)) Else
  Begin
    ShowMessage (Str2Win (sm (smWorkDirNotFound)));
    If Cnf. Sound Then SoundOf ('1 200 1 2 800 1000 -1 2 800');
    Halt (205);
  End;

  If Not DirExists (Cnf. TempDir) Or Not DirExists (Cnf. DoorInfoDir) Then
  Begin
    ShowMessage (Str2Win (sm (smTempDirNotFound)));
    If Cnf. Sound Then SoundOf ('1 200 1 2 800 1000 -1 2 800');
    Halt (205);
  End;

  If (UpString (Cnf. TempDir) = UpString (Cnf. Path)) Or
     (UpString (Cnf. DoorInfoDir) = UpString (Cnf. Path)) Then
  Begin
    ShowMessage (Str2Win (sm (smTempDoorNPath)));
    If Cnf. Sound Then SoundOf ('1 200 1 2 800 1000 -1 2 800');
    Halt (205);
  End;

  StatusBar := False;
  StatusBarEnable := False;
  EnterTime := MidSec;
  InChat := False;
  InShell := False;
  InAction := False;
  EnteringPass := False;
  SizeOfAll := 0;
  SessionDL := 0;
  SessionUL := 0;
  AutoDL := False;
  PrevLang := JustName (Cnf. DefLangFile);
  NetMailEntered  := False;
  EchoMailEntered := False;
  SetSoundBellProc (TorSoundBell);
  WaitReturn := MainComm. RetWait;
  MenuItems := New (PMenuItemsCollection, Init (10, 2));
  MsgText := New (PBigCollection, Init (10, 2));
  XLATs := New (PNotSortedCollection, Init (2, 2));
  qwkAreas := New (PNotSortedCollection, Init (10, 2));
  Screens := New (PNotSortedCollection, Init (1, 1));
  Reps := New (PBigCollection, Init (5, 5));
  ExecScript := tExecScript;
  ExecRexx := tExecRexx;
  Randomize;

  F2Transfer := New (PTagFilesCollection, Init (10, 1));
  UpFiles    := New (PBigCollection, Init (10, 1));

  InitCompSys;
  SetBaseName (Cnf. Path + 'users.tor');

  If Not tMisc. FileExists (Cnf. Path + 'system.tor') Then WriteSystemStatus (Sys, Cnf. Path + 'system.tor');
  ReadSystemStatus (Sys, Cnf. Path + 'system.tor');
  uNum := UsersNum;

{$IFNDEF AUTHOR}
  If LineUsed Then
  Begin
    If BbsLine <> 0 Then LogWrite ('!', sm (smLineUsed)) Else LogWrite ('!', sm (smAlreadyRun));
    Kill_Line_Flag := False;
    Prepare := False;
    Exit;
  End;

  MakeFlag (RunFlag);
{$ENDIF}

  EraseFlag (FileFlag);
  KeyBuffer := '';
  EMSI. Allowed := Cnf. IEMSI_Enable;
  EMSI. Session := False;
  RegLet := 0;

  CheckFiles;

  If (Cnf. BaudRate = 0)
  Or (Cnf. ComPort = {$IFNDEF OS2} 0 {$ELSE} '' {$ENDIF}) Then
  Begin
    AutoMode := False;
    Local := True;
  End;

  ReadWinSettings;
(*
  Protect. SysOp := Cnf. SysOp;
  InitKey ('tornado.key');

  If Protect. Registered And Protect. RegWin32
  Then
    NameVer := NameVer + '/R' + Long2Str (Protect. RegNum)
  Else
    NameVer := NameVer + '/UNREG';
*)
  If BbsLine <> 0 Then
{  If Protect. Registered Or (Not Protect. Registered And (BbsLine < 3))
  Then}
    LogWrite (':', sm (smlMultiLine) + Long2Str (BbsLine))
{  Else Begin
    S := 'Can''t run more than 2 lines with UNREGISTERED version';
    LogWrite ('!', S);
    ShowMessage (S);
    Application. Terminate;
    Prepare := False;
    Exit;
  End};

  Application.Title := 'Tornado, running ...';
End;

procedure TMainForm.ModemAnswerCount(M: TObject; Remaining: Word);
begin
  If Modem. IsAttemptingConnect And Not sUpdated Then
  Begin
    Status. Caption := 'Answering ...';
    sUpdated := True;
  End;
end;

procedure TMainForm.ModemModemRing(Sender: TObject);
begin
  mResult. Caption := Modem. RingMsg;
  If Not MatchTimeArray (Cnf. Answer) Then
  Begin
    Modem. CancelDialAnswer;
    Modem. AutoAnswer (2);
  End;
end;

procedure TMainForm.ModemAnswerTimedOut(Sender: TObject);
begin
  mResult. Caption := Modem. NoCarrierMsg;
  miAnswer := True;
  miInit := True;
end;

Function WaitResult: Boolean;
Begin
  Application. ProcessMessages;
  WaitResult := Not Application. Terminated;
End;

procedure TMainForm.InitButtonClick(Sender: TObject);
var
  i : Byte;
  ModemResult : tModemResponse;

begin
  miInit := False;
  miAnswer := False;
  miBreak := False;
  InitOk := False;
  Modem. Started := False;

  InitError := False;
  P. Open := False;
  OpenPort;

  If InitError Then
  Begin
    mResult. Caption := 'Unable to open COM' + Long2Str (Cnf. ComPort);
  End Else
  Begin
    For i := 1 To Cnf. InitTryes Do
    Begin
      Status. Caption := sInitModem + ', ' + Long2Str (Cnf.
      BaudRate) + ' bps.. [' + Long2Str (i) + ']';

      DoCommand (Cnf. InitString);
      ModemResult := GetModemResponse (rmInit, 180, WaitResult);
      mResult. Caption := LastResponse;

      If ModemResult in [mdmrOk, mrRing] Then
      Begin
        InitOk := True;
        Break;
      End Else
        mResult. Caption := tModem. LastResponse;
    End;

    If Not InitOk Then mResult. Caption := 'Unable to initialize the modem';
    Modem. Started := True;
    Status. Caption := sCallWait + '..';
    sUpdated := False;
    Modem. AutoAnswer (Cnf. Rings);
    miAnswer := True;
    miBreak := True;
  End;

  miInit := True;
end;

procedure TMainForm.ModemCommandProcessed(M: TObject;
  WhatHappened: TModemStatus; Data: Integer);
begin
  Case WhatHappened Of
    msModemOK        : mResult. Caption := Modem. OkMsg;
    msModemNoCarrier : mResult. Caption := Modem. NoCarrierMsg;
    msModemError     : mResult. Caption := Modem. ErrorMsg;
    msCmdTimeout     : mResult. Caption := '';
    msModemRing      : mResult. Caption := Modem. RingMsg;
  End;
end;

procedure TMainForm.ModemModemIsConnected(Sender: TObject);
Var
  S, S1 : String;
  i     : Byte;

begin
  AutoMode := True;
  S := Modem. LastString;
  S := Trim (Copy (S, Length (Cnf. ConnectStr)+1, 255));
  i := 1;
  S1 := '';

  While (i <= Length (S)) And (S [i] in ['0'..'9']) Do
  Begin
    S1 := S1 + S [i];
    Inc (i);
  End;

  SetConnectSpeed (Str2Long (S1));
  Modem. Started := False;
  WaitFinished := True;
end;

procedure TMainForm.ModemConnectFailed(Sender: TObject);
begin
  BreakButtonClick (Self);
end;

procedure TMainForm.BreakButtonClick(Sender: TObject);
begin
  If Modem. IsAttemptingConnect Then
  With Modem Do
  Begin
    CancelDialAnswer;
    sUpdated := False;
    AutoAnswer (Cnf. Rings);
  End;
  Status. Caption := sCallWait + '..';
  miAnswer := True;
  miInit := True;
end;

procedure TMainForm.AutonomousMode;
Var
  S, S1 : PChar;

begin
  If PageControl1. ActivePage <> TabSheet2 Then
  Begin
    PageControl1. ActivePage := Autonomous;
    ActiveControl := Panel3;
    Menu := WaitMenu;
  End;

  PageControl2. ActivePage := WaitButtons;
  TabSheet1. TabVisible := False;
  Autonomous. TabVisible := True;
  ButtonPanelResize (nil);

  GetMem (S, 256);
  GetMem (S1, 256);

  StrPCopy (S, sm (smCallWait)); OemToAnsi (S, S1); sCallWait := StrPas (S1);
  StrPCopy (S, sm (smInitModem)); OemToAnsi (S, S1); sInitModem := StrPas (S1);

  FreeMem (S, 256);
  FreeMem (S1, 256);

  If ReadLastCaller (LC, trlcOpen4Stat) Then
  Begin
    While ReadLastCaller (LC, trlcRead) Do
    Begin
      If LC. Name = '' Then Continue;
      LastList. Items. Add (LC. LoginTime + ' ' + LC. Name + ' (' +
      Long2Str (LC. TimeOnLine) + ' min., ' + Long2Str (LC. DLkb) + '/' +
      Long2Str (LC. ULkb) + ')');
    End;
    ReadLastCaller (LC, trlcClose);
  End;

  TotalCalls. Caption := Long2Str (Sys. TotalCalls);
  TotalUsers. Caption := Long2Str (uNum);
  MsgsPosted. Caption := Long2Str (Sys. MsgsPosted);
  TotalULs. Caption := Long2Str (Sys. UpLoads);
  TotalDLs. Caption := Long2Str (Sys. DownLoads);

  With Modem Do
  Begin
    ComPort := P;
    AnswerTimeOut := Cnf. CDTime;
    ConnectMsg := Cnf. ConnectStr;
    RingMsg := Cnf. RingStr;
    NoCarrierMsg := Cnf. NoCarrierStr;
    OkMsg := Cnf. OkStr;
  {$IFNDEF AUTHOR}
    AnswerCmd := PlaceSubStr (Cnf. AnswerString, '|', '^M');
  {$ELSE}
    AnswerCmd := 'AT&N3M1A^M';
  {$ENDIF}
    InitButtonClick (nil);

    If Not InitOk Then
    Begin
      LogWrite ('!', sm (smlInitError));
      NormExit;
      Exit;
    End;
  End;

  Status. Caption := sCallWait + '..';
  LogWrite (':', sm (smCallWait));
  SetTitle ('waiting for call');

  WaitFinished := False;
  // Application. Restore;

  Repeat
    Application. ProcessMessages;
  Until WaitFinished Or Application. Terminated;

  If Not Application. Terminated Then
  Begin
    If PageControl1. ActivePage <> TabSheet2 Then
    Begin
      PageControl1. ActivePage := TabSheet1;
      ActiveControl := Console1;
    End Else
      ActiveControl := Memo1;

    PageControl2. ActivePage := WorkButtons;
    TabSheet1. TabVisible := True;
    Autonomous. TabVisible := False;
    ButtonPanelResize (nil);
    Menu := WorkMenu;
  End;
end;

procedure TMainForm.AnswerButtonClick(Sender: TObject);
begin
  Status. Caption := 'Answering ...';
  If Not Modem. IsAttemptingConnect Then
  With Modem Do
  Begin
    miAnswer := False;
    miInit := False;
    CancelDialAnswer;
    Answer;
  End;
end;

procedure TMainForm.LocalButtonClick(Sender: TObject);
begin
  Local := True;
  Modem. Started := False;
  WaitFinished := True;
end;

procedure TMainForm.Panel2Resize(Sender: TObject);
begin
  ProtText1. Width := Panel2. Width - 14;
  ProtText2. Width := Panel2. Width - 14;
end;

procedure TMainForm.Panel8Resize(Sender: TObject);
begin
  FileName. Width := Panel8. Width-70;
end;

procedure TMainForm.LastListEnter(Sender: TObject);
begin
  ActiveControl := Panel3;
end;

procedure TMainForm.TabSheet1Enter(Sender: TObject);
begin
  ActiveControl := Console1;
end;

procedure TMainForm.AppMinimize(Sender: TObject);
begin
(*  MainForm.WindowState := wsNormal;
  MainForm.Show;*)
  RxTrayIcon1. Icon := Application. Icon;
  RxTrayIcon1. Active := True;
  MainForm. Hide;
end;

procedure TMainForm.AppRestore(Sender: TObject);
begin
  MainForm. Show;
  MainForm. SetFocus;
  RxTrayIcon1. Active := False;
  Application. Restore;
  Application. BringToFront;
end;

procedure TMainForm.misInit (B: Boolean);
begin
  InitButton. Enabled := B;
  Initialize1. Enabled := B;
  migInit := B;
end;

procedure TMainForm.misLocal (B: Boolean);
begin
  LocalButton. Enabled := B;
  Localmode1. Enabled := B;
  migLocal := B;
end;

procedure TMainForm.misSendFile (B: Boolean);
begin
  SendFileButton. Enabled := B;
  Sendfile1. Enabled := B;
  migSendFile := B;
end;

procedure TMainForm.misBugEmu (B: Boolean);
begin
  BugEmuButton. Enabled := B;
  Bugs1. Enabled := B;
  migBugEmu := B;
end;

procedure TMainForm.misChat (B: Boolean);
begin
  ChatButton. Enabled := B;
  Chatwiththeuser1. Enabled := B;
  migChat := B;
end;

procedure TMainForm.misExit (B: Boolean);
begin
  ExitButton. Enabled := B;
  wExitButton. Enabled := B;
  Exit1. Enabled := B;
  Exit2. Enabled := B;
  migExit := B;
end;

procedure TMainForm.misFont (B: Boolean);
begin
  FontButton. Enabled := B;
  Font1. Enabled := B;
  migFont := B;
end;

procedure TMainForm.misLockout (B: Boolean);
begin
  LockoutButton. Enabled := B;
  Lockout1. Enabled := B;
  migLockout := B;
end;

procedure TMainForm.misShowFile (B: Boolean);
begin
  ShowFileButton. Enabled := B;
  Showfile1. Enabled := B;
  migShowFile := B;
end;

procedure TMainForm.misHelp (B: Boolean);
begin
  HelpButton. Enabled := B;
  ProgramKeys1. Enabled := B;
  migHelp := B;
end;

procedure TMainForm.misUserInfo (B: Boolean);
begin
  UserInfoButton. Enabled := B;
  Viewinfo1. Enabled := B;
  migUserInfo := B;
end;

procedure TMainForm.misEditUser (B: Boolean);
begin
  EditUserButton. Enabled := B;
  Editusersparameters1. Enabled := B;
  migEditUser := B;
end;

procedure TMainForm.misSecurity (B: Boolean);
begin
  SecurityButton. Enabled := B;
  Setsecuritylevel1. Enabled := B;
  migSecurity := B;
end;

procedure TMainForm.misTagList (B: Boolean);
begin
  TagListButton. Enabled := B;
  Taggedfiles1. Enabled := B;
  migTagList := B;
end;

procedure TMainForm.misAnswer (B: Boolean);
begin
  AnswerButton. Enabled := B;
  Answer1. Enabled := B;
  migAnswer := B;
end;

procedure TMainForm.misBreak (B: Boolean);
begin
  BreakButton. Enabled := B;
  Break1. Enabled := B;
  migBreak := B;
end;

procedure TMainForm.Showtoolbar1Click(Sender: TObject);
begin
  Showtoolbar1. Checked := Not Showtoolbar1. Checked;
  Showtoolbar2. Checked := Showtoolbar1. Checked;

  If Not Showtoolbar1. Checked Then
  Begin
    PageControl2. Height := 0;
    Height := Height-41;
  End Else
  Begin
    PageControl2. Height := 41;
    Height := Height+41;
  End;
end;

procedure TMainForm.Alignwindow1Click(Sender: TObject);
Var
  H, W : LongInt;

begin
  With Console1 Do
  Begin
    H := FRows * FCharSize. Y + 76;
    If Showtoolbar1. Checked Then Inc (H, 41);
    If Showstatusbar1. Checked Then Inc (H, 42);

    ScrollBarsEnabled := False;
    MainForm. Height := H;
    MainForm. Width := FCols * FCharSize. X + 16;
    SetScrollBars;
  End;
end;

procedure TMainForm.Autoalignwindow1Click(Sender: TObject);
begin
  Autoalignwindow1. Checked := Not Autoalignwindow1. Checked;
  Autoalignwindow2. Checked := Autoalignwindow1. Checked;
  If Autoalignwindow1. Checked Then Alignwindow1Click (nil);
end;

procedure TMainForm.Commandline1Click(Sender: TObject);
begin
  Commandline1. Enabled := False;
  CommandLineForm. Show;
end;

procedure TMainForm.Showstatusbar1Click(Sender: TObject);
begin
  Showstatusbar1. Checked := Not Showstatusbar1. Checked;
  Showstatusbar2. Checked := Showstatusbar1. Checked;

  If Not Showstatusbar1. Checked Then
  Begin
    Panel1. Height := 0;
    Height := Height-42;
  End Else
  Begin
    Panel1. Height := 42;
    Height := Height+42;
  End;
end;

procedure TMainForm.Increasetimeby1min1Click(Sender: TObject);
begin
  IncTime;
end;

procedure TMainForm.Decreasetimeby1min1Click(Sender: TObject);
begin
  DecTime;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  ExitButtonClick (nil);
end;

procedure TMainForm.About1Click(Sender: TObject);
begin
  AboutForm. Show;
end;

procedure TMainForm.Decreasefilesby50KClick(Sender: TObject);
begin
  DecKBLD;
end;

procedure TMainForm.Increasefilesby50KClick(Sender: TObject);
begin
  IncKBLD;
end;

procedure TMainForm.RxTrayIcon1Click(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  AppRestore(Sender);
end;

End.
