{$O+}
Unit tHTML;

Interface

Uses
  HtmlPrim,
{$IFNDEF WIN32}
  Objects,
{$ENDIF}
  DOS,
  tGlob,
  MainComm,
  OpCrt,
  tMisc;

Procedure BrowseHTML (fName: PathStr);

Implementation

Procedure BrowseHTML (fName: PathStr);
Var
  AHTML                                  : PHTML;
  S, S1                                  : String;
  Finished                               : Boolean;
  StartLine, EndLine, CurRef, LineCount  : Integer;
  Ref                                    : PRefItem;

Const
  LastAttr : Char = #0;
  TAttr    : Byte = 7;
  NextChar : Char = ' ';
  LastWord : String = '';
  UpState  : Boolean = False;

Procedure ShowCurRef (Up: Boolean);
Begin
  If Up
  Then Up := Ref^. Line1 >= StartLine
  Else Up := Ref^. Line1 <= EndLine;

  If Not Up Then Exit;

  If Ref^. PfName <> nil Then
    S1 := PString (Ref^. PFName)^
  Else If Ref^. PRefName <> nil Then
    S1 := PString (Ref^. PRefName)^;

  i := Ref^. Line1-StartLine+2;
  If i < 0 Then i := Ref^. Line1+2;

  TAttr := TextAttr;
  GoToXY (1, 23);
  ComWrite (EmuColor ($0A) + S1 + EmuColor (TAttr) + EmuClrEOL, 0);
  GoToXY (Ref^. Pos1, i);
End;

Procedure PrevPage;
Begin
  StartLine := StartLine - R. Lines + 4;
  If StartLine < 0 Then StartLine := 0;

  For i := CurRef DownTo 0 Do
  Begin
    Ref := aHTML^. Refs^. At (i);
    If (Ref^. Line1 >= StartLine) and (Ref^. Line1 <= StartLine+R. Lines-5) Then
    Begin
      CurRef := i;
      Break;
    End;
  End;
  UpState := True;
End;

Procedure NextPage;
Begin
  With aHTML^ Do
  If LineCount < HTMLtext^. Count-2 Then
  Begin
    StartLine := LineCount+1;
    For i := CurRef To Refs^. Count-1 Do
    Begin
      Ref := Refs^. At (i);
      If (Ref^. Line1 >= StartLine) and (Ref^. Line1 <= StartLine+R. Lines-5) Then
      Begin
        CurRef := i;
        Break;
      End;
    End;
  End;
  UpState := False;
End;

Label
  ReReadKey;

Begin
  AHtml := New (PHtml, Init (77, True));

  With AHtml^ Do
  Begin
    If Not InitStream (fName, False) then
    Begin
      Message ('File ' + fName + ' not found.');
      Halt;
    End;

    While FHtml^. Status = stOk Do
    Begin
      S := GetLine;
      S1 := '';

      If Not FirstLine Then Continue;

      For i := 1 To Length (S) Do
      If i mod 2 <> 0 Then NextChar := S [i] Else
      Begin
        If S [i] <> LastAttr Then
        Begin
          Case S [i] Of
             #7 : S1 := S1 + '\07';
             #9 : S1 := S1 + '\09';
            #15 : S1 := S1 + '\15';
          End;
          LastAttr := S [i];
        End;

        S1 := S1 + NextChar;
      End;

      If Length (ZeroMsg (S1, False)) > 79 Then
      Begin
        i := RPos (' ', S1, 79);
        {
        If i = 0 Then i := 79;
        LastWord := Copy (S1, i+1, 255);
        }
        S1 [0] := Chr (i-1);
      End {Else
        LastWord := ''};

      HTMLText^. Insert (NewStr (S1));

      {
      If LastWord <> '' Then HTMLText^. Insert (NewStr (LastWord));
      }
    End;

    StartLine := 0;
    Finished := False;
    LineCount := 0; CurRef := 0;

    While Not Finished Do
    Begin
      EndLine := StartLine+R. Lines-5;
      If EndLine > HTMLtext^. Count-1 Then EndLine := HTMLtext^. Count-1;

      Cls;
      TAttr := TextAttr;

      ComWriteLn ('\10Title: ' + AHTML^. HTMLtitle + ' [' + Long2Str
                 (Trunc (StartLine/(R. Lines-5))+1) + '/' + Long2Str
                 (Round (HTMLtext^. Count/(R. Lines-5))) + ']' + EmuColor
                 (TAttr) + EmuClrEOL, eoCodes);

      For LineCount := StartLine To EndLine Do
      If HTMLtext^. At (LineCount) <> nil
      Then ComWriteLn (PString (HTMLtext^. At (LineCount))^, eoCodes)
      Else ComWriteLn ('', 0);

      TAttr := TextAttr;
      ComWriteLn ('\10Choose XLAT (\15x\10): ' + EmuColor
                 (TAttr) + EmuClrEOL, eoCodes);

      Ref := aHTML^. Refs^. At (CurRef);
      ShowCurRef (UpState);

      ReReadKey:
      Case ComReadKey Of

        ' ' : NextPage;

         #8 : PrevPage;

        '2' : Begin
                If CurRef+1 < Refs^. Count Then Inc (CurRef);
                Ref := aHTML^. Refs^. At (CurRef);

                If Ref^. Line1 <= EndLine Then
                Begin
                  ShowCurRef (False);
                  GoTo ReReadKey;
                End Else
                  NextPage;
              End;

        '8' : Begin
                If CurRef-1 >= 0 Then Dec (CurRef);
                Ref := aHTML^. Refs^. At (CurRef);

                If Ref^. Line1 >= StartLine Then
                Begin
                  ShowCurRef (True);
                  GoTo ReReadKey;
                End Else
                  PrevPage;
              End;

        'q' : Break;
      Else
        GoTo ReReadKey;
      End;

    End;

    DoneStream;
  End;

  Dispose (AHtml, Done);
End;

End.
