unit taglist;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, tGlob,MainComm;

type
  TTagListForm = class(TForm)
    TagList: TListBox;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    TotalFiles: TLabel;
    TotalSize: TLabel;
    ConnectSpeed: TLabel;
    EstimatedTime: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    tglAdd: TButton;
    tglDel: TButton;
    AddFileDialog: TOpenDialog;
    procedure BitBtn1Click(Sender: TObject);
    procedure tglAddClick(Sender: TObject);
    procedure tglDelClick(Sender: TObject);
    Procedure tglOnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TagListForm: TTagListForm;

implementation

uses tor32u;

{$R *.DFM}

Procedure TTagListForm.tglOnClick(Sender: TObject);
begin
if F2Transfer^.Count > 0 then begin
 TagList.Hint:=IntToStr(PTagFileRec(F2Transfer^.At(TagList.ItemIndex))^.Size);
 ShowHint:=true;
 end;
end;

procedure TTagListForm.BitBtn1Click(Sender: TObject);
begin
  MainForm. Console1. ShowCursor;
  MainForm. miTagList := True;
  TagList.ShowHint:=false;
  Close;
end;

procedure TTagListForm.tglAddClick(Sender: TObject);
var s:string;
F:File;
FileRec:TTAgFileRec;

begin
AddFileDialog.Execute;
s:=AddFileDialog.FileName;
if s <>'' then begin
        {$I-}
        AssignFile(F,S);Reset(F,1);
        FileRec.Size:=FileSize(F);
        CloseFile(F);
        TagList.Items.Add(S);
        FileRec.PathName:=s;
        FileRec.FromName:='';
        FileRec.AreaNum:=-10;
        FileRec.GroupNum:=10;
        FileRec.Free:=false;
        F2Transfer^.Insert(NewTagFile(FileRec));
        TotalFiles.Caption:=IntToStr(F2Transfer^.Count);
        Inc(SizeOfAll,FileRec.Size);
        TotalSize. Caption := InttoStr (SizeOfAll);
        end;
end;

procedure TTagListForm.tglDelClick(Sender: TObject);
var F:File;
a:Integer;
begin
 if TagList.Items.Count > 0 then begin
   F2Transfer^.AtDelete(TagList.ItemIndex);
   TagList.Items.Delete(TagList.ItemIndex);
   TotalFiles.Caption:=IntToStr(F2Transfer^.Count);
   SizeOfAll:=0;
   for a:=0 to F2Transfer^.Count-1 do SizeOfAll:=SizeOfAll+PTagFileRec(F2Transfer^.At(a))^.Size;
   TotalSize. Caption := InttoStr (SizeOfAll);
 end;

end;

end.
