{$IFDEF MSDOS}
{$O+,F+}
{$ENDIF}
{$B-,I-}

Unit
  Multi;

Interface

Uses
  tMisc,
  tGlob,
{$IFNDEF WIN32}
  DOS,
{$ELSE}
  SysUtils,
  OpCrt,
  Forms,
{$ENDIF}
  Log,
  Parse,
  Resource;

Procedure InitMultiUnit;

Implementation

Var
  LineFile              : File Of tLine;
  LineRec               : tLine;
  From                  : String;
  Err                   : SysInt;

Function fmL_Init (LineNo: Byte): Boolean;
Var
  tLF           : File Of tLine;
  Present       : Boolean;
  DirInfo       : {$IFNDEF WIN32} SearchRec; {$ELSE} TSearchRec; {$ENDIF}
  F             : File;

Begin
  If LineNo = 0 Then
  Begin
    fmL_Init := True;
    Exit;
  End;

  BbsLine := LineNo;
  Present := False;

  Wait4Flag ('linelist.tbf');
  SetFlag ('linelist.tbf');

  Assign (LineFile, Cnf. FlagsDir + '!llist.tor');
  If FileExists (Cnf. FlagsDir + '!llist.tor') Then ReSet (LineFile) Else ReWrite (LineFile);

  Assign (tLF, Cnf. FlagsDir + '!llist.t$$');
  ReWrite (tLF);

  While Not EoF (LineFile) Do
  Begin
    Read (LineFile, LineRec);
    If UpString (LineRec. UserName) = UpString (R. Name) Then
    Begin
      Present := True;
      Break;
    End;
    Write (tLF, LineRec);
  End;

  If Not Present Then
  Begin
    LineRec. UserName  := R. Name;
    LineRec. Number    := BbsLine;
    LineRec. Logged    := True;
    LineRec. LoginTime := StrTime;

    Write (tLF, LineRec);
    Close (LineFile);
    Erase (LineFile);
    Close (tLF);
    Rename (tLF, Cnf. FlagsDir + '!llist.tor');

  {$IFDEF WIN32}
    DOSerror :=
  {$ENDIF}
    FindFirst (Cnf. FlagsDir + '!msg' + Long2Str (BbsLine) + '.*', AnyFile-Directory{$IFNDEF OS2}-VolumeID{$ENDIF}, DirInfo);

    While DOSerror = 0 Do
    Begin
      tDeleteFile (Cnf. FlagsDir + DirInfo. Name);
    {$IFDEF WIN32}
      DOSerror :=
    {$ENDIF}
      FindNext (DirInfo);
    End;

  {$IFNDEF MSDOS}
    FindClose (DirInfo);
  {$ENDIF}
  End Else
  Begin
    Close (tLF);
    Erase (tLF);
  End;

  fmL_Init := Not Present;
  DelFlag ('linelist.tbf');
  {If Present Then BbsLine := 0;}
End;

Function fmL_MsgWaiting: Boolean;
Begin
  fmL_MsgWaiting := False;
  If BbsLine = 0 Then Exit;
  fmL_MsgWaiting := Not FileExists (Cnf. FlagsDir + '!msg' + Long2Str (BbsLine) + '.*');
End;

Procedure fmL_SendMsg (LineNo: Byte; MsgText: String; MsgType: tMsgType);
Var
  F     : Text;
  i, l  : Byte;
  fN    : PathStr;

Begin
  If BbsLine = 0 Then Exit;

  If MsgType = mtConference Then
  Begin
    Wait4Flag ('trclog.tbf');
    SetFlag ('trclog.tbf');

    Assign (F, Cnf. TRCLog);
    If FileExists (Cnf. TRCLog) Then Append (F) Else ReWrite (F);

    If IOResult = 0 Then
    Begin
      If MsgText [1] <> trcSysMsgPrefix
      Then
        WriteLn (F, ReFormatDate (Long2Date (DateL), DefaultDateMask,
        Cnf. DateMask) + ' ' + Copy (StrTime, 1, 5) + ' [' +
        R. Name + ']: ' + MsgText)
      Else
        WriteLn (F, ReFormatDate (Long2Date (DateL), DefaultDateMask,
        Cnf. DateMask) + ' ' + Copy (StrTime, 1, 5) + ' ' +
        Copy (MsgText, 2, 255));

      Close (F);
    End;

    DelFlag ('trclog.tbf');
  End;

  For l := 1 To 255 Do

  If l <> LineRec. Number Then
  If ((MsgType = mtConference) and CheckFlag
      ('!conf' + Long2Str (l) + '!.tbf') Or
      (MsgType = mtUserMsg))
  Then For i := 1 To 255 Do
  Begin
    If MsgType = mtConference Then
      fN := Cnf. FlagsDir + '!msg' + Long2Str (l) + '.' + Long2Str (i)
    Else
      fN := Cnf. FlagsDir + '!msg' + Long2Str (LineNo) + '.' + Long2Str (i);

    Assign (F, fN);
    ReSet (F);

    If IOResult = 2 Then ReWrite (F) Else
    Begin
      Close (F);
      Continue;
    End;

    Case MsgType Of
      mtUserMsg    : Write (F, 'u;');
      mtConference : Write (F, 'c;');
    End;

    WriteLn (F, Long2Str (BbsLine) + ';' + R. Name);
    WriteLn (F, MsgText);
    Close (F);

    If MsgType = mtUserMsg Then Exit Else Break;
  End;
End;

Function fmL_GetMsg (Var Msg: tMsg; MsgType: tMsgType): Boolean;
Var
  F       : Text;
  S       : String;
  tS      : String [1];
  cT      : Char;
  DirInfo : {$IFNDEF WIN32} SearchRec {$ELSE} TSearchRec {$ENDIF};

Begin
  If BbsLine = 0 Then Exit;
  fmL_GetMsg := False;

{$IFDEF WIN32}
  DOSerror :=
{$ENDIF}
  FindFirst (Cnf. FlagsDir + '!msg' + Long2Str (BbsLine) + '.*', AnyFile-Directory{$IFNDEF OS2}-VolumeID{$ENDIF}, DirInfo);

  While DOSerror = 0 Do
  Begin
    Assign (F, Cnf. FlagsDir + DirInfo. Name);
    ReSet (F);
    If IOResult <> 0 Then Continue;

    ReadLn (F, S);
    tS := ExtractWord (1, S, [';']);
    cT := tS [1];

    If ((cT = 'u') and (MsgType <> mtUserMsg)) Or
       ((cT = 'c') and (MsgType <> mtConference)) Then
    Begin
      Close (F);
    {$IFNDEF MSDOS}
      FindClose (DirInfo);
    {$ENDIF}
      Exit;
    End;

    If Not (cT in ['c', 'u']) Then
    Begin
      Close (F);
      Erase (F);
    {$IFNDEF MSDOS}
      FindClose (DirInfo);
    {$ENDIF}
      Exit;
    End;

    Msg. FromUserName := ExtractWord (3, S, [';']);
    Msg. FromLineNum  := Str2Long (ExtractWord (2, S, [';']));
    ReadLn (F, S);
    Msg. MessageText := S;
    Close (F);
    Erase (F);
    fmL_GetMsg := True;
  {$IFNDEF MSDOS}
    FindClose (DirInfo);
  {$ENDIF}
    Exit;
  End;

{$IFNDEF MSDOS}
  FindClose (DirInfo);
{$ENDIF}
End;

Function fmL_GetUserName (LineNo: Byte): String;
Begin
  If BbsLine = 0 Then Exit;

  Wait4Flag  ('linelist.tbf');
  SetFlag ('linelist.tbf');

  Assign (LineFile, Cnf. FlagsDir + '!llist.tor');
  ReSet (LineFile);
  Read (LineFile, LineRec);
  fmL_GetUserName := LineRec. UserName;
  Close (LineFile);

  DelFlag ('linelist.tbf');
End;

Function fmL_GetMesgStat (LineNo: Byte): Boolean;
Begin
  If BbsLine = 0 Then Exit;
  fmL_GetMesgStat := CheckFlag ('!mena' + Long2Str (LineNo) + '!.tbf');
End;

Procedure fmL_DisableMsg;
Begin
  If BbsLine = 0 Then Exit;
  DelFlag ('!mena' + Long2Str (BbsLine) + '!.tbf');
End;

Procedure fmL_EnableMsg;
Begin
  If BbsLine = 0 Then Exit;
  SetFlag ('!mena' + Long2Str (BbsLine) + '!.tbf');
End;

Procedure fmL_LineMsg;
Var
  Msg   : tMsg;

Begin
  If BbsLine = 0 Then Exit;
  If Not fmL_GetMsg (Msg, mtUserMsg) Then Exit;

  SmartLine;
  ComWriteLn (#7, 0);
  ComWriteLn (lang (lamlMessageFrom) + Msg. FromUserName + ' (' +
  lang (lamlLine) + Long2Str (Msg. FromLineNum) + ')..',
  eoCodes + eoMacro);

  ComWriteLn (Msg. MessageText, 0);
  Message ('');
End;

Procedure fmL_WhoDo (ListMode: tListMode);
Var
  tmpLine       : tLine;
  LineFile      : File Of tLine;

Begin
  If BbsLine = 0 Then Exit;
  If Not InConference Then Cls Else ComWrite (#13 + EmuClrEOL, 0);

  ComWriteLn (lang (laLineStatus), eoMacro + eoCodes);

  ComWriteLn (EmuColor (Cnf. ColorScheme [umSeparator]) +
  '  ',
  eoMacro + eoCodes);

  Wait4Flag ('linelist.tbf');
  SetFlag ('linelist.tbf');

  Assign (LineFile, Cnf. FlagsDir + '!llist.tor');
  ReSet (LineFile);
  If IOResult <> 0 Then Exit;

  While Not EoF (LineFile) Do
  Begin
    Read (LineFile, tmpLine);

    If ((ListMode = lmExcludeCurrent) and (tmpLine. Number = BbsLine)) Or
       ((ListMode = lmConference) and (Not CheckFlag ('!conf' + Long2Str
        (tmpLine. Number) + '!.tbf'))) Then Continue;

    If tmpLine. Logged Then
    ComWriteLn (EmuColor ($0E) + LeftPadCh (Long2Str (tmpLine. Number), ' ', 3) +
    EmuColor ($0F) + '. ' + EmuColor ($0A) + PadCh (tmpLine. UserName, ' ', 36) + ' ' +
    tmpLine. LoginTime, 0);
  End;

  If InConference Then ComWriteLn ('', 0);
  Close (LineFile);
  DelFlag ('linelist.tbf');
End;

Function fmL_ChooseLine: Byte;
Var
  Err           : {$IFNDEF OS2} Integer; {$ELSE} LongInt; {$ENDIF}
  NumLine       : Byte;

Begin
  If BbsLine = 0 Then Exit;
  fmL_WhoDo (lmExcludeCurrent);
  ComWriteLn ('', 0);
  Val (GetAnswer (lang (laLineNumber), 4, ofFramed + ofAllowEmpty, ''), NumLine, Err);
  If (Err <> 0) Or (NumLine = 0) Then fmL_ChooseLine := 0 Else fmL_ChooseLine := NumLine;
End;

Procedure fmL_RealTimeConference;
Var
  S, pMsg       : String;
  cLine         : Byte;

Label
  EoP;

Begin
  If BbsLine = 0 Then Exit;

  fmL_EnableMsg;
  LogWrite ('+', sm (smTRCjoin));
  SetFlag ('!conf' + Long2Str (BbsLine) + '!.tbf');
  InConference := True;

  S := '';
  EmuDispFile ('~trchelp');
  ClearInputHistory;

  fmL_SendMsg (0, trcSysMsgPrefix + '** ' + R. Name + lang (laTRCline) +
  Long2Str (BbsLine) + lang (laTRCjoined), mtConference);

  While True Do
  Begin
    If R. Alias <> '' Then From := R. Alias Else From := R. Name;
    ComWrite (#13, 0);
    If S <> '' Then
    Begin
      fmL_SendMsg (0, S, mtConference);
      ComWrite (#13 + EmuClrEoL, 0);
      ComWriteLn (EmuColor ($0F) + '<' + From + '> ' + EmuColor ($0B) + S, eoCodes);
    End;

    ComWrite (#13 + EmuClrEoL, 0);
    ComWrite (EmuColor ($0B) + '> ' + EmuColor ($0E), 0);
    S := '';
    ComRead (S, 76 - Length (From), ofHistory);

    If S [1] = '/' Then
    Begin
      Case UpCase (S [2]) Of
        'Q' : GoTo EoP;
        'W' : fmL_WhoDo (lmConference);
        'H' : EmuDispFile ('~trchelp');
        'O' : fmL_WhoDo (lmAll);
        'M' : Begin
                Val (ExtractWord (2, S, [' ']), cLine, Err);
                If (cLine = 0) or (err <> 0) or (cLine = BbsLine) Then
                Begin
                  S := '';
                  Continue;
                End Else
                Begin
                  pMsg := Copy (S, Pos (ExtractWord (2, S, [' ']), S) +
                  Length (ExtractWord (2, S, [' '])), 255);

                  If fmL_GetMesgStat (cLine) Then fmL_SendMsg (cLine, pMsg, mtUserMsg);
                  LogWrite ('+', sm (smlSendingMsg) + Long2Str (cLine));
                End;
              End;
      End;
      S := '';
    End;
  End;

  EoP:
  fmL_SendMsg (0, trcSysMsgPrefix + '** ' + R. Name + lang (laTRCline) +
  Long2Str (BbsLine) + lang (laTRCleft), mtConference);

  DelFlag ('!conf' + Long2Str (BbsLine) + '!.tbf');
  LogWrite ('+', sm (smTRCleave));
  InConference := False;
End;

Procedure fmL_Done;
Var
  tLF   : File Of tLine;
  tS    : LongInt;

Begin
  If BbsLine = 0 Then Exit;

  tDeleteFile (Cnf. FlagsDir + '!msg' + Long2Str (LineRec. Number) + '.*');
  tDeleteFile (Cnf. FlagsDir + '!mena' + Long2Str (LineRec. Number) + '!.tbf');
  tDeleteFile (Cnf. FlagsDir + '!conf' + Long2Str (LineRec. Number) + '!.tbf');

  Wait4Flag ('linelist.tbf');
  SetFlag ('linelist.tbf');

  Assign (LineFile, Cnf. FlagsDir + '!llist.tor');
  If FileExists (Cnf. FlagsDir + '!llist.tor') Then ReSet (LineFile) Else ReWrite (LineFile);

  Assign (tLF, Cnf. FlagsDir + '!llist.t$$');
  ReWrite (tLF);

  While Not EoF (LineFile) Do
  Begin
    Read (LineFile, LineRec);
    If LineRec. Number <> BbsLine Then Write (tLF, LineRec);
  End;

  tS := FileSize (tLF);
  Close (LineFile);
  Erase (LineFile);
  Close (tLF);

  If tS > 0 Then Rename (tLF, Cnf. FlagsDir + '!llist.tor') Else Erase (tLF);
  DelFlag ('linelist.tbf');
End;

Procedure InitMultiUnit;
Begin
  mL_Init := fmL_Init;
  mL_MsgWaiting := fmL_MsgWaiting;
  mL_GetMsg := fmL_GetMsg;
  mL_GetUserName := fmL_GetUserName;
  mL_GetMesgStat := fmL_GetMesgStat;
  mL_SendMsg := fmL_SendMsg;
  mL_WhoDo := fmL_WhoDo;
  mL_ChooseLine := fmL_ChooseLine;
  mL_RealTimeConference := fmL_RealTimeConference;
  mL_DisableMsg := fmL_DisableMsg;
  mL_EnableMsg := fmL_EnableMsg;
  mL_LineMsg := fmL_LineMsg;
  mL_Done := fmL_Done;
End;

End.