{$IFDEF MSDOS}
{$O+,F+}
{$ENDIF}
Unit MFind;

Interface

Uses
{$IFNDEF WIN32}
  DOS,
{$ELSE}
  OpCrt,
  SysUtils,
{$ENDIF}
  tMisc;

Type
  mSearchRec = Record
    mfMaskNum, WC : Byte;
    mfAttr        : Word;
    mfMask        : String;
    mfFile        : String [80];
    Name          : PathStr;
    Info          : {$IFNDEF WIN32} SearchRec {$ELSE} TSearchRec {$ENDIF};
  End;

Procedure mFindFirst (Path, Mask: String; Attr: Word; Var F: mSearchRec);
Procedure mFindNext (Var F: mSearchRec);
Procedure mFindDone (Var F: mSearchRec);
Function mFileExist (Path, Mask: String): PathStr;

Implementation

Procedure mFindFirst (Path, Mask: String; Attr: Word; var F: mSearchRec);
Label
  Loop;

Begin
  With F Do
  Begin
    mfMaskNum := 0;
    mfMask := Path;
    mfFile := Mask;
    mfAttr := Attr;
    WC := WordCount (mfMask, [#255]);

    If WC = 0 Then
    Begin
      Name := '';
      DOSerror := 2;
      Exit;
    End;

    Loop:
    Inc (mfMaskNum);
    If mfMaskNum > WC Then Exit;

    Name := AddBackSlash (ExtractWord (mfMaskNum, mfMask, [#255])) + mfFile;

  {$IFDEF WIN32}
    DOSerror :=
  {$ENDIF}
    FindFirst (AddBackSlash (ExtractWord (mfMaskNum, mfMask, [#255])) + mfFile, mfAttr, F. Info);

    Name := AddBackSlash (Trim (ExtractWord (mfMaskNum, mfMask, [#255]))) + F. Info. Name;

    If DOSerror <> 0 Then GoTo Loop;
  End;

End;

Procedure mFindNext (Var F: mSearchRec);
Label
  Loop;

Begin
  {$IFDEF WIN32}
    DOSerror :=
  {$ENDIF}
  FindNext (F. Info);
  F. Name := AddBackSlash (Trim (ExtractWord (F. mfMaskNum,
             F. mfMask, [#255]))) + F. Info. Name;

  If DOSerror <> 0 Then
  With F Do
  Begin
    Loop:
    Inc (mfMaskNum);
    If mfMaskNum > WC Then Exit;
  {$IFDEF WIN32}
    DOSerror :=
  {$ENDIF}
    FindFirst (AddBackSlash (ExtractWord (mfMaskNum, mfMask, [#255])) + mfFile, mfAttr, F. Info);
    Name := AddBackSlash (Trim (ExtractWord (mfMaskNum,
            mfMask, [#255]))) + F. Info. Name;

    If DOSerror <> 0 Then GoTo Loop;
  End;
End;

Procedure mFindDone (Var F: mSearchRec);
Begin
  {$IFDEF OS2}
  FindClose (F. Info);
  {$ENDIF}
End;

Function mFileExist (Path, Mask: String): PathStr;
Var
  SR    : mSearchRec;

Begin
  mFindFirst (Path, Mask, AnyFile{$IFNDEF OS2}-VolumeID{$ENDIF}-Directory, SR);
  If DOSerror = 0 Then mFileExist := SR. Name Else mFileExist := '';
  mFindDone (SR);
End;

End.