{$IFNDEF OS2}
{$O+,F+}
{$ENDIF}
{$I-}

Unit FilesBBS;

Interface

Uses
{$IFDEF OS2}
  Os2Base,
  VPSysLow,
  VPutils,
{$ENDIF}

{$IFNDEF WIN32}
  Objects,
  DOS,
  OpInline,
{$ELSE}
  Classes,
  SysUtils,
  Forms,
  Console,
{$ENDIF}

  TGlob,
  MainComm,
  tMisc,
  tModem,
  Log,
  OpCrt,
  Resource,
  Parse,
  Parser,
  mFind,
  Users;

Type
  MaskType = String [50];
  tIncType = (itNone, Increase);

Var
  Desc                                  : String;
  WildCard                              : String [12];
  Finished, IsNew, FirstStep,
  LastNew, Fin, FinByMore, Warned       : Boolean;
  RightMargin, NumFile, DescMargin      : Byte;
  FilesColl                             : PFileItemCollection;

Const
  NumOfLines = 20;
  NumChar      : Char = '#';
  SpcOrNumChar : Char = '*';
  DefDescript  : String [50] = '';
  GotDLC       : Boolean = False;
  DontShowLong : Boolean = False;
  FindMask     : Word = AnyFile{$IFNDEF OS2}-VolumeID{$ENDIF}-Directory-Hidden;

Function FormDLC (Counter: LongInt; Mask: String): String;
Procedure GetDLC (Var Desc, DLC: String);

Procedure AddDescription (FileList, FileName, Description: String);
Procedure IncFilesBBSCounter (Filename, FileList: PathStr; Mask: MaskType; SpecFormat: Boolean);
Procedure OutFilesBBSString (Filename : String);

Function Tag: Boolean;
Function DispFilesBBS (WCard, Date: String; IsNew1, Raw: Boolean; Var NewFound: Boolean): Boolean;
Function InTagList (S: PathStr): Boolean;
Function IsFree (FileName: String): Boolean;
Function ZeroMask (Mask: String): String;
{ Procedure LBarFileList; }

Procedure ExportDescs;

Implementation

Var
  NextLong, SecurityWarned, SpeedWarned : Boolean;

Function IsFree (FileName: String): Boolean;
Var
  F             : Text;
  S, Sfn        : String;

Begin
  IsFree := False;
  If (Trim (FileName) = '') Or (FileArea. FileList = '') Then Exit;

  Assign (F, FileArea. FileList);
  ReSet (F);
  If IOResult <> 0 Then Exit;

  While Not EoF (F) Do
  Begin
    ReadLn (F, S);
    Sfn := Copy (S, 1, 12);

    If UpString (Trim (Sfn)) = UpString (FileName) Then
    Begin
      If Pos (Cnf. DLFreeKey, Copy (S, 13, 255)) <> 0
         Then IsFree := True;
      Break;
    End;
  End;

  Close (F);
End;

Function InTagList (S: PathStr): Boolean;
Var
  i     : Word;

Begin
  InTagList := False;
  If F2Transfer^. Count > 0 Then
  For i := 0 To F2Transfer^. Count-1 Do
  If Trim (UpString (PTagFileRec (F2Transfer^. At (i))^. PathName)) = Trim (UpString (S))
  Then InTagList := True;
End;

Procedure TagListAdd (Num: Word);
Var
  DirInfo               : {$IFNDEF WIN32} SearchRec {$ELSE} TSearchRec {$ENDIF};
  FileRec               : TTagFileRec;
  FreeFile              : Boolean;
  Temp                  : Word;

Begin
  If (Num <= 0) Or (Num > FilesColl^. Count) Then Exit;

  Temp := pFileItem (FilesColl^. At (Num-1))^. GroupNum;
  If R. FileGroup <> Temp Then SetFileGroup (Temp);
  Temp := pFileItem (FilesColl^. At (Num-1))^. AreaNum;
  If R. FileArea <> Temp Then SetFileArea (Temp);

  If (FileArea. DL_Security > R. Security) Or Not FlagsValid (R. Flags, FileArea. DL_Flags) Then
  Begin
    If Not SecurityWarned Then
    Begin
      ComWrite (#13 + EmuClrEOL +
         JustFileName (PFileItem (FilesColl^. At (Num-1))^. FileName) + ': ', 0);
      ComWriteLn (lang (laSecurityLow), eoMacro+eoCodes);
      SecurityWarned := True;
      Warned := True;
    End;

    Exit;
  End;

  If (FileArea. MinSpeed > GetConnectSpeed) And Not Local Then
  Begin
    If Not SpeedWarned Then
    Begin
      ComWriteLn (#13 + EmuClrEOL + lang (laTooSlow), eoMacro+eoCodes);
      SpeedWarned := True;
      Warned := True;
    End;

    Exit;
  End;

  If FileArea. FListFormat = fFilesBBS Then
  Begin
  {$IFDEF WIN32}
    DOSerror :=
  {$ENDIF}
    FindFirst (pFileItem (FilesColl^. At (Num-1))^. FileName, FindMask, DirInfo);

    If DosError <> 0 Then
    Begin
    {$IFDEF OS2}
      FindClose (DirInfo);
    {$ENDIF}
      Exit;
    End;
  End Else
    DirInfo. Size := pFileItem (FilesColl^. At (Num-1))^. Size;

  FreeFile := IsFree (UpString (JustFileName (PFileItem (FilesColl^. At (Num - 1))^. FileName)));

  If (R. TodayK + Trunc (DirInfo. Size/1024) + Trunc (SizeOfAll/1024) < R. DailySize) Or FreeFile
    Or (Cnf. DontUseDLLimitWhenTagging) Then
  Begin
    If (R. TodayK + Trunc (DirInfo. Size/1024 + SizeOfAll/1024) < Round
       ((GetConnectSpeed/10 * (R. TotalTime - MidSec + EnterTime)) / 1024))
       Or (Cnf. DontUseTimeLimitWhenTagging) Or Local Or FreeFile Then
    Begin
      FileRec. PathName := PFileItem (FilesColl^. At (Num - 1))^. FileName;
      FileRec. AreaNum  := R. FileArea;
      FileRec. GroupNum := R. FileGroup;
      FileRec. Size     := DirInfo. Size;
      FileRec. Free     := FreeFile;
      FileRec. FromName := '';

      If Not InTagList (FileRec. PathName) Then
      Begin
        F2Transfer^. Insert (NewTagFile (FileRec));
        Inc (SizeOfAll, DirInfo. Size);
        LogWrite ('&', 'Added file: "' + FileRec. PathName + '"');
      End;

    End Else
    Begin
      ComWrite (EmuColor ($0E) + Trim (JustFileName (pFileItem
               (FilesColl^. At (Num - 1))^. FileName)) + ': ' , 0);
      ComWriteLn (lang (laDLTimeLimit), eoMacro + eoCodes);
      Warned := True;
    End
  End Else
  Begin
    ComWrite (EmuColor ($0E) + Trim (JustFileName (pFileItem
             (FilesColl^. At (Num - 1))^. FileName)) + ': ' , 0);
    ComWriteLn (lang (laDLLimitExceed), eoMacro + eoCodes);
    Warned := True;
  End;

End;

Function Tag: Boolean;
Var
  i, j                  : Word;
  TagStr                : String;
  TagItem               : String [40];
  oTotalTime, oFileArea : LongInt;

Begin
  oFileArea := R. FileArea;

  Warned := False;
  SpeedWarned := False;
  SecurityWarned := False;
  Tag := True;

  UpdateUserMacro;
  ComWrite (#13, 0);
  ComWrite (EmuClrEOL, 0);
  ComWrite (#13+lang (laTagFilesNum), eoMacro + eoCodes);

  TagStr := '';
  ComRead (TagStr, 78 - Length (ZeroMsg (lang (laTagFilesNum), True)), ofAllowEmpty);
{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}

  If Trim (TagStr) = '' Then
  Begin
    Tag := False;
    Exit;
  End;

  ComWrite (#13, 0);

  If ToEventTime > 0 Then
  Begin
    oTotalTime := R. TotalTime;
    R. TotalTime := ToEventTime*60;
  End;

  LogWrite ('&', 'Tagging files query: ' + TagStr);

  For i := 1 To WordCount (TagStr, [' ', ',']) Do
  Begin
    TagItem := ExtractWord (i, TagStr, [' ', ',']);

    If Not ConsistsOf (TagItem, ['0'..'9', '-']) Then
    Begin
      If FilesColl^. Count > 0 Then
      For j := 0 To FilesColl^. Count-1 Do
      If MatchWildCard (JustFileName (pFileItem (FilesColl^. At (j))^. FileName), TagItem)
      Then TagListAdd (j+1);
      Continue;
    End;

    If Pos ('-', TagItem) = 0 Then
    Begin
      TagListAdd (Str2Long (TagItem));
      Continue;
    End;

    If Pos ('-', TagItem) <> 0 Then
    For j := Str2Long (Copy (TagItem, 1, Pos ('-', TagItem) - 1)) To
             Str2Long (Copy (TagItem, Pos ('-', TagItem)+1, 255))
    Do TagListAdd (j);

  End;

  If ToEventTime > 0 Then R. TotalTime := oTotalTime;
  R. FileArea := oFileArea;
  SetFileArea (0);

  OpenFileAreas;
End;

Function FilesMore (Incr: tIncType): Boolean;
Var
  oAttr, i : Byte;
  S        : String [1];
  S1       : String;

Label
  Loop;

Begin
  FilesMore := True;
  If Not R. More Then Exit;
  If (Not IsNew) And (Incr = Increase) Then Inc (MoreLines);

  If MoreLines < R. Lines Then Exit;

  MoreLines := 1;
  S1 := #13 + lang (laFilesMore);

  If R. Emu <> teTty
  Then S1 := S1+EmuClrEol
  Else S1 := S1+Replicate (' ', 79-Length (ZeroMsg (lang (laFilesMore),
                True)))+Replicate (#8, 79-
                Length (ZeroMsg (lang (laFilesMore), True)));

  oAttr := TextAttr;

  Loop:
  i := MenuBar (S1, lang (laYesNoKeys)+#13'0123456789');
{$IFDEF WIN32}
  If Application. Terminated Then
  Begin
    FilesMore := False;
    Exit;
  End;
{$ENDIF}

  Case i Of
    1, 3  : FilesMore := True;
    2     : FilesMore := False;
    4..13 : Begin
              S := Long2Str (i-4);
              If R. HotKeys Then KeyBufAdd (S [1]) Else HotKeysStr := S [1] + HotKeysStr;
              Tag;
              ComWrite (#13 + EmuClrEOL + EmuColor (oAttr), 0);
              GoTo Loop;
            End;
  End;

  ComWrite (#13, 0);
  ComWrite (EmuClrEOL + EmuColor (oAttr), 0);
  ComWrite (#13, 0);
End;

Function FormDLC (Counter: LongInt; Mask: String): String;
Var
  i, j, MaskLen, MaskPos  : Byte;
  S                       : String [20];

Begin
  For i := 1 To Length (Mask) Do
  If (Mask [i] = '#') Or (Mask [i] = '*') Then
  Begin
    j := i;
    MaskPos := i;
    MaskLen := 0;

    While j <= Length (Mask) Do
    Begin
      If (Mask [j] = '#') Or (Mask [j] = '*') Then Inc (MaskLen) Else Break;
      Inc (j);
    End;

    S := Long2Str (Counter);
    If Length (S) > MaskLen Then S := '0';

    S := LeftPadCh (S, ' ', MaskLen);

    For j := 1 To MaskLen Do
    Begin
      If (Mask [j+MaskPos-1] = '#') And (S [j] = ' ') Then
        Mask [j+MaskPos-1] := '0'
      Else
        Mask [j+MaskPos-1] := S [j];
    End;

    Break;
  End;

  FormDLC := Mask;
End;

Procedure GetDLC (Var Desc, DLC: String);
Var
  Counter                 : LongInt;
  S                       : String [20];
  MaskLen, MaskPos, i, j  : Byte;

Label
  FromCycle;

Begin
  MaskLen := 0;
  MaskPos := 0;
  GotDLC := False;

  For i := 1 To Length (Cnf. DLCountMask) Do
  If (Cnf. DLCountMask [i] = '#') Or
     (Cnf. DLCountMask [i] = '*')
  Then Begin
    j := i;
    MaskPos := i;
    MaskLen := 0;

    While j <= Length (Cnf. DLCountMask) Do
    Begin
      If (Cnf. DLCountMask [j] = '#') Or
         (Cnf. DLCountMask [j] = '*')
      Then
        Inc (MaskLen)
      Else
        GoTo FromCycle;
      Inc (j);
    End;
  End;

  FromCycle:
  S := '';

  If (MaskPos > 1) and (Desc [1] <> Cnf. DLCountMask [1]) Then
  Begin
    DLC := '';
    GotDLC := False;
    Exit;
  End;

  For i := 1 To MaskLen Do
  Begin
    If MaskPos+i-1 > Length (Desc) Then Break;
    S := S + Desc [MaskPos+i-1];
  End;

  S := Trim (S);
  If ConsistsOf (S, ['0'..'9', ' '])
  Then Counter := Str2Long (S)
  Else Counter := 0;

  DLC := FormDLC (Counter, Cnf. DLCountMask);
  GotDLC := Pos (Cnf. DLCountMask [1], Desc) <> 0;

  Delete (Desc, Pos (Cnf. DLCountMask [1], Desc), Pos
         (Cnf. DLCountMask [Length (Cnf. DLCountMask)], Desc)-Pos
         (Cnf. DLCountMask [1], Desc)+1);

  If Desc [1] = ' ' Then Delete (Desc, 1, 1);
End;

Procedure SplitDesc (isOne: Boolean);
Var
  FL             : Array [1..NumOfLines] Of String [70];
  Buf            : String [70];
  i, j, Margin   : Byte;

Begin
  Desc := PlaceSubStr (Desc, Cnf. DLFreeKey, '');

  FillChar (FL, SizeOf (FL), #0);
  J := 1; Buf := '';
  Margin := DescMargin;

  For I := 1 To Length (Desc) Do
  If (Desc [I] = ' ') Or (I = Length (Desc)) Or (i = Margin) Then
  Begin
    If Length (FL [J]) + Length (Buf) + 2 > Margin Then
    Begin
      Inc (J);
      FL [J] := Buf + Desc [I];
      Buf := '';

      If J = 2 Then
      If Cnf. DescUnderDLC Then
        Margin := RightMargin-Length (Cnf. DLCountMask)
      Else
        Margin := RightMargin;

    End Else
    Begin
      FL [J] := FL [J] + Buf + Desc [I];
      Buf := '';
    End;
  End
  Else
    Buf := Buf + Desc [I];

  Margin := 78-Margin;
  If Cnf. DescUnderDLC Then Inc (Margin);

  For i := 1 To j Do
  Begin
    If i = 1 Then
    Begin
      ComWriteLn (FL [1], 0);
      If Not (IsNew Or (WildCard <> '*.*')) Then Inc (MoreLines);
    End;

    If i > 1 Then
    Begin
      ComWriteLn (EmuCursorRight (Margin) + FL [I], 0);
      Inc (MoreLines);
    End;

    If Not isOne Then
    If Not FilesMore (itNone) Then
    Begin
      Finished := True;
      FinByMore := True;
      Fin := True;
      mL_LineMsg;
      Exit;
    End;

    If DrawAborted Then Finished := True;
  End;
End;

Function IsLongDesc (BufStr: String): Boolean;
Var
  Res        : Boolean;

Begin
  Res := False;
  BufStr := TrimTrail (PlaceSubStr (BufStr, #9, '    '));

  If Copy (BufStr, 1, Cnf. LongDescPos) = Replicate (' ', Cnf. LongDescPos) Then
  Begin
    Delete (BufStr, 1, Cnf. LongDescPos);
    BufStr := PlaceSubStr (BufStr, Cnf. DLFreeKey, '');
    Res := True;
  End;

  If Not Res Then
  Begin
    BufStr := Trim (BufStr);
    If BufStr [1] = Cnf. LongDescChar Then
    Begin
      Delete (BufStr, 1, 1);
      BufStr := PlaceSubStr (BufStr, Cnf. DLFreeKey, '');
      Res := True;
    End;
  End;

  IsLongDesc := Res;
End;

(*
Var
  FileEntry : PBigCollection;
  FList     : Text;

Procedure GetNextFile;
Var
  Finished, fNameGot, NextLong : Boolean;
  S, S1, S2, fName, sName      : String;
  DirInfo                      : mSearchRec;

Begin
  Finished := False;
  fNameGot := False;
  ReadLn (FList, S1);

  Repeat
    S := S1;
    ReadLn (FList, S1);
    If IOResult <> 0 Then S1 := '' Else NextLong := IsLongDesc (S1);

    If Not fNameGot Then
    Begin
      If (S [1] = ' ') Or (Trim (S) = '') Then Continue;

      fName := UpString (ExtractWord (1, S, [' ']));
      sName := fName;
      If Length (fName) > 12 Then sName := Copy (sName, 1, 10) + '..';
      Desc := Copy (S, Length (fName)+1, 255);

      If Not ConsistsOf (Copy (Desc, 1, 15-Length (fName)), [' '])
        Then Desc := Trim (Desc)
        Else Desc := Copy (Desc, Cnf. LongDescPos-Length (fName)+1, 255);

      If Cnf. DLFreeKey <> '' Then Desc := PlaceSubStr (Desc, Cnf. DLFreeKey, '');
      DirInfo. Info. Time := 0;

      If FileArea. FListFormat = fFilesBBS Then mFindFirst (FileArea. DLPath, fName, FindMask, DirInfo) Else
      Begin
        S2 := Copy (Desc, 1, Pos (' ', Desc)-1);
        Desc := Trim (Copy (Desc, Pos (' ', Desc), 255));
        DirInfo. Info. Size := Str2Long (S2);
        S2 := Copy (Desc, 1, Pos (' ', Desc)-1);
        Desc := Trim (Copy (Desc, Pos (' ', Desc), 255));
        DirInfo. Info. Time := PackStrTime (S2, Cnf. DateMask);
        DirInfo. Name := FileArea. DLPath + '\' + fName;
        DOSerror := 0;
      End;

      If DOSerror = 0 Then
      Begin
        UnpackTime (DirInfo. Info. Time, FT);

      {$IFDEF OS2}
        If GetDriveType (DirInfo. Name [1]) = dtHDHPFS
        Then FD := GetFileDateCreation (DirInfo. Name) Else
      {$ENDIF}
        Begin
          FD := LeftPadCh (Long2Str (FT. Day), '0', 2) + '-' +
                LeftPadCh (Long2Str (FT. Month), '0', 2) + '-' +
                Copy (Long2Str (FT. Year), 3, 2) + ' ' +
                LeftPadCh (Long2Str (FT. Hour), '0', 2) + ':' +
                LeftPadCh (Long2Str (FT. Min), '0', 2)
      End;

      (*
      If CompareDates (Date, FD) In [0, 1] Then
      Begin
        mFindDone (DirInfo);
        Continue;
      End Else
      If Not NewFound Then
      Begin
        NewFound := True;
        If IsNew Or (WildCard <> '*.*') Then
        Begin
          Inc (MoreLines, 2);
          ComWriteLn (#13#10, 0);
        End;

        If Not FilesMore (itNone) Then
        Begin
        {$IFDEF WIN32}
          If Application. Terminated Then Exit;
        {$ENDIF}
          mL_LineMsg;
          Finished := True;
          Fin := True;
          FinByMore := True;
          GoTo SkipLine;
        End;
      End;
      *)(*

      Str (DirInfo. Info. Size: 8, S);

      ComWrite (EmuColor (Cnf. ColorScheme [flTagNum]) +
        LeftPadCh (Long2Str (NumFile),'0', 2) + ' ' +
        EmuColor (Cnf. ColorScheme [flFileName]) +
        PadCh (sName, ' ', 12) + ' ', 0);

      If Cnf. FAShowSize Then
        ComWrite (EmuColor (Cnf. ColorScheme [flSize]) +
        OutStr + ' ', 0);

      With FileItem Do
      Begin
        FileName := DirInfo. Name;
        AreaNum := R. FileArea;
        GroupNum := R. FileGroup;
        Size := DirInfo. Info. Size;
      End;

      If FileArea. FListFormat = fFilesBBS Then mFindDone (DirInfo);

      If FirstStep
      Then FilesColl^. Insert (NewFileItem (FileItem))
      Else FilesColl^. AtPut (NumFile - 1, NewFileItem (FileItem));

      Inc (NumFile); Str (FT. Year, OutStr);

      If Cnf. FAShowDate Then
      ComWrite (EmuColor (Cnf. ColorScheme [flDate]) + ReFormatDate (LeftPadCh
               (Long2Str (FT. Month), '0', 2) + '-' + LeftPadCh (Long2Str
               (FT. Day), '0', 2) + '-' + OutStr, 'MM-DD-YYYY',
               Cnf. DateMask) + ' ', 0);
    End Else
    Begin
      PrevIsFile := True;

      If Cnf. FAShowMissing And (Not IsNew) Then
      Begin
        SomeShowed := True;
        ComWrite ('   ' + EmuColor (Cnf. ColorScheme [flFileName]) + PadCh
                 (sName, ' ', 12), 0);

        If Cnf. FAShowDate and Cnf. FAShowSize Then i := Length (Cnf. DateMask) + 13 Else
        If Cnf. FAShowDate and not Cnf. FAShowSize Then i := Length (Cnf. DateMask) + 4 Else
        If Cnf. FAShowSize and not Cnf. FAShowDate Then i := 12 Else i := 0;

        If i > 0 Then ComWrite (CenterCh (Copy (lang (laMissing), 1, i), ' ', i) + ' ', eoMacro + eoCodes);
      End Else
      Begin
        DontShowLong := True;
        GoTo SkipLine;
      End;
    End;

      fNameGot := True;
    End Else
    If NextLong Then
    Begin

    End Else
    Begin

    End;

  Until Finished;

End;

Procedure LBarFileList;
Var
  S     : String;

Begin
  FileEntry := New (PBigCollection, Init (10, 10));
  Assign (FList, FileArea. FileList);
  Reset (FList);

  While Not Finished Do
  Begin
    Cls;
    ComWriteLn ('\14+-----------------------------------------------------------------------------+', eoCodes);
    ComWriteLn ('1 Filename     Size     Date     Description                                  1', eoCodes);
    ComWriteLn ('+-----------------------------------------------------------------------------+', eoCodes);

    While (WhereY < 22) And Not EoF (FList) Do
    Begin
      GetNextFile;
    End;
  End;

  Close (FList);
  Dispose (FileEntry, Done);
End;
*)

Function DispFilesBBS;
Var
  F                             : Text;
  OutStr, BufStr, tBufStr, DLC,
  BufStr1, ttBufStr, LastWord,
  S                             : String;
  fName                         : String [80];
  sName                         : String [12];
  FD                            : String [20];
  DirInfo, Catalogue            : mSearchRec;
  FT                            : DateTime;
  i                             : Byte;
  PrevIsFile,
  ShowRaw, SomeShowed, LongDesc : Boolean;
  FileItem                      : tFileItem;
  it                            : tIncType;

Label
  SkipLine,
  Loop,
  Raw_Next;

Begin
  IsNew := IsNew1;

  If (Not IsNew) Or (IsNew and (Not LastNew)) Then
  Begin
    FirstStep := True;
    NumFile := 1;
  End;

  LastNew := IsNew;
  DispFilesBBS := True;
  ShowRaw := False;
  Fin := False;
  SomeShowed := False;
  PrevIsFile := False;

  RightMargin := 42;
  If Length (Cnf. DateMask) = 8 Then Inc (RightMargin, 2);
  If Not Cnf. FAShowSize Then Inc (RightMargin, 9);
  If Not Cnf. FAShowDLC  Then Inc (RightMargin, Length (Cnf. DLCountMask)+1);
  If Not Cnf. FAShowDate Then Inc (RightMargin, Length (Cnf. DateMask)+1);

  If Length (Cnf. DLCountMask) > 0
  Then DescMargin := RightMargin-Length (Cnf. DLCountMask)
  Else DescMargin := RightMargin+1;

  NewFound := False;
  FinByMore := False;
  WildCard := WCard;

  If Not Raw Then
  If FileArea. FileList <> '' Then
  Begin
    Assign (F, FileArea. FileList);
    Reset (F);
    ReadLn (F, BufStr1);
    Raw := Raw Or (IOResult <> 0);
    BufStr1 := PlaceSubStr (BufStr1, #9, '    ');
  End Else
    Raw := True;

  Finished := False;
  If (Not IsNew) and (IOResult <> 0) Or (FileArea. FileList = '') Or Raw Then ShowRaw := True;
  If (Not IsNew) and (WildCard = '*.*') Then Cls;

  If ShowRaw Then
  Begin
    mFindFirst (FileArea. DLPath, WildCard, FindMask, Catalogue);
    If DOSError <> 0 Then
    Begin
      mFindDone (Catalogue);
      If (Not IsNew) And (WildCard = '*.*') Then Message (lang (laEmptyFArea));
      Exit;
    End;
  End;

  If (Not IsNew) and (WildCard = '*.*') {and (Date = '')} Then
  Begin
    FilesColl := New (PFileItemCollection, Init (100, 1));
    InitMore (0);
  End;

  ttBufStr := '';
  While Not Fin Do
  Begin
    If Not ShowRaw Then
    Begin
      BufStr := BufStr1;
      ReadLn (F, BufStr1);
      If IOResult <> 0 Then BufStr1 := '' Else NextLong := IsLongDesc (BufStr1);

      Loop:
      If (Trim (BufStr) = '') And (Not IsNew) Then
      Begin
        ComWriteLn ('', 0);
        it := Increase;
        PrevIsFile := False;
        Goto SkipLine;
      End;

      If PrevIsFile then
      Begin
        LongDesc := False;

        tBufStr := PlaceSubStr (BufStr, #9, '    ');
        If Copy (tBufStr, 1, Cnf. LongDescPos) = Replicate (' ', Cnf. LongDescPos) Then
        Begin
          Delete (tBufStr, 1, Cnf. LongDescPos);
          tBufStr := PlaceSubStr (tBufStr, Cnf. DLFreeKey, '');
          LongDesc := True;
        End;

        If Not LongDesc Then
        Begin
          tBufStr := Trim (BufStr);
          If tBufStr [1] = Cnf. LongDescChar Then
          Begin
            Delete (tBufStr, 1, 1);
            tBufStr := PlaceSubStr (tBufStr, Cnf. DLFreeKey, '');
            If Cnf. FAShowDLC Then Insert (Replicate (' ', Length (DLC)+1), tBufStr, 1);
            LongDesc := True;
          End;
        End;

        If LongDesc And DontShowLong Then
        Begin
          it := itNone;
          GoTo SkipLine;
        End;

        If LongDesc Then
        Begin
          If Cnf. DLCount Then
          If ((Copy (tBufStr, 1, Length (Cnf. DLCountMask)) <>
             Replicate (' ', Length (Cnf. DLCountMask))) And
             (Not Cnf. FAShowDLC)) Or ((Not GotDLC) and Cnf. FAShowDLC)
          Then
            tBufStr := Replicate (' ', Length (Cnf. DLCountMask)+1) + tBufStr;

          While Length (tBufStr) > 0 Do
          Begin
            If Cnf. DLCount And (Length (Cnf. DLCountMask) > 0)
            Then
              i := RightMargin-Length (Cnf. DLCountMask)+5
            Else
              i := RightMargin-6;

            ComWriteLn (EmuCursorRight (78-i) + SplitString (tBufStr, i), 0);
            If ((Length (tBufStr) < RightMargin) Or Cnf. CutLongDescs) And Not IsNew Then it := itNone Else it := Increase;
            If (IsNew or (WildCard <> '*.*')) {And (it = Increase)} Then Inc (MoreLines);

            If Not FilesMore (it) Then
            Begin
            {$IFDEF WIN32}
              If Application. Terminated Then Exit;
            {$ENDIF}
              mL_LineMsg;
              Finished := True;
              Fin := True;
              FinByMore := True;
              GoTo SkipLine;
            End;

            If DrawAborted Then Finished := True;
            If Cnf. CutLongDescs Then tBufStr := '';
          End;

          it := Increase;
          Goto SkipLine;
        End;
      End;

      If Not (IsNew or (WildCard <> '*.*')) Then
      If (BufStr [1] = ' ') Or (BufStr = '') Then
      Begin
        If (BufStr [1] = ' ') Then
        ComWrite (EmuColor (Cnf. ColorScheme [flComments]), 0);
        ComWriteLn (BufStr, 0);
        Goto SkipLine;
      End;

    End Else

    If Catalogue. Info. Attr and Directory = 0
    Then
      BufStr := PadCh (Catalogue. Info. Name, ' ', 15)
    Else
      GoTo Raw_Next;

    PrevIsFile := False;
    it := Increase;

    If ((BufStr [1] = ' ') Or (Trim (BufStr) = '')) And
       ((WildCard <> '*.*') Or (IsNew))
    Then GoTo SkipLine;

    fName := UpString (ExtractWord (1, BufStr, [' ']));
    sName := fName;
    If Length (fName) > 12 Then sName := Copy (sName, 1, 10) + '..';

    If (Not MatchMultiCard (fName, WildCard)) Or IsDevice (fName) Then GoTo SkipLine;

    Desc := Copy (BufStr, Length (fName)+1, 255);

    If Not ConsistsOf (Copy (Desc, 1, 15-Length (fName)), [' '])
    Then
      Desc := Trim (Desc)
    Else
      Desc := Copy (Desc, Cnf. LongDescPos-Length (fName)+1, 255);

    If Cnf. DLFreeKey <> '' Then Desc := PlaceSubStr (Desc, Cnf. DLFreeKey, '');
    DirInfo. Info. Time := 0;

    If FileArea. FListFormat = fFilesBBS Then mFindFirst (FileArea. DLPath, fName, FindMask, DirInfo) Else
    Begin
      S := Copy (Desc, 1, Pos (' ', Desc)-1);
      Desc := Trim (Copy (Desc, Pos (' ', Desc), 255));
      DirInfo. Info. Size := Str2Long (S);
      S := Copy (Desc, 1, Pos (' ', Desc)-1);
      Desc := Trim (Copy (Desc, Pos (' ', Desc), 255));
      DirInfo. Info. Time := PackStrTime (S, Cnf. DateMask);
      DirInfo. Name := FileArea. DLPath + '\' + fName;
      DOSerror := 0;
    End;

    If DOSerror = 0 Then
    Begin
      UnpackTime (DirInfo. Info. Time, FT);

    {$IFDEF OS2}
      If GetDriveType (DirInfo. Name [1]) = dtHDHPFS
      Then FD := GetFileDateCreation (DirInfo. Name) Else
    {$ENDIF}
      Begin
        FD := LeftPadCh (Long2Str (FT. Day), '0', 2) + '-' +
        LeftPadCh (Long2Str (FT. Month), '0', 2) + '-' + Long2Str (FT. Year) + ' ' +
        LeftPadCh (Long2Str (FT. Hour), '0', 2) + ':' +
        LeftPadCh (Long2Str (FT. Min), '0', 2)
      End;

      If CompareDates (Date, FD) In [0, 1] Then
      Begin
        mFindDone (DirInfo);
        GoTo SkipLine;
      End Else
      If Not NewFound Then
      Begin
        NewFound := True;

        If IsNew Or (WildCard <> '*.*') Then
        Begin
          Inc (MoreLines, 2);
          ComWriteLn (#13#10, 0);
        End;

        If Not FilesMore (itNone) Then
        Begin
        {$IFDEF WIN32}
          If Application. Terminated Then Exit;
        {$ENDIF}
          mL_LineMsg;
          Finished := True;
          Fin := True;
          FinByMore := True;
          GoTo SkipLine;
        End;
      End;

      SomeShowed := True;
      PrevIsFile := True;
      DontShowLong := False;

      Str (DirInfo. Info. Size: 8, OutStr);

      If NumFile >= 100 Then
      Begin
        NumFile := 1;
        FirstStep := False;
      End;

      ComWrite (EmuColor (Cnf. ColorScheme [flTagNum]) +
        LeftPadCh (Long2Str (NumFile),'0', 2) + ' ' +
        EmuColor (Cnf. ColorScheme [flFileName]) +
        PadCh (sName, ' ', 12) + ' ', 0);

      If Cnf. FAShowSize Then
        ComWrite (EmuColor (Cnf. ColorScheme [flSize]) +
        OutStr + ' ', 0);

      With FileItem Do
      Begin
        FileName := DirInfo. Name;
        AreaNum := R. FileArea;
        GroupNum := R. FileGroup;
        Size := DirInfo. Info. Size;
      End;

      If FileArea. FListFormat = fFilesBBS Then mFindDone (DirInfo);

      If FirstStep
      Then FilesColl^. Insert (NewFileItem (FileItem))
      Else FilesColl^. AtPut (NumFile - 1, NewFileItem (FileItem));

      Inc (NumFile); Str (FT. Year, OutStr);

      If Cnf. FAShowDate Then
      ComWrite (EmuColor (Cnf. ColorScheme [flDate]) + ReFormatDate (LeftPadCh
               (Long2Str (FT. Month), '0', 2) + '-' + LeftPadCh (Long2Str
               (FT. Day), '0', 2) + '-' + LeftPadCh (Long2Str (FT. Year), '0', 4), 'MM-DD-YYYY',
               Cnf. DateMask) + ' ', 0);
    End Else
    Begin
      PrevIsFile := True;

      If Cnf. FAShowMissing And (Not IsNew) Then
      Begin
        SomeShowed := True;
        ComWrite ('   ' + EmuColor (Cnf. ColorScheme [flFileName]) + PadCh
                 (sName, ' ', 12), 0);

        If Cnf. FAShowDate and Cnf. FAShowSize Then i := Length (Cnf. DateMask) + 13 Else
        If Cnf. FAShowDate and not Cnf. FAShowSize Then i := Length (Cnf. DateMask) + 4 Else
        If Cnf. FAShowSize and not Cnf. FAShowDate Then i := 12 Else i := 0;

        If i > 0 Then ComWrite (CenterCh (Copy (lang (laMissing), 1, i), ' ', i) + ' ', eoMacro + eoCodes);
      End Else
      Begin
        DontShowLong := True;
        GoTo SkipLine;
      End;
    End;

    If Cnf. DLCount Then
    Begin
      GetDLC (Desc, DLC);
      If DLC = '' Then DLC := ZeroMask (Cnf. DLCountMask);

      If Cnf. FAShowDLC Then
        ComWrite (EmuColor (Cnf. ColorScheme [flDLC]) + DLC + ' ', 0);
    End;

    ComWrite (EmuColor (Cnf. ColorScheme [flDesc]), 0);

    If IsNew or (WildCard <> '*.*') Then Inc (MoreLines);

    If (Length (Desc) <= DescMargin) Or
       (Cnf. CutLongDescs And NextLong) Or
        Cnf. CutDescs Then
    Begin
      Desc := Copy (Desc, 1, DescMargin);
      ComWriteLn (Desc, 0);
      it := Increase;
    End Else
    Begin
      SplitDesc (False);
    {$IFDEF WIN32}
      If Application. Terminated Then Exit;
    {$ENDIF}
      it := itNone;
    End;

    If DrawAborted Then Finished := True;

    SkipLine:
    If Finished Then Break;

    If Not FilesMore (it) Then
    Begin
    {$IFDEF WIN32}
      If Application. Terminated Then Exit;
    {$ENDIF}
      mL_LineMsg;
      Finished := True;
      Fin := True;
      FinByMore := True;
    End;

 {$IFDEF WIN32}
    If Application. Terminated Then Exit;
 {$ENDIF}

    If ShowRaw Then
    Begin
      Raw_Next:
      mFindNext (Catalogue);
      Fin := (DOSError <> 0)
    End Else
      If Not Fin Then
      If Eof (F) Then
      Begin
        Fin := True;
        If BufStr1 <> '' Then
        Begin
          BufStr := BufStr1;
          GoTo Loop;
        End;
      End;
  End;

  If Not ShowRaw Then Close (F);
  If (Not IsNew) and (WildCard = '*.*') Then
  Begin
    ComWriteLn ('', 0);

    If SomeShowed Then
    Begin
      If Not FinByMore Then
      Begin
        Tag;
        If Warned Then Message ('');
      End;
    End Else
      Message (lang (laEmptyFArea));

{    FilesColl^. DeleteAll;}
    Dispose (FilesColl, Done);
  End;

  If NewFound Then ComWriteLn ('', 0);

  mFindDone (Catalogue);

  If Finished Then DispFilesBBS := False
              Else DispFilesBBS := True;

End;

Procedure OutFilesBBSString (FileName : String);
Var
  F                       : Text;
  OutStr, BufStr, tBufStr,
  DLC                     : String;
  fName                   : String [80];
  sName                   : String [12];
  DirInfo                 : mSearchRec;
  FT                      : DateTime;
  NoFilesBBS, NextLong,
  Terminate, oEoF         : Boolean;
  i                       : Byte;

Label
  OutLongDesc,
  Loop;

Begin
  NextLong := False;
  Terminate := False;
  oEoF := False;

  RightMargin := 45;
  If Length (Cnf. DateMask) = 8 Then Inc (RightMargin, 2);
  If Not Cnf. FAShowSize Then Inc (RightMargin, 9);
  If Not Cnf. FAShowDate Then Inc (RightMargin, Length (Cnf. DateMask)+1);
  If Not Cnf. FAShowDLC  Then Inc (RightMargin, Length (Cnf. DLCountMask)+1);

  If Length (Cnf. DLCountMask) > 0
  Then DescMargin := RightMargin-Length (Cnf. DLCountMask)
  Else DescMargin := RightMargin+1;

  Assign (F, FileArea. FileList);
  Reset (F);
  NoFilesBBS := (IOResult <> 0);
  If Not EoF (F) Then ReadLn (F, BufStr);

  Repeat
    If Not NoFilesBBS And Not EoF (F) Then
    Begin
      ReadLn (F, tBufStr);
      Loop: fName := PadCh (ExtractWord (1, BufStr, [' ']), ' ', 12);
    End Else
      fName := FileName;

    sName := fName;
    If Length (fName) > 12 Then sName := Copy (sName, 1, 10) + '..';

    If NextLong Then
    Begin
      NextLong := IsLongDesc (tBufStr);

      If Length (Cnf. DLCountMask) > 0
      Then i := RightMargin-Length (Cnf. DLCountMask)+5
      Else i := RightMargin-1;

      If BufStr [1] <> Cnf. LongDescChar Then
        Delete (BufStr, 1, Cnf. LongDescPos)
      Else Begin
        Delete (BufStr, 1, 1);
        If Cnf. FAShowDLC Then Insert (Replicate (' ', Length (DLC)+1), BufStr, 1);
      End;

      BufStr := PlaceSubStr (BufStr, Cnf. DLFreeKey, '');
      ComWriteLn (EmuCursorRight (78-i) + SplitString (BufStr, i), 0);
      GoTo OutLongDesc;
    End;

    If (Not NoFilesBBS) And ((BufStr [1] = #32) Or
       (Length (BufStr) = 0) Or
       (UpString (FileName) <> UpString (Trim (fName)))) Then
    Begin
      BufStr := tBufStr;
      If EoF (F) And (Not Terminate) Then
      Begin
        Terminate := True;
        GoTo Loop;
      End Else
        Continue;
    End;

    Desc := Trim (Copy (BufStr, Length (fName)+1, 255));
    NextLong := IsLongDesc (tBufStr);
    If Cnf. DLFreeKey <> '' Then Desc := PlaceSubStr (Desc, Cnf. DLFreeKey, '');
    DirInfo. Info. Time := 0;
    mFindFirst (FileArea. DLPath, fName, FindMask, DirInfo);

    If DirInfo. Info. Time <> 0 Then
    Begin
      UnpackTime (DirInfo. Info. Time, FT);
      ComWrite (EmuColor (Cnf. ColorScheme [flFileName]) + sName + ' ', 0);
      If Cnf. FAShowSize Then
      Begin
        Str (DirInfo. Info. Size: 8, OutStr);
        ComWrite (EmuColor(Cnf. ColorScheme [flSize]) + OutStr + ' ', 0);
      End;

      If Cnf. FAShowDate Then
      Begin
        Str (FT. Year, OutStr);
        ComWrite (EmuColor (Cnf. ColorScheme [flDate]) + ReFormatDate (LeftPadCh
                 (Long2Str (FT. Month), '0', 2) + '-' + LeftPadCh (Long2Str
                 (FT. Day), '0', 2) + '-' + LeftPadCh (Long2Str(FT. Year), '0', 4), 'MM-DD-YYYY',
                 Cnf. DateMask) + ' ', 0);
      End;
    End Else

    If Cnf. FAShowMissing Then
    If Cnf. FAShowDate
    Then ComWrite (EmuColor (Cnf. ColorScheme [flFileName]) + PadCh
                  (sName, ' ', 12) + CenterCh (lang (laMissing), ' ', 14 + Length
                  (Cnf. DateMask)), 0);

    mFindDone (DirInfo);

    If Not NoFilesBBS Then
    Begin
      GetDLC (Desc, DLC);

      If Cnf. FAShowDLC
      Then ComWrite (EmuColor (Cnf. ColorScheme [flDLC]) + DLC + ' ', 0);
      ComWrite (EmuColor (Cnf. ColorScheme [flDesc]), 0);

      If (Length (Desc) <= DescMargin) Or
         (Cnf. CutLongDescs And NextLong) Or
          Cnf. CutDescs Then
      Begin
        Desc := Copy (Desc, 1, DescMargin);
        ComWriteLn (Desc, 0);
      End Else
        SplitDesc (True);
    End;

    OutLongDesc:
    If NextLong Then
    Begin
      BufStr := tBufStr;
      If oEoF and EoF (F) Then Break;
      oEoF := EoF (F);
      Continue;
    End;

    If DrawAborted Or Not NoFilesBBS Then Break;
  Until False;

  If Not NoFilesBBS Then Close (F);
End;

Function ZeroMask (Mask: String): String;
Var
  R : byte;

Begin
  For R := 1 To Length (Mask) Do
  begin
    if Mask [R] = NumChar      then  Mask [R] := '0';
    if Mask [R] = SpcOrNumChar then  Mask [R] := ' ';
  end;
  ZeroMask := Mask;
End;

Procedure AddDescription (FileList, FileName, Description: String);
Var
  T     : Text;
  F     : File of Byte;
  C     : Byte;
  IsCR  : Boolean;

Begin
  IsCR := True;
  C := 255;

  Assign (F, FileList);
  Reset (F);

  If (IOResult = 0) and (FileSize (F) <> 0) Then
  Begin
    Seek (F, FileSize (F)-1);
    Read (F, C);
    IsCR := C in [13, 10];
    Close (F);

    Assign (T, FileList);
    Reset (T);
    Append (T);
  End Else
  Begin
    Assign (T, FileList);
    ReWrite (T);
  End;

  If Not IsCR Then WriteLn (T);
  Write (T, PadCh (FileName, ' ', 13) + Description);
  Close (T);
End;

Procedure IncFilesBBSCounter;
Var
  FiLi, FiOu    : Text;
  Desc          : String [242];
  Counter       : Integer;
  R             : {$IFNDEF OS2} Integer; {$ELSE} LongInt; {$ENDIF}
  S             : MaskType;
  T1, ZM,
  BufStr        : String;
  Counted       : Boolean;
  DescPos       : Byte;

Label
  SkipLine, Proceed;

Procedure IncBufStr; { 稢 祭 稪  ப BufStr }
Var
  I, PosS       : Byte;
  Fl, Fl1, F    : Boolean;
  S1            : String;

Label
  Cont;

Begin
  {If DescPos = 1 Then DescPos := Length (T1)+2;
  DescPos := Pos (ExtractWord (2, BufStr, [' ']), BufStr);}

  S := ''; S1 := ''; PosS := 0;
  F := (Mask [1] = NumChar) or (Mask [1] = SpcOrNumChar);
  Fl := F;
  If Not F Then S1 := S1 + BufStr [DescPos];
  Fl1 := False;

  For i := 2 To Length (Mask) Do
  Begin
    F := (Mask [i] = NumChar) Or (Mask [i] = SpcOrNumChar);
    Fl1 := Fl And (Not F) Or Fl1;
    Fl := F;
    If F And Not Fl1 Then
    Begin
      If PosS = 0 Then PosS := i;
      S  := S  + BufStr [DescPos+i-1];
      S1 := S1 + Mask [I];
    End Else
      S1 := S1 + BufStr [DescPos+i-1];
  End;

  { ᫨ BufStr=...'[000]'  Mask='[***]',  S='000'  S1='[***]' }

  I := Length (S);
  Val (S, Counter, R);
  Inc (Counter);
  Str (Counter, S);
  S := LeftPad (S, I);

  {If i < Length (S) Then Delete (S, 1, 1); { Inc(999, '[###]' = '[000]'}
  S := FormDLC (Counter, Mask);
  Delete (BufStr, DescPos, Length (Mask));
  Insert (S, BufStr, DescPos);

  {
  For i := 1 To Byte (S [0]) Do
   If Mask [PosS+I-1] = NumChar Then
    If S [i] = ' ' Then S [I] := '0';

  For i := 1 To Byte (S [0]) Do
   BufStr [PosS+DescPos-2+I] := S [I];
  }
End;

Var
  TempFBBSName : PathStr;

Begin
  { ஢ਬ  稥 files.bbs.   - ᮧ                      }
  { 䮫⮢묨 ᠭﬨ.    ᠭ :)                         }

  FileName := Trim (FileName);
  If (FileName = '') Or (FileList = '') Then Exit;

  Assign (FiLi, FileList);
  ReSet (FiLi);

  If IOResult <> 0 Then
  Begin
    LogWrite ('!',  sm (smFile) + FileList + sm (smNotFound));
    Exit;
  End;

  TempFBBSName := DelChars ([':'], StrTime) + '.' + LeftPadCh (Long2Str (Random (999)), '0', 3);

  Assign (FiOu, Cnf. TempDir + TempFBBSName);
  ReWrite (FiOu);

  If IOResult <> 0 Then
  Begin
    Close (FiLi);
    Exit;
  End;

  While Not EoF (FiLi) Do
  Begin
    ReadLn (FiLi, BufStr);
    R := Pos (' ', BufStr);
    If R <> 0 Then T1 := Copy (BufStr, 1, Pos (' ', BufStr) - 1) Else T1 := BufStr;
    If (BufStr [1] = #32) Or (Length (BufStr) = 0) Or (UpString (T1) <> UpString (Filename)) Then Goto SkipLine;

    S := '';
    If SpecFormat Then
      DescPos := WordPosition (4, BufStr, [' '])
    Else
      DescPos := Pos (' ', BufStr)+1;

    If DescPos=1 then
    Begin
      Desc := '';
      Counted := False;
    End Else
    Begin
      Desc := Copy (BufStr, DescPos, 255);
      Counted := True;
      While Desc [1] in [#0..#32] Do
      Begin
        Inc (DescPos);
        Delete (Desc, 1, 1);
      End;
    End;

    For R := 1 To Byte (Mask [0]) Do
    If Counted Then
    If (Mask [R] = NumChar) or (Mask [R] = SpcOrNumChar) Then
    Begin
      If Not (Desc [R] In [' ', '0'..'9']) Then Counted := False;
    End Else
      If Not (Desc [R] = Mask [R]) Then Counted := False;

    If Counted Then Goto Proceed;
    ZM := ' ' + ZeroMask(Mask);
    If Byte (Desc [0]) = 0 Then BufStr := T1 + ZM Else BufStr := T1 + ZM + ' ' + Desc;
    Desc := Copy (ZM, 2, 255) + ' ' + Desc;

    Proceed:
    IncBufStr;

    SkipLine:
    WriteLn (FiOu, BufStr);
  End;

  Close (FiLi);
  Close (FiOu);
{$IFNDEF WIN32}
  SetFAttr (FiLi, Archive);
{$ELSE}
  Try FileSetAttr (GetStr (UpFiles. At (i)), faArchive);
  Except
  End;
{$ENDIF}

  Erase (FiLi);
  DOSerror := IOResult;

  tRenameFile (Cnf. TempDir + TempFBBSName, FileList);
End;

Procedure ExportDescs;
Procedure CopyDescription (FileList, FileName: PathStr);
Var
  Out, FList    : Text;
  S, S1         : String;

Begin
  Assign (FList, FileList);
  ReSet (FList);
  If IOResult <> 0 Then Exit;

  Assign (Out, Cnf. DoorInfoDir + 'file_id.1');
  If FileExists (Cnf. DoorInfoDir + 'file_id.1') Then Append (Out) Else ReWrite (Out);

  While Not EoF (FList) Do
  Begin
    ReadLn (FList, S);
    S1 := Trim (UpString (ExtractWord (1, S, [' '])));

    If S1 = UpString (FileName) Then
    Begin
      If FileArea. FListFormat = fCDList Then
        Delete (S, Length (S1)+2, WordPosition (4, S, [' '])-
        Length (S1)-2);

      WriteLn (Out, S);
      ReadLn (FList, S);

      While ((S [1] = Cnf. LongDescChar) Or
            (Copy (S, 1, Cnf. LongDescPos) = Replicate
            (' ', Cnf. LongDescPos))) And
            Not EoF (FList) Do
      Begin
        WriteLn (Out, S);
        ReadLn (FList, S);
      End;

      Break;
    End;

  End;

  Close (FList);
  Close (Out);
End;

Var
  k          : Integer;
  FileRec    : TTagFileRec;
  oFArea, i  : Word;

Begin
  If AutoDL or (F2Transfer^. Count = 0) Then Exit;
  Case Cnf. DLDescs Of
    atNo  : Exit;
    atAsk : If Not Query (lang (laDownLoadDescs), True, ofFramed) Then Exit;
  End;

  k := -1;
  oFArea := R. FileArea;

  For i := 0 To F2Transfer^. Count-1 Do
  Begin
    If PTagFileRec (F2Transfer^. At (i))^. AreaNum <> k Then
    Begin
      k := PTagFileRec (F2Transfer^. At (i))^. AreaNum;
      SetFileArea (k);
    End;

    If k > 0 Then
      CopyDescription (FileArea. FileList, Trim (JustFileName (
      PTagFileRec (F2Transfer^. At (i))^. PathName)));
  End;

  R. FileArea := oFArea;
  SetFileArea (0);

  If FileExists (Cnf. DoorInfoDir + 'file_id.1') And (gFileSize (Cnf. DoorInfoDir + 'file_id.1') > 0) Then
  With FileRec, F2Transfer^ Do
  Begin
    PathName := Cnf. DoorInfoDir + 'file_id.1';
    AreaNum := 0;
    Size := gFileSize (Cnf. DoorInfoDir + 'file_id.1');
    FileRec. Free := True;
    FromName := '';

    Insert (NewTagFile (FileRec));
  End;

End;

End.