{$IFDEF MSDOS}
{$O+,F+}
{$ENDIF}
{$I-}

Unit Areas;

{*********************************************************}
{*                       AREAS.PAS                       *}
{*                                                       *}
{*  Copyright (c) Konstantin Klyagin, 1995-98,           *}
{*                exspecially for Tornado BBS System     *}
{*                                                       *}
{*********************************************************}

Interface

Uses
{$IFDEF OS2}
  Os2Base,
{$ENDIF}

{$IFNDEF WIN32}
  ApAbsPcl,
  DOS,
  ApTimer,
  ApCom,
  tWin,
{$ELSE}
  Classes,
  SysUtils,
  Windows,
  ooMisc,
  Forms,
  Page,
  WApro,
  Console,
{$ENDIF}

  Objects,
  MKMsgAbs,
  MainComm,
  tMisc,
  Resource,
  Parse,
  Parser,
  FilesBBS,
  BSC,
  CompSys,
  OpCrt,
  MKOpen,
  MKGlobT,
  MKMsgHud,
  MKDos,
  MKFile,
  MKMsgFid,
  MKMsgJam,
  MKMsgSqu,
  Log,
  Protocol,
  TGlob,
  Users,
  Ansi,
  TimeTask,
  tFSed,
  {$IFDEF SOUND}
  soundlib,
  {$ENDIF}
  mFind;

Type
  tPostMode = (pmNew, pmReply);

Var
  Msg         : AbsMsgPtr;
  MsgText     : PBigCollection;

Const
  pfAutoOpen       = $01;
  pfPrivate        = $02;
  pfUpgrader       = $04;
  pfUseDefaultAddr = $08;

Procedure SelectFArea;
Procedure SelectMArea;

Procedure SelectFGroup;
Procedure SelectMGroup;

Procedure SearchPrivate;

Procedure OnlineArcView (Param: PathStr);
Procedure TypeFile (FileName: PathStr);
Function OpenMessageArea (ErrorReport, Make: Boolean): Boolean;
Function PostMsg (PostMode: tPostMode; ToUser, eMail, Subj: String): Boolean;
Procedure SetAreas;
Procedure SetGroups;
Procedure ShowCurrentMsg (Pause: Boolean);
{Procedure ReadMsgs (NMsg: LongInt);}
Function ReadMsgs (NMsg: LongInt): Boolean;
Procedure ListMsgs;
Procedure Msg2SysOp (Subj: String);

Procedure PostFile (FileName: PathStr; AbsoluteNum: Word; FromName,
          ToName, mSubj: String; OrigAddr, DestAddr: AddrType;
          Options: Byte);

Procedure GlobalSearch (WildCard: String; ForNew: Boolean; SinceLast: AskType; dFrom: String);
Procedure PrePostMsg (param: String);

Procedure PageSysOp (Topic: String);

Procedure SetRelativeMsgArea;
Procedure SetRelativeFileArea;

Implementation

{$IFDEF WIN32}
Uses
  tor32u;
{$ENDIF}

Type
  tMsgHead = Record
    MsgNum, NumOfMsgs : LongInt;
    IsPriv, IsRcvd    : Boolean;
    MsgDate, MsgTime  : String [10];
    MsgFrom, MsgTo,
    MsgSubj, eMail,
    eReplyTo          : String [80];
    MsgID             : String [50];
    FromAddr, ToAddr  : AddrType;
  End;

Var
  i             : LongInt;
  Err           : SysInt;
  FinishReading : Boolean;
  M             : PNotSortedCollection;
  H             : tMsgHead;

Procedure SelectFGroup;
Var
  OldFG                 : tFileGroup;
  i, j                  : LongInt;
  Tmp                   : String;

Begin
  If Cnf. FileGroupsFile = '' Then Exit;
  If Not OpenFileGroups Then Exit;

  OldFG := FileGroup; i := 1;
  M := New (PNotSortedCollection, Init (1, 1));

  While ReadFileGroup (tFG, i) Do
  Begin
    Inc (i);

    If (tFG. Name <> '') And
       (tFG. ShowSec <= R. Security) and
       FlagsValid (R. Flags, tFG. ShowFlags)
    Then
       M^. Insert (NewStr (tFG. Name));
  End;

  CloseFileGroups; Cls;
  Tmp := ComMenu (lang (laChooseFileGroup), lang (laYourChoice), M);

  Val (Tmp, i, Err);
  If (Tmp = '') Or (err <> 0) Or (i > M^. Count) Or (i < 1) Then
  Begin
    FileGroup := OldFG;
    Dispose (M, Done);
    Exit;
  End;

  SetFileGroup (i);
  Dispose (M, Done);
  SetRelativeFileArea;
  UpdateUserMacro;
End;

Procedure SelectMGroup;
Var
  OldMG                 : tMsgGroup;
  i, j                  : LongInt;
  Tmp                   : String;

Begin
  If Cnf. MsgGroupsFile = '' Then Exit;
  If Not OpenMsgGroups Then Exit;

  OldMG := MsgGroup;
  i := 1;
  M := New (PNotSortedCollection, Init (1, 1));

  While ReadMsgGroup (tMG, i) Do
  Begin
    Inc (i);

    If (tMG. Name <> '') And
       (tMG. ShowSec <= R. Security) and
       FlagsValid (R. Flags, tMG. ShowFlags)
    Then
       M^. Insert (NewStr (tMG. Name));
  End;

  CloseMsgGroups; Cls;
  Tmp := ComMenu (lang (laChooseMsgGroup), lang (laYourChoice), M);

  Val (Tmp, i, Err);
  If (Tmp = '') Or (err <> 0) Or (i > M^. Count) Or (i < 1) Then
  Begin
    MsgGroup := OldMG;
    Dispose (M, Done);
    Exit;
  End;

  SetMsgGroup (i);
  Dispose (M, Done);
  SetRelativeMsgArea;
  UpdateUserMacro;
End;

Procedure SelectFArea;
Var
  OldFA  : tFileArea;
  i      : LongInt;
  Tmp    : String;
  aNum   : Word;

Begin
  If Not OpenFileAreas Then Exit;

  OldFA := FileArea;
  i := 1;
  M := New (PNotSortedCollection, Init (1, 1));

  While ReadFileArea (tFA, i) Do
  Begin
    Inc (i);
    If (tFA. Name <> '') And FlagsValid (R. Flags, tFA. ShowFlags) And
       (tFA. ShowSec <= R. Security) And
       (WordInString (FileGroup. Tag, tFA. Group) Or
       (tFA. Group = '') Or (FileGroup. Tag = ''))
    Then
       M^. Insert (NewStr (tFA. Name));
  End;

  CloseFileAreas;
  Cls;
  Tmp := ComMenu (lang (laChooseFileArea), lang (laYourChoice), M);

  Val (Tmp, aNum, Err);
  If (Tmp = '') Or (Err <> 0) Or (aNum > M^. Count) Or (aNum < 1) Then
  Begin
    FileArea := OldFA;
    Dispose (M, Done);
    Exit;
  End;

  SetFileArea (aNum);
  Dispose (M, Done);

  ScreenOut^. MacroTable1^. ReplaceMacro ('FARE', FileArea. Name);
  ScreenOut^. MacroTable1^. ReplaceMacro ('FNUM', Long2Str (R. FileArea));
End;

Procedure SelectMArea;
Var
  OldMA                 : tMsgArea;
  i                     : LongInt;
  Tmp                   : String;
  aNum                  : Word;

Begin
  If Not OpenMsgAreas Then Exit;

  OldMA := MsgArea;
  i := 1;
  M := New (PNotSortedCollection, Init (1, 1));

  While ReadMsgArea (tMA, i) Do
  Begin
    Inc (i);

    If (tMA. Name <> '') And FlagsValid (R. Flags, tMA. ShowFlags) And
       (tMA. ShowSec <= R. Security) And
       (WordInString (MsgGroup. Tag, tMA. Group) Or
       (MsgGroup. Tag = '')  Or (tMA. Group = ''))
    Then
       M^. Insert (NewStr (tMA. Name));
  End;

  CloseMsgAreas;

  Cls;
  Tmp := ComMenu (lang (laSelectMArea), lang (laYourChoice), M);

  Val (Tmp, aNum, err);
  If (Tmp = '') Or (Err <> 0) Or (aNum > M^. Count) Or (aNum < 1) Then
  Begin
    MsgArea := OldMA;
    Dispose (M, Done);
    Exit;
  End;

  SetMsgArea (aNum);
  Dispose (M, Done);

  ScreenOut^. MacroTable1^. ReplaceMacro ('MARE', MsgArea. Name);
  ScreenOut^. MacroTable1^. ReplaceMacro ('MNUM', Long2Str (R. MsgArea));
End;

Procedure Add2EchoMail (Path: PathStr);
Var
  fName : PathStr;
  F     : Text;

Begin
  Case MsgArea. BaseType Of
    btJam       : Case MsgArea. AreaType Of
                    mmtNetMail  : fName := 'netmail.jam';
                    mmtEchoMail : fName := 'echomail.jam';
                  End;
    btSquish    : fName := 'echotoss.log';
  Else
    Exit;
  End;

  Path := Copy (Path, 1, Length (Path)-1);
  Assign (F, JustPathName (Path) + '\' + fName);

  ReSet (F);
  If IOResult <> 0 Then ReWrite (F) Else Append (F);

  If IOResult <> 0 Then Exit;

  If MsgArea. BaseType = btSquish
   Then WriteLn (F, MsgArea. Name)
   Else WriteLn (F, Path);

  Close (F);
End;

Function FormArcString (FName, FileDate: String; OrigSize, PackSize: LongInt): String;
Begin
  FName := PlaceSubStr (FName, '/', '\');
  FormArcString := EmuColor (Cnf. ColorScheme [avFileName]) + NiceFileName
    (FName, 42) + ' ' + EmuColor (Cnf. ColorScheme [avDate]) + ReFormatDate
    (FileDate, 'MM-DD-YY', Cnf. DateMask) + ' ' + EmuColor (Cnf. ColorScheme
    [avSize]) + PadCh (Long2Str (OrigSize), ' ', 12) + EmuColor (Cnf.
    ColorScheme [avCompressed]) + PadCh (Long2Str (PackSize), ' ', 12);
End;

Procedure OnlineArcView;
Var
  CO      : CompressorType;
  IBMRec  : IBM;
  MACRec  : MAC;

Begin
  If (Trim (Param) = '') Or
     (UpString (Param) = UpString (FileArea. DLPath)) Or
     (FileArea. DLPath = '')
  Then Exit;

  BSC. ArcFiles := New (PNotSortedCollection, Init (10, 1));
  BSC. FormArcStringFunc := FormArcString;

  If DetectCompressor (Param, CO) Then
  Begin
    CO^. CheckProtection;

    If CO^. Broken Then
    Begin
      If InShell
      Then
        ComWrite ('|' + lang (laNotArchive), eoMacro+eoCodes)
      Else
        Message ('|' + lang (laNotArchive));

      Dispose (ArcFiles, Done);
      Exit;
    End;

    CO^. WriteHeader;
    CO^. FindFirstEntry;

    While Not CO^. LastEntry Do
    Begin
      CO^.PrintEntry;

      Case PlatformID (CO^. WhichPlatform) Of
        ID_IBM : CO^. ReturnEntry (IBMRec);
        ID_MAC : CO^. ReturnEntry (MACRec);
       End;

       CO^. FindNextEntry;
    End;

    ComWriteLn ('', 0);

    ComWrite (lang (laArcName), eoMacro + eoCodes);
    ComWrite (UpString (JustFileName (Param)), 0);
    ComWriteLn (' (' + CO^. CompressorName + ')', eoMacro + eoCodes);
    ComWriteLn (lang (laArcHead), eoMacro + eoCodes);
    ComWrite (EmuColor (Cnf. ColorScheme [umSeparator]) +
      ' ', eoMacro + eoCodes);
    If Length (Cnf. DateMask) = 10 Then ComWrite ('', eoMacro + eoCodes);
    ComWriteLn ('  ', eoMacro + eoCodes);

    InitMore (3);

    If ArcFiles^. Count > 0 Then
    For i := 0 To ArcFiles^. Count - 1 Do
    Begin
      ComWriteLn (GetStr (ArcFiles^. At (i)), 0);
      If Not More Then
      Begin
        Dispose (ArcFiles, Done);
        Exit;
      End;
    End;

    Dispose (ArcFiles, Done);
    If Not InShell Then Message ('');
  End Else
    Begin
      Dispose (ArcFiles, Done);
      If InShell
      Then ComWrite ('|'+lang (laNotArchive), eoMacro+eoCodes)
      Else Message ('|'+lang (laNotArchive));
    End;
End;

Procedure GetAddrSmart (Var Addr: AddrType);
Var
  TmpStr        : String [79];

Begin
  FillChar (Addr, SizeOf (Addr), #0);
  Msg^. MsgTxtStartUp;

  While Not Msg^. EOM Do
  Begin
    TmpStr := Msg^. GetString (79);

    If Copy (TmpStr, 1, 8) = #1'MSGID: ' Then
    Begin
      ParseStrAddr (ExtractWord (2, Trim (TmpStr), [' ']), Addr);
      Exit;
    End;

    If Copy (TmpStr, 1, 11) = ' * Origin: ' Then
    Begin
      TmpStr := ExtractWord (WordCount (TmpStr, ['(', ')']), TmpStr, ['(', ')']);
      If WordCount (TmpStr, [' ']) > 1 Then TmpStr := ExtractWord (WordCount
                                            (TmpStr, [' ']), TmpStr, [' ']);
      ParseStrAddr (Trim (TmpStr), Addr);
    End;

  End;
End;

Function OpenMessageArea (ErrorReport, Make: Boolean): Boolean;
Var
  HArea         : String [4];
  AreaID        : String [90];
  IsFileName, B : Boolean;
  MP            : PathStr;

Begin
  Str (MsgArea. BoardNum, HArea);
  AreaID := MsgArea. BasePath;

  Case MsgArea. BaseType Of
    btHudson : Begin
                 IsFileName := False;
                 HArea := Replicate ('0', 3 - Length (HArea)) + HArea;
               End;

    btSquish : Begin
                 IsFileName := True;
                 HArea := '';
                 AreaID [0] := Chr (Length (MsgArea. BasePath) - 1);
               End;

      btFido : Begin
                 IsFileName := False;
                 HArea := '';
                 AreaID := MsgArea. BasePath;
               End;

       btJam : Begin
                 IsFileName := True;
                 HArea := '';
                 AreaID [0] := Chr (Length (MsgArea. BasePath) - 1);
               End;
  End;

  If Not IsFileName Then MP := JustPathName (MsgArea. BasePath) Else MP := MsgArea. BasePath;
  AreaID := MsgBaseLetter [MsgArea. BaseType] + HArea + AreaID;

  If Make
  Then B := OpenOrCreateMsgArea (Msg, AreaID, True, MsgArea. AreaType)
  Else B := OpenMsgArea (Msg, AreaID, True, MsgArea. AreaType);

  If Not B Then
  Begin
    OpenMessageArea := False;
    If ErrorReport Then
    Begin
      If R. HotKeys Then ComWriteLn ('', 0);
      Message (lang (laMsgOpenError));
      LogWrite ('!', sm (smMAreaOpenErr) + ZeroMsg (MsgArea. Name, True));
    End;
  End Else
    OpenMessageArea := True;
End;

Function PostMenu (Var S: String): tLineEditResult;
Var
  F : Boolean;

Function iAnalyze: Boolean;
Begin
  iAnalyze := False;

  Case i Of
    1 : Begin
          Message ('|' + lang (laMsgSaved));
          PostMenu := mpSave;
        End;
    2 : Begin
          ComWriteLn ('', 0);
          If Not Query (lang (laSure), False, 0) Then iAnalyze := True;
          PostMenu := mpAbort;
        End;
    3 : Begin
          ComWriteLn ('', 0);
          PostMenu := mpContinue;
        End;
    4 : Begin
          S := GetAnswer ('|' + lang (laEnterMsgLine), 2, ofAllowEmpty, '');
          If Trim (S) = '' Then iAnalyze := True;
          PostMenu := mpEditLine;
        End;
    5 : Begin
          ComWriteLn (#10, 0);
          ComWriteLn (lang (laMsgWriteText3), eoMacro + eoCodes);
          PostMenu := mpShow;
        End;
    6 : Begin
          S := Trim (GetAnswer ('||' + lang (laDelLines), 20, ofAllowEmpty, ''));
          If Trim (S) = '' Then iAnalyze := True;
          PostMenu := mpDeleteLine;
        End;
  End;
End;

Begin
  F := True;

  Repeat
    i := MenuBar ('|' + lang (laPostMenu), lang (laPostKeys));
  {$IFDEF WIN32}
    If Application. Terminated Then Exit;
  {$ENDIF}
    iAnalyze;
  Until F;
End;

Procedure EditLine (Var S: String);
Begin
  S := GetAnswer ('', 73, 0, S);
End;

Function PostMsg (PostMode: tPostMode; ToUser, eMail, Subj: String): Boolean;
Var
  i          : Integer;
  DestAddr   : AddrType;
  TextLine   : Byte;
  F          : Text;
  S, WToAddr : String;
  OrigArea, OrigGroup: Word;
  OrigMNum   : LongInt;
  OrigAreaName : String[72];

Label
  KeyLoop,
  EndOfCase,
  NextLine;

Procedure UpLoadMsg;
Begin
  AutoDL := True;
  SmartChDir (Cnf. DoorInfoDir);
  Transfer ('', Receive, tsUploadMsg);
  AutoDL := False;
  SmartChDir (Cnf. Path);
End;

Var
  MsgNum, mNum  : LongInt;

Var
  Priv, FirstLine, Quote, mUPL : Boolean;
  List                         : Text;
  UR                           : tUser;
  sLine, eLine, j              : LongInt;
  Options, EditY               : Byte;
  Initials                     : String [4];
  QuoteAbbr, S1                : String;
  C                            : Char;

Const
  YN   : Array [Boolean] Of String [3] = ('NO', 'YES');

Function QuoteLine (S: String): String;
Begin
  If Trim (S) = '' Then
  Begin
    QuoteLine := '';
    Exit;
  End;

  If Pos ('>', Copy (S, 1, 7)) <> 0 Then
  Begin
    If FirstLine Then QuoteAbbr := Copy (S, 1, Pos ('>', Copy (S, 1, 7)));
    Insert ('>', S, Pos ('>', S));
    QuoteLine := S;
  End Else
    If Trim (S) <> '' Then
    Begin
      If FirstLine Then
      Begin
        If Cnf. QuotePrefix Then
        Begin
          QuoteAbbr := Initials;
          QuoteLine := QuoteAbbr + '> ' + S
        End Else
          QuoteLine := '> ' + S;
      End Else
        QuoteLine := QuoteAbbr + '> ' + S;

    End Else
      QuoteLine := '';
End;

Begin
  PostMsg := False;
  OrigArea  := R. MsgArea;
  OrigGroup := R. MsgGroup;
  OrigAreaName := MsgArea. Name;
  OrigMNum  := Msg^. GetMsgNum;
  If (PostMode = pmReply) Then
  Begin
    ComWriteLn ('', 0);
    If Query (lang (laReplyAnotherArea), False, 0) Then SelectMArea;
  End;
  MsgNum := Msg^. GetMsgNum;

  If (MsgArea. WriteSec > R. Security) Or Not FlagsValid (R. Flags, MsgArea. WriteFlags) Then
  Begin
    If R. HotKeys Then ComWriteLn ('', 0);
    Message (lang (laSecurityLow));
    Exit;
  End;

  Cls;
  SetTitle ('posting message');
  PostMsg := False;
  ComWriteLn (lang (laMsgHead), eoMacro + eoCodes);
  ComWrite   (lang (laMsgFrom), eoMacro + eoCodes);
  ComWriteLn (PadCh (R. Name, ' ', 36) + '  ' + PadCh (Addr2Str (MsgArea. Address), ' ', 25), eoMacro + eoCodes);

  ComWrite (lang (laMsgTo), eoMacro + eoCodes);

  ToUser := Trim (ToUser);

  If ToUser <> '' Then ComWrite (PadCh (ToUser, ' ', 36), 0) Else
  Begin
    SetInputCap (NoCaps, AllChars);

    While True Do
    Begin
      ToUser := '';
      ComRead (ToUser, 36, ofAllowEmpty + ofSpaceAdd);
      ToUser := Trim (ToUser);
    {$IFDEF WIN32}
      If Application. Terminated Then Exit;
    {$ENDIF}
      If (Pos ('$EXEC', UpString (ToUser)) <> 0) Or
         (Pos ('$FILE', UpString (ToUser)) <> 0) Then
      Begin
        ComWrite (EmuCursorLeft (36), 0);
        ComWrite (Replicate (' ', 36), 0);
        ComWrite (EmuCursorLeft (36), 0);
      End Else
        Break;
    End;

  End;

  If UpString (ToUser) = 'SYSOP' Then
  Begin
    ComWrite (#13 + lang (laMsgTo) + PadCh (Cnf. SysOp, ' ', 36), eoMacro + eoCodes);
    ToUser := Cnf. SysOp;
  End Else
  If Cnf. Aliases Then
  If Is_User (ToUser, True) Then
  Begin
    GetUser (ToUser, UR, True);
    If ToUser <> UR. Name Then
    Begin
      ToUser := UR. Name;
      ComWrite (#13 + lang (laMsgTo) + PadCh (ToUser, ' ', 36), eoMacro + eoCodes);
    End;
  End;

  If Trim (ToUser) = '' Then Exit;
  ComWrite ('  ', 0);
  If eMail <> '' Then ToUser := eMail;

  If MsgArea. AreaType = mmtNetMail Then
  Begin
    If (Pos ('@', ToUser) <> 0) And (MsgArea. GateWay <> '') Then
    Begin
      WToAddr := RelativeAddr (MsgArea. GateWay, MsgArea. Address);
      ComWriteLn (WToAddr, 0);
    End Else
    Begin
      WToAddr := RelativeAddr ('', H. FromAddr);
      ComRead (WToAddr, 25, ofAllowEmpty + ofSpaceAdd);
   {$IFDEF WIN32}
      If Application. Terminated Then Exit;
   {$ENDIF}
      ComWrite (Replicate (#8, 25), 0);
      ComWriteLn (RelativeAddr (WToAddr, MsgArea. Address), 0);
    End;
  End Else
    ComWriteLn ('', 0);

  ComWrite (lang (laMsgSubj), eoMacro + eoCodes);
  SetInputCap (NoCaps, AllChars);

  If (PostMode = pmNew) And (Subj <> '')
  Then
    ComWriteLn (Subj, 0)
  Else
    ComReadLn (Subj, 80 - Length (lang (laMsgSubj)), ofAllowEmpty);

  tDeleteFile (Cnf. DoorInfoDir + 'msgtmp.');
  ComWriteLn (lang (laMsgDate) + ReFormatDate (StrDate, 'DD-MM-YYYY', Cnf. DateMask), eoMacro + eoCodes);
  ComWrite (lang (laMsgFooter), eoMacro + eoCodes);
  ComWriteLn ('', 0);
  EditY := WhereY;

  If PostMode = pmReply Then
  Begin
    If Cnf. PostQuote = atAsk
    Then Quote := Query (lang (laQuoteMsg), True, 0)
    Else Quote := Cnf. PostQuote = atYes;

    If Quote Then
    Begin
      mNum := Msg^. GetMsgNum;
      Msg^. MsgTxtStartUp;
      Initials := '';

      For i := 1 To WordCount (ToUser, [' ', ',', '.', '-'])
      Do Initials := Initials + Copy (ExtractWord (i,
         ToUser, [' ', ',', '.', '-']), 1, 1);

      Assign (List, AddBackSlash (Cnf. DoorInfoDir) + 'msgtmp.');
      ReWrite (List);

      If IOResult = 0 Then
      Begin
        If (OrigArea <> R. MsgArea) Or (OrigGroup <> R. MsgGroup) Then Begin
           WriteLn (List, lang (laReplyingToArea) + OrigAreaName);
        End;
        While Not Msg^. EOM Do
        Begin
          S := TrimTrail (Msg^. GetString (80));
          If (S [1] = #1) Or (Copy (S, 1, 10) = ' * Origin:') Or (Copy (S, 1, 4) = '--- ') Then Continue;

          If S <> '' Then
          Begin
            FirstLine := True;
            S1 := S;
            QuoteAbbr := '';

            While S1 <> '' Do
            Begin
              WriteLn (List, QuoteLine (SplitString (S1, 70)));
              FirstLine := False;
            End;
          End Else
            WriteLn (List);

        End;

        Close (List);
      End;

      Msg^. SeekFirst (mNum);
    End;
  End;

{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}
  Priv := (MsgArea. Private = atYes);

  If MsgArea. AreaType = mmtNetMail Then Priv := True Else
  If MsgArea. Private = atAsk Then
     Priv := Query (lang (laQueryPrivate), (PostMode =
     pmReply) and (Msg^. IsPriv), 0);

{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}

  If Cnf. PostUpload = atAsk
  Then mUPL := Query (lang (laUpLoadMsg), False, 0)
  Else mUPL := Cnf. PostUpload = atYes;

  CloseMsgArea (Msg);
  If Not OpenMessageArea (True, True) Then Exit;

  If mUPL Then UpLoadMsg Else
  If R. FSEditor Then
  Begin
  {$IFDEF WIN32}
    If Application. Terminated Then Exit;
  {$ENDIF}

    If Cnf. ExtMailEd <> '' Then
    Begin
      Assign (F, Cnf. DoorInfoDir + 'msginf.');
      ReWrite (F);

      If IOResult = 0 Then
      Begin
        WriteLn (F, R. Name);
        WriteLn (F, ToUser);
        WriteLn (F, Subj);
        WriteLn (F, Long2Str (BbsLine));
        WriteLn (F, ZeroMsg (MsgArea. Name, True));
        WriteLn (F, YN [Priv]);
        Close (F);
      End;

      DosShell (TranslateExecParams (Cnf. ExtMailEd), exCommand, False);
    End Else
    Begin
      ComWrite (EmuGoToXY (1, 23), 0);
      ComWrite (lang (laEditStatusLine), eoCodes+eoMacro);

      While True Do
      Begin
        C := fsEditFile (Cnf. DoorInfoDir + 'msgtmp.', [#27, #21, #26],
        ofsQuoting, Cnf. ColorScheme [edQuote], Cnf. ColorScheme [edText],
        1, EditY, 79, 22);

      {$IFDEF WIN32}
        If Application. Terminated Then Exit;
      {$ENDIF}

        Case C Of

          #27 : Begin
                  ComWrite (EmuGoToXY (1, 22), 0);
                  ComWrite (EmuClrEOL, 0);
                  If Query (lang (laSure), False, ofNoCR) Then
                  Begin
                    tDeleteFile (Cnf. DoorInfoDir + 'msgtmp.');
                    Break;
                  End;
                End;
          #21 : ;
          #26 : Break;
        End;
      End;

    End;
  End Else
  Begin
    Cls;
    ComWriteLn (lang (laMsgWriteText1), eoMacro + eoCodes);
    ComWriteLn (lang (laMsgWriteText2), eoMacro + eoCodes);
    ComWriteLn (lang (laMsgWriteText3), eoMacro + eoCodes);

    If lnEditFile (Cnf. DoorInfoDir + 'msgtmp.', PostMenu, EditLine,
       Cnf. ColorScheme [edQuote], Cnf. ColorScheme [edText]) = mpAbort
    Then tDeleteFile (Cnf. DoorInfoDir + 'msgtmp.');
  End;

{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}
  LogWrite ('#','Saving msg into base');
  If FileExists (Cnf. DoorInfoDir + 'msgtmp.') Then
  Begin
    If Priv Then Options := pfPrivate Else Options := 0;
    ParseStrAddr (RelativeAddr (WToAddr, MsgArea. Address), DestAddr);

    LogWrite ('#','Post msg');
    PostFile (Cnf. DoorInfoDir + 'msgtmp.', MtoAbs (R. MsgGroup, R. MsgArea),
    R. Name, ToUser, Subj, MsgArea. Address, DestAddr, Options);

    S := Cnf. DoorInfoDir + 'msgtmp.';
    tDeleteFile (S);
    Inc (Sys. MsgsPosted);
    Inc (R. MsgsPosted);
    LogWrite ('@', 'To: ' + ToUser + ', Subj: ' + Subj);
    PostMsg := True;
    LogWrite ('#','Msg saved');
  End;
  LogWrite ('#','closing msgarea');
  CloseMsgArea (Msg);
  LogWrite ('#','set msggroup');
  SetMsgGroup (OrigGroup);
  LogWrite ('#','set msgarea');
  SetMsgArea (OrigArea);
  LogWrite ('#','open old area');
  If OpenMessageArea (True, False) Then
  Begin
    LogWrite ('#','seek to old msg');
    Msg^. SeekFirst (OrigMNum);
  End;
End;

Procedure SetAreas;
Begin
  SetMsgArea (0);
  SetFileArea (0);
End;

Procedure SetGroups;
Begin
  SetMsgGroup (0);
  SetFileGroup (0);
End;

Procedure ExtractMsgText;
Var
  S, S1, S2                             : String;
  LastKludge, LastWrap, EndReached, FR  : Boolean;

Label
  Loop;

Begin
  MsgText^. FreeAll;
  MsgText^. DeleteAll;
  Msg^. MsgTxtStartUp;
  LastKludge := False;
  LastWrap := False;
  H. eMail := '';
  EndReached := False;

  While Not Msg^. EOM Do
  Begin
    S := TrimTrail (PlaceSubStr (Msg^. GetString (80), #9, '    '));

    If Copy (S, 1, 7)  = #1'MSGID:' Then H. MsgID := Trim (Copy (S, 8, 255)) Else
    If (Copy (S, 1, 10) = #1'RFC-From:') Or (Copy (S, 1, 14) = #1'RFC-Reply-To:') Then
    If (Pos ('<', S) <> 0) Or (Pos ('>', S) <> 0) Or
       (Pos ('(', S) <> 0) Or (Pos (')', S) <> 0) Then
    Begin
      FR := Copy (S, 1, 10) = #1'RFC-From:';
      If FR Then S1 := Copy (S, 12, 255) Else S1 := Copy (S, 16, 255);
      S2 := Trim (ExtractWord (2, S1, ['<', '>', '(', ')']));
      H. MsgFrom := Trim (ExtractWord (1, S1, ['<', '>', '(', ')']));

      If Pos ('@', H. MsgFrom) <> 0 Then
      Begin
        S1 := S2;
        S2 := H. MsgFrom;
        H. MsgFrom := S1;
      End;

      If H. MsgFrom [1] = '"' Then H. MsgFrom := Copy (H. MsgFrom, 2, Length (H. MsgFrom)-2);
      If FR Then H. eMail := S2 Else H. eReplyTo := S2;
    End;

    If ((S [1] = #1) Or (LastWrap And LastKludge)) {And Not DisplayKludges} Then
    Begin
      LastKludge := True;
      LastWrap := Msg^. WasWrap;
      Continue;
    End Else
      If Trim (S) = #0 Then Break;

    LastKludge := False;

    Loop:
    If ((Copy (S, 1, 3) = '---') Or
       (Copy (S, 1, 11) = ' * Origin: ')) And
        Not EndReached Then
    Begin
      MsgText^. InsLine (S);
      EndReached := True;
    End Else
    If Not EndReached Then MsgText^. InsLine (S) Else
    If S <> '' Then
    Begin
      EndReached := False;
      GoTo Loop;
    End;

  End;

  If H. eReplyTo = '' Then H. eReplyTo := H. eMail;
End;

Procedure ShowCurrentMsg;

Type
  tText         = (txNormal, txQuote, txOrigin);

Var
  TmpStr, S1        : String [100];
  Addr              : AddrType;
  TxtMode, oTxtMode : tText;
  i                 : LongInt;

Const
  TextColorSch     : Array [txNormal..txOrigin] Of Byte = (0, 0, 0);
Label
  ShowNext;

{----------------------------------------------------------------------------}
{  㭪樨,   প Color StyleCodes a'la Golded}
{  㭪 ࠡ⠥ ⮫쪮     1!}
function ReplString (Source,Target,s:string;mode:byte):string;
var p,p2:byte;
s1:string;
flag:boolean;
begin
s1:=s;
p:=1;
(* H稭  *)
p2:=1;
repeat
   p:=Pos(Source,s1);

   if p=0 then break;

   {H砫 뤥}
   if (p <> 0) and (mode=1) and (s1[p+Length(source)]<>' ')
   and ( (s1[p-1]=' ') or (p=1) )
   then begin
     delete(s1,p,Length(Source));
     insert(Target,s1,p);
     end else

     { ᫨  騩}
   if (p <> 0) and (mode=2) and (s1[p-1]<>' ')
   and ( (s1[p+Length(source)]=' ') or (p-1+Length(Source) = Length(s1)) )
   then begin
     delete(s1,p,Length(Source));
     insert(Target,s1,p);
     end;
   inc(p2);
until p2=0;

ReplString:=s1;
end;

{  ᠬ,   筮 뤥(᫨ 뤥  ᨬ)}

function ReplStringOnce(NachaloM,KonecM,SCode,stroka:string):string;
var
pos1,pos2:byte;
Len:byte;
_a,_b:byte;
AllRigth:boolean;
begin

Pos1:=0;
Pos2:=0;
Len:=Length(Stroka);
AllRigth:=false;

{Primary cycle}
for _a:=1 to Len+80 do begin
    AllRigth:=false;
                  {,  室 ᨬ ⢮騩 }
                  {᫮ 砫 梥⮢뤥          }
    if (stroka[_a]=SCode)
    and ( (_a=1) or (stroka[_a-1]=' ') or (stroka[_a-1]='='))
    and (stroka[_a+1]<>' ')
    then begin
    Pos1:=_a;

    { 饬 ᨬ 㤮⢮騩  梥⮢뤥}
      for _b:=_a+1 to Len do
          if (stroka[_b]=SCode)
          and ( (_b=Len) or (stroka[_b+1]=' ') or (stroka[_b+1]='='))
          and (stroka[_b-1]<>' ') then begin
               Pos2:=_b;
              AllRigth:=true;
              Break;
          end;
   end;

 if AllRigth then begin
                  Delete(stroka,Pos2,1);
                  Insert(KonecM,Stroka,Pos2);
                  Delete(stroka,Pos1,1);
                  Insert(NachaloM,Stroka,Pos1);
                  Len:=Length(Stroka);
                  end;

end;

ReplStringOnce:=stroka;
end;

{஡ࠧ  梥  ப ⨯ \color%background}
Function Color2Color(b:byte):string;
var temp_s,s1,s2:string;
begin
temp_s:=HexB(b);
LeftPadCh(temp_s,'0',2);
temp_s:=UpString(temp_s);
if Temp_s[1]='0' then s1:='%00' else
if Temp_s[1]='1' then s1:='%01' else
if Temp_s[1]='2' then s1:='%02' else
if Temp_s[1]='3' then s1:='%03' else
if Temp_s[1]='4' then s1:='%04' else
if Temp_s[1]='5' then s1:='%05' else
if Temp_s[1]='6' then s1:='%06' else
if Temp_s[1]='7' then s1:='%07' else s1:='%00';

if Temp_s[2]='0' then s2:='\00' else
if Temp_s[2]='1' then s2:='\01' else
if Temp_s[2]='2' then s2:='\02' else
if Temp_s[2]='3' then s2:='\03' else
if Temp_s[2]='4' then s2:='\04' else
if Temp_s[2]='5' then s2:='\05' else
if Temp_s[2]='6' then s2:='\06' else
if Temp_s[2]='7' then s2:='\07' else
if Temp_s[2]='8' then s2:='\08' else
if Temp_s[2]='9' then s2:='\09' else
if Temp_s[2]='A' then s2:='\10' else
if Temp_s[2]='B' then s2:='\11' else
if Temp_s[2]='C' then s2:='\12' else
if Temp_s[2]='D' then s2:='\13' else
if Temp_s[2]='E' then s2:='\14' else
if Temp_s[2]='F' then s2:='\15' else s2:='\07';
Color2Color:=s1+s2;
end;

{ 楤 ᮡ⭮   ப}
Function ReceptStyleColor(s:string):string;
begin

{15 - _/*#ReverseItalicUnderline#*/_ }
s:=ReplString('_/*#',Color2Color(Cnf. ColorScheme [StyleCode15]),s,1);
s:=ReplString('#*/_',Color2Color(TextColorSch [TxtMode]),s,2);

{14- _/#ReverseItalicUnderline#/_ }
s:=ReplString('_/#',Color2Color(Cnf. ColorScheme [StyleCode14]),s,1);
s:=ReplString('#/_',Color2Color(TextColorSch [TxtMode]),s,2);

{13 -  _*#ReverseBoldUnderline#*_ }
s:=ReplString('_*#',Color2Color(Cnf. ColorScheme [StyleCode13]),s,1);
s:=ReplString('#*_',Color2Color(TextColorSch [TxtMode]),s,2);

{12 -  _#ReverseUnderline#_ }
s:=ReplString('_#',Color2Color(Cnf. ColorScheme [StyleCode12]),s,1);
s:=ReplString('#_',Color2Color(TextColorSch [TxtMode]),s,2);

{11 -  /*#ReverseBoldItalic#*/ }
s:=ReplString('/*#',Color2Color(Cnf. ColorScheme [StyleCode11]),s,1);
s:=ReplString('#*/',Color2Color(TextColorSch [TxtMode]),s,2);

{10 -  /#Reversetalic#/ }
s:=ReplString('/#',Color2Color(Cnf. ColorScheme [StyleCode10]),s,1);
s:=ReplString('#/',Color2Color(TextColorSch [TxtMode]),s,2);


{9 - *#ReverseBold#* }
s:=ReplString('*#',Color2Color(Cnf. ColorScheme [StyleCode9]),s,1);
s:=ReplString('#*',Color2Color(TextColorSch [TxtMode]),s,2);

{7 - _/*BoldItalicUnderline*/_ }
s:=ReplString('_/*',Color2Color(Cnf. ColorScheme [StyleCode7]),s,1);
s:=ReplString('*/_',Color2Color(TextColorSch [TxtMode]),s,2);

{6 -  /_ItalicUnderline_/ }
s:=ReplString('/_',Color2Color(Cnf. ColorScheme [StyleCode6]),s,1);
s:=ReplString('_/',Color2Color(TextColorSch [TxtMode]),s,2);

{5 -   _*BoldUnderline*_ }
s:=ReplString('_*',Color2Color(Cnf. ColorScheme [StyleCode5]),s,1);
s:=ReplString('*_',Color2Color(TextColorSch [TxtMode]),s,2);

{3 -  /*BoldItalic*/  }
s:=ReplString('/*',Color2Color(Cnf. ColorScheme [StyleCode3]),s,1);
s:=ReplString('*/',Color2Color(TextColorSch [TxtMode]),s,2);


{8 - #Reverse# }
s:=ReplStringOnce(Color2Color(Cnf. ColorScheme [StyleCode8]),
                  Color2Color(TextColorSch [TxtMode]),'#',s);


{2 -  /Italic/   }
s:=ReplStringOnce(Color2Color(Cnf. ColorScheme [StyleCode2]),
                  Color2Color(TextColorSch [TxtMode]),'/',s);


{4 -    _Underline_ }
s:=ReplStringOnce(Color2Color(Cnf. ColorScheme [StyleCode4]),
                  Color2Color(TextColorSch [TxtMode]),'_',s);

{1 -  *Bold*  }
s:=ReplStringOnce(Color2Color(Cnf. ColorScheme [StyleCode1]),
                  Color2Color(TextColorSch [TxtMode]),'*',s);

ReceptStyleColor:=s;
end;
{----------------------------------------------------------------------------}

Begin
  If HotKeysStr <> '' Then Exit;
  If Pause Then Cls;
ShowNext:
  Msg^. MsgStartUp;
  FillChar (H, SizeOf (H), 0);
  H. MsgFrom := Msg^. GetFrom;
  H. MsgTo   := Msg^. GetTo;
  H. MsgSubj := Msg^. GetSubj;
  H. IsPriv := Msg^. IsPriv;
  H. IsRcvd := Msg^. IsRcvd;
  H. MsgDate := Msg^. GetDate;
  H. MsgTime := Msg^. GetTime;
  H. MsgNum := Msg^. GetMsgNumRelative;
  H. NumOfMsgs := Msg^. NumberOfMsgs;

  Msg^. GetOrigAddrSmart (H. FromAddr);

  If MsgArea. AreaType = mmtNetMail
  Then Msg^. GetDestAddrSmart (H. ToAddr)
  Else FillChar (H. ToAddr, SizeOf (H. ToAddr), 0);

  If H. IsPriv And
     (LoString(R. Name) <> LoString(Trim (H. MsgTo))) And
     ((MsgArea. SysOpSec > R. Security) Or
     (Not FlagsValid (R. Flags, MsgArea. SysOpFlags))) And
     (LoString(R. Name) <> LoString(Trim (H. MsgFrom))) Then
  Begin
    Msg^. SeekNext;
    If Msg^. SeekFound Then Goto ShowNext;
  End;

  ExtractMsgText;
  ComWriteLn (lang (laMsgHead), eoMacro + eoCodes);

  If Not Pause Then
  If Not More Then
  Begin
    FinishReading := True;
    Exit;
  End;

  ComWrite (lang (laMsgNum) + Long2Str (H. MsgNum) + '/' +
  Long2Str (H. NumOfMsgs), eoMacro + eoCodes);

  If H. IsPriv Then ComWrite (' (Priv)', 0);
  If H. IsRcvd Then ComWrite (' (Rcvd)', 0);
  ComWriteLn ('', 0);

  If Not Pause Then
  If Not More Then
  Begin
    FinishReading := True;
    Exit;
  End;

  ComWrite (lang (laMsgDate), eoMacro + eoCodes);
  ComWriteLn (ReformatDate (H. MsgDate, 'MM-DD-YY', Cnf. DateMask) + ' ' + H. MsgTime, 0);

  If Not Pause Then
  If Not More Then
  Begin
    FinishReading := True;
    Exit;
  End;

  If MsgArea. BaseType in [btFido, btJam] Then Msg^. GetOrig (Addr) Else GetAddrSmart (Addr);
  ComWrite   (lang (laMsgFrom), eoMacro + eoCodes);
  ComWrite (PadCh (H. MsgFrom, ' ', 36), 0);

  S1 := Long2Str (H. FromAddr. Zone) + ':' + Long2Str (H. FromAddr. Net) + '/' +
  Long2Str (H. FromAddr. Node) + '.' + Long2Str (H. FromAddr. Point);

  If H. eMail <> '' Then ComWriteLn (Copy (H. eMail, 1, 30), 0) Else
  If S1 <> '0:0/0.0' Then ComWriteLn (S1, 0) Else ComWriteLn ('', 0);

  If Not Pause Then If Not More Then Begin FinishReading := True; Exit; End;
  ComWrite (lang (laMsgTo) + H. MsgTo, eoMacro + eoCodes);

  If MsgArea. AreaType <> mmtNetMail Then ComWriteLn ('', 0) Else
  Begin
    S1 := Long2Str (H. ToAddr. Zone) + ':' + Long2Str (H. ToAddr. Net) + '/' +
    Long2Str (H. ToAddr. Node) + '.' + Long2Str (H. ToAddr. Point);
    ComWrite (Replicate (' ', 36-Length (H. MsgTo)), 0);
    If S1 <> '0:0/0.0' Then ComWriteLn (S1, 0) Else ComWriteLn ('', 0);
  End;

  If Not Pause Then If Not More Then Begin FinishReading := True; Exit; End;
  ComWrite (lang (laMsgSubj), eoMacro + eoCodes);
  If H. IsPriv And
     (LoString(R. Name) <> LoString(Trim (H. MsgTo))) And
     ((MsgArea. SysOpSec > R. Security) Or
     (Not FlagsValid (R. Flags, MsgArea. SysOpFlags))) And
     (LoString(R. Name) <> LoString(Trim (H. MsgFrom)))
  Then ComWriteLn ('\15********* Private message *********', eoColorCode)
  Else ComWriteLn (H. MsgSubj, 0);

  If Not Pause Then If Not More Then Begin FinishReading := True; Exit; End;
  ComWriteLn (lang (laMsgFooter), eoMacro + eoCodes);
  If Not Pause Then If Not More Then Begin FinishReading := True; Exit; End;
  If Pause Then InitMore (WhereY);

  (* ஢ઠ  ਡ Private *)

  If H. IsPriv And
     (LoString(R. Name) <> LoString(Trim (H. MsgTo))) And
     ((MsgArea. SysOpSec > R. Security) Or
     (Not FlagsValid (R. Flags, MsgArea. SysOpFlags))) And
     (LoString(R. Name) <> LoString(Trim (H. MsgFrom))) Then
  Begin
    ComWriteLn (#13#10 + lang (laPrivMsg) + #13#10, eoMacro + eoCodes);
    Exit;
  End;

  (* End *)

  Msg^. MsgTxtStartUp;
  TxtMode := txNormal;
  oTxtMode := txNormal;
  TextColorSch [txNormal] := Cnf. ColorScheme [mrNormal];
  TextColorSch [txQuote] := Cnf. ColorScheme [mrQuote];
  TextColorSch [txOrigin] := Cnf. ColorScheme [mrOrigin];
  ComWrite (EmuColor (TextColorSch [TxtMode]), 0);

  For i := 0 To MsgText^. Count-1 Do
  Begin
    If MsgText^. At (i) <> Nil Then TmpStr := GetStr (MsgText^. At (i)) Else TmpStr := '';

    If Length (TmpStr) > 0 Then
    Begin
      If Copy (TmpStr, 1, 11) = ' * Origin: ' Then TxtMode := txOrigin Else
      If Pos ('>', Copy (TmpStr, 1, 10)) <> 0 Then
        TxtMode := txQuote Else TxtMode := txNormal;

      If Copy (TmpStr, 1, 3) = '---' Then
      If (Length (TmpStr) = 3) or ((Length (TmpStr) > 3) and (TmpStr [4] = ' '))
      Then txtMode := txOrigin;
      {஢ઠ  ૠ  ਤ -     ⠬ , ࠢ?}
      If (Copy (TmpStr, 1, 11) <> ' * Origin: ')
        and (Copy (TmpStr, 1, 3) <> '---') Then
        TmpStr:=ReceptStyleColor(TmpStr);
    End;

    If TxtMode <> oTxtMode Then ComWrite (EmuColor (TextColorSch [TxtMode]), 0);
    {  ⮣, ⮡ ন  ⨯ \00%00}
    ComWriteLn (TmpStr, eoColorCode + eoDisable01);
    oTxtMode := TxtMode;

    If Not More Then
    Begin
      If Not Pause Then FinishReading := True;
      Break;
    End;

    If DrawAborted Then Break;
  End;

  MsgText^. FreeAll;
  MsgText^. DeleteAll;
End;

{Procedure ReadMsgs;}
Function ReadMsgs (NMsg: LongInt): Boolean;
Var
  ATT             : Word;
  MsgNum          : LongInt;
  PauseAfterEach  : Boolean;

Label
  EndOfProc,
  Again,
  Next,
  ReSelect;

Begin
  ReadMsgs := True;
  If (MsgArea. ReadSec > R. Security) or
     (Not FlagsValid (R. Flags, MsgArea. ReadFlags)) Then
  Begin
    If R. HotKeys Then ComWriteLn ('', 0);
    Message (lang (laSecurityLow));
    Exit;
  End;

  If NMsg = 0 Then
  If Not OpenMessageArea (True, True) Then Exit;

  If Msg^. NumberOfMsgs = 0 Then
  Begin
    Message (#10 + lang (laNoMsgsInArea));
    Goto EndOfProc;
  End;

  If NMsg <> 0 Then MsgNum := NMsg Else Begin
  If R. LastRead >= 0 Then
  If MsgArea. BaseType = btJam
  Then MsgNum := Msg^. GetLastRead (Crc32Str (LoString (R. Name)))
  Else MsgNum := Msg^. GetLastRead (R. LastRead);

  If (R. LastRead < 0) Or (MsgNum = 0) Then MsgNum := 1;
  End;

  Msg^. SeekFirst (MsgNum);
  If Not Msg^. SeekFound Then Msg^. SeekFirst (Msg^. GetLowMsgNum);

  If NMsg <> 0 Then PauseAfterEach :=True Else
  PauseAfterEach := Query (lang (laPauseAfterEach), True, 0);
{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}

  Cls;
  InitMore (0);
  FinishReading := False;

  While Not FinishReading Do
  Begin
    Again:

    Msg^. SeekFirst (Msg^. GetMsgNum);
    ShowCurrentMsg (PauseAfterEach);
  {$IFDEF WIN32}
    If Application. Terminated Then Exit;
  {$ENDIF}

    If R. LastRead >= 0 Then
    If MsgArea. BaseType = btJam
    Then Msg^. SetLastRead (Crc32Str (LoString (R. Name)), Msg^. GetMsgNum)
    Else Msg^. SetLastRead (R. LastRead, Msg^. GetMsgNum);

    ComWriteLn ('', 0);

    If Not PauseAfterEach Then
    If Not More Then Begin FinishReading := True; Break; End;

    If LoString (Trim (Msg^. GetTo)) = LoString (R. Name) Then
    Begin
      Msg^. SetRcvd (True);
      Msg^. ReWriteHdr;
    End;

    ATT := TextAttr;

    ReSelect:
    Msg^. MsgStartUp;

    If Not PauseAfterEach Then
    Begin
      If DrawAborted Then GoTo EndOfProc;
    End Else
    Begin
      If (NMsg = 0) Or (Length (lang (laMsgLstString)) = 0) Then
      i := MenuBar (lang (laMsgString), Copy (lang (laMsgKeys), 1,
      3) + #13 + Copy (lang (laMsgKeys), 4, 255)){;}
      Else
      i := MenuBar (lang (laMsgLstString), Copy (lang (laMsgKeys), 1,
      3) + #13 + Copy (lang (laMsgKeys), 4, 255));
    {$IFDEF WIN32}
      If Application. Terminated Then Exit;
    {$ENDIF}

      Case i Of
      1    : If Msg^. NumberOfMsgs > 0 Then
             Begin         {Again}
               Cls;
               GoTo Again;
             End Else
             Begin
               ComWriteLn ('|'#10 + lang (laNoMsgsInArea), eoMacro + eoCodes);
               GoTo ReSelect;
             End;

      2    : Begin         {Delete}
               If NMsg <> 0 Then Goto ReSelect;
               If Msg^. GetFrom <> R. Name Then
               If (MsgArea. SysOpSec > R. Security) or
                  (Not FlagsValid (R. Flags, MsgArea. SysOpFlags)) Then
               Begin
                 If R. HotKeys Then ComWriteLn ('', 0);
                 Message (lang (laSecurityLow));
                 Goto ReSelect;
               End;

               If (Not R. Frames) or (EmuGoToXY (1, 1) = '') Then ComWriteLn ('', 0);

               If Query (lang (laDeleteMsg), True, ofFramed) Then
               Begin
                 LogWrite ('+', sm (smlDeletingMsg) + Long2Str (Msg^.
                   GetMsgNum) + sm (smDelFromArea) + ZeroMsg (MsgArea.
                   Name, True));

                 Msg^. DeleteMsg (True);

                 If (MsgArea. BaseType = btJAM) And
                    (Msg^. GetMsgNum = Msg^. GetHighMsgNum) And
                    (Msg^. NumberOfMsgs > 1)
                 Then Msg^. SeekPrior;

               End Else
                 GoTo Again;
             End;

      3, 4 : Begin
               If NMsg <> 0 Then Goto EndOfProc;
               Goto Next;    {Next}
             End;

      5    : Begin {Last}
               If NMsg <> 0 Then Goto ReSelect;
               ComWrite (#13 + EmuClrEoL + EmuColor (Att), 0);
               Msg^. SeekPrior;

               If Not Msg^. SeekFound Then
               Begin
                 ComWriteLn (#13#10 + lang (laNoPrevMsg), eoMacro + eoCodes);

                 If Not PauseAfterEach Then
                 Begin
                   Message ('');
                   GoTo EndOfProc;
                 End;

                 GoTo ReSelect;
               End;

               Cls;
               Goto Again;
             End;

      6    : If Not (H. IsPriv And {Reply}
                (LoString(R. Name) <> LoString(Trim (H. MsgTo))) And
                ((MsgArea. SysOpSec > R. Security) Or
                (Not FlagsValid (R. Flags, MsgArea. SysOpFlags))) And
                (R. Name <> Trim (H. MsgFrom))) Then
             Begin
               If PostMsg (pmReply, H. MsgFrom, H. eReplyTo, H. MsgSubj)
               Then LogWrite ('+', sm (smAnswerInArea) + ZeroMsg (MsgArea. Name, True));
               GoTo Again;
             End Else
             Begin
               ComWriteLn ('', 0);
               GoTo ReSelect;
             End;

      7    : Begin
               If NMsg <> 0 Then Goto ReSelect;
               If PostMsg (pmNew, '', '', '') Then {Post}
               LogWrite ('+', sm (smlPosting) + ZeroMsg (MsgArea. Name, True));
             End;

      8    : Begin  {To begin}
               If NMsg <> 0 Then Goto ReSelect;
               Msg^. SeekFirst (Msg^. GetLowMsgNum);
               Cls; GoTo Again;
             End;

      9    : Begin  {To end}
               If NMsg <> 0 Then Goto ReSelect;
               Msg^. SeekFirst (Msg^. GetHighMsgNum);
               Cls; GoTo Again;
             End;

     10    : Begin
               If NMsg <> 0 Then ReadMsgs := False;
               GoTo EndOfProc; {Stop}
             End;

      End;
    End;
    Next:
    ComWrite (#13 + EmuClrEoL + EmuColor (Att), 0);

    Msg^. SeekNext;

    If Not Msg^. SeekFound Then
    Begin
      Cls;
      ComWriteLn (#13#10 + lang (laNoMoreMessages), eoMacro + eoCodes);
      If Not PauseAfterEach Then
      Begin
        Message ('');
        GoTo EndOfProc;
      End;

      GoTo ReSelect;
    End;

  End;

  EndOfProc:
  If NMsg = 0 Then
  CloseMsgArea (Msg);
End;

Procedure ListMsgs;
Var
  i, WC         : Byte;
  MsgNum        : LongInt;
  S             : String;
  mFrom, mTo    : String [36];

Label
  EndOfProc,
  Cloze,
  ShowMsgs;

Begin
  If (MsgArea. ReadSec > R. Security) or
     (Not FlagsValid (R. Flags, MsgArea. ReadFlags)) Then
  Begin
    If R. HotKeys Then ComWriteLn ('', 0);
    Message (lang (laSecurityLow));
    Exit;
  End;

  If Not OpenMessageArea (True, True) Then Exit;
  Msg^. GetMsgNumRelative;
  Msg^. SeekFirst (Msg^. GetLowMsgNum);

  If Not Msg^. SeekFound Then
  Begin
    Message (#10 + lang (laNoMsgsInArea));
    Goto Cloze;
  End;

  Cls;
  ComWriteLn (lang (laListHeader), eoMacro + eoCodes);
  ComWriteLn (EmuColor (Cnf. ColorScheme [umSeparator]) +
    '   ', eoMacro + eoCodes);

  InitMore (WhereY);

  While Msg^. SeekFound {$IFDEF WIN32} And Not Application. Terminated {$ENDIF} Do
  Begin
    S := '';
    Msg^. MsgStartUp;

    mFrom := PlaceSubStr (Msg^. GetFrom, #1, '@');
    mTo := PlaceSubStr (Msg^. GetTo, #1, '@');

    ComWrite (EmuColor (Cnf. ColorScheme [mlNumber]) +
      LeftPadCh (Long2Str (Msg^. GetMsgNum), ' ', 5) + ' ',
{      LeftPadCh (Long2Str (Msg^. GetMsgNumRelative), ' ', 5) + ' ',}
      eoCodes+eoMacro);

    If mFrom = R. Name Then
      ComWrite (EmuColor (Cnf. ColorScheme [mlLightFrom]), 0)
    Else
      ComWrite (EmuColor (Cnf. ColorScheme [mlFrom]), 0);

    ComWrite (PadCh (mFrom, ' ', 24) + ' ', 0);
    If mTo = R. Name Then ComWrite (EmuColor (Cnf. ColorScheme [mlLightTo]), 0)
                     Else ComWrite (EmuColor (Cnf. ColorScheme [mlTo]), 0);

    ComWriteLn (PadCh (mTo, ' ', 24) + ' ' + EmuColor (Cnf. ColorScheme
    [mlSubj]) + PadCh (PlaceSubStr (Msg^. GetSubj, #1, '@'), ' ', 20), 0);

    Msg^. SeekNext;
    If Not MoreNums (S, lang (laEnterMsgNums) )Then GoTo Cloze;
    If Length (S) > 0 Then GoTo ShowMsgs;

    If DrawAborted Then Goto EndOfProc;
  End;

  EndOfProc:
  ComWrite (#13#10 + lang (laEnterMsgNums), eoCodes + eoMacro);
  S := '';
  ComReadLn (S, 78 - Length (ZeroMsg (lang (laEnterMsgNums), True)), ofAllowEmpty);

  ShowMsgs:
{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}
  WC := WordCount (S, [' ', ',']);
  For i := 1 To WC Do
  Begin
    MsgNum := Str2Long (ExtractWord (i, S, [' ', ',']));
    If MsgNum <> 0 Then
    Begin
      Msg^. SeekFirst (MsgNum);
      If Msg^. SeekFound Then
      Begin
        {ShowCurrentMsg (True);}
  Msg^. MsgStartUp;
  FillChar (H, SizeOf (H), 0);
  H. MsgFrom := Msg^. GetFrom;
  H. MsgTo   := Msg^. GetTo;
  H. MsgSubj := Msg^. GetSubj;
  H. IsPriv := Msg^. IsPriv;
  H. IsRcvd := Msg^. IsRcvd;
  H. MsgDate := Msg^. GetDate;
  H. MsgTime := Msg^. GetTime;
  H. MsgNum := Msg^. GetMsgNumRelative;
  H. NumOfMsgs := Msg^. NumberOfMsgs;

  Msg^. GetOrigAddrSmart (H. FromAddr);

  If MsgArea. AreaType = mmtNetMail
  Then Msg^. GetDestAddrSmart (H. ToAddr)
  Else FillChar (H. ToAddr, SizeOf (H. ToAddr), 0);

  If H. IsPriv And
     (LoString(R. Name) <> LoString(Trim (H. MsgTo))) And
     ((MsgArea. SysOpSec > R. Security) Or
     (Not FlagsValid (R. Flags, MsgArea. SysOpFlags))) And
     (LoString(R. Name) <> LoString(Trim (H. MsgFrom))) Then
  Begin
    Continue;
  End;
        If Not ReadMsgs (MsgNum) Then Break;
         {
        If i < WC Then
        Begin
          If Not Query ('|' + lang (laNextMsg), True, 0) Then Break;
        End} {Else
          Message ('')};
      End;
    End;
  End;

  Cloze:
{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}
  If Not CloseMsgArea (Msg) Then {Message (lang (laErrorMBClose)};
End;

Procedure SearchPrivate;
Var
  ColorNum : Byte;
  Found, Finish : Boolean;
  i, j, t, saveArea, saveGroup : Word;
  Passed : PNotSortedCollection;

Procedure FoundRead;
Var
  Num   : LongInt;
  C     : Char;

Begin
  Found := True;
  If Msg^. IsRcvd Then Exit;

  If R. Frames and (EmuGoToXY (1, 1) <> '') Then Cls;
  ComWriteLn ('|' + lang (laFoundPrivMsgFrom) + Msg^. GetFrom +
  lang (laFoundPrivMsgInArea) + MsgArea. Name, eoMacro+eoCodes);

  C := Query_YNQ (lang (laWantToRead));
{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}
  Case C Of
    'y' : Begin
            ShowCurrentMsg (True);
            ComWriteLn ('', 0);
            Msg^. SetRcvd (True);
            Msg^. ReWriteHdr;
          End;
    'q' : Begin
            Finish := True;
            Exit;
          End;
    'n' : Exit;
  End;

  Num := Msg^. GetMsgNum;

  If Query (lang (laWantToAnswer), True, 0) Then
  If PostMsg (pmReply, H. MsgFrom, H. eMail, H. MsgSubj) Then
  Begin
    LogWrite ('+', sm (smAnswerInArea) + ZeroMsg (MsgArea. Name, True));
    Msg^. SeekFirst (1);
    While ((Msg^. GetMsgNum <> Num) and (Msg^. SeekFound)) Do Msg^. SeekNext;
  End;

{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}
  If R. FSEditor Then Cls;
  ComWriteLn ('', 0);
End;

Begin
  saveArea := R. MsgArea;
  saveGroup := R. MsgGroup;
  Found := False;
  Finish := False;
  If R. Frames and (EmuGoToXY (1, 1) <> '') Then Cls Else ComWriteLn ('', 0);
  ComWriteLn ('', 0);
  LogWrite ('+', sm (smlSearchPrivate));
  Passed := New (PNotSortedCollection, Init (1, 3));

  t := mmGroupsAmount;
  If t = 0 Then t := 1;

  For i := 1 To t Do
  Begin
    If Finish Or DrawAborted Then Break;
    SetMsgGroup (i);

    For j := 1 To mAreasGroup Do
    Begin
      Clock2;
      If Finish Or DrawAborted Then Break;
      SetMsgArea (j);

      If Not MsgArea. ScanPrivMail Or Not FlagsValid (R. Flags,
         MsgArea. ShowFlags) Or (MsgArea. ShowSec > R. Security) Or
         Passed^. Contains (Long2Str (PhysMsgArea))
      Then Continue;

      UpdateUserMacro;
      ColorNum := 9 + Random (6);
      ComWrite (EmuColor (ColorNum) + lang (laScanMsgAreas), eoMacro + eoCodes);
      ComWrite (EmuClrEoL + #13, 0);
      Passed^. Insert (NewStr (Long2Str (PhysMsgArea)));

      If Not OpenMessageArea (False, False) Then Continue;
      Clock2;
      Msg^. YoursFirst (R. Name, R. Alias);

      If Not Msg^. YoursFound Then
      Begin
        CloseMsgArea (Msg);
        Continue;
      End;

      While Msg^. YoursFound Do
      Begin
        Msg^. MsgStartUp;
        If LoString (Msg^. GetTo) = LoString (R. Name) Then FoundRead
        Else If LoString (Msg^. GetTo) = LoString (R. Alias) Then FoundRead;
      {$IFDEF WIN32}
        If Application. Terminated Then Exit;
      {$ENDIF}

        If Finish Then Break;
        Msg^. YoursNext;
        Clock2;
      End;

      CloseMsgArea (Msg);
    End;
  End;

  SetMsgGroup (saveGroup);
  SetMsgArea (saveArea);
  Dispose (Passed, Done);

{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}

  If Not Found Then
  Begin
    ComWrite (#13, 0);
    ComWrite (EmuClrEoL, 0);
    Message (lang (laNoPrivFound));
  End;
End;

(*
Procedure SearchNew; {  ᮮ饭}
Var
  ColorNum : Byte;
  Found, Finish : Boolean;
  i, j, t, saveArea, saveGroup : Word;
  Passed : PNotSortedCollection;

Procedure FoundRead__;
Var
  Num   : LongInt;
  C     : Char;

Begin
  Found := True;
  If Msg^. IsRcvd Then Exit;

  If R. Frames and (EmuGoToXY (1, 1) <> '') Then Cls;
  ComWriteLn ('|' + lang (laFoundPrivMsgFrom) + Msg^. GetFrom +
  lang (laFoundPrivMsgInArea) + MsgArea. Name, eoMacro+eoCodes);

  C := Query_YNQ (lang (laWantToRead));
{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}
  Case C Of
    'y' : Begin
            ShowCurrentMsg (True);
            ComWriteLn ('', 0);
            Msg^. SetRcvd (True);
            Msg^. ReWriteHdr;
          End;
    'q' : Begin
            Finish := True;
            Exit;
          End;
    'n' : Exit;
  End;

  Num := Msg^. GetMsgNum;

  If Query (lang (laWantToAnswer), True, 0) Then
  If PostMsg (pmReply, H. MsgFrom, H. eMail, H. MsgSubj) Then
  Begin
    LogWrite ('+', sm (smAnswerInArea) + ZeroMsg (MsgArea. Name, True));
    Msg^. SeekFirst (1);
    While ((Msg^. GetMsgNum <> Num) and (Msg^. SeekFound)) Do Msg^. SeekNext;
  End;

{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}
  If R. FSEditor Then Cls;
  ComWriteLn ('', 0);
End;

Begin
  saveArea := R. MsgArea;
  saveGroup := R. MsgGroup;
  Found := False;
  Finish := False;
  If R. Frames and (EmuGoToXY (1, 1) <> '') Then Cls Else ComWriteLn ('', 0);
  ComWriteLn ('', 0);
  LogWrite ('+', sm (smlSearchPrivate));
  Passed := New (PNotSortedCollection, Init (1, 3));

  t := mmGroupsAmount;
  If t = 0 Then t := 1;

  For i := 1 To t Do
  Begin
    If Finish Or DrawAborted Then Break;
    SetMsgGroup (i);

    For j := 1 To mAreasGroup Do
    Begin
      Clock2;
      If Finish Or DrawAborted Then Break;
      SetMsgArea (j);

      If Not MsgArea. ScanPrivMail Or Not FlagsValid (R. Flags,
         MsgArea. ShowFlags) Or (MsgArea. ShowSec > R. Security) Or
         Passed^. Contains (Long2Str (PhysMsgArea))
      Then Continue;

      UpdateUserMacro;
      ColorNum := 9 + Random (6);
      ComWrite (EmuColor (ColorNum) + lang (laScanMsgAreas), eoMacro + eoCodes);
      ComWrite (EmuClrEoL + #13, 0);
      Passed^. Insert (NewStr (Long2Str (PhysMsgArea)));

      If Not OpenMessageArea (False, False) Then Continue;
      Clock2;
      Msg^. YoursFirst (R. Name, R. Alias);

      If Not Msg^. YoursFound Then
      Begin
        CloseMsgArea (Msg);
        Continue;
      End;

      While Msg^. YoursFound Do
      Begin
        Msg^. MsgStartUp;
        If LoString (Msg^. GetTo) = LoString (R. Name) Then FoundRead
        Else If LoString (Msg^. GetTo) = LoString (R. Alias) Then FoundRead;
      {$IFDEF WIN32}
        If Application. Terminated Then Exit;
      {$ENDIF}

        If Finish Then Break;
        Msg^. YoursNext;
        Clock2;
      End;

      CloseMsgArea (Msg);
    End;
  End;

  SetMsgGroup (saveGroup);
  SetMsgArea (saveArea);
  Dispose (Passed, Done);

{$IFDEF WIN32}
  If Application. Terminated Then Exit;
{$ENDIF}

  If Not Found Then
  Begin
    ComWrite (#13, 0);
    ComWrite (EmuClrEoL, 0);
    Message (lang (laNoNewMsgFound));
  End;
End;
*)

Procedure Msg2SysOp (Subj: String);
Var
  TmpMA : tMsgArea;

Begin
  TmpMA := MsgArea;

  OpenMsgAreas;
  If Not ReadMsgArea (MsgArea, Str2Long (Cnf. ToSysOpArea)) Then Exit;
  CloseMsgAreas;
  UpdateUserMacro;

  If OpenMessageArea (True, True) Then
  Begin
    Msg^. GetMsgNumRelative;
    If PostMsg (pmNew, Cnf. SysOp, '', Subj)
    Then LogWrite ('+', sm (smlPosting) + ZeroMsg (MsgArea. Name, True));

  {$IFDEF WIN32}
    If Application. Terminated Then Exit;
  {$ENDIF}
    CloseMsgArea (Msg)
  End;

  MsgArea := TmpMA;
End;

Procedure TypeFile;
Var
  F     : Text;
  S     : String;

Begin
  If (FileArea. DL_Security > R. Security) Or
     (Not FlagsValid (R. Flags, FileArea. DL_Flags)) Then
  Begin
    ComWriteLn ('|' + lang (laSecurityLow), eoCodes+eoMacro);
    Exit;
  End;

  System. FileMode := Open_Access_ReadOnly;

  Assign (F, FileName);
  ReSet (F);

  System. FileMode := Open_Access_ReadWrite;

  If IOResult <> 0 Then Exit;

  InitMore (0);
  ComWrite (EmuColor ($07), 0);
  While Not EoF (F) Do
  Begin
    ReadLn (F, S);
    PlaceSubStr (S, #8, '    ');
    ComWriteLn (S, 0);
    If Not More Then Break;
  End;
  Close (F);
End;

Procedure PostFile (FileName: PathStr; AbsoluteNum: Word; FromName,
          ToName, mSubj: String; OrigAddr, DestAddr: AddrType;
          Options: Byte);
Var
  F : Text;
  S : String;
  A : tMsgArea;

Begin
  A := MsgArea;

  If Options And pfAutoOpen <> 0 Then
  Begin
    OpenMsgAreas;
    ReadMsgArea (MsgArea, AbsoluteNum);
    CloseMsgAreas;
  End;

  If (MsgArea. WriteSec > R. Security) Or
     Not FlagsValid (R. Flags, MsgArea. WriteFlags) Then
  Begin
    MsgArea := A;
    Exit;
  End;

  If Options And pfAutoOpen <> 0 Then
  If Not OpenMessageArea (False, True) Then Exit;
  System. FileMode := Open_Access_ReadOnly;

  Assign (F, FileName);
  ReSet (F);
  If IOResult <> 0 Then Exit;

  System. FileMode := Open_Access_ReadWrite;

  LogWrite ('#','Filling msg header');
  Msg^. SetMailType (MsgArea. AreaType);
  Msg^. StartNewMsg;
  Msg^. SetFrom (FromName);
  Msg^. SetTo (ToName);
  Msg^. SetSubj (mSubj);
  Msg^. SetDate (ReFormatDate (Long2Date (DateL), DefaultDateMask, 'MM-DD-YY'));
  Msg^. SetTime (StrTime);
  Msg^. SetLocal (True);
  Msg^. SetEcho (MsgArea. AreaType = mmtEchoMail);
  Msg^. SetPriv ((MsgArea. AreaType = mmtNetMail) Or (Options And pfPrivate <> 0));

  If Options And pfUseDefaultAddr <> 0 Then
  Begin
    Msg^. SetOrig (MsgArea. Address);
    Msg^. SetDest (MsgArea. Address);
  End Else
  Begin
    Msg^. SetOrig (OrigAddr);
    Msg^. SetDest (DestAddr);
  End;

  LogWrite ('#','Generating MSGID');
  Msg^. DoStringLn (#1'MSGID: ' + Addr2Str (MsgArea. Address) + ' ' +
  LoString (HexL (Crc32Str (StrTime + StrDate))));

  LogWrite ('#','Generating PID');
  S := #1'PID: ' + NameVer;
  If Options And pfUpgrader <> 0 Then S := S + ' upgrade manager';
  Msg^. DoStringLn (S);

  LogWrite ('#','Saving body');
  While Not EoF (F) Do
  Begin
    ReadLn (F, S);
    S := PlaceSubStr (S, '', 'H');
    Msg^. DoStringLn (S);
  End;

  Close (F);
  LogWrite ('#','Body saved');
  Msg^. DoStringLn ('--- ' + NameVer);
  Msg^. DoStringLn (' * Origin: ' + MsgArea. Origin + ' (' + Addr2Str (MsgArea. Address) + ')');

  LogWrite ('#','Posting NOW!');
  Msg^. WriteMsg;

  LogWrite ('#','Posted...');
  If Options And pfAutoOpen <> 0 Then
  Begin
    CloseMsgArea (Msg);
    MsgArea := A;
  End;

  Add2EchoMail (MsgArea. BasePath);
  MakeFlag (MailFlag);
End;

Procedure GlobalSearch (WildCard: String; ForNew: Boolean; SinceLast: AskType; dFrom: String);
Var
  ColorNum, t           : Byte;
  OldFA                 : tFileArea;
  Passed                : PNotSortedCollection;
  Found, tNf, Aborted   : Boolean;
  saveArea, saveGroup,
  i, j                  : Word;
  DateFrom              : String [18];

Procedure CheckSince;
Begin
  If (R. ScanDate > 0) And (R. ScanDate <> $FFFF) And (Cnf. ScanLastDate = 1)
  Then DateFrom := ReFormatDate (Long2Date (R. ScanDate), DefaultDateMask, 'DD-MM-YYYY') + ' ' + Word2Time (R. ScanTime)
  Else DateFrom := ReFormatDate (Long2Date (R. LastDate), DefaultDateMask, 'DD-MM-YYYY') + ' ' + Word2Time (R. LastTime);
  Aborted := False;

  If SinceLast <> atYes Then
  Begin
    If SinceLast = atNo Then DateFrom := dFrom Else
    Begin
      If Not Query (lang (laFindNewFiles), True, ofFramed) Then
      If (SinceLast = atAsk) And (dFrom <> '') Then
      Begin
        Aborted := True;
        Exit;
      End Else
        DateFrom := '';

    {$IFDEF WIN32}
      If Application. Terminated Then
      Begin
        Aborted := True;
        Exit;
      End;
    {$ENDIF}
    End;

    If DateFrom = '' Then
    Begin
      DateFrom := GetAnswer (lang (laNewSinceDate) + ' (' +
        Cnf. DateMask + '): ', Length (Cnf. DateMask),
        ofAllowEmpty, '');

      If DateFrom = '' Then
      Begin
        Aborted := True;
        Exit;
      End;
      DateFrom := ReFormatDate (DateFrom, Cnf. DateMask, 'DD-MM-YYYY');
    End;

  End;
End;

Begin
  saveArea := R. FileArea;
  saveGroup := R. FileGroup;

  If R. Frames and (EmuGoToXY (1, 1) <> '') Then Cls Else ComWriteLn ('', 0);
  If ForNew Then
  Begin
    CheckSince;
    If Aborted Then Exit;
    LogWrite ('+', sm (smlNewSearch));
  End Else
  Begin
    LogWrite ('&', 'Search mask: "'+ WildCard + '"');
  End;

  Found := False;
  ComWriteLn ('', 0);
  InitMore (0);

  FilesColl := New (PFileItemCollection, Init (100, 1));
  Passed := New (PNotSortedCollection, Init (1, 3));
  FilesBBS. FirstStep := True;
  FilesBBS. NumFile := 1;
  Finished := False;
  t := ffGroupsAmount;
  If t = 0 Then t := 1;

  For i := 1 To t Do
  Begin
    SetFileGroup (i);

    For j := 1 To fAreasGroup Do
    Begin
      SetFileArea (j);

      If (FileArea. List_Security > R. Security) Or
         (FileArea. ShowSec > R. Security) Or
         Not FlagsValid (R. Flags, FileArea. List_Flags)
         Or Passed^. Contains (Long2Str (PhysFileArea))
      Then Continue;

      If ForNew And Not FileArea. ScanNewFiles Then Continue;

      UpdateUserMacro;
      ColorNum := 9 + Random (6);
      ComWrite (EmuColor (ColorNum) + lang (laScanFileAreas), eoMacro+eoCodes);
      ComWrite (EmuClrEoL + #13, 0); Clock2;
      Passed^. Insert (NewStr (Long2Str (PhysFileArea)));

      If ForNew
      Then Aborted := Not DispFilesBBS ('*.*', DateFrom, True, False, tNf)
      Else Aborted := Not DispFilesBBS (WildCard, '', True, False, tNf);

    {$IFDEF WIN32}
      If Application. Terminated Then Exit;
    {$ENDIF}

      If tNf Then
      Begin
        Found := True;
        Inc (MoreLines);
      End;

      If Aborted Or DrawAborted Then
      Begin
        Aborted := True;
        Break;
      End;

    End;

    If Aborted Then Break;
  End;

  ComWrite (#13, 0);
  ComWrite (EmuClrEoL, 0);
  SetFileGroup (saveGroup);
  SetFileArea (saveArea);

  If (Not Aborted) And ForNew Then
  Begin
    R. ScanDate := Date2Long (ReFormatDate (StrDate, 'DD-MM-YYYY', 'MM-DD-YYYY'));
    R. ScanTime := TimeStr2Word (StrTime);
  End;
  If Not Found Then Message (lang (laNoFilesFound)) Else
  If Not Aborted Then While Tag Do;

  FilesBBS. FirstStep := True;
  FilesBBS. NumFile := 1;
  Dispose (Passed, Done);
  Dispose (FilesColl, Done);
  UpdateUserMacro;
  InitMore (0);
End;

Procedure SetRelativeFileArea;
Begin
  R. FileArea := 1;
  SetFileArea (1);
End;

Procedure SetRelativeMsgArea;
Begin
  R. MsgArea := 1;
  SetMsgArea (1);
End;

Procedure PrePostMsg (param: String);
Var
  MA    : tMsgArea;

Label
  PostLbl;

Begin
  MA := MsgArea;

  If Param <> '' Then
  Begin
    If Not OpenMsgAreas Then Exit;
    ReadMsgArea (MsgArea, Str2Long (Param));
    CloseMsgAreas;
  End;

  If MsgArea. Name = '' Then
  Begin
    LogWrite ('!', sm (smErrorMsgAreaDef) + Param);
    Goto PostLbl;
  End;

  If OpenMessageArea (True, True) Then
  If PostMsg (pmNew, '', '', '') Then LogWrite ('+', sm (smlPosting) + ZeroMsg (MsgArea. Name, True));

  CloseMsgArea (Msg);

  PostLbl:
  MsgArea := MA;
End;

Procedure PageSysOp (Topic: String);
Type
  tSysOpState = (sNoReaction, sBusy, sOK);

Var
{$IFNDEF WIN32}
  PageBox       : pBoxRec;
  oStat         : Boolean;
{$ENDIF}
  Inp           : String [40];
  PageResult    : tSysOpState;

Const
  PageTimes    : Byte = 0;

Function DoPage: tSysOpState;

{$IFNDEF WIN32}
Procedure RestoreStatus;
Begin
  StatusBarEnable := True;
  StatusBar := oStat;
  If Not StatusBar Then ClearWindow (1, ScrY-1, ScrX+1, ScrY+1, ' ', $00);
End;
{$ENDIF}

Begin
  DoPage := sOK;

{$IFDEF OS2}
  If ThreadLocked Then
  Begin
    DoPage := sBusy;
    Exit;
  End;
{$ENDIF}

{$IFNDEF WIN32}
  oStat := StatusBar;
  StatusBar := False;
  StatusBarEnable := False;

  FastWrite (Copy (CenterCh ('(' + R. Name + '): ' + Inp, ' ', ScrX+1), 1, ScrX+1), ScrY, 1, Cnf. ColorScheme [cmStatusLine]);
  FastWrite (Replicate (' ', ScrX+1), ScrY+1, 1, Cnf. ColorScheme [cmStatusLine]);

  InitWindow (PageBox, 25, 8, 55, 14, 2, Cnf. ColorScheme [cdFrame], '', $00, ZoomSpeed, True);
  DrawWindow (PageBox);

  FastWrite (sm (smwPaging), PageBox^. Y1 + 1, 28, Cnf. ColorScheme [cdInput]);
  FastWrite (sm (smwAnswer), PageBox^. Y1 + 3, 28, Cnf. ColorScheme [cdText]);
  FastWrite (sm (smwPageCanc), PageBox^. Y1 + 4, 28, Cnf. ColorScheme [cdText]);
{$ELSE}
  MainForm. PlayerWave1. Stop;
  MainForm. PlayerWave1. WaveName := Cnf. Path + 'chat.wav';
  MainForm. PlayerWave1. Loop := True;
  MainForm. PlayerWave1. Async := True;
  With PageForm Do
  Begin
    Topic. Caption := Inp;
    Show;
  End;
  MainForm. Console1. ShowCursor;
{$ENDIF}

  NewTimerSecs (Timer, Cnf. PageDuration);
  OpenPageFile (Cnf. Path + 'page.tor');
  {$IFDEF SOUND}
  {$IFDEF MSDOS}
  initblaster;
  {$ENDIF}
  {$ENDIF}

  Repeat
    If Cnf. Sound Then
    If Not keyScrollLock Then
    Begin
      {$IFDEF SOUND}
      {$IFDEF MSDOS}
      If play. stopped Then
      Begin
        if blaster. available then
         if opensound (0, Cnf. Path + 'chat.wav') then
            startplay(0)
         else
           blaster. available := false
        Else
      {$ENDIF}
      {$ENDIF}
          PlayNextString;
      {$IFDEF SOUND}
      {$IFDEF MSDOS}
      End;
      {$ENDIF}
      {$ENDIF}
    End;

    SlashRotate;

    If Task. OS = 0 Then Clock2 Else
    Begin
    {$IFNDEF WIN32}
      If Cnf. Clock Then FastWrite (StrTime, 1, ScrX-6, Cnf. ColorScheme [cmClock]);
    {$ENDIF}
      If Not Local And Not CheckDCD (P) Then LostCarrier;
    End;

    If TimerExpired (Timer) Then
    Begin
    {$IFDEF WIN32}
      Paged := True;
    {$ENDIF}
      DoPage := sNoReaction;
      Break;
    End;

  {$IFDEF WIN32}
    Application. ProcessMessages;
  {$ENDIF}

  Until
  {$IFDEF WIN32}
    Not PageForm. Visible Or Application. Terminated
  {$ELSE}
    KeyPressed
  {$ENDIF};

{$IFNDEF WIN32}
  {$IFDEF SOUND}
  {$IFDEF MSDOS}
  closesound(0);                        {close file 0}
  {$ENDIF}
  {$ENDIF}
  If KeyPressed Then
{  If Not (ReadKey In ['C', 'c','', ''] ) Then DoPage := sBusy;}
  If Not (ReadKey = #13) Then DoPage := sBusy;
{$ELSE}
  If Not Paged Then DoPage := sBusy;
{$ENDIF}

  If ScreenOut^. EnableScreenOut Then NormalCursor;
{$IFNDEF WIN32}
  CloseWindow (PageBox);
  RestoreStatus;
{$ELSE}
  PageForm. Visible := False;
{$ENDIF}
End;

Begin
  If (Not MatchTimeArray (Cnf. PageTime)) Or ChkFlag (PageFlag) Then
  Begin
    WantsChat := True;
    EmuDispFile ('~notaval');
    Message ('|' + lang (laOutPageTime));
    Exit;
  End;

  Inp := '* No Topic *';

  If Cnf. AskChatTopic Or (Topic <> '') Then
  Begin
    If Topic = '' Then
    Begin
      If R. Frames and (EmuGoToXY (1, 1) <> '') Then ComWrite (EmuGotoXY (1, 2), 0);
      Inp := GetAnswer (lang (laTopicForChat) + ' ', 40, ofAllowEmpty, '');
      If Inp = '' Then Exit;
    End Else
      Inp := Topic;

    LogWrite ('+', sm (smlPagingSysOpTopic) + Inp);
    ComWriteLn ('', 0);
  End Else
    LogWrite ('+', sm (smlPagingSysOp));

  Inc (PageTimes);

  If (PageTimes > Cnf. PageLimit) And (Cnf. PageLimit > 0) Then Message (lang (laPageLimit)) Else
  Begin
    SetTitle ('paging sysop for a chat');
    ComWrite (lang (laPagingForChat), eoMacro + eoCodes);
    If ScreenOut^. EnableScreenOut Then HiddenCursor;
    WantsChat := True;
    PageResult := DoPage;
  {$IFDEF WIN32}
    If Application. Terminated Then Exit;
  {$ENDIF}

    Case PageResult Of
           sOK : Begin
                   LogWrite ('+', sm (smSysOpPaged));
                   SetTitle ('chatting with sysop');
                   PageTimes := 0;
                   Chat;
                   SetTitle ('');
                 End;

         sBusy : Begin
                   LogWrite ('+', sm (smSysOpBusy));
                   If Query (lang (laSysOpBusy), True, ofFramed)
                   Then Msg2SysOp (Inp);
                 End;

   sNoReaction : Begin
                   LogWrite ('+', sm (smNoSysOp));
                   If Query (lang (laNoSysOpForChat), True, ofFramed)
                   Then Msg2SysOp (Inp);
                 End;
    End;

  End;

  If R. Emu = teTty Then TextAttr := 3;
  ClosePageFile;
End;

End.