'           Molnar \ Kucalaba Production File Decompressor v1.1
'                   http://members.aol.com/mkwebsite
'
' This program uses the Huffman algorithm for decoding files.  To encode
' a file, please use the file MKENCODE.BAS.
'
' This program was designed ot be easy to cut and paste into various
' programs.  Therefore, the code is not very modular at all, almost
' all of the code is in DecodeFile.  As far as optimizations go,
' several have been implemented:
'
'   1) All input/output is buffered so there should not be very many
'      reads/writes to files.
'   2) The decoding  process is no longer recursive which speeds
'      things up a lot.
'   3) A bit table is used for extracting bits
'



DECLARE FUNCTION StrippedName$ (in$)
DECLARE FUNCTION FindSmallestTree% ()
DECLARE SUB GetHeader ()
DECLARE SUB DecodeFile ()


'$DYNAMIC

DIM SHARED InFile$, OutFile$

CLS
PRINT "Please select an input (MKZ) file: ";
INPUT "", InFile$
PRINT



'*********** Begin Data Initialization *************
CONST NoSubTrees = 0
CONST ChunkSize = 600

' Node type for trees.  Only the Code and Ptr fields are needed to decode,
' but the GenBool and Freq value are needed for construction
TYPE NodeType
	Code AS STRING * 1    ' The actual code
	Lptr AS INTEGER       ' pointer to left subtree
	Rptr AS INTEGER       ' pointer to right subtree
	GenBool AS STRING * 1
	Freq AS INTEGER
END TYPE

TYPE FileHeaderType
	MKZ AS STRING * 3
	Reserved AS STRING * 1
	Version AS SINGLE
	ExpectedFileName AS STRING * 12
	ExpectedFileLen AS DOUBLE
END TYPE

' Create a fileheader object and some other useful things
DIM SHARED File AS FileHeaderType
DIM SHARED byte AS STRING * 1, InByte AS INTEGER, BytePos AS INTEGER, Buffer$
DIM SHARED root AS INTEGER, FreeTree AS INTEGER
DIM SHARED CodeTree(1 TO 511) AS NodeType, start!
DIM SHARED FreqTable(0 TO 255) AS INTEGER, MKZSize AS DOUBLE
' Create a bit table
DIM SHARED BitTable(0 TO 8) AS INTEGER
FOR X% = 0 TO 8
	BitTable(X%) = 2 ^ X%
NEXT
'*********** End Data Initialization *************


' Get file header so we can display some information
CALL GetHeader



IF File.MKZ <> "MKZ" THEN
	PRINT "This is an invalid MKZ file!"
	SYSTEM
END IF

CLS
PRINT
PRINT "͵ M \ K Productions' Decoder v1.1 ͸"
PRINT "                                                                              "
PRINT " MKZ File Name                       : "; StrippedName$(InFile$); TAB(80); ""
PRINT " MKZ file size is                    :"; MKZSize; "bytes"; TAB(80); ""
PRINT " MKZ Version                         :"; File.Version; TAB(80); ""
PRINT " Expected Output File Name           : "; File.ExpectedFileName; ; TAB(80); ""
PRINT " Expected Output File Length         :"; File.ExpectedFileLen; "bytes"; TAB(80); ""
PRINT " Input/Output Chunk Size             :"; ChunkSize; TAB(80); ""
PRINT "                                                                              "
PRINT ";"



PRINT
PRINT "Please select an output option: "
PRINT "1) Output to expected file name ("; RTRIM$(File.ExpectedFileName); ")"
PRINT "2) Specify a different output file name"
PRINT "3) Oops I don't want to decode after all"

a$ = INPUT$(1)
IF a$ = "2" THEN
       INPUT "Output file name? ", OutFile$
ELSEIF a$ = "1" THEN
	OutFile$ = File.ExpectedFileName
ELSE
	SYSTEM
END IF


LOCATE 11, 1
PRINT "Ĵ Decoding Status Ĵ"
PRINT "                                                                              "
PRINT " Number of bytes decoded : "; TAB(80); ""
PRINT " Number of bytes wrote   : "; TAB(80); ""
PRINT " KBs decoded per second  :"; TAB(80); ""
PRINT " Percentage complete     :"; TAB(80); ""
PRINT " Elapsed time (seconds)  :"; TAB(80); ""
PRINT "                                                                              "
PRINT ";"
start! = TIMER
DecodeFile
LOCATE 20, 1: PRINT

SYSTEM

REM $STATIC
SUB DecodeFile
' This is a huge SUB beacuse it actually contains 3 other SUBs that 
' were merged for simplicity and speed.

OPEN InFile$ FOR BINARY AS #1
	      
' Input Header (again)
GET #1, , File
	       
' Get the frequency table
FOR X% = 0 TO 255
	GET #1, , byte
	FreqTable(X%) = ASC(byte)
NEXT

'  ***** BEGIN - Build Code Tree *****
	FreeTree = 1
	' Scan the frequency table and build a "forest" of trees
	FOR X% = 0 TO 255
		' if code existed in file then create a tree for it
		IF FreqTable(X%) <> 0 THEN
			CodeTree(FreeTree).Code = CHR$(X%)
			CodeTree(FreeTree).Freq = FreqTable(X%)
			CodeTree(FreeTree).GenBool = "T"
			EnabledTrees = EnabledTrees + 1
			FreeTree = FreeTree + 1
		END IF
	NEXT
	' At this point the CodeTree holds all the important data
	root = FreeTree

	' Now we have to remove the two smallest trees and merge them
	' continuously until there is only one tree left in the "forest"
	DO WHILE EnabledTrees > 1
		' First, find the two smallest trees and disable them
		' so they don't get merged again after this one time
		Node1% = FindSmallestTree%
		CodeTree(Node1%).GenBool = "F"
	     
		Node2% = FindSmallestTree%
		CodeTree(Node2%).GenBool = "F"

		' Now we need to create a new node
		' --- make sure the tree is enabled for future merging
		CodeTree(FreeTree).GenBool = "T"
		' --- fill in the two subtree pointers
		CodeTree(FreeTree).Lptr = Node1%
		CodeTree(FreeTree).Rptr = Node2%
		' --- the frequency is now the sum of the two children
		CodeTree(FreeTree).Freq = CodeTree(Node1%).Freq + CodeTree(Node2%).Freq
		FreeTree = FreeTree + 1
		EnabledTrees = EnabledTrees - 1
	      
	LOOP
	root = FreeTree - 1
'  ***** END - Build Code Tree ***** 



OPEN OutFile$ FOR BINARY AS #2
	' Overwrite the selected output file if it exists
	IF LOF(2) <> 0 THEN
		CLOSE #2
		KILL OutFile$
		OPEN OutFile$ FOR BINARY AS #2
	END IF
	Chunk$ = ""


' Now loop through compressed file, looking up codes
' and sending them to the output file.
DO
		       
	' ****** BEGIN - Look up the code ******
	rcopy% = root
	Code$ = ""
	WHILE LEN(Code$) = 0
		IF CodeTree(rcopy%).Lptr = NoSubTrees AND CodeTree(rcopy%).Rptr = NoSubTrees THEN
			Code$ = CodeTree(rcopy%).Code
		ELSE
					
			' ****** BEGIN - Get Next Bit ******
			' First of all, if starting new byte then input from buffer
			' If buffer is empty input from file
			IF BytePos = 0 THEN
				' If reached end of buffer fill it up again
				IF LEN(Buffer$) = 0 THEN
					IF LOF(1) - LOC(1) > ChunkSize THEN
						Buffer$ = SPACE$(ChunkSize)
					ELSE
						Buffer$ = SPACE$(LOF(1) - LOC(1))
					END IF
					GET #1, , Buffer$
				END IF
				byte = LEFT$(Buffer$, 1)
				IF LEN(Buffer$) > 0 THEN Buffer$ = RIGHT$(Buffer$, LEN(Buffer$) - 1)
					InByte = ASC(byte)
					BytePos = 0
				END IF
				' Get the next bit from input stream, to be used only in decoding
				' of the bitstream
				bit% = (InByte AND BitTable(BytePos)) \ BitTable(BytePos)
				BytePos = BytePos + 1
				IF BytePos = 8 THEN BytePos = 0
				' ****** END - Get Next Bit ******

				IF bit% = 1 THEN
					rcopy% = CodeTree(rcopy%).Lptr
				ELSE
					' If we have a 0 bit then go to right subtree
					rcopy% = CodeTree(rcopy%).Rptr
				END IF
		END IF
	WEND
	' ****** END - Look up code ******                  

	Chunk$ = Chunk$ + Code$

	IF (LEN(Chunk$) = ChunkSize) OR (LEN(Chunk$) + LOC(2) = File.ExpectedFileLen) THEN
		' Here is where the data is written so you can
		' alter it to go to memory if you want (for games etc)
		PUT #2, , Chunk$
		Chunk$ = ""

		' UPDATE SCREEN
		' REMOVE THIS CODE IF NEEDED
		LOCATE 13, 28: PRINT LOC(1)
		LOCATE 14, 28: PRINT LOF(2)
		LOCATE 15, 29: PRINT USING "####.#"; (LOF(2) / (TIMER - start! + .00001)) / 1024
		LOCATE 16, 31: PRINT USING "##.##"; (LOF(2) / File.ExpectedFileLen) * 100
		LOCATE 17, 29: PRINT USING "####.###"; TIMER - start!

	END IF

LOOP UNTIL LOF(2) = File.ExpectedFileLen
CLOSE #1
CLOSE #2
END SUB

FUNCTION FindSmallestTree%
	' Find the smallest enabled tree in forest and return pointer to it
	min% = 32767
	
	FOR X% = 1 TO FreeTree - 1
		IF CodeTree(X%).GenBool = "T" THEN
			Ptr% = X%
			EXIT FOR
		END IF
	NEXT

	FOR X% = Ptr% TO FreeTree - 1
		' if code is enabled then check value
		IF CodeTree(X%).GenBool = "T" THEN
			' If find a new smallest frequency then
			' set new pointer value (to be returned)
			' and new Min and disable node
			IF CodeTree(X%).Freq < min% THEN
				Ptr% = X%
				min% = CodeTree(X%).Freq
			END IF
		END IF
	NEXT
      
	' Return the smallest pointer
	FindSmallestTree% = Ptr%
END FUNCTION

SUB GetHeader
	OPEN InFile$ FOR BINARY AS #1
		MKZSize = LOF(1)
		GET #1, , File
	CLOSE #1
END SUB

FUNCTION StrippedName$ (in$)
	' Takes a file name+path and returns only the file name
	' i.e. strips away the directory information
	work$ = in$
	WHILE INSTR(work$, "\") <> 0
		work$ = RIGHT$(work$, LEN(work$) - INSTR(work$, "\"))
	WEND
	StrippedName$ = work$
END FUNCTION

