DECLARE SUB boundary ()
DECLARE SUB continue ()
DECLARE SUB move.hero ()
DECLARE SUB move.robots ()
DECLARE SUB next.level ()
DECLARE SUB randomizer ()
DECLARE SUB screen.layout ()
DECLARE SUB start.setup ()
DECLARE SUB status ()

REM    Robots Game adapted from Red Hat Linux recreated in QBasic
REM      for use in DOS, by << Steven Pahlke, September 1998 >>

DIM SHARED x(41), y(41), v(41), lev, name$, numr, points, score, z
CLS : SCREEN 0: CALL start.setup

DO
CALL status: CALL move.hero
CALL status: CALL move.robots
LOOP

SUB boundary
                     
'  Prevents any pieces from
'  leaving the game window.

IF x(z) < 2 THEN x(z) = 2
IF y(z) < 2 THEN y(z) = 2
IF x(z) > 60 THEN x(z) = 60
IF y(z) > 22 THEN y(z) = 22

END SUB

SUB continue

IF v(1) = 0 THEN
LOCATE y(1), x(1): PRINT "AARRgghhhh...."
COLOR 0, 7: LOCATE 3, 16
PRINT SPC(1); "1"; SPC(7); score + points; SPC(6); name$; SPC(3);
COLOR 7, 0
END IF

IF v(1) = 0 THEN LOCATE 23, 64: PRINT "Another game?": GOTO again
IF v(1) = 1 THEN LOCATE 23, 64: PRINT "Really quit?": GOTO over

again:
more$ = INPUT$(1)
more$ = LCASE$(more$)
IF more$ = "y" THEN PRINT SPACE$(13): CALL start.setup
IF more$ = "n" THEN END
IF more$ <> "y" AND more$ <> "n" THEN GOTO again
GOTO skipy

over:
LOCATE y(1), x(1): PRINT CHR$(64)
more$ = INPUT$(1)
more$ = LCASE$(more$)
IF more$ = "n" THEN LOCATE 23, 64: PRINT SPACE$(13): CALL move.hero
IF more$ = "y" THEN END
IF more$ <> "y" AND more$ <> "n" THEN GOTO over

skipy:
END SUB

SUB move.hero
z = 1

LOCATE y(z), x(z): PRINT CHR$(64)               '+ CHR$(95)
                                                'oops:
h$ = INPUT$(1)
LOCATE y(z), x(z): PRINT CHR$(0)

IF h$ = "k" THEN y(z) = y(z) - 1
IF h$ = "h" THEN x(z) = x(z) - 1
IF h$ = "l" THEN x(z) = x(z) + 1
IF h$ = "j" THEN y(z) = y(z) + 1
IF h$ = "y" THEN x(z) = x(z) - 1: y(z) = y(z) - 1
IF h$ = "u" THEN x(z) = x(z) + 1: y(z) = y(z) - 1
IF h$ = "b" THEN x(z) = x(z) - 1: y(z) = y(z) + 1
IF h$ = "n" THEN x(z) = x(z) + 1: y(z) = y(z) + 1

'IF h$ = "K" THEN
'IF h$ = "H" THEN
'IF h$ = "L" THEN
'IF h$ = "J" THEN
'IF h$ = "Y" THEN
'IF h$ = "U" THEN
'IF h$ = "B" THEN
'IF h$ = "N" THEN

'IF h$ = ">" THEN
'IF h$ = "w" THEN
IF h$ = "t" THEN CALL randomizer
IF h$ = "q" THEN CALL continue
'IF h$ = ">L" THEN

CALL boundary

END SUB

SUB move.robots

FOR z = 2 TO (numr + 1)
IF v(z) = 0 THEN GOTO skip
a = x(z) - x(1)
b = y(z) - y(1)

LOCATE y(z), x(z): PRINT CHR$(0)

IF a < 0 THEN x(z) = x(z) + 1
IF a > 0 THEN x(z) = x(z) - 1
IF b < 0 THEN y(z) = y(z) + 1
IF b > 0 THEN y(z) = y(z) - 1

LOCATE y(z), x(z): PRINT CHR$(43)
skip:
NEXT z

END SUB

SUB next.level

IF lev = 1 THEN numr = 10                 ' # of robots for each level
IF lev = 2 THEN numr = 20
IF lev = 3 THEN numr = 30
IF lev >= 4 THEN numr = 40

FOR x = 2 TO 59                         ' Clear the game arena
FOR y = 2 TO 22
LOCATE y, x: PRINT CHR$(0)
NEXT y
NEXT x

FOR z = 1 TO (numr + 1)                 ' Generate random positions
v(z) = 1
CALL randomizer
CALL boundary
NEXT z

FOR z = 2 TO (numr + 1)
LOCATE y(z), x(z): PRINT CHR$(43)
NEXT z

score = score + points

END SUB

SUB randomizer

RANDOMIZE TIMER
x(z) = CINT(RND * 59) + 1
y(z) = CINT(RND * 21) + 1

END SUB

SUB screen.layout

COLOR 7, 0
LOCATE 1, 1

PRINT "+-----------------------------------------------------------+ Directions:"
PRINT "|                                                           |"
PRINT "|                                                           | y k u"
PRINT "|                                                           |  \|/"
PRINT "|                                                           | h- -l"
PRINT "|                                                           |  /|\"
PRINT "|                                                           | b j n"
PRINT "|                                                           |"
PRINT "|                                                           | Commands:"
PRINT "|                                                           |"
PRINT "|                                                           |  w: wait for end"
PRINT "|                                                           |  t: teleport"
PRINT "|                                                           |  q: quit"
PRINT "|                                                           | ^L: redraw screen"
PRINT "|                                                           |"
PRINT "|                                                           | Legend:"
PRINT "|                                                           |"
PRINT "|                                                           |  +: robot"
PRINT "|                                                           |  *: junk heap"
PRINT "|                                                           |  @: you"
PRINT "|                                                           |"
PRINT "|                                                           |  Score:"
PRINT "+-----------------------------------------------------------+"

END SUB

SUB start.setup

score = 0                         'initialize var's
points = 0
lev = 1
numr = 10

name$ = "default"

CLS : CALL screen.layout          'build the screen
CALL next.level

END SUB

SUB status

' Keep track of the junk piles and score/points.

FOR m = 1 TO (numr + 1)
FOR n = (m + 1) TO (numr + 1)
IF x(m) = x(n) AND y(m) = y(n) THEN v(m) = 0: v(n) = 0
NEXT n
NEXT m

j = 0
FOR z = 2 TO (numr + 1)
IF v(z) = 0 THEN LOCATE y(z), x(z): PRINT CHR$(42)
j = j + v(z)
NEXT z

points = ((numr * 10) - (j * 10))
LOCATE 22, 70: PRINT (score + points)

IF v(1) = 0 THEN CALL continue
IF j = 0 THEN lev = lev + 1: CALL next.level

END SUB

