' -----------------------------
' Gouraud polygons, revisited. Get these things
' fast enough for animation, and you're in
' business.  Easier said than done.  With QBasic's
' inability to compute fixed numbers quickly (not
' to mention my inability to write an ASM program
' to do it) the best solution is simply to buy
' a faster computer.  :-)

' Written by M \ K Productions
' http://members.aol.com/mkwebsite/index.html
' -----------------------------

DECLARE SUB Delay (x!)
DECLARE SUB Fset (a%, b%, c%, d%)
DECLARE SUB SetPal ()
DECLARE SUB dumpedges ()
DECLARE SUB BuildEdges ()
DECLARE SUB ClearEdges ()
DECLARE SUB FillPolygon ()

CLS
SCREEN 13
DEFINT A-Z
RANDOMIZE TIMER
'$DYNAMIC

TYPE ptype
        x AS INTEGER
        y AS INTEGER
        c AS INTEGER
END TYPE

CONST NumPts = 2

DIM SHARED Polygon(NumPts) AS ptype  ' Polygon holds the rotated points

DIM SHARED Edges%(0 TO 320, 0 TO 1)
DIM SHARED ColEdges(0 TO 320, 0 TO 1) AS INTEGER

DIM SHARED XMin%, XMax%




DO
        'initialize random triangle
        FOR x% = 0 TO NumPts
                Polygon(x%).x = INT(RND * 320) + 1
                Polygon(x%).y = INT(RND * 190) + 10
                Polygon(x%).c = INT(RND * 64) + 1
        NEXT

        SetPal
        ClearEdges
        BuildEdges
        FillPolygon
        Delay .6
        LINE (0, 11)-(320, 199), 0, BF
LOOP UNTIL INKEY$ <> ""



CLS
SCREEN 0
WIDTH 80
SYSTEM

REM $STATIC
DEFSNG A-Z
SUB BuildEdges

        ' Find the x min and max values
        XMin% = 32767
        XMax% = -32767
        FOR x% = 0 TO 2
                IF Polygon(x%).x > XMax% THEN XMax% = Polygon(x%).x
                IF Polygon(x%).x < XMin% THEN XMin% = Polygon(x%).x
        NEXT


        ' Build a list of edges
        FOR Node% = 0 TO 2
              
                Pnt1% = Node%                 ' Calculate which two points of
                Pnt2% = (Node% + 1) MOD 3     ' the polygon to trace
              
                ' Sort the two X point values
              
               
                IF Polygon(Pnt1%).x > Polygon(Pnt2%).x THEN SWAP Pnt1%, Pnt2%

                x1% = Polygon(Pnt1%).x
                x2% = Polygon(Pnt2%).x
               
                y1% = Polygon(Pnt1%).y
                y2% = Polygon(Pnt2%).y
              
                c1% = Polygon(Pnt1%).c
                c2% = Polygon(Pnt2%).c
              

                XDelta% = x2% - x1%
                YDelta% = y2% - y1%
                CDelta% = c2% - c1%

               
                ' Calculate the Y slope (increment)
                IF XDelta% <> 0 THEN
                        YSlope! = YDelta% / XDelta%
                        CSlope! = CDelta% / XDelta%
                ELSE
                        YSlope! = 0
                        CSlope! = 0
                END IF
               
               
                YStep! = Polygon(Pnt1%).y
                CStep! = Polygon(Pnt1%).c
               
                ' Loop from x pos to next x pos, filling in edges with ystep
                FOR x% = x1% TO x2%
                       
                        IF Edges%(x%, 0) = -1 THEN
                                Edges%(x%, 0) = YStep!
                                ColEdges(x%, 0) = CStep!
                        ELSE
                        
                                IF YStep! > Edges%(x%, 1) THEN
                                        Edges%(x%, 1) = YStep!
                                        ColEdges(x%, 1) = CStep!
                                ELSEIF YStep! < Edges%(x%, 0) THEN
                                        Edges%(x%, 0) = YStep!
                                        ColEdges(x%, 0) = CStep!
                                END IF
                               
                                'IF CStep! > colEdges(x%, 1) THEN
                                '        colEdges(x%, 1) = CStep!
                                'ELSEIF CStep! < colEdges(x%, 0) THEN
                                '        colEdges(x%, 0) = CStep!
                                'END IF
                               
                                IF Edges%(x%, 0) > Edges%(x%, 1) THEN
                                        SWAP Edges%(x%, 1), Edges%(x%, 0)
                                        SWAP ColEdges(x%, 1), ColEdges(x%, 0)
                                END IF
                                
                        END IF
                       

                        IF ColEdges(x%, 0) = -1 THEN
                                'ColEdges(x%, 0) = CStep!
                        ELSE
                                'ColEdges(x%, 1) = CStep!
                        END IF

                        YStep! = YStep! + YSlope!
                        CStep! = CStep! + CSlope!
                        
                NEXT


        NEXT


END SUB

SUB ClearEdges
FOR x% = 0 TO 320
        Edges%(x%, 0) = -1: Edges%(x%, 1) = -1
        ColEdges(x%, 0) = -1: ColEdges(x%, 1) = -1
NEXT
END SUB

DEFINT A-Z
SUB Delay (x!)
c! = TIMER + x!
DO: LOOP UNTIL TIMER >= c!
END SUB

SUB dumpedges
a$ = INPUT$(1)
CLS
SCREEN 0
WIDTH 80
FOR x% = 0 TO 320
        IF Edges(x%, 0) <> -1 THEN
                PRINT Edges(x%, 0); Edges(x%, 1), x%
        END IF
NEXT
END SUB

DEFSNG A-Z
SUB FillPolygon
        FOR x% = XMin% TO XMax%
               
                
                CDelta% = ColEdges(x%, 1) - ColEdges(x%, 0)
                YDelta% = Edges%(x%, 1) - Edges%(x%, 0)
                Col! = ColEdges(x%, 0)

                IF YDelta% <> 0 THEN
                        CStep! = CDelta% / YDelta%
                ELSE
               
                END IF
                FOR y% = Edges%(x%, 0) TO Edges%(x%, 1)
                        PSET (x%, y%), Col!
                        Col! = Col! + CStep!
                NEXT
        NEXT
END SUB

DEFINT A-Z
SUB Fset (a%, b%, c%, d%)
OUT &H3C8, a%
OUT &H3C9, b%
OUT &H3C9, c%
OUT &H3C9, d%
END SUB

SUB SetPal
J% = INT(RND * 4) + 1
FOR x% = 1 TO 63
        SELECT CASE J%
                CASE 1: Fset x%, x%, 0, 0
                CASE 2: Fset x%, x%, x%, 0
                CASE 3: Fset x%, x%, x%, x%
                CASE 4: Fset x%, 0, x%, 0
                CASE 5: Fset x%, 0, x%, x%
                CASE 6: Fset x%, 0, 0, x%
                CASE 7: Fset x%, x%, 0, x%
        END SELECT
        LINE (x%, 0)-(x%, 10), x%
NEXT
END SUB

