'$DYNAMIC
'$INCLUDE: 'USELESS.BI'
DEFINT A-Z

REM $STATIC
FUNCTION USgetArraySizeFromBMP& (filename AS STRING)
'Returns the size of the buffer required to store a sprite directly from a BMP
DIM fh AS INTEGER, header AS BMPheadertype
fh = FREEFILE
OPEN filename FOR BINARY ACCESS READ AS #fh
IF LOF(fh) = 0 THEN
  CLOSE fh
  KILL filename
  USgetArraySizeFromBMP& = -1
  EXIT FUNCTION
END IF
GET #fh, , header
IF header.bpp <> 4 THEN
  CLOSE fh
  USgetArraySizeFromBMP& = -2
  EXIT FUNCTION
END IF
IF header.compression <> 0 THEN
  CLOSE fh
  USgetArraySizeFromBMP& = -3
  EXIT FUNCTION
END IF
CLOSE fh
USgetArraySizeFromBMP& = header.sizeHeight * header.SizeWidth + 1
END FUNCTION

FUNCTION USloadBMP (filename AS STRING, character AS INTEGER, destSegment AS INTEGER, destOffset AS INTEGER)
'Loads a 4BPP RGB BMP
DIM fh AS INTEGER, header AS BMPheadertype, falsePal AS STRING * 64, nbyte AS STRING * 1
fh = FREEFILE
OPEN filename FOR BINARY ACCESS READ AS #fh
IF LOF(fh) = 0 THEN
  CLOSE fh
  KILL filename
  USloadBMP = 1
  EXIT FUNCTION
END IF
GET #fh, , header
IF header.bpp <> 4 THEN
  CLOSE fh
  USloadBMP = 2
  EXIT FUNCTION
END IF
IF header.compression <> 0 THEN
  CLOSE fh
  USloadBMP = 3
  EXIT FUNCTION
END IF
USbumpUpPal
FOR a = 0 TO 15
  GET #fh, , nbyte
  blue = ASC(nbyte)
  IF blue > 0 THEN blue = INT(blue / 4)
  GET #fh, , nbyte
  green = ASC(nbyte)
  IF green > 0 THEN green = INT(green / 4)
  GET #fh, , nbyte
  red = ASC(nbyte)
  IF red > 0 THEN red = INT(red / 4)
  GET #fh, , nbyte
  USsetPal a + 16, red, green, blue
NEXT a
result = (header.DataSize / header.sizeHeight)
inbuffer$ = STRING$(result, " ")
FOR yy = header.sizeHeight TO 1 STEP -1
  GET #fh, , inbuffer$
  FOR xx = 1 TO header.SizeWidth STEP 2
    pixel = ASC(MID$(inbuffer$, ((xx + 1) / 2), 1))
    pixel2 = pixel AND 15
    pixel1 = INT((pixel - pixel2) / 16)
    USplaceElement xx, yy, character, pixel1, destSegment, destOffset
    IF xx + 1 < header.SizeWidth THEN USplaceElement xx + 1, yy, character, pixel2, destSegment, destOffset
  NEXT
NEXT
CLOSE fh
END FUNCTION

FUNCTION USloadPackedBMP% (filename AS STRING, destSegment AS INTEGER, destOffset AS INTEGER)
'Loads a 4BPP RGB BMP and packs the elements
'This function requires the use of USkillBlink and standard char 223
IF LEFT$(USdetectVideoHardware$, 1) <> "V" THEN
  USloadPackedBMP = 4
  EXIT FUNCTION
END IF
DIM fh AS INTEGER, header AS BMPheadertype, nbyte AS STRING * 1
fh = FREEFILE
OPEN filename FOR BINARY ACCESS READ AS #fh
IF LOF(fh) = 0 THEN
  CLOSE fh
  KILL filename
  USloadPackedBMP = 1
  EXIT FUNCTION
END IF
GET #fh, , header
IF header.bpp <> 4 THEN
  CLOSE fh
  USloadPackedBMP = 2
  EXIT FUNCTION
END IF
IF header.compression <> 0 THEN
  CLOSE fh
  USloadPackedBMP = 3
  EXIT FUNCTION
END IF
USbumpUpPal
FOR a = 0 TO 15
  GET #fh, , nbyte
  blue = ASC(nbyte)
  IF blue > 0 THEN blue = INT(blue / 4)
  GET #fh, , nbyte
  green = ASC(nbyte)
  IF green > 0 THEN green = INT(green / 4)
  GET #fh, , nbyte
  red = ASC(nbyte)
  IF red > 0 THEN red = INT(red / 4)
  GET #fh, , nbyte
  USsetPal a + 16, red, green, blue
NEXT a
result = (header.DataSize / header.sizeHeight)
inbuffer1$ = STRING$(result, " ")
inbuffer2$ = STRING$(result, " ")
yytemp = INT(header.sizeHeight / 2)
FOR yy = header.sizeHeight TO 1 STEP -2
  GET #fh, , inbuffer2$
  GET #fh, , inbuffer1$
  FOR xx = 1 TO header.SizeWidth STEP 2
    pixelspec1 = ASC(MID$(inbuffer1$, ((xx + 1) / 2), 1))
    pixelspec2 = ASC(MID$(inbuffer2$, ((xx + 1) / 2), 1))
    pixel12 = pixelspec1 AND 15
    pixel11 = INT((pixelspec1 - pixel12) / 16)
    pixel22 = pixelspec2 AND 15
    pixel21 = INT((pixelspec2 - pixel22) / 16)
    USplaceElement xx, yytemp, 223, pixel21 * 16 + pixel11, destSegment, destOffset
    IF xx + 1 < header.SizeWidth THEN USplaceElement xx + 1, yytemp, 223, pixel22 * 16 + pixel12, destSegment, destOffset
  NEXT
  yytemp = yytemp - 1
NEXT
CLOSE fh
END FUNCTION

