''
''  ugfrmwrk.bas - UGL template
''                 Best viewed in a text editor and NOT qb's IDE.
''
''         Note:   Add your code in the doMain sub where it says
''                 Your code here. This template automatically clears
''                 the screen. And as for the destination DC you use
''                 Env.hVideoDC.
''            
''
''

DEFINT A-Z
'$INCLUDE: '..\inc\ugl.bi'
'$INCLUDE: '..\inc\kbd.bi'
'$INCLUDE: '..\inc\font.bi'

CONST xRes = 320 * 1
CONST yRes = 240 * 1
CONST cFmt = UGL.8BIT
CONST FALSE = 0
CONST PAGES = 1


TYPE EnvType
	hFont       AS LONG
	hvideodc    AS LONG
	hTextrDC    AS LONG
	Keyboard    AS TKBD
	FPS         AS SINGLE
	ViewPage    AS INTEGER
	WorkPage    AS INTEGER
END TYPE


DECLARE SUB doMain ()
DECLARE SUB doInit ()
DECLARE SUB doTerminate ()
DECLARE SUB ExitError (msg AS STRING)
DECLARE SUB doRotate (pOut AS vector3f, ang AS SINGLE, pIn AS vector3f)
DECLARE SUB doTranslate (pOut AS vector3f, x AS SINGLE, y AS SINGLE, pIn AS vector3f)


	'' Your code goes in doMain ( )
	
	DIM SHARED Env AS EnvType
	
	doInit
	doMain
	doTerminate

SUB doInit

	'' Init UGL
	''
	IF (uglInit = FALSE) THEN
		ExitError "0x0000, UGL init failed..."
	END IF
	
	
	'' Set video mode with x pages where
	'' x = PAGES
	''
	Env.hvideodc = uglSetVideoDC(cFmt, xRes, yRes, PAGES)
	IF (Env.hvideodc = FALSE) THEN ExitError "0x0001, Could not set video mode..."
	
	
	'' Init keyboard handler
	''
	kbdInit Env.Keyboard
		
END SUB

SUB doMain
	STATIC vtx AS tritype, vtxb AS tritype
	STATIC frmCounter AS SINGLE, ang AS SINGLE
	STATIC tmrIni AS SINGLE, tmrEnd AS SINGLE
	
	vtx.v1.x = 0 - 128: vtx.v1.y = 0 - 128: vtx.v1.r = 1!: vtx.v1.g = 0!: vtx.v1.b = 0!
	vtx.v2.x = 255 - 128: vtx.v2.y = 0 - 128: vtx.v2.r = 0!: vtx.v2.g = 1!: vtx.v2.b = 0!
	vtx.v3.x = 0 - 128: vtx.v3.y = 255 - 128: vtx.v3.r = 1!: vtx.v3.g = 0!: vtx.v3.b = 1!
   
CONST border = 0
	DIM rc AS CLIPRECT
	rc.xMin = border: rc.yMin = 0'border
	rc.xMax = xRes - border: rc.yMax = yRes '- border
	uglSetClipRect Env.hvideodc, rc
	
	tmrIni = TIMER
	frmCounter = 0

	DO
		'' Wait for vsync
		'WAIT &H3DA, 8
		
		'' Page flipping   
		'uglSetVisPage Env.ViewPage
		'uglSetWrkPage Env.WorkPage
		
		'' Clear screen
		
		
		doRotate vtxb.v1, ang, vtx.v1
		doRotate vtxb.v2, ang, vtx.v2
		doRotate vtxb.v3, ang, vtx.v3
		doTranslate vtxb.v1, xRes / 2, yRes / 2, vtxb.v1
		doTranslate vtxb.v2, xRes / 2, yRes / 2, vtxb.v2
		doTranslate vtxb.v3, xRes / 2, yRes / 2, vtxb.v3
		
		'' -= Your code here =-
		''
		uglTriG Env.hvideodc, vtxb
		
		'' Update some frame counter
		'' etc etc   
		frmCounter = frmCounter + 1!
		Env.ViewPage = Env.WorkPage
		Env.WorkPage = (Env.WorkPage + 1) MOD PAGES
		
		IF (Env.Keyboard.plus) THEN
			uglClear Env.hvideodc, 0
			ang = ang + 1
		END IF
		
		IF ang >= 360 THEN ang = 0
		
	LOOP UNTIL (Env.Keyboard.Esc)
	
	tmrEnd = TIMER
	Env.FPS = frmCounter / (tmrEnd - tmrIni)
		
END SUB

SUB doRotate (pOut AS vector3f, ang AS SINGLE, pIn AS vector3f)
	CONST deg2rad# = 3.14159# / 180#
	
	pOut.r = pIn.r
	pOut.g = pIn.g
	pOut.b = pIn.b
	pOut.x = pIn.x * COS(ang * deg2rad#) - pIn.y * SIN(ang * deg2rad#)
	pOut.y = pIn.y * COS(ang * deg2rad#) + pIn.x * SIN(ang * deg2rad#)
	
END SUB

SUB doTerminate

	'' Terminate UGL
	''
	kbdEnd
	uglRestore
	uglEnd
	
	'' Print FPS
	CLS
	PRINT "Frames per second:" + STR$(CINT(Env.FPS))
		
END SUB

SUB doTranslate (pOut AS vector3f, x AS SINGLE, y AS SINGLE, pIn AS vector3f)

	pOut.r = pIn.r
	pOut.g = pIn.g
	pOut.b = pIn.b
	pOut.x = pIn.x + x
	pOut.y = pIn.y + y
	
END SUB

SUB ExitError (msg AS STRING)

	'' Terminate UGL
	'
	kbdEnd
	uglRestore
	uglEnd
	
	'' Print error message
	'' and end
	'
	PRINT "Error: " + msg
	END
	
END SUB

