.model medium, basic
.stack 40h
.386
.code

public VsFillPoly
public VsTexture
public VsTri
public VsWall
align 2

;===================The following is the source for Dash=====================
;==========================by 1998-2000 VirtuaSoft===========================

;=======This textures a triangle=============================================
;bp=tempread, bp+2=tempy, bp+4=tempx, bp+6=temp2
;bp+8=temp1, bp+10=v, bp+12=u, bp+14=dv
;bp+16=height, bp+18=width, bp+20=bp, bp+22=ds
;bp+24=QBoffset, bp+26=QBsegment
;bp+28=pixelvector, bp+30=offset2, bp+32=segment2
;bp+34=y3, bp+36=x3, bp+38=y2, bp+40=x2
;bp+42=y1, bp+44=x1, bp+46=offset1, bp+48=segment1
VsTri proc
      push ds
      push bp
      push eax                   ;width, height
      push eax                   ;dv, u
      push eax                   ;v, temp1
      push eax                   ;temp2, tempx
      push eax                   ;tempy, tempread
      mov bp, sp

      mov ds, [bp+48]            ;image segment
      mov es, [bp+32]            ;screen segment
      mov si, [bp+46]            ;image offset
      mov di, [bp+30]            ;screen offset

      ;***picheight% = pic%(1)***
      ;***picwidth% = pic%(0) \ 8***
      mov ax, [si+2]
      mov bx, [si]
      dec ax
      shr bx, 3
      mov [bp+16], ax            ;height
      mov [bp+18], bx            ;width

      inc ax
      mul bx
      dec ax
      mov fs, ax                 ;store last pixel offset

      ;***dx1% = x2% - x1% : dy1% = y2% - y1%***
      ;***dx2% = x3% - x1% : dy2% = y3% - y1%***
      mov cx, [bp+36]            ;x3
      mov ax, [bp+40]            ;x2
      mov dx, [bp+34]            ;y3
      mov bx, [bp+38]            ;y2

      sub cx, [bp+44]            ;x3-x1
      sub ax, [bp+44]            ;x2-x1
      sub dx, [bp+42]            ;y3-y1
      sub bx, [bp+42]            ;y2-y1

      ;***IF ABS(dy1%) > ABS(dx1%) THEN u% = ABS(dy1%) ELSE u% = ABS(dx1%)***
      ;***IF ABS(dy2%) > ABS(dx2%) THEN v% = ABS(dy2%) ELSE v% = ABS(dx2%)***
      cmp ax, 32768              ;is dx1<0?
      jb skipaxneg
      neg ax                     ;dx1=-dx1
   skipaxneg:
      cmp bx, 32768              ;is dy1<0?
      jb skipbxneg
      neg bx                     ;dy1=-dy1
   skipbxneg:
      cmp cx, 32768              ;is dx2<0?
      jb skipcxneg
      neg cx                     ;dx2=-dx2
   skipcxneg:
      cmp dx, 32768              ;is dy2<0?
      jb skipdxneg
      neg dx                     ;dy2=-dy2
   skipdxneg:

      mov [bp+12], ax            ;set u
      cmp ax, bx
      ja skipnewu
      mov [bp+12], bx
   skipnewu:
      ;***IF u% = 0 THEN EXIT SUB***
      cmp [bp+12], word ptr 0
      jnz notendtriu
      jmp endtri
   notendtriu:

      mov [bp+10], cx            ;set v
      cmp cx, dx
      ja skipnewv
      mov [bp+10], dx
   skipnewv:
      ;***IF v% = 0 THEN EXIT SUB***
      cmp [bp+10], word ptr 0
      jnz notendtriv
      jmp endtri
   notendtriv:

      mov eax, 1073758208      ;add 16K to Xs and Ys
      add [bp+42], eax
      add [bp+38], eax
      add [bp+34], eax

      add [bp+46], word ptr 4 ;increment image offset to pixel location

      ;***FOR temp1% = 0 TO v%***
      mov [bp+8], word ptr 0
   nexttemp1:

      ;******dv% = v% - temp1%***
      mov ax, [bp+10]
      sub ax, [bp+8]
      mov [bp+14], ax

      ;******tempx% = x3% * temp1% \ v% - x1% * temp1% \ v% + x1%***
      mov ax, [bp+36]      ;AX=x3%
      mul word ptr [bp+8]  ;AX=x3%*temp1%
      div word ptr [bp+10] ;AX=x3%*temp1%\v%
      mov [bp+4], ax       ;tempx%=x3%*temp1%\v%
      mov ax, [bp+44]      ;AX=x1%
      mul word ptr [bp+8]  ;AX=x1%*temp1%
      div word ptr [bp+10] ;AX=x1%*temp1%\v%
      sub ax, [bp+44]      ;AX=x1%*temp1%\v%-x1%
      sub [bp+4], ax       ;tempx%=tempx%-x1%*temp1%\v%+x1%


      ;******tempy% = y3% * temp1% \ v% - y1% * temp1% \ v% + y1%***
      mov ax, [bp+34]      ;AX=y3%
      mul word ptr [bp+8]  ;AX=y3%*temp1%
      div word ptr [bp+10] ;AX=y3%*temp1%\v%
      mov [bp+2], ax       ;tempy%=AX*temp1%
      mov ax, [bp+42]      ;AX=y1%
      mul word ptr [bp+8]  ;AX=y1%*temp1%
      div word ptr [bp+10] ;AX=y1%*temp1%\v%
      sub ax, [bp+42]      ;AX=y1%*temp1%\v%-y1%
      sub [bp+2], ax       ;tempy%=tempy%-y1%*temp1%\v%+y1%

      ;******tempread% = picwidth% * (picheight% * dv% \ v%)***
      mov ax, [bp+16]
      mul word ptr [bp+8]
      div word ptr [bp+10]
      mul word ptr [bp+18]
      mov [bp], ax

      ;******FOR temp2% = 0 TO u% * dv% \ v%***
      mov [bp+6], word ptr 0

      mov ax, [bp+12]            ;CX = u% * dv% \ v%
      mul word ptr [bp+14]
      div word ptr [bp+10]
      mov cx, ax
   nexttemp2:

      ;*********PSET (x2% * temp2% \ u% - x1% * temp2% \ u% + tempx%,...
      mov ax, [bp+40]      ;AX=x2%
      mul word ptr [bp+6]  ;AX=x2%*temp2%
      div word ptr [bp+12] ;AX=x2%*temp2%\u%
      mov bx, ax           ;BX=AX
      mov ax, [bp+44]      ;AX=x1%
      mul word ptr [bp+6]  ;AX=x1%*temp2%
      div word ptr [bp+12] ;AX=x1%*temp2%\u%
      sub bx, ax           ;BX=x2%*temp2%\u%-x1%*temp2%\u%
      add bx, [bp+4]       ;BX=x2%*temp2%\u%-x1%*temp2%\u%+tempx%
      sub bx, 16384
      cmp bx, 318
      ja skipdrawtri
      mov di, bx                 ;store x

      ;*********...y1% + y2% * temp2% \ u% - y1% * temp2% \ u% + tempy%),...
      mov ax, [bp+38]      ;AX=y2%
      mul word ptr [bp+6]  ;AX=y2%*temp2%
      div word ptr [bp+12] ;AX=y2%*temp2%\u%
      mov bx, ax           ;BX=AX
      mov ax, [bp+42]      ;AX=y1%
      mul word ptr [bp+6]  ;AX=y1%*temp2%
      div word ptr [bp+12] ;AX=y1%*temp2%\u%
      sub bx, ax           ;BX=y2%*temp2%\u%-y1%*temp2%\u%
      add bx, [bp+2]       ;BX=y2%*temp2%\u%-y1%*temp2%\u%+tempy%
      sub bx, 16384
      cmp bx, 199
      ja skipdrawtri
      mov dx, bx                 ;store y

      shl bx, 8
      add di, [bp+30]
      shl dx, 6
      add di, bx
      add di, dx           ;DI = x + 320 * y + offset

      ;*********...PEEK(picwidth% * temp2% \ u% + tempread% + VARPTR(pic%(2)))***
      mov ax, [bp+18]
      mul word ptr [bp+6]
      div word ptr [bp+12]
      add ax, [bp]
      cmp word ptr [bp+28], 1 ;read from opposite end of image
      jnz skipvector
      neg ax
      mov bx, fs
      add ax, bx
   skipvector:
      add ax, [bp+46]
      mov si, ax
      mov dl, [si]
      cmp dl, 0
      jz skipdrawtri
      mov dh, dl
      mov es:[di], dx            ;draw pixel

   skipdrawtri:
      ;******NEXT temp2%***
      mov ax, [bp+6]
      inc ax
      mov [bp+6], ax
      cmp ax, cx
      jng nexttemp2


      ;***NEXT temp1%***
      mov ax, [bp+8]
      inc ax
      cmp ax, [bp+10]
      jg endtri
      mov [bp+8], ax
      jmp nexttemp1

   endtri:
      pop eax
      pop eax
      pop eax
      pop eax
      pop eax
      pop bp
      pop ds
      ret 22
VsTri endp

;=======This textures a 4-sided polygon======================================
VsTexture proc
      push ds
      push bp
      xor eax, eax
      push eax                ;tempx, tempy
      push eax                ;width, height
      push eax                ;perx, pery
      push eax                ;perx2, pery2
      push eax                ;dxy^2
      push ax                 ;dxy
      mov bp, sp
      mov es, [bp+54]         ;es=VARSEG(pic(0))
      mov ds, [bp+34]         ;ds=screen segment
      mov di, [bp+52]         ;di=VARPTR(pic(0))
      mov fs, [bp+32]         ;fs=screen offset

      mov ax, es:[di]         ;width=pic(0)\8
      shr ax, 3
      mov [bp+16], ax
      add di, 2               ;height=pic(1)
      mov al, es:[di]
      mov [bp+14], al

      mov eax, 8388736        ;add 128 to Xs and Ys
      add [bp+48], eax
      add [bp+44], eax
      add [bp+40], eax
      add [bp+36], eax

      mov ax, [bp+50]         ;get DX
      mov bx, [bp+46]
      mov cx, [bp+42]
      mov dx, [bp+38]

      cmp ax, bx
      ja xmore
      xchg ax, bx
   xmore:
      cmp cx, dx             ;ax>bx
      ja xmore2
      xchg cx, dx
   xmore2:
      cmp ax, cx             ;cx>dx
      ja xmore3
      xchg ax, cx
   xmore3:
      cmp bx, dx             ;ax>cx
      ja xmore4
      xchg bx, dx
   xmore4:
      sub ax, dx             ;dx<bx
      mov [bp], ax

      mov ax, [bp+48]         ;get DY
      mov bx, [bp+44]
      mov cx, [bp+40]
      mov dx, [bp+36]

      cmp ax, bx
      ja ymore
      xchg ax, bx
   ymore:
      cmp cx, dx             ;ax>bx
      ja ymore2
      xchg cx, dx
   ymore2:
      cmp ax, cx             ;cx>dx
      ja ymore3
      xchg ax, cx
   ymore3:
      cmp bx, dx             ;AX>CX
      ja ymore4
      xchg bx, dx
   ymore4:
      sub ax, dx             ;DX<BX
      cmp ax, [bp]           ;get bigger of dx and dy
      jb yless
      mov [bp], ax
   yless:
      xor eax, eax
      add ax, [bp]
      jz endtext

      mul eax
      mov [bp+2], eax

   ;=====Outer loop (x)=====
   nexttextx:
      mov ax, [bp]
      sub ax, [bp+12]         ;perx2=dxy-perx
      mov [bp+8], ax

      mov word ptr [bp+10], 0 ;pery=0

      mov ax, [bp+48]         ;cx=y1*perx2
      mul word ptr [bp+8]
      mov cx, dx
      shl ecx, 16
      mov cx, ax
      mov ax, [bp+44]         ;ax=y2*perx
      mul word ptr [bp+12]
      mov bx, ax
      mov ax, dx
      shl eax, 16
      mov ax, bx
      add eax, ecx            ;ax=y1*perx2+y2*perx
      mov [bp+34], ax         ;store value

      mov ax, [bp+36]         ;cx=y4*perx2
      mul word ptr [bp+8]
      mov cx, dx
      shl ecx, 16
      mov cx, ax
      mov ax, [bp+40]         ;ax=y3*perx
      mul word ptr [bp+12]
      mov bx, ax
      mov ax, dx
      shl eax, 16
      mov ax, bx
      add eax, ecx            ;ax=y4*perx2+y3*perx
      mov [bp+54], ax         ;store value

   ;=====Inner loop (y)=====
   nexttexty:
      mov bx, [bp]
      sub bx, [bp+10]         ;pery2=dxy-pery
      mov [bp+6], bx

   ;=====Find Sprite Offset=====
      mov ax, [bp+16]         ;ax=width-1
      dec ax
      mul word ptr [bp+12]    ;ax*perx
      div word ptr [bp]       ;ax=(width-1)*perx/dxy
      mov cx, ax              ;save ax in cx
      mov ax, [bp+14]         ;ax=height-1
      dec ax
      mul word ptr [bp+10]    ;ax*pery
      div word ptr [bp]       ;ax=(height-1)*pery/dxy
      mul word ptr [bp+16]    ;ax=width*((height-1)*pery/dxy)
      add ax, 4               ;ax=ax+sprx+4+offset
      add ax, cx
      add ax, [bp+52]
      mov di, ax              ;di=total offset

   ;=====Find X=====
      xor eax, eax
      xor ebx, ebx
      mov ax, [bp+50]         ;cx=x1*pery2
      mul word ptr [bp+6]
      mov cx, dx
      shl ecx, 16
      mov cx, ax
      mov ax, [bp+38]         ;ax=x4*pery
      mov bx, [bp+10]
      mul ebx
      add eax, ecx            ;eax=x1*pery2+x4*pery
      mov bx, [bp+8]
      mul ebx
      mov ecx, eax            ;edx=(x1*pery2+x4*pery)*perx2

      xor eax, eax
      mov ax, [bp+46]         ;cx=x2*pery2
      mul word ptr [bp+6]
      mov si, dx
      shl esi, 16
      mov si, ax
      mov ax, [bp+42]         ;ax=x3*pery
      mul word ptr [bp+10]
      mov bx, ax
      mov ax, dx
      shl eax, 16
      mov ax, bx
      add eax, esi            ;eax=x2*pery2+x3*pery
      mov bx, [bp+12]
      mul ebx
      add eax, ecx            ;edx=edx+(x2*pery2+x3*pery)*perx
      div dword ptr [bp+2]    ;dx=((x1*pery2+x4*pery)*perx2+(x2*pery2+x3*pery)*perx)/16384
      mov [bp+20], ax         ;save x

   ;=====Find Y=====
      xor eax, eax
      mov ax, [bp+34]
      mov bx, [bp+6]
      mul ebx
      mov ecx, eax            ;edx=(y1*perx2+y2*perx)*pery2

      xor eax, eax
      mov ax, [bp+54]
      mov bx, [bp+10]
      mul ebx
      add eax, ecx            ;edx=(y4*perx2+y3*perx)*pery
      div dword ptr [bp+2]    ;dx=((y1*perx2+y2*perx)*pery2+(y4*perx2+y3*perx)*pery)/16384
      mov [bp+18], ax         ;save y

   ;=====Check Bounds=====
      sub ax, 128
      cmp ax, 199
      ja nexttexture          ;Is the Y on the screen?
      mov cx, [bp+20]
      sub cx, 128
      cmp cx, 319
      ja nexttexture          ;Is the X on the screen?

   ;=====Is the color 0?=====
      mov dh, es:[di]
      cmp dh, 0
      jz nexttexture

   ;=====Plot Pixel=====
      xor bl, bl
      mov bh, al              ;y*256
      shl ax, 6               ;+y*64
      add bx, ax              ;y*320+x
      add bx, cx
      mov si, fs              ;si=screen offset
      add si, bx

      cmp word ptr [bp+30], 0
      jz skipblend

      mov dl, [si]
      mov ch, dh
      and dl, 00011111b
      and ch, 00011111b

      add dl, ch              ;add shades
      sub dh, ch
      shr dl, 1               ;average shades
      add dh, dl              ;new pixel = averaged shades

   skipblend:
      mov [si], dh

   nexttexture:
      inc byte ptr [bp+10]    ;inc pery
      mov ax, [bp+10]
      cmp ax, [bp]            ;if pery=dxy then end yloop
      jge endtexty
      jmp nexttexty

   endtexty:
      inc byte ptr [bp+12]    ;inc perx
      mov ax, [bp+12]
      cmp ax, [bp]            ;if perx=dxy then end
      jge endtext
      jmp nexttextx

   endtext:
      pop eax
      pop eax
      pop eax
      pop eax
      pop eax
      pop ax
      pop bp
      pop ds

      ret 26
VsTexture endp

;=======This fills a 4-sided polygon=========================================
VsFillPoly proc
        push ds
        push bp
        xor eax, eax
        push eax                 ;tempx, tempy
        push eax                 ;perx, pery
        push eax                 ;perx2, pery2
        mov bp, sp
        mov ds, [bp+40]         ;ds=screen segment
        mov fs, [bp+38]         ;fs=screen offset

;=====Outer loop (x)=====
nextfillx:
        mov al, 128
        sub al, [bp+6]          ;perx2=128-perx
        mov [bp+2], al

        mov word ptr [bp+4], 0  ;pery=0

        mov ax, [bp+34]         ;cx=y1*perx2
        mul word ptr [bp+2]
        mov cx, ax
        mov ax, [bp+30]         ;ax=y2*perx
        mul word ptr [bp+6]
        add ax, cx              ;ax=y1*perx2+y2*perx
        mov [bp+8], ax          ;store value

        mov ax, [bp+22]         ;cx=y4*perx2
        mul word ptr [bp+2]
        mov cx, ax              ;(temporarily store ax here)
        mov ax, [bp+26]         ;ax=y3*perx
        mul word ptr [bp+6]
        add ax, cx              ;ax=y4*perx2+y3*perx
        mov [bp+38], ax         ;store value

;=====Inner loop (y)=====
nextfilly:
        mov bx, 128
        sub bl, [bp+4]      ;pery2=128-pery
        mov [bp], bx

;=====Find X=====
        xor eax, eax
        xor ebx, ebx
        xor ecx, ecx
        mov ax, [bp+36]         ;cx=x1*pery2
        mul word ptr [bp]
        mov cx, ax
        mov ax, [bp+24]         ;ax=x4*pery
        mul word ptr [bp+4]
        add eax, ecx            ;eax=x1*pery2+x4*pery
        mov bl, [bp+2]
        mul ebx
        mov ecx, eax            ;edx=(x1*pery2+x4*pery)*perx2

        xor eax, eax
        xor edx, edx
        mov ax, [bp+32]         ;cx=x2*pery2
        mul word ptr [bp]
        mov si, ax              ;(temporarily store ax here)
        mov ax, [bp+28]         ;ax=x3*pery
        mul word ptr [bp+4]
        mov dx, si              ;(retrieve value)
        add eax, edx            ;eax=x2*pery2+x3*pery
        mov bl, [bp+6]
        mul ebx
        add ecx, eax            ;edx=edx+(x2*pery2+x3*pery)*perx
        shr ecx, 14             ;dx=((x1*pery2+x4*pery)*perx2+(x2*pery2+x3*pery)*perx)/16384
        mov [bp+10], cx         ;save x

;=====Find Y=====
        xor eax, eax
        mov ax, [bp+8]
        mov bl, [bp]
        mul ebx
        mov ecx, eax            ;edx=(y1*perx2+y2*perx)*pery2

        xor eax, eax
        mov ax, [bp+38]
        mov bl, [bp+4]
        mul ebx
        add eax, ecx            ;edx=(y4*perx2+y3*perx)*pery
        shr eax, 14             ;dx=((y1*perx2+y2*perx)*pery2+(y4*perx2+y3*perx)*pery)/16384
        mov [bp+8], al          ;save y

;=====Check Bounds=====
        cmp ax, 199
        ja nextfillpoly
        mov cx, [bp+10]         ;Is the X on the screen?
        cmp cx, 319
        ja nextfillpoly

;=====Plot Pixel=====
        xor bl, bl
        mov bh, al              ;y*256
        shl ax, 6               ;+y*64
        add bx, ax              ;y*320+x
        add bx, cx
        mov si, fs              ;si=screen offset
        add si, bx
        mov dh, [bp+20]
        mov [si], dh

nextfillpoly:
        mov ax, [bp+4]          ;pery=pery+1
        inc al
        mov [bp+4], al
        cmp ax, 128             ;if pery=128 then end yloop
        jg endfilly
        jmp nextfilly

endfilly:
        mov ax, [bp+6]          ;perx=perx+1
        inc al
        mov [bp+6], al
        cmp ax, 128             ;if perx=128 then end
        jg endfill
        jmp nextfillx

endfill:
        pop eax
        pop eax
        pop eax
        pop bp
        pop ds
        ret 22
VsFillPoly endp

;=======This textures a wall tile============================================
;CX = tmpyi             SI = tmpfy              bp = dx
;bp+2 = tmpy2           bp+4 = tmpx2            bp+6 = tmpy
;bp+8 = tmpx            bp+10 = height          bp+12 = width
;bp+14 = bp             bp+16 = ds              bp+18 = return offset
;bp+20 = return segment bp+22 = offset2         bp+24 = segment2
;bp+26 = y4             bp+28 = y3              bp+30 = x2
;bp+32 = y2             bp+34 = y1              bp+36 = x1
;bp+38 = offset1        bp+40 = segment1
VsWall proc
        push ds
        push bp
        xor eax, eax
        push eax                        ;width +12, height +10
        push eax                        ;tmpx +8, tmpy +6
        push eax                        ;tmpx2 +4, tmpy2 +2
        push ax                         ;dx

        mov bp, sp

        ;***DEF SEG = VARSEG(pic(0))****
        mov es, [bp+40]                 ;image seg=VARSEG(pic)
        mov ds, [bp+24]                 ;scrn seg
        mov di, [bp+38]                 ;image off=VARPTR(pic)

        ;***width = pic(0) \ 8**********
        mov ax, es:[di]                 ;width=pic(0)\8
        shr ax, 3
        mov [bp+12], ax
        add di, 2

        ;***height = pic(1)*************
        mov ax, es:[di]                 ;height=pic(1)
        mov [bp+10], ax
        add di, 2

        mov ax, [bp+36]
        cmp ax, [bp+30]

        ;***IF x1 = x2 THEN END*********
        jz endwall

        ;***IF x1 > x2 THEN*************
        js skipswap

        ;******SWAP x1, x2**************
        mov ax, [bp+30]
        xchg [bp+36], ax
        mov [bp+30], ax
        ;******SWAP y1, y2**************
        mov ax, [bp+32]
        xchg [bp+34], ax
        mov [bp+32], ax
        ;******SWAP y3, y4**************
        mov ax, [bp+26]
        xchg [bp+28], ax
        mov [bp+26], ax

        ;***END IF**********************
skipswap:
        ;***dx = x2 - x1****************
        mov ax, [bp+30]
        sub ax, [bp+36]
        mov [bp], ax

        ;***FOR tmpx = 0 TO dx - 1******
wallloopx:
        ;******x1 = x1 + 1**************
        inc word ptr [bp+36]            ;next x

        cmp word ptr [bp+36], 319       ;is the x out of the screen?
        ja skipwallcolumn

        ;******tmpyi = (y1 * dx + tmpx * y2 - tmpx * y1) \ dx
        mov ax, [bp+34]
        mul word ptr [bp]
        mov cx, ax                      ;tmpyi=y1*dx

        mov ax, [bp+8]                  ;tmpx
        mul word ptr [bp+32]            ;tmpx*y2
        add cx, ax                      ;y1*dx+tmpx*y2

        mov ax, [bp+8]                  ;tmpx
        mul word ptr [bp+34]            ;tmpx*y1
        sub cx, ax                      ;y1*dx+tmpx*y2-tmpx*y1

        mov ax, cx
        div word ptr [bp]              ;\dx
        mov cx, ax                      ;tmpyi=(y1*dx+tmpx*y2-tmpx*y1)\dx

        ;******tmpyf = (y3 * dx + tmpx * y4 - tmpx * y3) \ dx
        mov ax, [bp+28]
        mul word ptr [bp]
        mov si, ax                      ;tmpyi=y3*dx

        mov ax, [bp+8]                  ;tmpx
        mul word ptr [bp+26]            ;tmpx*y4
        add si, ax                      ;tmpyi=y3*dx+tmpx*y4

        mov ax, [bp+8]                  ;tmpx
        mul word ptr [bp+28]            ;tmpx*y3
        sub si, ax                      ;tmpyi=y3*dx+tmpx*y4-tmpx*y3

        mov ax, si
        div word ptr [bp]               ;\dx
        mov si, ax                      ;tmpyi=(y3*dx+tmpx*y4-tmpx*y3)\dx

        ;******tmpy2 = tmpyf - tmpyi****
        mov [bp+2], si                  ;tmpy2=tmpyf
        sub [bp+2], cx                  ;tmpy2=tmpyf-tmpyi

        cmp word ptr [bp+2], 0
        jz skipwallcolumn

        ;******tmpx2 = VARPTR(pic(0)) + 4 + tmpx * width \ dx
        mov ax, [bp+8]                  ;tmpx
        mov [bp+4], di                  ;tmpx2=VARPTR(pic)+4
        mul word ptr [bp+12]            ;tmpx*width
        div word ptr [bp]               ;tmpx*width\dx
        add [bp+4], ax                  ;tmpx2=VARPTR(pic)+4+tmpx*width\dx

        ;******FOR tmpy = 0 TO tmpy2 - 1
        mov word ptr [bp+6], 0
wallloopy:
        ;*********tmpyi = tmpyi + 1*****
        inc cx                          ;next y

        cmp cx, 199                     ;is the y outside the screen?
        jg nextwally                    ;       yes

        ;*********DL = PEEK(tmpx2 + wd * (tmpy * height \ tmpy2))
        mov ax, [bp+6]                  ;tmpy
        mul word ptr [bp+10]            ;tmpy*height
        div word ptr [bp+2]             ;tmpy*height\tmpy2
        mov bx, [bp+4]                  ;tmpx2
        mul word ptr [bp+12]            ;width*(tmpy*height\tmpy2)
        add bx, ax                      ;tmpx2+width*(tmpy*height\tmpy2)

        mov dl, es:[bx]                 ;get pixel
        cmp dl, 0                       ;is it color 0?
        jz nextwally                    ;       yes

        ;*********PSET (x1, tmpyi), DL**
        mov ax, cx                      ;y
        xor bl, bl
        mov bh, al                      ;y*256
        shl ax, 6                       ;y*64
        add bx, ax                      ;y*320
        add bx, [bp+22]                 ;y*320+offset2
        add bx, [bp+36]                 ;y*320+offset2+x1
        mov ds:[bx], dl                 ;plot texel

        ;******NEXT Y******
nextwally:
        inc word ptr [bp+6]             ;tmpy=tmpy+1
        mov ax, [bp+2]                  ;AX=tmpy2
        cmp word ptr [bp+6], ax         ;is tmpy<tmpy2?
        js wallloopy                    ;       yes

        ;***NEXT X******
skipwallcolumn:
        inc word ptr [bp+8]             ;tmpx=tmpx+1
        mov ax, [bp]                    ;AX=dx
        cmp [bp+8], ax                  ;is tmpx<dx?
        js wallloopx                    ;       yes

endwall:
        pop eax
        pop ax
        pop eax
        pop eax
        pop bp
        pop ds
        ret 20
VsWall endp

end
