.model medium, basic
.stack 20h
.386
.code

public VSParaStar
public VSPoint
public VSPset

;===================The following is the source for Dash=====================
;==========================by 1998-2000 VirtuaSoft===========================

;=======This plots a pixel===================================================
VSPset proc
      mov cx, bp
      mov bp, sp

      mov al, [bp+6]          ;retrieve y
      mov bx, [bp+10]         ;add offset
      xor ah, ah
      mov dl, [bp+4]          ;retrieve color
      add bh, al              ;move y*256 into bx
      shl ax, 6               ;y = y*64
      add bx, [bp+8]          ;add x to total
      mov es, [bp+12]         ;graphics segment
      add bx, ax              ;bx = bx + y*64
      mov es:[bx], dl         ;draw pixel

      mov bp, cx
      ret 10
VSPset endp

;=======This reads a pixel===================================================
VSPoint proc
      mov cx, bp
      mov bp, sp

      mov ax, [bp+4]          ;retrieve y
      mov bx, [bp+8]          ;offset
      add bh, al              ;move y*256 into bx
      shl ax, 6               ;y = y*64
      add bx, ax              ;bx = bx + y*64
      mov es, [bp+10]         ;graphics segment
      xor ah, ah
      add bx, [bp+6]          ;add x to total
      mov al, es:[bx]         ;save pixel

      mov bp, cx
      ret 8
VSPoint endp

;=======This places a layer of pixels========================================
VSParastar proc
      push ds
      push bp
      mov bp, sp              ;bx = Stack pointer 
      mov ds, [bp+10]         ;graphics segment
      mov es, [bp+20]         ;VARSEG

      xor cx, cx
      mov di, [bp+18]         ;VARPTR
      mov dl, [bp+12]         ;retrieve color

   nextstar:
      mov si, es:[di]         ;array x
      add si, [bp+16]

      cmp si, 320             ;is x > 319?
      js dontdecx             ;if not, skip this
      sub si, 320             ;else sub 320 from x
   dontdecx:

      add di, 2
      mov ax, es:[di]         ;array y
      add cx, 2
      add ax, [bp+14]         ;add y

      cmp ax, 200             ;is y > 199?
      js dontdecy             ;if not, skip this
      sub ax, 200             ;else sub 200 from y
   dontdecy:
      mov bh, al              ;move y*256 into bx
      shl ax, 6               ;y = y*64
      add bx, ax              ;bx = bx + y*64
      add si, bx
      xor bl, bl
      add si, [bp+8]          ;varptr
      mov [si], dl            ;draw pixel

      add cx, 2
      add di, 2
      cmp cx, 400
      js nextstar             ;continue loop

      pop bp
      pop ds
      ret 14
VSParastar endp

end
