.model medium, basic
.stack 12h
.386
.code

public MouseDriver
public MouseOn
public MouseOff
public MouseX
public MouseY
public MouseL
public MouseR
public MouseSetXY
public MouseSetBounds
public MouseClickInBox ;(x1, y1, x2, y2)
public MouseClickOutBox ;(x1, y1, x2, y2)
public MouseOverBox ;(x1, y1, x2, y2)
public JoyButton ;(button)
public JoyStickX
public JoyStickY

;===================The following is the source for Dash=====================
;==========================by 1998-2000 VirtuaSoft===========================

;===============This tests for the mouse driver==============================
MouseDriver proc
      xor ax, ax      ;check for driver
      int 33H
      ret
MouseDriver endp

;===============This shows the mouse cursor==================================
MouseOn proc
      mov ax, 1       ;turn on mouse cursor
      int 33H
      ret
MouseOn endp

;===============This hides the mouse cursor==================================
MouseOff proc
      mov ax, 2       ;turn off mouse cursor
      int 33H
      ret
MouseOff endp

;===============This returns the mouse x-coord===============================
MouseX proc
      mov ax, 3       ;check for x
      int 33H
      shr cx, 1
      mov ax, cx
      ret
MouseX endp

;===============This returns the mouse y-coord===============================
MouseY proc
      mov ax, 3       ;check for y
      int 33H
      mov ax, dx
      ret
MouseY endp

;===============This returns the mouse left press============================
MouseL proc
      mov ax, 3       ;check for left button press
      int 33H
      and bx, 1
      mov ax, bx
      ret
MouseL endp

;===============This returns the mouse right press===========================
MouseR proc
      mov ax, 3       ;check for left button press
      int 33H
      and bx, 2
      shr bx, 1
      mov ax, bx
      ret
MouseR endp

;===============This sets the mouse coords===================================
MouseSetXY proc
      mov bx, bp

      mov ax, 4
      mov bp, sp
      mov cx, [bp+6]  ;x
      shl cx, 1
      mov dx, [bp+4]  ;y
      int 33H
      mov bp, bx
      ret 4
MouseSetXY endp

;===============This sets the mouse coord bounds=============================
MouseSetBounds proc
      mov bx, bp
      mov ax, 7
      mov bp, sp
      mov cx, [bp+10] ;min x
      mov dx, [bp+6]  ;max x
      shl cx, 1
      shl dx, 1
      int 33H
      inc al
      mov cx, [bp+8]  ;min y
      mov dx, [bp+4]  ;max y
      int 33H
      mov bp, bx
      ret 8
MouseSetBounds endp

;===============This returns if the mouse clicked in a box or not============
MouseClickInBox proc    ;14, 12, 10, 8
      push ds
      push bp
      mov ax, 3       ;check for info
      int 33H
      mov bp, sp

      xor ax, ax
      shr cx, 1       ;x
      cmp cx, [bp+14]
      js endinbox
      cmp cx, [bp+10]
      jg endinbox
      cmp dx, [bp+12]
      js endinbox
      cmp dx, [bp+8]
      jg endinbox

      mov ax, bx
      and ax, 0fffdh

   endinbox:
      pop bp
      pop ds
      ret 8
MouseClickInBox endp

;===============This returns if the mouse clicked out of a box or not========
MouseClickOutBox proc    ;14, 12, 10, 8
      push ds
      push bp
      mov ax, 3       ;check for info
      int 33H
      mov bp, sp

      mov ax, bx
      and ax, 0fffdh

      shr cx, 1       ;x
      cmp cx, [bp+14]
      js endoutbox
      cmp cx, [bp+10]
      jg endoutbox
      cmp dx, [bp+12]
      js endoutbox
      cmp dx, [bp+8]
      jg endoutbox
        
      xor ax, ax

   endoutbox:
      pop bp
      pop ds
      ret 8
MouseClickOutBox endp

;===============This returns if the mouse is over a box or not===============
MouseOverBox proc    ;14, 12, 10, 8
      push ds
      push bp
      mov ax, 3       ;check for info
      int 33H
      mov bp, sp

      xor ax, ax
      shr cx, 1       ;x
      cmp cx, [bp+14]
      js endoverbox
      cmp cx, [bp+10]
      jg endoverbox
      cmp dx, [bp+12]
      js endoverbox
      cmp dx, [bp+8]
      jg endoverbox
        
      mov ax, 1

   endoverbox:
      pop bp
      pop ds
      ret 8
MouseOverBox endp

;===============This tells if a gamepad button is pressed====================
JoyButton proc
      mov di, bp
      mov bp, sp
      xor ah, ah           ;clear upper byte

      mov cl, [bp+4]       ;BX=buttonnum%
      mov bl, 1
      dec cl
      shl bl, cl           ;set bit in CL corresponding to buttonnum%

      mov dx, 201h         ;read value from port
      in al, dx
      not al
      shr al, 4            ;set lower 4 bits to buttons

      and al, bl
      shr al, cl
      mov bp, di
      ret 2
JoyButton endp

;===============This returns the X-axis value================================
JoyStickX proc
      cli
      xor bx, bx           ;clear counter
      mov dx, 201h
   stickx:
      out dx, al
      inc bx               ;increment counter
      cmp bx, 0ffffh
      jz endstickx
      in al, dx
      and al, 1            ;test x-axis
      cmp al, 0
      jnz stickx
   endstickx:
      mov ax, bx           ;return counter
      sti
      ret
JoystickX endp

;===============This returns the Y-axis value================================
JoyStickY proc
      cli
      xor bx, bx           ;clear counter
      mov dx, 201h
   sticky:
      out dx, al
      inc bx               ;increment counter
      cmp bx, 0ffffh
      jz endsticky
      in al, dx
      and al, 2            ;test y-axis
      cmp al, 0
      jnz sticky
   endsticky:
      mov ax, bx           ;return counter
      sti
      ret
JoystickY endp

end
