.model medium
.stack 12h
.386
.code

;===================The following is the source for Dash=====================
;==========================by 1998-2000 VirtuaSoft===========================

public MouseDriver
MouseDriver proc
        xor ax, ax      ;check for driver
        int 33H
        ret
MouseDriver endp

public MouseOn
MouseOn proc
        mov ax, 1       ;turn on mouse cursor
        int 33H
        ret
MouseOn endp

public MouseOff
MouseOff proc
        mov ax, 2       ;turn off mouse cursor
        int 33H
        ret
MouseOff endp

public MouseInfo
MouseInfo proc
        push ds
        push bp
        mov ax, 3       ;check for info
        int 33H
        mov bp, sp

        mov ds, [bp+18] ;varseg(button%)
        mov si, [bp+16] ;varptr(button%)
        mov [si], bx

        mov ds, [bp+14] ;varseg(x%)
        mov si, [bp+12] ;varptr(x%)
        shr cx, 1
        mov [si], cx

        mov ds, [bp+10] ;varseg(y%)
        mov si, [bp+8]  ;varptr(y%)
        mov [si], dx

        pop bp
        pop ds
        ret 12
MouseInfo endp

public MouseSetXY
MouseSetXY proc
        mov bx, bp

        mov ax, 4
        mov bp, sp
        mov cx, [bp+6]  ;x
        shl cx, 1
        mov dx, [bp+4]  ;y
        int 33H
        mov bp, bx
        ret 4
MouseSetXY endp

public MouseSetBounds
MouseSetBounds proc
        mov bx, bp
        mov ax, 7
        mov bp, sp
        mov cx, [bp+10] ;min x
        mov dx, [bp+6]  ;max x
        shl cx, 1
        shl dx, 1
        int 33H
        inc al
        mov cx, [bp+8]  ;min y
        mov dx, [bp+4]  ;max y
        int 33H
        mov bp, bx
        ret 8
MouseSetBounds endp

public MouseClickInBox  ;x1, y1, x2, y2
MouseClickInBox proc    ;14, 12, 10, 8
        push ds
        push bp
        mov ax, 3       ;check for info
        int 33H
        mov bp, sp

        xor ax, ax

        shr cx, 1       ;x
        cmp cx, [bp+14]
        js endinbox
        cmp cx, [bp+10]
        jg endinbox
        cmp dx, [bp+12]
        js endinbox
        cmp dx, [bp+8]
        jg endinbox

        mov ax, bx
        and ax, 0fffdh

endinbox:
        pop bp
        pop ds
        ret 8
MouseClickInBox endp

public MouseClickOutBox  ;x1, y1, x2, y2
MouseClickOutBox proc    ;14, 12, 10, 8
        push ds
        push bp
        mov ax, 3       ;check for info
        int 33H
        mov bp, sp

        mov ax, bx
        and ax, 0fffdh

        shr cx, 1       ;x
        cmp cx, [bp+14]
        js endoutbox
        cmp cx, [bp+10]
        jg endoutbox
        cmp dx, [bp+12]
        js endoutbox
        cmp dx, [bp+8]
        jg endoutbox
        
        xor ax, ax

endoutbox:
        pop bp
        pop ds
        ret 8
MouseClickOutBox endp

public MouseOverBox  ;x1, y1, x2, y2
MouseOverBox proc    ;14, 12, 10, 8
        push ds
        push bp
        mov ax, 3       ;check for info
        int 33H
        mov bp, sp

        xor ax, ax

        shr cx, 1       ;x
        cmp cx, [bp+14]
        js endoverbox
        cmp cx, [bp+10]
        jg endoverbox
        cmp dx, [bp+12]
        js endoverbox
        cmp dx, [bp+8]
        jg endoverbox
        
        mov ax, 1

endoverbox:
        pop bp
        pop ds
        ret 8
MouseOverBox endp

end
