'$INCLUDE: '\Prog\Forward\LIB\MTimer\MTimerA.bi'
DECLARE FUNCTION RAMValue% ()
DECLARE FUNCTION TestRnd% ()
DECLARE SUB Test1 ()
DECLARE SUB Test2 (Seconds#)
DEFINT A-Z
'$INCLUDE: '\Prog\Forward\LIB\MTimer\MTimer.bi'
'   Filename: MTimerT.bas
'      Title: MTimer Test
'Description: Test Framework for MTimer.
'     Author: Antoni Gual [AG] and Peter Fedorow [PF]
'    Contact: AG - agual AT eic.ictnet.es
'    Contact: PF - fedorowp AT yahoo.com / fedorowp AT earthlink.net
'  Copyright: 2003 Antoni Gual, 2003 Peter Fedorow
'    Started: 2002 Mar 15
'Last Change: 2003 Jun 02 Mon
'    History: 2003 May 25 Sun  Split off from MTimer.
'    History: 2003 Jun 02 Mon  Added random number generator test.


  CONST False = 0
  CONST True = NOT False

  'CLS
  'Test1
  'Test2 .5
  'Test2 1
  'Test2 5

  'Discard = TestRnd
  'FOR A = 1 TO 30
  '  PRINT TestRnd;
  'NEXT A

  
  OPEN "Bytes.rnd" FOR BINARY AS #1
  'FOR ByteCount& = 1 TO 32768
  FOR ByteCount& = 1 TO 1048576
    Bytes = TestRnd
    Byte$ = CHR$(Bytes)
    PUT #1, , Byte$
  NEXT ByteCount&
  CLOSE #1

FUNCTION RAMValue ()

  STATIC RAMIndex, Segment&


  DEF SEG = Segment&
  RAMValue = PEEK(RAMIndex)
  DEF SEG

  RAMIndex = RAMIndex + 1

  IF RAMIndex = 256 THEN
    RAMIndex = 0
    Segment& = Segment& + 1
    IF Segment& = 65536 THEN
      Segment& = 0
    END IF
  END IF

END FUNCTION

SUB Test1 ()

  CountTimes = 3000

  FOR TestCount = 1 TO 3
    dtimer& = 0
    ltimer& = TimerRead&
    'Call TimerRead CountTimes times.
    FOR I = 1 TO CountTimes
      tim& = TimerRead&
      dtimer& = dtimer& + (tim& - ltimer&)
      SWAP ltimer&, tim&
    NEXT I

    'Time the empty loop.
    dtimer1& = 0
    xtimer& = TimerRead&
    lt1& = 1&

    FOR I = 1 TO CountTimes
      tim& = 1&
      dt1& = dt1& + tim& - lt1&
      SWAP lt1&, tim&
    NEXT I

    'Substract empty loop time.
    dtimer& = dtimer& - TimerRead& + ltimer&
    PRINT USING "A call to TimerRead needs##.#### milliseconds.  (Averaged over #### calls.)"; dtimer& * SecsPerTick# * 1000 / CountTimes; CountTimes
  NEXT TestCount


  'Do a TimerDelay
  '---------------
  PRINT
  PRINT "Delaying for 0.5 seconds: "
  A = 0
  T& = TimerRead&

  'Initialize TimerDelay.
  THandle = TimerAlarmSet(.5)

  'Do work as you wait for the delay.
  DO UNTIL TimerAlarmPoll(THandle)
    'Do anything you want during the delay loop.
    Count& = Count& + 1
    LOCATE , 3
    PRINT "Doing stuff:"; Count&;
  LOOP

  ElapsedTime# = (TimerRead& - T&) * SecsPerTick#
  PRINT
  PRINT "TimerAlarmPoll was called"; Count&; "times in"; ElapsedTime#; "seconds."
  PRINT

END SUB

SUB Test2 (Seconds#)

  PRINT "Start"; Seconds#; "second delay."

  StartTime& = TimerRead&
  THandle = TimerAlarmSet(Seconds#)
  StopTime& = TimerRead&
  DO UNTIL TimerAlarmPoll(THandle)
    Count& = Count& + 1
    LOCATE , 2
    PRINT "Doing stuff: "; Count&;
    StopTime& = TimerRead&
  LOOP


  ElapsedTime# = (StopTime& - StartTime&) * SecsPerTick#
  PRINT
  PRINT "TimerAlarmPoll was called"; Count&; "times in"; ElapsedTime#; "seconds."
  PRINT

END SUB

FUNCTION TestRnd ()
'Timer entropy based random number generator.

  STATIC SampleTime&
  STATIC PrevElapsed&


  PowerTwo = 1


  FOR BitIndex = 1 TO 8

    'FOR Sample = 1 TO 19
    '  NewSampleTime& = TimerRead&
    '  Elapsed& = NewSampleTime& - SampleTime&
    '  SWAP NewSampleTime&, SampleTime&
    '  Bit = Bit XOR (Elapsed& > PrevElapsed&)
    '  SWAP PrevElapsed&, Elapsed&
    '  RAMEntropy = RAMEntropy XOR RAMValue
    'NEXT Sample

    FOR Sample = 1 TO 41
      PITReadTicks TicksHi, TicksLo
      Entropy = Entropy XOR TicksHi XOR TicksLo XOR RAMValue
    NEXT Sample

    'Entropy = ((-Bit XOR RAMEntropy) + NewSampleTime&) MOD 256
    Byte = (Byte XOR (Entropy * PowerTwo)) MOD 256
    PowerTwo = PowerTwo + PowerTwo

  NEXT BitIndex
  
  
  TestRnd = Byte

END FUNCTION

