'
' NeoLib.bi
' This BI File was automatically composed by:
'   biMerge.exe,  by Neo Deus Ex Machina
'

'
' NeoLib - Calls Module
'
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'

'***
' QB.BI - Assembly Support Include File
'
'       Copyright <C> 1987 Microsoft Corporation
'
' Purpose:
'      This include file defines the types and gives the DECLARE
'       statements for the assembly language routines ABSOLUTE,
'       INTERRUPT, INTERRUPTX, INT86OLD, and INT86XOLD.
'
'***************************************************************************
'
' Define the type needed for INTERRUPT
'
TYPE RegType
     ax    AS INTEGER
     bx    AS INTEGER
     cx    AS INTEGER
     dx    AS INTEGER
     bp    AS INTEGER
     si    AS INTEGER
     di    AS INTEGER
     flags AS INTEGER
END TYPE
'
' Define the type needed for INTERUPTX
'
TYPE RegTypeX
     ax    AS INTEGER
     bx    AS INTEGER
     cx    AS INTEGER
     dx    AS INTEGER
     bp    AS INTEGER
     si    AS INTEGER
     di    AS INTEGER
     flags AS INTEGER
     ds    AS INTEGER
     es    AS INTEGER
END TYPE
'
'                 DECLARE statements for the 5 routines
'                 -------------------------------------
'
' Generate a software interrupt, loading all but the segment registers
'
DECLARE SUB INTERRUPT (intnum AS INTEGER,inreg AS RegType,outreg AS RegType)
'
' Generate a software interrupt, loading all registers
'
DECLARE SUB INTERRUPTX (intnum AS INTEGER,inreg AS RegTypeX, outreg AS RegTypeX)
'
' Call a routine at an absolute address.
' NOTE: If the routine called takes parameters, then they will have to
'       be added to this declare statement before the parameter given.
'
'DECLARE SUB ABSOLUTE (address AS INTEGER)
'
' Generate a software interrupt, loading all but the segment registers
'       (old version)
'
DECLARE SUB INT86OLD (intnum AS INTEGER,inarray(1) AS INTEGER,outarray(1) AS INTEGER)
'
' Gemerate a software interrupt, loading all the registers
'       (old version)
'
DECLARE SUB INT86XOLD (intnum AS INTEGER,inarray(1) AS INTEGER,outarray(1) AS INTEGER)


'$DYNAMIC
DEFINT A-Z

'
' NeoLib - Main Module
'
' Features:
'  2 subs
'  1 functions
' For a total of: 3 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'

'DECLARE FUNCTION neoInit (Layers AS INTEGER)

'DECLARE SUB neoClose ()
'DECLARE SUB neoFFix ()

'CONST FALSE = 0, TRUE = NOT FALSE


'
' NeoLib - EMS Module
'
' Features:
'  6 subs
'  9 functions
' For a total of: 15 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'


DECLARE FUNCTION neoEMSexist% ()
DECLARE FUNCTION neoEMSpageFrame% ()
DECLARE FUNCTION neoEMSversion$ ()
DECLARE FUNCTION neoEMSfreePages% ()
DECLARE FUNCTION neoEMStotalPages% ()
DECLARE FUNCTION neoEMSfreeHandles% ()
DECLARE FUNCTION neoEMSisError% ()
DECLARE FUNCTION neoEMSgetErrorMsg$ ()
DECLARE FUNCTION neoEMSalloc% (NoPages AS INTEGER)

DECLARE SUB neoEMSdealloc (Handle AS INTEGER)
DECLARE SUB neoEMSrealloc (Handle AS INTEGER, NoPages AS INTEGER)
DECLARE SUB neoEMSmap (LogicalPage AS INTEGER, PhysicalPage AS INTEGER, Handle AS INTEGER)
DECLARE SUB neoEMSmapX (LogicalOffset AS INTEGER, PhysicalOffset AS INTEGER, NoPages AS INTEGER, Handle AS INTEGER)
DECLARE SUB neoEMSmove (SrcHandle AS INTEGER, SrcSegmentOrPage AS INTEGER, SrcOffset AS INTEGER, DstHandle AS INTEGER, DstSegmentOrPage AS INTEGER, DstOffset AS INTEGER, DataLength AS LONG)
DECLARE SUB neoEMSexchange (SrcHandle AS INTEGER, SrcSegmentOrPage AS INTEGER, SrcOffset AS INTEGER, DstHandle AS INTEGER, DstSegmentOrPage AS INTEGER, DstOffset AS INTEGER, DataLength AS LONG)



'
' NeoLib - VXMS Module
'
' Features:
'  6 subs
'  3 functions
' For a total of: 9 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'
DECLARE FUNCTION neoVXMSinit% ()
DECLARE FUNCTION neoVXMSalloc% (KBytes AS LONG)
DECLARE FUNCTION neoVXMSfree& ()

DECLARE SUB neoVXMSdealloc (Handle AS INTEGER)
DECLARE SUB neoVXMSrealloc (Handle AS INTEGER, KBytes AS LONG)
DECLARE SUB neoVXMSread (Handle AS INTEGER, Offset AS LONG, DataLength AS LONG, BufferSeg AS INTEGER, BufferOff AS INTEGER)
DECLARE SUB neoVXMSwrite (BufferSeg AS INTEGER, BufferOff AS INTEGER, Handle AS INTEGER, Offset AS LONG, DataLength AS LONG)
DECLARE SUB neoVXMSmove (FirstHandle AS INTEGER, FirstOffset AS LONG, SecondHandle AS INTEGER, SecondOffset AS LONG, DataLength AS LONG)
DECLARE SUB neoVXMSexchange (FirstHandle AS INTEGER, FirstOffset AS LONG, SecondHandle AS INTEGER, SecondOffset AS LONG, DataLength AS LONG)


'
' NeoLib - Layer Module
'
' Features:
'  13 subs
'  2 functions
' For a total of: 15 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'

DECLARE FUNCTION neoLayerGetHandle% ()
DECLARE FUNCTION neoLayerCreate% (NoLayers AS INTEGER)

DECLARE SUB neoLayerRemove ()
DECLARE SUB neoLayerCopy (SrcLayer AS INTEGER, DstLayer AS INTEGER)
DECLARE SUB neoLayerCopyTrans (SrcLayer AS INTEGER, DstLayer AS INTEGER, TransCol AS INTEGER)
DECLARE SUB neoLayerClear (Layer AS INTEGER, Colour AS INTEGER)
DECLARE SUB neoLayerExchange (SrcLayer AS INTEGER, DstLayer AS INTEGER)
DECLARE SUB neoLayerMirror (Layer AS INTEGER, HorVerBits AS INTEGER)
DECLARE SUB neoLayerFilter (Layer AS INTEGER, FromCol AS INTEGER, ToCol AS INTEGER)
DECLARE SUB neoLayerSave (Layer AS INTEGER, Filename AS STRING)
DECLARE SUB neoLayerLoad (Layer AS INTEGER, Filename AS STRING)
DECLARE SUB neoLayerCopyColor (SrcLayer AS INTEGER, DstLayer AS INTEGER, TransCol AS INTEGER, ReplaceCol AS INTEGER)
DECLARE SUB neoLayerCopyForward (SrcLayer AS INTEGER, DstLayer AS INTEGER, CheckCol AS INTEGER, TransCol AS INTEGER)
DECLARE SUB neoLayerCopyBlend (SrcLayer AS INTEGER, DstLayer AS INTEGER, StdPal AS STRING)
DECLARE SUB neoLayerLighting (Layer AS INTEGER, LightFactor AS INTEGER, StdPal AS STRING)


CONST VIDEO = 0
CONST HORIZONTAL = 1, VERTICAL = 2



'
' NeoLib - Drawing Primitives Module
'
' Features:
'  16 subs
'  1 function
' For a total of: 17 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'
DECLARE FUNCTION neoDrawPoint% (Layer AS INTEGER, fromX AS INTEGER, fromY AS INTEGER)

DECLARE SUB neoDrawInitLayers ()
DECLARE SUB neoDrawSetClipBox (X1 AS INTEGER, Y1 AS INTEGER, X2 AS INTEGER, Y2 AS INTEGER)
DECLARE SUB neoDrawPixel (Layer AS INTEGER, toX AS INTEGER, toY AS INTEGER, Colour AS INTEGER)
DECLARE SUB neoDrawLine (Layer AS INTEGER, StartX AS INTEGER, StartY AS INTEGER, EndX AS INTEGER, EndY AS INTEGER, Colour AS INTEGER)
DECLARE SUB neoDrawLineGouraud (Layer AS INTEGER, StartX AS INTEGER, StartY AS INTEGER, EndX AS INTEGER, EndY AS INTEGER, StartCol AS INTEGER, EndCol AS INTEGER)
DECLARE SUB neoDrawBox (Layer AS INTEGER, StartX AS INTEGER, StartY AS INTEGER, EndX AS INTEGER, EndY AS INTEGER, Colour AS INTEGER)
DECLARE SUB neoDrawBoxF (Layer AS INTEGER, StartX AS INTEGER, StartY AS INTEGER, EndX AS INTEGER, EndY AS INTEGER, Colour AS INTEGER)
DECLARE SUB neoDrawBoxTrans (Layer AS INTEGER, StartX AS INTEGER, StartY AS INTEGER, EndX AS INTEGER, EndY AS INTEGER, Colour AS INTEGER, StdPal AS STRING)
DECLARE SUB neoDrawCircle (Layer AS INTEGER, MiddleX AS INTEGER, MiddleY AS INTEGER, Radius AS INTEGER, Colour AS INTEGER)
DECLARE SUB neoDrawCircleF (Layer AS INTEGER, MiddleX AS INTEGER, MiddleY AS INTEGER, Radius AS INTEGER, Colour AS INTEGER)
DECLARE SUB neoDrawEllipse (Layer AS INTEGER, MiddleX AS INTEGER, MiddleY AS INTEGER, XRadius AS INTEGER, YRadius AS INTEGER, Colour AS INTEGER)
DECLARE SUB neoDrawEllipseF (Layer AS INTEGER, MiddleX AS INTEGER, MiddleY AS INTEGER, XRadius AS INTEGER, YRadius AS INTEGER, Colour AS INTEGER)
DECLARE SUB neoDrawPolygon (Layer AS INTEGER, PolyArray() AS ANY, Colour AS INTEGER)
DECLARE SUB neoDrawPolygonGouraud (Layer AS INTEGER, PolyArray() AS ANY)
DECLARE SUB neoDrawHLine (Layer AS INTEGER, OnY AS INTEGER, Colour AS INTEGER)
DECLARE SUB neoDrawVLine (Layer AS INTEGER, OnX AS INTEGER, Colour AS INTEGER)


TYPE PolyStruct
        X AS INTEGER
        Y AS INTEGER
        C AS INTEGER
END TYPE



'
' NeoLib - Palette Module
'
' Features:
'  27 subs
'  3 functions
' For a total of: 30 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'

DECLARE FUNCTION neoPalGetRelativeCol& (ColorNumber AS INTEGER)
DECLARE FUNCTION neoPalSearch% (Red AS INTEGER, Green AS INTEGER, Blue AS INTEGER)
DECLARE FUNCTION neoPalSearchIn% (PalString AS STRING, Red AS INTEGER, Green AS INTEGER, Blue AS INTEGER)

DECLARE SUB neoPalSetCol (ColorNumber AS INTEGER, Red AS INTEGER, Green AS INTEGER, Blue AS INTEGER)
DECLARE SUB neoPalGetCol (ColorNumber AS INTEGER, Red AS INTEGER, Green AS INTEGER, Blue AS INTEGER)
DECLARE SUB neoPalOff ()
DECLARE SUB neoPalNegative ()
DECLARE SUB neoPalGrey (Amount AS INTEGER)
DECLARE SUB neoPalGet (PalString AS STRING)
DECLARE SUB neoPalSet (PalString AS STRING)
DECLARE SUB neoPalStringOff (PalString AS STRING)
DECLARE SUB neoPalStringSetCol (PalString AS STRING, ColorNumber AS INTEGER, Red AS INTEGER, Green AS INTEGER, Blue AS INTEGER)
DECLARE SUB neoPalStringGetCol (PalString AS STRING, ColorNumber AS INTEGER, Red AS INTEGER, Green AS INTEGER, Blue AS INTEGER)
DECLARE SUB neoPalSave (PalString AS STRING, Filename AS STRING)
DECLARE SUB neoPalLoad (PalString AS STRING, Filename AS STRING)
DECLARE SUB neoPalLoadPP256Pal (PalString AS STRING, Filename AS STRING)
DECLARE SUB neoPalSavePP256Pal (PalString AS STRING, Filename AS STRING)
DECLARE SUB neoPalFadeTo (Red AS INTEGER, Green AS INTEGER, Blue AS INTEGER)
DECLARE SUB neoPalFadeStepTo (Red AS INTEGER, Green AS INTEGER, Blue AS INTEGER)
DECLARE SUB neoPalFadeIn (PalString AS STRING)
DECLARE SUB neoPalFadeStepIn (PalString AS STRING)
DECLARE SUB neoPalFadeX (BeginCol AS INTEGER, EndCol AS INTEGER, Red AS INTEGER, Green AS INTEGER, Blue AS INTEGER)
DECLARE SUB neoPalFadeStepX (BeginCol AS INTEGER, EndCol AS INTEGER, Red AS INTEGER, Green AS INTEGER, Blue AS INTEGER)
DECLARE SUB neoPalFadePalX (PalString AS STRING, BeginCol AS INTEGER, EndCol AS INTEGER)
DECLARE SUB neoPalFadePalStepX (PalString AS STRING, BeginCol AS INTEGER, EndCol AS INTEGER)
DECLARE SUB neoPalRotateFull (Direction AS INTEGER)
DECLARE SUB neoPalRotatePart (Direction AS INTEGER, BeginCol AS INTEGER, EndCol AS INTEGER)
DECLARE SUB neoPalGradient (StartCol AS INTEGER, StartR AS INTEGER, StartG AS INTEGER, StartB AS INTEGER, EndCol AS INTEGER, EndR AS INTEGER, EndG AS INTEGER, EndB AS INTEGER)
DECLARE SUB neoPalExtractFromBMP (Filename AS STRING, PalString AS STRING)
DECLARE SUB neoPalOldSkool ()

CONST LEFT = -1, RIGHT = 1


'
' NeoLib - Keyboard Module
'
' Features:
'  9 subs
'  1 functions
' For a total of: 10 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'

DECLARE FUNCTION neoKeybInkeyScan% ()

DECLARE SUB neoKeybGetShift (LeftShift AS INTEGER, RightShift AS INTEGER, Alt AS INTEGER, Control AS INTEGER)
DECLARE SUB neoKeybGetShiftEnhanced (LeftControl AS INTEGER, RightControl AS INTEGER, LeftAlt AS INTEGER, RightAlt AS INTEGER, SysReq AS INTEGER)
DECLARE SUB neoKeybGetLeds (NumLock AS INTEGER, CapsLock AS INTEGER, ScrollLock AS INTEGER)
DECLARE SUB neoKeybSetLeds (NumLock AS INTEGER, CapsLock AS INTEGER, ScrollLock AS INTEGER)
DECLARE SUB neoKeybOff ()
DECLARE SUB neoKeybOn ()
DECLARE SUB neoKeybSetSpeed (TypemativDelay AS INTEGER, TypematicRate AS SINGLE)
DECLARE SUB neoKeybWaitKey ()
DECLARE SUB neoKeybSetKey (ScanCode AS INTEGER, ASCIIcode AS INTEGER)



'
' NeoLib - Mouse Module
'
' Features:
'  6 subs
'  7 functions
' For a total of: 13 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'

DECLARE FUNCTION neoMouseInit% ()
DECLARE FUNCTION neoMouseGetButtons% ()
DECLARE FUNCTION neoMouseX% ()
DECLARE FUNCTION neoMouseY% ()
DECLARE FUNCTION neoMouseLB% ()
DECLARE FUNCTION neoMouseRB% ()
DECLARE FUNCTION neoMouseMB% ()

DECLARE SUB neoMouseShow ()
DECLARE SUB neoMouseHide ()
DECLARE SUB neoMouseSetPos (NewX AS INTEGER, NewY AS INTEGER)
DECLARE SUB neoMouseSetRange (MinX AS INTEGER, MinY AS INTEGER, MaxX AS INTEGER, MaxY AS INTEGER)
DECLARE SUB neoMouseSetShape (NewShape AS STRING, HotX AS INTEGER, HotY AS INTEGER)
DECLARE SUB neoMouseSetSensitivity (Xsens AS INTEGER, Ysens AS INTEGER)


'
' NeoLib - Cdrom Module
'
' Features:
'  14 (17) subs
'  10 functions
' For a total of: 24 (27) routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'
' Part is sample code by Plasma, adapted and recoded by Neo Deus Ex Machina
' Special thanks and credits to Plasma (Tha Pirate)
'

DECLARE FUNCTION neoCdromInit% ()
DECLARE FUNCTION neoCdromGetDriveLetters$ ()
DECLARE FUNCTION neoCdromDriveExist% (DriveLetter AS STRING)
DECLARE FUNCTION neoCdromGetVersion$ ()
DECLARE FUNCTION neoCdromChanged% (DriveLetter AS STRING)
DECLARE FUNCTION neoCdromIsError% ()
DECLARE FUNCTION neoCdromGetErrorMsg$ ()
DECLARE FUNCTION neoCdromSize& (DriveLetter AS STRING)
DECLARE FUNCTION neoCdromRB2HSG& (Minutes AS INTEGER, Seconds AS INTEGER, Frames AS INTEGER)
DECLARE FUNCTION neoCdromHeadPosition& (DriveLetter AS STRING)

DECLARE SUB neoCdromHSG2RB (Sectors AS LONG, Minutes AS INTEGER, Seconds AS INTEGER, Frames AS INTEGER)
DECLARE SUB neoCdromRead (DriveLetter AS STRING, StartSector AS LONG, NumSectors AS INTEGER, Buffer AS STRING)
DECLARE SUB neoCdromWrite (DriveLetter AS STRING, StartSector AS LONG, NumSectors AS INTEGER, Buffer AS STRING)
DECLARE SUB neoCdromClose (DriveLetter AS STRING)
DECLARE SUB neoCdromOpen (DriveLetter AS STRING)
DECLARE SUB neoCdromLock (DriveLetter AS STRING)
DECLARE SUB neoCdromUnlock (DriveLetter AS STRING)
DECLARE SUB neoCdromGetInfo (DriveLetter AS STRING, BitFlags AS LONG)
DECLARE SUB neoCdromDiskInfo (DriveLetter AS STRING, FirstTrack AS INTEGER, LastTrack AS INTEGER)
DECLARE SUB neoCdromTrackInfo (DriveLetter AS STRING, TrackNumber AS INTEGER, StartSector AS LONG, TrackType AS INTEGER)
DECLARE SUB neoCdromPlay (DriveLetter AS STRING, TrackNumber AS INTEGER, StartSector AS LONG, NumSectors AS LONG)
DECLARE SUB neoCdromResume (DriveLetter AS STRING)
DECLARE SUB neoCdromStop (DriveLetter AS STRING)
DECLARE SUB neoCdromPlayRaw (DriveLetter AS STRING, StartSector AS LONG, NumSectors AS LONG)

'internal routines (undocumented!!!)
DECLARE SUB neoCdromDoCall (Code AS INTEGER, Info AS STRING, DriveLetter AS STRING)
DECLARE SUB neoCdromOutIOCTL (DataString AS STRING, DriveLetter AS STRING)
DECLARE SUB neoCdromInIOCTL (DataString AS STRING, DriveLetter AS STRING)

CONST DAT = 0
CONST CDA = -1


'
' NeoLib - Sprite Module
'
' Features:
'  13 subs
'  3 functions
' For a total of: 16 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'

DECLARE FUNCTION neoSpriteSize% (StartX AS INTEGER, StartY AS INTEGER, EndX AS INTEGER, EndY AS INTEGER)
DECLARE FUNCTION neoSpriteCollide% (X1 AS INTEGER, Y1 AS INTEGER, BufferSeg1 AS INTEGER, BufferOff1 AS INTEGER, X2 AS INTEGER, Y2 AS INTEGER, BufferSeg2 AS INTEGER, BufferOff2 AS INTEGER, TransCol AS INTEGER)
DECLARE FUNCTION neoSpriteCollideOnLayer% (Layer AS INTEGER, X1 AS INTEGER, Y1 AS INTEGER, BufferSeg AS INTEGER, BufferOff AS INTEGER, TransCol AS INTEGER)

DECLARE SUB neoSpriteInitLayers ()
DECLARE SUB neoSpriteSetClipBox (X1 AS INTEGER, Y1 AS INTEGER, X2 AS INTEGER, Y2 AS INTEGER)
DECLARE SUB neoSpriteGet (Layer AS INTEGER, StartX AS INTEGER, StartY AS INTEGER, EndX AS INTEGER, EndY AS INTEGER, BufferSeg AS INTEGER, BufferOff AS INTEGER)
DECLARE SUB neoSpritePut (Layer AS INTEGER, PutX AS INTEGER, PutY AS INTEGER, BufferSeg AS INTEGER, BufferOff AS INTEGER)
DECLARE SUB neoSpritePutTrans (Layer AS INTEGER, PutX AS INTEGER, PutY AS INTEGER, BufferSeg AS INTEGER, BufferOff AS INTEGER, TransCol AS INTEGER)
DECLARE SUB neoSpritePutColor (Layer AS INTEGER, PutX AS INTEGER, PutY AS INTEGER, BufferSeg AS INTEGER, BufferOff AS INTEGER, TransCol AS INTEGER, PutColor AS INTEGER)
DECLARE SUB neoSpritePutRotate (Layer AS INTEGER, PutX AS INTEGER, PutY AS INTEGER, BufferSeg AS INTEGER, BufferOff AS INTEGER, TransCol AS INTEGER, Angle AS INTEGER)
DECLARE SUB neoSpritePutBlend (Layer AS INTEGER, PutX AS INTEGER, PutY AS INTEGER, BufferSeg AS INTEGER, BufferOff AS INTEGER, TransCol AS INTEGER, StdPal AS STRING)
DECLARE SUB neoSpritePutForward (Layer AS INTEGER, PutX AS INTEGER, PutY AS INTEGER, BufferSeg AS INTEGER, BufferOff AS INTEGER, TransCol AS INTEGER, CheckCol AS INTEGER)
DECLARE SUB neoSpritePutBit (Layer AS INTEGER, PutX AS INTEGER, PutY AS INTEGER, BufferSeg AS INTEGER, BufferOff AS INTEGER, TransCol AS INTEGER, BitMode AS INTEGER)
DECLARE SUB neoSpriteMirror (BufferSeg AS INTEGER, BufferOff AS INTEGER, HorVerFlags AS INTEGER)
DECLARE SUB neoSpriteScale (SpriteArray() AS INTEGER, ZoomFactor AS SINGLE)
DECLARE SUB neoSpriteLighting (BufferSeg AS INTEGER, BufferOff AS INTEGER, LightFactor AS INTEGER, StdPal AS STRING)

CONST XORBITS = 1, ORBITS = 2, ANDBITS = 4



'
' NeoLib - Long FileName Module
'
' Features:
'  6 subs
'  5 functions
' For a total of: 11 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'
' Warning! Requires Windows active to use
'

DECLARE FUNCTION neoLFNgetCurrDir$ ()
DECLARE FUNCTION neoLFNgetFullPath$(FileName AS STRING)
DECLARE FUNCTION neoLFNgetShortPath$(FileName AS STRING)
DECLARE FUNCTION neoLFNshortFileName$(LongFileName AS STRING)
DECLARE FUNCTION neoLFNgetFileSystem$(DriveLetter AS STRING)

DECLARE SUB neoLFNmakeDir(DirName AS STRING)
DECLARE SUB neoLFNremoveDir(DirName AS STRING)
DECLARE SUB neoLFNchangeDir(DirName AS STRING)
DECLARE SUB neoLFNrenameDir(DirName AS STRING, NewDirName AS STRING)
DECLARE SUB neoLFNdeleteFile(FileName AS STRING)
DECLARE SUB neoLFNrenameFile(FileName AS STRING, NewFileName AS STRING)


'
' NeoLib - DOS Module
'
' Features:
'  4 subs
'  10 functions
' For a total of: 14 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'

DECLARE FUNCTION neoDOSsearchFile$ (FileMask AS STRING)
DECLARE FUNCTION neoDOSsearchDir$ (DirMask AS STRING)
DECLARE FUNCTION neoDOSgetOpenedDateTime$ (FileHandle AS INTEGER)
DECLARE FUNCTION neoDOSisDir% (FileName AS STRING)
DECLARE FUNCTION neoDOSisFile% (FileName AS STRING)
DECLARE FUNCTION neoDOSgetFileAttributes% (FileName AS STRING)
DECLARE FUNCTION neoDOSgetFullPath$ (FileName AS STRING)
DECLARE FUNCTION neoDOSgetCurrentDrive$ ()
DECLARE FUNCTION neoDOSgetCurrentDir$ ()
DECLARE FUNCTION neoDOSgetTime$ ()

DECLARE SUB neoDOSsearchFileThrough (FileMask AS STRING, Root AS STRING, TempFile AS STRING, FileOpenMode AS INTEGER)
DECLARE SUB neoDOSsetFileAttributes (FileName AS STRING, FileAttributes AS INTEGER)
DECLARE SUB neoDOSdisableDrive (DriveLetter AS STRING)
DECLARE SUB neoDOSenableDrive (DriveLetter AS STRING)

CONST DELETEONEXISTING = 1, APPENDONEXISTING = 2
CONST FILEREADONLY = 1, FILEHIDDEN = 2, FILESYSTEM = 4, FILEVOLUMELABEL = 8, FILEDIRECTORY = 16
CONST FILEARCHIVE = 32, FILESHARABLE = 128


'
' NeoLib - Font Module
'
' Features:
'  11 subs
'  1 functions
' For a total of: 12 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'

DECLARE FUNCTION neoFontLen% (Text AS STRING)

DECLARE SUB neoFontInitLayers ()
DECLARE SUB neoFontPrint (Layer AS INTEGER, Text AS STRING, xPos AS INTEGER, yPos AS INTEGER, Colour AS INTEGER, Italic AS INTEGER)
DECLARE SUB neoFontPrintT (Layer AS INTEGER, Text AS STRING, xPos AS INTEGER, yPos AS INTEGER, Italic AS INTEGER)
DECLARE SUB neoFontPrintG (Layer AS INTEGER, Text AS STRING, xPos AS INTEGER, yPos AS INTEGER, Colour AS INTEGER, Italic AS INTEGER)
DECLARE SUB neoFontPrintB (Layer AS INTEGER, Text AS STRING, xPos AS INTEGER, yPos AS INTEGER, Colour AS INTEGER, Italic AS INTEGER, Textured AS INTEGER, Gradiented AS INTEGER, StdPal AS STRING)
DECLARE SUB neoFontPrintN (Layer AS INTEGER, Text AS STRING, xPos AS INTEGER, yPos AS INTEGER, Italic AS INTEGER, StdPal AS STRING)
DECLARE SUB neoFontPrintS (Layer AS INTEGER, Text AS STRING, xPos AS INTEGER, yPos AS INTEGER, xScale AS INTEGER, yScale AS INTEGER, Colour AS INTEGER, Italic AS INTEGER, Textured AS INTEGER, Gradiented AS INTEGER)
DECLARE SUB neoFontPrintSB (Layer AS INTEGER, Text AS STRING, xPos AS INTEGER, yPos AS INTEGER, xScale AS INTEGER, yScale AS INTEGER, Colour AS INTEGER, Italic AS INTEGER, Textured AS INTEGER, Gradiented AS INTEGER, StdPal AS STRING)
DECLARE SUB neoFontPrintSN (Layer AS INTEGER, Text AS STRING, xPos AS INTEGER, yPos AS INTEGER, xScale AS INTEGER, yScale AS INTEGER, Italic AS INTEGER, StdPal AS STRING)
DECLARE SUB neoFontSetTexture (TexSeg AS INTEGER, TexOff AS INTEGER)
DECLARE SUB neoFontSetClipBox (X1 AS INTEGER, Y1 AS INTEGER, X2 AS INTEGER, Y2 AS INTEGER)



'
' NeoLib - Image Module
'
' Features:
'  5 subs
'  0 functions
' For a total of: 5 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'

DECLARE SUB neoImageLoadPP256Put (Filename AS STRING, Array() AS INTEGER)
DECLARE SUB neoImageLoadBMP (Filename AS STRING, Layer AS INTEGER, X AS INTEGER, Y AS INTEGER, Pal AS STRING)
DECLARE SUB neoImageLoadArrayBMP (Filename AS STRING, Array() AS INTEGER, Pal AS STRING)
DECLARE SUB neoImageSaveBMP (Filename AS STRING, Layer AS INTEGER, X AS INTEGER, Y AS INTEGER, Wid AS INTEGER, Hei AS INTEGER, Pal AS STRING)
DECLARE SUB neoImageSaveArrayBMP (Filename AS STRING, ArraySeg AS INTEGER, ArrayOff AS INTEGER, Pal AS STRING)

'
' NeoLib - Joystick Module
'
' Features:
'  3 subs
'  0 functions
' For a total of: 3 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'
' Special Thanks to the AAP Gamepad Library for QuickBASIC!
' Credits go to Adigun Azikiwe Polack
'

DECLARE FUNCTION neoJoyDetected% ()

DECLARE SUB neoJoyXY (X AS INTEGER, Y AS INTEGER)
DECLARE SUB neoJoyButton (ButtonA AS INTEGER, ButtonB AS INTEGER, ButtonC AS INTEGER, ButtonD AS INTEGER)


DIM SHARED Regs AS RegType
DIM SHARED RegsX AS RegTypeX
'DIM SHARED FFixCode AS STRING
DIM SHARED EMSerror AS INTEGER
DIM SHARED LAYERhandle AS INTEGER
DIM SHARED DRAWhandle AS INTEGER
DIM SHARED ClipBox(4) AS INTEGER
DIM SHARED CdromError AS INTEGER
DIM SHARED SpriteHandle AS INTEGER
DIM SHARED sClipBox(4) AS INTEGER
DIM SHARED FontSeg(2) AS INTEGER
DIM SHARED FontOff(2) AS INTEGER
DIM SHARED FontHandle AS INTEGER
DIM SHARED fClipBox(4) AS INTEGER
DIM SHARED FontTexture(32) AS INTEGER
