' Program Name : INSSWP.BAS
' Description  : A program that changes the instruments of a MKJ song file.
' Look at This : You don't have to look at any of this because you most
'                likely will never use the code in this program.

' Written in 1996 by Molnar \ Kucalaba Productions


DECLARE SUB MakeJamFile (File$)
DECLARE FUNCTION LoadJamFile% (File$)
DECLARE FUNCTION LoadIns% (FileName$)

'$DYNAMIC


' Instrument-type.  For your convenience, use the MKJamz Instrument Creator.
' After all, that's what it's there for.
TYPE InsType
 MMult AS INTEGER     ' Modulator's Multiple
 MLevel AS INTEGER    ' Modulator's Level
 MAttack AS INTEGER   ' Modulator's Attack
 MSustain AS INTEGER  ' Modulator's Sustain
 CMult AS INTEGER     ' Carrier's Multiple
 CLevel AS INTEGER    ' Carrier's Level
 CAttack AS INTEGER   ' Carrier's Attack
 CSustain AS INTEGER  ' Carrier's Sustain
END TYPE


' This template holds the current channel information.
TYPE ChannelType
 Defined AS INTEGER   ' Has the user defined the channel and it's notes? (1 if yes)
 Speed AS SINGLE      ' The duration of each note
 SongPtr AS INTEGER   ' A pointer to the current song position
 PStat AS SINGLE      ' Pause counter 2
 Octave AS INTEGER    ' The Octave of each channel
 WaveForm AS INTEGER  ' The Wave Form of each channel
 Flag AS INTEGER      ' Misc control flag
 Flag2 AS INTEGER     ' Number of times to play song
 IsPlaying AS INTEGER ' Is a note playing (1=yes)
 IsDone AS INTEGER    ' Has the note stopped? (1=yes)
END TYPE


DIM SHARED MaxChannel%, MaxNotes%
DIM SHARED ChannelStat(1 TO 2) AS ChannelType
DIM SHARED SongBuf(1 TO 2) AS INTEGER
DIM SHARED CurrentIns AS InsType
DIM SHARED InsList(1 TO 2) AS STRING
DIM SHARED OriginalFile$

CLS
SCREEN 0
WIDTH 80

COLOR 15
PRINT "                       .MKJ Instrument Swapper v1.0": PRINT
COLOR 14
PRINT "            Please type in the name of the .MKJ file to edit..."
COLOR 15
PRINT
PRINT "File Name : ";
COLOR 10
INPUT "", FileName$

ResCode% = LoadJamFile(FileName$)

IF ResCode% <> 1 THEN
 COLOR 15
 PRINT "Error reading .MKJ file, code : "; ResCode%
 WHILE INKEY$ = "": WEND
 SYSTEM
END IF

OriginalFile$ = FileName$

COLOR 14
PRINT
PRINT "      Type the instrument name as the file name, i.e COOLBASS.INS"
PRINT
COLOR 15
FOR Chan% = 1 TO MaxChannel%
 PRINT "Channel"; Chan%; "Instrument (x if none) : ";
 COLOR 10
 INPUT "", FileName$
 COLOR 15
 IF LTRIM$(RTRIM$(UCASE$(FileName$))) <> "X" THEN
  InsList(Chan%) = FileName$
 ELSE
  InsList(Chan%) = ".SAME"
 END IF
NEXT

COLOR 14
PRINT : PRINT "                      Output file as (i.e. NEW.MKJ) : ": PRINT
COLOR 15
PRINT "New File Name : ";
COLOR 10
INPUT "", NewFile$
CALL MakeJamFile(NewFile$)
COLOR 15
PRINT
PRINT "                 File creation complete, have a nice day."

REM $STATIC
FUNCTION LoadIns% (FileName$)
Free = FREEFILE
OPEN FileName$ FOR BINARY AS #Free
 IF LOF(Free) < 2 THEN
  BEEP
  CLOSE #Free
  KILL FileName$
  LoadIns% = -1
  EXIT FUNCTION
 END IF
 GET #Free, , CurrentIns
CLOSE #Free
END FUNCTION

FUNCTION LoadJamFile% (File$)

OPEN File$ FOR BINARY AS #1

 IF LOF(1) < 2 THEN
  CLOSE #1
  KILL File$
  LoadJamFile% = -1
  EXIT FUNCTION
 END IF

 IF INPUT$(6, #1) <> "MKJamz" THEN
   LoadJamFile% = -2
   EXIT FUNCTION
 END IF

 GET #1, , Version!
 IF Version! > 1.1 THEN
  LoadJamFile% = -3
  EXIT FUNCTION
 END IF

 GET #1, , MaxChannel%

  FOR x% = 1 TO MaxChannel%
    GET #1, , CurrentIns
  NEXT

 GET #1, , MaxNotes%

  REDIM SongBuf(1 TO (MaxChannel% + 1) * MaxNotes%) AS INTEGER
  REDIM ChannelStat(1 TO MaxChannel%) AS ChannelType
  REDIM InsList(1 TO MaxChannel%) AS STRING

  FOR x% = 1 TO MaxChannel%
    GET #1, , ChannelStat(x%).Defined
    ChannelStat(x%).SongPtr = 1
    ChannelStat(x%).Octave = 4
  NEXT


  ' Begin of FAST music loader...load 40,000 bytes of data in no time flat!
  ' Almost like BLOAD/BSAVE but much more flexible.  (If you know what you
  ' are doing.)


  RemBytes& = LOF(1) - SEEK(1)  ' The size, in bytes (not ints) of song data

  BufferSize% = 2000           ' The buffer size to use.

  DEF SEG = VARSEG(SongBuf(1)) ' The segment of the song buffer
  Ptr& = VARPTR(SongBuf(1))    ' Pointer to the song buffer

  LeftBytes& = RemBytes& MOD BufferSize% ' The amount of left over bytes

  IF (LeftBytes& < RemBytes&) THEN
    FOR QuickLoad% = 1 TO (RemBytes& - LeftBytes&) / BufferSize%
       Buffer$ = INPUT$(BufferSize%, #1) ' Load all the data into buffer
         FOR x% = 1 TO LEN(Buffer$)
            POKE Ptr&, ASC(MID$(Buffer$, x%, 1))
            Ptr& = Ptr& + 1
         NEXT
       RemBytes& = RemBytes& - BufferSize%
    NEXT
  END IF

  IF (LeftBytes& > 0) THEN
    Buffer$ = INPUT$(LeftBytes&, #1)
     FOR x% = 1 TO LEN(Buffer$)
        POKE Ptr&, ASC(MID$(Buffer$, x%, 1))
        Ptr& = Ptr& + 1
     NEXT
   END IF

  DEF SEG

CLOSE #1

LoadJamFile% = 1

END FUNCTION

SUB MakeJamFile (File$)

OPEN File$ FOR BINARY AS #1
 IF LOF(1) < 2 THEN
   CLOSE
   KILL File$
 END IF
CLOSE #1

Id$ = "MKJamz"

StupidQB% = MaxChannel%
StupidQB2% = MaxNotes%
Version! = 1.1

OPEN File$ FOR BINARY AS #1
OPEN OriginalFile$ FOR BINARY AS #2
 PUT #1, , Id$
 PUT #1, , Version!
 PUT #1, , StupidQB%   ' # of Channels

  FOR x% = 1 TO MaxChannel%
   IF InsList(x%) <> ".SAME" THEN
    ResCode% = LoadIns(InsList(x%))
   ELSEIF InsList(x%) = ".SAME" OR ResCode% = -1 THEN
    IOPos& = SEEK(1)        ' Return the same instrument if they typed x
    SEEK #2, IOPos&         ' using super tricky method.
    GET #2, , CurrentIns
   END IF
   PUT #1, , CurrentIns      ' Intrument data
  NEXT

 PUT #1, , StupidQB2%  ' Notes number

  FOR x% = 1 TO MaxChannel%
   PUT #1, , ChannelStat(x%).Defined  ' Channel definitions
  NEXT

  FOR x% = 1 TO UBOUND(SongBuf)
     PUT #1, , SongBuf(x%)        ' Song data
  NEXT

CLOSE #1
END SUB

